/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.ticks;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.ticks.NextTickListEntry;
import net.minecraft.world.ticks.SerializableTickContainer;
import net.minecraft.world.ticks.TickContainerAccess;
import net.minecraft.world.ticks.TickListChunk;

public class LevelChunkTicks<T>
implements SerializableTickContainer<T>,
TickContainerAccess<T> {
    private final Queue<NextTickListEntry<T>> tickQueue = new PriorityQueue(NextTickListEntry.DRAIN_ORDER);
    @Nullable
    private List<TickListChunk<T>> pendingTicks;
    private final Set<NextTickListEntry<?>> ticksPerPosition = new ObjectOpenCustomHashSet(NextTickListEntry.UNIQUE_TICK_HASH);
    @Nullable
    private BiConsumer<LevelChunkTicks<T>, NextTickListEntry<T>> onTickAdded;

    public LevelChunkTicks() {
    }

    public LevelChunkTicks(List<TickListChunk<T>> var0) {
        this.pendingTicks = var0;
        for (TickListChunk<T> var2 : var0) {
            this.ticksPerPosition.add(NextTickListEntry.probe(var2.type(), var2.pos()));
        }
    }

    public void setOnTickAdded(@Nullable BiConsumer<LevelChunkTicks<T>, NextTickListEntry<T>> var0) {
        this.onTickAdded = var0;
    }

    @Nullable
    public NextTickListEntry<T> peek() {
        return this.tickQueue.peek();
    }

    @Nullable
    public NextTickListEntry<T> poll() {
        NextTickListEntry<T> var0 = this.tickQueue.poll();
        if (var0 != null) {
            this.ticksPerPosition.remove(var0);
        }
        return var0;
    }

    @Override
    public void schedule(NextTickListEntry<T> var0) {
        if (this.ticksPerPosition.add(var0)) {
            this.scheduleUnchecked(var0);
        }
    }

    private void scheduleUnchecked(NextTickListEntry<T> var0) {
        this.tickQueue.add(var0);
        if (this.onTickAdded != null) {
            this.onTickAdded.accept(this, var0);
        }
    }

    @Override
    public boolean hasScheduledTick(BlockPosition var0, T var1) {
        return this.ticksPerPosition.contains(NextTickListEntry.probe(var1, var0));
    }

    public void removeIf(Predicate<NextTickListEntry<T>> var0) {
        Iterator var1 = this.tickQueue.iterator();
        while (var1.hasNext()) {
            NextTickListEntry var2 = (NextTickListEntry)var1.next();
            if (!var0.test(var2)) continue;
            var1.remove();
            this.ticksPerPosition.remove(var2);
        }
    }

    public Stream<NextTickListEntry<T>> getAll() {
        return this.tickQueue.stream();
    }

    @Override
    public int count() {
        return this.tickQueue.size() + (this.pendingTicks != null ? this.pendingTicks.size() : 0);
    }

    @Override
    public NBTTagList save(long var0, Function<T, String> var2) {
        NBTTagList var3 = new NBTTagList();
        if (this.pendingTicks != null) {
            for (TickListChunk<Object> tickListChunk : this.pendingTicks) {
                var3.add(tickListChunk.save(var2));
            }
        }
        for (NextTickListEntry nextTickListEntry : this.tickQueue) {
            var3.add(TickListChunk.saveTick(nextTickListEntry, var2, var0));
        }
        return var3;
    }

    public void unpack(long var0) {
        if (this.pendingTicks != null) {
            int var2 = -this.pendingTicks.size();
            for (TickListChunk<T> var4 : this.pendingTicks) {
                this.scheduleUnchecked(var4.unpack(var0, var2++));
            }
        }
        this.pendingTicks = null;
    }

    public static <T> LevelChunkTicks<T> load(NBTTagList var0, Function<String, Optional<T>> var1, ChunkCoordIntPair var2) {
        ImmutableList.Builder var3 = ImmutableList.builder();
        TickListChunk.loadTickList(var0, var1, var2, arg_0 -> ((ImmutableList.Builder)var3).add(arg_0));
        return new LevelChunkTicks<T>(var3.build());
    }

    @Override
    public /* synthetic */ NBTBase save(long l2, Function function) {
        return this.save(l2, function);
    }
}

