/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.ticks;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.ticks.NextTickListEntry;
import net.minecraft.world.ticks.SerializableTickContainer;
import net.minecraft.world.ticks.TickContainerAccess;
import net.minecraft.world.ticks.TickListChunk;

public class ProtoChunkTickList<T>
implements SerializableTickContainer<T>,
TickContainerAccess<T> {
    private final List<TickListChunk<T>> ticks = Lists.newArrayList();
    private final Set<TickListChunk<?>> ticksPerPosition = new ObjectOpenCustomHashSet(TickListChunk.UNIQUE_TICK_HASH);

    @Override
    public void schedule(NextTickListEntry<T> var0) {
        TickListChunk<T> var1 = new TickListChunk<T>(var0.type(), var0.pos(), 0, var0.priority());
        this.schedule(var1);
    }

    @Override
    private void schedule(TickListChunk<T> var0) {
        if (this.ticksPerPosition.add(var0)) {
            this.ticks.add(var0);
        }
    }

    @Override
    public boolean hasScheduledTick(BlockPosition var0, T var1) {
        return this.ticksPerPosition.contains(TickListChunk.probe(var1, var0));
    }

    @Override
    public int count() {
        return this.ticks.size();
    }

    @Override
    public NBTBase save(long var0, Function<T, String> var2) {
        NBTTagList var3 = new NBTTagList();
        for (TickListChunk<T> var5 : this.ticks) {
            var3.add(var5.save(var2));
        }
        return var3;
    }

    public List<TickListChunk<T>> scheduledTicks() {
        return List.copyOf(this.ticks);
    }

    public static <T> ProtoChunkTickList<T> load(NBTTagList var0, Function<String, Optional<T>> var1, ChunkCoordIntPair var2) {
        ProtoChunkTickList<T> var3 = new ProtoChunkTickList<T>();
        TickListChunk.loadTickList(var0, var1, var2, var3::schedule);
        return var3;
    }
}

