/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1;

import com.google.common.base.Preconditions;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.level.material.FluidType;
import org.bukkit.Fluid;
import org.bukkit.Registry;
import org.bukkit.craftbukkit.v1_21_R1.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftNamespacedKey;

public class CraftFluid {
    public static Fluid minecraftToBukkit(FluidType minecraft) {
        Preconditions.checkArgument((minecraft != null ? 1 : 0) != 0);
        IRegistry registry = CraftRegistry.getMinecraftRegistry(Registries.FLUID);
        Fluid bukkit = (Fluid)Registry.FLUID.get(CraftNamespacedKey.fromMinecraft(registry.getResourceKey(minecraft).orElseThrow().location()));
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return bukkit;
    }

    public static FluidType bukkitToMinecraft(Fluid bukkit) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return (FluidType)CraftRegistry.getMinecraftRegistry(Registries.FLUID).getOptional(CraftNamespacedKey.toMinecraft(bukkit.getKey())).orElseThrow();
    }
}

