/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.entity.raid.EntityRaider;
import org.bukkit.Location;
import org.bukkit.Raid;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftLocation;
import org.bukkit.entity.Raider;

public final class CraftRaid
implements Raid {
    private final net.minecraft.world.entity.raid.Raid handle;

    public CraftRaid(net.minecraft.world.entity.raid.Raid handle) {
        this.handle = handle;
    }

    public boolean isStarted() {
        return this.handle.isStarted();
    }

    public long getActiveTicks() {
        return this.handle.ticksActive;
    }

    public int getBadOmenLevel() {
        return this.handle.raidOmenLevel;
    }

    public void setBadOmenLevel(int badOmenLevel) {
        int max = this.handle.getMaxRaidOmenLevel();
        Preconditions.checkArgument((0 <= badOmenLevel && badOmenLevel <= max ? 1 : 0) != 0, (String)"Bad Omen level must be between 0 and %s", (int)max);
        this.handle.raidOmenLevel = badOmenLevel;
    }

    public Location getLocation() {
        BlockPosition pos = this.handle.getCenter();
        net.minecraft.world.level.World world = this.handle.getLevel();
        return CraftLocation.toBukkit(pos, (World)world.getWorld());
    }

    public Raid.RaidStatus getStatus() {
        if (this.handle.isStopped()) {
            return Raid.RaidStatus.STOPPED;
        }
        if (this.handle.isVictory()) {
            return Raid.RaidStatus.VICTORY;
        }
        if (this.handle.isLoss()) {
            return Raid.RaidStatus.LOSS;
        }
        return Raid.RaidStatus.ONGOING;
    }

    public int getSpawnedGroups() {
        return this.handle.getGroupsSpawned();
    }

    public int getTotalGroups() {
        return this.handle.numGroups + (this.handle.raidOmenLevel > 1 ? 1 : 0);
    }

    public int getTotalWaves() {
        return this.handle.numGroups;
    }

    public float getTotalHealth() {
        return this.handle.getHealthOfLivingRaiders();
    }

    public Set<UUID> getHeroes() {
        return Collections.unmodifiableSet(this.handle.heroesOfTheVillage);
    }

    public List<Raider> getRaiders() {
        return (List)this.handle.getRaiders().stream().map(new Function<EntityRaider, Raider>(this){

            @Override
            public Raider apply(EntityRaider entityRaider) {
                return (Raider)entityRaider.getBukkitEntity();
            }
        }).collect(ImmutableList.toImmutableList());
    }

    public net.minecraft.world.entity.raid.Raid getHandle() {
        return this.handle;
    }
}

