/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.entity.animal.CatVariant;
import net.minecraft.world.entity.animal.FrogVariant;
import net.minecraft.world.entity.animal.WolfVariant;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.item.Instrument;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimPattern;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.EnumBannerPatternType;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.saveddata.maps.MapDecorationType;
import org.bukkit.GameEvent;
import org.bukkit.JukeboxSong;
import org.bukkit.Keyed;
import org.bukkit.MusicInstrument;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Registry;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Biome;
import org.bukkit.block.BlockType;
import org.bukkit.block.banner.PatternType;
import org.bukkit.craftbukkit.v1_21_R1.CraftGameEvent;
import org.bukkit.craftbukkit.v1_21_R1.CraftJukeboxSong;
import org.bukkit.craftbukkit.v1_21_R1.CraftMusicInstrument;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlockType;
import org.bukkit.craftbukkit.v1_21_R1.block.banner.CraftPatternType;
import org.bukkit.craftbukkit.v1_21_R1.damage.CraftDamageType;
import org.bukkit.craftbukkit.v1_21_R1.enchantments.CraftEnchantment;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftCat;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftFrog;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftVillager;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftWolf;
import org.bukkit.craftbukkit.v1_21_R1.generator.structure.CraftStructure;
import org.bukkit.craftbukkit.v1_21_R1.generator.structure.CraftStructureType;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemType;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftMenuType;
import org.bukkit.craftbukkit.v1_21_R1.inventory.trim.CraftTrimMaterial;
import org.bukkit.craftbukkit.v1_21_R1.inventory.trim.CraftTrimPattern;
import org.bukkit.craftbukkit.v1_21_R1.legacy.FieldRename;
import org.bukkit.craftbukkit.v1_21_R1.map.CraftMapCursor;
import org.bukkit.craftbukkit.v1_21_R1.potion.CraftPotionEffectType;
import org.bukkit.craftbukkit.v1_21_R1.util.ApiVersion;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftNamespacedKey;
import org.bukkit.craftbukkit.v1_21_R1.util.Handleable;
import org.bukkit.damage.DamageType;
import org.bukkit.entity.Cat;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Frog;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Wolf;
import org.bukkit.generator.structure.Structure;
import org.bukkit.inventory.ItemType;
import org.bukkit.inventory.MenuType;
import org.bukkit.map.MapCursor;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;

public class CraftRegistry<B extends Keyed, M>
implements Registry<B> {
    private static IRegistryCustom registry;
    private final Class<? super B> bukkitClass;
    private final Map<NamespacedKey, B> cache = new HashMap<NamespacedKey, B>();
    private final IRegistry<M> minecraftRegistry;
    private final BiFunction<NamespacedKey, M, B> minecraftToBukkit;
    private final BiFunction<NamespacedKey, ApiVersion, NamespacedKey> updater;
    private boolean init;

    public static void setMinecraftRegistry(IRegistryCustom registry) {
        Preconditions.checkState((CraftRegistry.registry == null ? 1 : 0) != 0, (Object)"Registry already set");
        CraftRegistry.registry = registry;
    }

    public static IRegistryCustom getMinecraftRegistry() {
        return registry;
    }

    public static <E> IRegistry<E> getMinecraftRegistry(ResourceKey<IRegistry<E>> key) {
        return CraftRegistry.getMinecraftRegistry().registryOrThrow(key);
    }

    public static <B extends Keyed, M> B minecraftToBukkit(M minecraft, ResourceKey<IRegistry<M>> registryKey, Registry<B> bukkitRegistry) {
        Preconditions.checkArgument((minecraft != null ? 1 : 0) != 0);
        IRegistry registry = CraftRegistry.getMinecraftRegistry(registryKey);
        Keyed bukkit = bukkitRegistry.get(CraftNamespacedKey.fromMinecraft(registry.getResourceKey(minecraft).orElseThrow(() -> new IllegalStateException(String.format("Cannot convert '%s' to bukkit representation, since it is not registered.", minecraft))).location()));
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return (B)bukkit;
    }

    public static <B extends Keyed, M> M bukkitToMinecraft(B bukkit) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return ((Handleable)bukkit).getHandle();
    }

    public static <B extends Keyed, M> Holder<M> bukkitToMinecraftHolder(B bukkit, ResourceKey<IRegistry<M>> registryKey) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        IRegistry registry = CraftRegistry.getMinecraftRegistry(registryKey);
        Holder holder = registry.wrapAsHolder(CraftRegistry.bukkitToMinecraft(bukkit));
        if (holder instanceof Holder.c) {
            Holder.c holder2 = (Holder.c)holder;
            return holder2;
        }
        throw new IllegalArgumentException("No Reference holder found for " + String.valueOf(bukkit) + ", this can happen if a plugin creates its own registry entry with out properly registering it.");
    }

    public static <B extends Keyed> Registry<?> createRegistry(Class<? super B> bukkitClass, IRegistryCustom registryHolder) {
        if (bukkitClass == org.bukkit.enchantments.Enchantment.class) {
            return new CraftRegistry<CraftEnchantment, Enchantment>(org.bukkit.enchantments.Enchantment.class, registryHolder.registryOrThrow(Registries.ENCHANTMENT), CraftEnchantment::new, FieldRename.ENCHANTMENT_RENAME);
        }
        if (bukkitClass == GameEvent.class) {
            return new CraftRegistry<CraftGameEvent, net.minecraft.world.level.gameevent.GameEvent>(GameEvent.class, registryHolder.registryOrThrow(Registries.GAME_EVENT), CraftGameEvent::new, FieldRename.NONE);
        }
        if (bukkitClass == MusicInstrument.class) {
            return new CraftRegistry<CraftMusicInstrument, Instrument>(MusicInstrument.class, registryHolder.registryOrThrow(Registries.INSTRUMENT), CraftMusicInstrument::new, FieldRename.NONE);
        }
        if (bukkitClass == MenuType.class) {
            return new CraftRegistry<CraftMenuType, Containers>(MenuType.class, registryHolder.registryOrThrow(Registries.MENU), CraftMenuType::new, FieldRename.NONE);
        }
        if (bukkitClass == PotionEffectType.class) {
            return new CraftRegistry<CraftPotionEffectType, MobEffectList>(PotionEffectType.class, registryHolder.registryOrThrow(Registries.MOB_EFFECT), CraftPotionEffectType::new, FieldRename.NONE);
        }
        if (bukkitClass == Structure.class) {
            return new CraftRegistry<CraftStructure, net.minecraft.world.level.levelgen.structure.Structure>(Structure.class, registryHolder.registryOrThrow(Registries.STRUCTURE), CraftStructure::new, FieldRename.NONE);
        }
        if (bukkitClass == org.bukkit.generator.structure.StructureType.class) {
            return new CraftRegistry<CraftStructureType, StructureType>(org.bukkit.generator.structure.StructureType.class, registryHolder.registryOrThrow(Registries.STRUCTURE_TYPE), CraftStructureType::new, FieldRename.NONE);
        }
        if (bukkitClass == Villager.Type.class) {
            return new CraftRegistry<CraftVillager.CraftType, VillagerType>(Villager.Type.class, registryHolder.registryOrThrow(Registries.VILLAGER_TYPE), CraftVillager.CraftType::new, FieldRename.NONE);
        }
        if (bukkitClass == Villager.Profession.class) {
            return new CraftRegistry<CraftVillager.CraftProfession, VillagerProfession>(Villager.Profession.class, registryHolder.registryOrThrow(Registries.VILLAGER_PROFESSION), CraftVillager.CraftProfession::new, FieldRename.NONE);
        }
        if (bukkitClass == org.bukkit.inventory.meta.trim.TrimMaterial.class) {
            return new CraftRegistry<CraftTrimMaterial, TrimMaterial>(org.bukkit.inventory.meta.trim.TrimMaterial.class, registryHolder.registryOrThrow(Registries.TRIM_MATERIAL), CraftTrimMaterial::new, FieldRename.NONE);
        }
        if (bukkitClass == org.bukkit.inventory.meta.trim.TrimPattern.class) {
            return new CraftRegistry<CraftTrimPattern, TrimPattern>(org.bukkit.inventory.meta.trim.TrimPattern.class, registryHolder.registryOrThrow(Registries.TRIM_PATTERN), CraftTrimPattern::new, FieldRename.NONE);
        }
        if (bukkitClass == DamageType.class) {
            return new CraftRegistry<CraftDamageType, net.minecraft.world.damagesource.DamageType>(DamageType.class, registryHolder.registryOrThrow(Registries.DAMAGE_TYPE), CraftDamageType::new, FieldRename.NONE);
        }
        if (bukkitClass == JukeboxSong.class) {
            return new CraftRegistry<CraftJukeboxSong, net.minecraft.world.item.JukeboxSong>(JukeboxSong.class, registryHolder.registryOrThrow(Registries.JUKEBOX_SONG), CraftJukeboxSong::new, FieldRename.NONE);
        }
        if (bukkitClass == Wolf.Variant.class) {
            return new CraftRegistry<CraftWolf.CraftVariant, WolfVariant>(Wolf.Variant.class, registryHolder.registryOrThrow(Registries.WOLF_VARIANT), CraftWolf.CraftVariant::new, FieldRename.NONE);
        }
        if (bukkitClass == BlockType.class) {
            return new CraftRegistry<CraftBlockType, Block>(BlockType.class, registryHolder.registryOrThrow(Registries.BLOCK), CraftBlockType::new, FieldRename.NONE);
        }
        if (bukkitClass == ItemType.class) {
            return new CraftRegistry<CraftItemType, Item>(ItemType.class, registryHolder.registryOrThrow(Registries.ITEM), CraftItemType::new, FieldRename.NONE);
        }
        if (bukkitClass == Frog.Variant.class) {
            return new CraftRegistry<CraftFrog.CraftVariant, FrogVariant>(Frog.Variant.class, registryHolder.registryOrThrow(Registries.FROG_VARIANT), CraftFrog.CraftVariant::new, FieldRename.NONE);
        }
        if (bukkitClass == Cat.Type.class) {
            return new CraftRegistry<CraftCat.CraftType, CatVariant>(Cat.Type.class, registryHolder.registryOrThrow(Registries.CAT_VARIANT), CraftCat.CraftType::new, FieldRename.NONE);
        }
        if (bukkitClass == MapCursor.Type.class) {
            return new CraftRegistry<CraftMapCursor.CraftType, MapDecorationType>(MapCursor.Type.class, registryHolder.registryOrThrow(Registries.MAP_DECORATION_TYPE), CraftMapCursor.CraftType::new, FieldRename.NONE);
        }
        if (bukkitClass == PatternType.class) {
            return new CraftRegistry<CraftPatternType, EnumBannerPatternType>(PatternType.class, registryHolder.registryOrThrow(Registries.BANNER_PATTERN), CraftPatternType::new, FieldRename.NONE);
        }
        return null;
    }

    public static <B extends Keyed> B get(Registry<B> bukkit, NamespacedKey namespacedKey, ApiVersion apiVersion) {
        if (bukkit instanceof CraftRegistry) {
            CraftRegistry craft = (CraftRegistry)bukkit;
            return craft.get(namespacedKey, apiVersion);
        }
        if (bukkit instanceof Registry.SimpleRegistry) {
            Registry.SimpleRegistry simple = (Registry.SimpleRegistry)bukkit;
            Class bClass = simple.getType();
            if (bClass == Biome.class) {
                return (B)bukkit.get(FieldRename.BIOME_RENAME.apply(namespacedKey, apiVersion));
            }
            if (bClass == EntityType.class) {
                return (B)bukkit.get(FieldRename.ENTITY_TYPE_RENAME.apply(namespacedKey, apiVersion));
            }
            if (bClass == Particle.class) {
                return (B)bukkit.get(FieldRename.PARTICLE_TYPE_RENAME.apply(namespacedKey, apiVersion));
            }
            if (bClass == Attribute.class) {
                return (B)bukkit.get(FieldRename.ATTRIBUTE_RENAME.apply(namespacedKey, apiVersion));
            }
        }
        return (B)bukkit.get(namespacedKey);
    }

    public CraftRegistry(Class<? super B> bukkitClass, IRegistry<M> minecraftRegistry, BiFunction<NamespacedKey, M, B> minecraftToBukkit, BiFunction<NamespacedKey, ApiVersion, NamespacedKey> updater) {
        this.bukkitClass = bukkitClass;
        this.minecraftRegistry = minecraftRegistry;
        this.minecraftToBukkit = minecraftToBukkit;
        this.updater = updater;
    }

    public B get(NamespacedKey namespacedKey, ApiVersion apiVersion) {
        return this.get(this.updater.apply(namespacedKey, apiVersion));
    }

    public B get(NamespacedKey namespacedKey) {
        Keyed cached = (Keyed)this.cache.get(namespacedKey);
        if (cached != null) {
            return (B)cached;
        }
        if (!this.init) {
            this.init = true;
            try {
                Class.forName(this.bukkitClass.getName());
            }
            catch (ClassNotFoundException e2) {
                throw new RuntimeException("Could not load registry class " + String.valueOf(this.bukkitClass), e2);
            }
            return this.get(namespacedKey);
        }
        B bukkit = this.createBukkit(namespacedKey, this.minecraftRegistry.getOptional(CraftNamespacedKey.toMinecraft(namespacedKey)).orElse(null));
        if (bukkit == null) {
            return null;
        }
        this.cache.put(namespacedKey, bukkit);
        return bukkit;
    }

    @NotNull
    public B getOrThrow(@NotNull NamespacedKey namespacedKey) {
        B object = this.get(namespacedKey);
        Preconditions.checkArgument((object != null ? 1 : 0) != 0, (String)"No %s registry entry found for key %s.", this.minecraftRegistry.key(), (Object)namespacedKey);
        return object;
    }

    @NotNull
    public Stream<B> stream() {
        return this.minecraftRegistry.keySet().stream().map(minecraftKey -> this.get(CraftNamespacedKey.fromMinecraft(minecraftKey)));
    }

    public Iterator<B> iterator() {
        return this.stream().iterator();
    }

    public B createBukkit(NamespacedKey namespacedKey, M minecraft) {
        if (minecraft == null) {
            return null;
        }
        return (B)((Keyed)this.minecraftToBukkit.apply(namespacedKey, minecraft));
    }
}

