/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.CallSite;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import jline.console.ConsoleReader;
import net.md_5.bungee.api.chat.BaseComponent;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.commands.CommandDispatcher;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryBlocks;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NbtException;
import net.minecraft.nbt.ReportedNbtException;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ReloadableServerRegistries;
import net.minecraft.server.ServerCommand;
import net.minecraft.server.WorldLoader;
import net.minecraft.server.bossevents.BossBattleCustom;
import net.minecraft.server.bossevents.BossBattleCustomData;
import net.minecraft.server.commands.CommandReload;
import net.minecraft.server.dedicated.DedicatedPlayerList;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.dedicated.DedicatedServerProperties;
import net.minecraft.server.dedicated.DedicatedServerSettings;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.players.GameProfileBanEntry;
import net.minecraft.server.players.JsonListEntry;
import net.minecraft.server.players.OpListEntry;
import net.minecraft.server.players.PlayerList;
import net.minecraft.server.players.WhiteListEntry;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.util.datafix.DataConverterRegistry;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.village.VillageSiege;
import net.minecraft.world.entity.npc.MobSpawnerCat;
import net.minecraft.world.entity.npc.MobSpawnerTrader;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerWorkbench;
import net.minecraft.world.inventory.InventoryCraftResult;
import net.minecraft.world.inventory.InventoryCrafting;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemWorldMap;
import net.minecraft.world.item.crafting.RecipeCrafting;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeRepair;
import net.minecraft.world.item.crafting.Recipes;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.MobSpawner;
import net.minecraft.world.level.WorldSettings;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.MobSpawnerPatrol;
import net.minecraft.world.level.levelgen.MobSpawnerPhantom;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.LevelDataAndDimensions;
import net.minecraft.world.level.storage.WorldDataServer;
import net.minecraft.world.level.storage.WorldInfo;
import net.minecraft.world.level.storage.WorldNBTStorage;
import net.minecraft.world.level.validation.ContentValidationException;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Fluid;
import org.bukkit.GameMode;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Registry;
import org.bukkit.Server;
import org.bukkit.ServerLinks;
import org.bukkit.ServerTickManager;
import org.bukkit.StructureType;
import org.bukkit.Tag;
import org.bukkit.UnsafeValues;
import org.bukkit.Warning;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.WorldCreator;
import org.bukkit.advancement.Advancement;
import org.bukkit.block.data.BlockData;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.boss.KeyedBossBar;
import org.bukkit.command.Command;
import org.bukkit.command.CommandException;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.conversations.Conversable;
import org.bukkit.craftbukkit.Main;
import org.bukkit.craftbukkit.v1_21_R1.CraftLootTable;
import org.bukkit.craftbukkit.v1_21_R1.CraftOfflinePlayer;
import org.bukkit.craftbukkit.v1_21_R1.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R1.CraftServerLinks;
import org.bukkit.craftbukkit.v1_21_R1.CraftServerTickManager;
import org.bukkit.craftbukkit.v1_21_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R1.CraftWorldBorder;
import org.bukkit.craftbukkit.v1_21_R1.ban.CraftIpBanList;
import org.bukkit.craftbukkit.v1_21_R1.ban.CraftProfileBanList;
import org.bukkit.craftbukkit.v1_21_R1.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R1.boss.CraftBossBar;
import org.bukkit.craftbukkit.v1_21_R1.boss.CraftKeyedBossbar;
import org.bukkit.craftbukkit.v1_21_R1.command.BukkitCommandWrapper;
import org.bukkit.craftbukkit.v1_21_R1.command.CraftCommandMap;
import org.bukkit.craftbukkit.v1_21_R1.command.VanillaCommandWrapper;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftEntityFactory;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R1.generator.CraftWorldInfo;
import org.bukkit.craftbukkit.v1_21_R1.generator.OldCraftChunkData;
import org.bukkit.craftbukkit.v1_21_R1.help.SimpleHelpMap;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftBlastingRecipe;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftCampfireRecipe;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftFurnaceRecipe;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemCraftResult;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemFactory;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftMerchantCustom;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftRecipe;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftShapedRecipe;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftShapelessRecipe;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftSmithingTransformRecipe;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftSmithingTrimRecipe;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftSmokingRecipe;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftStonecuttingRecipe;
import org.bukkit.craftbukkit.v1_21_R1.inventory.RecipeIterator;
import org.bukkit.craftbukkit.v1_21_R1.inventory.util.CraftInventoryCreator;
import org.bukkit.craftbukkit.v1_21_R1.map.CraftMapColorCache;
import org.bukkit.craftbukkit.v1_21_R1.map.CraftMapCursor;
import org.bukkit.craftbukkit.v1_21_R1.map.CraftMapView;
import org.bukkit.craftbukkit.v1_21_R1.metadata.EntityMetadataStore;
import org.bukkit.craftbukkit.v1_21_R1.metadata.PlayerMetadataStore;
import org.bukkit.craftbukkit.v1_21_R1.metadata.WorldMetadataStore;
import org.bukkit.craftbukkit.v1_21_R1.packs.CraftDataPackManager;
import org.bukkit.craftbukkit.v1_21_R1.packs.CraftResourcePack;
import org.bukkit.craftbukkit.v1_21_R1.profile.CraftPlayerProfile;
import org.bukkit.craftbukkit.v1_21_R1.scheduler.CraftScheduler;
import org.bukkit.craftbukkit.v1_21_R1.scoreboard.CraftCriteria;
import org.bukkit.craftbukkit.v1_21_R1.scoreboard.CraftScoreboardManager;
import org.bukkit.craftbukkit.v1_21_R1.structure.CraftStructureManager;
import org.bukkit.craftbukkit.v1_21_R1.tag.CraftBlockTag;
import org.bukkit.craftbukkit.v1_21_R1.tag.CraftEntityTag;
import org.bukkit.craftbukkit.v1_21_R1.tag.CraftFluidTag;
import org.bukkit.craftbukkit.v1_21_R1.tag.CraftItemTag;
import org.bukkit.craftbukkit.v1_21_R1.util.ApiVersion;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftIconCache;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftLocation;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftNamespacedKey;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftSpawnCategory;
import org.bukkit.craftbukkit.v1_21_R1.util.DatFileFilter;
import org.bukkit.craftbukkit.v1_21_R1.util.Versioning;
import org.bukkit.craftbukkit.v1_21_R1.util.permissions.CraftDefaultPermissions;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.SpawnCategory;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerChatTabCompleteEvent;
import org.bukkit.event.server.BroadcastMessageEvent;
import org.bukkit.event.server.ServerLoadEvent;
import org.bukkit.event.server.TabCompleteEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.help.HelpMap;
import org.bukkit.inventory.BlastingRecipe;
import org.bukkit.inventory.CampfireRecipe;
import org.bukkit.inventory.ComplexRecipe;
import org.bukkit.inventory.FurnaceRecipe;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemCraftResult;
import org.bukkit.inventory.Merchant;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.SmithingTransformRecipe;
import org.bukkit.inventory.SmithingTrimRecipe;
import org.bukkit.inventory.SmokingRecipe;
import org.bukkit.inventory.StonecuttingRecipe;
import org.bukkit.loot.LootTable;
import org.bukkit.map.MapPalette;
import org.bukkit.map.MapView;
import org.bukkit.packs.DataPackManager;
import org.bukkit.packs.ResourcePack;
import org.bukkit.permissions.Permissible;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginLoadOrder;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.ServicesManager;
import org.bukkit.plugin.SimplePluginManager;
import org.bukkit.plugin.SimpleServicesManager;
import org.bukkit.plugin.java.JavaPluginLoader;
import org.bukkit.plugin.messaging.Messenger;
import org.bukkit.plugin.messaging.StandardMessenger;
import org.bukkit.profile.PlayerProfile;
import org.bukkit.scheduler.BukkitWorker;
import org.bukkit.scoreboard.Criteria;
import org.bukkit.structure.StructureManager;
import org.bukkit.util.StringUtil;
import org.bukkit.util.permissions.DefaultPermissions;
import org.spigotmc.AsyncCatcher;
import org.spigotmc.RestartCommand;
import org.spigotmc.SpigotConfig;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.error.MarkedYAMLException;

public final class CraftServer
implements Server {
    private final String serverName = "CraftBukkit";
    private final String serverVersion;
    private final String bukkitVersion = Versioning.getBukkitVersion();
    private final Logger logger = Logger.getLogger("Minecraft");
    private final ServicesManager servicesManager = new SimpleServicesManager();
    private final CraftScheduler scheduler = new CraftScheduler();
    private final CraftCommandMap commandMap = new CraftCommandMap(this);
    private final SimpleHelpMap helpMap = new SimpleHelpMap(this);
    private final StandardMessenger messenger = new StandardMessenger();
    private final SimplePluginManager pluginManager = new SimplePluginManager((Server)this, (SimpleCommandMap)this.commandMap);
    private final StructureManager structureManager;
    protected final DedicatedServer console;
    protected final DedicatedPlayerList playerList;
    private final Map<String, World> worlds = new LinkedHashMap<String, World>();
    private final Map<Class<?>, Registry<?>> registries = new HashMap();
    private YamlConfiguration configuration;
    private YamlConfiguration commandsConfiguration;
    private final Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor(new LoaderOptions()));
    private final Map<UUID, OfflinePlayer> offlinePlayers = new MapMaker().weakValues().makeMap();
    private final EntityMetadataStore entityMetadata = new EntityMetadataStore();
    private final PlayerMetadataStore playerMetadata = new PlayerMetadataStore();
    private final WorldMetadataStore worldMetadata = new WorldMetadataStore();
    private final Object2IntOpenHashMap<SpawnCategory> spawnCategoryLimit = new Object2IntOpenHashMap();
    private File container;
    private Warning.WarningState warningState = Warning.WarningState.DEFAULT;
    public ApiVersion minimumAPI;
    public CraftScoreboardManager scoreboardManager;
    public CraftDataPackManager dataPackManager;
    private CraftServerTickManager serverTickManager;
    private CraftServerLinks serverLinks;
    public boolean playerCommandState;
    private boolean printSaveWarning;
    private CraftIconCache icon;
    private boolean overrideAllCommandBlockCommands = false;
    public boolean ignoreVanillaPermissions = false;
    private final List<CraftPlayer> playerView;
    public int reloadCount;
    public Set<String> activeCompatibilities = Collections.emptySet();
    private final Server.Spigot spigot = new Server.Spigot(){

        public YamlConfiguration getConfig() {
            return SpigotConfig.config;
        }

        public void restart() {
            RestartCommand.restart();
        }

        public void broadcast(BaseComponent component) {
            for (Player player : CraftServer.this.getOnlinePlayers()) {
                player.spigot().sendMessage(component);
            }
        }

        public void broadcast(BaseComponent ... components) {
            for (Player player : CraftServer.this.getOnlinePlayers()) {
                player.spigot().sendMessage(components);
            }
        }
    };

    public CraftServer(DedicatedServer console, PlayerList playerList) {
        this.console = console;
        this.playerList = (DedicatedPlayerList)playerList;
        this.playerView = Collections.unmodifiableList(Lists.transform(playerList.players, (Function)new Function<EntityPlayer, CraftPlayer>(this){

            public CraftPlayer apply(EntityPlayer player) {
                return player.getBukkitEntity();
            }
        }));
        this.serverVersion = CraftServer.class.getPackage().getImplementationVersion();
        this.structureManager = new CraftStructureManager(console.getStructureManager(), console.registryAccess());
        this.dataPackManager = new CraftDataPackManager(this.getServer().getPackRepository());
        this.serverTickManager = new CraftServerTickManager(console.tickRateManager());
        this.serverLinks = new CraftServerLinks(console);
        Bukkit.setServer((Server)this);
        CraftRegistry.setMinecraftRegistry(console.registryAccess());
        if (!Main.useConsole) {
            this.getLogger().info("Console input is disabled due to --noconsole command argument");
        }
        this.configuration = YamlConfiguration.loadConfiguration((File)this.getConfigFile());
        this.configuration.options().copyDefaults(true);
        this.configuration.setDefaults((Configuration)YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream("configurations/bukkit.yml"), Charsets.UTF_8)));
        ConfigurationSection legacyAlias = null;
        if (!this.configuration.isString("aliases")) {
            legacyAlias = this.configuration.getConfigurationSection("aliases");
            this.configuration.set("aliases", (Object)"now-in-commands.yml");
        }
        this.saveConfig();
        if (this.getCommandsConfigFile().isFile()) {
            legacyAlias = null;
        }
        this.commandsConfiguration = YamlConfiguration.loadConfiguration((File)this.getCommandsConfigFile());
        this.commandsConfiguration.options().copyDefaults(true);
        this.commandsConfiguration.setDefaults((Configuration)YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream("configurations/commands.yml"), Charsets.UTF_8)));
        this.saveCommandsConfig();
        if (legacyAlias != null) {
            ConfigurationSection aliases = this.commandsConfiguration.createSection("aliases");
            for (String key : legacyAlias.getKeys(false)) {
                ArrayList<CallSite> commands = new ArrayList<CallSite>();
                if (legacyAlias.isList(key)) {
                    for (String command : legacyAlias.getStringList(key)) {
                        commands.add((CallSite)((Object)(command + " $1-")));
                    }
                } else {
                    commands.add((CallSite)((Object)(legacyAlias.getString(key) + " $1-")));
                }
                aliases.set(key, commands);
            }
        }
        this.saveCommandsConfig();
        this.overrideAllCommandBlockCommands = this.commandsConfiguration.getStringList("command-block-overrides").contains("*");
        this.ignoreVanillaPermissions = this.commandsConfiguration.getBoolean("ignore-vanilla-permissions");
        this.pluginManager.useTimings(this.configuration.getBoolean("settings.plugin-profiling"));
        this.overrideSpawnLimits();
        console.autosavePeriod = this.configuration.getInt("ticks-per.autosave");
        this.warningState = Warning.WarningState.value((String)this.configuration.getString("settings.deprecated-verbose"));
        TicketType.PLUGIN.timeout = this.configuration.getInt("chunk-gc.period-in-ticks");
        this.minimumAPI = ApiVersion.getOrCreateVersion(this.configuration.getString("settings.minimum-api"));
        this.loadIcon();
        this.loadCompatibilities();
        CraftMagicNumbers.INSTANCE.getCommodore().updateReroute(this.activeCompatibilities::contains);
        if (this.configuration.getBoolean("settings.use-map-color-cache")) {
            MapPalette.setMapColorCache((MapPalette.MapColorCache)new CraftMapColorCache(this.logger));
        }
    }

    public boolean getCommandBlockOverride(String command) {
        return this.overrideAllCommandBlockCommands || this.commandsConfiguration.getStringList("command-block-overrides").contains(command);
    }

    private File getConfigFile() {
        return (File)this.console.options.valueOf("bukkit-settings");
    }

    private File getCommandsConfigFile() {
        return (File)this.console.options.valueOf("commands-settings");
    }

    private void overrideSpawnLimits() {
        for (SpawnCategory spawnCategory : SpawnCategory.values()) {
            if (!CraftSpawnCategory.isValidForLimits(spawnCategory)) continue;
            this.spawnCategoryLimit.put((Object)spawnCategory, this.configuration.getInt(CraftSpawnCategory.getConfigNameSpawnLimit(spawnCategory)));
        }
    }

    private void saveConfig() {
        try {
            this.configuration.save(this.getConfigFile());
        }
        catch (IOException ex) {
            Logger.getLogger(CraftServer.class.getName()).log(Level.SEVERE, "Could not save " + String.valueOf(this.getConfigFile()), ex);
        }
    }

    private void saveCommandsConfig() {
        try {
            this.commandsConfiguration.save(this.getCommandsConfigFile());
        }
        catch (IOException ex) {
            Logger.getLogger(CraftServer.class.getName()).log(Level.SEVERE, "Could not save " + String.valueOf(this.getCommandsConfigFile()), ex);
        }
    }

    private void loadCompatibilities() {
        ConfigurationSection compatibilities = this.configuration.getConfigurationSection("settings.compatibility");
        if (compatibilities == null) {
            this.activeCompatibilities = Collections.emptySet();
            return;
        }
        this.activeCompatibilities = compatibilities.getKeys(false).stream().filter(arg_0 -> ((ConfigurationSection)compatibilities).getBoolean(arg_0)).collect(Collectors.toSet());
        if (!this.activeCompatibilities.isEmpty()) {
            this.logger.info("Using following compatibilities: `" + Joiner.on((String)"`, `").join(this.activeCompatibilities) + "`, this will affect performance and other plugins behavior.");
            this.logger.info("Only use when necessary and prefer updating plugins if possible.");
        }
        if (this.activeCompatibilities.contains("enum-compatibility-mode")) {
            this.getLogger().warning("Loading plugins in enum compatibility mode. This will affect plugin performance. Use only as a transition period or when absolutely necessary.");
        } else if (System.getProperty("RemoveEnumBanner") == null) {
            this.getLogger().info("*** This version of Spigot contains changes to some enums. If you notice that plugins no longer work after updating, please report this to the developers of those plugins first. ***");
            this.getLogger().info("*** If you cannot update those plugins, you can try setting `settings.compatibility.enum-compatibility-mode` to `true` in `bukkit.yml`. ***");
        }
    }

    public void loadPlugins() {
        this.pluginManager.registerInterface(JavaPluginLoader.class);
        File pluginFolder = (File)this.console.options.valueOf("plugins");
        if (pluginFolder.exists()) {
            Plugin[] plugins;
            for (Plugin plugin : plugins = this.pluginManager.loadPlugins(pluginFolder)) {
                try {
                    String message = String.format("Loading %s", plugin.getDescription().getFullName());
                    plugin.getLogger().info(message);
                    plugin.onLoad();
                }
                catch (Throwable ex) {
                    Logger.getLogger(CraftServer.class.getName()).log(Level.SEVERE, ex.getMessage() + " initializing " + plugin.getDescription().getFullName() + " (Is it up to date?)", ex);
                }
            }
        } else {
            pluginFolder.mkdir();
        }
    }

    public void enablePlugins(PluginLoadOrder type) {
        Plugin[] plugins;
        if (type == PluginLoadOrder.STARTUP) {
            this.helpMap.clear();
            this.helpMap.initializeGeneralTopics();
        }
        for (Plugin plugin : plugins = this.pluginManager.getPlugins()) {
            if (plugin.isEnabled() || plugin.getDescription().getLoad() != type) continue;
            this.enablePlugin(plugin);
        }
        if (type == PluginLoadOrder.POSTWORLD) {
            this.setVanillaCommands(true);
            this.commandMap.setFallbackCommands();
            this.setVanillaCommands(false);
            this.commandMap.registerServerAliases();
            DefaultPermissions.registerCorePermissions();
            CraftDefaultPermissions.registerCorePermissions();
            this.loadCustomPermissions();
            this.helpMap.initializeCommands();
            this.syncCommands();
        }
    }

    public void disablePlugins() {
        this.pluginManager.disablePlugins();
    }

    private void setVanillaCommands(boolean first) {
        CommandDispatcher dispatcher = this.console.vanillaCommandDispatcher;
        for (CommandNode cmd : dispatcher.getDispatcher().getRoot().getChildren()) {
            VanillaCommandWrapper wrapper = new VanillaCommandWrapper(dispatcher, cmd);
            if (SpigotConfig.replaceCommands.contains(wrapper.getName())) {
                if (!first) continue;
                this.commandMap.register("minecraft", (Command)wrapper);
                continue;
            }
            if (first) continue;
            this.commandMap.register("minecraft", (Command)wrapper);
        }
    }

    public void syncCommands() {
        CommandDispatcher dispatcher = this.console.resources.managers().commands = new CommandDispatcher();
        for (Map.Entry<String, Command> entry : this.commandMap.getKnownCommands().entrySet()) {
            String label = entry.getKey();
            Command command = entry.getValue();
            if (command instanceof VanillaCommandWrapper) {
                LiteralCommandNode node = (LiteralCommandNode)((VanillaCommandWrapper)command).vanillaCommand;
                if (!node.getLiteral().equals(label)) {
                    LiteralCommandNode clone = new LiteralCommandNode(label, node.getCommand(), node.getRequirement(), node.getRedirect(), node.getRedirectModifier(), node.isFork());
                    for (CommandNode child : node.getChildren()) {
                        clone.addChild(child);
                    }
                    node = clone;
                }
                dispatcher.getDispatcher().getRoot().addChild((CommandNode)node);
                continue;
            }
            new BukkitCommandWrapper(this, entry.getValue()).register(dispatcher.getDispatcher(), label);
        }
        for (EntityPlayer player : this.getHandle().players) {
            dispatcher.sendCommands(player);
        }
    }

    private void enablePlugin(Plugin plugin) {
        try {
            List perms = plugin.getDescription().getPermissions();
            for (Permission perm : perms) {
                try {
                    this.pluginManager.addPermission(perm, false);
                }
                catch (IllegalArgumentException ex) {
                    this.getLogger().log(Level.WARNING, "Plugin " + plugin.getDescription().getFullName() + " tried to register permission '" + perm.getName() + "' but it's already registered", ex);
                }
            }
            this.pluginManager.dirtyPermissibles();
            this.pluginManager.enablePlugin(plugin);
        }
        catch (Throwable ex) {
            Logger.getLogger(CraftServer.class.getName()).log(Level.SEVERE, ex.getMessage() + " loading " + plugin.getDescription().getFullName() + " (Is it up to date?)", ex);
        }
    }

    public String getName() {
        return "CraftBukkit";
    }

    public String getVersion() {
        return this.serverVersion + " (MC: " + this.console.getServerVersion() + ")";
    }

    public String getBukkitVersion() {
        return this.bukkitVersion;
    }

    public List<CraftPlayer> getOnlinePlayers() {
        return this.playerView;
    }

    @Deprecated
    public Player getPlayer(String name) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"name cannot be null");
        Player found = this.getPlayerExact(name);
        if (found != null) {
            return found;
        }
        String lowerName = name.toLowerCase(Locale.ROOT);
        int delta = Integer.MAX_VALUE;
        for (Player player : this.getOnlinePlayers()) {
            if (!player.getName().toLowerCase(Locale.ROOT).startsWith(lowerName)) continue;
            int curDelta = Math.abs(player.getName().length() - lowerName.length());
            if (curDelta < delta) {
                found = player;
                delta = curDelta;
            }
            if (curDelta != 0) continue;
            break;
        }
        return found;
    }

    @Deprecated
    public Player getPlayerExact(String name) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"name cannot be null");
        EntityPlayer player = this.playerList.getPlayerByName(name);
        return player != null ? player.getBukkitEntity() : null;
    }

    public Player getPlayer(UUID id) {
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"UUID id cannot be null");
        EntityPlayer player = this.playerList.getPlayer(id);
        if (player != null) {
            return player.getBukkitEntity();
        }
        return null;
    }

    public int broadcastMessage(String message) {
        return this.broadcast(message, "bukkit.broadcast.user");
    }

    @Deprecated
    public List<Player> matchPlayer(String partialName) {
        Preconditions.checkArgument((partialName != null ? 1 : 0) != 0, (Object)"partialName cannot be null");
        ArrayList<Player> matchedPlayers = new ArrayList<Player>();
        for (Player iterPlayer : this.getOnlinePlayers()) {
            String iterPlayerName = iterPlayer.getName();
            if (partialName.equalsIgnoreCase(iterPlayerName)) {
                matchedPlayers.clear();
                matchedPlayers.add(iterPlayer);
                break;
            }
            if (!iterPlayerName.toLowerCase(Locale.ROOT).contains(partialName.toLowerCase(Locale.ROOT))) continue;
            matchedPlayers.add(iterPlayer);
        }
        return matchedPlayers;
    }

    public int getMaxPlayers() {
        return this.playerList.getMaxPlayers();
    }

    public void setMaxPlayers(int maxPlayers) {
        Preconditions.checkArgument((maxPlayers >= 0 ? 1 : 0) != 0, (Object)"maxPlayers must be >= 0");
        this.playerList.maxPlayers = maxPlayers;
    }

    public int getPort() {
        return this.getServer().getPort();
    }

    public int getViewDistance() {
        return this.getProperties().viewDistance;
    }

    public int getSimulationDistance() {
        return this.getProperties().simulationDistance;
    }

    public String getIp() {
        return this.getServer().getLocalIp();
    }

    public String getWorldType() {
        return this.getProperties().properties.getProperty("level-type");
    }

    public boolean getGenerateStructures() {
        return this.getServer().getWorldData().worldGenOptions().generateStructures();
    }

    public int getMaxWorldSize() {
        return this.getProperties().maxWorldSize;
    }

    public boolean getAllowEnd() {
        return this.configuration.getBoolean("settings.allow-end");
    }

    public boolean getAllowNether() {
        return this.getProperties().allowNether;
    }

    public boolean isLoggingIPs() {
        return this.getServer().logIPs();
    }

    public boolean getWarnOnOverload() {
        return this.configuration.getBoolean("settings.warn-on-overload");
    }

    public boolean getQueryPlugins() {
        return this.configuration.getBoolean("settings.query-plugins");
    }

    public List<String> getInitialEnabledPacks() {
        return Collections.unmodifiableList(this.getProperties().initialDataPackConfiguration.getEnabled());
    }

    public List<String> getInitialDisabledPacks() {
        return Collections.unmodifiableList(this.getProperties().initialDataPackConfiguration.getDisabled());
    }

    public DataPackManager getDataPackManager() {
        return this.dataPackManager;
    }

    public ServerTickManager getServerTickManager() {
        return this.serverTickManager;
    }

    public ResourcePack getServerResourcePack() {
        return this.getServer().getServerResourcePack().map(CraftResourcePack::new).orElse(null);
    }

    public String getResourcePack() {
        return this.getServer().getServerResourcePack().map(MinecraftServer.ServerResourcePackInfo::url).orElse("");
    }

    public String getResourcePackHash() {
        return this.getServer().getServerResourcePack().map(MinecraftServer.ServerResourcePackInfo::hash).orElse("").toUpperCase(Locale.ROOT);
    }

    public String getResourcePackPrompt() {
        return this.getServer().getServerResourcePack().map(MinecraftServer.ServerResourcePackInfo::prompt).map(CraftChatMessage::fromComponent).orElse("");
    }

    public boolean isResourcePackRequired() {
        return this.getServer().isResourcePackRequired();
    }

    public boolean hasWhitelist() {
        return this.getProperties().whiteList.get();
    }

    private DedicatedServerProperties getProperties() {
        return this.console.getProperties();
    }

    public String getUpdateFolder() {
        return this.configuration.getString("settings.update-folder", "update");
    }

    public File getUpdateFolderFile() {
        return new File((File)this.console.options.valueOf("plugins"), this.configuration.getString("settings.update-folder", "update"));
    }

    public long getConnectionThrottle() {
        if (SpigotConfig.bungee) {
            return -1L;
        }
        return this.configuration.getInt("settings.connection-throttle");
    }

    @Deprecated
    public int getTicksPerAnimalSpawns() {
        return this.getTicksPerSpawns(SpawnCategory.ANIMAL);
    }

    @Deprecated
    public int getTicksPerMonsterSpawns() {
        return this.getTicksPerSpawns(SpawnCategory.MONSTER);
    }

    @Deprecated
    public int getTicksPerWaterSpawns() {
        return this.getTicksPerSpawns(SpawnCategory.WATER_ANIMAL);
    }

    @Deprecated
    public int getTicksPerWaterAmbientSpawns() {
        return this.getTicksPerSpawns(SpawnCategory.WATER_AMBIENT);
    }

    @Deprecated
    public int getTicksPerWaterUndergroundCreatureSpawns() {
        return this.getTicksPerSpawns(SpawnCategory.WATER_UNDERGROUND_CREATURE);
    }

    @Deprecated
    public int getTicksPerAmbientSpawns() {
        return this.getTicksPerSpawns(SpawnCategory.AMBIENT);
    }

    public int getTicksPerSpawns(SpawnCategory spawnCategory) {
        Preconditions.checkArgument((spawnCategory != null ? 1 : 0) != 0, (Object)"SpawnCategory cannot be null");
        Preconditions.checkArgument((boolean)CraftSpawnCategory.isValidForLimits(spawnCategory), (String)"SpawnCategory.%s are not supported", (Object)spawnCategory);
        return this.configuration.getInt(CraftSpawnCategory.getConfigNameTicksPerSpawn(spawnCategory));
    }

    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    public CraftScheduler getScheduler() {
        return this.scheduler;
    }

    public ServicesManager getServicesManager() {
        return this.servicesManager;
    }

    public List<World> getWorlds() {
        return new ArrayList<World>(this.worlds.values());
    }

    public DedicatedPlayerList getHandle() {
        return this.playerList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchServerCommand(CommandSender sender, ServerCommand serverCommand) {
        Conversable conversable2;
        if (sender instanceof Conversable && (conversable2 = (Conversable)sender).isConversing()) {
            conversable2.acceptConversationInput(serverCommand.msg);
            return true;
        }
        try {
            this.playerCommandState = true;
            boolean conversable2 = this.dispatchCommand(sender, serverCommand.msg);
            return conversable2;
        }
        catch (Exception ex) {
            this.getLogger().log(Level.WARNING, "Unexpected exception while parsing console command \"" + serverCommand.msg + "\"", ex);
            boolean bl = false;
            return bl;
        }
        finally {
            this.playerCommandState = false;
        }
    }

    public boolean dispatchCommand(CommandSender sender, String commandLine) {
        Preconditions.checkArgument((sender != null ? 1 : 0) != 0, (Object)"sender cannot be null");
        Preconditions.checkArgument((commandLine != null ? 1 : 0) != 0, (Object)"commandLine cannot be null");
        AsyncCatcher.catchOp("command dispatch");
        if (this.commandMap.dispatch(sender, commandLine)) {
            return true;
        }
        if (!SpigotConfig.unknownCommandMessage.isEmpty()) {
            sender.sendMessage(SpigotConfig.unknownCommandMessage);
        }
        return false;
    }

    public void reload() {
        ++this.reloadCount;
        this.configuration = YamlConfiguration.loadConfiguration((File)this.getConfigFile());
        this.commandsConfiguration = YamlConfiguration.loadConfiguration((File)this.getCommandsConfigFile());
        this.console.settings = new DedicatedServerSettings(this.console.options);
        DedicatedServerProperties config = this.console.settings.getProperties();
        this.console.setPvpAllowed(config.pvp);
        this.console.setFlightAllowed(config.allowFlight);
        this.console.setMotd(config.motd);
        this.overrideSpawnLimits();
        this.warningState = Warning.WarningState.value((String)this.configuration.getString("settings.deprecated-verbose"));
        TicketType.PLUGIN.timeout = this.configuration.getInt("chunk-gc.period-in-ticks");
        this.minimumAPI = ApiVersion.getOrCreateVersion(this.configuration.getString("settings.minimum-api"));
        this.printSaveWarning = false;
        this.console.autosavePeriod = this.configuration.getInt("ticks-per.autosave");
        this.loadIcon();
        this.loadCompatibilities();
        CraftMagicNumbers.INSTANCE.getCommodore().updateReroute(this.activeCompatibilities::contains);
        try {
            this.playerList.getIpBans().load();
        }
        catch (IOException ex) {
            this.logger.log(Level.WARNING, "Failed to load banned-ips.json, " + ex.getMessage());
        }
        try {
            this.playerList.getBans().load();
        }
        catch (IOException ex) {
            this.logger.log(Level.WARNING, "Failed to load banned-players.json, " + ex.getMessage());
        }
        SpigotConfig.init((File)this.console.options.valueOf("spigot-settings"));
        for (WorldServer world : this.console.getAllLevels()) {
            world.serverLevelData.setDifficulty(config.difficulty);
            world.setSpawnSettings(config.spawnMonsters, config.spawnAnimals);
            for (SpawnCategory spawnCategory : SpawnCategory.values()) {
                if (!CraftSpawnCategory.isValidForLimits(spawnCategory)) continue;
                long ticksPerCategorySpawn = this.getTicksPerSpawns(spawnCategory);
                if (ticksPerCategorySpawn < 0L) {
                    world.ticksPerSpawnCategory.put((Object)spawnCategory, CraftSpawnCategory.getDefaultTicksPerSpawn(spawnCategory));
                    continue;
                }
                world.ticksPerSpawnCategory.put((Object)spawnCategory, ticksPerCategorySpawn);
            }
            world.spigotConfig.init();
        }
        this.pluginManager.clearPlugins();
        this.commandMap.clearCommands();
        this.reloadData();
        SpigotConfig.registerCommands();
        this.overrideAllCommandBlockCommands = this.commandsConfiguration.getStringList("command-block-overrides").contains("*");
        this.ignoreVanillaPermissions = this.commandsConfiguration.getBoolean("ignore-vanilla-permissions");
        for (int pollCount = 0; pollCount < 50 && this.getScheduler().getActiveWorkers().size() > 0; ++pollCount) {
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException world) {
                // empty catch block
            }
        }
        List<BukkitWorker> overdueWorkers = this.getScheduler().getActiveWorkers();
        for (BukkitWorker worker : overdueWorkers) {
            Plugin plugin = worker.getOwner();
            this.getLogger().log(Level.SEVERE, String.format("Nag author(s): '%s' of '%s' about the following: %s", plugin.getDescription().getAuthors(), plugin.getDescription().getFullName(), "This plugin is not properly shutting down its async tasks when it is being reloaded.  This may cause conflicts with the newly loaded version of the plugin"));
        }
        this.loadPlugins();
        this.enablePlugins(PluginLoadOrder.STARTUP);
        this.enablePlugins(PluginLoadOrder.POSTWORLD);
        this.getPluginManager().callEvent((Event)new ServerLoadEvent(ServerLoadEvent.LoadType.RELOAD));
    }

    public void reloadData() {
        CommandReload.reload(this.console);
    }

    private void loadIcon() {
        this.icon = new CraftIconCache(null);
        try {
            File file = new File(new File("."), "server-icon.png");
            if (file.isFile()) {
                this.icon = CraftServer.loadServerIcon0(file);
            }
        }
        catch (Exception ex) {
            this.getLogger().log(Level.WARNING, "Couldn't load server icon", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCustomPermissions() {
        Map perms;
        FileInputStream stream;
        File file = new File(this.configuration.getString("settings.permissions-file"));
        try {
            stream = new FileInputStream(file);
        }
        catch (FileNotFoundException ex) {
            try {
                file.createNewFile();
                return;
            }
            catch (Throwable throwable) {
                return;
            }
        }
        try {
            perms = (Map)this.yaml.load((InputStream)stream);
        }
        catch (MarkedYAMLException ex) {
            this.getLogger().log(Level.WARNING, "Server permissions file " + String.valueOf(file) + " is not valid YAML: " + ex.toString());
            return;
        }
        catch (Throwable ex) {
            this.getLogger().log(Level.WARNING, "Server permissions file " + String.valueOf(file) + " is not valid YAML.", ex);
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
        if (perms == null) {
            this.getLogger().log(Level.INFO, "Server permissions file " + String.valueOf(file) + " is empty, ignoring it");
            return;
        }
        List permsList = Permission.loadPermissions((Map)perms, (String)("Permission node '%s' in " + String.valueOf(file) + " is invalid"), (PermissionDefault)Permission.DEFAULT_PERMISSION);
        for (Permission perm : permsList) {
            try {
                this.pluginManager.addPermission(perm);
            }
            catch (IllegalArgumentException ex) {
                this.getLogger().log(Level.SEVERE, "Permission in " + String.valueOf(file) + " was already defined", ex);
            }
        }
    }

    public String toString() {
        return "CraftServer{serverName=CraftBukkit,serverVersion=" + this.serverVersion + ",minecraftVersion=" + this.console.getServerVersion() + "}";
    }

    public World createWorld(String name, World.Environment environment) {
        return WorldCreator.name((String)name).environment(environment).createWorld();
    }

    public World createWorld(String name, World.Environment environment, long seed) {
        return WorldCreator.name((String)name).environment(environment).seed(seed).createWorld();
    }

    public World createWorld(String name, World.Environment environment, ChunkGenerator generator) {
        return WorldCreator.name((String)name).environment(environment).generator(generator).createWorld();
    }

    public World createWorld(String name, World.Environment environment, long seed, ChunkGenerator generator) {
        return WorldCreator.name((String)name).environment(environment).seed(seed).generator(generator).createWorld();
    }

    public World createWorld(WorldCreator creator) {
        String levelName;
        WorldDataServer worlddata;
        Dynamic<?> dynamic;
        Convertable.ConversionSession worldSession;
        Preconditions.checkState((boolean)this.console.getAllLevels().iterator().hasNext(), (Object)"Cannot create additional worlds on STARTUP");
        Preconditions.checkArgument((creator != null ? 1 : 0) != 0, (Object)"WorldCreator cannot be null");
        String name = creator.name();
        ChunkGenerator generator = creator.generator();
        BiomeProvider biomeProvider = creator.biomeProvider();
        File folder = new File(this.getWorldContainer(), name);
        World world = this.getWorld(name);
        if (world != null) {
            return world;
        }
        if (folder.exists()) {
            Preconditions.checkArgument((boolean)folder.isDirectory(), (String)"File (%s) exists and isn't a folder", (Object)name);
        }
        if (generator == null) {
            generator = this.getGenerator(name);
        }
        if (biomeProvider == null) {
            biomeProvider = this.getBiomeProvider(name);
        }
        ResourceKey<WorldDimension> actualDimension = switch (creator.environment()) {
            case World.Environment.NORMAL -> WorldDimension.OVERWORLD;
            case World.Environment.NETHER -> WorldDimension.NETHER;
            case World.Environment.THE_END -> WorldDimension.END;
            default -> throw new IllegalArgumentException("Illegal dimension (" + String.valueOf(creator.environment()) + ")");
        };
        try {
            worldSession = Convertable.createDefault(this.getWorldContainer().toPath()).validateAndCreateAccess(name, actualDimension);
        }
        catch (IOException | ContentValidationException ex) {
            throw new RuntimeException(ex);
        }
        if (worldSession.hasWorldData()) {
            WorldInfo worldinfo;
            try {
                dynamic = worldSession.getDataTag();
                worldinfo = worldSession.getSummary(dynamic);
            }
            catch (IOException | NbtException | ReportedNbtException ioexception) {
                Convertable.b convertable_b = worldSession.getLevelDirectory();
                MinecraftServer.LOGGER.warn("Failed to load world data from {}", (Object)convertable_b.dataFile(), (Object)ioexception);
                MinecraftServer.LOGGER.info("Attempting to use fallback");
                try {
                    dynamic = worldSession.getDataTagFallback();
                    worldinfo = worldSession.getSummary(dynamic);
                }
                catch (IOException | NbtException | ReportedNbtException ioexception1) {
                    MinecraftServer.LOGGER.error("Failed to load world data from {}", (Object)convertable_b.oldDataFile(), (Object)ioexception1);
                    MinecraftServer.LOGGER.error("Failed to load world data from {} and {}. World files may be corrupted. Shutting down.", (Object)convertable_b.dataFile(), (Object)convertable_b.oldDataFile());
                    return null;
                }
                worldSession.restoreLevelDataFromOld();
            }
            if (worldinfo.requiresManualConversion()) {
                MinecraftServer.LOGGER.info("This world must be opened in an older version (like 1.6.4) to be safely converted");
                return null;
            }
            if (!worldinfo.isCompatible()) {
                MinecraftServer.LOGGER.info("This world was created by an incompatible version.");
                return null;
            }
        } else {
            dynamic = null;
        }
        boolean hardcore = creator.hardcore();
        WorldLoader.a worldloader_a = this.console.worldLoader;
        IRegistryCustom.Dimension iregistrycustom_dimension = worldloader_a.datapackDimensions();
        IRegistry<WorldDimension> iregistry = iregistrycustom_dimension.registryOrThrow(Registries.LEVEL_STEM);
        if (dynamic != null) {
            LevelDataAndDimensions leveldataanddimensions = Convertable.getLevelDataAndDimensions(dynamic, worldloader_a.dataConfiguration(), iregistry, worldloader_a.datapackWorldgen());
            worlddata = (WorldDataServer)leveldataanddimensions.worldData();
            iregistrycustom_dimension = leveldataanddimensions.dimensions().dimensionsRegistryAccess();
        } else {
            WorldOptions worldoptions = new WorldOptions(creator.seed(), creator.generateStructures(), false);
            DedicatedServerProperties.WorldDimensionData properties = new DedicatedServerProperties.WorldDimensionData(ChatDeserializer.parse(creator.generatorSettings().isEmpty() ? "{}" : creator.generatorSettings()), creator.type().name().toLowerCase(Locale.ROOT));
            WorldSettings worldsettings = new WorldSettings(name, EnumGamemode.byId(this.getDefaultGameMode().getValue()), hardcore, EnumDifficulty.EASY, false, new GameRules(), worldloader_a.dataConfiguration());
            WorldDimensions worlddimensions = properties.create(worldloader_a.datapackWorldgen());
            WorldDimensions.b worlddimensions_b = worlddimensions.bake(iregistry);
            Lifecycle lifecycle = worlddimensions_b.lifecycle().add(worldloader_a.datapackWorldgen().allRegistriesLifecycle());
            worlddata = new WorldDataServer(worldsettings, worldoptions, worlddimensions_b.specialWorldProperty(), lifecycle);
            iregistrycustom_dimension = worlddimensions_b.dimensionsRegistryAccess();
        }
        iregistry = iregistrycustom_dimension.registryOrThrow(Registries.LEVEL_STEM);
        worlddata.customDimensions = iregistry;
        worlddata.checkName(name);
        worlddata.setModdedInfo(this.console.getServerModName(), this.console.getModdedStatus().shouldReportAsModified());
        if (this.console.options.has("forceUpgrade")) {
            net.minecraft.server.Main.forceUpgrade(worldSession, DataConverterRegistry.getDataFixer(), this.console.options.has("eraseCache"), () -> true, iregistrycustom_dimension, this.console.options.has("recreateRegionFiles"));
        }
        long j2 = BiomeManager.obfuscateSeed(creator.seed());
        ImmutableList list = ImmutableList.of((Object)new MobSpawnerPhantom(), (Object)new MobSpawnerPatrol(), (Object)new MobSpawnerCat(), (Object)new VillageSiege(), (Object)new MobSpawnerTrader(worlddata));
        WorldDimension worlddimension = iregistry.get(actualDimension);
        CraftWorldInfo worldInfo = new CraftWorldInfo(worlddata, worldSession, creator.environment(), worlddimension.type().value());
        if (biomeProvider == null && generator != null) {
            biomeProvider = generator.getDefaultBiomeProvider((org.bukkit.generator.WorldInfo)worldInfo);
        }
        ResourceKey<net.minecraft.world.level.World> worldKey = name.equals((levelName = this.getServer().getProperties().levelName) + "_nether") ? net.minecraft.world.level.World.NETHER : (name.equals(levelName + "_the_end") ? net.minecraft.world.level.World.END : ResourceKey.create(Registries.DIMENSION, MinecraftKey.withDefaultNamespace(name.toLowerCase(Locale.ROOT))));
        if (!creator.keepSpawnInMemory()) {
            worlddata.getGameRules().getRule(GameRules.RULE_SPAWN_CHUNK_RADIUS).set(0, null);
        }
        WorldServer internal = new WorldServer(this.console, this.console.executor, worldSession, worlddata, worldKey, worlddimension, this.getServer().progressListenerFactory.create(worlddata.getGameRules().getInt(GameRules.RULE_SPAWN_CHUNK_RADIUS)), worlddata.isDebugWorld(), j2, (List<MobSpawner>)(creator.environment() == World.Environment.NORMAL ? list : ImmutableList.of()), true, this.console.overworld().getRandomSequences(), creator.environment(), generator, biomeProvider);
        if (!this.worlds.containsKey(name.toLowerCase(Locale.ROOT))) {
            return null;
        }
        this.console.initWorld(internal, worlddata, worlddata, worlddata.worldGenOptions());
        internal.setSpawnSettings(true, true);
        this.console.addLevel(internal);
        this.getServer().prepareLevels(internal.getChunkSource().chunkMap.progressListener, internal);
        internal.entityManager.tick();
        this.pluginManager.callEvent((Event)new WorldLoadEvent((World)internal.getWorld()));
        return internal.getWorld();
    }

    public boolean unloadWorld(String name, boolean save) {
        return this.unloadWorld(this.getWorld(name), save);
    }

    public boolean unloadWorld(World world, boolean save) {
        if (world == null) {
            return false;
        }
        WorldServer handle = ((CraftWorld)world).getHandle();
        if (this.console.getLevel(handle.dimension()) == null) {
            return false;
        }
        if (handle.dimension() == net.minecraft.world.level.World.OVERWORLD) {
            return false;
        }
        if (handle.players().size() > 0) {
            return false;
        }
        WorldUnloadEvent e2 = new WorldUnloadEvent((World)handle.getWorld());
        this.pluginManager.callEvent((Event)e2);
        if (e2.isCancelled()) {
            return false;
        }
        try {
            if (save) {
                handle.save(null, true, true);
            }
            handle.getChunkSource().close(save);
            handle.entityManager.close(save);
            handle.convertable.close();
        }
        catch (Exception ex) {
            this.getLogger().log(Level.SEVERE, null, ex);
        }
        this.worlds.remove(world.getName().toLowerCase(Locale.ROOT));
        this.console.removeLevel(handle);
        return true;
    }

    public DedicatedServer getServer() {
        return this.console;
    }

    public World getWorld(String name) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"name cannot be null");
        return this.worlds.get(name.toLowerCase(Locale.ROOT));
    }

    public World getWorld(UUID uid) {
        for (World world : this.worlds.values()) {
            if (!world.getUID().equals(uid)) continue;
            return world;
        }
        return null;
    }

    public void addWorld(World world) {
        if (this.getWorld(world.getUID()) != null) {
            System.out.println("World " + world.getName() + " is a duplicate of another world and has been prevented from loading. Please delete the uid.dat file from " + world.getName() + "'s world directory if you want to be able to load the duplicate world.");
            return;
        }
        this.worlds.put(world.getName().toLowerCase(Locale.ROOT), world);
    }

    public WorldBorder createWorldBorder() {
        return new CraftWorldBorder(new net.minecraft.world.level.border.WorldBorder());
    }

    public Logger getLogger() {
        return this.logger;
    }

    public ConsoleReader getReader() {
        return this.console.reader;
    }

    public PluginCommand getPluginCommand(String name) {
        Command command = this.commandMap.getCommand(name);
        if (command instanceof PluginCommand) {
            return (PluginCommand)command;
        }
        return null;
    }

    public void savePlayers() {
        this.checkSaveState();
        this.playerList.saveAll();
    }

    public boolean addRecipe(Recipe recipe) {
        CraftRecipe toAdd;
        if (recipe instanceof CraftRecipe) {
            toAdd = (CraftRecipe)recipe;
        } else if (recipe instanceof ShapedRecipe) {
            toAdd = CraftShapedRecipe.fromBukkitRecipe((ShapedRecipe)recipe);
        } else if (recipe instanceof ShapelessRecipe) {
            toAdd = CraftShapelessRecipe.fromBukkitRecipe((ShapelessRecipe)recipe);
        } else if (recipe instanceof FurnaceRecipe) {
            toAdd = CraftFurnaceRecipe.fromBukkitRecipe((FurnaceRecipe)recipe);
        } else if (recipe instanceof BlastingRecipe) {
            toAdd = CraftBlastingRecipe.fromBukkitRecipe((BlastingRecipe)recipe);
        } else if (recipe instanceof CampfireRecipe) {
            toAdd = CraftCampfireRecipe.fromBukkitRecipe((CampfireRecipe)recipe);
        } else if (recipe instanceof SmokingRecipe) {
            toAdd = CraftSmokingRecipe.fromBukkitRecipe((SmokingRecipe)recipe);
        } else if (recipe instanceof StonecuttingRecipe) {
            toAdd = CraftStonecuttingRecipe.fromBukkitRecipe((StonecuttingRecipe)recipe);
        } else if (recipe instanceof SmithingTransformRecipe) {
            toAdd = CraftSmithingTransformRecipe.fromBukkitRecipe((SmithingTransformRecipe)recipe);
        } else if (recipe instanceof SmithingTrimRecipe) {
            toAdd = CraftSmithingTrimRecipe.fromBukkitRecipe((SmithingTrimRecipe)recipe);
        } else {
            if (recipe instanceof ComplexRecipe) {
                throw new UnsupportedOperationException("Cannot add custom complex recipe");
            }
            return false;
        }
        toAdd.addToCraftingManager();
        return true;
    }

    public List<Recipe> getRecipesFor(org.bukkit.inventory.ItemStack result) {
        Preconditions.checkArgument((result != null ? 1 : 0) != 0, (Object)"ItemStack cannot be null");
        ArrayList<Recipe> results = new ArrayList<Recipe>();
        Iterator<Recipe> iter = this.recipeIterator();
        while (iter.hasNext()) {
            Recipe recipe = iter.next();
            org.bukkit.inventory.ItemStack stack = recipe.getResult();
            if (stack.getType() != result.getType() || result.getDurability() != -1 && result.getDurability() != stack.getDurability()) continue;
            results.add(recipe);
        }
        return results;
    }

    public Recipe getRecipe(NamespacedKey recipeKey) {
        Preconditions.checkArgument((recipeKey != null ? 1 : 0) != 0, (Object)"NamespacedKey recipeKey cannot be null");
        return this.getServer().getRecipeManager().byKey(CraftNamespacedKey.toMinecraft(recipeKey)).map(RecipeHolder::toBukkitRecipe).orElse(null);
    }

    private InventoryCrafting createInventoryCrafting() {
        Container container = new Container(this, null, -1){

            @Override
            public InventoryView getBukkitView() {
                return null;
            }

            @Override
            public boolean stillValid(EntityHuman entityhuman) {
                return false;
            }

            @Override
            public ItemStack quickMoveStack(EntityHuman entityhuman, int i2) {
                return ItemStack.EMPTY;
            }
        };
        TransientCraftingContainer inventoryCrafting = new TransientCraftingContainer(container, 3, 3);
        return inventoryCrafting;
    }

    public Recipe getCraftingRecipe(org.bukkit.inventory.ItemStack[] craftingMatrix, World world) {
        return this.getNMSRecipe(craftingMatrix, this.createInventoryCrafting(), (CraftWorld)world).map(RecipeHolder::toBukkitRecipe).orElse(null);
    }

    public org.bukkit.inventory.ItemStack craftItem(org.bukkit.inventory.ItemStack[] craftingMatrix, World world, Player player) {
        return this.craftItemResult(craftingMatrix, world, player).getResult();
    }

    public ItemCraftResult craftItemResult(org.bukkit.inventory.ItemStack[] craftingMatrix, World world, Player player) {
        Preconditions.checkArgument((world != null ? 1 : 0) != 0, (Object)"world cannot be null");
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"player cannot be null");
        CraftWorld craftWorld = (CraftWorld)world;
        CraftPlayer craftPlayer = (CraftPlayer)player;
        ContainerWorkbench container = new ContainerWorkbench(-1, craftPlayer.getHandle().getInventory());
        TransientCraftingContainer inventoryCrafting = container.craftSlots;
        InventoryCraftResult craftResult = container.resultSlots;
        Optional<RecipeHolder<RecipeCrafting>> recipe = this.getNMSRecipe(craftingMatrix, inventoryCrafting, craftWorld);
        ItemStack itemstack = ItemStack.EMPTY;
        if (recipe.isPresent()) {
            RecipeHolder<RecipeCrafting> recipeCrafting = recipe.get();
            if (craftResult.setRecipeUsed(craftWorld.getHandle(), craftPlayer.getHandle(), recipeCrafting)) {
                itemstack = recipeCrafting.value().assemble(inventoryCrafting.asCraftInput(), craftWorld.getHandle().registryAccess());
            }
        }
        ItemStack result = CraftEventFactory.callPreCraftEvent(inventoryCrafting, craftResult, itemstack, container.getBukkitView(), recipe.map(RecipeHolder::value).orElse(null) instanceof RecipeRepair);
        return this.createItemCraftResult(CraftItemStack.asBukkitCopy(result), inventoryCrafting, craftWorld.getHandle());
    }

    public org.bukkit.inventory.ItemStack craftItem(org.bukkit.inventory.ItemStack[] craftingMatrix, World world) {
        return this.craftItemResult(craftingMatrix, world).getResult();
    }

    public ItemCraftResult craftItemResult(org.bukkit.inventory.ItemStack[] craftingMatrix, World world) {
        Preconditions.checkArgument((world != null ? 1 : 0) != 0, (Object)"world must not be null");
        CraftWorld craftWorld = (CraftWorld)world;
        InventoryCrafting inventoryCrafting = this.createInventoryCrafting();
        Optional<RecipeHolder<RecipeCrafting>> recipe = this.getNMSRecipe(craftingMatrix, inventoryCrafting, craftWorld);
        ItemStack itemStack = ItemStack.EMPTY;
        if (recipe.isPresent()) {
            itemStack = recipe.get().value().assemble(inventoryCrafting.asCraftInput(), craftWorld.getHandle().registryAccess());
        }
        return this.createItemCraftResult(CraftItemStack.asBukkitCopy(itemStack), inventoryCrafting, craftWorld.getHandle());
    }

    private CraftItemCraftResult createItemCraftResult(org.bukkit.inventory.ItemStack itemStack, InventoryCrafting inventoryCrafting, WorldServer worldServer) {
        int i2;
        CraftItemCraftResult craftItemResult = new CraftItemCraftResult(itemStack);
        NonNullList<ItemStack> remainingItems = this.getServer().getRecipeManager().getRemainingItemsFor(Recipes.CRAFTING, inventoryCrafting.asCraftInput(), worldServer);
        for (i2 = 0; i2 < remainingItems.size(); ++i2) {
            ItemStack itemstack1 = inventoryCrafting.getItem(i2);
            ItemStack itemstack2 = remainingItems.get(i2);
            if (!itemstack1.isEmpty()) {
                inventoryCrafting.removeItem(i2, 1);
                itemstack1 = inventoryCrafting.getItem(i2);
            }
            if (itemstack2.isEmpty()) continue;
            if (itemstack1.isEmpty()) {
                inventoryCrafting.setItem(i2, itemstack2);
                continue;
            }
            if (ItemStack.isSameItemSameComponents(itemstack1, itemstack2)) {
                itemstack2.grow(itemstack1.getCount());
                inventoryCrafting.setItem(i2, itemstack2);
                continue;
            }
            craftItemResult.getOverflowItems().add(CraftItemStack.asBukkitCopy(itemstack2));
        }
        for (i2 = 0; i2 < inventoryCrafting.getContents().size(); ++i2) {
            craftItemResult.setResultMatrix(i2, CraftItemStack.asBukkitCopy(inventoryCrafting.getItem(i2)));
        }
        return craftItemResult;
    }

    private Optional<RecipeHolder<RecipeCrafting>> getNMSRecipe(org.bukkit.inventory.ItemStack[] craftingMatrix, InventoryCrafting inventoryCrafting, CraftWorld world) {
        Preconditions.checkArgument((craftingMatrix != null ? 1 : 0) != 0, (Object)"craftingMatrix must not be null");
        Preconditions.checkArgument((craftingMatrix.length == 9 ? 1 : 0) != 0, (Object)"craftingMatrix must be an array of length 9");
        Preconditions.checkArgument((world != null ? 1 : 0) != 0, (Object)"world must not be null");
        for (int i2 = 0; i2 < craftingMatrix.length; ++i2) {
            inventoryCrafting.setItem(i2, CraftItemStack.asNMSCopy(craftingMatrix[i2]));
        }
        return this.getServer().getRecipeManager().getRecipeFor(Recipes.CRAFTING, inventoryCrafting.asCraftInput(), world.getHandle());
    }

    public Iterator<Recipe> recipeIterator() {
        return new RecipeIterator();
    }

    public void clearRecipes() {
        this.console.getRecipeManager().clearRecipes();
    }

    public void resetRecipes() {
        this.reloadData();
    }

    public boolean removeRecipe(NamespacedKey recipeKey) {
        Preconditions.checkArgument((recipeKey != null ? 1 : 0) != 0, (Object)"recipeKey == null");
        MinecraftKey mcKey = CraftNamespacedKey.toMinecraft(recipeKey);
        return this.getServer().getRecipeManager().removeRecipe(mcKey);
    }

    public Map<String, String[]> getCommandAliases() {
        ConfigurationSection section = this.commandsConfiguration.getConfigurationSection("aliases");
        LinkedHashMap<String, String[]> result = new LinkedHashMap<String, String[]>();
        if (section != null) {
            for (String key : section.getKeys(false)) {
                List commands = section.isList(key) ? section.getStringList(key) : ImmutableList.of((Object)section.getString(key));
                result.put(key, commands.toArray(new String[commands.size()]));
            }
        }
        return result;
    }

    public void removeBukkitSpawnRadius() {
        this.configuration.set("settings.spawn-radius", null);
        this.saveConfig();
    }

    public int getBukkitSpawnRadius() {
        return this.configuration.getInt("settings.spawn-radius", -1);
    }

    public String getShutdownMessage() {
        return this.configuration.getString("settings.shutdown-message");
    }

    public int getSpawnRadius() {
        return this.getServer().getSpawnProtectionRadius();
    }

    public void setSpawnRadius(int value) {
        this.configuration.set("settings.spawn-radius", (Object)value);
        this.saveConfig();
    }

    public boolean shouldSendChatPreviews() {
        return false;
    }

    public boolean isEnforcingSecureProfiles() {
        return this.getServer().enforceSecureProfile();
    }

    public boolean isAcceptingTransfers() {
        return this.getServer().acceptsTransfers();
    }

    public boolean getHideOnlinePlayers() {
        return this.console.hidesOnlinePlayers();
    }

    public boolean getOnlineMode() {
        return this.console.usesAuthentication();
    }

    public boolean getAllowFlight() {
        return this.console.isFlightAllowed();
    }

    public boolean isHardcore() {
        return this.console.isHardcore();
    }

    public ChunkGenerator getGenerator(String world) {
        String name;
        ConfigurationSection section = this.configuration.getConfigurationSection("worlds");
        ChunkGenerator result = null;
        if (section != null && (section = section.getConfigurationSection(world)) != null && (name = section.getString("generator")) != null && !name.equals("")) {
            String[] split = name.split(":", 2);
            String id = split.length > 1 ? split[1] : null;
            Plugin plugin = this.pluginManager.getPlugin(split[0]);
            if (plugin == null) {
                this.getLogger().severe("Could not set generator for default world '" + world + "': Plugin '" + split[0] + "' does not exist");
            } else if (!plugin.isEnabled()) {
                this.getLogger().severe("Could not set generator for default world '" + world + "': Plugin '" + plugin.getDescription().getFullName() + "' is not enabled yet (is it load:STARTUP?)");
            } else {
                try {
                    result = plugin.getDefaultWorldGenerator(world, id);
                    if (result == null) {
                        this.getLogger().severe("Could not set generator for default world '" + world + "': Plugin '" + plugin.getDescription().getFullName() + "' lacks a default world generator");
                    }
                }
                catch (Throwable t2) {
                    plugin.getLogger().log(Level.SEVERE, "Could not set generator for default world '" + world + "': Plugin '" + plugin.getDescription().getFullName(), t2);
                }
            }
        }
        return result;
    }

    public BiomeProvider getBiomeProvider(String world) {
        String name;
        ConfigurationSection section = this.configuration.getConfigurationSection("worlds");
        BiomeProvider result = null;
        if (section != null && (section = section.getConfigurationSection(world)) != null && (name = section.getString("biome-provider")) != null && !name.equals("")) {
            String[] split = name.split(":", 2);
            String id = split.length > 1 ? split[1] : null;
            Plugin plugin = this.pluginManager.getPlugin(split[0]);
            if (plugin == null) {
                this.getLogger().severe("Could not set biome provider for default world '" + world + "': Plugin '" + split[0] + "' does not exist");
            } else if (!plugin.isEnabled()) {
                this.getLogger().severe("Could not set biome provider for default world '" + world + "': Plugin '" + plugin.getDescription().getFullName() + "' is not enabled yet (is it load:STARTUP?)");
            } else {
                try {
                    result = plugin.getDefaultBiomeProvider(world, id);
                    if (result == null) {
                        this.getLogger().severe("Could not set biome provider for default world '" + world + "': Plugin '" + plugin.getDescription().getFullName() + "' lacks a default world biome provider");
                    }
                }
                catch (Throwable t2) {
                    plugin.getLogger().log(Level.SEVERE, "Could not set biome provider for default world '" + world + "': Plugin '" + plugin.getDescription().getFullName(), t2);
                }
            }
        }
        return result;
    }

    @Deprecated
    public CraftMapView getMap(int id) {
        WorldMap worldmap = this.console.getLevel(net.minecraft.world.level.World.OVERWORLD).getMapData(new MapId(id));
        if (worldmap == null) {
            return null;
        }
        return worldmap.mapView;
    }

    public CraftMapView createMap(World world) {
        Preconditions.checkArgument((world != null ? 1 : 0) != 0, (Object)"World cannot be null");
        WorldServer minecraftWorld = ((CraftWorld)world).getHandle();
        BlockPosition spawn = minecraftWorld.getLevelData().getSpawnPos();
        MapId newId = ItemWorldMap.createNewSavedData(minecraftWorld, spawn.getX(), spawn.getZ(), 3, false, false, minecraftWorld.dimension());
        return ((net.minecraft.world.level.World)minecraftWorld).getMapData((MapId)newId).mapView;
    }

    public org.bukkit.inventory.ItemStack createExplorerMap(World world, Location location, StructureType structureType) {
        return this.createExplorerMap(world, location, structureType, 100, true);
    }

    public org.bukkit.inventory.ItemStack createExplorerMap(World world, Location location, StructureType structureType, int radius, boolean findUnexplored) {
        Preconditions.checkArgument((world != null ? 1 : 0) != 0, (Object)"World cannot be null");
        Preconditions.checkArgument((structureType != null ? 1 : 0) != 0, (Object)"StructureType cannot be null");
        Preconditions.checkArgument((structureType.getMapIcon() != null ? 1 : 0) != 0, (String)"Cannot create explorer maps for StructureType %s", (Object)structureType.getName());
        WorldServer worldServer = ((CraftWorld)world).getHandle();
        Location structureLocation = world.locateNearestStructure(location, structureType, radius, findUnexplored);
        BlockPosition structurePosition = CraftLocation.toBlockPosition(structureLocation);
        ItemStack stack = ItemWorldMap.create(worldServer, structurePosition.getX(), structurePosition.getZ(), MapView.Scale.NORMAL.getValue(), true, true);
        ItemWorldMap.renderBiomePreviewMap(worldServer, stack);
        ItemWorldMap.getSavedData(stack, (net.minecraft.world.level.World)worldServer);
        WorldMap.addTargetDecoration(stack, structurePosition, "+", CraftMapCursor.CraftType.bukkitToMinecraftHolder(structureType.getMapIcon()));
        return CraftItemStack.asBukkitCopy(stack);
    }

    public void shutdown() {
        this.console.halt(false);
    }

    public int broadcast(String message, String permission) {
        HashSet<CommandSender> recipients = new HashSet<CommandSender>();
        for (Permissible permissible : this.getPluginManager().getPermissionSubscriptions(permission)) {
            if (!(permissible instanceof CommandSender) || !permissible.hasPermission(permission)) continue;
            recipients.add((CommandSender)permissible);
        }
        BroadcastMessageEvent broadcastMessageEvent = new BroadcastMessageEvent(!Bukkit.isPrimaryThread(), message, recipients);
        this.getPluginManager().callEvent((Event)broadcastMessageEvent);
        if (broadcastMessageEvent.isCancelled()) {
            return 0;
        }
        message = broadcastMessageEvent.getMessage();
        for (CommandSender recipient : recipients) {
            recipient.sendMessage(message);
        }
        return recipients.size();
    }

    @Deprecated
    public OfflinePlayer getOfflinePlayer(String name) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"name cannot be null");
        Preconditions.checkArgument((!name.isBlank() ? 1 : 0) != 0, (Object)"name cannot be empty");
        Player result = this.getPlayerExact(name);
        if (result == null) {
            GameProfile profile = null;
            if (this.getOnlineMode() || SpigotConfig.bungee) {
                profile = this.console.getProfileCache().get(name).orElse(null);
            }
            result = profile == null ? this.getOfflinePlayer(new GameProfile(UUID.nameUUIDFromBytes(("OfflinePlayer:" + name).getBytes(Charsets.UTF_8)), name)) : this.getOfflinePlayer(profile);
        } else {
            this.offlinePlayers.remove(result.getUniqueId());
        }
        return result;
    }

    public OfflinePlayer getOfflinePlayer(UUID id) {
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"UUID id cannot be null");
        Object result = this.getPlayer(id);
        if (result == null) {
            result = this.offlinePlayers.get(id);
            if (result == null) {
                result = new CraftOfflinePlayer(this, new GameProfile(id, ""));
                this.offlinePlayers.put(id, (OfflinePlayer)result);
            }
        } else {
            this.offlinePlayers.remove(id);
        }
        return result;
    }

    public PlayerProfile createPlayerProfile(UUID uniqueId, String name) {
        return new CraftPlayerProfile(uniqueId, name);
    }

    public PlayerProfile createPlayerProfile(UUID uniqueId) {
        return new CraftPlayerProfile(uniqueId, null);
    }

    public PlayerProfile createPlayerProfile(String name) {
        return new CraftPlayerProfile(null, name);
    }

    public OfflinePlayer getOfflinePlayer(GameProfile profile) {
        CraftOfflinePlayer player = new CraftOfflinePlayer(this, profile);
        this.offlinePlayers.put(profile.getId(), player);
        return player;
    }

    public Set<String> getIPBans() {
        return this.playerList.getIpBans().getEntries().stream().map(JsonListEntry::getUser).collect(Collectors.toSet());
    }

    public void banIP(String address) {
        Preconditions.checkArgument((address != null && !address.isBlank() ? 1 : 0) != 0, (Object)"Address cannot be null or blank.");
        this.getBanList(BanList.Type.IP).addBan(address, null, null, null);
    }

    public void unbanIP(String address) {
        Preconditions.checkArgument((address != null && !address.isBlank() ? 1 : 0) != 0, (Object)"Address cannot be null or blank.");
        this.getBanList(BanList.Type.IP).pardon(address);
    }

    public void banIP(InetAddress address) {
        Preconditions.checkArgument((address != null ? 1 : 0) != 0, (Object)"Address cannot be null.");
        ((CraftIpBanList)this.getBanList(BanList.Type.IP)).addBan(address, null, (Date)null, null);
    }

    public void unbanIP(InetAddress address) {
        Preconditions.checkArgument((address != null ? 1 : 0) != 0, (Object)"Address cannot be null.");
        ((CraftIpBanList)this.getBanList(BanList.Type.IP)).pardon(address);
    }

    public Set<OfflinePlayer> getBannedPlayers() {
        HashSet<OfflinePlayer> result = new HashSet<OfflinePlayer>();
        for (GameProfileBanEntry entry : this.playerList.getBans().getEntries()) {
            result.add(this.getOfflinePlayer((GameProfile)entry.getUser()));
        }
        return result;
    }

    public <T extends BanList<?>> T getBanList(BanList.Type type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"BanList.Type cannot be null");
        return (T)(switch (type) {
            default -> throw new MatchException(null, null);
            case BanList.Type.IP -> (BanList)new CraftIpBanList(this.playerList.getIpBans());
            case BanList.Type.PROFILE, BanList.Type.NAME -> (BanList)new CraftProfileBanList(this.playerList.getBans());
        });
    }

    public void setWhitelist(boolean value) {
        this.playerList.setUsingWhiteList(value);
        this.console.storeUsingWhiteList(value);
    }

    public boolean isWhitelistEnforced() {
        return this.console.isEnforceWhitelist();
    }

    public void setWhitelistEnforced(boolean value) {
        this.console.setEnforceWhitelist(value);
    }

    public Set<OfflinePlayer> getWhitelistedPlayers() {
        LinkedHashSet<OfflinePlayer> result = new LinkedHashSet<OfflinePlayer>();
        for (WhiteListEntry entry : this.playerList.getWhiteList().getEntries()) {
            result.add(this.getOfflinePlayer((GameProfile)entry.getUser()));
        }
        return result;
    }

    public Set<OfflinePlayer> getOperators() {
        HashSet<OfflinePlayer> result = new HashSet<OfflinePlayer>();
        for (OpListEntry entry : this.playerList.getOps().getEntries()) {
            result.add(this.getOfflinePlayer((GameProfile)entry.getUser()));
        }
        return result;
    }

    public void reloadWhitelist() {
        this.playerList.reloadWhiteList();
    }

    public GameMode getDefaultGameMode() {
        return GameMode.getByValue((int)this.console.getLevel(net.minecraft.world.level.World.OVERWORLD).serverLevelData.getGameType().getId());
    }

    public void setDefaultGameMode(GameMode mode) {
        Preconditions.checkArgument((mode != null ? 1 : 0) != 0, (Object)"GameMode cannot be null");
        for (World world : this.getWorlds()) {
            ((CraftWorld)world).getHandle().serverLevelData.setGameType(EnumGamemode.byId(mode.getValue()));
        }
    }

    public ConsoleCommandSender getConsoleSender() {
        return this.console.console;
    }

    public EntityMetadataStore getEntityMetadata() {
        return this.entityMetadata;
    }

    public PlayerMetadataStore getPlayerMetadata() {
        return this.playerMetadata;
    }

    public WorldMetadataStore getWorldMetadata() {
        return this.worldMetadata;
    }

    public File getWorldContainer() {
        return this.getServer().storageSource.getDimensionPath(net.minecraft.world.level.World.OVERWORLD).getParent().toFile();
    }

    public OfflinePlayer[] getOfflinePlayers() {
        WorldNBTStorage storage = this.console.playerDataStorage;
        String[] files = storage.getPlayerDir().list(new DatFileFilter());
        HashSet<OfflinePlayer> players = new HashSet<OfflinePlayer>();
        for (String file : files) {
            try {
                players.add(this.getOfflinePlayer(UUID.fromString(file.substring(0, file.length() - 4))));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        players.addAll(this.getOnlinePlayers());
        return players.toArray(new OfflinePlayer[players.size()]);
    }

    public Messenger getMessenger() {
        return this.messenger;
    }

    public void sendPluginMessage(Plugin source, String channel, byte[] message) {
        StandardMessenger.validatePluginMessage((Messenger)this.getMessenger(), (Plugin)source, (String)channel, (byte[])message);
        for (Player player : this.getOnlinePlayers()) {
            player.sendPluginMessage(source, channel, message);
        }
    }

    public Set<String> getListeningPluginChannels() {
        HashSet<String> result = new HashSet<String>();
        for (Player player : this.getOnlinePlayers()) {
            result.addAll(player.getListeningPluginChannels());
        }
        return result;
    }

    public Inventory createInventory(InventoryHolder owner, InventoryType type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"InventoryType cannot be null");
        Preconditions.checkArgument((boolean)type.isCreatable(), (String)"InventoryType.%s cannot be used to create a inventory", (Object)type);
        return CraftInventoryCreator.INSTANCE.createInventory(owner, type);
    }

    public Inventory createInventory(InventoryHolder owner, InventoryType type, String title) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"InventoryType cannot be null");
        Preconditions.checkArgument((boolean)type.isCreatable(), (String)"InventoryType.%s cannot be used to create a inventory", (Object)type);
        Preconditions.checkArgument((title != null ? 1 : 0) != 0, (Object)"title cannot be null");
        return CraftInventoryCreator.INSTANCE.createInventory(owner, type, title);
    }

    public Inventory createInventory(InventoryHolder owner, int size) throws IllegalArgumentException {
        Preconditions.checkArgument((9 <= size && size <= 54 && size % 9 == 0 ? 1 : 0) != 0, (String)"Size for custom inventory must be a multiple of 9 between 9 and 54 slots (got %s)", (int)size);
        return CraftInventoryCreator.INSTANCE.createInventory(owner, size);
    }

    public Inventory createInventory(InventoryHolder owner, int size, String title) throws IllegalArgumentException {
        Preconditions.checkArgument((9 <= size && size <= 54 && size % 9 == 0 ? 1 : 0) != 0, (String)"Size for custom inventory must be a multiple of 9 between 9 and 54 slots (got %s)", (int)size);
        return CraftInventoryCreator.INSTANCE.createInventory(owner, size, title);
    }

    public Merchant createMerchant(String title) {
        return new CraftMerchantCustom(title == null ? InventoryType.MERCHANT.getDefaultTitle() : title);
    }

    public int getMaxChainedNeighborUpdates() {
        return this.getServer().getMaxChainedNeighborUpdates();
    }

    public HelpMap getHelpMap() {
        return this.helpMap;
    }

    public SimpleCommandMap getCommandMap() {
        return this.commandMap;
    }

    @Deprecated
    public int getMonsterSpawnLimit() {
        return this.getSpawnLimit(SpawnCategory.MONSTER);
    }

    @Deprecated
    public int getAnimalSpawnLimit() {
        return this.getSpawnLimit(SpawnCategory.ANIMAL);
    }

    @Deprecated
    public int getWaterAnimalSpawnLimit() {
        return this.getSpawnLimit(SpawnCategory.WATER_ANIMAL);
    }

    @Deprecated
    public int getWaterAmbientSpawnLimit() {
        return this.getSpawnLimit(SpawnCategory.WATER_AMBIENT);
    }

    @Deprecated
    public int getWaterUndergroundCreatureSpawnLimit() {
        return this.getSpawnLimit(SpawnCategory.WATER_UNDERGROUND_CREATURE);
    }

    @Deprecated
    public int getAmbientSpawnLimit() {
        return this.getSpawnLimit(SpawnCategory.AMBIENT);
    }

    public int getSpawnLimit(SpawnCategory spawnCategory) {
        return this.spawnCategoryLimit.getOrDefault((Object)spawnCategory, -1);
    }

    public boolean isPrimaryThread() {
        return Thread.currentThread().equals(this.console.serverThread) || this.console.hasStopped() || !AsyncCatcher.enabled;
    }

    public String getMotd() {
        return this.console.getMotd();
    }

    public void setMotd(String motd) {
        this.console.setMotd(motd);
    }

    public ServerLinks getServerLinks() {
        return this.serverLinks;
    }

    public Warning.WarningState getWarningState() {
        return this.warningState;
    }

    public List<String> tabComplete(CommandSender sender, String message, WorldServer world, Vec3D pos, boolean forceCommand) {
        if (!(sender instanceof Player)) {
            return ImmutableList.of();
        }
        Player player = (Player)sender;
        List<String> offers = message.startsWith("/") || forceCommand ? this.tabCompleteCommand(player, message, world, pos) : this.tabCompleteChat(player, message);
        TabCompleteEvent tabEvent = new TabCompleteEvent((CommandSender)player, message, offers);
        this.getPluginManager().callEvent((Event)tabEvent);
        return tabEvent.isCancelled() ? Collections.EMPTY_LIST : tabEvent.getCompletions();
    }

    public List<String> tabCompleteCommand(Player player, String message, WorldServer world, Vec3D pos) {
        if (!(SpigotConfig.tabComplete >= 0 && message.length() > SpigotConfig.tabComplete || message.contains(" "))) {
            return ImmutableList.of();
        }
        List completions = null;
        try {
            if (message.startsWith("/")) {
                message = message.substring(1);
            }
            completions = pos == null ? this.getCommandMap().tabComplete((CommandSender)player, message) : this.getCommandMap().tabComplete((CommandSender)player, message, CraftLocation.toBukkit(pos, (World)world.getWorld()));
        }
        catch (CommandException ex) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "An internal error occurred while attempting to tab-complete this command");
            this.getLogger().log(Level.SEVERE, "Exception when " + player.getName() + " attempted to tab complete " + message, ex);
        }
        return completions == null ? ImmutableList.of() : completions;
    }

    public List<String> tabCompleteChat(Player player, String message) {
        ArrayList<String> completions = new ArrayList<String>();
        PlayerChatTabCompleteEvent event = new PlayerChatTabCompleteEvent(player, message, completions);
        String token = event.getLastToken();
        for (Player p2 : this.getOnlinePlayers()) {
            if (!player.canSee(p2) || !StringUtil.startsWithIgnoreCase((String)p2.getName(), (String)token)) continue;
            completions.add(p2.getName());
        }
        this.pluginManager.callEvent((Event)event);
        Iterator it = completions.iterator();
        while (it.hasNext()) {
            Object current = it.next();
            if (current instanceof String) continue;
            it.remove();
        }
        Collections.sort(completions, String.CASE_INSENSITIVE_ORDER);
        return completions;
    }

    public CraftItemFactory getItemFactory() {
        return CraftItemFactory.instance();
    }

    public CraftEntityFactory getEntityFactory() {
        return CraftEntityFactory.instance();
    }

    public CraftScoreboardManager getScoreboardManager() {
        return this.scoreboardManager;
    }

    public Criteria getScoreboardCriteria(String name) {
        return CraftCriteria.getFromBukkit(name);
    }

    public void checkSaveState() {
        if (this.playerCommandState || this.printSaveWarning || this.console.autosavePeriod <= 0) {
            return;
        }
        this.printSaveWarning = true;
        this.getLogger().log(Level.WARNING, "A manual (plugin-induced) save has been detected while server is configured to auto-save. This may affect performance.", this.warningState == Warning.WarningState.ON ? new Throwable() : null);
    }

    public CraftIconCache getServerIcon() {
        return this.icon;
    }

    public CraftIconCache loadServerIcon(File file) throws Exception {
        Preconditions.checkArgument((file != null ? 1 : 0) != 0, (Object)"File cannot be null");
        Preconditions.checkArgument((boolean)file.isFile(), (String)"File (%s) is not a valid file", (Object)file);
        return CraftServer.loadServerIcon0(file);
    }

    static CraftIconCache loadServerIcon0(File file) throws Exception {
        return CraftServer.loadServerIcon0(ImageIO.read(file));
    }

    public CraftIconCache loadServerIcon(BufferedImage image) throws Exception {
        Preconditions.checkArgument((image != null ? 1 : 0) != 0, (Object)"BufferedImage image cannot be null");
        return CraftServer.loadServerIcon0(image);
    }

    static CraftIconCache loadServerIcon0(BufferedImage image) throws Exception {
        Preconditions.checkArgument((image.getWidth() == 64 ? 1 : 0) != 0, (String)"BufferedImage must be 64 pixels wide (%s)", (int)image.getWidth());
        Preconditions.checkArgument((image.getHeight() == 64 ? 1 : 0) != 0, (String)"BufferedImage must be 64 pixels high (%s)", (int)image.getHeight());
        ByteArrayOutputStream bytebuf = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "PNG", bytebuf);
        return new CraftIconCache(bytebuf.toByteArray());
    }

    public void setIdleTimeout(int threshold) {
        this.console.setPlayerIdleTimeout(threshold);
    }

    public int getIdleTimeout() {
        return this.console.getPlayerIdleTimeout();
    }

    public ChunkGenerator.ChunkData createChunkData(World world) {
        Preconditions.checkArgument((world != null ? 1 : 0) != 0, (Object)"World cannot be null");
        WorldServer handle = ((CraftWorld)world).getHandle();
        return new OldCraftChunkData(world.getMinHeight(), world.getMaxHeight(), handle.registryAccess().registryOrThrow(Registries.BIOME));
    }

    public BossBar createBossBar(String title, BarColor color, BarStyle style, BarFlag ... flags) {
        return new CraftBossBar(title, color, style, flags);
    }

    public KeyedBossBar createBossBar(NamespacedKey key, String title, BarColor barColor, BarStyle barStyle, BarFlag ... barFlags) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"NamespacedKey key cannot be null");
        Preconditions.checkArgument((barColor != null ? 1 : 0) != 0, (Object)"BarColor key cannot be null");
        Preconditions.checkArgument((barStyle != null ? 1 : 0) != 0, (Object)"BarStyle key cannot be null");
        BossBattleCustom bossBattleCustom = this.getServer().getCustomBossEvents().create(CraftNamespacedKey.toMinecraft(key), CraftChatMessage.fromString(title, true)[0]);
        CraftKeyedBossbar craftKeyedBossbar = new CraftKeyedBossbar(bossBattleCustom);
        craftKeyedBossbar.setColor(barColor);
        craftKeyedBossbar.setStyle(barStyle);
        for (BarFlag flag : barFlags) {
            if (flag == null) continue;
            craftKeyedBossbar.addFlag(flag);
        }
        return craftKeyedBossbar;
    }

    public Iterator<KeyedBossBar> getBossBars() {
        return Iterators.unmodifiableIterator((Iterator)Iterators.transform(this.getServer().getCustomBossEvents().getEvents().iterator(), (Function)new Function<BossBattleCustom, KeyedBossBar>(this){

            public KeyedBossBar apply(BossBattleCustom bossBattleCustom) {
                return bossBattleCustom.getBukkitEntity();
            }
        }));
    }

    public KeyedBossBar getBossBar(NamespacedKey key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"key");
        BossBattleCustom bossBattleCustom = this.getServer().getCustomBossEvents().get(CraftNamespacedKey.toMinecraft(key));
        return bossBattleCustom == null ? null : bossBattleCustom.getBukkitEntity();
    }

    public boolean removeBossBar(NamespacedKey key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"key");
        BossBattleCustomData bossBattleCustomData = this.getServer().getCustomBossEvents();
        BossBattleCustom bossBattleCustom = bossBattleCustomData.get(CraftNamespacedKey.toMinecraft(key));
        if (bossBattleCustom != null) {
            bossBattleCustomData.remove(bossBattleCustom);
            return true;
        }
        return false;
    }

    public Entity getEntity(UUID uuid) {
        Preconditions.checkArgument((uuid != null ? 1 : 0) != 0, (Object)"UUID id cannot be null");
        for (WorldServer world : this.getServer().getAllLevels()) {
            net.minecraft.world.entity.Entity entity = world.getEntity(uuid);
            if (entity == null) continue;
            return entity.getBukkitEntity();
        }
        return null;
    }

    public Advancement getAdvancement(NamespacedKey key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"NamespacedKey key cannot be null");
        AdvancementHolder advancement = this.console.getAdvancements().get(CraftNamespacedKey.toMinecraft(key));
        return advancement == null ? null : advancement.toBukkit();
    }

    public Iterator<Advancement> advancementIterator() {
        return Iterators.unmodifiableIterator((Iterator)Iterators.transform(this.console.getAdvancements().getAllAdvancements().iterator(), (Function)new Function<AdvancementHolder, Advancement>(this){

            public Advancement apply(AdvancementHolder advancement) {
                return advancement.toBukkit();
            }
        }));
    }

    public BlockData createBlockData(Material material) {
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        return this.createBlockData(material, (String)null);
    }

    public BlockData createBlockData(Material material, Consumer<? super BlockData> consumer) {
        BlockData data = this.createBlockData(material);
        if (consumer != null) {
            consumer.accept((BlockData)data);
        }
        return data;
    }

    public BlockData createBlockData(String data) throws IllegalArgumentException {
        Preconditions.checkArgument((data != null ? 1 : 0) != 0, (Object)"data cannot be null");
        return this.createBlockData((Material)null, data);
    }

    public BlockData createBlockData(Material material, String data) {
        Preconditions.checkArgument((material != null || data != null ? 1 : 0) != 0, (Object)"Must provide one of material or data");
        return CraftBlockData.newData(material != null ? material.asBlockType() : null, data);
    }

    public <T extends Keyed> Tag<T> getTag(String registry, NamespacedKey tag, Class<T> clazz) {
        Preconditions.checkArgument((registry != null ? 1 : 0) != 0, (Object)"registry cannot be null");
        Preconditions.checkArgument((tag != null ? 1 : 0) != 0, (Object)"NamespacedKey tag cannot be null");
        Preconditions.checkArgument((clazz != null ? 1 : 0) != 0, (Object)"Class clazz cannot be null");
        MinecraftKey key = CraftNamespacedKey.toMinecraft(tag);
        switch (registry) {
            case "blocks": {
                Preconditions.checkArgument((clazz == Material.class ? 1 : 0) != 0, (String)"Block namespace (%s) must have material type", (Object)clazz.getName());
                TagKey<Block> blockTagKey = TagKey.create(Registries.BLOCK, key);
                if (!BuiltInRegistries.BLOCK.getTag(blockTagKey).isPresent()) break;
                return new CraftBlockTag((IRegistry<Block>)BuiltInRegistries.BLOCK, blockTagKey);
            }
            case "items": {
                Preconditions.checkArgument((clazz == Material.class ? 1 : 0) != 0, (String)"Item namespace (%s) must have material type", (Object)clazz.getName());
                TagKey<Item> itemTagKey = TagKey.create(Registries.ITEM, key);
                if (!BuiltInRegistries.ITEM.getTag(itemTagKey).isPresent()) break;
                return new CraftItemTag((IRegistry<Item>)BuiltInRegistries.ITEM, itemTagKey);
            }
            case "fluids": {
                Preconditions.checkArgument((clazz == Fluid.class ? 1 : 0) != 0, (String)"Fluid namespace (%s) must have fluid type", (Object)clazz.getName());
                TagKey<FluidType> fluidTagKey = TagKey.create(Registries.FLUID, key);
                if (!BuiltInRegistries.FLUID.getTag(fluidTagKey).isPresent()) break;
                return new CraftFluidTag((IRegistry<FluidType>)BuiltInRegistries.FLUID, fluidTagKey);
            }
            case "entity_types": {
                Preconditions.checkArgument((clazz == EntityType.class ? 1 : 0) != 0, (String)"Entity type namespace (%s) must have entity type", (Object)clazz.getName());
                TagKey<EntityTypes<?>> entityTagKey = TagKey.create(Registries.ENTITY_TYPE, key);
                if (!BuiltInRegistries.ENTITY_TYPE.getTag(entityTagKey).isPresent()) break;
                return new CraftEntityTag((IRegistry<EntityTypes<?>>)BuiltInRegistries.ENTITY_TYPE, entityTagKey);
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return null;
    }

    public <T extends Keyed> Iterable<Tag<T>> getTags(String registry, Class<T> clazz) {
        Preconditions.checkArgument((registry != null ? 1 : 0) != 0, (Object)"registry cannot be null");
        Preconditions.checkArgument((clazz != null ? 1 : 0) != 0, (Object)"Class clazz cannot be null");
        switch (registry) {
            case "blocks": {
                Preconditions.checkArgument((clazz == Material.class ? 1 : 0) != 0, (String)"Block namespace (%s) must have material type", (Object)clazz.getName());
                RegistryBlocks<Block> blockTags = BuiltInRegistries.BLOCK;
                return (Iterable)blockTags.getTags().map(pair -> new CraftBlockTag((IRegistry<Block>)blockTags, (TagKey)pair.getFirst())).collect(ImmutableList.toImmutableList());
            }
            case "items": {
                Preconditions.checkArgument((clazz == Material.class ? 1 : 0) != 0, (String)"Item namespace (%s) must have material type", (Object)clazz.getName());
                RegistryBlocks<Item> itemTags = BuiltInRegistries.ITEM;
                return (Iterable)itemTags.getTags().map(pair -> new CraftItemTag((IRegistry<Item>)itemTags, (TagKey)pair.getFirst())).collect(ImmutableList.toImmutableList());
            }
            case "fluids": {
                Preconditions.checkArgument((clazz == Material.class ? 1 : 0) != 0, (String)"Fluid namespace (%s) must have fluid type", (Object)clazz.getName());
                RegistryBlocks<FluidType> fluidTags = BuiltInRegistries.FLUID;
                return (Iterable)fluidTags.getTags().map(pair -> new CraftFluidTag((IRegistry<FluidType>)fluidTags, (TagKey)pair.getFirst())).collect(ImmutableList.toImmutableList());
            }
            case "entity_types": {
                Preconditions.checkArgument((clazz == EntityType.class ? 1 : 0) != 0, (String)"Entity type namespace (%s) must have entity type", (Object)clazz.getName());
                RegistryBlocks<EntityTypes<?>> entityTags = BuiltInRegistries.ENTITY_TYPE;
                return (Iterable)entityTags.getTags().map(pair -> new CraftEntityTag((IRegistry<EntityTypes<?>>)entityTags, (TagKey)pair.getFirst())).collect(ImmutableList.toImmutableList());
            }
        }
        throw new IllegalArgumentException();
    }

    public LootTable getLootTable(NamespacedKey key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"NamespacedKey key cannot be null");
        ReloadableServerRegistries.b registry = this.getServer().reloadableRegistries();
        return registry.lookup().lookup(Registries.LOOT_TABLE).flatMap(lookup -> lookup.get(CraftLootTable.bukkitKeyToMinecraft(key))).map(holder -> new CraftLootTable(key, (net.minecraft.world.level.storage.loot.LootTable)holder.value())).orElse(null);
    }

    public List<Entity> selectEntities(CommandSender sender, String selector) {
        List<? extends net.minecraft.world.entity.Entity> nms;
        Preconditions.checkArgument((selector != null ? 1 : 0) != 0, (Object)"selector cannot be null");
        Preconditions.checkArgument((sender != null ? 1 : 0) != 0, (Object)"CommandSender sender cannot be null");
        ArgumentEntity arg = ArgumentEntity.entities();
        try {
            StringReader reader = new StringReader(selector);
            nms = arg.parse(reader, true, true).findEntities(VanillaCommandWrapper.getListener(sender));
            Preconditions.checkArgument((!reader.canRead() ? 1 : 0) != 0, (String)"Spurious trailing data in selector: %s", (Object)selector);
        }
        catch (CommandSyntaxException ex) {
            throw new IllegalArgumentException("Could not parse selector: " + selector, ex);
        }
        return new ArrayList<Entity>(Lists.transform(nms, entity -> entity.getBukkitEntity()));
    }

    public StructureManager getStructureManager() {
        return this.structureManager;
    }

    public <T extends Keyed> Registry<T> getRegistry(Class<T> aClass) {
        return this.registries.computeIfAbsent(aClass, key -> CraftRegistry.createRegistry(aClass, this.console.registryAccess()));
    }

    @Deprecated
    public UnsafeValues getUnsafe() {
        return CraftMagicNumbers.INSTANCE;
    }

    public Server.Spigot spigot() {
        return this.spigot;
    }

    static {
        ConfigurationSerialization.registerClass(CraftOfflinePlayer.class);
        ConfigurationSerialization.registerClass(CraftPlayerProfile.class);
        CraftItemFactory.instance();
        CraftEntityFactory.instance();
    }
}

