/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1;

import java.util.HashMap;
import net.minecraft.world.level.block.SoundEffectType;
import org.bukkit.Sound;
import org.bukkit.SoundGroup;
import org.bukkit.craftbukkit.v1_21_R1.CraftSound;

public class CraftSoundGroup
implements SoundGroup {
    private final SoundEffectType handle;
    private static final HashMap<SoundEffectType, CraftSoundGroup> SOUND_GROUPS = new HashMap();

    public static SoundGroup getSoundGroup(SoundEffectType soundEffectType) {
        return SOUND_GROUPS.computeIfAbsent(soundEffectType, CraftSoundGroup::new);
    }

    private CraftSoundGroup(SoundEffectType soundEffectType) {
        this.handle = soundEffectType;
    }

    public SoundEffectType getHandle() {
        return this.handle;
    }

    public float getVolume() {
        return this.getHandle().getVolume();
    }

    public float getPitch() {
        return this.getHandle().getPitch();
    }

    public Sound getBreakSound() {
        return CraftSound.minecraftToBukkit(this.getHandle().breakSound);
    }

    public Sound getStepSound() {
        return CraftSound.minecraftToBukkit(this.getHandle().getStepSound());
    }

    public Sound getPlaceSound() {
        return CraftSound.minecraftToBukkit(this.getHandle().getPlaceSound());
    }

    public Sound getHitSound() {
        return CraftSound.minecraftToBukkit(this.getHandle().hitSound);
    }

    public Sound getFallSound() {
        return CraftSound.minecraftToBukkit(this.getHandle().getFallSound());
    }
}

