/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.block;

import java.util.Set;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.block.entity.TileEntity;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.TileState;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftLocation;
import org.bukkit.persistence.PersistentDataContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CraftBlockEntityState<T extends TileEntity>
extends CraftBlockState
implements TileState {
    private final T tileEntity;
    private final T snapshot;

    public CraftBlockEntityState(World world, T tileEntity) {
        super(world, ((TileEntity)tileEntity).getBlockPos(), ((TileEntity)tileEntity).getBlockState());
        this.tileEntity = tileEntity;
        this.snapshot = this.createSnapshot(tileEntity);
        this.load(this.snapshot);
    }

    protected CraftBlockEntityState(CraftBlockEntityState<T> state, Location location) {
        super(state, location);
        this.tileEntity = this.createSnapshot(state.snapshot);
        this.snapshot = this.tileEntity;
        this.loadData(state.getSnapshotNBT());
    }

    public void refreshSnapshot() {
        this.load(this.tileEntity);
    }

    private IRegistryCustom getRegistryAccess() {
        GeneratorAccess worldHandle = this.getWorldHandle();
        return worldHandle != null ? worldHandle.registryAccess() : MinecraftServer.getDefaultRegistryAccess();
    }

    private T createSnapshot(T tileEntity) {
        if (tileEntity == null) {
            return null;
        }
        NBTTagCompound nbtTagCompound = ((TileEntity)tileEntity).saveWithFullMetadata(this.getRegistryAccess());
        TileEntity snapshot = TileEntity.loadStatic(this.getPosition(), this.getHandle(), nbtTagCompound, this.getRegistryAccess());
        return (T)snapshot;
    }

    public Set<DataComponentType<?>> applyComponents(DataComponentMap datacomponentmap, DataComponentPatch datacomponentpatch) {
        Set<DataComponentType<?>> result = ((TileEntity)this.snapshot).applyComponentsSet(datacomponentmap, datacomponentpatch);
        this.load(this.snapshot);
        return result;
    }

    public DataComponentMap collectComponents() {
        return ((TileEntity)this.snapshot).collectComponents();
    }

    public void loadData(NBTTagCompound nbtTagCompound) {
        ((TileEntity)this.snapshot).loadWithComponents(nbtTagCompound, this.getRegistryAccess());
        this.load(this.snapshot);
    }

    private void copyData(T from, T to) {
        NBTTagCompound nbtTagCompound = ((TileEntity)from).saveWithFullMetadata(this.getRegistryAccess());
        ((TileEntity)to).loadWithComponents(nbtTagCompound, this.getRegistryAccess());
    }

    protected T getTileEntity() {
        return this.tileEntity;
    }

    protected T getSnapshot() {
        return this.snapshot;
    }

    protected TileEntity getTileEntityFromWorld() {
        this.requirePlaced();
        return this.getWorldHandle().getBlockEntity(this.getPosition());
    }

    public NBTTagCompound getSnapshotNBT() {
        this.applyTo(this.snapshot);
        return ((TileEntity)this.snapshot).saveWithFullMetadata(this.getRegistryAccess());
    }

    public NBTTagCompound getItemNBT() {
        this.applyTo(this.snapshot);
        NBTTagCompound nbt = ((TileEntity)this.snapshot).saveCustomOnly(this.getRegistryAccess());
        ((TileEntity)this.snapshot).removeComponentsFromTag(nbt);
        return nbt;
    }

    public void addEntityType(NBTTagCompound nbt) {
        TileEntity.addEntityType(nbt, ((TileEntity)this.snapshot).getType());
    }

    public NBTTagCompound getUpdateNBT() {
        this.applyTo(this.snapshot);
        return ((TileEntity)this.snapshot).getUpdateTag(this.getRegistryAccess());
    }

    protected void load(T tileEntity) {
        if (tileEntity != null && tileEntity != this.snapshot) {
            this.copyData(tileEntity, this.snapshot);
        }
    }

    protected void applyTo(T tileEntity) {
        if (tileEntity != null && tileEntity != this.snapshot) {
            this.copyData(this.snapshot, tileEntity);
        }
    }

    protected boolean isApplicable(TileEntity tileEntity) {
        return tileEntity != null && this.tileEntity.getClass() == tileEntity.getClass();
    }

    @Override
    public boolean update(boolean force, boolean applyPhysics) {
        TileEntity tile;
        boolean result = super.update(force, applyPhysics);
        if (result && this.isPlaced() && this.isApplicable(tile = this.getTileEntityFromWorld())) {
            this.applyTo(tile);
            tile.setChanged();
        }
        return result;
    }

    public PersistentDataContainer getPersistentDataContainer() {
        return ((TileEntity)this.getSnapshot()).persistentDataContainer;
    }

    @Nullable
    public Packet<PacketListenerPlayOut> getUpdatePacket(@NotNull Location location) {
        return new PacketPlayOutTileEntityData(CraftLocation.toBlockPosition(location), ((TileEntity)this.snapshot).getType(), this.getUpdateNBT());
    }

    @Override
    public CraftBlockEntityState<T> copy() {
        return new CraftBlockEntityState<T>(this, null);
    }

    @Override
    public CraftBlockEntityState<T> copy(Location location) {
        return new CraftBlockEntityState<T>(this, location);
    }
}

