/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.block;

import net.minecraft.world.ChestLock;
import net.minecraft.world.level.block.entity.TileEntityContainer;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Container;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftChatMessage;

public abstract class CraftContainer<T extends TileEntityContainer>
extends CraftBlockEntityState<T>
implements Container {
    public CraftContainer(World world, T tileEntity) {
        super(world, tileEntity);
    }

    protected CraftContainer(CraftContainer<T> state, Location location) {
        super(state, location);
    }

    public boolean isLocked() {
        return !((TileEntityContainer)this.getSnapshot()).lockKey.key().isEmpty();
    }

    public String getLock() {
        return ((TileEntityContainer)this.getSnapshot()).lockKey.key();
    }

    public void setLock(String key) {
        ((TileEntityContainer)this.getSnapshot()).lockKey = key == null ? ChestLock.NO_LOCK : new ChestLock(key);
    }

    public String getCustomName() {
        TileEntityContainer container = (TileEntityContainer)this.getSnapshot();
        return container.name != null ? CraftChatMessage.fromComponent(container.getCustomName()) : null;
    }

    public void setCustomName(String name) {
        ((TileEntityContainer)this.getSnapshot()).name = CraftChatMessage.fromStringOrNull(name);
    }

    @Override
    public void applyTo(T container) {
        super.applyTo(container);
        if (((TileEntityContainer)this.getSnapshot()).name == null) {
            ((TileEntityContainer)container).name = null;
        }
    }

    @Override
    public abstract CraftContainer<T> copy();

    @Override
    public abstract CraftContainer<T> copy(Location var1);
}

