/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.block;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.InclusiveRange;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EquipmentTable;
import net.minecraft.world.level.MobSpawnerAbstract;
import net.minecraft.world.level.MobSpawnerData;
import net.minecraft.world.level.block.entity.TileEntityMobSpawner;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.spawner.SpawnRule;
import org.bukkit.block.spawner.SpawnerEntry;
import org.bukkit.craftbukkit.v1_21_R1.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_21_R1.CraftLootTable;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftEntitySnapshot;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftEntityType;
import org.bukkit.entity.EntitySnapshot;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.EquipmentSlot;

public class CraftCreatureSpawner
extends CraftBlockEntityState<TileEntityMobSpawner>
implements CreatureSpawner {
    public CraftCreatureSpawner(World world, TileEntityMobSpawner tileEntity) {
        super(world, tileEntity);
    }

    protected CraftCreatureSpawner(CraftCreatureSpawner state, Location location) {
        super(state, location);
    }

    public EntityType getSpawnedType() {
        MobSpawnerData spawnData = ((TileEntityMobSpawner)this.getSnapshot()).getSpawner().nextSpawnData;
        if (spawnData == null) {
            return null;
        }
        Optional<EntityTypes<?>> type = EntityTypes.by(spawnData.getEntityToSpawn());
        return type.map(CraftEntityType::minecraftToBukkit).orElse(null);
    }

    public void setSpawnedType(EntityType entityType) {
        if (entityType == null) {
            ((TileEntityMobSpawner)this.getSnapshot()).getSpawner().spawnPotentials = SimpleWeightedRandomList.empty();
            ((TileEntityMobSpawner)this.getSnapshot()).getSpawner().nextSpawnData = new MobSpawnerData();
            return;
        }
        Preconditions.checkArgument((entityType != EntityType.UNKNOWN ? 1 : 0) != 0, (String)"Can't spawn EntityType %s from mob spawners!", (Object)entityType);
        RandomSource rand = this.isPlaced() ? this.getWorldHandle().getRandom() : RandomSource.create();
        ((TileEntityMobSpawner)this.getSnapshot()).setEntityId(CraftEntityType.bukkitToMinecraft(entityType), rand);
    }

    public EntitySnapshot getSpawnedEntity() {
        MobSpawnerData spawnData = ((TileEntityMobSpawner)this.getSnapshot()).getSpawner().nextSpawnData;
        if (spawnData == null) {
            return null;
        }
        return CraftEntitySnapshot.create(spawnData.getEntityToSpawn());
    }

    public void setSpawnedEntity(EntitySnapshot snapshot) {
        CraftCreatureSpawner.setSpawnedEntity(((TileEntityMobSpawner)this.getSnapshot()).getSpawner(), snapshot, null, null);
    }

    public void setSpawnedEntity(SpawnerEntry spawnerEntry) {
        Preconditions.checkArgument((spawnerEntry != null ? 1 : 0) != 0, (Object)"Entry cannot be null");
        CraftCreatureSpawner.setSpawnedEntity(((TileEntityMobSpawner)this.getSnapshot()).getSpawner(), spawnerEntry.getSnapshot(), spawnerEntry.getSpawnRule(), spawnerEntry.getEquipment());
    }

    public static void setSpawnedEntity(MobSpawnerAbstract spawner, EntitySnapshot snapshot, SpawnRule spawnRule, SpawnerEntry.Equipment equipment) {
        spawner.spawnPotentials = SimpleWeightedRandomList.empty();
        if (snapshot == null) {
            spawner.nextSpawnData = new MobSpawnerData();
            return;
        }
        NBTTagCompound compoundTag = ((CraftEntitySnapshot)snapshot).getData();
        spawner.nextSpawnData = new MobSpawnerData(compoundTag, Optional.ofNullable(CraftCreatureSpawner.toMinecraftRule(spawnRule)), CraftCreatureSpawner.getEquipment(equipment));
    }

    public void addPotentialSpawn(EntitySnapshot snapshot, int weight, SpawnRule spawnRule) {
        CraftCreatureSpawner.addPotentialSpawn(((TileEntityMobSpawner)this.getSnapshot()).getSpawner(), snapshot, weight, spawnRule, null);
    }

    public static void addPotentialSpawn(MobSpawnerAbstract spawner, EntitySnapshot snapshot, int weight, SpawnRule spawnRule, SpawnerEntry.Equipment equipment) {
        Preconditions.checkArgument((snapshot != null ? 1 : 0) != 0, (Object)"Snapshot cannot be null");
        NBTTagCompound compoundTag = ((CraftEntitySnapshot)snapshot).getData();
        SimpleWeightedRandomList.a<MobSpawnerData> builder = SimpleWeightedRandomList.builder();
        spawner.spawnPotentials.unwrap().forEach(entry -> builder.add((MobSpawnerData)entry.data(), entry.getWeight().asInt()));
        builder.add(new MobSpawnerData(compoundTag, Optional.ofNullable(CraftCreatureSpawner.toMinecraftRule(spawnRule)), CraftCreatureSpawner.getEquipment(equipment)), weight);
        spawner.spawnPotentials = builder.build();
    }

    public void addPotentialSpawn(SpawnerEntry spawnerEntry) {
        Preconditions.checkArgument((spawnerEntry != null ? 1 : 0) != 0, (Object)"Entry cannot be null");
        this.addPotentialSpawn(spawnerEntry.getSnapshot(), spawnerEntry.getSpawnWeight(), spawnerEntry.getSpawnRule());
    }

    public void setPotentialSpawns(Collection<SpawnerEntry> entries) {
        CraftCreatureSpawner.setPotentialSpawns(((TileEntityMobSpawner)this.getSnapshot()).getSpawner(), entries);
    }

    public static void setPotentialSpawns(MobSpawnerAbstract spawner, Collection<SpawnerEntry> entries) {
        Preconditions.checkArgument((entries != null ? 1 : 0) != 0, (Object)"Entries cannot be null");
        SimpleWeightedRandomList.a<MobSpawnerData> builder = SimpleWeightedRandomList.builder();
        for (SpawnerEntry spawnerEntry : entries) {
            NBTTagCompound compoundTag = ((CraftEntitySnapshot)spawnerEntry.getSnapshot()).getData();
            builder.add(new MobSpawnerData(compoundTag, Optional.ofNullable(CraftCreatureSpawner.toMinecraftRule(spawnerEntry.getSpawnRule())), CraftCreatureSpawner.getEquipment(spawnerEntry.getEquipment())), spawnerEntry.getSpawnWeight());
        }
        spawner.spawnPotentials = builder.build();
    }

    public List<SpawnerEntry> getPotentialSpawns() {
        return CraftCreatureSpawner.getPotentialSpawns(((TileEntityMobSpawner)this.getSnapshot()).getSpawner());
    }

    public static List<SpawnerEntry> getPotentialSpawns(MobSpawnerAbstract spawner) {
        ArrayList<SpawnerEntry> entries = new ArrayList<SpawnerEntry>();
        for (WeightedEntry.b entry : spawner.spawnPotentials.unwrap()) {
            CraftEntitySnapshot snapshot = CraftEntitySnapshot.create(((MobSpawnerData)entry.data()).getEntityToSpawn());
            if (snapshot == null) continue;
            SpawnRule rule = ((MobSpawnerData)entry.data()).customSpawnRules().map(CraftCreatureSpawner::fromMinecraftRule).orElse(null);
            entries.add(new SpawnerEntry((EntitySnapshot)snapshot, entry.getWeight().asInt(), rule, CraftCreatureSpawner.getEquipment(((MobSpawnerData)entry.data()).equipment())));
        }
        return entries;
    }

    public static MobSpawnerData.a toMinecraftRule(SpawnRule rule) {
        if (rule == null) {
            return null;
        }
        return new MobSpawnerData.a(new InclusiveRange<Integer>(rule.getMinBlockLight(), rule.getMaxBlockLight()), new InclusiveRange<Integer>(rule.getMinSkyLight(), rule.getMaxSkyLight()));
    }

    public static SpawnRule fromMinecraftRule(MobSpawnerData.a rule) {
        InclusiveRange<Integer> blockLight = rule.blockLightLimit();
        InclusiveRange<Integer> skyLight = rule.skyLightLimit();
        return new SpawnRule(blockLight.maxInclusive().intValue(), blockLight.maxInclusive().intValue(), skyLight.minInclusive().intValue(), skyLight.maxInclusive().intValue());
    }

    public String getCreatureTypeName() {
        MobSpawnerData spawnData = ((TileEntityMobSpawner)this.getSnapshot()).getSpawner().nextSpawnData;
        if (spawnData == null) {
            return null;
        }
        Optional<EntityTypes<?>> type = EntityTypes.by(spawnData.getEntityToSpawn());
        return type.map(CraftEntityType::minecraftToBukkit).map(CraftEntityType::bukkitToString).orElse(null);
    }

    public void setCreatureTypeByName(String creatureType) {
        EntityType type = CraftEntityType.stringToBukkit(creatureType);
        if (type == null) {
            this.setSpawnedType(null);
            return;
        }
        this.setSpawnedType(type);
    }

    public int getDelay() {
        return ((TileEntityMobSpawner)this.getSnapshot()).getSpawner().spawnDelay;
    }

    public void setDelay(int delay) {
        ((TileEntityMobSpawner)this.getSnapshot()).getSpawner().spawnDelay = delay;
    }

    public int getMinSpawnDelay() {
        return ((TileEntityMobSpawner)this.getSnapshot()).getSpawner().minSpawnDelay;
    }

    public void setMinSpawnDelay(int spawnDelay) {
        Preconditions.checkArgument((spawnDelay <= this.getMaxSpawnDelay() ? 1 : 0) != 0, (Object)"Minimum Spawn Delay must be less than or equal to Maximum Spawn Delay");
        ((TileEntityMobSpawner)this.getSnapshot()).getSpawner().minSpawnDelay = spawnDelay;
    }

    public int getMaxSpawnDelay() {
        return ((TileEntityMobSpawner)this.getSnapshot()).getSpawner().maxSpawnDelay;
    }

    public void setMaxSpawnDelay(int spawnDelay) {
        Preconditions.checkArgument((spawnDelay > 0 ? 1 : 0) != 0, (Object)"Maximum Spawn Delay must be greater than 0.");
        Preconditions.checkArgument((spawnDelay >= this.getMinSpawnDelay() ? 1 : 0) != 0, (Object)"Maximum Spawn Delay must be greater than or equal to Minimum Spawn Delay");
        ((TileEntityMobSpawner)this.getSnapshot()).getSpawner().maxSpawnDelay = spawnDelay;
    }

    public int getMaxNearbyEntities() {
        return ((TileEntityMobSpawner)this.getSnapshot()).getSpawner().maxNearbyEntities;
    }

    public void setMaxNearbyEntities(int maxNearbyEntities) {
        ((TileEntityMobSpawner)this.getSnapshot()).getSpawner().maxNearbyEntities = maxNearbyEntities;
    }

    public int getSpawnCount() {
        return ((TileEntityMobSpawner)this.getSnapshot()).getSpawner().spawnCount;
    }

    public void setSpawnCount(int count) {
        ((TileEntityMobSpawner)this.getSnapshot()).getSpawner().spawnCount = count;
    }

    public int getRequiredPlayerRange() {
        return ((TileEntityMobSpawner)this.getSnapshot()).getSpawner().requiredPlayerRange;
    }

    public void setRequiredPlayerRange(int requiredPlayerRange) {
        ((TileEntityMobSpawner)this.getSnapshot()).getSpawner().requiredPlayerRange = requiredPlayerRange;
    }

    public int getSpawnRange() {
        return ((TileEntityMobSpawner)this.getSnapshot()).getSpawner().spawnRange;
    }

    public void setSpawnRange(int spawnRange) {
        ((TileEntityMobSpawner)this.getSnapshot()).getSpawner().spawnRange = spawnRange;
    }

    @Override
    public CraftCreatureSpawner copy() {
        return new CraftCreatureSpawner(this, null);
    }

    @Override
    public CraftCreatureSpawner copy(Location location) {
        return new CraftCreatureSpawner(this, location);
    }

    public static Optional<EquipmentTable> getEquipment(SpawnerEntry.Equipment bukkit) {
        if (bukkit == null) {
            return Optional.empty();
        }
        return Optional.of(new EquipmentTable(CraftLootTable.bukkitToMinecraft(bukkit.getEquipmentLootTable()), bukkit.getDropChances().entrySet().stream().collect(Collectors.toMap(entry -> CraftEquipmentSlot.getNMS((EquipmentSlot)entry.getKey()), Map.Entry::getValue))));
    }

    public static SpawnerEntry.Equipment getEquipment(Optional<EquipmentTable> optional) {
        return optional.map(nms -> new SpawnerEntry.Equipment(CraftLootTable.minecraftToBukkit(nms.lootTable()), new HashMap<EquipmentSlot, Float>(nms.slotDropChances().entrySet().stream().collect(Collectors.toMap(entry -> CraftEquipmentSlot.getSlot((EnumItemSlot)entry.getKey()), Map.Entry::getValue))))).orElse(null);
    }
}

