/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.block;

import java.util.Objects;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.level.block.entity.TileEntityEndGateway;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.EndGateway;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftLocation;

public class CraftEndGateway
extends CraftBlockEntityState<TileEntityEndGateway>
implements EndGateway {
    public CraftEndGateway(World world, TileEntityEndGateway tileEntity) {
        super(world, tileEntity);
    }

    protected CraftEndGateway(CraftEndGateway state, Location location) {
        super(state, location);
    }

    public Location getExitLocation() {
        BlockPosition pos = ((TileEntityEndGateway)this.getSnapshot()).exitPortal;
        return pos == null ? null : CraftLocation.toBukkit(pos, this.isPlaced() ? this.getWorld() : null);
    }

    public void setExitLocation(Location location) {
        if (location == null) {
            ((TileEntityEndGateway)this.getSnapshot()).exitPortal = null;
        } else {
            if (!Objects.equals(location.getWorld(), this.isPlaced() ? this.getWorld() : null)) {
                throw new IllegalArgumentException("Cannot set exit location to different world");
            }
            ((TileEntityEndGateway)this.getSnapshot()).exitPortal = CraftLocation.toBlockPosition(location);
        }
    }

    public boolean isExactTeleport() {
        return ((TileEntityEndGateway)this.getSnapshot()).exactTeleport;
    }

    public void setExactTeleport(boolean exact) {
        ((TileEntityEndGateway)this.getSnapshot()).exactTeleport = exact;
    }

    public long getAge() {
        return ((TileEntityEndGateway)this.getSnapshot()).age;
    }

    public void setAge(long age) {
        ((TileEntityEndGateway)this.getSnapshot()).age = age;
    }

    @Override
    public void applyTo(TileEntityEndGateway endGateway) {
        super.applyTo(endGateway);
        if (((TileEntityEndGateway)this.getSnapshot()).exitPortal == null) {
            endGateway.exitPortal = null;
        }
    }

    @Override
    public CraftEndGateway copy() {
        return new CraftEndGateway(this, null);
    }

    @Override
    public CraftEndGateway copy(Location location) {
        return new CraftEndGateway(this, location);
    }
}

