/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.block;

import net.minecraft.world.level.block.entity.TileEntityLootable;
import org.bukkit.Location;
import org.bukkit.Nameable;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R1.CraftLootTable;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftContainer;
import org.bukkit.loot.LootTable;
import org.bukkit.loot.Lootable;

public abstract class CraftLootable<T extends TileEntityLootable>
extends CraftContainer<T>
implements Nameable,
Lootable {
    public CraftLootable(World world, T tileEntity) {
        super(world, tileEntity);
    }

    protected CraftLootable(CraftLootable<T> state, Location location) {
        super(state, location);
    }

    @Override
    public void applyTo(T lootable) {
        super.applyTo(lootable);
        if (((TileEntityLootable)this.getSnapshot()).lootTable == null) {
            lootable.setLootTable(null, 0L);
        }
    }

    public LootTable getLootTable() {
        return CraftLootTable.minecraftToBukkit(((TileEntityLootable)this.getSnapshot()).lootTable);
    }

    public void setLootTable(LootTable table) {
        this.setLootTable(table, this.getSeed());
    }

    public long getSeed() {
        return ((TileEntityLootable)this.getSnapshot()).lootTableSeed;
    }

    public void setSeed(long seed) {
        this.setLootTable(this.getLootTable(), seed);
    }

    private void setLootTable(LootTable table, long seed) {
        ((TileEntityLootable)this.getSnapshot()).setLootTable(CraftLootTable.bukkitToMinecraft(table), seed);
    }

    @Override
    public abstract CraftLootable<T> copy();

    @Override
    public abstract CraftLootable<T> copy(Location var1);
}

