/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.boss;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.protocol.game.PacketPlayOutBoss;
import net.minecraft.server.level.BossBattleServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.BossBattle;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftChatMessage;
import org.bukkit.entity.Player;

public class CraftBossBar
implements BossBar {
    private final BossBattleServer handle;
    private Map<BarFlag, FlagContainer> flags;

    public CraftBossBar(String title, BarColor color, BarStyle style, BarFlag ... flags) {
        this.handle = new BossBattleServer(CraftChatMessage.fromString(title, true)[0], this.convertColor(color), this.convertStyle(style));
        this.initialize();
        for (BarFlag flag : flags) {
            this.addFlag(flag);
        }
        this.setColor(color);
        this.setStyle(style);
    }

    public CraftBossBar(BossBattleServer bossBattleServer) {
        this.handle = bossBattleServer;
        this.initialize();
    }

    private void initialize() {
        this.flags = new HashMap<BarFlag, FlagContainer>();
        this.flags.put(BarFlag.DARKEN_SKY, new FlagContainer(this, this.handle::shouldDarkenScreen, this.handle::setDarkenScreen));
        this.flags.put(BarFlag.PLAY_BOSS_MUSIC, new FlagContainer(this, this.handle::shouldPlayBossMusic, this.handle::setPlayBossMusic));
        this.flags.put(BarFlag.CREATE_FOG, new FlagContainer(this, this.handle::shouldCreateWorldFog, this.handle::setCreateWorldFog));
    }

    private BarColor convertColor(BossBattle.BarColor color) {
        BarColor bukkitColor = BarColor.valueOf((String)color.name());
        return bukkitColor == null ? BarColor.WHITE : bukkitColor;
    }

    private BossBattle.BarColor convertColor(BarColor color) {
        BossBattle.BarColor nmsColor = BossBattle.BarColor.valueOf(color.name());
        return nmsColor == null ? BossBattle.BarColor.WHITE : nmsColor;
    }

    private BossBattle.BarStyle convertStyle(BarStyle style) {
        switch (style) {
            default: {
                return BossBattle.BarStyle.PROGRESS;
            }
            case SEGMENTED_6: {
                return BossBattle.BarStyle.NOTCHED_6;
            }
            case SEGMENTED_10: {
                return BossBattle.BarStyle.NOTCHED_10;
            }
            case SEGMENTED_12: {
                return BossBattle.BarStyle.NOTCHED_12;
            }
            case SEGMENTED_20: 
        }
        return BossBattle.BarStyle.NOTCHED_20;
    }

    private BarStyle convertStyle(BossBattle.BarStyle style) {
        switch (style) {
            default: {
                return BarStyle.SOLID;
            }
            case NOTCHED_6: {
                return BarStyle.SEGMENTED_6;
            }
            case NOTCHED_10: {
                return BarStyle.SEGMENTED_10;
            }
            case NOTCHED_12: {
                return BarStyle.SEGMENTED_12;
            }
            case NOTCHED_20: 
        }
        return BarStyle.SEGMENTED_20;
    }

    public String getTitle() {
        return CraftChatMessage.fromComponent(this.handle.name);
    }

    public void setTitle(String title) {
        this.handle.name = CraftChatMessage.fromString(title, true)[0];
        this.handle.broadcast(PacketPlayOutBoss::createUpdateNamePacket);
    }

    public BarColor getColor() {
        return this.convertColor(this.handle.color);
    }

    public void setColor(BarColor color) {
        this.handle.color = this.convertColor(color);
        this.handle.broadcast(PacketPlayOutBoss::createUpdateStylePacket);
    }

    public BarStyle getStyle() {
        return this.convertStyle(this.handle.overlay);
    }

    public void setStyle(BarStyle style) {
        this.handle.overlay = this.convertStyle(style);
        this.handle.broadcast(PacketPlayOutBoss::createUpdateStylePacket);
    }

    public void addFlag(BarFlag flag) {
        FlagContainer flagContainer = this.flags.get(flag);
        if (flagContainer != null) {
            flagContainer.set.accept(true);
        }
    }

    public void removeFlag(BarFlag flag) {
        FlagContainer flagContainer = this.flags.get(flag);
        if (flagContainer != null) {
            flagContainer.set.accept(false);
        }
    }

    public boolean hasFlag(BarFlag flag) {
        FlagContainer flagContainer = this.flags.get(flag);
        if (flagContainer != null) {
            return flagContainer.get.get();
        }
        return false;
    }

    public void setProgress(double progress) {
        Preconditions.checkArgument((progress >= 0.0 && progress <= 1.0 ? 1 : 0) != 0, (String)"Progress must be between 0.0 and 1.0 (%s)", (Object)progress);
        this.handle.setProgress((float)progress);
    }

    public double getProgress() {
        return this.handle.getProgress();
    }

    public void addPlayer(Player player) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"player == null");
        Preconditions.checkArgument((((CraftPlayer)player).getHandle().connection != null ? 1 : 0) != 0, (Object)"player is not fully connected (wait for PlayerJoinEvent)");
        this.handle.addPlayer(((CraftPlayer)player).getHandle());
    }

    public void removePlayer(Player player) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"player == null");
        this.handle.removePlayer(((CraftPlayer)player).getHandle());
    }

    public List<Player> getPlayers() {
        ImmutableList.Builder players = ImmutableList.builder();
        for (EntityPlayer p2 : this.handle.getPlayers()) {
            players.add((Object)p2.getBukkitEntity());
        }
        return players.build();
    }

    public void setVisible(boolean visible) {
        this.handle.setVisible(visible);
    }

    public boolean isVisible() {
        return this.handle.visible;
    }

    public void show() {
        this.handle.setVisible(true);
    }

    public void hide() {
        this.handle.setVisible(false);
    }

    public void removeAll() {
        for (Player player : this.getPlayers()) {
            this.removePlayer(player);
        }
    }

    public BossBattleServer getHandle() {
        return this.handle;
    }

    private final class FlagContainer {
        private Supplier<Boolean> get;
        private Consumer<Boolean> set;

        private FlagContainer(CraftBossBar craftBossBar, Supplier<Boolean> get, Consumer<Boolean> set) {
            this.get = get;
            this.set = set;
        }
    }
}

