/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.entity;

import com.google.common.base.Preconditions;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.entity.projectile.EntityArrow;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_21_R1.CraftServer;
import org.bukkit.craftbukkit.v1_21_R1.entity.AbstractProjectile;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.projectiles.ProjectileSource;

public class CraftAbstractArrow
extends AbstractProjectile
implements AbstractArrow {
    public CraftAbstractArrow(CraftServer server, EntityArrow entity) {
        super(server, entity);
    }

    public void setKnockbackStrength(int knockbackStrength) {
    }

    public int getKnockbackStrength() {
        return 0;
    }

    public double getDamage() {
        return this.getHandle().getBaseDamage();
    }

    public void setDamage(double damage) {
        Preconditions.checkArgument((damage >= 0.0 ? 1 : 0) != 0, (String)"Damage value (%s) must be positive", (Object)damage);
        this.getHandle().setBaseDamage(damage);
    }

    public int getPierceLevel() {
        return this.getHandle().getPierceLevel();
    }

    public void setPierceLevel(int pierceLevel) {
        Preconditions.checkArgument((0 <= pierceLevel && pierceLevel <= 127 ? 1 : 0) != 0, (String)"Pierce level (%s) out of range, expected 0 < level < 127", (int)pierceLevel);
        this.getHandle().setPierceLevel((byte)pierceLevel);
    }

    public boolean isCritical() {
        return this.getHandle().isCritArrow();
    }

    public void setCritical(boolean critical) {
        this.getHandle().setCritArrow(critical);
    }

    public ProjectileSource getShooter() {
        return this.getHandle().projectileSource;
    }

    public void setShooter(ProjectileSource shooter) {
        if (shooter instanceof Entity) {
            this.getHandle().setOwner(((CraftEntity)shooter).getHandle());
        } else {
            this.getHandle().setOwner(null);
        }
        this.getHandle().projectileSource = shooter;
    }

    public boolean isInBlock() {
        return this.getHandle().inGround;
    }

    public Block getAttachedBlock() {
        if (!this.isInBlock()) {
            return null;
        }
        BlockPosition pos = this.getHandle().blockPosition();
        return this.getWorld().getBlockAt(pos.getX(), pos.getY(), pos.getZ());
    }

    public AbstractArrow.PickupStatus getPickupStatus() {
        return AbstractArrow.PickupStatus.values()[this.getHandle().pickup.ordinal()];
    }

    public void setPickupStatus(AbstractArrow.PickupStatus status) {
        Preconditions.checkArgument((status != null ? 1 : 0) != 0, (Object)"PickupStatus cannot be null");
        this.getHandle().pickup = EntityArrow.PickupStatus.byOrdinal(status.ordinal());
    }

    @Override
    public void setTicksLived(int value) {
        super.setTicksLived(value);
        this.getHandle().life = value;
    }

    public boolean isShotFromCrossbow() {
        return this.getHandle().shotFromCrossbow();
    }

    public void setShotFromCrossbow(boolean shotFromCrossbow) {
    }

    public ItemStack getItem() {
        return CraftItemStack.asBukkitCopy(this.getHandle().pickupItemStack);
    }

    public void setItem(ItemStack item) {
        Preconditions.checkArgument((item != null ? 1 : 0) != 0, (Object)"ItemStack cannot be null");
        this.getHandle().pickupItemStack = CraftItemStack.asNMSCopy(item);
    }

    public ItemStack getWeapon() {
        return CraftItemStack.asBukkitCopy(this.getHandle().getWeaponItem());
    }

    public void setWeapon(ItemStack item) {
        Preconditions.checkArgument((item != null ? 1 : 0) != 0, (Object)"ItemStack cannot be null");
        this.getHandle().firedFromWeapon = CraftItemStack.asNMSCopy(item);
    }

    @Override
    public EntityArrow getHandle() {
        return (EntityArrow)this.entity;
    }

    @Override
    public String toString() {
        return "CraftArrow";
    }
}

