/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.entity;

import com.google.common.base.Preconditions;
import java.util.stream.Collectors;
import net.minecraft.world.entity.vehicle.EntityBoat;
import org.bukkit.TreeSpecies;
import org.bukkit.craftbukkit.v1_21_R1.CraftServer;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftVehicle;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Entity;

public class CraftBoat
extends CraftVehicle
implements Boat {
    public CraftBoat(CraftServer server, EntityBoat entity) {
        super(server, entity);
    }

    public TreeSpecies getWoodType() {
        return CraftBoat.getTreeSpecies(this.getHandle().getVariant());
    }

    public void setWoodType(TreeSpecies species) {
        this.getHandle().setVariant(CraftBoat.getBoatType(species));
    }

    public Boat.Type getBoatType() {
        return CraftBoat.boatTypeFromNms(this.getHandle().getVariant());
    }

    public void setBoatType(Boat.Type type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"Boat.Type cannot be null");
        this.getHandle().setVariant(CraftBoat.boatTypeToNms(type));
    }

    public double getMaxSpeed() {
        return this.getHandle().maxSpeed;
    }

    public void setMaxSpeed(double speed) {
        if (speed >= 0.0) {
            this.getHandle().maxSpeed = speed;
        }
    }

    public double getOccupiedDeceleration() {
        return this.getHandle().occupiedDeceleration;
    }

    public void setOccupiedDeceleration(double speed) {
        if (speed >= 0.0) {
            this.getHandle().occupiedDeceleration = speed;
        }
    }

    public double getUnoccupiedDeceleration() {
        return this.getHandle().unoccupiedDeceleration;
    }

    public void setUnoccupiedDeceleration(double speed) {
        this.getHandle().unoccupiedDeceleration = speed;
    }

    public boolean getWorkOnLand() {
        return this.getHandle().landBoats;
    }

    public void setWorkOnLand(boolean workOnLand) {
        this.getHandle().landBoats = workOnLand;
    }

    public Boat.Status getStatus() {
        return CraftBoat.boatStatusFromNms(this.getHandle().status);
    }

    @Override
    public EntityBoat getHandle() {
        return (EntityBoat)this.entity;
    }

    @Override
    public String toString() {
        return "CraftBoat{boatType=" + String.valueOf(this.getBoatType()) + ",status=" + String.valueOf(this.getStatus()) + ",passengers=" + this.getPassengers().stream().map(Entity::toString).collect(Collectors.joining("-", "{", "}")) + "}";
    }

    public static Boat.Type boatTypeFromNms(EntityBoat.EnumBoatType boatType) {
        return switch (boatType) {
            default -> throw new EnumConstantNotPresentException(Boat.Type.class, boatType.name());
            case EntityBoat.EnumBoatType.OAK -> Boat.Type.OAK;
            case EntityBoat.EnumBoatType.BIRCH -> Boat.Type.BIRCH;
            case EntityBoat.EnumBoatType.ACACIA -> Boat.Type.ACACIA;
            case EntityBoat.EnumBoatType.CHERRY -> Boat.Type.CHERRY;
            case EntityBoat.EnumBoatType.JUNGLE -> Boat.Type.JUNGLE;
            case EntityBoat.EnumBoatType.SPRUCE -> Boat.Type.SPRUCE;
            case EntityBoat.EnumBoatType.DARK_OAK -> Boat.Type.DARK_OAK;
            case EntityBoat.EnumBoatType.MANGROVE -> Boat.Type.MANGROVE;
            case EntityBoat.EnumBoatType.BAMBOO -> Boat.Type.BAMBOO;
        };
    }

    public static EntityBoat.EnumBoatType boatTypeToNms(Boat.Type type) {
        return switch (type) {
            default -> throw new EnumConstantNotPresentException(EntityBoat.EnumBoatType.class, type.name());
            case Boat.Type.BAMBOO -> EntityBoat.EnumBoatType.BAMBOO;
            case Boat.Type.MANGROVE -> EntityBoat.EnumBoatType.MANGROVE;
            case Boat.Type.SPRUCE -> EntityBoat.EnumBoatType.SPRUCE;
            case Boat.Type.DARK_OAK -> EntityBoat.EnumBoatType.DARK_OAK;
            case Boat.Type.JUNGLE -> EntityBoat.EnumBoatType.JUNGLE;
            case Boat.Type.CHERRY -> EntityBoat.EnumBoatType.CHERRY;
            case Boat.Type.ACACIA -> EntityBoat.EnumBoatType.ACACIA;
            case Boat.Type.BIRCH -> EntityBoat.EnumBoatType.BIRCH;
            case Boat.Type.OAK -> EntityBoat.EnumBoatType.OAK;
        };
    }

    public static Boat.Status boatStatusFromNms(EntityBoat.EnumStatus enumStatus) {
        return switch (enumStatus) {
            default -> throw new EnumConstantNotPresentException(Boat.Status.class, enumStatus.name());
            case EntityBoat.EnumStatus.IN_AIR -> Boat.Status.IN_AIR;
            case EntityBoat.EnumStatus.ON_LAND -> Boat.Status.ON_LAND;
            case EntityBoat.EnumStatus.UNDER_WATER -> Boat.Status.UNDER_WATER;
            case EntityBoat.EnumStatus.UNDER_FLOWING_WATER -> Boat.Status.UNDER_FLOWING_WATER;
            case EntityBoat.EnumStatus.IN_WATER -> Boat.Status.IN_WATER;
        };
    }

    @Deprecated
    public static TreeSpecies getTreeSpecies(EntityBoat.EnumBoatType boatType) {
        switch (boatType) {
            case SPRUCE: {
                return TreeSpecies.REDWOOD;
            }
            case BIRCH: {
                return TreeSpecies.BIRCH;
            }
            case JUNGLE: {
                return TreeSpecies.JUNGLE;
            }
            case ACACIA: {
                return TreeSpecies.ACACIA;
            }
            case DARK_OAK: {
                return TreeSpecies.DARK_OAK;
            }
        }
        return TreeSpecies.GENERIC;
    }

    @Deprecated
    public static EntityBoat.EnumBoatType getBoatType(TreeSpecies species) {
        switch (species) {
            case REDWOOD: {
                return EntityBoat.EnumBoatType.SPRUCE;
            }
            case BIRCH: {
                return EntityBoat.EnumBoatType.BIRCH;
            }
            case JUNGLE: {
                return EntityBoat.EnumBoatType.JUNGLE;
            }
            case ACACIA: {
                return EntityBoat.EnumBoatType.ACACIA;
            }
            case DARK_OAK: {
                return EntityBoat.EnumBoatType.DARK_OAK;
            }
        }
        return EntityBoat.EnumBoatType.OAK;
    }
}

