/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.entity;

import net.minecraft.core.EnumDirection;
import net.minecraft.world.entity.decoration.EntityHanging;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_21_R1.CraftServer;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftBlockAttachedEntity;
import org.bukkit.entity.Hanging;

public class CraftHanging
extends CraftBlockAttachedEntity
implements Hanging {
    public CraftHanging(CraftServer server, EntityHanging entity) {
        super(server, entity);
    }

    public BlockFace getAttachedFace() {
        return this.getFacing().getOppositeFace();
    }

    public void setFacingDirection(BlockFace face) {
        this.setFacingDirection(face, false);
    }

    public boolean setFacingDirection(BlockFace face, boolean force) {
        EntityHanging hanging = this.getHandle();
        EnumDirection dir = hanging.getDirection();
        switch (face) {
            case SOUTH: {
                this.getHandle().setDirection(EnumDirection.SOUTH);
                break;
            }
            case WEST: {
                this.getHandle().setDirection(EnumDirection.WEST);
                break;
            }
            case NORTH: {
                this.getHandle().setDirection(EnumDirection.NORTH);
                break;
            }
            case EAST: {
                this.getHandle().setDirection(EnumDirection.EAST);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("%s is not a valid facing direction", face));
            }
        }
        if (!(force || this.getHandle().generation || hanging.survives())) {
            hanging.setDirection(dir);
            return false;
        }
        return true;
    }

    @Override
    public BlockFace getFacing() {
        EnumDirection direction = this.getHandle().getDirection();
        if (direction == null) {
            return BlockFace.SELF;
        }
        return CraftBlock.notchToBlockFace(direction);
    }

    @Override
    public EntityHanging getHandle() {
        return (EntityHanging)this.entity;
    }

    @Override
    public String toString() {
        return "CraftHanging";
    }
}

