/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.entity;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayInCloseWindow;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindow;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityFireworks;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.item.ItemCooldown;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.trading.IMerchant;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_21_R1.CraftServer;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftAbstractHorse;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftAbstractVillager;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftVillager;
import org.bukkit.craftbukkit.v1_21_R1.entity.memory.CraftMemoryMapper;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftContainer;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventoryAbstractHorse;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventoryDoubleChest;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventoryLectern;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventoryPlayer;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventoryView;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemType;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftMerchantCustom;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftLocation;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftNamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Firework;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Villager;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MainHand;
import org.bukkit.inventory.Merchant;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.permissions.PermissibleBase;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.permissions.ServerOperator;
import org.bukkit.plugin.Plugin;

public class CraftHumanEntity
extends CraftLivingEntity
implements HumanEntity {
    private CraftInventoryPlayer inventory;
    private final CraftInventory enderChest;
    protected final PermissibleBase perm = new PermissibleBase((ServerOperator)this);
    private boolean op;
    private GameMode mode;

    public CraftHumanEntity(CraftServer server, EntityHuman entity) {
        super(server, entity);
        this.mode = server.getDefaultGameMode();
        this.inventory = new CraftInventoryPlayer(entity.getInventory());
        this.enderChest = new CraftInventory(entity.getEnderChestInventory());
    }

    public PlayerInventory getInventory() {
        return this.inventory;
    }

    @Override
    public EntityEquipment getEquipment() {
        return this.inventory;
    }

    public Inventory getEnderChest() {
        return this.enderChest;
    }

    public MainHand getMainHand() {
        return this.getHandle().getMainArm() == EnumMainHand.LEFT ? MainHand.LEFT : MainHand.RIGHT;
    }

    public ItemStack getItemInHand() {
        return this.getInventory().getItemInHand();
    }

    public void setItemInHand(ItemStack item) {
        this.getInventory().setItemInHand(item);
    }

    public ItemStack getItemOnCursor() {
        return CraftItemStack.asCraftMirror(this.getHandle().containerMenu.getCarried());
    }

    public void setItemOnCursor(ItemStack item) {
        net.minecraft.world.item.ItemStack stack = CraftItemStack.asNMSCopy(item);
        this.getHandle().containerMenu.setCarried(stack);
        if (this instanceof CraftPlayer) {
            this.getHandle().containerMenu.broadcastCarriedItem();
        }
    }

    public int getSleepTicks() {
        return this.getHandle().sleepCounter;
    }

    public boolean sleep(Location location, boolean force) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((location.getWorld() != null ? 1 : 0) != 0, (Object)"Location needs to be in a world");
        Preconditions.checkArgument((boolean)location.getWorld().equals((Object)this.getWorld()), (Object)"Cannot sleep across worlds");
        BlockPosition blockposition = CraftLocation.toBlockPosition(location);
        IBlockData iblockdata = this.getHandle().level().getBlockState(blockposition);
        if (!(iblockdata.getBlock() instanceof BlockBed)) {
            return false;
        }
        if (this.getHandle().startSleepInBed(blockposition, force).left().isPresent()) {
            return false;
        }
        iblockdata = (IBlockData)iblockdata.setValue(BlockBed.OCCUPIED, true);
        this.getHandle().level().setBlock(blockposition, iblockdata, 4);
        return true;
    }

    public void wakeup(boolean setSpawnLocation) {
        Preconditions.checkState((boolean)this.isSleeping(), (Object)"Cannot wakeup if not sleeping");
        this.getHandle().stopSleepInBed(true, setSpawnLocation);
    }

    public void startRiptideAttack(int duration, float damage, ItemStack attackItem) {
        Preconditions.checkArgument((duration > 0 ? 1 : 0) != 0, (Object)"Duration must be greater than 0");
        Preconditions.checkArgument((damage >= 0.0f ? 1 : 0) != 0, (Object)"Damage must not be negative");
        this.getHandle().startAutoSpinAttack(duration, damage, CraftItemStack.asNMSCopy(attackItem));
    }

    public Location getBedLocation() {
        Preconditions.checkState((boolean)this.isSleeping(), (Object)"Not sleeping");
        BlockPosition bed = this.getHandle().getSleepingPos().get();
        return CraftLocation.toBukkit(bed, this.getWorld());
    }

    @Override
    public String getName() {
        return this.getHandle().getScoreboardName();
    }

    @Override
    public boolean isOp() {
        return this.op;
    }

    @Override
    public boolean isPermissionSet(String name) {
        return this.perm.isPermissionSet(name);
    }

    @Override
    public boolean isPermissionSet(Permission perm) {
        return this.perm.isPermissionSet(perm);
    }

    @Override
    public boolean hasPermission(String name) {
        return this.perm.hasPermission(name);
    }

    @Override
    public boolean hasPermission(Permission perm) {
        return this.perm.hasPermission(perm);
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin, String name, boolean value) {
        return this.perm.addAttachment(plugin, name, value);
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin) {
        return this.perm.addAttachment(plugin);
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin, String name, boolean value, int ticks) {
        return this.perm.addAttachment(plugin, name, value, ticks);
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin, int ticks) {
        return this.perm.addAttachment(plugin, ticks);
    }

    @Override
    public void removeAttachment(PermissionAttachment attachment) {
        this.perm.removeAttachment(attachment);
    }

    @Override
    public void recalculatePermissions() {
        this.perm.recalculatePermissions();
    }

    @Override
    public void setOp(boolean value) {
        this.op = value;
        this.perm.recalculatePermissions();
    }

    @Override
    public Set<PermissionAttachmentInfo> getEffectivePermissions() {
        return this.perm.getEffectivePermissions();
    }

    public GameMode getGameMode() {
        return this.mode;
    }

    public void setGameMode(GameMode mode) {
        Preconditions.checkArgument((mode != null ? 1 : 0) != 0, (Object)"GameMode cannot be null");
        this.mode = mode;
    }

    @Override
    public EntityHuman getHandle() {
        return (EntityHuman)this.entity;
    }

    public void setHandle(EntityHuman entity) {
        super.setHandle(entity);
        this.inventory = new CraftInventoryPlayer(entity.getInventory());
    }

    @Override
    public String toString() {
        return "CraftHumanEntity{id=" + this.getEntityId() + "name=" + this.getName() + "}";
    }

    public InventoryView getOpenInventory() {
        return this.getHandle().containerMenu.getBukkitView();
    }

    public InventoryView openInventory(Inventory inventory) {
        InventoryHolder inventoryHolder;
        TileEntity te;
        CraftInventory craft;
        if (!(this.getHandle() instanceof EntityPlayer)) {
            return null;
        }
        EntityPlayer player = (EntityPlayer)this.getHandle();
        Container formerContainer = this.getHandle().containerMenu;
        ITileInventory tileInventory = null;
        if (inventory instanceof CraftInventoryDoubleChest) {
            tileInventory = ((CraftInventoryDoubleChest)inventory).tile;
        } else if (inventory instanceof CraftInventoryLectern) {
            tileInventory = ((CraftInventoryLectern)inventory).tile;
        } else if (inventory instanceof CraftInventory && (craft = (CraftInventory)inventory).getInventory() instanceof ITileInventory) {
            tileInventory = (ITileInventory)((Object)craft.getInventory());
        }
        if (tileInventory instanceof ITileInventory && tileInventory instanceof TileEntity && !(te = (TileEntity)((Object)tileInventory)).hasLevel()) {
            te.setLevel(this.getHandle().level());
        }
        if (tileInventory instanceof ITileInventory) {
            this.getHandle().openMenu(tileInventory);
        } else if (inventory instanceof CraftInventoryAbstractHorse && (inventoryHolder = (craft = (CraftInventoryAbstractHorse)inventory).getInventory().getOwner()) instanceof CraftAbstractHorse) {
            CraftAbstractHorse horse = (CraftAbstractHorse)inventoryHolder;
            this.getHandle().openHorseInventory(horse.getHandle(), craft.getInventory());
        } else {
            Containers container = CraftContainer.getNotchInventoryType(inventory);
            CraftHumanEntity.openCustomInventory(inventory, player, container);
        }
        if (this.getHandle().containerMenu == formerContainer) {
            return null;
        }
        this.getHandle().containerMenu.checkReachable = false;
        return this.getHandle().containerMenu.getBukkitView();
    }

    private static void openCustomInventory(Inventory inventory, EntityPlayer player, Containers<?> windowType) {
        if (player.connection == null) {
            return;
        }
        Preconditions.checkArgument((windowType != null ? 1 : 0) != 0, (Object)"Unknown windowType");
        Container container = new CraftContainer(inventory, (EntityHuman)player, player.nextContainerCounter());
        container = CraftEventFactory.callInventoryOpenEvent(player, container);
        if (container == null) {
            return;
        }
        String title = container.getBukkitView().getTitle();
        player.connection.send(new PacketPlayOutOpenWindow(container.containerId, windowType, CraftChatMessage.fromString(title)[0]));
        player.containerMenu = container;
        player.initMenu(container);
    }

    public InventoryView openWorkbench(Location location, boolean force) {
        Block block;
        if (location == null) {
            location = this.getLocation();
        }
        if (!force && (block = location.getBlock()).getType() != Material.CRAFTING_TABLE) {
            return null;
        }
        this.getHandle().openMenu(Blocks.CRAFTING_TABLE.defaultBlockState().getMenuProvider(this.getHandle().level(), CraftLocation.toBlockPosition(location)));
        if (force) {
            this.getHandle().containerMenu.checkReachable = false;
        }
        return this.getHandle().containerMenu.getBukkitView();
    }

    public InventoryView openEnchanting(Location location, boolean force) {
        Block block;
        if (location == null) {
            location = this.getLocation();
        }
        if (!force && (block = location.getBlock()).getType() != Material.ENCHANTING_TABLE) {
            return null;
        }
        BlockPosition pos = CraftLocation.toBlockPosition(location);
        this.getHandle().openMenu(Blocks.ENCHANTING_TABLE.defaultBlockState().getMenuProvider(this.getHandle().level(), pos));
        if (force) {
            this.getHandle().containerMenu.checkReachable = false;
        }
        return this.getHandle().containerMenu.getBukkitView();
    }

    public void openInventory(InventoryView inventory) {
        Preconditions.checkArgument((boolean)this.equals(inventory.getPlayer()), (Object)"InventoryView must belong to the opening player");
        if (!(this.getHandle() instanceof EntityPlayer)) {
            return;
        }
        if (((EntityPlayer)this.getHandle()).connection == null) {
            return;
        }
        if (this.getHandle().containerMenu != this.getHandle().inventoryMenu) {
            ((EntityPlayer)this.getHandle()).connection.handleContainerClose(new PacketPlayInCloseWindow(this.getHandle().containerMenu.containerId));
        }
        EntityPlayer player = (EntityPlayer)this.getHandle();
        Container container = inventory instanceof CraftInventoryView ? ((CraftInventoryView)inventory).getHandle() : new CraftContainer(inventory, this.getHandle(), player.nextContainerCounter());
        if ((container = CraftEventFactory.callInventoryOpenEvent(player, container)) == null) {
            return;
        }
        Containers windowType = CraftContainer.getNotchInventoryType(inventory.getTopInventory());
        String title = inventory.getTitle();
        player.connection.send(new PacketPlayOutOpenWindow(container.containerId, windowType, CraftChatMessage.fromString(title)[0]));
        player.containerMenu = container;
        player.initMenu(container);
    }

    public InventoryView openMerchant(Villager villager, boolean force) {
        Preconditions.checkNotNull((Object)villager, (Object)"villager cannot be null");
        return this.openMerchant((Merchant)villager, force);
    }

    public InventoryView openMerchant(Merchant merchant, boolean force) {
        IChatBaseComponent name;
        IMerchant mcMerchant;
        Preconditions.checkNotNull((Object)merchant, (Object)"merchant cannot be null");
        if (!force && merchant.isTrading()) {
            return null;
        }
        if (merchant.isTrading()) {
            merchant.getTrader().closeInventory();
        }
        int level = 1;
        if (merchant instanceof CraftAbstractVillager) {
            mcMerchant = ((CraftAbstractVillager)merchant).getHandle();
            name = ((CraftAbstractVillager)merchant).getHandle().getDisplayName();
            if (merchant instanceof CraftVillager) {
                level = ((CraftVillager)merchant).getHandle().getVillagerData().getLevel();
            }
        } else if (merchant instanceof CraftMerchantCustom) {
            mcMerchant = ((CraftMerchantCustom)merchant).getMerchant();
            name = ((CraftMerchantCustom)merchant).getMerchant().getScoreboardDisplayName();
        } else {
            throw new IllegalArgumentException("Can't open merchant " + merchant.toString());
        }
        mcMerchant.setTradingPlayer(this.getHandle());
        mcMerchant.openTradingScreen(this.getHandle(), name, level);
        return this.getHandle().containerMenu.getBukkitView();
    }

    public void closeInventory() {
        this.getHandle().closeContainer();
    }

    public boolean isBlocking() {
        return this.getHandle().isBlocking();
    }

    public boolean isHandRaised() {
        return this.getHandle().isUsingItem();
    }

    public boolean setWindowProperty(InventoryView.Property prop, int value) {
        return false;
    }

    public int getEnchantmentSeed() {
        return this.getHandle().enchantmentSeed;
    }

    public void setEnchantmentSeed(int i2) {
        this.getHandle().enchantmentSeed = i2;
    }

    public int getExpToLevel() {
        return this.getHandle().getXpNeededForNextLevel();
    }

    public float getAttackCooldown() {
        return this.getHandle().getAttackStrengthScale(0.5f);
    }

    public boolean hasCooldown(Material material) {
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        Preconditions.checkArgument((boolean)material.isItem(), (String)"Material %s is not an item", (Object)material);
        return this.getHandle().getCooldowns().isOnCooldown(CraftItemType.bukkitToMinecraft(material));
    }

    public int getCooldown(Material material) {
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        Preconditions.checkArgument((boolean)material.isItem(), (String)"Material %s is not an item", (Object)material);
        ItemCooldown.Info cooldown = this.getHandle().getCooldowns().cooldowns.get(CraftItemType.bukkitToMinecraft(material));
        return cooldown == null ? 0 : Math.max(0, cooldown.endTime - this.getHandle().getCooldowns().tickCount);
    }

    public void setCooldown(Material material, int ticks) {
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        Preconditions.checkArgument((boolean)material.isItem(), (String)"Material %s is not an item", (Object)material);
        Preconditions.checkArgument((ticks >= 0 ? 1 : 0) != 0, (Object)"Cannot have negative cooldown");
        this.getHandle().getCooldowns().addCooldown(CraftItemType.bukkitToMinecraft(material), ticks);
    }

    public boolean discoverRecipe(NamespacedKey recipe) {
        return this.discoverRecipes(Arrays.asList(recipe)) != 0;
    }

    public int discoverRecipes(Collection<NamespacedKey> recipes) {
        return this.getHandle().awardRecipes(this.bukkitKeysToMinecraftRecipes(recipes));
    }

    public boolean undiscoverRecipe(NamespacedKey recipe) {
        return this.undiscoverRecipes(Arrays.asList(recipe)) != 0;
    }

    public int undiscoverRecipes(Collection<NamespacedKey> recipes) {
        return this.getHandle().resetRecipes(this.bukkitKeysToMinecraftRecipes(recipes));
    }

    public boolean hasDiscoveredRecipe(NamespacedKey recipe) {
        return false;
    }

    public Set<NamespacedKey> getDiscoveredRecipes() {
        return ImmutableSet.of();
    }

    private Collection<RecipeHolder<?>> bukkitKeysToMinecraftRecipes(Collection<NamespacedKey> recipeKeys) {
        ArrayList recipes = new ArrayList();
        CraftingManager manager = this.getHandle().level().getServer().getRecipeManager();
        for (NamespacedKey recipeKey : recipeKeys) {
            Optional<RecipeHolder<?>> recipe = manager.byKey(CraftNamespacedKey.toMinecraft(recipeKey));
            if (!recipe.isPresent()) continue;
            recipes.add(recipe.get());
        }
        return recipes;
    }

    public Entity getShoulderEntityLeft() {
        if (!this.getHandle().getShoulderEntityLeft().isEmpty()) {
            Optional<net.minecraft.world.entity.Entity> shoulder = EntityTypes.create(this.getHandle().getShoulderEntityLeft(), this.getHandle().level());
            return !shoulder.isPresent() ? null : shoulder.get().getBukkitEntity();
        }
        return null;
    }

    public void setShoulderEntityLeft(Entity entity) {
        this.getHandle().setShoulderEntityLeft(entity == null ? new NBTTagCompound() : ((CraftEntity)entity).save());
        if (entity != null) {
            entity.remove();
        }
    }

    public Entity getShoulderEntityRight() {
        if (!this.getHandle().getShoulderEntityRight().isEmpty()) {
            Optional<net.minecraft.world.entity.Entity> shoulder = EntityTypes.create(this.getHandle().getShoulderEntityRight(), this.getHandle().level());
            return !shoulder.isPresent() ? null : shoulder.get().getBukkitEntity();
        }
        return null;
    }

    public void setShoulderEntityRight(Entity entity) {
        this.getHandle().setShoulderEntityRight(entity == null ? new NBTTagCompound() : ((CraftEntity)entity).save());
        if (entity != null) {
            entity.remove();
        }
    }

    public boolean dropItem(boolean dropAll) {
        if (!(this.getHandle() instanceof EntityPlayer)) {
            return false;
        }
        return ((EntityPlayer)this.getHandle()).drop(dropAll);
    }

    public float getExhaustion() {
        return this.getHandle().getFoodData().exhaustionLevel;
    }

    public void setExhaustion(float value) {
        this.getHandle().getFoodData().exhaustionLevel = value;
    }

    public float getSaturation() {
        return this.getHandle().getFoodData().saturationLevel;
    }

    public void setSaturation(float value) {
        this.getHandle().getFoodData().saturationLevel = value;
    }

    public int getFoodLevel() {
        return this.getHandle().getFoodData().foodLevel;
    }

    public void setFoodLevel(int value) {
        this.getHandle().getFoodData().foodLevel = value;
    }

    public int getSaturatedRegenRate() {
        return this.getHandle().getFoodData().saturatedRegenRate;
    }

    public void setSaturatedRegenRate(int i2) {
        this.getHandle().getFoodData().saturatedRegenRate = i2;
    }

    public int getUnsaturatedRegenRate() {
        return this.getHandle().getFoodData().unsaturatedRegenRate;
    }

    public void setUnsaturatedRegenRate(int i2) {
        this.getHandle().getFoodData().unsaturatedRegenRate = i2;
    }

    public int getStarvationRate() {
        return this.getHandle().getFoodData().starvationRate;
    }

    public void setStarvationRate(int i2) {
        this.getHandle().getFoodData().starvationRate = i2;
    }

    public Location getLastDeathLocation() {
        return this.getHandle().getLastDeathLocation().map(CraftMemoryMapper::fromNms).orElse(null);
    }

    public void setLastDeathLocation(Location location) {
        if (location == null) {
            this.getHandle().setLastDeathLocation(Optional.empty());
        } else {
            this.getHandle().setLastDeathLocation(Optional.of(CraftMemoryMapper.toNms(location)));
        }
    }

    public Firework fireworkBoost(ItemStack fireworkItemStack) {
        Preconditions.checkArgument((fireworkItemStack != null ? 1 : 0) != 0, (Object)"fireworkItemStack must not be null");
        Preconditions.checkArgument((fireworkItemStack.getType() == Material.FIREWORK_ROCKET ? 1 : 0) != 0, (String)"fireworkItemStack must be of type %s", (Object)Material.FIREWORK_ROCKET);
        EntityFireworks fireworks = new EntityFireworks(this.getHandle().level(), CraftItemStack.asNMSCopy(fireworkItemStack), this.getHandle());
        boolean success = this.getHandle().level().addFreshEntity(fireworks, CreatureSpawnEvent.SpawnReason.CUSTOM);
        return success ? (Firework)fireworks.getBukkitEntity() : null;
    }

    @Override
    public Entity copy() {
        throw new UnsupportedOperationException("Cannot copy human entities");
    }

    @Override
    public Entity copy(Location location) {
        throw new UnsupportedOperationException("Cannot copy human entities");
    }
}

