/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.entity;

import com.google.common.base.Preconditions;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.world.entity.EntityInsentient;
import org.bukkit.Sound;
import org.bukkit.craftbukkit.v1_21_R1.CraftLootTable;
import org.bukkit.craftbukkit.v1_21_R1.CraftServer;
import org.bukkit.craftbukkit.v1_21_R1.CraftSound;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftLivingEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.loot.LootTable;

public abstract class CraftMob
extends CraftLivingEntity
implements Mob {
    public CraftMob(CraftServer server, EntityInsentient entity) {
        super(server, entity);
    }

    public void setTarget(LivingEntity target) {
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot set target during world generation");
        EntityInsentient entity = this.getHandle();
        if (target == null) {
            entity.setTarget(null, null, false);
        } else if (target instanceof CraftLivingEntity) {
            entity.setTarget(((CraftLivingEntity)target).getHandle(), null, false);
        }
    }

    public CraftLivingEntity getTarget() {
        if (this.getHandle().getTarget() == null) {
            return null;
        }
        return (CraftLivingEntity)this.getHandle().getTarget().getBukkitEntity();
    }

    public void setAware(boolean aware) {
        this.getHandle().aware = aware;
    }

    public boolean isAware() {
        return this.getHandle().aware;
    }

    public Sound getAmbientSound() {
        SoundEffect sound = this.getHandle().getAmbientSound0();
        return sound != null ? CraftSound.minecraftToBukkit(sound) : null;
    }

    @Override
    public EntityInsentient getHandle() {
        return (EntityInsentient)this.entity;
    }

    @Override
    public String toString() {
        return "CraftMob";
    }

    public void setLootTable(LootTable table) {
        this.getHandle().lootTable = CraftLootTable.bukkitToMinecraft(table);
    }

    public LootTable getLootTable() {
        return CraftLootTable.minecraftToBukkit(this.getHandle().getLootTable());
    }

    public void setSeed(long seed) {
        this.getHandle().lootTableSeed = seed;
    }

    public long getSeed() {
        return this.getHandle().lootTableSeed;
    }
}

