/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.entity;

import com.google.common.base.Preconditions;
import net.minecraft.world.entity.animal.EntityPanda;
import org.bukkit.craftbukkit.v1_21_R1.CraftServer;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftAnimals;
import org.bukkit.entity.Panda;

public class CraftPanda
extends CraftAnimals
implements Panda {
    public CraftPanda(CraftServer server, EntityPanda entity) {
        super(server, entity);
    }

    @Override
    public EntityPanda getHandle() {
        return (EntityPanda)super.getHandle();
    }

    @Override
    public String toString() {
        return "CraftPanda";
    }

    public Panda.Gene getMainGene() {
        return CraftPanda.fromNms(this.getHandle().getMainGene());
    }

    public void setMainGene(Panda.Gene gene) {
        this.getHandle().setMainGene(CraftPanda.toNms(gene));
    }

    public Panda.Gene getHiddenGene() {
        return CraftPanda.fromNms(this.getHandle().getHiddenGene());
    }

    public void setHiddenGene(Panda.Gene gene) {
        this.getHandle().setHiddenGene(CraftPanda.toNms(gene));
    }

    public boolean isRolling() {
        return this.getHandle().isRolling();
    }

    public void setRolling(boolean flag) {
        this.getHandle().roll(flag);
    }

    public boolean isSneezing() {
        return this.getHandle().isSneezing();
    }

    public void setSneezing(boolean flag) {
        this.getHandle().sneeze(flag);
    }

    public boolean isSitting() {
        return this.getHandle().isSitting();
    }

    public void setSitting(boolean flag) {
        this.getHandle().sit(flag);
    }

    public boolean isOnBack() {
        return this.getHandle().isOnBack();
    }

    public void setOnBack(boolean flag) {
        this.getHandle().setOnBack(flag);
    }

    public boolean isEating() {
        return this.getHandle().isEating();
    }

    public void setEating(boolean flag) {
        this.getHandle().eat(flag);
    }

    public boolean isScared() {
        return this.getHandle().isScared();
    }

    public int getUnhappyTicks() {
        return this.getHandle().getUnhappyCounter();
    }

    public static Panda.Gene fromNms(EntityPanda.Gene gene) {
        Preconditions.checkArgument((gene != null ? 1 : 0) != 0, (Object)"Gene may not be null");
        return Panda.Gene.values()[gene.ordinal()];
    }

    public static EntityPanda.Gene toNms(Panda.Gene gene) {
        Preconditions.checkArgument((gene != null ? 1 : 0) != 0, (Object)"Gene may not be null");
        return EntityPanda.Gene.values()[gene.ordinal()];
    }
}

