/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.entity;

import com.google.common.base.Preconditions;
import net.minecraft.world.entity.monster.EntitySkeleton;
import org.bukkit.craftbukkit.v1_21_R1.CraftServer;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftAbstractSkeleton;
import org.bukkit.entity.Skeleton;

public class CraftSkeleton
extends CraftAbstractSkeleton
implements Skeleton {
    public CraftSkeleton(CraftServer server, EntitySkeleton entity) {
        super(server, entity);
    }

    public boolean isConverting() {
        return this.getHandle().isFreezeConverting();
    }

    public int getConversionTime() {
        Preconditions.checkState((boolean)this.isConverting(), (Object)"Entity is not converting");
        return this.getHandle().conversionTime;
    }

    public void setConversionTime(int time) {
        if (time < 0) {
            this.getHandle().conversionTime = -1;
            this.getHandle().getEntityData().set(EntitySkeleton.DATA_STRAY_CONVERSION_ID, false);
        } else {
            this.getHandle().startFreezeConversion(time);
        }
    }

    @Override
    public EntitySkeleton getHandle() {
        return (EntitySkeleton)this.entity;
    }

    @Override
    public String toString() {
        return "CraftSkeleton";
    }

    public Skeleton.SkeletonType getSkeletonType() {
        return Skeleton.SkeletonType.NORMAL;
    }
}

