/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.entity;

import com.google.common.base.Preconditions;
import net.minecraft.world.entity.monster.EntityZombie;
import net.minecraft.world.entity.monster.EntityZombieVillager;
import org.bukkit.craftbukkit.v1_21_R1.CraftServer;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftMonster;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Zombie;

public class CraftZombie
extends CraftMonster
implements Zombie {
    public CraftZombie(CraftServer server, EntityZombie entity) {
        super(server, entity);
    }

    @Override
    public EntityZombie getHandle() {
        return (EntityZombie)this.entity;
    }

    @Override
    public String toString() {
        return "CraftZombie";
    }

    public boolean isBaby() {
        return this.getHandle().isBaby();
    }

    public void setBaby(boolean flag) {
        this.getHandle().setBaby(flag);
    }

    public boolean isVillager() {
        return this.getHandle() instanceof EntityZombieVillager;
    }

    public void setVillager(boolean flag) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public void setVillagerProfession(Villager.Profession profession) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public Villager.Profession getVillagerProfession() {
        return null;
    }

    public boolean isConverting() {
        return this.getHandle().isUnderWaterConverting();
    }

    public int getConversionTime() {
        Preconditions.checkState((boolean)this.isConverting(), (Object)"Entity not converting");
        return this.getHandle().conversionTime;
    }

    public void setConversionTime(int time) {
        if (time < 0) {
            this.getHandle().conversionTime = -1;
            this.getHandle().getEntityData().set(EntityZombie.DATA_DROWNED_CONVERSION_ID, false);
        } else {
            this.getHandle().startUnderWaterConversion(time);
        }
    }

    public int getAge() {
        return this.getHandle().isBaby() ? -1 : 0;
    }

    public void setAge(int i2) {
        this.getHandle().setBaby(i2 < 0);
    }

    public void setAgeLock(boolean b2) {
    }

    public boolean getAgeLock() {
        return false;
    }

    public void setBaby() {
        this.getHandle().setBaby(true);
    }

    public void setAdult() {
        this.getHandle().setBaby(false);
    }

    public boolean isAdult() {
        return !this.getHandle().isBaby();
    }

    public boolean canBreed() {
        return false;
    }

    public void setBreed(boolean b2) {
    }

    public boolean canBreakDoors() {
        return this.getHandle().canBreakDoors();
    }

    public void setCanBreakDoors(boolean flag) {
        this.getHandle().setCanBreakDoors(flag);
    }
}

