/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.inventory;

import com.google.common.base.Preconditions;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EnumItemSlot;
import org.bukkit.craftbukkit.v1_21_R1.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class CraftEntityEquipment
implements EntityEquipment {
    private final CraftLivingEntity entity;

    public CraftEntityEquipment(CraftLivingEntity entity) {
        this.entity = entity;
    }

    public void setItem(EquipmentSlot slot, ItemStack item) {
        this.setItem(slot, item, false);
    }

    public void setItem(EquipmentSlot slot, ItemStack item, boolean silent) {
        Preconditions.checkArgument((slot != null ? 1 : 0) != 0, (Object)"slot must not be null");
        EnumItemSlot nmsSlot = CraftEquipmentSlot.getNMS(slot);
        this.setEquipment(nmsSlot, item, silent);
    }

    public ItemStack getItem(EquipmentSlot slot) {
        Preconditions.checkArgument((slot != null ? 1 : 0) != 0, (Object)"slot must not be null");
        EnumItemSlot nmsSlot = CraftEquipmentSlot.getNMS(slot);
        return this.getEquipment(nmsSlot);
    }

    public ItemStack getItemInMainHand() {
        return this.getEquipment(EnumItemSlot.MAINHAND);
    }

    public void setItemInMainHand(ItemStack item) {
        this.setItemInMainHand(item, false);
    }

    public void setItemInMainHand(ItemStack item, boolean silent) {
        this.setEquipment(EnumItemSlot.MAINHAND, item, silent);
    }

    public ItemStack getItemInOffHand() {
        return this.getEquipment(EnumItemSlot.OFFHAND);
    }

    public void setItemInOffHand(ItemStack item) {
        this.setItemInOffHand(item, false);
    }

    public void setItemInOffHand(ItemStack item, boolean silent) {
        this.setEquipment(EnumItemSlot.OFFHAND, item, silent);
    }

    public ItemStack getItemInHand() {
        return this.getItemInMainHand();
    }

    public void setItemInHand(ItemStack stack) {
        this.setItemInMainHand(stack);
    }

    public ItemStack getHelmet() {
        return this.getEquipment(EnumItemSlot.HEAD);
    }

    public void setHelmet(ItemStack helmet) {
        this.setHelmet(helmet, false);
    }

    public void setHelmet(ItemStack helmet, boolean silent) {
        this.setEquipment(EnumItemSlot.HEAD, helmet, silent);
    }

    public ItemStack getChestplate() {
        return this.getEquipment(EnumItemSlot.CHEST);
    }

    public void setChestplate(ItemStack chestplate) {
        this.setChestplate(chestplate, false);
    }

    public void setChestplate(ItemStack chestplate, boolean silent) {
        this.setEquipment(EnumItemSlot.CHEST, chestplate, silent);
    }

    public ItemStack getLeggings() {
        return this.getEquipment(EnumItemSlot.LEGS);
    }

    public void setLeggings(ItemStack leggings) {
        this.setLeggings(leggings, false);
    }

    public void setLeggings(ItemStack leggings, boolean silent) {
        this.setEquipment(EnumItemSlot.LEGS, leggings, silent);
    }

    public ItemStack getBoots() {
        return this.getEquipment(EnumItemSlot.FEET);
    }

    public void setBoots(ItemStack boots) {
        this.setBoots(boots, false);
    }

    public void setBoots(ItemStack boots, boolean silent) {
        this.setEquipment(EnumItemSlot.FEET, boots, silent);
    }

    public ItemStack[] getArmorContents() {
        ItemStack[] armor = new ItemStack[]{this.getEquipment(EnumItemSlot.FEET), this.getEquipment(EnumItemSlot.LEGS), this.getEquipment(EnumItemSlot.CHEST), this.getEquipment(EnumItemSlot.HEAD)};
        return armor;
    }

    public void setArmorContents(ItemStack[] items) {
        this.setEquipment(EnumItemSlot.FEET, items.length >= 1 ? items[0] : null, false);
        this.setEquipment(EnumItemSlot.LEGS, items.length >= 2 ? items[1] : null, false);
        this.setEquipment(EnumItemSlot.CHEST, items.length >= 3 ? items[2] : null, false);
        this.setEquipment(EnumItemSlot.HEAD, items.length >= 4 ? items[3] : null, false);
    }

    private ItemStack getEquipment(EnumItemSlot slot) {
        return CraftItemStack.asBukkitCopy(this.entity.getHandle().getItemBySlot(slot));
    }

    private void setEquipment(EnumItemSlot slot, ItemStack stack, boolean silent) {
        this.entity.getHandle().setItemSlot(slot, CraftItemStack.asNMSCopy(stack), silent);
    }

    public void clear() {
        for (EnumItemSlot slot : EnumItemSlot.values()) {
            this.setEquipment(slot, null, false);
        }
    }

    public Entity getHolder() {
        return this.entity;
    }

    public float getItemInHandDropChance() {
        return this.getItemInMainHandDropChance();
    }

    public void setItemInHandDropChance(float chance) {
        this.setItemInMainHandDropChance(chance);
    }

    public float getItemInMainHandDropChance() {
        return this.getDropChance(EnumItemSlot.MAINHAND);
    }

    public void setItemInMainHandDropChance(float chance) {
        this.setDropChance(EnumItemSlot.MAINHAND, chance);
    }

    public float getItemInOffHandDropChance() {
        return this.getDropChance(EnumItemSlot.OFFHAND);
    }

    public void setItemInOffHandDropChance(float chance) {
        this.setDropChance(EnumItemSlot.OFFHAND, chance);
    }

    public float getHelmetDropChance() {
        return this.getDropChance(EnumItemSlot.HEAD);
    }

    public void setHelmetDropChance(float chance) {
        this.setDropChance(EnumItemSlot.HEAD, chance);
    }

    public float getChestplateDropChance() {
        return this.getDropChance(EnumItemSlot.CHEST);
    }

    public void setChestplateDropChance(float chance) {
        this.setDropChance(EnumItemSlot.CHEST, chance);
    }

    public float getLeggingsDropChance() {
        return this.getDropChance(EnumItemSlot.LEGS);
    }

    public void setLeggingsDropChance(float chance) {
        this.setDropChance(EnumItemSlot.LEGS, chance);
    }

    public float getBootsDropChance() {
        return this.getDropChance(EnumItemSlot.FEET);
    }

    public void setBootsDropChance(float chance) {
        this.setDropChance(EnumItemSlot.FEET, chance);
    }

    private void setDropChance(EnumItemSlot slot, float chance) {
        Preconditions.checkArgument((boolean)(this.entity.getHandle() instanceof EntityInsentient), (Object)"Cannot set drop chance for non-Mob entity");
        if (slot == EnumItemSlot.MAINHAND || slot == EnumItemSlot.OFFHAND) {
            ((EntityInsentient)this.entity.getHandle()).handDropChances[slot.getIndex()] = chance;
        } else {
            ((EntityInsentient)this.entity.getHandle()).armorDropChances[slot.getIndex()] = chance;
        }
    }

    private float getDropChance(EnumItemSlot slot) {
        if (!(this.entity.getHandle() instanceof EntityInsentient)) {
            return 1.0f;
        }
        if (slot == EnumItemSlot.MAINHAND || slot == EnumItemSlot.OFFHAND) {
            return ((EntityInsentient)this.entity.getHandle()).handDropChances[slot.getIndex()];
        }
        return ((EntityInsentient)this.entity.getHandle()).armorDropChances[slot.getIndex()];
    }
}

