/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.inventory;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import net.minecraft.world.IInventory;
import net.minecraft.world.inventory.InventoryCrafting;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;

public class CraftInventoryCrafting
extends CraftInventory
implements CraftingInventory {
    private final IInventory resultInventory;

    public CraftInventoryCrafting(InventoryCrafting inventory, IInventory resultInventory) {
        super(inventory);
        this.resultInventory = resultInventory;
    }

    public IInventory getResultInventory() {
        return this.resultInventory;
    }

    public InventoryCrafting getMatrixInventory() {
        return (InventoryCrafting)this.inventory;
    }

    @Override
    public int getSize() {
        return this.getResultInventory().getContainerSize() + this.getMatrixInventory().getContainerSize();
    }

    @Override
    public void setContents(ItemStack[] items) {
        Preconditions.checkArgument((items.length <= this.getSize() ? 1 : 0) != 0, (String)"Invalid inventory size (%s); expected %s or less", (int)items.length, (int)this.getSize());
        this.setContents(items[0], Arrays.copyOfRange(items, 1, items.length));
    }

    @Override
    public ItemStack[] getContents() {
        ItemStack[] items = new ItemStack[this.getSize()];
        List<net.minecraft.world.item.ItemStack> mcResultItems = this.getResultInventory().getContents();
        int i2 = 0;
        for (i2 = 0; i2 < mcResultItems.size(); ++i2) {
            items[i2] = CraftItemStack.asCraftMirror(mcResultItems.get(i2));
        }
        List<net.minecraft.world.item.ItemStack> mcItems = this.getMatrixInventory().getContents();
        for (int j2 = 0; j2 < mcItems.size(); ++j2) {
            items[i2 + j2] = CraftItemStack.asCraftMirror(mcItems.get(j2));
        }
        return items;
    }

    public void setContents(ItemStack result, ItemStack[] contents) {
        this.setResult(result);
        this.setMatrix(contents);
    }

    @Override
    public CraftItemStack getItem(int index) {
        if (index < this.getResultInventory().getContainerSize()) {
            net.minecraft.world.item.ItemStack item = this.getResultInventory().getItem(index);
            return item.isEmpty() ? null : CraftItemStack.asCraftMirror(item);
        }
        net.minecraft.world.item.ItemStack item = this.getMatrixInventory().getItem(index - this.getResultInventory().getContainerSize());
        return item.isEmpty() ? null : CraftItemStack.asCraftMirror(item);
    }

    @Override
    public void setItem(int index, ItemStack item) {
        if (index < this.getResultInventory().getContainerSize()) {
            this.getResultInventory().setItem(index, CraftItemStack.asNMSCopy(item));
        } else {
            this.getMatrixInventory().setItem(index - this.getResultInventory().getContainerSize(), CraftItemStack.asNMSCopy(item));
        }
    }

    public ItemStack[] getMatrix() {
        List<net.minecraft.world.item.ItemStack> matrix = this.getMatrixInventory().getContents();
        return this.asCraftMirror(matrix);
    }

    public ItemStack getResult() {
        net.minecraft.world.item.ItemStack item = this.getResultInventory().getItem(0);
        if (!item.isEmpty()) {
            return CraftItemStack.asCraftMirror(item);
        }
        return null;
    }

    public void setMatrix(ItemStack[] contents) {
        Preconditions.checkArgument((contents.length <= this.getMatrixInventory().getContainerSize() ? 1 : 0) != 0, (String)"Invalid inventory size (%s); expected %s or less", (int)contents.length, (int)this.getMatrixInventory().getContainerSize());
        for (int i2 = 0; i2 < this.getMatrixInventory().getContainerSize(); ++i2) {
            if (i2 < contents.length) {
                this.getMatrixInventory().setItem(i2, CraftItemStack.asNMSCopy(contents[i2]));
                continue;
            }
            this.getMatrixInventory().setItem(i2, net.minecraft.world.item.ItemStack.EMPTY);
        }
    }

    public void setResult(ItemStack item) {
        List<net.minecraft.world.item.ItemStack> contents = this.getResultInventory().getContents();
        contents.set(0, CraftItemStack.asNMSCopy(item));
    }

    public Recipe getRecipe() {
        RecipeHolder<?> recipe = this.getMatrixInventory().getCurrentRecipe();
        return recipe == null ? null : recipe.toBukkitRecipe();
    }
}

