/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.inventory;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.Containers;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.craftbukkit.v1_21_R1.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R1.inventory.util.CraftMenus;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_21_R1.util.Handleable;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.MenuType;

public class CraftMenuType<V extends InventoryView>
implements MenuType.Typed<V>,
Handleable<Containers<?>> {
    private final NamespacedKey key;
    private final Containers<?> handle;
    private final Supplier<CraftMenus.MenuTypeData<V>> typeData;

    public CraftMenuType(NamespacedKey key, Containers<?> handle) {
        this.key = key;
        this.handle = handle;
        this.typeData = Suppliers.memoize(() -> CraftMenus.getMenuTypeData(this));
    }

    @Override
    public Containers<?> getHandle() {
        return this.handle;
    }

    public V create(HumanEntity player, String title) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"The given player must not be null");
        Preconditions.checkArgument((title != null ? 1 : 0) != 0, (Object)"The given title must not be null");
        Preconditions.checkArgument((boolean)(player instanceof CraftHumanEntity), (Object)"The given player must be a CraftHumanEntity");
        CraftHumanEntity craftHuman = (CraftHumanEntity)player;
        Preconditions.checkArgument((boolean)(craftHuman.getHandle() instanceof EntityPlayer), (Object)"The given player must be an EntityPlayer");
        EntityPlayer serverPlayer = (EntityPlayer)craftHuman.getHandle();
        Container container = this.typeData.get().menuBuilder().build(serverPlayer, this.handle);
        container.setTitle(CraftChatMessage.fromString(title)[0]);
        container.checkReachable = false;
        return (V)container.getBukkitView();
    }

    public MenuType.Typed<InventoryView> typed() {
        return this.typed(InventoryView.class);
    }

    public <V extends InventoryView> MenuType.Typed<V> typed(Class<V> clazz) {
        if (clazz.isAssignableFrom(this.typeData.get().viewClass())) {
            return this;
        }
        throw new IllegalArgumentException("Cannot type InventoryView " + this.key.toString() + " to InventoryView type " + clazz.getSimpleName());
    }

    public Class<? extends InventoryView> getInventoryViewClass() {
        return this.typeData.get().viewClass();
    }

    public NamespacedKey getKey() {
        return this.key;
    }

    public static Containers<?> bukkitToMinecraft(MenuType bukkit) {
        return (Containers)CraftRegistry.bukkitToMinecraft(bukkit);
    }

    public static MenuType minecraftToBukkit(Containers<?> minecraft) {
        return (MenuType)CraftRegistry.minecraftToBukkit(minecraft, Registries.MENU, Registry.MENU);
    }

    public static MenuType minecraftHolderToBukkit(Holder<Containers<?>> minecraft) {
        return CraftMenuType.minecraftToBukkit(minecraft.value());
    }
}

