/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.inventory.components;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.level.block.Block;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlockType;
import org.bukkit.craftbukkit.v1_21_R1.inventory.SerializableMeta;
import org.bukkit.craftbukkit.v1_21_R1.tag.CraftBlockTag;
import org.bukkit.inventory.meta.components.ToolComponent;

@SerializableAs(value="Tool")
public final class CraftToolComponent
implements ToolComponent {
    private Tool handle;

    public CraftToolComponent(Tool tool) {
        this.handle = tool;
    }

    public CraftToolComponent(CraftToolComponent tool) {
        this.handle = tool.handle;
    }

    public CraftToolComponent(Map<String, Object> map) {
        Float speed = SerializableMeta.getObject(Float.class, map, "default-mining-speed", false);
        Integer damage = SerializableMeta.getObject(Integer.class, map, "damage-per-block", false);
        ImmutableList.Builder rules = ImmutableList.builder();
        Iterable rawRuleList = SerializableMeta.getObject(Iterable.class, map, "rules", true);
        if (rawRuleList != null) {
            for (Object obj : rawRuleList) {
                Preconditions.checkArgument((boolean)(obj instanceof ToolComponent.ToolRule), (String)"Object (%s) in rule list is not valid", obj.getClass());
                CraftToolRule rule = new CraftToolRule((ToolComponent.ToolRule)obj);
                if (rule.handle.blocks().size() <= 0) continue;
                rules.add((Object)rule);
            }
        }
        this.handle = new Tool(rules.build().stream().map(CraftToolRule::new).map(CraftToolRule::getHandle).toList(), speed.floatValue(), damage);
    }

    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("default-mining-speed", Float.valueOf(this.getDefaultMiningSpeed()));
        result.put("damage-per-block", this.getDamagePerBlock());
        result.put("rules", this.getRules());
        return result;
    }

    public Tool getHandle() {
        return this.handle;
    }

    public float getDefaultMiningSpeed() {
        return this.handle.defaultMiningSpeed();
    }

    public void setDefaultMiningSpeed(float speed) {
        this.handle = new Tool(this.handle.rules(), speed, this.handle.damagePerBlock());
    }

    public int getDamagePerBlock() {
        return this.handle.damagePerBlock();
    }

    public void setDamagePerBlock(int damage) {
        Preconditions.checkArgument((damage >= 0 ? 1 : 0) != 0, (String)"damage must be >= 0, was %d", (int)damage);
        this.handle = new Tool(this.handle.rules(), this.handle.defaultMiningSpeed(), damage);
    }

    public List<ToolComponent.ToolRule> getRules() {
        return this.handle.rules().stream().map(CraftToolRule::new).collect(Collectors.toList());
    }

    public void setRules(List<ToolComponent.ToolRule> rules) {
        Preconditions.checkArgument((rules != null ? 1 : 0) != 0, (Object)"rules must not be null");
        this.handle = new Tool(rules.stream().map(CraftToolRule::new).map(CraftToolRule::getHandle).toList(), this.handle.defaultMiningSpeed(), this.handle.damagePerBlock());
    }

    public ToolComponent.ToolRule addRule(Material block, Float speed, Boolean correctForDrops) {
        Preconditions.checkArgument((block != null ? 1 : 0) != 0, (Object)"block must not be null");
        Preconditions.checkArgument((boolean)block.isBlock(), (String)"block must be a block type, given %s", (Object)block.getKey());
        Holder.c<Block> nmsBlock = CraftBlockType.bukkitToMinecraft(block).builtInRegistryHolder();
        return this.addRule(HolderSet.direct(nmsBlock), speed, correctForDrops);
    }

    public ToolComponent.ToolRule addRule(Collection<Material> blocks, Float speed, Boolean correctForDrops) {
        ArrayList<Holder.c<Block>> nmsBlocks = new ArrayList<Holder.c<Block>>(blocks.size());
        for (Material material : blocks) {
            Preconditions.checkArgument((boolean)material.isBlock(), (String)"blocks contains non-block type: %s", (Object)material.getKey());
            nmsBlocks.add(CraftBlockType.bukkitToMinecraft(material).builtInRegistryHolder());
        }
        return this.addRule(HolderSet.direct(nmsBlocks), speed, correctForDrops);
    }

    public ToolComponent.ToolRule addRule(Tag<Material> tag, Float speed, Boolean correctForDrops) {
        Preconditions.checkArgument((boolean)(tag instanceof CraftBlockTag), (Object)"tag must be a block tag");
        return this.addRule(((CraftBlockTag)tag).getHandle(), speed, correctForDrops);
    }

    private ToolComponent.ToolRule addRule(HolderSet<Block> blocks, Float speed, Boolean correctForDrops) {
        Tool.a rule = new Tool.a(blocks, Optional.ofNullable(speed), Optional.ofNullable(correctForDrops));
        ArrayList<Tool.a> rules = new ArrayList<Tool.a>(this.handle.rules().size() + 1);
        rules.addAll(this.handle.rules());
        rules.add(rule);
        this.handle = new Tool(rules, this.handle.defaultMiningSpeed(), this.handle.damagePerBlock());
        return new CraftToolRule(rule);
    }

    public boolean removeRule(ToolComponent.ToolRule rule) {
        Preconditions.checkArgument((rule != null ? 1 : 0) != 0, (Object)"rule must not be null");
        ArrayList<Tool.a> rules = new ArrayList<Tool.a>(this.handle.rules());
        boolean removed = rules.remove(((CraftToolRule)rule).handle);
        this.handle = new Tool(rules, this.handle.defaultMiningSpeed(), this.handle.damagePerBlock());
        return removed;
    }

    public int hashCode() {
        int hash = 7;
        hash = 73 * hash + Objects.hashCode(this.handle);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CraftToolComponent other = (CraftToolComponent)obj;
        return Objects.equals(this.handle, other.handle);
    }

    public String toString() {
        return "CraftToolComponent{handle=" + String.valueOf(this.handle) + "}";
    }

    @SerializableAs(value="ToolRule")
    public static class CraftToolRule
    implements ToolComponent.ToolRule {
        private Tool.a handle;

        public CraftToolRule(Tool.a handle) {
            this.handle = handle;
        }

        public CraftToolRule(ToolComponent.ToolRule bukkit) {
            Tool.a toCopy = ((CraftToolRule)bukkit).handle;
            this.handle = new Tool.a(toCopy.blocks(), toCopy.speed(), toCopy.correctForDrops());
        }

        public CraftToolRule(Map<String, Object> map) {
            String blocksString;
            Float speed = SerializableMeta.getObject(Float.class, map, "speed", true);
            Boolean correct = SerializableMeta.getObject(Boolean.class, map, "correct-for-drops", true);
            HolderSet blocks = null;
            Object blocksObject = SerializableMeta.getObject(Object.class, map, "blocks", false);
            if (blocksObject instanceof String && (blocksString = (String)blocksObject).startsWith("#")) {
                MinecraftKey key = MinecraftKey.tryParse(blocksString = blocksString.substring(1));
                if (key != null) {
                    blocks = BuiltInRegistries.BLOCK.getTag(TagKey.create(Registries.BLOCK, key)).orElse(null);
                }
            } else if (blocksObject instanceof List) {
                List blocksList = (List)blocksObject;
                ArrayList blockHolders = new ArrayList(blocksList.size());
                for (Object entry : blocksList) {
                    MinecraftKey key = MinecraftKey.tryParse(entry.toString());
                    if (key == null) continue;
                    BuiltInRegistries.BLOCK.getHolder(key).ifPresent(blockHolders::add);
                }
                blocks = HolderSet.direct(blockHolders);
            } else {
                throw new IllegalArgumentException("blocks(" + String.valueOf(blocksObject) + ") is not a valid String or List");
            }
            if (blocks == null) {
                blocks = HolderSet.empty();
            }
            this.handle = new Tool.a(blocks, Optional.ofNullable(speed), Optional.ofNullable(correct));
        }

        public Map<String, Object> serialize() {
            Boolean correct;
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            this.handle.blocks().unwrap().ifLeft(key -> result.put("blocks", "#" + key.location().toString())).ifRight(blocks -> result.put("blocks", blocks.stream().map(block -> block.unwrapKey().orElseThrow().location().toString()).toList()));
            Float speed = this.getSpeed();
            if (speed != null) {
                result.put("speed", speed);
            }
            if ((correct = this.isCorrectForDrops()) != null) {
                result.put("correct-for-drops", correct);
            }
            return result;
        }

        public Tool.a getHandle() {
            return this.handle;
        }

        public Collection<Material> getBlocks() {
            return this.handle.blocks().stream().map(Holder::value).map(CraftBlockType::minecraftToBukkit).collect(Collectors.toList());
        }

        public void setBlocks(Material block) {
            Preconditions.checkArgument((block != null ? 1 : 0) != 0, (Object)"block must not be null");
            Preconditions.checkArgument((boolean)block.isBlock(), (String)"block must be a block type, given %s", (Object)block.getKey());
            this.handle = new Tool.a(HolderSet.direct(CraftBlockType.bukkitToMinecraft(block).builtInRegistryHolder()), this.handle.speed(), this.handle.correctForDrops());
        }

        public void setBlocks(Collection<Material> blocks) {
            Preconditions.checkArgument((blocks != null ? 1 : 0) != 0, (Object)"blocks must not be null");
            for (Material material : blocks) {
                Preconditions.checkArgument((boolean)material.isBlock(), (String)"blocks contains non-block type: %s", (Object)material.getKey());
            }
            this.handle = new Tool.a(HolderSet.direct(blocks.stream().map(CraftBlockType::bukkitToMinecraft).map(Block::builtInRegistryHolder).collect(Collectors.toList())), this.handle.speed(), this.handle.correctForDrops());
        }

        public void setBlocks(Tag<Material> tag) {
            Preconditions.checkArgument((boolean)(tag instanceof CraftBlockTag), (Object)"tag must be a block tag");
            this.handle = new Tool.a(((CraftBlockTag)tag).getHandle(), this.handle.speed(), this.handle.correctForDrops());
        }

        public Float getSpeed() {
            return this.handle.speed().orElse(null);
        }

        public void setSpeed(Float speed) {
            this.handle = new Tool.a(this.handle.blocks(), Optional.ofNullable(speed), this.handle.correctForDrops());
        }

        public Boolean isCorrectForDrops() {
            return this.handle.correctForDrops().orElse(null);
        }

        public void setCorrectForDrops(Boolean correct) {
            this.handle = new Tool.a(this.handle.blocks(), this.handle.speed(), Optional.ofNullable(correct));
        }

        public int hashCode() {
            int hash = 5;
            hash = 97 * hash + Objects.hashCode(this.handle);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CraftToolRule other = (CraftToolRule)obj;
            return Objects.equals(this.handle, other.handle);
        }

        public String toString() {
            return "CraftToolRule{handle=" + String.valueOf(this.handle) + "}";
        }
    }
}

