/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.inventory.util;

import net.minecraft.core.BlockPosition;
import net.minecraft.world.IInventory;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.CrafterBlockEntity;
import net.minecraft.world.level.block.entity.TileEntityBlastFurnace;
import net.minecraft.world.level.block.entity.TileEntityBrewingStand;
import net.minecraft.world.level.block.entity.TileEntityDispenser;
import net.minecraft.world.level.block.entity.TileEntityDropper;
import net.minecraft.world.level.block.entity.TileEntityFurnace;
import net.minecraft.world.level.block.entity.TileEntityFurnaceFurnace;
import net.minecraft.world.level.block.entity.TileEntityHopper;
import net.minecraft.world.level.block.entity.TileEntityLectern;
import net.minecraft.world.level.block.entity.TileEntityLootable;
import net.minecraft.world.level.block.entity.TileEntitySmoker;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventoryBrewer;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventoryFurnace;
import org.bukkit.craftbukkit.v1_21_R1.inventory.util.CraftInventoryCreator;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftChatMessage;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;

public abstract class CraftTileInventoryConverter
implements CraftInventoryCreator.InventoryConverter {
    public abstract IInventory getTileEntity();

    @Override
    public Inventory createInventory(InventoryHolder holder, InventoryType type) {
        return this.getInventory(this.getTileEntity());
    }

    @Override
    public Inventory createInventory(InventoryHolder holder, InventoryType type, String title) {
        IInventory te = this.getTileEntity();
        if (te instanceof TileEntityLootable) {
            ((TileEntityLootable)te).name = CraftChatMessage.fromStringOrNull(title);
        }
        return this.getInventory(te);
    }

    public Inventory getInventory(IInventory tileEntity) {
        return new CraftInventory(tileEntity);
    }

    public static class Crafter
    extends CraftTileInventoryConverter {
        @Override
        public IInventory getTileEntity() {
            return new CrafterBlockEntity(BlockPosition.ZERO, Blocks.CRAFTER.defaultBlockState());
        }
    }

    public static class Smoker
    extends CraftTileInventoryConverter {
        @Override
        public IInventory getTileEntity() {
            return new TileEntitySmoker(BlockPosition.ZERO, Blocks.SMOKER.defaultBlockState());
        }
    }

    public static class Lectern
    extends CraftTileInventoryConverter {
        @Override
        public IInventory getTileEntity() {
            return new TileEntityLectern((BlockPosition)BlockPosition.ZERO, (IBlockData)Blocks.LECTERN.defaultBlockState()).bookAccess;
        }
    }

    public static class BlastFurnace
    extends CraftTileInventoryConverter {
        @Override
        public IInventory getTileEntity() {
            return new TileEntityBlastFurnace(BlockPosition.ZERO, Blocks.BLAST_FURNACE.defaultBlockState());
        }
    }

    public static class Hopper
    extends CraftTileInventoryConverter {
        @Override
        public IInventory getTileEntity() {
            return new TileEntityHopper(BlockPosition.ZERO, Blocks.HOPPER.defaultBlockState());
        }
    }

    public static class Dropper
    extends CraftTileInventoryConverter {
        @Override
        public IInventory getTileEntity() {
            return new TileEntityDropper(BlockPosition.ZERO, Blocks.DROPPER.defaultBlockState());
        }
    }

    public static class Dispenser
    extends CraftTileInventoryConverter {
        @Override
        public IInventory getTileEntity() {
            return new TileEntityDispenser(BlockPosition.ZERO, Blocks.DISPENSER.defaultBlockState());
        }
    }

    public static class BrewingStand
    extends CraftTileInventoryConverter {
        @Override
        public IInventory getTileEntity() {
            return new TileEntityBrewingStand(BlockPosition.ZERO, Blocks.BREWING_STAND.defaultBlockState());
        }

        @Override
        public Inventory createInventory(InventoryHolder holder, InventoryType type, String title) {
            IInventory tileEntity = this.getTileEntity();
            if (tileEntity instanceof TileEntityBrewingStand) {
                ((TileEntityBrewingStand)tileEntity).name = CraftChatMessage.fromStringOrNull(title);
            }
            return this.getInventory(tileEntity);
        }

        @Override
        public Inventory getInventory(IInventory tileEntity) {
            return new CraftInventoryBrewer(tileEntity);
        }
    }

    public static class Furnace
    extends CraftTileInventoryConverter {
        @Override
        public IInventory getTileEntity() {
            TileEntityFurnaceFurnace furnace = new TileEntityFurnaceFurnace(BlockPosition.ZERO, Blocks.FURNACE.defaultBlockState());
            return furnace;
        }

        @Override
        public Inventory createInventory(InventoryHolder owner, InventoryType type, String title) {
            IInventory tileEntity = this.getTileEntity();
            ((TileEntityFurnace)tileEntity).name = CraftChatMessage.fromStringOrNull(title);
            return this.getInventory(tileEntity);
        }

        @Override
        public Inventory getInventory(IInventory tileEntity) {
            return new CraftInventoryFurnace((TileEntityFurnace)tileEntity);
        }
    }
}

