/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.packs;

import java.io.IOException;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.metadata.pack.ResourcePackInfo;
import net.minecraft.server.packs.repository.EnumResourcePackVersion;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.ResourcePackLoader;
import net.minecraft.util.InclusiveRange;
import org.bukkit.Bukkit;
import org.bukkit.FeatureFlag;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_21_R1.CraftFeatureFlag;
import org.bukkit.craftbukkit.v1_21_R1.CraftServer;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftChatMessage;
import org.bukkit.packs.DataPack;

public class CraftDataPack
implements DataPack {
    private final ResourcePackLoader handle;
    private final ResourcePackInfo resourcePackInfo;

    public CraftDataPack(ResourcePackLoader handler) {
        this.handle = handler;
        try (IResourcePack iresourcepack = this.handle.resources.openPrimary(this.handle.location());){
            this.resourcePackInfo = iresourcepack.getMetadataSection(ResourcePackInfo.TYPE);
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    public ResourcePackLoader getHandle() {
        return this.handle;
    }

    public String getRawId() {
        return this.getHandle().getId();
    }

    public String getTitle() {
        return CraftChatMessage.fromComponent(this.getHandle().getTitle());
    }

    public String getDescription() {
        return CraftChatMessage.fromComponent(this.getHandle().getDescription());
    }

    public int getPackFormat() {
        return this.resourcePackInfo.packFormat();
    }

    public int getMinSupportedPackFormat() {
        return this.resourcePackInfo.supportedFormats().orElse(new InclusiveRange<Integer>(this.getPackFormat())).minInclusive();
    }

    public int getMaxSupportedPackFormat() {
        return this.resourcePackInfo.supportedFormats().orElse(new InclusiveRange<Integer>(this.getPackFormat())).maxInclusive();
    }

    public boolean isRequired() {
        return this.getHandle().isRequired();
    }

    public DataPack.Compatibility getCompatibility() {
        return switch (this.getHandle().getCompatibility()) {
            default -> throw new MatchException(null, null);
            case EnumResourcePackVersion.COMPATIBLE -> DataPack.Compatibility.COMPATIBLE;
            case EnumResourcePackVersion.TOO_NEW -> DataPack.Compatibility.NEW;
            case EnumResourcePackVersion.TOO_OLD -> DataPack.Compatibility.OLD;
        };
    }

    public boolean isEnabled() {
        return ((CraftServer)Bukkit.getServer()).getServer().getPackRepository().getSelectedIds().contains(this.getRawId());
    }

    public DataPack.Source getSource() {
        if (this.getHandle().getPackSource() == PackSource.BUILT_IN) {
            return DataPack.Source.BUILT_IN;
        }
        if (this.getHandle().getPackSource() == PackSource.FEATURE) {
            return DataPack.Source.FEATURE;
        }
        if (this.getHandle().getPackSource() == PackSource.WORLD) {
            return DataPack.Source.WORLD;
        }
        if (this.getHandle().getPackSource() == PackSource.SERVER) {
            return DataPack.Source.SERVER;
        }
        return DataPack.Source.DEFAULT;
    }

    public Set<FeatureFlag> getRequestedFeatures() {
        return CraftFeatureFlag.getFromNMS(this.getHandle().getRequestedFeatures()).stream().map(FeatureFlag.class::cast).collect(Collectors.toUnmodifiableSet());
    }

    public NamespacedKey getKey() {
        return NamespacedKey.fromString((String)this.getRawId());
    }

    public String toString() {
        String requestedFeatures = this.getRequestedFeatures().stream().map(featureFlag -> featureFlag.getKey().toString()).collect(Collectors.joining(","));
        return "CraftDataPack{rawId=" + this.getRawId() + ",id=" + String.valueOf(this.getKey()) + ",title=" + this.getTitle() + ",description=" + this.getDescription() + ",packformat=" + this.getPackFormat() + ",minSupportedPackFormat=" + this.getMinSupportedPackFormat() + ",maxSupportedPackFormat=" + this.getMaxSupportedPackFormat() + ",compatibility=" + String.valueOf(this.getCompatibility()) + ",source=" + String.valueOf(this.getSource()) + ",enabled=" + this.isEnabled() + ",requestedFeatures=[" + requestedFeatures + "]}";
    }
}

