/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.structure;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureInfo;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorRotation;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.RegionAccessor;
import org.bukkit.World;
import org.bukkit.block.structure.Mirror;
import org.bukkit.block.structure.StructureRotation;
import org.bukkit.craftbukkit.v1_21_R1.CraftRegionAccessor;
import org.bukkit.craftbukkit.v1_21_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R1.structure.CraftPalette;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftBlockVector;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftLocation;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftStructureTransformer;
import org.bukkit.craftbukkit.v1_21_R1.util.RandomSourceWrapper;
import org.bukkit.craftbukkit.v1_21_R1.util.TransformerGeneratorAccess;
import org.bukkit.entity.Entity;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.structure.Palette;
import org.bukkit.structure.Structure;
import org.bukkit.util.BlockTransformer;
import org.bukkit.util.BlockVector;
import org.bukkit.util.EntityTransformer;

public class CraftStructure
implements Structure {
    private final DefinedStructure structure;
    private final IRegistryCustom registry;

    public CraftStructure(DefinedStructure structure, IRegistryCustom registry) {
        this.structure = structure;
        this.registry = registry;
    }

    public void place(Location location, boolean includeEntities, StructureRotation structureRotation, Mirror mirror, int palette, float integrity, Random random) {
        this.place(location, includeEntities, structureRotation, mirror, palette, integrity, random, Collections.emptyList(), Collections.emptyList());
    }

    public void place(Location location, boolean includeEntities, StructureRotation structureRotation, Mirror mirror, int palette, float integrity, Random random, Collection<BlockTransformer> blockTransformers, Collection<EntityTransformer> entityTransformers) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        location.checkFinite();
        World world = location.getWorld();
        Preconditions.checkArgument((world != null ? 1 : 0) != 0, (Object)"The World of Location cannot be null");
        BlockVector blockVector = new BlockVector(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        this.place((RegionAccessor)world, blockVector, includeEntities, structureRotation, mirror, palette, integrity, random, blockTransformers, entityTransformers);
    }

    public void place(RegionAccessor regionAccessor, BlockVector location, boolean includeEntities, StructureRotation structureRotation, Mirror mirror, int palette, float integrity, Random random) {
        this.place(regionAccessor, location, includeEntities, structureRotation, mirror, palette, integrity, random, Collections.emptyList(), Collections.emptyList());
    }

    public void place(RegionAccessor regionAccessor, BlockVector location, boolean includeEntities, StructureRotation structureRotation, Mirror mirror, int palette, float integrity, Random random, Collection<BlockTransformer> blockTransformers, Collection<EntityTransformer> entityTransformers) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((regionAccessor != null ? 1 : 0) != 0, (Object)"RegionAccessor cannot be null");
        Preconditions.checkArgument((blockTransformers != null ? 1 : 0) != 0, (Object)"BlockTransformers cannot be null");
        Preconditions.checkArgument((entityTransformers != null ? 1 : 0) != 0, (Object)"EntityTransformers cannot be null");
        location.checkFinite();
        Preconditions.checkArgument((integrity >= 0.0f && integrity <= 1.0f ? 1 : 0) != 0, (String)"Integrity value (%S) must be between 0 and 1 inclusive", (Object)Float.valueOf(integrity));
        RandomSourceWrapper randomSource = new RandomSourceWrapper(random);
        DefinedStructureInfo definedstructureinfo = new DefinedStructureInfo().setMirror(EnumBlockMirror.valueOf(mirror.name())).setRotation(EnumBlockRotation.valueOf(structureRotation.name())).setIgnoreEntities(!includeEntities).addProcessor(new DefinedStructureProcessorRotation(integrity)).setRandom(randomSource);
        definedstructureinfo.palette = palette;
        BlockPosition blockPosition = CraftBlockVector.toBlockPosition(location);
        GeneratorAccessSeed handle = ((CraftRegionAccessor)regionAccessor).getHandle();
        TransformerGeneratorAccess access = new TransformerGeneratorAccess();
        access.setHandle(handle);
        access.setStructureTransformer(new CraftStructureTransformer(handle, new ChunkCoordIntPair(blockPosition), blockTransformers, entityTransformers));
        this.structure.placeInWorld(access, blockPosition, blockPosition, definedstructureinfo, randomSource, 2);
        access.getStructureTransformer().discard();
    }

    public void fill(Location corner1, Location corner2, boolean includeEntities) {
        Preconditions.checkArgument((corner1 != null ? 1 : 0) != 0, (Object)"Location corner1 cannot be null");
        Preconditions.checkArgument((corner2 != null ? 1 : 0) != 0, (Object)"Location corner2 cannot be null");
        World world = corner1.getWorld();
        Preconditions.checkArgument((world != null ? 1 : 0) != 0, (Object)"World of corner1 Location cannot be null");
        Location origin = new Location(world, (double)Math.min(corner1.getBlockX(), corner2.getBlockX()), (double)Math.min(corner1.getBlockY(), corner2.getBlockY()), (double)Math.min(corner1.getBlockZ(), corner2.getBlockZ()));
        BlockVector size = new BlockVector(Math.abs(corner1.getBlockX() - corner2.getBlockX()), Math.abs(corner1.getBlockY() - corner2.getBlockY()), Math.abs(corner1.getBlockZ() - corner2.getBlockZ()));
        this.fill(origin, size, includeEntities);
    }

    public void fill(Location origin, BlockVector size, boolean includeEntities) {
        Preconditions.checkArgument((origin != null ? 1 : 0) != 0, (Object)"Location origin cannot be null");
        World world = origin.getWorld();
        Preconditions.checkArgument((world != null ? 1 : 0) != 0, (Object)"World of Location origin cannot be null");
        Preconditions.checkArgument((size != null ? 1 : 0) != 0, (Object)"BlockVector size cannot be null");
        Preconditions.checkArgument((size.getBlockX() >= 1 && size.getBlockY() >= 1 && size.getBlockZ() >= 1 ? 1 : 0) != 0, (String)"Size must be at least 1x1x1 but was %sx%sx%s", (Object)size.getBlockX(), (Object)size.getBlockY(), (Object)size.getBlockZ());
        this.structure.fillFromWorld(((CraftWorld)world).getHandle(), CraftLocation.toBlockPosition(origin), CraftBlockVector.toBlockPosition(size), includeEntities, Blocks.STRUCTURE_VOID);
    }

    public BlockVector getSize() {
        return CraftBlockVector.toBukkit(this.structure.getSize());
    }

    public List<Entity> getEntities() {
        ArrayList entities = new ArrayList();
        for (DefinedStructure.EntityInfo entity : this.structure.entityInfoList) {
            EntityTypes.create(entity.nbt, ((CraftWorld)Bukkit.getServer().getWorlds().get(0)).getHandle()).ifPresent(dummyEntity -> {
                dummyEntity.setPos(entity.pos.x, entity.pos.y, entity.pos.z);
                entities.add(dummyEntity.getBukkitEntity());
            });
        }
        return Collections.unmodifiableList(entities);
    }

    public int getEntityCount() {
        return this.structure.entityInfoList.size();
    }

    public List<Palette> getPalettes() {
        return this.structure.palettes.stream().map(palette -> new CraftPalette((DefinedStructure.a)palette, this.registry)).collect(Collectors.toList());
    }

    public int getPaletteCount() {
        return this.structure.palettes.size();
    }

    public PersistentDataContainer getPersistentDataContainer() {
        return this.getHandle().persistentDataContainer;
    }

    public DefinedStructure getHandle() {
        return this.structure;
    }
}

