/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.block.ITileEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.WorldData;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_21_R1.util.DummyGeneratorAccess;

public class BlockStateListPopulator
extends DummyGeneratorAccess {
    private final GeneratorAccess world;
    private final Map<BlockPosition, IBlockData> dataMap = new HashMap<BlockPosition, IBlockData>();
    private final Map<BlockPosition, TileEntity> entityMap = new HashMap<BlockPosition, TileEntity>();
    private final LinkedHashMap<BlockPosition, CraftBlockState> list;

    public BlockStateListPopulator(GeneratorAccess world) {
        this(world, new LinkedHashMap<BlockPosition, CraftBlockState>());
    }

    private BlockStateListPopulator(GeneratorAccess world, LinkedHashMap<BlockPosition, CraftBlockState> list) {
        this.world = world;
        this.list = list;
    }

    @Override
    public IBlockData getBlockState(BlockPosition bp) {
        IBlockData blockData = this.dataMap.get(bp);
        return blockData != null ? blockData : this.world.getBlockState(bp);
    }

    @Override
    public Fluid getFluidState(BlockPosition bp) {
        IBlockData blockData = this.dataMap.get(bp);
        return blockData != null ? blockData.getFluidState() : this.world.getFluidState(bp);
    }

    @Override
    public TileEntity getBlockEntity(BlockPosition blockposition) {
        if (this.entityMap.containsKey(blockposition)) {
            return this.entityMap.get(blockposition);
        }
        return this.world.getBlockEntity(blockposition);
    }

    @Override
    public boolean setBlock(BlockPosition position, IBlockData data, int flag) {
        position = position.immutable();
        this.list.remove(position);
        this.dataMap.put(position, data);
        if (data.hasBlockEntity()) {
            this.entityMap.put(position, ((ITileEntity)((Object)data.getBlock())).newBlockEntity(position, data));
        } else {
            this.entityMap.put(position, null);
        }
        CraftBlockState state = (CraftBlockState)CraftBlock.at(this, position).getState();
        state.setFlag(flag);
        state.setWorldHandle(this.world);
        this.list.put(position, state);
        return true;
    }

    @Override
    public WorldServer getMinecraftWorld() {
        return this.world.getMinecraftWorld();
    }

    public void refreshTiles() {
        for (CraftBlockState state : this.list.values()) {
            if (!(state instanceof CraftBlockEntityState)) continue;
            ((CraftBlockEntityState)state).refreshSnapshot();
        }
    }

    public void updateList() {
        for (BlockState blockState : this.list.values()) {
            blockState.update(true);
        }
    }

    public Set<BlockPosition> getBlocks() {
        return this.list.keySet();
    }

    public List<CraftBlockState> getList() {
        return new ArrayList<CraftBlockState>(this.list.values());
    }

    public GeneratorAccess getWorld() {
        return this.world;
    }

    @Override
    public int getMinBuildHeight() {
        return this.getWorld().getMinBuildHeight();
    }

    @Override
    public int getHeight() {
        return this.getWorld().getHeight();
    }

    @Override
    public boolean isStateAtPosition(BlockPosition blockposition, Predicate<IBlockData> predicate) {
        return predicate.test(this.getBlockState(blockposition));
    }

    @Override
    public boolean isFluidAtPosition(BlockPosition bp, Predicate<Fluid> prdct) {
        return this.world.isFluidAtPosition(bp, prdct);
    }

    @Override
    public DimensionManager dimensionType() {
        return this.world.dimensionType();
    }

    @Override
    public IRegistryCustom registryAccess() {
        return this.world.registryAccess();
    }

    @Override
    public WorldData getLevelData() {
        return this.world.getLevelData();
    }

    @Override
    public long nextSubTickCount() {
        return this.world.nextSubTickCount();
    }
}

