/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.util;

import net.minecraft.core.BaseBlockPosition;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftEntity;
import org.bukkit.entity.Entity;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public final class CraftRayTraceResult {
    private CraftRayTraceResult() {
    }

    public static RayTraceResult fromNMS(World world, MovingObjectPosition nmsHitResult) {
        if (nmsHitResult == null || nmsHitResult.getType() == MovingObjectPosition.EnumMovingObjectType.MISS) {
            return null;
        }
        Vec3D nmsHitPos = nmsHitResult.getLocation();
        Vector hitPosition = new Vector(nmsHitPos.x, nmsHitPos.y, nmsHitPos.z);
        BlockFace hitBlockFace = null;
        if (nmsHitResult.getType() == MovingObjectPosition.EnumMovingObjectType.ENTITY) {
            CraftEntity hitEntity = ((MovingObjectPositionEntity)nmsHitResult).getEntity().getBukkitEntity();
            return new RayTraceResult(hitPosition, (Entity)hitEntity, null);
        }
        Block hitBlock = null;
        BaseBlockPosition nmsBlockPos = null;
        if (nmsHitResult.getType() == MovingObjectPosition.EnumMovingObjectType.BLOCK) {
            MovingObjectPositionBlock blockHitResult = (MovingObjectPositionBlock)nmsHitResult;
            hitBlockFace = CraftBlock.notchToBlockFace(blockHitResult.getDirection());
            nmsBlockPos = blockHitResult.getBlockPos();
        }
        if (nmsBlockPos != null && world != null) {
            hitBlock = world.getBlockAt(nmsBlockPos.getX(), nmsBlockPos.getY(), nmsBlockPos.getZ());
        }
        return new RayTraceResult(hitPosition, hitBlock, hitBlockFace);
    }
}

