/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.util;

import net.minecraft.world.entity.EnumCreatureType;
import org.bukkit.entity.SpawnCategory;

public class CraftSpawnCategory {
    public static boolean isValidForLimits(SpawnCategory spawnCategory) {
        return spawnCategory != null && spawnCategory != SpawnCategory.MISC;
    }

    public static String getConfigNameSpawnLimit(SpawnCategory spawnCategory) {
        return switch (spawnCategory) {
            case SpawnCategory.MONSTER -> "spawn-limits.monsters";
            case SpawnCategory.ANIMAL -> "spawn-limits.animals";
            case SpawnCategory.WATER_ANIMAL -> "spawn-limits.water-animals";
            case SpawnCategory.WATER_AMBIENT -> "spawn-limits.water-ambient";
            case SpawnCategory.WATER_UNDERGROUND_CREATURE -> "spawn-limits.water-underground-creature";
            case SpawnCategory.AMBIENT -> "spawn-limits.ambient";
            case SpawnCategory.AXOLOTL -> "spawn-limits.axolotls";
            default -> throw new UnsupportedOperationException("Unknown Config value " + String.valueOf(spawnCategory) + " for spawn-limits");
        };
    }

    public static String getConfigNameTicksPerSpawn(SpawnCategory spawnCategory) {
        return switch (spawnCategory) {
            case SpawnCategory.MONSTER -> "ticks-per.monster-spawns";
            case SpawnCategory.ANIMAL -> "ticks-per.animal-spawns";
            case SpawnCategory.WATER_ANIMAL -> "ticks-per.water-spawns";
            case SpawnCategory.WATER_AMBIENT -> "ticks-per.water-ambient-spawns";
            case SpawnCategory.WATER_UNDERGROUND_CREATURE -> "ticks-per.water-underground-creature-spawns";
            case SpawnCategory.AMBIENT -> "ticks-per.ambient-spawns";
            case SpawnCategory.AXOLOTL -> "ticks-per.axolotl-spawns";
            default -> throw new UnsupportedOperationException("Unknown Config value " + String.valueOf(spawnCategory) + " for ticks-per");
        };
    }

    public static long getDefaultTicksPerSpawn(SpawnCategory spawnCategory) {
        return switch (spawnCategory) {
            case SpawnCategory.MONSTER, SpawnCategory.WATER_ANIMAL, SpawnCategory.WATER_AMBIENT, SpawnCategory.WATER_UNDERGROUND_CREATURE, SpawnCategory.AMBIENT, SpawnCategory.AXOLOTL -> 1L;
            case SpawnCategory.ANIMAL -> 400L;
            default -> throw new UnsupportedOperationException("Unknown Config value " + String.valueOf(spawnCategory) + " for ticks-per");
        };
    }

    public static SpawnCategory toBukkit(EnumCreatureType enumCreatureType) {
        return switch (enumCreatureType) {
            case EnumCreatureType.MONSTER -> SpawnCategory.MONSTER;
            case EnumCreatureType.CREATURE -> SpawnCategory.ANIMAL;
            case EnumCreatureType.AMBIENT -> SpawnCategory.AMBIENT;
            case EnumCreatureType.AXOLOTLS -> SpawnCategory.AXOLOTL;
            case EnumCreatureType.WATER_CREATURE -> SpawnCategory.WATER_ANIMAL;
            case EnumCreatureType.WATER_AMBIENT -> SpawnCategory.WATER_AMBIENT;
            case EnumCreatureType.UNDERGROUND_WATER_CREATURE -> SpawnCategory.WATER_UNDERGROUND_CREATURE;
            case EnumCreatureType.MISC -> SpawnCategory.MISC;
            default -> throw new UnsupportedOperationException("Unknown EnumCreatureType " + String.valueOf(enumCreatureType) + " for SpawnCategory");
        };
    }

    public static EnumCreatureType toNMS(SpawnCategory spawnCategory) {
        return switch (spawnCategory) {
            case SpawnCategory.MONSTER -> EnumCreatureType.MONSTER;
            case SpawnCategory.ANIMAL -> EnumCreatureType.CREATURE;
            case SpawnCategory.AMBIENT -> EnumCreatureType.AMBIENT;
            case SpawnCategory.AXOLOTL -> EnumCreatureType.AXOLOTLS;
            case SpawnCategory.WATER_ANIMAL -> EnumCreatureType.WATER_CREATURE;
            case SpawnCategory.WATER_AMBIENT -> EnumCreatureType.WATER_AMBIENT;
            case SpawnCategory.WATER_UNDERGROUND_CREATURE -> EnumCreatureType.UNDERGROUND_WATER_CREATURE;
            case SpawnCategory.MISC -> EnumCreatureType.MISC;
            default -> throw new UnsupportedOperationException("Unknown SpawnCategory " + String.valueOf(spawnCategory) + " for EnumCreatureType");
        };
    }
}

