/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.util;

import net.minecraft.core.BlockPosition;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.material.Fluid;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlockStates;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftStructureTransformer;
import org.bukkit.craftbukkit.v1_21_R1.util.DelegatedGeneratorAccess;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class TransformerGeneratorAccess
extends DelegatedGeneratorAccess {
    private CraftStructureTransformer structureTransformer;

    public void setStructureTransformer(CraftStructureTransformer structureTransformer) {
        this.structureTransformer = structureTransformer;
    }

    public CraftStructureTransformer getStructureTransformer() {
        return this.structureTransformer;
    }

    @Override
    public boolean addFreshEntity(Entity arg0) {
        if (this.structureTransformer != null && !this.structureTransformer.transformEntity(arg0)) {
            return false;
        }
        return super.addFreshEntity(arg0);
    }

    @Override
    public boolean addFreshEntity(Entity arg0, CreatureSpawnEvent.SpawnReason arg1) {
        if (this.structureTransformer != null && !this.structureTransformer.transformEntity(arg0)) {
            return false;
        }
        return super.addFreshEntity(arg0, arg1);
    }

    @Override
    public void addFreshEntityWithPassengers(Entity arg0) {
        if (this.structureTransformer != null && !this.structureTransformer.transformEntity(arg0)) {
            return;
        }
        super.addFreshEntityWithPassengers(arg0);
    }

    @Override
    public void addFreshEntityWithPassengers(Entity arg0, CreatureSpawnEvent.SpawnReason arg1) {
        if (this.structureTransformer != null && !this.structureTransformer.transformEntity(arg0)) {
            return;
        }
        super.addFreshEntityWithPassengers(arg0, arg1);
    }

    public boolean setCraftBlock(BlockPosition position, CraftBlockState craftBlockState, int i2, int j2) {
        TileEntity tileEntity;
        if (this.structureTransformer != null) {
            craftBlockState = this.structureTransformer.transformCraftState(craftBlockState);
        }
        IBlockData iblockdata = craftBlockState.getHandle();
        boolean result = super.setBlock(position, iblockdata, i2, j2);
        Fluid fluid = this.getFluidState(position);
        if (!fluid.isEmpty()) {
            this.scheduleTick(position, fluid.getType(), 0);
        }
        if (StructurePiece.SHAPE_CHECK_BLOCKS.contains(iblockdata.getBlock())) {
            this.getChunk(position).markPosForPostprocessing(position);
        }
        if ((tileEntity = this.getBlockEntity(position)) != null && craftBlockState instanceof CraftBlockEntityState) {
            CraftBlockEntityState craftEntityState = (CraftBlockEntityState)craftBlockState;
            tileEntity.loadWithComponents(craftEntityState.getSnapshotNBT(), this.registryAccess());
        }
        return result;
    }

    public boolean setCraftBlock(BlockPosition position, CraftBlockState craftBlockState, int i2) {
        return this.setCraftBlock(position, craftBlockState, i2, 512);
    }

    @Override
    public boolean setBlock(BlockPosition position, IBlockData iblockdata, int i2, int j2) {
        if (this.structureTransformer == null || !this.structureTransformer.canTransformBlocks()) {
            return super.setBlock(position, iblockdata, i2, j2);
        }
        return this.setCraftBlock(position, (CraftBlockState)CraftBlockStates.getBlockState((IWorldReader)this, position, iblockdata, null), i2, j2);
    }

    @Override
    public boolean setBlock(BlockPosition position, IBlockData iblockdata, int i2) {
        return this.setBlock(position, iblockdata, i2, 512);
    }
}

