/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTNumber;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.nbt.NBTTagType;
import net.minecraft.nbt.NBTTagTypes;
import net.minecraft.nbt.ReportedNbtException;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.TagVisitor;

public class NBTTagCompound
implements NBTBase {
    public static final Codec<NBTTagCompound> a = Codec.PASSTHROUGH.comapFlatMap(var0 -> {
        NBTBase var1 = (NBTBase)var0.convert((DynamicOps)DynamicOpsNBT.a).getValue();
        if (var1 instanceof NBTTagCompound) {
            NBTTagCompound var2 = (NBTTagCompound)var1;
            return DataResult.success((Object)(var2 == var0.getValue() ? var2.i() : var2));
        }
        return DataResult.error(() -> "Not a compound tag: " + String.valueOf(var1));
    }, var0 -> new Dynamic((DynamicOps)DynamicOpsNBT.a, (Object)var0.i()));
    private static final int c = 48;
    private static final int w = 32;
    public static final NBTTagType<NBTTagCompound> b = new NBTTagType.b<NBTTagCompound>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public NBTTagCompound a(DataInput var0, NBTReadLimiter var1) throws IOException {
            var1.b();
            try {
                NBTTagCompound nBTTagCompound = 1.d(var0, var1);
                return nBTTagCompound;
            }
            finally {
                var1.c();
            }
        }

        private static NBTTagCompound d(DataInput var0, NBTReadLimiter var1) throws IOException {
            byte var3;
            var1.b(48L);
            HashMap var2 = Maps.newHashMap();
            while ((var3 = var0.readByte()) != 0) {
                NBTBase var5;
                String var4 = 1.e(var0, var1);
                if (var2.put(var4, var5 = NBTTagCompound.a(NBTTagTypes.a(var3), var4, var0, var1)) != null) continue;
                var1.b(36L);
            }
            return new NBTTagCompound(var2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public StreamTagVisitor.b a(DataInput var0, StreamTagVisitor var1, NBTReadLimiter var2) throws IOException {
            var2.b();
            try {
                StreamTagVisitor.b b2 = 1.c(var0, var1, var2);
                return b2;
            }
            finally {
                var2.c();
            }
        }

        private static StreamTagVisitor.b c(DataInput var0, StreamTagVisitor var1, NBTReadLimiter var2) throws IOException {
            byte var3;
            var2.b(48L);
            block13: while ((var3 = var0.readByte()) != 0) {
                NBTTagType<?> var4 = NBTTagTypes.a(var3);
                switch (var1.a(var4)) {
                    case d: {
                        return StreamTagVisitor.b.c;
                    }
                    case c: {
                        NBTTagString.a(var0);
                        var4.b(var0, var2);
                        break block13;
                    }
                    case b: {
                        NBTTagString.a(var0);
                        var4.b(var0, var2);
                        continue block13;
                    }
                    default: {
                        String var5 = 1.e(var0, var2);
                        switch (var1.a(var4, var5)) {
                            case d: {
                                return StreamTagVisitor.b.c;
                            }
                            case c: {
                                var4.b(var0, var2);
                                break block13;
                            }
                            case b: {
                                var4.b(var0, var2);
                                continue block13;
                            }
                        }
                        var2.b(36L);
                        switch (var4.a(var0, var1, var2)) {
                            case c: {
                                return StreamTagVisitor.b.c;
                            }
                        }
                        continue block13;
                    }
                }
            }
            if (var3 != 0) {
                while ((var3 = var0.readByte()) != 0) {
                    NBTTagString.a(var0);
                    NBTTagTypes.a(var3).b(var0, var2);
                }
            }
            return var1.b();
        }

        private static String e(DataInput var0, NBTReadLimiter var1) throws IOException {
            String var2 = var0.readUTF();
            var1.b(28L);
            var1.a(2L, var2.length());
            return var2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void b(DataInput var0, NBTReadLimiter var1) throws IOException {
            var1.b();
            try {
                byte var2;
                while ((var2 = var0.readByte()) != 0) {
                    NBTTagString.a(var0);
                    NBTTagTypes.a(var2).b(var0, var1);
                }
            }
            finally {
                var1.c();
            }
        }

        @Override
        public String a() {
            return "COMPOUND";
        }

        @Override
        public String b() {
            return "TAG_Compound";
        }

        @Override
        public /* synthetic */ NBTBase c(DataInput dataInput, NBTReadLimiter nBTReadLimiter) throws IOException {
            return this.a(dataInput, nBTReadLimiter);
        }
    };
    private final Map<String, NBTBase> x;

    protected NBTTagCompound(Map<String, NBTBase> var0) {
        this.x = var0;
    }

    public NBTTagCompound() {
        this(Maps.newHashMap());
    }

    @Override
    public void a(DataOutput var0) throws IOException {
        for (String var2 : this.x.keySet()) {
            NBTBase var3 = this.x.get(var2);
            NBTTagCompound.a(var2, var3, var0);
        }
        var0.writeByte(0);
    }

    @Override
    public int a() {
        int var0 = 48;
        for (Map.Entry<String, NBTBase> var2 : this.x.entrySet()) {
            var0 += 28 + 2 * var2.getKey().length();
            var0 += 36;
            var0 += var2.getValue().a();
        }
        return var0;
    }

    public Set<String> e() {
        return this.x.keySet();
    }

    @Override
    public byte b() {
        return 10;
    }

    public NBTTagType<NBTTagCompound> c() {
        return b;
    }

    public int f() {
        return this.x.size();
    }

    @Nullable
    public NBTBase a(String var0, NBTBase var1) {
        return this.x.put(var0, var1);
    }

    public void a(String var0, byte var1) {
        this.x.put(var0, NBTTagByte.a(var1));
    }

    public void a(String var0, short var1) {
        this.x.put(var0, NBTTagShort.a(var1));
    }

    public void a(String var0, int var1) {
        this.x.put(var0, NBTTagInt.a(var1));
    }

    public void a(String var0, long var1) {
        this.x.put(var0, NBTTagLong.a(var1));
    }

    public void a(String var0, UUID var1) {
        this.x.put(var0, GameProfileSerializer.a(var1));
    }

    public UUID a(String var0) {
        return GameProfileSerializer.a(this.c(var0));
    }

    public boolean b(String var0) {
        NBTBase var1 = this.c(var0);
        return var1 != null && var1.c() == NBTTagIntArray.a && ((NBTTagIntArray)var1).g().length == 4;
    }

    public void a(String var0, float var1) {
        this.x.put(var0, NBTTagFloat.a(var1));
    }

    public void a(String var0, double var1) {
        this.x.put(var0, NBTTagDouble.a(var1));
    }

    public void a(String var0, String var1) {
        this.x.put(var0, NBTTagString.a(var1));
    }

    public void a(String var0, byte[] var1) {
        this.x.put(var0, new NBTTagByteArray(var1));
    }

    public void a(String var0, List<Byte> var1) {
        this.x.put(var0, new NBTTagByteArray(var1));
    }

    public void a(String var0, int[] var1) {
        this.x.put(var0, new NBTTagIntArray(var1));
    }

    public void b(String var0, List<Integer> var1) {
        this.x.put(var0, new NBTTagIntArray(var1));
    }

    public void a(String var0, long[] var1) {
        this.x.put(var0, new NBTTagLongArray(var1));
    }

    public void c(String var0, List<Long> var1) {
        this.x.put(var0, new NBTTagLongArray(var1));
    }

    public void a(String var0, boolean var1) {
        this.x.put(var0, NBTTagByte.a(var1));
    }

    @Nullable
    public NBTBase c(String var0) {
        return this.x.get(var0);
    }

    public byte d(String var0) {
        NBTBase var1 = this.x.get(var0);
        if (var1 == null) {
            return 0;
        }
        return var1.b();
    }

    public boolean e(String var0) {
        return this.x.containsKey(var0);
    }

    public boolean b(String var0, int var1) {
        byte var2 = this.d(var0);
        if (var2 == var1) {
            return true;
        }
        if (var1 == 99) {
            return var2 == 1 || var2 == 2 || var2 == 3 || var2 == 4 || var2 == 5 || var2 == 6;
        }
        return false;
    }

    public byte f(String var0) {
        try {
            if (this.b(var0, 99)) {
                return ((NBTNumber)this.x.get(var0)).i();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0;
    }

    public short g(String var0) {
        try {
            if (this.b(var0, 99)) {
                return ((NBTNumber)this.x.get(var0)).h();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0;
    }

    public int h(String var0) {
        try {
            if (this.b(var0, 99)) {
                return ((NBTNumber)this.x.get(var0)).g();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0;
    }

    public long i(String var0) {
        try {
            if (this.b(var0, 99)) {
                return ((NBTNumber)this.x.get(var0)).f();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0L;
    }

    public float j(String var0) {
        try {
            if (this.b(var0, 99)) {
                return ((NBTNumber)this.x.get(var0)).k();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0.0f;
    }

    public double k(String var0) {
        try {
            if (this.b(var0, 99)) {
                return ((NBTNumber)this.x.get(var0)).j();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0.0;
    }

    public String l(String var0) {
        try {
            if (this.b(var0, 8)) {
                return this.x.get(var0).s_();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return "";
    }

    public byte[] m(String var0) {
        try {
            if (this.b(var0, 7)) {
                return ((NBTTagByteArray)this.x.get(var0)).e();
            }
        }
        catch (ClassCastException var1) {
            throw new ReportedException(this.a(var0, NBTTagByteArray.a, var1));
        }
        return new byte[0];
    }

    public int[] n(String var0) {
        try {
            if (this.b(var0, 11)) {
                return ((NBTTagIntArray)this.x.get(var0)).g();
            }
        }
        catch (ClassCastException var1) {
            throw new ReportedException(this.a(var0, NBTTagIntArray.a, var1));
        }
        return new int[0];
    }

    public long[] o(String var0) {
        try {
            if (this.b(var0, 12)) {
                return ((NBTTagLongArray)this.x.get(var0)).g();
            }
        }
        catch (ClassCastException var1) {
            throw new ReportedException(this.a(var0, NBTTagLongArray.a, var1));
        }
        return new long[0];
    }

    public NBTTagCompound p(String var0) {
        try {
            if (this.b(var0, 10)) {
                return (NBTTagCompound)this.x.get(var0);
            }
        }
        catch (ClassCastException var1) {
            throw new ReportedException(this.a(var0, b, var1));
        }
        return new NBTTagCompound();
    }

    public NBTTagList c(String var0, int var1) {
        try {
            if (this.d(var0) == 9) {
                NBTTagList var2 = (NBTTagList)this.x.get(var0);
                if (var2.isEmpty() || var2.f() == var1) {
                    return var2;
                }
                return new NBTTagList();
            }
        }
        catch (ClassCastException var2) {
            throw new ReportedException(this.a(var0, NBTTagList.a, var2));
        }
        return new NBTTagList();
    }

    public boolean q(String var0) {
        return this.f(var0) != 0;
    }

    public void r(String var0) {
        this.x.remove(var0);
    }

    @Override
    public String toString() {
        return this.s_();
    }

    public boolean g() {
        return this.x.isEmpty();
    }

    private CrashReport a(String var0, NBTTagType<?> var1, ClassCastException var2) {
        CrashReport var3 = CrashReport.a(var2, "Reading NBT data");
        CrashReportSystemDetails var4 = var3.a("Corrupt NBT tag", 1);
        var4.a("Tag type found", () -> this.x.get(var0).c().a());
        var4.a("Tag type expected", var1::a);
        var4.a("Tag name", var0);
        return var3;
    }

    protected NBTTagCompound h() {
        return new NBTTagCompound(new HashMap<String, NBTBase>(this.x));
    }

    public NBTTagCompound i() {
        HashMap var0 = Maps.newHashMap((Map)Maps.transformValues(this.x, NBTBase::d));
        return new NBTTagCompound(var0);
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        return var0 instanceof NBTTagCompound && Objects.equals(this.x, ((NBTTagCompound)var0).x);
    }

    public int hashCode() {
        return this.x.hashCode();
    }

    private static void a(String var0, NBTBase var1, DataOutput var2) throws IOException {
        var2.writeByte(var1.b());
        if (var1.b() == 0) {
            return;
        }
        var2.writeUTF(var0);
        var1.a(var2);
    }

    static NBTBase a(NBTTagType<?> var0, String var1, DataInput var2, NBTReadLimiter var3) {
        try {
            return var0.c(var2, var3);
        }
        catch (IOException var4) {
            CrashReport var5 = CrashReport.a(var4, "Loading NBT data");
            CrashReportSystemDetails var6 = var5.a("NBT Tag");
            var6.a("Tag name", var1);
            var6.a("Tag type", var0.a());
            throw new ReportedNbtException(var5);
        }
    }

    public NBTTagCompound a(NBTTagCompound var0) {
        for (String var2 : var0.x.keySet()) {
            NBTBase var3 = var0.x.get(var2);
            if (var3.b() == 10) {
                if (this.b(var2, 10)) {
                    NBTTagCompound var4 = this.p(var2);
                    var4.a((NBTTagCompound)var3);
                    continue;
                }
                this.a(var2, var3.d());
                continue;
            }
            this.a(var2, var3.d());
        }
        return this;
    }

    @Override
    public void a(TagVisitor var0) {
        var0.a(this);
    }

    protected Set<Map.Entry<String, NBTBase>> j() {
        return this.x.entrySet();
    }

    @Override
    public StreamTagVisitor.b a(StreamTagVisitor var0) {
        block14: for (Map.Entry<String, NBTBase> var2 : this.x.entrySet()) {
            NBTBase var3 = var2.getValue();
            NBTTagType<?> var4 = var3.c();
            StreamTagVisitor.a var5 = var0.a(var4);
            switch (var5) {
                case d: {
                    return StreamTagVisitor.b.c;
                }
                case c: {
                    return var0.b();
                }
                case b: {
                    continue block14;
                }
            }
            var5 = var0.a(var4, var2.getKey());
            switch (var5) {
                case d: {
                    return StreamTagVisitor.b.c;
                }
                case c: {
                    return var0.b();
                }
                case b: {
                    continue block14;
                }
            }
            StreamTagVisitor.b var6 = var3.a(var0);
            switch (var6) {
                case c: {
                    return StreamTagVisitor.b.c;
                }
                case b: {
                    return var0.b();
                }
            }
        }
        return var0.b();
    }

    @Override
    public /* synthetic */ NBTBase d() {
        return this.i();
    }
}

