/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.gson.JsonParser;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.util.INamable;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ChatHoverable {
    public static final Codec<ChatHoverable> a = Codec.withAlternative((Codec)e.a.codec(), (Codec)e.b.codec()).xmap(ChatHoverable::new, var0 -> var0.b);
    private final e<?> b;

    public <T> ChatHoverable(EnumHoverAction<T> var0, T var1) {
        this(new e<T>(var0, var1));
    }

    private ChatHoverable(e<?> var0) {
        this.b = var0;
    }

    public EnumHoverAction<?> a() {
        return this.b.c;
    }

    @Nullable
    public <T> T a(EnumHoverAction<T> var0) {
        if (this.b.c == var0) {
            return var0.a(this.b.d);
        }
        return null;
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (var0 == null || this.getClass() != var0.getClass()) {
            return false;
        }
        return ((ChatHoverable)var0).b.equals(this.b);
    }

    public String toString() {
        return this.b.toString();
    }

    public int hashCode() {
        return this.b.hashCode();
    }

    static final class e<T>
    extends Record {
        final EnumHoverAction<T> c;
        final T d;
        public static final MapCodec<e<?>> a = EnumHoverAction.e.dispatchMap("action", e::a, var0 -> var0.h);
        public static final MapCodec<e<?>> b = EnumHoverAction.e.dispatchMap("action", e::a, var0 -> var0.i);

        e(EnumHoverAction<T> var0, T var1) {
            this.c = var0;
            this.d = var1;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{e.class, "action;value", "c", "d"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{e.class, "action;value", "c", "d"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{e.class, "action;value", "c", "d"}, this, var0);
        }

        public EnumHoverAction<T> a() {
            return this.c;
        }

        public T b() {
            return this.d;
        }
    }

    public static class EnumHoverAction<T>
    implements INamable {
        public static final EnumHoverAction<IChatBaseComponent> a = new EnumHoverAction<IChatBaseComponent>("show_text", true, ComponentSerialization.a, (var0, var1) -> DataResult.success((Object)var0));
        public static final EnumHoverAction<c> b = new EnumHoverAction<c>("show_item", true, net.minecraft.network.chat.ChatHoverable$c.b, c::a);
        public static final EnumHoverAction<b> c = new EnumHoverAction<b>("show_entity", true, net.minecraft.network.chat.ChatHoverable$b.a, b::a);
        public static final Codec<EnumHoverAction<?>> d = INamable.b(() -> new EnumHoverAction[]{a, b, c});
        public static final Codec<EnumHoverAction<?>> e = d.validate(EnumHoverAction::a);
        private final String f;
        private final boolean g;
        final MapCodec<e<T>> h;
        final MapCodec<e<T>> i;

        public EnumHoverAction(String var02, boolean var1, Codec<T> var2, final d<T> var3) {
            this.f = var02;
            this.g = var1;
            this.h = var2.xmap(var0 -> new e<Object>(this, var0), var0 -> var0.d).fieldOf("contents");
            this.i = new Codec<e<T>>(){

                public <D> DataResult<Pair<e<T>, D>> decode(DynamicOps<D> var0, D var1) {
                    return ComponentSerialization.a.decode(var0, var1).flatMap(var2 -> {
                        DataResult var32;
                        if (var0 instanceof RegistryOps) {
                            RegistryOps var4 = (RegistryOps)var0;
                            var32 = var3.parse((IChatBaseComponent)var2.getFirst(), var4);
                        } else {
                            var32 = var3.parse((IChatBaseComponent)var2.getFirst(), null);
                        }
                        return var32.map(var1 -> Pair.of(new e<Object>(this, var1), (Object)var2.getSecond()));
                    });
                }

                public <D> DataResult<D> a(e<T> var0, DynamicOps<D> var1, D var2) {
                    return DataResult.error(() -> "Can't encode in legacy format");
                }

                public /* synthetic */ DataResult encode(Object object, DynamicOps dynamicOps, Object object2) {
                    return this.a((e)object, dynamicOps, object2);
                }
            }.fieldOf("value");
        }

        public boolean a() {
            return this.g;
        }

        @Override
        public String c() {
            return this.f;
        }

        T a(Object var0) {
            return (T)var0;
        }

        public String toString() {
            return "<action " + this.f + ">";
        }

        private static DataResult<EnumHoverAction<?>> a(@Nullable EnumHoverAction<?> var0) {
            if (var0 == null) {
                return DataResult.error(() -> "Unknown action");
            }
            if (!var0.a()) {
                return DataResult.error(() -> "Action not allowed: " + String.valueOf(var0));
            }
            return DataResult.success(var0, (Lifecycle)Lifecycle.stable());
        }
    }

    public static interface d<T> {
        public DataResult<T> parse(IChatBaseComponent var1, @Nullable RegistryOps<?> var2);
    }

    public static class c {
        public static final Codec<c> a = ItemStack.b.xmap(c::new, c::a);
        private static final Codec<c> c = ItemStack.g.xmap(c::new, c::a);
        public static final Codec<c> b = Codec.withAlternative(a, c);
        private final Holder<Item> d;
        private final int e;
        private final DataComponentPatch f;
        @Nullable
        private ItemStack g;

        c(Holder<Item> var0, int var1, DataComponentPatch var2) {
            this.d = var0;
            this.e = var1;
            this.f = var2;
        }

        public c(ItemStack var0) {
            this(var0.h(), var0.H(), var0.d());
        }

        public boolean equals(Object var0) {
            if (this == var0) {
                return true;
            }
            if (var0 == null || this.getClass() != var0.getClass()) {
                return false;
            }
            c var1 = (c)var0;
            return this.e == var1.e && this.d.equals(var1.d) && this.f.equals(var1.f);
        }

        public int hashCode() {
            int var0 = this.d.hashCode();
            var0 = 31 * var0 + this.e;
            var0 = 31 * var0 + this.f.hashCode();
            return var0;
        }

        public ItemStack a() {
            if (this.g == null) {
                this.g = new ItemStack(this.d, this.e, this.f);
            }
            return this.g;
        }

        private static DataResult<c> a(IChatBaseComponent var0, @Nullable RegistryOps<?> var1) {
            try {
                NBTTagCompound var2 = MojangsonParser.a(var0.getString());
                DynamicOpsNBT var3 = var1 != null ? var1.a(DynamicOpsNBT.a) : DynamicOpsNBT.a;
                return ItemStack.b.parse((DynamicOps)var3, (Object)var2).map(c::new);
            }
            catch (CommandSyntaxException var2) {
                return DataResult.error(() -> "Failed to parse item tag: " + var2.getMessage());
            }
        }
    }

    public static class b {
        public static final Codec<b> a = RecordCodecBuilder.create(var02 -> var02.group((App)BuiltInRegistries.f.r().fieldOf("type").forGetter(var0 -> var0.b), (App)UUIDUtil.f.fieldOf("id").forGetter(var0 -> var0.c), (App)ComponentSerialization.a.lenientOptionalFieldOf("name").forGetter(var0 -> var0.d)).apply((Applicative)var02, b::new));
        public final EntityTypes<?> b;
        public final UUID c;
        public final Optional<IChatBaseComponent> d;
        @Nullable
        private List<IChatBaseComponent> e;

        public b(EntityTypes<?> var0, UUID var1, @Nullable IChatBaseComponent var2) {
            this(var0, var1, Optional.ofNullable(var2));
        }

        public b(EntityTypes<?> var0, UUID var1, Optional<IChatBaseComponent> var2) {
            this.b = var0;
            this.c = var1;
            this.d = var2;
        }

        public static DataResult<b> a(IChatBaseComponent var0, @Nullable RegistryOps<?> var1) {
            try {
                NBTTagCompound var22 = MojangsonParser.a(var0.getString());
                JsonOps var3 = var1 != null ? var1.a(JsonOps.INSTANCE) : JsonOps.INSTANCE;
                DataResult var4 = ComponentSerialization.a.parse((DynamicOps)var3, (Object)JsonParser.parseString((String)var22.l("name")));
                EntityTypes<?> var5 = BuiltInRegistries.f.a(MinecraftKey.a(var22.l("type")));
                UUID var6 = UUID.fromString(var22.l("id"));
                return var4.map(var2 -> new b(var5, var6, (IChatBaseComponent)var2));
            }
            catch (Exception var23) {
                return DataResult.error(() -> "Failed to parse tooltip: " + var23.getMessage());
            }
        }

        public List<IChatBaseComponent> a() {
            if (this.e == null) {
                this.e = new ArrayList<IChatBaseComponent>();
                this.d.ifPresent(this.e::add);
                this.e.add(IChatBaseComponent.a("gui.entity_tooltip.type", this.b.h()));
                this.e.add(IChatBaseComponent.b(this.c.toString()));
            }
            return this.e;
        }

        public boolean equals(Object var0) {
            if (this == var0) {
                return true;
            }
            if (var0 == null || this.getClass() != var0.getClass()) {
                return false;
            }
            b var1 = (b)var0;
            return this.b.equals(var1.b) && this.c.equals(var1.c) && this.d.equals(var1.d);
        }

        public int hashCode() {
            int var0 = this.b.hashCode();
            var0 = 31 * var0 + this.c.hashCode();
            var0 = 31 * var0 + this.d.hashCode();
            return var0;
        }
    }
}

