/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.SystemUtils;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.IRegistryWritable;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.RegistryMaterials;
import net.minecraft.core.RegistrySynchronization;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.packs.repository.KnownPack;
import net.minecraft.server.packs.resources.IResource;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.animal.WolfVariant;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.item.JukeboxSong;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimPattern;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.providers.EnchantmentProvider;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterList;
import net.minecraft.world.level.block.entity.EnumBannerPatternType;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.GeneratorSettingBase;
import net.minecraft.world.level.levelgen.carver.WorldGenCarverWrapper;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.flat.FlatLevelGeneratorPreset;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureStructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorList;
import net.minecraft.world.level.levelgen.synth.NoiseGeneratorNormal;
import org.slf4j.Logger;

public class RegistryDataLoader {
    private static final Logger d = LogUtils.getLogger();
    private static final RegistrationInfo e = new RegistrationInfo(Optional.empty(), Lifecycle.experimental());
    private static final Function<Optional<KnownPack>, RegistrationInfo> f = SystemUtils.b((T var02) -> {
        Lifecycle var1 = var02.map(KnownPack::a).map(var0 -> Lifecycle.stable()).orElse(Lifecycle.experimental());
        return new RegistrationInfo((Optional<KnownPack>)var02, var1);
    });
    public static final List<c<?>> a = List.of(new c<DimensionManager>(Registries.aK, DimensionManager.h), new c<BiomeBase>(Registries.aF, BiomeBase.a), new c<ChatMessageType>(Registries.aG, ChatMessageType.a), new c(Registries.aH, WorldGenCarverWrapper.a), new c(Registries.aI, WorldGenFeatureConfigured.a), new c<PlacedFeature>(Registries.aQ, PlacedFeature.a), new c<Structure>(Registries.aR, Structure.a), new c<StructureSet>(Registries.aT, StructureSet.a), new c<ProcessorList>(Registries.aS, DefinedStructureStructureProcessorType.c), new c<WorldGenFeatureDefinedStructurePoolTemplate>(Registries.aU, WorldGenFeatureDefinedStructurePoolTemplate.a), new c<GeneratorSettingBase>(Registries.aO, GeneratorSettingBase.a), new c<NoiseGeneratorNormal.a>(Registries.aP, NoiseGeneratorNormal.a.a), new c<DensityFunction>(Registries.aJ, DensityFunction.b), new c<WorldPreset>(Registries.aY, WorldPreset.a), new c<FlatLevelGeneratorPreset>(Registries.aN, FlatLevelGeneratorPreset.a), new c<TrimPattern>(Registries.aX, TrimPattern.a), new c<TrimMaterial>(Registries.aW, TrimMaterial.a), new c<WolfVariant>(Registries.m, WolfVariant.a, true), new c<PaintingVariant>(Registries.X, PaintingVariant.a, true), new c<DamageType>(Registries.s, DamageType.a), new c<MultiNoiseBiomeSourceParameterList>(Registries.aZ, MultiNoiseBiomeSourceParameterList.a), new c<EnumBannerPatternType>(Registries.d, EnumBannerPatternType.a), new c<Enchantment>(Registries.aL, Enchantment.b), new c<EnchantmentProvider>(Registries.aM, EnchantmentProvider.a), new c<JukeboxSong>(Registries.L, JukeboxSong.a));
    public static final List<c<?>> b = List.of(new c<WorldDimension>(Registries.bb, WorldDimension.a));
    public static final List<c<?>> c = List.of(new c<BiomeBase>(Registries.aF, BiomeBase.b), new c<ChatMessageType>(Registries.aG, ChatMessageType.a), new c<TrimPattern>(Registries.aX, TrimPattern.a), new c<TrimMaterial>(Registries.aW, TrimMaterial.a), new c<WolfVariant>(Registries.m, WolfVariant.a, true), new c<PaintingVariant>(Registries.X, PaintingVariant.a, true), new c<DimensionManager>(Registries.aK, DimensionManager.h), new c<DamageType>(Registries.s, DamageType.a), new c<EnumBannerPatternType>(Registries.d, EnumBannerPatternType.a), new c<Enchantment>(Registries.aL, Enchantment.b), new c<JukeboxSong>(Registries.L, JukeboxSong.a));

    public static IRegistryCustom.Dimension a(IResourceManager var0, IRegistryCustom var12, List<c<?>> var22) {
        return RegistryDataLoader.a((a<?> var1, RegistryOps.c var2) -> var1.a(var0, var2), var12, var22);
    }

    public static IRegistryCustom.Dimension a(Map<ResourceKey<? extends IRegistry<?>>, List<RegistrySynchronization.a>> var0, ResourceProvider var1, IRegistryCustom var22, List<c<?>> var32) {
        return RegistryDataLoader.a((a<?> var2, RegistryOps.c var3) -> var2.a(var0, var1, var3), var22, var32);
    }

    private static IRegistryCustom.Dimension a(b var0, IRegistryCustom var12, List<c<?>> var22) {
        HashMap var3 = new HashMap();
        List<a<?>> var4 = var22.stream().map(var1 -> var1.a(Lifecycle.stable(), var3)).collect(Collectors.toUnmodifiableList());
        RegistryOps.c var5 = RegistryDataLoader.a(var12, var4);
        var4.forEach(var2 -> var0.apply((a<?>)var2, var5));
        var4.forEach(var1 -> {
            IRegistryWritable var2 = var1.b();
            try {
                var2.m();
            }
            catch (Exception var3) {
                var3.put(var2.d(), var3);
            }
            if (var1.a.c && var2.c() == 0) {
                var3.put(var2.d(), new IllegalStateException("Registry must be non-empty"));
            }
        });
        if (!var3.isEmpty()) {
            RegistryDataLoader.a(var3);
            throw new IllegalStateException("Failed to load registries due to above errors");
        }
        return new IRegistryCustom.c(var4.stream().map(a::b).toList()).d();
    }

    private static RegistryOps.c a(IRegistryCustom var0, List<a<?>> var12) {
        final HashMap var2 = new HashMap();
        var0.c().forEach(var1 -> var2.put(var1.a(), RegistryDataLoader.a(var1.b())));
        var12.forEach(var1 -> var2.put(var1.b.d(), RegistryDataLoader.a(var1.b)));
        return new RegistryOps.c(){

            @Override
            public <T> Optional<RegistryOps.b<T>> a(ResourceKey<? extends IRegistry<? extends T>> var0) {
                return Optional.ofNullable((RegistryOps.b)var2.get(var0));
            }
        };
    }

    private static <T> RegistryOps.b<T> a(IRegistryWritable<T> var0) {
        return new RegistryOps.b(var0.q(), var0.o(), var0.e());
    }

    private static <T> RegistryOps.b<T> a(IRegistry<T> var0) {
        return new RegistryOps.b<T>(var0.q(), var0.v(), var0.e());
    }

    private static void a(Map<ResourceKey<?>, Exception> var02) {
        StringWriter var1 = new StringWriter();
        PrintWriter var2 = new PrintWriter(var1);
        Map<MinecraftKey, Map<MinecraftKey, Exception>> var3 = var02.entrySet().stream().collect(Collectors.groupingBy(var0 -> ((ResourceKey)var0.getKey()).b(), Collectors.toMap(var0 -> ((ResourceKey)var0.getKey()).a(), Map.Entry::getValue)));
        var3.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(var12 -> {
            var2.printf("> Errors in registry %s:%n", var12.getKey());
            ((Map)var12.getValue()).entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(var1 -> {
                var2.printf(">> Errors in element %s:%n", var1.getKey());
                ((Exception)var1.getValue()).printStackTrace(var2);
            });
        });
        var2.flush();
        d.error("Registry loading errors:\n{}", (Object)var1);
    }

    private static <E> void a(IRegistryWritable<E> var0, Decoder<E> var1, RegistryOps<JsonElement> var2, ResourceKey<E> var3, IResource var4, RegistrationInfo var5) throws IOException {
        try (BufferedReader var6 = var4.e();){
            JsonElement var7 = JsonParser.parseReader((Reader)var6);
            DataResult var8 = var1.parse(var2, (Object)var7);
            Object var9 = var8.getOrThrow();
            var0.a(var3, var9, var5);
        }
    }

    static <E> void a(IResourceManager var0, RegistryOps.c var1, IRegistryWritable<E> var2, Decoder<E> var3, Map<ResourceKey<?>, Exception> var4) {
        String var5 = Registries.c(var2.d());
        FileToIdConverter var6 = FileToIdConverter.a(var5);
        RegistryOps<JsonElement> var7 = RegistryOps.a(JsonOps.INSTANCE, var1);
        for (Map.Entry<MinecraftKey, IResource> var9 : var6.a(var0).entrySet()) {
            MinecraftKey var10 = var9.getKey();
            ResourceKey var11 = ResourceKey.a(var2.d(), var6.b(var10));
            IResource var12 = var9.getValue();
            RegistrationInfo var13 = f.apply(var12.c());
            try {
                RegistryDataLoader.a(var2, var3, var7, var11, var12, var13);
            }
            catch (Exception var14) {
                var4.put(var11, new IllegalStateException(String.format(Locale.ROOT, "Failed to parse %s from pack %s", var10, var12.b()), var14));
            }
        }
    }

    static <E> void a(Map<ResourceKey<? extends IRegistry<?>>, List<RegistrySynchronization.a>> var0, ResourceProvider var1, RegistryOps.c var2, IRegistryWritable<E> var3, Decoder<E> var4, Map<ResourceKey<?>, Exception> var5) {
        List<RegistrySynchronization.a> var6 = var0.get(var3.d());
        if (var6 == null) {
            return;
        }
        RegistryOps<NBTBase> var7 = RegistryOps.a(DynamicOpsNBT.a, var2);
        RegistryOps<JsonElement> var8 = RegistryOps.a(JsonOps.INSTANCE, var2);
        String var9 = Registries.c(var3.d());
        FileToIdConverter var10 = FileToIdConverter.a(var9);
        for (RegistrySynchronization.a var12 : var6) {
            Object var16;
            MinecraftKey var15;
            ResourceKey var13 = ResourceKey.a(var3.d(), var12.a());
            Optional<NBTBase> var14 = var12.b();
            if (var14.isPresent()) {
                try {
                    var15 = var4.parse(var7, (Object)var14.get());
                    var16 = var15.getOrThrow();
                    var3.a(var13, var16, e);
                }
                catch (Exception var152) {
                    var5.put(var13, new IllegalStateException(String.format(Locale.ROOT, "Failed to parse value %s from server", var14.get()), var152));
                }
                continue;
            }
            var15 = var10.a(var12.a());
            try {
                var16 = var1.getResourceOrThrow(var15);
                RegistryDataLoader.a(var3, var4, var8, var13, (IResource)var16, e);
            }
            catch (Exception var162) {
                var5.put(var13, new IllegalStateException("Failed to parse local data", var162));
            }
        }
    }

    @FunctionalInterface
    static interface b {
        public void apply(a<?> var1, RegistryOps.c var2);
    }

    static final class a<T>
    extends Record {
        final c<T> a;
        final IRegistryWritable<T> b;
        private final Map<ResourceKey<?>, Exception> c;

        a(c<T> var0, IRegistryWritable<T> var1, Map<ResourceKey<?>, Exception> var2) {
            this.a = var0;
            this.b = var1;
            this.c = var2;
        }

        public void a(IResourceManager var0, RegistryOps.c var1) {
            RegistryDataLoader.a(var0, var1, this.b, this.a.b, this.c);
        }

        public void a(Map<ResourceKey<? extends IRegistry<?>>, List<RegistrySynchronization.a>> var0, ResourceProvider var1, RegistryOps.c var2) {
            RegistryDataLoader.a(var0, var1, var2, this.b, this.a.b, this.c);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "data;registry;loadingErrors", "a", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "data;registry;loadingErrors", "a", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "data;registry;loadingErrors", "a", "b", "c"}, this, var0);
        }

        public c<T> a() {
            return this.a;
        }

        public IRegistryWritable<T> b() {
            return this.b;
        }

        public Map<ResourceKey<?>, Exception> c() {
            return this.c;
        }
    }

    public static final class c<T>
    extends Record {
        private final ResourceKey<? extends IRegistry<T>> a;
        final Codec<T> b;
        final boolean c;

        c(ResourceKey<? extends IRegistry<T>> var0, Codec<T> var1) {
            this(var0, var1, false);
        }

        public c(ResourceKey<? extends IRegistry<T>> var0, Codec<T> var1, boolean var2) {
            this.a = var0;
            this.b = var1;
            this.c = var2;
        }

        a<T> a(Lifecycle var0, Map<ResourceKey<?>, Exception> var1) {
            RegistryMaterials var2 = new RegistryMaterials(this.a, var0);
            return new a(this, var2, var1);
        }

        public void a(BiConsumer<ResourceKey<? extends IRegistry<T>>, Codec<T>> var0) {
            var0.accept(this.a, this.b);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "key;elementCodec;requiredNonEmpty", "a", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "key;elementCodec;requiredNonEmpty", "a", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "key;elementCodec;requiredNonEmpty", "a", "b", "c"}, this, var0);
        }

        public ResourceKey<? extends IRegistry<T>> a() {
            return this.a;
        }

        public Codec<T> b() {
            return this.b;
        }

        public boolean c() {
            return this.c;
        }
    }
}

