/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.dedicated;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Proxy;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.logging.Handler;
import javax.annotation.Nullable;
import jline.console.ConsoleReader;
import jline.console.completer.CompletionHandler;
import joptsimple.OptionSet;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.SharedConstants;
import net.minecraft.SystemReport;
import net.minecraft.SystemUtils;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.IMinecraftServer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerCommand;
import net.minecraft.server.ServerLinks;
import net.minecraft.server.Services;
import net.minecraft.server.WorldLoader;
import net.minecraft.server.WorldStem;
import net.minecraft.server.dedicated.DedicatedPlayerList;
import net.minecraft.server.dedicated.DedicatedServerProperties;
import net.minecraft.server.dedicated.DedicatedServerSettings;
import net.minecraft.server.gui.ServerGUI;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.level.progress.WorldLoadListenerFactory;
import net.minecraft.server.network.ITextFilter;
import net.minecraft.server.network.TextFilter;
import net.minecraft.server.packs.repository.ResourcePackRepository;
import net.minecraft.server.players.NameReferencingFileConverter;
import net.minecraft.server.players.UserCache;
import net.minecraft.server.rcon.RemoteControlCommandListener;
import net.minecraft.server.rcon.thread.RemoteControlListener;
import net.minecraft.server.rcon.thread.RemoteStatusListener;
import net.minecraft.util.MathHelper;
import net.minecraft.util.debugchart.DebugSampleSubscriptionTracker;
import net.minecraft.util.debugchart.RemoteDebugSampleType;
import net.minecraft.util.debugchart.RemoteSampleLogger;
import net.minecraft.util.debugchart.SampleLogger;
import net.minecraft.util.debugchart.TpsDebugDimensions;
import net.minecraft.util.monitoring.jmx.MinecraftServerBeans;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.TileEntitySkull;
import net.minecraft.world.level.storage.Convertable;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.io.IoBuilder;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.Main;
import org.bukkit.craftbukkit.v1_21_R1.SpigotTimings;
import org.bukkit.craftbukkit.v1_21_R1.util.ForwardLogHandler;
import org.bukkit.craftbukkit.v1_21_R1.util.TerminalCompletionHandler;
import org.bukkit.craftbukkit.v1_21_R1.util.TerminalConsoleWriterThread;
import org.bukkit.event.Event;
import org.bukkit.event.server.RemoteServerCommandEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginLoadOrder;
import org.spigotmc.SpigotConfig;

public class DedicatedServer
extends MinecraftServer
implements IMinecraftServer {
    static final org.slf4j.Logger k = LogUtils.getLogger();
    private static final int l = 5000;
    private static final int m = 2;
    private final List<ServerCommand> n = Collections.synchronizedList(Lists.newArrayList());
    @Nullable
    private RemoteStatusListener o;
    @Nullable
    private RemoteControlListener q;
    public DedicatedServerSettings r;
    @Nullable
    private ServerGUI s;
    @Nullable
    private final TextFilter t;
    @Nullable
    private RemoteSampleLogger u;
    @Nullable
    private DebugSampleSubscriptionTracker v;
    public ServerLinks w;

    public DedicatedServer(OptionSet options, WorldLoader.a worldLoader, Thread thread, Convertable.ConversionSession convertable_conversionsession, ResourcePackRepository resourcepackrepository, WorldStem worldstem, DedicatedServerSettings dedicatedserversettings, DataFixer datafixer, Services services, WorldLoadListenerFactory worldloadlistenerfactory) {
        super(options, worldLoader, thread, convertable_conversionsession, resourcepackrepository, worldstem, Proxy.NO_PROXY, datafixer, services, worldloadlistenerfactory);
        this.r = dedicatedserversettings;
        this.t = TextFilter.a(dedicatedserversettings.a().T);
        this.w = DedicatedServer.a(dedicatedserversettings);
    }

    @Override
    public boolean e() throws IOException {
        Thread thread = new Thread("Server console handler"){

            @Override
            public void run() {
                if (!Main.useConsole) {
                    return;
                }
                ConsoleReader bufferedreader = DedicatedServer.this.reader;
                try {
                    System.in.available();
                }
                catch (IOException ex) {
                    return;
                }
                try {
                    while (!DedicatedServer.this.ag() && DedicatedServer.this.x()) {
                        String s2 = Main.useJline ? bufferedreader.readLine(">", null) : bufferedreader.readLine();
                        if (s2 == null) {
                            try {
                                Thread.sleep(50L);
                            }
                            catch (InterruptedException ex) {
                                Thread.currentThread().interrupt();
                            }
                            continue;
                        }
                        if (s2.trim().length() <= 0) continue;
                        DedicatedServer.this.a(s2, DedicatedServer.this.aI());
                    }
                }
                catch (IOException ioexception) {
                    k.error("Exception handling console input", (Throwable)ioexception);
                }
            }
        };
        java.util.logging.Logger global = java.util.logging.Logger.getLogger("");
        global.setUseParentHandlers(false);
        for (Handler handler : global.getHandlers()) {
            global.removeHandler(handler);
        }
        global.addHandler(new ForwardLogHandler());
        Logger logger = (Logger)LogManager.getRootLogger();
        for (Appender appender : logger.getAppenders().values()) {
            if (!(appender instanceof ConsoleAppender)) continue;
            logger.removeAppender(appender);
        }
        TerminalConsoleWriterThread writerThread = new TerminalConsoleWriterThread(System.out, this.reader);
        this.reader.setCompletionHandler((CompletionHandler)new TerminalCompletionHandler(writerThread, this.reader.getCompletionHandler()));
        writerThread.start();
        System.setOut(IoBuilder.forLogger((org.apache.logging.log4j.Logger)logger).setLevel(Level.INFO).buildPrintStream());
        System.setErr(IoBuilder.forLogger((org.apache.logging.log4j.Logger)logger).setLevel(Level.WARN).buildPrintStream());
        thread.setDaemon(true);
        thread.setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler(k));
        thread.start();
        k.info("Starting minecraft server version {}", (Object)SharedConstants.b().c());
        if (Runtime.getRuntime().maxMemory() / 1024L / 1024L < 512L) {
            k.warn("To start the server with more ram, launch it as \"java -Xmx1024M -Xms1024M -jar minecraft_server.jar\"");
        }
        k.info("Loading properties");
        DedicatedServerProperties dedicatedserverproperties = this.r.a();
        if (this.T()) {
            this.a_("127.0.0.1");
        } else {
            this.d(dedicatedserverproperties.a);
            this.e(dedicatedserverproperties.b);
            this.a_(dedicatedserverproperties.c);
        }
        this.a(new DedicatedPlayerList(this, this.bd(), this.g));
        SpigotConfig.init((File)this.options.valueOf("spigot-settings"));
        SpigotConfig.registerCommands();
        this.f(dedicatedserverproperties.f);
        this.g(dedicatedserverproperties.g);
        this.d(dedicatedserverproperties.h);
        super.c(dedicatedserverproperties.W.get());
        this.h(dedicatedserverproperties.k);
        k.info("Default game type: {}", (Object)dedicatedserverproperties.m);
        InetAddress inetaddress = null;
        if (!this.w().isEmpty()) {
            inetaddress = InetAddress.getByName(this.w());
        }
        if (this.R() < 0) {
            this.a(dedicatedserverproperties.o);
        }
        this.U();
        k.info("Starting Minecraft server on {}:{}", (Object)(this.w().isEmpty() ? "*" : this.w()), (Object)this.R());
        try {
            this.ai().a(inetaddress, this.R());
        }
        catch (IOException ioexception) {
            k.warn("**** FAILED TO BIND TO PORT!");
            k.warn("The exception was: {}", (Object)ioexception.toString());
            k.warn("Perhaps a server is already running on that port?");
            return false;
        }
        this.server.loadPlugins();
        this.server.enablePlugins(PluginLoadOrder.STARTUP);
        if (!this.Z()) {
            k.warn("**** SERVER IS RUNNING IN OFFLINE/INSECURE MODE!");
            k.warn("The server will make no attempt to authenticate usernames. Beware.");
            if (SpigotConfig.bungee) {
                k.warn("Whilst this makes it possible to use BungeeCord, unless access to your server is properly restricted, it also opens up the ability for hackers to connect with any username they choose.");
                k.warn("Please see http://www.spigotmc.org/wiki/firewall-guide/ for further information.");
            } else {
                k.warn("While this makes the game possible to play without internet access, it also opens up the ability for hackers to connect with any username they choose.");
            }
            k.warn("To change this, set \"online-mode\" to \"true\" in the server.properties file.");
        }
        if (this.bu()) {
            this.au().c();
        }
        if (!NameReferencingFileConverter.e(this)) {
            return false;
        }
        this.v = new DebugSampleSubscriptionTracker(this.bs());
        this.u = new RemoteSampleLogger(TpsDebugDimensions.values().length, this.v, RemoteDebugSampleType.a);
        long i2 = SystemUtils.d();
        TileEntitySkull.a(this.i, this);
        UserCache.a(this.Z());
        k.info("Preparing level \"{}\"", (Object)this.s());
        this.loadLevel(this.f.f());
        long j2 = SystemUtils.d() - i2;
        String s2 = String.format(Locale.ROOT, "%.3fs", (double)j2 / 1.0E9);
        k.info("Done ({})! For help, type \"help\"", (Object)s2);
        if (dedicatedserverproperties.p != null) {
            this.aM().a(GameRules.A).set(dedicatedserverproperties.p, this.I());
        }
        if (dedicatedserverproperties.q) {
            k.info("Starting GS4 status listener");
            this.o = RemoteStatusListener.a(this);
        }
        if (dedicatedserverproperties.s) {
            k.info("Starting remote control listener");
            this.q = RemoteControlListener.a(this);
        }
        if (dedicatedserverproperties.P) {
            MinecraftServerBeans.a(this);
            k.info("JMX monitoring enabled");
        }
        return true;
    }

    @Override
    public boolean ab() {
        return this.a().d && super.ab();
    }

    @Override
    public boolean V() {
        return this.r.a().x && super.V();
    }

    @Override
    public boolean ac() {
        return this.r.a().e && super.ac();
    }

    @Override
    public DedicatedServerProperties a() {
        return this.r.a();
    }

    @Override
    public void t() {
        this.a(this.a().l, true);
    }

    @Override
    public boolean j() {
        return this.a().v;
    }

    @Override
    public SystemReport a(SystemReport systemreport) {
        systemreport.a("Is Modded", () -> this.P().b());
        systemreport.a("Type", () -> "Dedicated Server (map_server.txt)");
        return systemreport;
    }

    @Override
    public void a(Path path) throws IOException {
        DedicatedServerProperties dedicatedserverproperties = this.a();
        try (BufferedWriter bufferedwriter = Files.newBufferedWriter(path, new OpenOption[0]);){
            bufferedwriter.write(String.format(Locale.ROOT, "sync-chunk-writes=%s%n", dedicatedserverproperties.N));
            bufferedwriter.write(String.format(Locale.ROOT, "gamemode=%s%n", dedicatedserverproperties.m));
            bufferedwriter.write(String.format(Locale.ROOT, "spawn-monsters=%s%n", dedicatedserverproperties.x));
            bufferedwriter.write(String.format(Locale.ROOT, "entity-broadcast-range-percentage=%d%n", dedicatedserverproperties.S));
            bufferedwriter.write(String.format(Locale.ROOT, "max-world-size=%d%n", dedicatedserverproperties.M));
            bufferedwriter.write(String.format(Locale.ROOT, "spawn-npcs=%s%n", dedicatedserverproperties.e));
            bufferedwriter.write(String.format(Locale.ROOT, "view-distance=%d%n", dedicatedserverproperties.G));
            bufferedwriter.write(String.format(Locale.ROOT, "simulation-distance=%d%n", dedicatedserverproperties.H));
            bufferedwriter.write(String.format(Locale.ROOT, "spawn-animals=%s%n", dedicatedserverproperties.d));
            bufferedwriter.write(String.format(Locale.ROOT, "generate-structures=%s%n", dedicatedserverproperties.aa.c()));
            bufferedwriter.write(String.format(Locale.ROOT, "use-native=%s%n", dedicatedserverproperties.y));
            bufferedwriter.write(String.format(Locale.ROOT, "rate-limit=%d%n", dedicatedserverproperties.F));
        }
    }

    @Override
    public void i() {
        if (this.t != null) {
            this.t.close();
        }
        if (this.s != null) {
            this.s.b();
        }
        if (this.q != null) {
            this.q.b();
        }
        if (this.o != null) {
            this.o.b();
        }
        System.exit(0);
    }

    @Override
    public void c(BooleanSupplier booleansupplier) {
        super.c(booleansupplier);
        this.br();
    }

    @Override
    public boolean a(World world) {
        return world.af() == World.i ? this.a().w : true;
    }

    public void a(String s2, CommandListenerWrapper commandlistenerwrapper) {
        this.n.add(new ServerCommand(s2, commandlistenerwrapper));
    }

    public void br() {
        SpigotTimings.serverCommandTimer.startTiming();
        while (!this.n.isEmpty()) {
            ServerCommand servercommand = this.n.remove(0);
            ServerCommandEvent event = new ServerCommandEvent((CommandSender)this.console, servercommand.a);
            this.server.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) continue;
            servercommand = new ServerCommand(event.getCommand(), servercommand.b);
            this.server.dispatchServerCommand((CommandSender)this.console, servercommand);
        }
        SpigotTimings.serverCommandTimer.stopTiming();
    }

    @Override
    public boolean n() {
        return true;
    }

    @Override
    public int o() {
        return this.a().F;
    }

    @Override
    public boolean p() {
        return this.a().y;
    }

    public DedicatedPlayerList bs() {
        return (DedicatedPlayerList)super.ah();
    }

    @Override
    public boolean r() {
        return true;
    }

    @Override
    public String b() {
        return this.w();
    }

    @Override
    public int d() {
        return this.R();
    }

    @Override
    public String h() {
        return this.af();
    }

    public void bt() {
        if (this.s == null) {
            this.s = ServerGUI.a(this);
        }
    }

    @Override
    public boolean ak() {
        return this.s != null;
    }

    @Override
    public boolean q() {
        return this.a().z;
    }

    @Override
    public int am() {
        return this.a().A;
    }

    @Override
    public boolean a(WorldServer worldserver, BlockPosition blockposition, EntityHuman entityhuman) {
        int j2;
        if (worldserver.af() != World.h) {
            return false;
        }
        if (this.bs().k().c()) {
            return false;
        }
        if (this.bs().f(entityhuman.fX())) {
            return false;
        }
        if (this.am() <= 0) {
            return false;
        }
        BlockPosition blockposition1 = worldserver.V();
        int i2 = MathHelper.a(blockposition.u() - blockposition1.u());
        int k2 = Math.max(i2, j2 = MathHelper.a(blockposition.w() - blockposition1.w()));
        return k2 <= this.am();
    }

    @Override
    public boolean an() {
        return this.a().Q;
    }

    @Override
    public boolean ao() {
        return this.a().R;
    }

    @Override
    public int k() {
        return this.a().B;
    }

    @Override
    public int l() {
        return this.a().C;
    }

    @Override
    public void c(int i2) {
        super.c(i2);
        this.r.a(dedicatedserverproperties -> (DedicatedServerProperties)dedicatedserverproperties.W.a(this.bc(), i2));
    }

    @Override
    public boolean m() {
        return this.a().K;
    }

    @Override
    public boolean M_() {
        return this.a().L;
    }

    @Override
    public int ax() {
        return this.a().M;
    }

    @Override
    public int aA() {
        return this.a().J;
    }

    @Override
    public boolean aB() {
        DedicatedServerProperties dedicatedserverproperties = this.a();
        return dedicatedserverproperties.Y && dedicatedserverproperties.a && this.i.b();
    }

    @Override
    public boolean bn() {
        return this.a().Z;
    }

    protected boolean bu() {
        int i2;
        boolean flag = false;
        for (i2 = 0; !flag && i2 <= 2; ++i2) {
            if (i2 > 0) {
                k.warn("Encountered a problem while converting the user banlist, retrying in a few seconds");
                this.bD();
            }
            flag = NameReferencingFileConverter.a((MinecraftServer)this);
        }
        boolean flag1 = false;
        for (i2 = 0; !flag1 && i2 <= 2; ++i2) {
            if (i2 > 0) {
                k.warn("Encountered a problem while converting the ip banlist, retrying in a few seconds");
                this.bD();
            }
            flag1 = NameReferencingFileConverter.b(this);
        }
        boolean flag2 = false;
        for (i2 = 0; !flag2 && i2 <= 2; ++i2) {
            if (i2 > 0) {
                k.warn("Encountered a problem while converting the op list, retrying in a few seconds");
                this.bD();
            }
            flag2 = NameReferencingFileConverter.c(this);
        }
        boolean flag3 = false;
        for (i2 = 0; !flag3 && i2 <= 2; ++i2) {
            if (i2 > 0) {
                k.warn("Encountered a problem while converting the whitelist, retrying in a few seconds");
                this.bD();
            }
            flag3 = NameReferencingFileConverter.d(this);
        }
        boolean flag4 = false;
        for (i2 = 0; !flag4 && i2 <= 2; ++i2) {
            if (i2 > 0) {
                k.warn("Encountered a problem while converting the player save files, retrying in a few seconds");
                this.bD();
            }
            flag4 = NameReferencingFileConverter.a(this);
        }
        return flag || flag1 || flag2 || flag3 || flag4;
    }

    private void bD() {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public long bv() {
        return this.a().D;
    }

    @Override
    public int bl() {
        return this.a().E;
    }

    @Override
    public String u() {
        StringBuilder result = new StringBuilder();
        Plugin[] plugins = this.server.getPluginManager().getPlugins();
        result.append(this.server.getName());
        result.append(" on Bukkit ");
        result.append(this.server.getBukkitVersion());
        if (plugins.length > 0 && this.server.getQueryPlugins()) {
            result.append(": ");
            for (int i2 = 0; i2 < plugins.length; ++i2) {
                if (i2 > 0) {
                    result.append("; ");
                }
                result.append(plugins[i2].getDescription().getName());
                result.append(" ");
                result.append(plugins[i2].getDescription().getVersion().replaceAll(";", ","));
            }
        }
        return result.toString();
    }

    @Override
    public String a(String s2) {
        throw new UnsupportedOperationException("Not supported - remote source required.");
    }

    public String runCommand(RemoteControlCommandListener rconConsoleSource, String s2) {
        rconConsoleSource.e();
        this.h(() -> {
            CommandListenerWrapper wrapper = rconConsoleSource.g();
            RemoteServerCommandEvent event = new RemoteServerCommandEvent(rconConsoleSource.getBukkitSender(wrapper), s2);
            this.server.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            ServerCommand serverCommand = new ServerCommand(event.getCommand(), wrapper);
            this.server.dispatchServerCommand(event.getSender(), serverCommand);
        });
        return rconConsoleSource.f();
    }

    @Override
    public void i(boolean flag) {
        this.r.a(dedicatedserverproperties -> (DedicatedServerProperties)dedicatedserverproperties.X.a(this.bc(), flag));
    }

    @Override
    public void v() {
        super.v();
        SystemUtils.j();
        TileEntitySkull.b();
    }

    @Override
    public boolean a(GameProfile gameprofile) {
        return false;
    }

    @Override
    public int b(int i2) {
        return this.a().S * i2 / 100;
    }

    @Override
    public String s() {
        return this.f.f();
    }

    @Override
    public boolean aZ() {
        return this.r.a().N;
    }

    @Override
    public ITextFilter a(EntityPlayer entityplayer) {
        return this.t != null ? this.t.a(entityplayer.fX()) : ITextFilter.a;
    }

    @Override
    @Nullable
    public EnumGamemode bf() {
        return this.r.a().j ? this.j.k() : null;
    }

    @Override
    public Optional<MinecraftServer.ServerResourcePackInfo> X() {
        return this.r.a().U;
    }

    @Override
    public void aU() {
        super.aU();
        this.v.a(this.al());
    }

    @Override
    public SampleLogger f() {
        return this.u;
    }

    @Override
    public boolean g() {
        return this.v.a(RemoteDebugSampleType.a);
    }

    @Override
    public void a(EntityPlayer entityplayer, RemoteDebugSampleType remotedebugsampletype) {
        this.v.a(entityplayer, remotedebugsampletype);
    }

    @Override
    public boolean bo() {
        return this.r.a().ab;
    }

    @Override
    public ServerLinks bq() {
        return this.w;
    }

    private static ServerLinks a(DedicatedServerSettings dedicatedserversettings) {
        Optional<URI> optional = DedicatedServer.a(dedicatedserversettings.a());
        return optional.map(uri -> new ServerLinks(List.of(ServerLinks.KnownLinkType.a.a((URI)uri)))).orElse(ServerLinks.a);
    }

    private static Optional<URI> a(DedicatedServerProperties dedicatedserverproperties) {
        String s2 = dedicatedserverproperties.i;
        if (s2.isEmpty()) {
            return Optional.empty();
        }
        try {
            return Optional.of(SystemUtils.a(s2));
        }
        catch (Exception exception) {
            k.warn("Failed to parse bug link {}", (Object)s2, (Object)exception);
            return Optional.empty();
        }
    }

    @Override
    public boolean isDebugging() {
        return this.a().debug;
    }

    @Override
    public CommandSender getBukkitSender(CommandListenerWrapper wrapper) {
        return this.console;
    }
}

