/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.net.InetAddresses;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.EnumChatFormat;
import net.minecraft.ReportedException;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.OutgoingChatMessage;
import net.minecraft.network.chat.RemoteChatSession;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundHurtAnimationPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatEndPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatEnterPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatKillPacket;
import net.minecraft.network.protocol.game.ClientboundServerDataPacket;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.network.protocol.game.CommonPlayerSpawnInfo;
import net.minecraft.network.protocol.game.PacketPlayOutAbilities;
import net.minecraft.network.protocol.game.PacketPlayOutAnimation;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutCamera;
import net.minecraft.network.protocol.game.PacketPlayOutCloseWindow;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutExperience;
import net.minecraft.network.protocol.game.PacketPlayOutGameStateChange;
import net.minecraft.network.protocol.game.PacketPlayOutLookAt;
import net.minecraft.network.protocol.game.PacketPlayOutNamedSoundEffect;
import net.minecraft.network.protocol.game.PacketPlayOutOpenBook;
import net.minecraft.network.protocol.game.PacketPlayOutOpenSignEditor;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindow;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindowHorse;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindowMerchant;
import net.minecraft.network.protocol.game.PacketPlayOutRemoveEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutRespawn;
import net.minecraft.network.protocol.game.PacketPlayOutServerDifficulty;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateHealth;
import net.minecraft.network.protocol.game.PacketPlayOutWindowData;
import net.minecraft.network.protocol.game.PacketPlayOutWindowItems;
import net.minecraft.network.protocol.status.ServerPing;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.AdvancementDataPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkTrackingView;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.PlayerInteractManager;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldProviderNormal;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.ITextFilter;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.server.players.PlayerList;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.stats.RecipeBookServer;
import net.minecraft.stats.ServerStatisticManager;
import net.minecraft.stats.Statistic;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.world.EnumHand;
import net.minecraft.world.IInventory;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.damagesource.CombatTracker;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.animal.EntityPig;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.EntityStrider;
import net.minecraft.world.entity.monster.warden.WardenSpawnTracker;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.EnumChatVisibility;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.food.FoodMetaData;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerHorse;
import net.minecraft.world.inventory.ContainerSynchronizer;
import net.minecraft.world.inventory.ICrafting;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.SlotResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldown;
import net.minecraft.world.item.ItemCooldownPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemWorldMapBase;
import net.minecraft.world.item.ItemWrittenBook;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ICollisionAccess;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.BlockChest;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockRespawnAnchor;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityCommand;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.ScoreAccess;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;
import net.minecraft.world.scores.criteria.IScoreboardCriteria;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R1.CraftWorldBorder;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftPortalEvent;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftDimensionUtil;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftLocation;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerBedLeaveEvent;
import org.bukkit.event.player.PlayerChangedMainHandEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerLocaleChangeEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerSpawnChangeEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.inventory.MainHand;
import org.slf4j.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class EntityPlayer
extends EntityHuman {
    private static final Logger cz = LogUtils.getLogger();
    private static final int cA = 32;
    private static final int cB = 10;
    private static final int cD = 25;
    public static final double b = 1.0;
    private static final AttributeModifier cE = new AttributeModifier(MinecraftKey.b("creative_mode_block_range"), 0.5, AttributeModifier.Operation.a);
    private static final AttributeModifier cF = new AttributeModifier(MinecraftKey.b("creative_mode_entity_range"), 2.0, AttributeModifier.Operation.a);
    public PlayerConnection c;
    public final MinecraftServer d;
    public final PlayerInteractManager e;
    private final AdvancementDataPlayer cG;
    private final ServerStatisticManager cH;
    private float cI = Float.MIN_VALUE;
    private int cJ = Integer.MIN_VALUE;
    private int cK = Integer.MIN_VALUE;
    private int cL = Integer.MIN_VALUE;
    private int cM = Integer.MIN_VALUE;
    private int cN = Integer.MIN_VALUE;
    private float cO = -1.0E8f;
    private int cP = -99999999;
    private boolean cQ = true;
    public int cR = -99999999;
    public int cS = 60;
    private EnumChatVisibility cT = EnumChatVisibility.a;
    private boolean cU = true;
    private long cV = SystemUtils.c();
    @Nullable
    private Entity cW;
    public boolean cX;
    public boolean f;
    private final RecipeBookServer cY = new RecipeBookServer();
    @Nullable
    private Vec3D cZ;
    private int da;
    private boolean db;
    private int dc = 2;
    public String dd = "en_us";
    @Nullable
    private Vec3D de;
    @Nullable
    private Vec3D df;
    @Nullable
    private Vec3D dg;
    private SectionPosition dh = SectionPosition.a(0, 0, 0);
    private ChunkTrackingView di = ChunkTrackingView.a;
    private ResourceKey<net.minecraft.world.level.World> dj = net.minecraft.world.level.World.h;
    @Nullable
    private BlockPosition dk;
    private boolean dl;
    private float dm;
    private final ITextFilter dn;
    private boolean do;
    private boolean dp;
    private boolean dq;
    private WardenSpawnTracker dr = new WardenSpawnTracker(0, 0, 0);
    @Nullable
    private BlockPosition ds;
    private Vec3D dt = Vec3D.b;
    private final ContainerSynchronizer du = new ContainerSynchronizer(){

        @Override
        public void a(Container container, NonNullList<ItemStack> nonnulllist, ItemStack itemstack, int[] aint) {
            EntityPlayer.this.c.b(new PacketPlayOutWindowItems(container.j, container.k(), nonnulllist, itemstack));
            for (int i2 = 0; i2 < aint.length; ++i2) {
                this.b(container, i2, aint[i2]);
            }
        }

        @Override
        public void a(Container container, int i2, ItemStack itemstack) {
            EntityPlayer.this.c.b(new PacketPlayOutSetSlot(container.j, container.k(), i2, itemstack));
        }

        @Override
        public void a(Container container, ItemStack itemstack) {
            EntityPlayer.this.c.b(new PacketPlayOutSetSlot(-1, container.k(), -1, itemstack));
        }

        @Override
        public void a(Container container, int i2, int j2) {
            this.b(container, i2, j2);
        }

        private void b(Container container, int i2, int j2) {
            EntityPlayer.this.c.b(new PacketPlayOutWindowData(container.j, i2, j2));
        }
    };
    private final ICrafting dv = new ICrafting(){

        @Override
        public void a(Container container, int i2, ItemStack itemstack) {
            Slot slot = container.b(i2);
            if (!(slot instanceof SlotResult) && slot.c == EntityPlayer.this.fY()) {
                CriterionTriggers.f.a(EntityPlayer.this, EntityPlayer.this.fY(), itemstack);
            }
        }

        @Override
        public void a(Container container, int i2, int j2) {
        }
    };
    @Nullable
    private RemoteChatSession dw;
    @Nullable
    public final Object g;
    private int dx;
    public boolean h;
    public CraftPlayer.TransferCookieConnection transferCookieConnection;
    public String displayName;
    public IChatBaseComponent listName;
    public Location compassTarget;
    public int newExp = 0;
    public int newLevel = 0;
    public int newTotalExp = 0;
    public boolean keepLevel = false;
    public double maxHealthCache;
    public boolean joining = true;
    public boolean sentListPacket = false;
    public String kickLeaveMessage = null;
    public long timeOffset = 0L;
    public boolean relativeTime = true;
    public WeatherType weather = null;
    private float pluginRainPosition;
    private float pluginRainPositionPrevious;

    public EntityPlayer(MinecraftServer minecraftserver, WorldServer worldserver, GameProfile gameprofile, ClientInformation clientinformation) {
        super(worldserver, worldserver.V(), worldserver.W(), gameprofile);
        this.dn = minecraftserver.a(this);
        this.e = minecraftserver.b(this);
        this.d = minecraftserver;
        this.cH = minecraftserver.ah().getPlayerStats(this);
        this.cG = minecraftserver.ah().g(this);
        this.a(this.a(worldserver, worldserver.V()).c(), 0.0f, 0.0f);
        this.a(clientinformation);
        this.g = null;
        this.displayName = this.cB();
        this.bukkitPickUpLoot = true;
        this.maxHealthCache = this.eN();
    }

    public void resendItemInHands() {
        this.cd.b(this.fY(), this.fY().k).ifPresent(s2 -> this.du.a(this.cd, s2, this.eT()));
        this.du.a((Container)this.cc, 45, this.eU());
    }

    public final BlockPosition getSpawnPoint(WorldServer worldserver) {
        BlockPosition blockposition = worldserver.V();
        if (worldserver.D_().g() && worldserver.K.k() != EnumGamemode.c) {
            long k2;
            long l2;
            int i2 = Math.max(0, this.d.a(worldserver));
            int j2 = MathHelper.a(worldserver.C_().b(blockposition.u(), blockposition.w()));
            if (j2 < i2) {
                i2 = j2;
            }
            if (j2 <= 1) {
                i2 = 1;
            }
            int i1 = (l2 = (k2 = (long)(i2 * 2 + 1)) * k2) > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l2;
            int j1 = this.t(i1);
            int k1 = RandomSource.a().a(i1);
            for (int l1 = 0; l1 < i1; ++l1) {
                int i22 = (k1 + j1 * l1) % i1;
                int j22 = i22 % (i2 * 2 + 1);
                int k22 = i22 / (i2 * 2 + 1);
                BlockPosition blockposition1 = WorldProviderNormal.a(worldserver, blockposition.u() + j22 - i2, blockposition.w() + k22 - i2);
                if (blockposition1 == null) continue;
                return blockposition1;
            }
        }
        return blockposition;
    }

    @Override
    public BlockPosition a(WorldServer worldserver, BlockPosition blockposition) {
        AxisAlignedBB axisalignedbb = this.a(EntityPose.a).a(Vec3D.b);
        BlockPosition blockposition1 = blockposition;
        if (worldserver.D_().g() && worldserver.K.k() != EnumGamemode.c) {
            long k2;
            long l2;
            int i2 = Math.max(0, this.d.a(worldserver));
            int j2 = MathHelper.a(worldserver.C_().b(blockposition.u(), blockposition.w()));
            if (j2 < i2) {
                i2 = j2;
            }
            if (j2 <= 1) {
                i2 = 1;
            }
            int i1 = (l2 = (k2 = (long)(i2 * 2 + 1)) * k2) > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l2;
            int j1 = this.t(i1);
            int k1 = RandomSource.a().a(i1);
            for (int l1 = 0; l1 < i1; ++l1) {
                int i22 = (k1 + j1 * l1) % i1;
                int j22 = i22 % (i2 * 2 + 1);
                int k22 = i22 / (i2 * 2 + 1);
                blockposition1 = WorldProviderNormal.a(worldserver, blockposition.u() + j22 - i2, blockposition.w() + k22 - i2);
                if (blockposition1 == null || !worldserver.a((Entity)this, axisalignedbb.c(blockposition1.c()))) continue;
                return blockposition1;
            }
            blockposition1 = blockposition;
        }
        while (!worldserver.a((Entity)this, axisalignedbb.c(blockposition1.c())) && blockposition1.v() < worldserver.am() - 1) {
            blockposition1 = blockposition1.d();
        }
        while (worldserver.a((Entity)this, axisalignedbb.c(blockposition1.e().c())) && blockposition1.v() > worldserver.I_() + 1) {
            blockposition1 = blockposition1.e();
        }
        return blockposition1;
    }

    private int t(int i2) {
        return i2 <= 16 ? i2 - 1 : 17;
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        String spawnWorld;
        CraftWorld oldWorld;
        Logger logger;
        DataResult dataresult;
        super.a(nbttagcompound);
        if (nbttagcompound.b("warden_spawn_tracker", 10)) {
            dataresult = WardenSpawnTracker.a.parse(new Dynamic((DynamicOps)DynamicOpsNBT.a, (Object)nbttagcompound.c("warden_spawn_tracker")));
            logger = cz;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(wardenspawntracker -> {
                this.dr = wardenspawntracker;
            });
        }
        if (nbttagcompound.b("enteredNetherPosition", 10)) {
            NBTTagCompound nbttagcompound1 = nbttagcompound.p("enteredNetherPosition");
            this.df = new Vec3D(nbttagcompound1.k("x"), nbttagcompound1.k("y"), nbttagcompound1.k("z"));
        }
        this.f = nbttagcompound.q("seenCredits");
        if (nbttagcompound.b("recipeBook", 10)) {
            this.cY.a(nbttagcompound.p("recipeBook"), this.d.aJ());
        }
        this.getBukkitEntity().readExtraData(nbttagcompound);
        if (this.fH()) {
            this.fI();
        }
        if ((oldWorld = (CraftWorld)Bukkit.getWorld((String)(spawnWorld = nbttagcompound.l("SpawnWorld")))) != null) {
            this.dj = oldWorld.getHandle().af();
        }
        if (nbttagcompound.b("SpawnX", 99) && nbttagcompound.b("SpawnY", 99) && nbttagcompound.b("SpawnZ", 99)) {
            this.dk = new BlockPosition(nbttagcompound.h("SpawnX"), nbttagcompound.h("SpawnY"), nbttagcompound.h("SpawnZ"));
            this.dl = nbttagcompound.q("SpawnForced");
            this.dm = nbttagcompound.j("SpawnAngle");
            if (nbttagcompound.e("SpawnDimension")) {
                DataResult dataresult1 = net.minecraft.world.level.World.g.parse((DynamicOps)DynamicOpsNBT.a, (Object)nbttagcompound.c("SpawnDimension"));
                Logger logger1 = cz;
                Objects.requireNonNull(logger1);
                this.dj = dataresult1.resultOrPartial(arg_0 -> ((Logger)logger1).error(arg_0)).orElse(net.minecraft.world.level.World.h);
            }
        }
        this.dq = nbttagcompound.q("spawn_extra_particles_on_fall");
        NBTBase nbtbase = nbttagcompound.c("raid_omen_position");
        if (nbtbase != null) {
            dataresult = BlockPosition.a.parse((DynamicOps)DynamicOpsNBT.a, (Object)nbtbase);
            logger = cz;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(blockposition -> {
                this.ds = blockposition;
            });
        }
    }

    @Override
    public void b(NBTTagCompound nbttagcompound) {
        super.b(nbttagcompound);
        DataResult dataresult = WardenSpawnTracker.a.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.dr);
        Logger logger = cz;
        Objects.requireNonNull(logger);
        dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbttagcompound.a("warden_spawn_tracker", (NBTBase)nbtbase));
        this.k(nbttagcompound);
        nbttagcompound.a("seenCredits", this.f);
        if (this.df != null) {
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.a("x", this.df.c);
            nbttagcompound1.a("y", this.df.d);
            nbttagcompound1.a("z", this.df.e);
            nbttagcompound.a("enteredNetherPosition", nbttagcompound1);
        }
        Entity entity = this.cZ();
        Entity entity1 = this.dc();
        boolean persistVehicle = true;
        if (entity1 != null) {
            for (Entity vehicle = entity1; vehicle != null; vehicle = vehicle.dc()) {
                if (vehicle.persist) continue;
                persistVehicle = false;
                break;
            }
        }
        if (persistVehicle && entity1 != null && entity != this && entity.cY()) {
            NBTTagCompound nbttagcompound2 = new NBTTagCompound();
            NBTTagCompound nbttagcompound3 = new NBTTagCompound();
            entity.e(nbttagcompound3);
            nbttagcompound2.a("Attach", entity1.cz());
            nbttagcompound2.a("Entity", nbttagcompound3);
            nbttagcompound.a("RootVehicle", nbttagcompound2);
        }
        nbttagcompound.a("recipeBook", this.cY.b());
        nbttagcompound.a("Dimension", this.dO().af().a().toString());
        if (this.dk != null) {
            nbttagcompound.a("SpawnX", this.dk.u());
            nbttagcompound.a("SpawnY", this.dk.v());
            nbttagcompound.a("SpawnZ", this.dk.w());
            nbttagcompound.a("SpawnForced", this.dl);
            nbttagcompound.a("SpawnAngle", this.dm);
            dataresult = MinecraftKey.a.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.dj.a());
            logger = cz;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbttagcompound.a("SpawnDimension", (NBTBase)nbtbase));
        }
        this.getBukkitEntity().setExtraData(nbttagcompound);
        nbttagcompound.a("spawn_extra_particles_on_fall", this.dq);
        if (this.ds != null) {
            dataresult = BlockPosition.a.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.ds);
            logger = cz;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbttagcompound.a("raid_omen_position", (NBTBase)nbtbase));
        }
    }

    public void spawnIn(net.minecraft.world.level.World world) {
        this.a(world);
        if (world == null) {
            this.dL();
            Vec3D position = null;
            if (this.dj != null && (world = this.d.a(this.dj)) != null && this.S() != null) {
                position = EntityPlayer.a((WorldServer)world, this.S(), this.T(), false, false).map(RespawnPosAngle::a).orElse(null);
            }
            if (world == null || position == null) {
                world = ((CraftWorld)Bukkit.getServer().getWorlds().get(0)).getHandle();
                position = Vec3D.b(world.V());
            }
            this.a(world);
            this.c(position);
        }
        this.e.a((WorldServer)world);
    }

    public void a(int i2) {
        float f2 = this.gh();
        float f1 = (f2 - 1.0f) / f2;
        this.cs = MathHelper.a((float)i2 / f2, 0.0f, f1);
        this.cR = -1;
    }

    public void b(int i2) {
        this.cq = i2;
        this.cR = -1;
    }

    @Override
    public void c(int i2) {
        super.c(i2);
        this.cR = -1;
    }

    @Override
    public void a(ItemStack itemstack, int i2) {
        super.a(itemstack, i2);
        this.cR = -1;
    }

    public void a(Container container) {
        container.a(this.dv);
        container.a(this.du);
    }

    public void h() {
        this.a(this.cc);
    }

    @Override
    public void f_() {
        super.f_();
        this.c.b(ClientboundPlayerCombatEnterPacket.a);
    }

    @Override
    public void g_() {
        super.g_();
        this.c.b(new ClientboundPlayerCombatEndPacket(this.eL()));
    }

    @Override
    public void a(IBlockData iblockdata) {
        CriterionTriggers.e.a(this, iblockdata);
    }

    @Override
    protected ItemCooldown k() {
        return new ItemCooldownPlayer(this);
    }

    @Override
    public void l() {
        Entity entity;
        if (this.joining) {
            this.joining = false;
        }
        this.e.a();
        this.dr.a();
        --this.cS;
        if (this.am > 0) {
            --this.am;
        }
        this.cd.d();
        if (!this.dO().B && !this.cd.b(this)) {
            this.s();
            this.cd = this.cc;
        }
        if ((entity = this.L()) != this) {
            if (entity.bE()) {
                this.a(entity.dt(), entity.dv(), entity.dz(), entity.dE(), entity.dG());
                this.A().l().a(this);
                if (this.fO()) {
                    this.d((Entity)this);
                }
            } else {
                this.d((Entity)this);
            }
        }
        CriterionTriggers.x.a(this);
        if (this.cZ != null) {
            CriterionTriggers.v.a(this, this.cZ, this.ai - this.da);
        }
        this.o();
        this.p();
        this.gD();
        this.cG.b(this);
    }

    private void gD() {
        AttributeModifiable attributemodifiable1;
        AttributeModifiable attributemodifiable = this.f(GenericAttributes.g);
        if (attributemodifiable != null) {
            if (this.f()) {
                attributemodifiable.a(cE);
            } else {
                attributemodifiable.e(cE);
            }
        }
        if ((attributemodifiable1 = this.f(GenericAttributes.j)) != null) {
            if (this.f()) {
                attributemodifiable1.a(cF);
            } else {
                attributemodifiable1.e(cF);
            }
        }
    }

    public void m() {
        try {
            if (!this.R_() || !this.dh()) {
                super.l();
            }
            for (int i2 = 0; i2 < this.fY().b(); ++i2) {
                Packet<?> packet;
                ItemStack itemstack = this.fY().a(i2);
                if (!itemstack.g().ao_() || (packet = ((ItemWorldMapBase)itemstack.g()).a(itemstack, this.dO(), this)) == null) continue;
                this.c.b(packet);
            }
            if (this.ew() != this.cO || this.cP != this.ce.a() || this.ce.e() == 0.0f != this.cQ) {
                this.c.b(new PacketPlayOutUpdateHealth(this.getBukkitEntity().getScaledHealth(), this.ce.a(), this.ce.e()));
                this.cO = this.ew();
                this.cP = this.ce.a();
                boolean bl = this.cQ = this.ce.e() == 0.0f;
            }
            if (this.ew() + this.fo() != this.cI) {
                this.cI = this.ew() + this.fo();
                this.a(IScoreboardCriteria.g, MathHelper.f(this.cI));
            }
            if (this.ce.a() != this.cJ) {
                this.cJ = this.ce.a();
                this.a(IScoreboardCriteria.h, MathHelper.f((float)this.cJ));
            }
            if (this.cm() != this.cK) {
                this.cK = this.cm();
                this.a(IScoreboardCriteria.i, MathHelper.f((float)this.cK));
            }
            if (this.eK() != this.cL) {
                this.cL = this.eK();
                this.a(IScoreboardCriteria.j, MathHelper.f((float)this.cL));
            }
            if (this.cr != this.cN) {
                this.cN = this.cr;
                this.a(IScoreboardCriteria.k, MathHelper.f((float)this.cN));
            }
            if (this.maxHealthCache != (double)this.eN()) {
                this.getBukkitEntity().updateScaledHealth();
            }
            if (this.cq != this.cM) {
                this.cM = this.cq;
                this.a(IScoreboardCriteria.l, MathHelper.f((float)this.cM));
            }
            if (this.cr != this.cR) {
                this.cR = this.cr;
                this.c.b(new PacketPlayOutExperience(this.cs, this.cr, this.cq));
            }
            if (this.ai % 20 == 0) {
                CriterionTriggers.q.a(this);
            }
            if (this.oldLevel == -1) {
                this.oldLevel = this.cq;
            }
            if (this.oldLevel != this.cq) {
                CraftEventFactory.callPlayerLevelChangeEvent(this.getBukkitEntity(), this.oldLevel, this.cq);
                this.oldLevel = this.cq;
            }
            if (this.getBukkitEntity().hasClientWorldBorder()) {
                ((CraftWorldBorder)this.getBukkitEntity().getWorldBorder()).getHandle().s();
            }
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.a(throwable, "Ticking player");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Player being ticked");
            this.a(crashreportsystemdetails);
            throw new ReportedException(crashreport);
        }
    }

    @Override
    public void n() {
        if (this.ew() > 0.0f && this.de != null) {
            CriterionTriggers.X.a(this, this.de);
        }
        this.de = null;
        super.n();
    }

    public void o() {
        if (this.ac > 0.0f && this.de == null) {
            this.de = this.dm();
            if (this.cx != null && this.cx.d <= this.de.d) {
                CriterionTriggers.ae.a(this, this.cx, this.cy);
            }
        }
    }

    public void p() {
        if (this.dc() != null && this.dc().bt()) {
            if (this.dg == null) {
                this.dg = this.dm();
            } else {
                CriterionTriggers.Y.a(this, this.dg);
            }
        }
        if (!(this.dg == null || this.dc() != null && this.dc().bt())) {
            this.dg = null;
        }
    }

    private void a(IScoreboardCriteria iscoreboardcriteria, int i2) {
        this.dO().getCraftServer().getScoreboardManager().forAllObjectives(iscoreboardcriteria, this, scoreaccess -> scoreaccess.a(i2));
    }

    @Override
    public void a(DamageSource damagesource) {
        String deathMessage;
        boolean keepInventory;
        ((Entity)this).a(GameEvent.p);
        boolean flag = this.dO().ab().b(GameRules.n);
        if (this.dJ()) {
            return;
        }
        ArrayList<org.bukkit.inventory.ItemStack> loot = new ArrayList<org.bukkit.inventory.ItemStack>(this.fY().b());
        boolean bl = keepInventory = this.dO().ab().b(GameRules.d) || this.R_();
        if (!keepInventory) {
            for (ItemStack item : this.fY().getContents()) {
                if (item.e() || EnchantmentManager.a(item, EnchantmentEffectComponents.D)) continue;
                loot.add(CraftItemStack.asCraftMirror(item).markForInventoryDrop());
            }
        }
        this.a(damagesource, this.bd > 0);
        this.a(this.A(), damagesource, flag);
        loot.addAll(this.drops);
        this.drops.clear();
        IChatBaseComponent defaultMessage = this.eL().a();
        String deathmessage = defaultMessage.getString();
        this.keepLevel = keepInventory;
        PlayerDeathEvent event = CraftEventFactory.callPlayerDeathEvent(this, damagesource, loot, deathmessage, keepInventory);
        if (this.cd != this.cc) {
            this.s();
        }
        if ((deathMessage = event.getDeathMessage()) != null && deathMessage.length() > 0 && flag) {
            IChatBaseComponent ichatbasecomponent = deathMessage.equals(deathmessage) ? this.eL().a() : CraftChatMessage.fromStringOrNull(deathMessage);
            this.c.a(new ClientboundPlayerCombatKillPacket(this.an(), ichatbasecomponent), PacketSendListener.a(() -> {
                boolean flag1 = true;
                String s2 = ichatbasecomponent.a(256);
                IChatMutableComponent ichatmutablecomponent = IChatBaseComponent.a("death.attack.message_too_long", IChatBaseComponent.b(s2).a(EnumChatFormat.o));
                IChatMutableComponent ichatmutablecomponent1 = IChatBaseComponent.a("death.attack.even_more_magic", this.S_()).a(chatmodifier -> chatmodifier.a(new ChatHoverable(ChatHoverable.EnumHoverAction.a, ichatmutablecomponent)));
                return new ClientboundPlayerCombatKillPacket(this.an(), ichatmutablecomponent1);
            }));
            ScoreboardTeam scoreboardteam = this.ck();
            if (scoreboardteam != null && scoreboardteam.k() != ScoreboardTeamBase.EnumNameTagVisibility.a) {
                if (scoreboardteam.k() == ScoreboardTeamBase.EnumNameTagVisibility.c) {
                    this.d.ah().a((EntityHuman)this, ichatbasecomponent);
                } else if (scoreboardteam.k() == ScoreboardTeamBase.EnumNameTagVisibility.d) {
                    this.d.ah().b(this, ichatbasecomponent);
                }
            } else {
                this.d.ah().a(ichatbasecomponent, false);
            }
        } else {
            this.c.b(new ClientboundPlayerCombatKillPacket(this.an(), CommonComponents.a));
        }
        this.gm();
        if (this.dO().ab().b(GameRules.N)) {
            this.gE();
        }
        this.C(damagesource.d());
        if (!event.getKeepInventory()) {
            this.fY().a();
        }
        this.d((Entity)this);
        this.dO().getCraftServer().getScoreboardManager().forAllObjectives(IScoreboardCriteria.d, this, ScoreAccess::b);
        EntityLiving entityliving = this.eM();
        if (entityliving != null) {
            this.b(StatisticList.h.b(entityliving.am()));
            entityliving.a((Entity)this, this.bl, damagesource);
            this.f(entityliving);
        }
        this.dO().a((Entity)this, (byte)3);
        this.a(StatisticList.N);
        this.a(StatisticList.i.b(StatisticList.m));
        this.a(StatisticList.i.b(StatisticList.n));
        this.aD();
        this.k(0);
        this.c(false);
        this.eL().c();
        ((EntityHuman)this).a(Optional.of(GlobalPos.a(this.dO().af(), this.do())));
    }

    private void gE() {
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(this.do()).c(32.0, 10.0, 32.0);
        this.dO().a(EntityInsentient.class, axisalignedbb, IEntitySelector.f).stream().filter(entityinsentient -> entityinsentient instanceof IEntityAngerable).forEach(entityinsentient -> ((IEntityAngerable)((Object)entityinsentient)).a_(this));
    }

    @Override
    public void a(Entity entity, int i2, DamageSource damagesource) {
        if (entity != this) {
            super.a(entity, i2, damagesource);
            this.s(i2);
            this.dO().getCraftServer().getScoreboardManager().forAllObjectives(IScoreboardCriteria.f, this, ScoreAccess::b);
            if (entity instanceof EntityHuman) {
                this.a(StatisticList.Q);
                this.dO().getCraftServer().getScoreboardManager().forAllObjectives(IScoreboardCriteria.e, this, ScoreAccess::b);
            } else {
                this.a(StatisticList.O);
            }
            this.a((ScoreHolder)this, (ScoreHolder)entity, IScoreboardCriteria.m);
            this.a((ScoreHolder)entity, (ScoreHolder)this, IScoreboardCriteria.n);
            CriterionTriggers.c.a(this, entity, damagesource);
        }
    }

    private void a(ScoreHolder scoreholder, ScoreHolder scoreholder1, IScoreboardCriteria[] aiscoreboardcriteria) {
        int i2;
        ScoreboardTeam scoreboardteam = this.gn().e(scoreholder1.cB());
        if (scoreboardteam != null && (i2 = scoreboardteam.n().b()) >= 0 && i2 < aiscoreboardcriteria.length) {
            this.dO().getCraftServer().getScoreboardManager().forAllObjectives(aiscoreboardcriteria[i2], scoreholder, ScoreAccess::b);
        }
    }

    @Override
    public boolean a(DamageSource damagesource, float f2) {
        EntityHuman entityhuman1;
        EntityArrow entityarrow;
        Entity entity1;
        EntityHuman entityhuman;
        boolean flag;
        if (this.b(damagesource)) {
            return false;
        }
        boolean bl = flag = this.d.n() && this.gF() && damagesource.a(DamageTypeTags.m);
        if (!flag && this.cS > 0 && !damagesource.a(DamageTypeTags.d)) {
            return false;
        }
        Entity entity = damagesource.d();
        if (entity instanceof EntityHuman && !this.a(entityhuman = (EntityHuman)entity)) {
            return false;
        }
        if (entity instanceof EntityArrow && (entity1 = (entityarrow = (EntityArrow)entity).s()) instanceof EntityHuman && !this.a(entityhuman1 = (EntityHuman)entity1)) {
            return false;
        }
        return super.a(damagesource, f2);
    }

    @Override
    public boolean a(EntityHuman entityhuman) {
        return !this.gF() ? false : super.a(entityhuman);
    }

    private boolean gF() {
        return this.dO().pvpMode;
    }

    public DimensionTransition findRespawnPositionAndUseSpawnBlock(boolean flag, DimensionTransition.a dimensiontransition_a, PlayerRespawnEvent.RespawnReason reason) {
        DimensionTransition dimensionTransition;
        boolean isBedSpawn = false;
        boolean isAnchorSpawn = false;
        BlockPosition blockposition = this.S();
        float f2 = this.T();
        boolean flag1 = this.V();
        WorldServer worldserver = this.d.a(this.U());
        if (worldserver != null && blockposition != null) {
            Optional<RespawnPosAngle> optional = EntityPlayer.a(worldserver, blockposition, f2, flag1, flag);
            if (optional.isPresent()) {
                RespawnPosAngle entityplayer_respawnposangle = optional.get();
                isBedSpawn = entityplayer_respawnposangle.isBedSpawn();
                isAnchorSpawn = entityplayer_respawnposangle.isAnchorSpawn();
                dimensionTransition = new DimensionTransition(worldserver, entityplayer_respawnposangle.a(), Vec3D.b, entityplayer_respawnposangle.b(), 0.0f, dimensiontransition_a);
            } else {
                dimensionTransition = DimensionTransition.a(this.d.I(), this, dimensiontransition_a);
            }
        } else {
            dimensionTransition = new DimensionTransition(this.d.I(), this, dimensiontransition_a);
        }
        if (reason == null) {
            return dimensionTransition;
        }
        CraftPlayer respawnPlayer = this.getBukkitEntity();
        Location location = CraftLocation.toBukkit(dimensionTransition.b(), (World)dimensionTransition.a().getWorld(), dimensionTransition.d(), dimensionTransition.e());
        PlayerRespawnEvent respawnEvent = new PlayerRespawnEvent((Player)respawnPlayer, location, isBedSpawn, isAnchorSpawn, reason);
        this.dO().getCraftServer().getPluginManager().callEvent((Event)respawnEvent);
        if (this.c.isDisconnected()) {
            return null;
        }
        location = respawnEvent.getRespawnLocation();
        return new DimensionTransition(((CraftWorld)location.getWorld()).getHandle(), CraftLocation.toVec3D(location), dimensionTransition.c(), location.getYaw(), location.getPitch(), dimensionTransition.f(), dimensionTransition.g(), dimensionTransition.cause());
    }

    public static Optional<RespawnPosAngle> a(WorldServer worldserver, BlockPosition blockposition, float f2, boolean flag, boolean flag1) {
        IBlockData iblockdata = worldserver.a_(blockposition);
        Block block = iblockdata.b();
        if (block instanceof BlockRespawnAnchor && (flag || iblockdata.c(BlockRespawnAnchor.d) > 0) && BlockRespawnAnchor.a(worldserver)) {
            Optional<Vec3D> optional = BlockRespawnAnchor.a(EntityTypes.by, worldserver, blockposition);
            if (!flag && !flag1 && optional.isPresent()) {
                worldserver.a(blockposition, (IBlockData)iblockdata.a(BlockRespawnAnchor.d, iblockdata.c(BlockRespawnAnchor.d) - 1), 3);
            }
            return optional.map(vec3d -> RespawnPosAngle.of(vec3d, blockposition, false, true));
        }
        if (block instanceof BlockBed && BlockBed.a(worldserver)) {
            return BlockBed.a(EntityTypes.by, (ICollisionAccess)worldserver, blockposition, iblockdata.c(BlockBed.aE), f2).map(vec3d -> RespawnPosAngle.of(vec3d, blockposition, true, false));
        }
        if (!flag) {
            return Optional.empty();
        }
        boolean flag2 = block.a(iblockdata);
        IBlockData iblockdata1 = worldserver.a_(blockposition.d());
        boolean flag3 = iblockdata1.b().a(iblockdata1);
        return flag2 && flag3 ? Optional.of(new RespawnPosAngle(new Vec3D((double)blockposition.u() + 0.5, (double)blockposition.v() + 0.1, (double)blockposition.w() + 0.5), f2, false, false)) : Optional.empty();
    }

    public void q() {
        this.ak();
        this.A().a(this, Entity.RemovalReason.e);
        if (!this.h) {
            this.h = true;
            this.c.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.f, 0.0f));
            this.f = true;
        }
    }

    @Override
    @Nullable
    public Entity a(DimensionTransition dimensiontransition) {
        if (this.fH()) {
            return null;
        }
        if (this.dJ()) {
            return null;
        }
        if (dimensiontransition.f()) {
            this.c.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.b, 0.0f));
        }
        WorldServer worldserver = dimensiontransition.a();
        WorldServer worldserver1 = this.A();
        ResourceKey<WorldDimension> resourcekey = worldserver1.getTypeKey();
        if (worldserver != null && worldserver.af() == worldserver1.af()) {
            boolean result = this.c.teleport(dimensiontransition.b().c, dimensiontransition.b().d, dimensiontransition.b().e, dimensiontransition.d(), dimensiontransition.e(), dimensiontransition.cause());
            if (!result) {
                return null;
            }
            this.c.l();
            dimensiontransition.g().onTransition(this);
            return this;
        }
        worldserver1.ag().a("moving");
        if (worldserver != null && resourcekey == WorldDimension.b && worldserver.getTypeKey() == WorldDimension.c) {
            this.df = this.dm();
        }
        Location enter = this.getBukkitEntity().getLocation();
        Location exit = worldserver == null ? null : CraftLocation.toBukkit(dimensiontransition.b(), (World)worldserver.getWorld(), dimensiontransition.d(), dimensiontransition.e());
        PlayerTeleportEvent tpEvent = new PlayerTeleportEvent((Player)this.getBukkitEntity(), enter, exit, dimensiontransition.cause());
        Bukkit.getServer().getPluginManager().callEvent((Event)tpEvent);
        if (tpEvent.isCancelled() || tpEvent.getTo() == null) {
            return null;
        }
        exit = tpEvent.getTo();
        worldserver = ((CraftWorld)exit.getWorld()).getHandle();
        worldserver1.ag().c();
        worldserver1.ag().a("placing");
        this.cX = true;
        WorldData worlddata = worldserver.A_();
        this.c.b(new PacketPlayOutRespawn(this.b(worldserver), 3));
        this.c.b(new PacketPlayOutServerDifficulty(worlddata.q(), worlddata.r()));
        PlayerList playerlist = this.d.ah();
        playerlist.e(this);
        worldserver1.a(this, Entity.RemovalReason.e);
        this.dL();
        this.a(worldserver);
        this.c.teleport(exit);
        this.c.l();
        worldserver.d(this);
        worldserver1.ag().c();
        this.c(worldserver1);
        this.c.b(new PacketPlayOutAbilities(this.fZ()));
        playerlist.a(this, worldserver);
        playerlist.f(this);
        playerlist.d(this);
        dimensiontransition.g().onTransition(this);
        this.cR = -1;
        this.cO = -1.0f;
        this.cP = -1;
        PlayerChangedWorldEvent changeEvent = new PlayerChangedWorldEvent((Player)this.getBukkitEntity(), (World)worldserver1.getWorld());
        this.dO().getCraftServer().getPluginManager().callEvent((Event)changeEvent);
        return this;
    }

    @Override
    public CraftPortalEvent callPortalEvent(Entity entity, Location exit, PlayerTeleportEvent.TeleportCause cause, int searchRadius, int creationRadius) {
        Location enter = this.getBukkitEntity().getLocation();
        PlayerPortalEvent event = new PlayerPortalEvent((Player)this.getBukkitEntity(), enter, exit, cause, searchRadius, true, creationRadius);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled() || event.getTo() == null || event.getTo().getWorld() == null) {
            return null;
        }
        return new CraftPortalEvent(event);
    }

    public void c(WorldServer worldserver) {
        ResourceKey<net.minecraft.world.level.World> resourcekey = worldserver.af();
        ResourceKey<net.minecraft.world.level.World> resourcekey1 = this.dO().af();
        ResourceKey<net.minecraft.world.level.World> maindimensionkey = CraftDimensionUtil.getMainDimensionKey(worldserver);
        ResourceKey<net.minecraft.world.level.World> maindimensionkey1 = CraftDimensionUtil.getMainDimensionKey(this.dO());
        CriterionTriggers.w.a(this, maindimensionkey, maindimensionkey1);
        if (maindimensionkey != resourcekey || maindimensionkey1 != resourcekey1) {
            CriterionTriggers.w.a(this, resourcekey, resourcekey1);
        }
        if (maindimensionkey == net.minecraft.world.level.World.i && maindimensionkey1 == net.minecraft.world.level.World.h && this.df != null) {
            CriterionTriggers.D.a(this, this.df);
        }
        if (maindimensionkey1 != net.minecraft.world.level.World.i) {
            this.df = null;
        }
    }

    @Override
    public boolean a(EntityPlayer entityplayer) {
        return entityplayer.R_() ? this.L() == this : (this.R_() ? false : super.a(entityplayer));
    }

    @Override
    public void a(Entity entity, int i2) {
        super.a(entity, i2);
        this.cd.d();
    }

    private Either<EntityHuman.EnumBedResult, Unit> getBedResult(BlockPosition blockposition, EnumDirection enumdirection) {
        if (!this.fH() && this.bE()) {
            if (!this.dO().D_().j() || !this.dO().D_().l()) {
                return Either.left((Object)((Object)EntityHuman.EnumBedResult.a));
            }
            if (!this.a(blockposition, enumdirection)) {
                return Either.left((Object)((Object)EntityHuman.EnumBedResult.c));
            }
            if (this.b(blockposition, enumdirection)) {
                return Either.left((Object)((Object)EntityHuman.EnumBedResult.d));
            }
            this.setRespawnPosition(this.dO().af(), blockposition, this.dE(), false, true, PlayerSpawnChangeEvent.Cause.BED);
            if (this.dO().R()) {
                return Either.left((Object)((Object)EntityHuman.EnumBedResult.b));
            }
            if (!this.f()) {
                double d0 = 8.0;
                double d1 = 5.0;
                Vec3D vec3d = Vec3D.c(blockposition);
                List<EntityMonster> list = this.dO().a(EntityMonster.class, new AxisAlignedBB(vec3d.a() - 8.0, vec3d.b() - 5.0, vec3d.c() - 8.0, vec3d.a() + 8.0, vec3d.b() + 5.0, vec3d.c() + 8.0), (? super T entitymonster) -> entitymonster.a((EntityHuman)this));
                if (!list.isEmpty()) {
                    return Either.left((Object)((Object)EntityHuman.EnumBedResult.f));
                }
            }
            return Either.right((Object)((Object)Unit.a));
        }
        return Either.left((Object)((Object)EntityHuman.EnumBedResult.e));
    }

    @Override
    public Either<EntityHuman.EnumBedResult, Unit> startSleepInBed(BlockPosition blockposition, boolean force) {
        EnumDirection enumdirection = this.dO().a_(blockposition).c(BlockFacingHorizontal.aE);
        Either<EntityHuman.EnumBedResult, Unit> bedResult = this.getBedResult(blockposition, enumdirection);
        if (bedResult.left().orElse(null) == EntityHuman.EnumBedResult.e) {
            return bedResult;
        }
        if (force) {
            bedResult = Either.right((Object)((Object)Unit.a));
        }
        if ((bedResult = CraftEventFactory.callPlayerBedEnterEvent(this, blockposition, bedResult)).left().isPresent()) {
            return bedResult;
        }
        Either either = super.startSleepInBed(blockposition, force).ifRight(unit -> {
            this.a(StatisticList.ap);
            CriterionTriggers.r.a(this);
        });
        if (!this.A().d()) {
            this.a(IChatBaseComponent.c("sleep.not_possible"), true);
        }
        ((WorldServer)this.dO()).e();
        return either;
    }

    @Override
    public void b(BlockPosition blockposition) {
        this.a(StatisticList.i.b(StatisticList.n));
        super.b(blockposition);
    }

    private boolean a(BlockPosition blockposition, EnumDirection enumdirection) {
        return this.i(blockposition) || this.i(blockposition.a(enumdirection.g()));
    }

    private boolean i(BlockPosition blockposition) {
        Vec3D vec3d = Vec3D.c(blockposition);
        return Math.abs(this.dt() - vec3d.a()) <= 3.0 && Math.abs(this.dv() - vec3d.b()) <= 2.0 && Math.abs(this.dz() - vec3d.c()) <= 3.0;
    }

    private boolean b(BlockPosition blockposition, EnumDirection enumdirection) {
        BlockPosition blockposition1 = blockposition.d();
        return !this.h(blockposition1) || !this.h(blockposition1.a(enumdirection.g()));
    }

    @Override
    public void a(boolean flag, boolean flag1) {
        if (!this.fH()) {
            return;
        }
        CraftPlayer player = this.getBukkitEntity();
        BlockPosition bedPosition = this.fF().orElse(null);
        org.bukkit.block.Block bed = bedPosition != null ? this.dO().getWorld().getBlockAt(bedPosition.u(), bedPosition.v(), bedPosition.w()) : this.dO().getWorld().getBlockAt(player.getLocation());
        PlayerBedLeaveEvent event = new PlayerBedLeaveEvent((Player)player, bed, true);
        this.dO().getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        if (this.fH()) {
            this.A().l().a(this, new PacketPlayOutAnimation(this, 2));
        }
        super.a(flag, flag1);
        if (this.c != null) {
            this.c.teleport(this.dt(), this.dv(), this.dz(), this.dE(), this.dG(), PlayerTeleportEvent.TeleportCause.EXIT_BED);
        }
    }

    @Override
    public void a(double d0, double d1, double d2) {
        this.bJ();
        this.a_(d0, d1, d2);
    }

    @Override
    public boolean b(DamageSource damagesource) {
        return super.b(damagesource) || this.P();
    }

    @Override
    protected void a(double d0, boolean flag, IBlockData iblockdata, BlockPosition blockposition) {
    }

    @Override
    protected void b(WorldServer worldserver, BlockPosition blockposition) {
        if (!this.R_()) {
            super.b(worldserver, blockposition);
        }
    }

    public void a(double d0, double d1, double d2, boolean flag) {
        if (!this.dh()) {
            this.b(flag, new Vec3D(d0, d1, d2));
            BlockPosition blockposition = this.aK();
            IBlockData iblockdata = this.dO().a_(blockposition);
            if (this.dq && flag && this.ac > 0.0f) {
                Vec3D vec3d = blockposition.b().b(0.0, 0.5, 0.0);
                int i2 = (int)MathHelper.a(50.0f * this.ac, 0.0f, 200.0f);
                this.A().a(new ParticleParamBlock(Particles.b, iblockdata), vec3d.c, vec3d.d, vec3d.e, i2, (double)0.3f, (double)0.3f, (double)0.3f, 0.15f);
                this.dq = false;
            }
            super.a(d1, flag, iblockdata, blockposition);
        }
    }

    @Override
    public void a(@Nullable Entity entity) {
        super.a(entity);
        this.cx = this.dm();
        this.cy = entity;
        this.w(entity != null && entity.am() == EntityTypes.bn);
    }

    @Override
    protected void r() {
        if (this.dO().s().i()) {
            super.r();
        }
    }

    @Override
    public void a(TileEntitySign tileentitysign, boolean flag) {
        this.c.b(new PacketPlayOutBlockChange(this.dO(), tileentitysign.aD_()));
        this.c.b(new PacketPlayOutOpenSignEditor(tileentitysign.aD_(), flag));
    }

    public int nextContainerCounter() {
        this.dx = this.dx % 100 + 1;
        return this.dx;
    }

    @Override
    public OptionalInt a(@Nullable ITileInventory itileinventory) {
        if (itileinventory == null) {
            return OptionalInt.empty();
        }
        this.nextContainerCounter();
        Container container = itileinventory.createMenu(this.dx, this.fY(), this);
        if (container != null) {
            container.setTitle(itileinventory.S_());
            boolean cancelled = false;
            container = CraftEventFactory.callInventoryOpenEvent(this, container, cancelled);
            if (container == null && !cancelled) {
                if (itileinventory instanceof IInventory) {
                    ((IInventory)((Object)itileinventory)).c(this);
                } else if (itileinventory instanceof BlockChest.DoubleInventory) {
                    ((BlockChest.DoubleInventory)itileinventory).inventorylargechest.c(this);
                }
                return OptionalInt.empty();
            }
        }
        if (container == null) {
            if (this.R_()) {
                this.a(IChatBaseComponent.c("container.spectatorCantOpen").a(EnumChatFormat.m), true);
            }
            return OptionalInt.empty();
        }
        this.cd = container;
        this.c.b(new PacketPlayOutOpenWindow(container.j, container.a(), container.getTitle()));
        this.a(container);
        return OptionalInt.of(this.dx);
    }

    @Override
    public void a(int i2, MerchantRecipeList merchantrecipelist, int j2, int k2, boolean flag, boolean flag1) {
        this.c.b(new PacketPlayOutOpenWindowMerchant(i2, merchantrecipelist, j2, k2, flag, flag1));
    }

    @Override
    public void a(EntityHorseAbstract entityhorseabstract, IInventory iinventory) {
        this.nextContainerCounter();
        Container container = new ContainerHorse(this.dx, this.fY(), iinventory, entityhorseabstract, entityhorseabstract.af_());
        container.setTitle(entityhorseabstract.S_());
        container = CraftEventFactory.callInventoryOpenEvent(this, container);
        if (container == null) {
            iinventory.c(this);
            return;
        }
        if (this.cd != this.cc) {
            this.s();
        }
        int i2 = entityhorseabstract.af_();
        this.c.b(new PacketPlayOutOpenWindowHorse(this.dx, i2, entityhorseabstract.an()));
        this.cd = container;
        this.a(this.cd);
    }

    @Override
    public void a(ItemStack itemstack, EnumHand enumhand) {
        if (itemstack.a(Items.ua)) {
            if (ItemWrittenBook.a(itemstack, this.dg(), this)) {
                this.cd.d();
            }
            this.c.b(new PacketPlayOutOpenBook(enumhand));
        }
    }

    @Override
    public void a(TileEntityCommand tileentitycommand) {
        this.c.b(PacketPlayOutTileEntityData.a(tileentitycommand, TileEntity::e));
    }

    @Override
    public void s() {
        CraftEventFactory.handleInventoryCloseEvent(this);
        this.c.b(new PacketPlayOutCloseWindow(this.cd.j));
        this.t();
    }

    @Override
    public void t() {
        this.cd.a(this);
        this.cc.a(this.cd);
        this.cd = this.cc;
    }

    public void a(float f2, float f1, boolean flag, boolean flag1) {
        if (this.bS()) {
            if (f2 >= -1.0f && f2 <= 1.0f) {
                this.bo = f2;
            }
            if (f1 >= -1.0f && f1 <= 1.0f) {
                this.bq = f1;
            }
            this.bn = flag;
            if (flag1 != this.bW()) {
                PlayerToggleSneakEvent event = new PlayerToggleSneakEvent((Player)this.getBukkitEntity(), flag1);
                this.d.server.getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return;
                }
            }
            this.g(flag1);
        }
    }

    @Override
    public void a(Vec3D vec3d) {
        double d0 = this.dt();
        double d1 = this.dv();
        double d2 = this.dz();
        super.a(vec3d);
        this.b(this.dt() - d0, this.dv() - d1, this.dz() - d2);
    }

    @Override
    public void u() {
        double d0 = this.dt();
        double d1 = this.dv();
        double d2 = this.dz();
        super.u();
        this.q(this.dt() - d0, this.dv() - d1, this.dz() - d2);
    }

    public void b(double d0, double d1, double d2) {
        if (!this.bS() && !EntityPlayer.r(d0, d1, d2)) {
            if (this.cd()) {
                int i2 = Math.round((float)Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2) * 100.0f);
                if (i2 > 0) {
                    this.a(StatisticList.C, i2);
                    this.causeFoodExhaustion(this.dO().spigotConfig.swimMultiplier * (float)i2 * 0.01f, EntityExhaustionEvent.ExhaustionReason.SWIM);
                }
            } else if (((Entity)this).a(TagsFluid.a)) {
                int i3 = Math.round((float)Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2) * 100.0f);
                if (i3 > 0) {
                    this.a(StatisticList.w, i3);
                    this.causeFoodExhaustion(this.dO().spigotConfig.swimMultiplier * (float)i3 * 0.01f, EntityExhaustionEvent.ExhaustionReason.WALK_UNDERWATER);
                }
            } else if (this.bf()) {
                int i4 = Math.round((float)Math.sqrt(d0 * d0 + d2 * d2) * 100.0f);
                if (i4 > 0) {
                    this.a(StatisticList.s, i4);
                    this.causeFoodExhaustion(this.dO().spigotConfig.swimMultiplier * (float)i4 * 0.01f, EntityExhaustionEvent.ExhaustionReason.WALK_ON_WATER);
                }
            } else if (this.p_()) {
                if (d1 > 0.0) {
                    this.a(StatisticList.u, (int)Math.round(d1 * 100.0));
                }
            } else if (this.aF()) {
                int i5 = Math.round((float)Math.sqrt(d0 * d0 + d2 * d2) * 100.0f);
                if (i5 > 0) {
                    if (this.cc()) {
                        this.a(StatisticList.r, i5);
                        this.causeFoodExhaustion(this.dO().spigotConfig.sprintMultiplier * (float)i5 * 0.01f, EntityExhaustionEvent.ExhaustionReason.SPRINT);
                    } else if (this.cb()) {
                        this.a(StatisticList.q, i5);
                        this.causeFoodExhaustion(this.dO().spigotConfig.otherMultiplier * (float)i5 * 0.01f, EntityExhaustionEvent.ExhaustionReason.CROUCH);
                    } else {
                        this.a(StatisticList.p, i5);
                        this.causeFoodExhaustion(this.dO().spigotConfig.otherMultiplier * (float)i5 * 0.01f, EntityExhaustionEvent.ExhaustionReason.WALK);
                    }
                }
            } else if (this.fA()) {
                int i6 = Math.round((float)Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2) * 100.0f);
                this.a(StatisticList.B, i6);
            } else {
                int i7 = Math.round((float)Math.sqrt(d0 * d0 + d2 * d2) * 100.0f);
                if (i7 > 25) {
                    this.a(StatisticList.v, i7);
                }
            }
        }
    }

    private void q(double d0, double d1, double d2) {
        if (this.bS() && !EntityPlayer.r(d0, d1, d2)) {
            int i2 = Math.round((float)Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2) * 100.0f);
            Entity entity = this.dc();
            if (entity instanceof EntityMinecartAbstract) {
                this.a(StatisticList.x, i2);
            } else if (entity instanceof EntityBoat) {
                this.a(StatisticList.y, i2);
            } else if (entity instanceof EntityPig) {
                this.a(StatisticList.z, i2);
            } else if (entity instanceof EntityHorseAbstract) {
                this.a(StatisticList.A, i2);
            } else if (entity instanceof EntityStrider) {
                this.a(StatisticList.D, i2);
            }
        }
    }

    private static boolean r(double d0, double d1, double d2) {
        return d0 == 0.0 && d1 == 0.0 && d2 == 0.0;
    }

    @Override
    public void a(Statistic<?> statistic, int i2) {
        this.cH.b(this, statistic, i2);
        this.dO().getCraftServer().getScoreboardManager().forAllObjectives(statistic, this, scoreaccess -> scoreaccess.b(i2));
    }

    @Override
    public void a(Statistic<?> statistic) {
        this.cH.a(this, statistic, 0);
        this.dO().getCraftServer().getScoreboardManager().forAllObjectives(statistic, this, ScoreAccess::c);
    }

    @Override
    public int a(Collection<RecipeHolder<?>> collection) {
        return this.cY.a(collection, this);
    }

    @Override
    public void a(RecipeHolder<?> recipeholder, List<ItemStack> list) {
        CriterionTriggers.ac.a(this, recipeholder.a(), list);
    }

    @Override
    public void b(List<MinecraftKey> list) {
        List<RecipeHolder<?>> list1 = list.stream().flatMap(minecraftkey -> this.d.aJ().a((MinecraftKey)minecraftkey).stream()).collect(Collectors.toList());
        this.a((Collection<RecipeHolder<?>>)list1);
    }

    @Override
    public int b(Collection<RecipeHolder<?>> collection) {
        return this.cY.b(collection, this);
    }

    @Override
    public void d(int i2) {
        super.d(i2);
        this.cR = -1;
    }

    public void v() {
        this.db = true;
        this.bI();
        if (this.fH()) {
            this.a(true, false);
        }
    }

    public boolean w() {
        return this.db;
    }

    public void x() {
        this.cO = -1.0E8f;
        this.cR = -1;
    }

    @Override
    public void a(IChatBaseComponent ichatbasecomponent, boolean flag) {
        this.b(ichatbasecomponent, flag);
    }

    @Override
    protected void L_() {
        if (!this.bz.e() && this.fr()) {
            this.c.b(new PacketPlayOutEntityStatus(this, 9));
            super.L_();
        }
    }

    @Override
    public void a(ArgumentAnchor.Anchor argumentanchor_anchor, Vec3D vec3d) {
        super.a(argumentanchor_anchor, vec3d);
        this.c.b(new PacketPlayOutLookAt(argumentanchor_anchor, vec3d.c, vec3d.d, vec3d.e));
    }

    public void a(ArgumentAnchor.Anchor argumentanchor_anchor, Entity entity, ArgumentAnchor.Anchor argumentanchor_anchor1) {
        Vec3D vec3d = argumentanchor_anchor1.a(entity);
        super.a(argumentanchor_anchor, vec3d);
        this.c.b(new PacketPlayOutLookAt(argumentanchor_anchor, entity, argumentanchor_anchor1));
    }

    public void a(EntityPlayer entityplayer, boolean flag) {
        this.dr = entityplayer.dr;
        this.dw = entityplayer.dw;
        this.e.a(entityplayer.e.b(), entityplayer.e.c());
        this.z();
        this.eS().b(entityplayer.eS());
        if (flag) {
            this.fY().a(entityplayer.fY());
            this.v(entityplayer.ew());
            this.ce = entityplayer.ce;
            for (MobEffect mobEffect : entityplayer.et()) {
            }
            this.cq = entityplayer.cq;
            this.cr = entityplayer.cr;
            this.cs = entityplayer.cs;
            this.r(entityplayer.fS());
            this.aw = entityplayer.aw;
        } else if (this.dO().ab().b(GameRules.d) || entityplayer.R_()) {
            this.fY().a(entityplayer.fY());
            this.cq = entityplayer.cq;
            this.cr = entityplayer.cr;
            this.cs = entityplayer.cs;
            this.r(entityplayer.fS());
        }
        this.ct = entityplayer.ct;
        this.cb = entityplayer.cb;
        this.ar().a(bX, (Byte)entityplayer.ar().a(bX));
        this.cR = -1;
        this.cO = -1.0f;
        this.cP = -1;
        this.f = entityplayer.f;
        this.df = entityplayer.df;
        this.di = entityplayer.di;
        this.i(entityplayer.gp());
        this.j(entityplayer.gq());
        ((EntityHuman)this).a(entityplayer.gx());
    }

    @Override
    protected void a(MobEffect mobeffect, @Nullable Entity entity) {
        super.a(mobeffect, entity);
        this.c.b(new PacketPlayOutEntityEffect(this.an(), mobeffect, true));
        if (mobeffect.a(MobEffects.y)) {
            this.da = this.ai;
            this.cZ = this.dm();
        }
        CriterionTriggers.B.a(this, entity);
    }

    @Override
    protected void a(MobEffect mobeffect, boolean flag, @Nullable Entity entity) {
        super.a(mobeffect, flag, entity);
        this.c.b(new PacketPlayOutEntityEffect(this.an(), mobeffect, false));
        CriterionTriggers.B.a(this, entity);
    }

    @Override
    protected void a(MobEffect mobeffect) {
        super.a(mobeffect);
        this.c.b(new PacketPlayOutRemoveEntityEffect(this.an(), mobeffect.c()));
        if (mobeffect.a(MobEffects.y)) {
            this.cZ = null;
        }
        CriterionTriggers.B.a(this, (Entity)null);
    }

    @Override
    public void c(double d0, double d1, double d2) {
        this.c.a(d0, d1, d2, this.dE(), this.dG(), RelativeMovement.g);
    }

    @Override
    public void d(double d0, double d1, double d2) {
        this.c.a(this.dt() + d0, this.dv() + d1, this.dz() + d2, this.dE(), this.dG(), RelativeMovement.f);
    }

    @Override
    public boolean a(WorldServer worldserver, double d0, double d1, double d2, Set<RelativeMovement> set, float f2, float f1) {
        return this.teleportTo(worldserver, d0, d1, d2, set, f2, f1, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    @Override
    public boolean teleportTo(WorldServer worldserver, double d0, double d1, double d2, Set<RelativeMovement> set, float f2, float f1, PlayerTeleportEvent.TeleportCause cause) {
        ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(BlockPosition.a(d0, d1, d2));
        worldserver.l().a(TicketType.f, chunkcoordintpair, 1, this.an());
        this.ad();
        if (this.fH()) {
            this.a(true, true);
        }
        if (worldserver == this.dO()) {
            this.c.teleport(d0, d1, d2, f2, f1, set, cause);
        } else {
            this.teleportTo(worldserver, d0, d1, d2, f2, f1, cause);
        }
        this.o(f2);
        return true;
    }

    @Override
    public void e(double d0, double d1, double d2) {
        super.e(d0, d1, d2);
        this.c.l();
    }

    @Override
    public void b(Entity entity) {
        this.A().l().a(this, new PacketPlayOutAnimation(entity, 4));
    }

    @Override
    public void c(Entity entity) {
        this.A().l().a(this, new PacketPlayOutAnimation(entity, 5));
    }

    @Override
    public void z() {
        if (this.c != null) {
            this.c.b(new PacketPlayOutAbilities(this.fZ()));
            this.K();
        }
    }

    public WorldServer A() {
        return (WorldServer)this.dO();
    }

    public boolean a(EnumGamemode enumgamemode) {
        boolean flag = this.R_();
        if (!this.e.a(enumgamemode)) {
            return false;
        }
        this.c.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.e, enumgamemode.a()));
        if (enumgamemode == EnumGamemode.d) {
            this.gm();
            this.ad();
            EnchantmentManager.a(this);
        } else {
            this.d((Entity)this);
            if (flag) {
                EnchantmentManager.a(this.A(), (EntityLiving)this);
            }
        }
        this.z();
        this.fp();
        return true;
    }

    @Override
    public boolean R_() {
        return this.e.b() == EnumGamemode.d;
    }

    @Override
    public boolean f() {
        return this.e.b() == EnumGamemode.b;
    }

    @Override
    public void a(IChatBaseComponent ichatbasecomponent) {
        this.b(ichatbasecomponent, false);
    }

    public void b(IChatBaseComponent ichatbasecomponent, boolean flag) {
        if (this.x(flag)) {
            this.c.a(new ClientboundSystemChatPacket(ichatbasecomponent, flag), PacketSendListener.a(() -> {
                if (this.x(false)) {
                    boolean flag1 = true;
                    String s2 = ichatbasecomponent.a(256);
                    IChatMutableComponent ichatmutablecomponent = IChatBaseComponent.b(s2).a(EnumChatFormat.o);
                    return new ClientboundSystemChatPacket(IChatBaseComponent.a("multiplayer.message_not_delivered", ichatmutablecomponent).a(EnumChatFormat.m), false);
                }
                return null;
            }));
        }
    }

    public void a(OutgoingChatMessage outgoingchatmessage, boolean flag, ChatMessageType.a chatmessagetype_a) {
        if (this.gH()) {
            outgoingchatmessage.a(this, flag, chatmessagetype_a);
        }
    }

    public String B() {
        SocketAddress socketaddress = this.c.m();
        if (socketaddress instanceof InetSocketAddress) {
            InetSocketAddress inetsocketaddress = (InetSocketAddress)socketaddress;
            return InetAddresses.toAddrString((InetAddress)inetsocketaddress.getAddress());
        }
        return "<unknown>";
    }

    public void a(ClientInformation clientinformation) {
        PlayerChangedMainHandEvent event;
        if (this.fq() != clientinformation.g()) {
            event = new PlayerChangedMainHandEvent((Player)this.getBukkitEntity(), this.fq() == EnumMainHand.a ? MainHand.LEFT : MainHand.RIGHT);
            this.d.server.getPluginManager().callEvent((Event)event);
        }
        if (!this.dd.equals(clientinformation.b())) {
            event = new PlayerLocaleChangeEvent((Player)this.getBukkitEntity(), clientinformation.b());
            this.d.server.getPluginManager().callEvent((Event)event);
        }
        this.dd = clientinformation.b();
        this.dc = clientinformation.c();
        this.cT = clientinformation.d();
        this.cU = clientinformation.e();
        this.do = clientinformation.h();
        this.dp = clientinformation.i();
        this.ar().a(bX, (byte)clientinformation.f());
        this.ar().a(bY, (byte)clientinformation.g().a());
    }

    public ClientInformation C() {
        byte b0 = (Byte)this.ar().a(bX);
        EnumMainHand enummainhand = EnumMainHand.d.apply(((Byte)this.ar().a(bY)).byteValue());
        return new ClientInformation(this.dd, this.dc, this.cT, this.cU, b0, enummainhand, this.do, this.dp);
    }

    public boolean D() {
        return this.cU;
    }

    public EnumChatVisibility E() {
        return this.cT;
    }

    private boolean x(boolean flag) {
        return this.cT == EnumChatVisibility.c ? flag : true;
    }

    private boolean gH() {
        return this.cT == EnumChatVisibility.a;
    }

    public int F() {
        return this.dc;
    }

    public void a(ServerPing serverping) {
        this.c.b(new ClientboundServerDataPacket(serverping.a(), serverping.d().map(ServerPing.a::a)));
    }

    @Override
    protected int G() {
        return this.d.c(this.fX());
    }

    public void H() {
        this.cV = SystemUtils.c();
    }

    public ServerStatisticManager I() {
        return this.cH;
    }

    public RecipeBookServer J() {
        return this.cY;
    }

    @Override
    protected void K() {
        if (this.R_()) {
            this.er();
            this.k(true);
        } else {
            super.K();
        }
    }

    public Entity L() {
        return this.cW == null ? this : this.cW;
    }

    public void d(@Nullable Entity entity) {
        Entity entity1 = this.L();
        Entity entity2 = this.cW = entity == null ? this : entity;
        if (entity1 != this.cW) {
            net.minecraft.world.level.World world = this.cW.dO();
            if (world instanceof WorldServer) {
                WorldServer worldserver = (WorldServer)world;
                this.teleportTo(worldserver, this.cW.dt(), this.cW.dv(), this.cW.dz(), Set.of(), this.dE(), this.dG(), PlayerTeleportEvent.TeleportCause.SPECTATE);
            }
            if (entity != null) {
                this.A().l().a(this);
            }
            this.c.b(new PacketPlayOutCamera(this.cW));
            this.c.l();
        }
    }

    @Override
    protected void M() {
        if (!this.cX) {
            super.M();
        }
    }

    @Override
    public void e(Entity entity) {
        if (this.e.b() == EnumGamemode.d) {
            this.d(entity);
        } else {
            super.e(entity);
        }
    }

    public long N() {
        return this.cV;
    }

    @Nullable
    public IChatBaseComponent O() {
        return this.listName;
    }

    @Override
    public void a(EnumHand enumhand) {
        super.a(enumhand);
        this.gs();
    }

    public boolean P() {
        return this.cX;
    }

    public void Q() {
        this.cX = false;
    }

    public AdvancementDataPlayer R() {
        return this.cG;
    }

    public void a(WorldServer worldserver, double d0, double d1, double d2, float f2, float f1) {
        this.teleportTo(worldserver, d0, d1, d2, f2, f1, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    public void teleportTo(WorldServer worldserver, double d0, double d1, double d2, float f2, float f1, PlayerTeleportEvent.TeleportCause cause) {
        this.d((Entity)this);
        this.ad();
        this.getBukkitEntity().teleport(new Location((World)worldserver.getWorld(), d0, d1, d2, f2, f1), cause);
    }

    @Nullable
    public BlockPosition S() {
        return this.dk;
    }

    public float T() {
        return this.dm;
    }

    public ResourceKey<net.minecraft.world.level.World> U() {
        return this.dj;
    }

    public boolean V() {
        return this.dl;
    }

    public void b(EntityPlayer entityplayer) {
        this.a(entityplayer.U(), entityplayer.S(), entityplayer.T(), entityplayer.V(), false);
    }

    public void a(ResourceKey<net.minecraft.world.level.World> resourcekey, @Nullable BlockPosition blockposition, float f2, boolean flag, boolean flag1) {
        this.setRespawnPosition(resourcekey, blockposition, f2, flag, flag1, PlayerSpawnChangeEvent.Cause.UNKNOWN);
    }

    public void setRespawnPosition(ResourceKey<net.minecraft.world.level.World> resourcekey, @Nullable BlockPosition blockposition, float f2, boolean flag, boolean flag1, PlayerSpawnChangeEvent.Cause cause) {
        WorldServer newWorld = this.d.a(resourcekey);
        Location newSpawn = blockposition != null ? CraftLocation.toBukkit(blockposition, (World)newWorld.getWorld(), f2, 0.0f) : null;
        PlayerSpawnChangeEvent event = new PlayerSpawnChangeEvent((Player)this.getBukkitEntity(), newSpawn, flag, cause);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        newSpawn = event.getNewSpawn();
        flag = event.isForced();
        if (newSpawn != null) {
            resourcekey = ((CraftWorld)newSpawn.getWorld()).getHandle().af();
            blockposition = BlockPosition.a(newSpawn.getX(), newSpawn.getY(), newSpawn.getZ());
            f2 = newSpawn.getYaw();
        } else {
            resourcekey = net.minecraft.world.level.World.h;
            blockposition = null;
            f2 = 0.0f;
        }
        if (blockposition != null) {
            boolean flag2;
            boolean bl = flag2 = blockposition.equals(this.dk) && resourcekey.equals(this.dj);
            if (flag1 && !flag2) {
                this.a(IChatBaseComponent.c("block.minecraft.set_spawn"));
            }
            this.dk = blockposition;
            this.dj = resourcekey;
            this.dm = f2;
            this.dl = flag;
        } else {
            this.dk = null;
            this.dj = net.minecraft.world.level.World.h;
            this.dm = 0.0f;
            this.dl = false;
        }
    }

    public SectionPosition W() {
        return this.dh;
    }

    public void a(SectionPosition sectionposition) {
        this.dh = sectionposition;
    }

    public ChunkTrackingView X() {
        return this.di;
    }

    public void a(ChunkTrackingView chunktrackingview) {
        this.di = chunktrackingview;
    }

    @Override
    public void a(SoundEffect soundeffect, SoundCategory soundcategory, float f2, float f1) {
        this.c.b(new PacketPlayOutNamedSoundEffect(BuiltInRegistries.b.e(soundeffect), soundcategory, this.dt(), this.dv(), this.dz(), f2, f1, this.ah.g()));
    }

    @Override
    public EntityItem a(ItemStack itemstack, boolean flag, boolean flag1) {
        return this.drop(itemstack, flag, flag1, true);
    }

    @Override
    public EntityItem drop(ItemStack itemstack, boolean flag, boolean flag1, boolean callEvent) {
        EntityItem entityitem = super.drop(itemstack, flag, flag1, callEvent);
        if (entityitem == null) {
            return null;
        }
        this.dO().b(entityitem);
        ItemStack itemstack1 = entityitem.p();
        if (flag1) {
            if (!itemstack1.e()) {
                this.a(StatisticList.f.b(itemstack1.g()), itemstack.H());
            }
            this.a(StatisticList.F);
        }
        return entityitem;
    }

    public ITextFilter Y() {
        return this.dn;
    }

    public void a(WorldServer worldserver) {
        this.a((net.minecraft.world.level.World)worldserver);
        this.e.a(worldserver);
    }

    @Nullable
    private static EnumGamemode a(@Nullable NBTTagCompound nbttagcompound, String s2) {
        return nbttagcompound != null && nbttagcompound.b(s2, 99) ? EnumGamemode.a(nbttagcompound.h(s2)) : null;
    }

    private EnumGamemode b(@Nullable EnumGamemode enumgamemode) {
        EnumGamemode enumgamemode1 = this.d.bf();
        return enumgamemode1 != null ? enumgamemode1 : (enumgamemode != null ? enumgamemode : this.d.u_());
    }

    public void c(@Nullable NBTTagCompound nbttagcompound) {
        this.e.a(this.b(EntityPlayer.a(nbttagcompound, "playerGameType")), EntityPlayer.a(nbttagcompound, "previousPlayerGameType"));
    }

    private void k(NBTTagCompound nbttagcompound) {
        nbttagcompound.a("playerGameType", this.e.b().a());
        EnumGamemode enumgamemode = this.e.c();
        if (enumgamemode != null) {
            nbttagcompound.a("previousPlayerGameType", enumgamemode.a());
        }
    }

    @Override
    public boolean Z() {
        return this.do;
    }

    public boolean c(EntityPlayer entityplayer) {
        return entityplayer == this ? false : this.do || entityplayer.do;
    }

    @Override
    public boolean a(net.minecraft.world.level.World world, BlockPosition blockposition) {
        return super.a(world, blockposition) && world.a(this, blockposition);
    }

    @Override
    protected void a(ItemStack itemstack) {
        CriterionTriggers.W.a(this, itemstack);
        super.a(itemstack);
    }

    public boolean a(boolean flag) {
        PlayerInventory playerinventory = this.fY();
        ItemStack itemstack = playerinventory.a(flag);
        this.cd.b(playerinventory, playerinventory.k).ifPresent(i2 -> this.cd.a(i2, playerinventory.f()));
        return this.a(itemstack, false, true) != null;
    }

    public boolean aa() {
        return this.dp;
    }

    @Override
    public Optional<WardenSpawnTracker> ab() {
        return Optional.of(this.dr);
    }

    public void b(boolean flag) {
        this.dq = flag;
    }

    @Override
    public void a(EntityItem entityitem) {
        super.a(entityitem);
        Entity entity = entityitem.s();
        if (entity != null) {
            CriterionTriggers.S.a(this, entityitem.p(), entity);
        }
    }

    public void a(RemoteChatSession remotechatsession) {
        this.dw = remotechatsession;
    }

    @Nullable
    public RemoteChatSession ac() {
        return this.dw != null && this.dw.b() ? null : this.dw;
    }

    @Override
    public void a(double d0, double d1) {
        this.cw = (float)(MathHelper.d(d1, d0) * 57.2957763671875 - (double)this.dE());
        this.c.b(new ClientboundHurtAnimationPacket(this));
    }

    @Override
    public boolean a(Entity entity, boolean flag) {
        if (super.a(entity, flag)) {
            this.b(Vec3D.b);
            entity.j(this);
            this.c.a(this.dt(), this.dv(), this.dz(), this.dE(), this.dG());
            if (entity instanceof EntityLiving) {
                EntityLiving entityliving = (EntityLiving)entity;
                this.d.ah().a(entityliving, this.c);
            }
            return true;
        }
        return false;
    }

    @Override
    public void ad() {
        Entity entity = this.dc();
        super.ad();
        if (entity instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)entity;
            for (MobEffect mobeffect : entityliving.et()) {
                this.c.b(new PacketPlayOutRemoveEntityEffect(entity.an(), mobeffect.c()));
            }
        }
    }

    public CommonPlayerSpawnInfo b(WorldServer worldserver) {
        return new CommonPlayerSpawnInfo(worldserver.ae(), worldserver.af(), BiomeManager.a(worldserver.C()), this.e.b(), this.e.c(), worldserver.ai(), worldserver.B(), this.gx(), this.az());
    }

    public void c(BlockPosition blockposition) {
        this.ds = blockposition;
    }

    public void ae() {
        this.ds = null;
    }

    @Nullable
    public BlockPosition af() {
        return this.ds;
    }

    @Override
    public Vec3D ag() {
        Entity entity = this.dc();
        return entity != null && entity.cQ() != this ? entity.ag() : this.dt;
    }

    public void b(Vec3D vec3d) {
        this.dt = vec3d;
    }

    @Override
    protected float a(Entity entity, float f2, DamageSource damagesource) {
        return EnchantmentManager.a(this.A(), this.dS(), entity, damagesource, f2);
    }

    @Override
    public void a(Item item, EnumItemSlot enumitemslot) {
        super.a(item, enumitemslot);
        this.b(StatisticList.d.b(item));
    }

    public long getPlayerTime() {
        if (this.relativeTime) {
            return this.dO().aa() + this.timeOffset;
        }
        return this.dO().aa() - this.dO().aa() % 24000L + this.timeOffset;
    }

    public WeatherType getPlayerWeather() {
        return this.weather;
    }

    public void setPlayerWeather(WeatherType type, boolean plugin) {
        if (!plugin && this.weather != null) {
            return;
        }
        if (plugin) {
            this.weather = type;
        }
        if (type == WeatherType.DOWNFALL) {
            this.c.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.d, 0.0f));
        } else {
            this.c.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.c, 0.0f));
        }
    }

    public void updateWeather(float oldRain, float newRain, float oldThunder, float newThunder) {
        if (this.weather == null) {
            if (oldRain != newRain) {
                this.c.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.i, newRain));
            }
        } else if (this.pluginRainPositionPrevious != this.pluginRainPosition) {
            this.c.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.i, this.pluginRainPosition));
        }
        if (oldThunder != newThunder) {
            if (this.weather == WeatherType.DOWNFALL || this.weather == null) {
                this.c.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.j, newThunder));
            } else {
                this.c.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.j, 0.0f));
            }
        }
    }

    public void tickWeather() {
        if (this.weather == null) {
            return;
        }
        this.pluginRainPositionPrevious = this.pluginRainPosition;
        this.pluginRainPosition = this.weather == WeatherType.DOWNFALL ? (float)((double)this.pluginRainPosition + 0.01) : (float)((double)this.pluginRainPosition - 0.01);
        this.pluginRainPosition = MathHelper.a(this.pluginRainPosition, 0.0f, 1.0f);
    }

    public void resetPlayerWeather() {
        this.weather = null;
        this.setPlayerWeather(this.dO().A_().i() ? WeatherType.DOWNFALL : WeatherType.CLEAR, false);
    }

    @Override
    public String toString() {
        return super.toString() + "(" + this.cB() + " at " + this.dt() + "," + this.dv() + "," + this.dz() + ")";
    }

    public void forceSetPositionRotation(double x2, double y2, double z2, float yaw, float pitch) {
        this.b(x2, y2, z2, yaw, pitch);
        this.c.l();
    }

    @Override
    public boolean fc() {
        return super.fc() || !this.getBukkitEntity().isOnline();
    }

    @Override
    public Scoreboard gn() {
        return this.getBukkitEntity().getScoreboard().getHandle();
    }

    public void reset() {
        float exp = 0.0f;
        boolean keepInventory = this.dO().ab().b(GameRules.d);
        if (this.keepLevel) {
            exp = this.cs;
            this.newTotalExp = this.cr;
            this.newLevel = this.cq;
        }
        this.v(this.eN());
        this.fx();
        this.h(0);
        this.ac = 0.0f;
        this.ce = new FoodMetaData(this);
        this.cq = this.newLevel;
        this.cr = this.newTotalExp;
        this.cs = 0.0f;
        this.aQ = 0;
        this.setArrowCount(0, true);
        this.removeAllEffects(EntityPotionEffectEvent.Cause.DEATH);
        this.cb = true;
        this.cd = this.cc;
        this.bc = null;
        this.cc = null;
        this.bV = new CombatTracker(this);
        this.cR = -1;
        if (this.keepLevel) {
            this.cs = exp;
        } else {
            this.d(this.newExp);
        }
        this.keepLevel = false;
        this.n(0.0, 0.0, 0.0);
        this.cp = false;
    }

    @Override
    public CraftPlayer getBukkitEntity() {
        return (CraftPlayer)super.getBukkitEntity();
    }

    public record RespawnPosAngle(Vec3D a, float b, boolean isBedSpawn, boolean isAnchorSpawn) {
        public static RespawnPosAngle of(Vec3D vec3d, BlockPosition blockposition, boolean isBedSpawn, boolean isAnchorSpawn) {
            return new RespawnPosAngle(vec3d, RespawnPosAngle.b(vec3d, blockposition), isBedSpawn, isAnchorSpawn);
        }

        private static float b(Vec3D vec3d, BlockPosition blockposition) {
            Vec3D vec3d1 = Vec3D.c(blockposition).d(vec3d).d();
            return (float)MathHelper.d(MathHelper.d(vec3d1.e, vec3d1.c) * 57.2957763671875 - 90.0);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{RespawnPosAngle.class, "position;yaw;isBedSpawn;isAnchorSpawn", "a", "b", "isBedSpawn", "isAnchorSpawn"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{RespawnPosAngle.class, "position;yaw;isBedSpawn;isAnchorSpawn", "a", "b", "isBedSpawn", "isAnchorSpawn"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{RespawnPosAngle.class, "position;yaw;isBedSpawn;isAnchorSpawn", "a", "b", "isBedSpawn", "isAnchorSpawn"}, this, o2);
        }
    }
}

