/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.ReportedException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkGenerationTask;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.ChunkResult;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.GeneratingChunkMap;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.util.StaticCache2D;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.ProtoChunkExtension;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.status.ChunkStep;

public abstract class GenerationChunkHolder {
    private static final List<ChunkStatus> a = ChunkStatus.a();
    private static final ChunkResult<IChunkAccess> e = ChunkResult.a("Not done yet");
    public static final ChunkResult<IChunkAccess> b = ChunkResult.a("Unloaded chunk");
    public static final CompletableFuture<ChunkResult<IChunkAccess>> c = CompletableFuture.completedFuture(b);
    protected final ChunkCoordIntPair d;
    @Nullable
    private volatile ChunkStatus f;
    private final AtomicReference<ChunkStatus> g = new AtomicReference();
    private final AtomicReferenceArray<CompletableFuture<ChunkResult<IChunkAccess>>> h = new AtomicReferenceArray(a.size());
    private final AtomicReference<ChunkGenerationTask> i = new AtomicReference();
    private final AtomicInteger j = new AtomicInteger();

    public GenerationChunkHolder(ChunkCoordIntPair var0) {
        this.d = var0;
    }

    public CompletableFuture<ChunkResult<IChunkAccess>> a(ChunkStatus var0, PlayerChunkMap var1) {
        if (this.f(var0)) {
            return c;
        }
        CompletableFuture<ChunkResult<IChunkAccess>> var2 = this.c(var0);
        if (var2.isDone()) {
            return var2;
        }
        ChunkGenerationTask var3 = this.i.get();
        if (var3 == null || var0.b(var3.a)) {
            this.a(var1, var0);
        }
        return var2;
    }

    CompletableFuture<ChunkResult<IChunkAccess>> a(ChunkStep var0, GeneratingChunkMap var12, StaticCache2D<GenerationChunkHolder> var22) {
        if (this.f(var0.a())) {
            return c;
        }
        if (this.e(var0.a())) {
            return var12.a(this, var0, var22).handle((var1, var2) -> {
                if (var2 != null) {
                    CrashReport var3 = CrashReport.a(var2, "Exception chunk generation/loading");
                    MinecraftServer.a(new ReportedException(var3));
                } else {
                    this.a(var0.a(), (IChunkAccess)var1);
                }
                return ChunkResult.a(var1);
            });
        }
        return this.c(var0.a());
    }

    protected void a(PlayerChunkMap var0) {
        boolean var3;
        ChunkStatus var2;
        ChunkStatus var1 = this.f;
        this.f = var2 = ChunkLevel.a(this.i());
        boolean bl = var3 = var1 != null && (var2 == null || var2.d(var1));
        if (var3) {
            this.a(var2, var1);
            if (this.i.get() != null) {
                this.a(var0, this.d(var2));
            }
        }
    }

    public void a(ProtoChunkExtension var0) {
        CompletableFuture<ChunkResult<ProtoChunkExtension>> var1 = CompletableFuture.completedFuture(ChunkResult.a(var0));
        for (int var2 = 0; var2 < this.h.length() - 1; ++var2) {
            CompletableFuture<ChunkResult<IChunkAccess>> var3 = this.h.get(var2);
            Objects.requireNonNull(var3);
            IChunkAccess var4 = var3.getNow(e).b((IChunkAccess)null);
            if (var4 instanceof ProtoChunk) {
                if (this.h.compareAndSet(var2, var3, var1)) continue;
                throw new IllegalStateException("Future changed by other thread while trying to replace it");
            }
            throw new IllegalStateException("Trying to replace a ProtoChunk, but found " + String.valueOf(var4));
        }
    }

    void a(ChunkGenerationTask var0) {
        this.i.compareAndSet(var0, null);
    }

    private void a(PlayerChunkMap var0, @Nullable ChunkStatus var1) {
        ChunkGenerationTask var2 = var1 != null ? var0.a(var1, this.r()) : null;
        ChunkGenerationTask var3 = this.i.getAndSet(var2);
        if (var3 != null) {
            var3.b();
        }
    }

    private CompletableFuture<ChunkResult<IChunkAccess>> c(ChunkStatus var0) {
        if (this.f(var0)) {
            return c;
        }
        int var1 = var0.b();
        CompletableFuture<ChunkResult<IChunkAccess>> var2 = this.h.get(var1);
        while (var2 == null) {
            CompletableFuture<ChunkResult<IChunkAccess>> var3 = new CompletableFuture<ChunkResult<IChunkAccess>>();
            var2 = this.h.compareAndExchange(var1, null, var3);
            if (var2 != null) continue;
            if (this.f(var0)) {
                this.a(var1, var3);
                return c;
            }
            return var3;
        }
        return var2;
    }

    private void a(@Nullable ChunkStatus var0, ChunkStatus var1) {
        int var2 = var0 == null ? 0 : var0.b() + 1;
        int var3 = var1.b();
        for (int var4 = var2; var4 <= var3; ++var4) {
            CompletableFuture<ChunkResult<IChunkAccess>> var5 = this.h.get(var4);
            if (var5 == null) continue;
            this.a(var4, var5);
        }
    }

    private void a(int var0, CompletableFuture<ChunkResult<IChunkAccess>> var1) {
        if (var1.complete(b) && !this.h.compareAndSet(var0, var1, null)) {
            throw new IllegalStateException("Nothing else should replace the future here");
        }
    }

    private void a(ChunkStatus var0, IChunkAccess var1) {
        ChunkResult<IChunkAccess> var2 = ChunkResult.a(var1);
        int var3 = var0.b();
        while (true) {
            CompletableFuture<ChunkResult<IChunkAccess>> var4;
            if ((var4 = this.h.get(var3)) == null) {
                if (!this.h.compareAndSet(var3, null, CompletableFuture.completedFuture(var2))) continue;
                return;
            }
            if (var4.complete(var2)) {
                return;
            }
            if (var4.getNow(e).a()) {
                throw new IllegalStateException("Trying to complete a future but found it to be completed successfully already");
            }
            Thread.yield();
        }
    }

    @Nullable
    private ChunkStatus d(@Nullable ChunkStatus var0) {
        if (var0 == null) {
            return null;
        }
        ChunkStatus var1 = var0;
        ChunkStatus var2 = this.g.get();
        while (var2 == null || var1.b(var2)) {
            if (this.h.get(var1.b()) != null) {
                return var1;
            }
            if (var1 == ChunkStatus.c) break;
            var1 = var1.c();
        }
        return null;
    }

    private boolean e(ChunkStatus var0) {
        ChunkStatus var1 = var0 == ChunkStatus.c ? null : var0.c();
        ChunkStatus var2 = this.g.compareAndExchange(var1, var0);
        if (var2 == var1) {
            return true;
        }
        if (var2 == null || var0.b(var2)) {
            throw new IllegalStateException("Unexpected last startedWork status: " + String.valueOf(var2) + " while trying to start: " + String.valueOf(var0));
        }
        return false;
    }

    private boolean f(ChunkStatus var0) {
        ChunkStatus var1 = this.f;
        return var1 == null || var0.b(var1);
    }

    public void m() {
        this.j.incrementAndGet();
    }

    public void n() {
        int var0 = this.j.decrementAndGet();
        if (var0 < 0) {
            throw new IllegalStateException("More releases than claims. Count: " + var0);
        }
    }

    public int o() {
        return this.j.get();
    }

    @Nullable
    public IChunkAccess a(ChunkStatus var0) {
        CompletableFuture<ChunkResult<IChunkAccess>> var1 = this.h.get(var0.b());
        return var1 == null ? null : (IChunkAccess)var1.getNow(e).b((IChunkAccess)null);
    }

    @Nullable
    public IChunkAccess b(ChunkStatus var0) {
        if (this.f(var0)) {
            return null;
        }
        return this.a(var0);
    }

    @Nullable
    public IChunkAccess p() {
        ChunkStatus var0 = this.g.get();
        if (var0 == null) {
            return null;
        }
        IChunkAccess var1 = this.a(var0);
        if (var1 != null) {
            return var1;
        }
        return this.a(var0.c());
    }

    @Nullable
    public ChunkStatus q() {
        CompletableFuture<ChunkResult<IChunkAccess>> var0 = this.h.get(ChunkStatus.c.b());
        IChunkAccess var1 = var0 == null ? null : (IChunkAccess)var0.getNow(e).b((IChunkAccess)null);
        return var1 == null ? null : var1.j();
    }

    public ChunkCoordIntPair r() {
        return this.d;
    }

    public FullChunkStatus s() {
        return ChunkLevel.c(this.i());
    }

    public abstract int i();

    public abstract int j();

    @VisibleForDebug
    public List<Pair<ChunkStatus, CompletableFuture<ChunkResult<IChunkAccess>>>> t() {
        ArrayList<Pair<ChunkStatus, CompletableFuture<ChunkResult<IChunkAccess>>>> var0 = new ArrayList<Pair<ChunkStatus, CompletableFuture<ChunkResult<IChunkAccess>>>>();
        for (int var1 = 0; var1 < a.size(); ++var1) {
            var0.add((Pair<ChunkStatus, CompletableFuture<ChunkResult<IChunkAccess>>>)Pair.of((Object)a.get(var1), this.h.get(var1)));
        }
        return var0;
    }

    @Nullable
    @VisibleForDebug
    public ChunkStatus u() {
        for (int var0 = a.size() - 1; var0 >= 0; --var0) {
            ChunkStatus var1 = a.get(var0);
            IChunkAccess var2 = this.a(var1);
            if (var2 == null) continue;
            return var1;
        }
        return null;
    }
}

