/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.mojang.logging.LogUtils;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.GenerationChunkHolder;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StaticCache2D;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ITileEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.IChunkProvider;
import net.minecraft.world.level.chunk.status.ChunkDependencies;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.status.ChunkStep;
import net.minecraft.world.level.chunk.status.ChunkType;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.ticks.LevelTickAccess;
import net.minecraft.world.ticks.TickListWorldGen;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.slf4j.Logger;

public class RegionLimitedWorldAccess
implements GeneratorAccessSeed {
    private static final Logger a = LogUtils.getLogger();
    private final StaticCache2D<GenerationChunkHolder> b;
    private final IChunkAccess c;
    private final WorldServer d;
    private final long e;
    private final WorldData f;
    private final RandomSource g;
    private final DimensionManager h;
    private final TickListWorldGen<Block> i = new TickListWorldGen(blockposition -> this.y((BlockPosition)blockposition).o());
    private final TickListWorldGen<FluidType> j = new TickListWorldGen(blockposition -> this.y((BlockPosition)blockposition).p());
    private final BiomeManager k;
    private final ChunkStep l;
    @Nullable
    private Supplier<String> m;
    private final AtomicLong n = new AtomicLong();
    private static final MinecraftKey o = MinecraftKey.b("worldgen_region_random");

    public RegionLimitedWorldAccess(WorldServer worldserver, StaticCache2D<GenerationChunkHolder> staticcache2d, ChunkStep chunkstep, IChunkAccess ichunkaccess) {
        this.l = chunkstep;
        this.b = staticcache2d;
        this.c = ichunkaccess;
        this.d = worldserver;
        this.e = worldserver.C();
        this.f = worldserver.A_();
        this.g = worldserver.l().i().a(o).a(this.c.f().l());
        this.h = worldserver.D_();
        this.k = new BiomeManager(this, BiomeManager.a(this.e));
    }

    public boolean a(ChunkCoordIntPair chunkcoordintpair, int i2) {
        return this.d.l().a.b(chunkcoordintpair, i2);
    }

    public ChunkCoordIntPair a() {
        return this.c.f();
    }

    @Override
    public void a(@Nullable Supplier<String> supplier) {
        this.m = supplier;
    }

    @Override
    public IChunkAccess a(int i2, int j2) {
        return this.a(i2, j2, ChunkStatus.c);
    }

    @Override
    @Nullable
    public IChunkAccess a(int i2, int j2, ChunkStatus chunkstatus, boolean flag) {
        GenerationChunkHolder generationchunkholder;
        ChunkStatus chunkstatus1;
        int k2 = this.c.f().e(i2, j2);
        ChunkStatus chunkStatus = chunkstatus1 = k2 >= this.l.b().b() ? null : this.l.b().a(k2);
        if (chunkstatus1 != null) {
            IChunkAccess ichunkaccess;
            generationchunkholder = this.b.a(i2, j2);
            if (chunkstatus.c(chunkstatus1) && (ichunkaccess = generationchunkholder.a(chunkstatus1)) != null) {
                return ichunkaccess;
            }
        } else {
            generationchunkholder = null;
        }
        CrashReport crashreport = CrashReport.a(new IllegalStateException("Requested chunk unavailable during world generation"), "Exception generating new chunk");
        CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Chunk request details");
        crashreportsystemdetails.a("Requested chunk", String.format(Locale.ROOT, "%d, %d", i2, j2));
        crashreportsystemdetails.a("Generating status", () -> this.l.a().f());
        Objects.requireNonNull(chunkstatus);
        crashreportsystemdetails.a("Requested status", chunkstatus::f);
        crashreportsystemdetails.a("Actual status", () -> generationchunkholder == null ? "[out of cache bounds]" : generationchunkholder.q().f());
        crashreportsystemdetails.a("Maximum allowed status", () -> chunkstatus1 == null ? "null" : chunkstatus1.f());
        ChunkDependencies chunkdependencies = this.l.b();
        Objects.requireNonNull(chunkdependencies);
        crashreportsystemdetails.a("Dependencies", chunkdependencies::toString);
        crashreportsystemdetails.a("Requested distance", k2);
        ChunkCoordIntPair chunkcoordintpair = this.c.f();
        Objects.requireNonNull(chunkcoordintpair);
        crashreportsystemdetails.a("Generating chunk", chunkcoordintpair::toString);
        throw new ReportedException(crashreport);
    }

    @Override
    public boolean b(int i2, int j2) {
        int k2 = this.c.f().e(i2, j2);
        return k2 < this.l.b().b();
    }

    @Override
    public IBlockData a_(BlockPosition blockposition) {
        return this.a(SectionPosition.a(blockposition.u()), SectionPosition.a(blockposition.w())).a_(blockposition);
    }

    @Override
    public Fluid b_(BlockPosition blockposition) {
        return this.y(blockposition).b_(blockposition);
    }

    @Override
    @Nullable
    public EntityHuman a(double d0, double d1, double d2, double d3, Predicate<Entity> predicate) {
        return null;
    }

    @Override
    public int B_() {
        return 0;
    }

    @Override
    public BiomeManager F_() {
        return this.k;
    }

    @Override
    public Holder<BiomeBase> a(int i2, int j2, int k2) {
        return this.d.a(i2, j2, k2);
    }

    @Override
    public float a(EnumDirection enumdirection, boolean flag) {
        return 1.0f;
    }

    @Override
    public LevelLightEngine y_() {
        return this.d.y_();
    }

    @Override
    public boolean a(BlockPosition blockposition, boolean flag, @Nullable Entity entity, int i2) {
        IBlockData iblockdata = this.a_(blockposition);
        if (iblockdata.i()) {
            return false;
        }
        return this.a(blockposition, Blocks.a.o(), 3, i2);
    }

    @Override
    @Nullable
    public TileEntity c_(BlockPosition blockposition) {
        IChunkAccess ichunkaccess = this.y(blockposition);
        TileEntity tileentity = ichunkaccess.c_(blockposition);
        if (tileentity != null) {
            return tileentity;
        }
        NBTTagCompound nbttagcompound = ichunkaccess.f(blockposition);
        IBlockData iblockdata = ichunkaccess.a_(blockposition);
        if (nbttagcompound != null) {
            if ("DUMMY".equals(nbttagcompound.l("id"))) {
                if (!iblockdata.t()) {
                    return null;
                }
                tileentity = ((ITileEntity)((Object)iblockdata.b())).a(blockposition, iblockdata);
            } else {
                tileentity = TileEntity.a(blockposition, iblockdata, nbttagcompound, this.d.H_());
            }
            if (tileentity != null) {
                ichunkaccess.a(tileentity);
                return tileentity;
            }
        }
        if (iblockdata.t()) {
            a.warn("Tried to access a block entity before it was created. {}", (Object)blockposition);
        }
        return null;
    }

    @Override
    public boolean f_(BlockPosition blockposition) {
        int i2 = SectionPosition.a(blockposition.u());
        int j2 = SectionPosition.a(blockposition.w());
        ChunkCoordIntPair chunkcoordintpair = this.a();
        int k2 = Math.abs(chunkcoordintpair.e - i2);
        int l2 = Math.abs(chunkcoordintpair.f - j2);
        if (k2 <= this.l.d() && l2 <= this.l.d()) {
            if (this.c.y()) {
                LevelHeightAccessor levelheightaccessor = this.c.z();
                if (blockposition.v() < levelheightaccessor.I_() || blockposition.v() >= levelheightaccessor.am()) {
                    return false;
                }
            }
            return true;
        }
        SystemUtils.b("Detected setBlock in a far chunk [" + i2 + ", " + j2 + "], pos: " + String.valueOf(blockposition) + ", status: " + String.valueOf(this.l.a()) + (String)(this.m == null ? "" : ", currently generating: " + this.m.get()));
        return false;
    }

    @Override
    public boolean a(BlockPosition blockposition, IBlockData iblockdata, int i2, int j2) {
        if (!this.f_(blockposition)) {
            return false;
        }
        IChunkAccess ichunkaccess = this.y(blockposition);
        IBlockData iblockdata1 = ichunkaccess.a(blockposition, iblockdata, false);
        if (iblockdata1 != null) {
            this.d.a(blockposition, iblockdata1, iblockdata);
        }
        if (iblockdata.t()) {
            if (ichunkaccess.j().d() == ChunkType.b) {
                TileEntity tileentity = ((ITileEntity)((Object)iblockdata.b())).a(blockposition, iblockdata);
                if (tileentity != null) {
                    ichunkaccess.a(tileentity);
                } else {
                    ichunkaccess.d(blockposition);
                }
            } else {
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                nbttagcompound.a("x", blockposition.u());
                nbttagcompound.a("y", blockposition.v());
                nbttagcompound.a("z", blockposition.w());
                nbttagcompound.a("id", "DUMMY");
                ichunkaccess.a(nbttagcompound);
            }
        } else if (iblockdata1 != null && iblockdata1.t()) {
            ichunkaccess.d(blockposition);
        }
        if (iblockdata.q(this, blockposition)) {
            this.f(blockposition);
        }
        return true;
    }

    private void f(BlockPosition blockposition) {
        this.y(blockposition).e(blockposition);
    }

    @Override
    public boolean b(Entity entity) {
        return this.addFreshEntity(entity, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    @Override
    public boolean addFreshEntity(Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        int i2 = SectionPosition.a(entity.ds());
        int j2 = SectionPosition.a(entity.dy());
        this.a(i2, j2).a(entity);
        return true;
    }

    @Override
    public boolean a(BlockPosition blockposition, boolean flag) {
        return this.a(blockposition, Blocks.a.o(), 3);
    }

    @Override
    public WorldBorder C_() {
        return this.d.C_();
    }

    @Override
    public boolean x_() {
        return false;
    }

    @Override
    @Deprecated
    public WorldServer E() {
        return this.d;
    }

    @Override
    public IRegistryCustom H_() {
        return this.d.H_();
    }

    @Override
    public FeatureFlagSet J() {
        return this.d.J();
    }

    @Override
    public WorldData A_() {
        return this.f;
    }

    @Override
    public DifficultyDamageScaler d_(BlockPosition blockposition) {
        if (!this.b(SectionPosition.a(blockposition.u()), SectionPosition.a(blockposition.w()))) {
            throw new RuntimeException("We are asking a region for a chunk out of bound");
        }
        return new DifficultyDamageScaler(this.d.al(), this.d.aa(), 0L, this.d.aq());
    }

    @Override
    @Nullable
    public MinecraftServer o() {
        return this.d.o();
    }

    @Override
    public IChunkProvider N() {
        return this.d.l();
    }

    @Override
    public long C() {
        return this.e;
    }

    @Override
    public LevelTickAccess<Block> P() {
        return this.i;
    }

    @Override
    public LevelTickAccess<FluidType> O() {
        return this.j;
    }

    @Override
    public int z_() {
        return this.d.z_();
    }

    @Override
    public RandomSource E_() {
        return this.g;
    }

    @Override
    public int a(HeightMap.Type heightmap_type, int i2, int j2) {
        return this.a(SectionPosition.a(i2), SectionPosition.a(j2)).a(heightmap_type, i2 & 0xF, j2 & 0xF) + 1;
    }

    @Override
    public void a(@Nullable EntityHuman entityhuman, BlockPosition blockposition, SoundEffect soundeffect, SoundCategory soundcategory, float f2, float f1) {
    }

    @Override
    public void a(ParticleParam particleparam, double d0, double d1, double d2, double d3, double d4, double d5) {
    }

    @Override
    public void a(@Nullable EntityHuman entityhuman, int i2, BlockPosition blockposition, int j2) {
    }

    @Override
    public void a(Holder<GameEvent> holder, Vec3D vec3d, GameEvent.a gameevent_a) {
    }

    @Override
    public DimensionManager D_() {
        return this.h;
    }

    @Override
    public boolean a(BlockPosition blockposition, Predicate<IBlockData> predicate) {
        return predicate.test(this.a_(blockposition));
    }

    @Override
    public boolean b(BlockPosition blockposition, Predicate<Fluid> predicate) {
        return predicate.test(this.b_(blockposition));
    }

    @Override
    public <T extends Entity> List<T> a(EntityTypeTest<Entity, T> entitytypetest, AxisAlignedBB axisalignedbb, Predicate<? super T> predicate) {
        return Collections.emptyList();
    }

    @Override
    public List<Entity> a(@Nullable Entity entity, AxisAlignedBB axisalignedbb, @Nullable Predicate<? super Entity> predicate) {
        return Collections.emptyList();
    }

    public List<EntityHuman> x() {
        return Collections.emptyList();
    }

    @Override
    public int I_() {
        return this.d.I_();
    }

    @Override
    public int J_() {
        return this.d.J_();
    }

    @Override
    public long G_() {
        return this.n.getAndIncrement();
    }
}

