/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSets;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportType;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundDamageEventPacket;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.protocol.game.PacketPlayOutBlockAction;
import net.minecraft.network.protocol.game.PacketPlayOutBlockBreakAnimation;
import net.minecraft.network.protocol.game.PacketPlayOutEntitySound;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutExplosion;
import net.minecraft.network.protocol.game.PacketPlayOutNamedSoundEffect;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnPosition;
import net.minecraft.network.protocol.game.PacketPlayOutWorldEvent;
import net.minecraft.network.protocol.game.PacketPlayOutWorldParticles;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.progress.WorldLoadListener;
import net.minecraft.server.players.SleepStatus;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.tags.TagKey;
import net.minecraft.util.AbortableIterationConsumer;
import net.minecraft.util.CSVWriter;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.IInventory;
import net.minecraft.world.RandomSequences;
import net.minecraft.world.TickRateManager;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.entity.ReputationHandler;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.village.ReputationEvent;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityWaterAnimal;
import net.minecraft.world.entity.animal.horse.EntityHorseSkeleton;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.npc.NPC;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.raid.PersistentRaid;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.alchemy.PotionBrewer;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.level.BlockActionData;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.ForcedChunk;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.MobSpawner;
import net.minecraft.world.level.SpawnerCreature;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockSnow;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.storage.EntityStorage;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.chunk.storage.SimpleRegionStorage;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.dimension.end.EnderDragonBattle;
import net.minecraft.world.level.entity.EntityTickList;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.entity.LevelCallback;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.entity.PersistentEntitySectionManager;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventDispatcher;
import net.minecraft.world.level.levelgen.ChunkGeneratorAbstract;
import net.minecraft.world.level.levelgen.ChunkProviderFlat;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructureCheck;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.pathfinder.PathTypeCache;
import net.minecraft.world.level.portal.PortalTravelAgent;
import net.minecraft.world.level.saveddata.PersistentBase;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.PersistentIdCounts;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.WorldDataServer;
import net.minecraft.world.level.storage.WorldPersistentData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import net.minecraft.world.ticks.TickListServer;
import org.bukkit.Bukkit;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R1.generator.CustomChunkGenerator;
import org.bukkit.craftbukkit.v1_21_R1.generator.CustomWorldChunkManager;
import org.bukkit.craftbukkit.v1_21_R1.util.WorldUUID;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LightningStrike;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.server.MapInitializeEvent;
import org.bukkit.event.weather.LightningStrikeEvent;
import org.bukkit.event.world.TimeSkipEvent;
import org.bukkit.event.world.WorldSaveEvent;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.WorldInfo;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.map.MapView;
import org.slf4j.Logger;
import org.spigotmc.ActivationRange;
import org.spigotmc.AsyncCatcher;

public class WorldServer
extends net.minecraft.world.level.World
implements GeneratorAccessSeed {
    public static final BlockPosition a = new BlockPosition(100, 50, 0);
    public static final IntProvider b = UniformInt.a(12000, 180000);
    public static final IntProvider c = UniformInt.a(12000, 24000);
    private static final IntProvider D = UniformInt.a(12000, 180000);
    public static final IntProvider d = UniformInt.a(3600, 15600);
    private static final Logger E = LogUtils.getLogger();
    private static final int F = 300;
    private static final int G = 65536;
    final List<EntityPlayer> H;
    private final ChunkProviderServer I;
    private final MinecraftServer J;
    public final WorldDataServer K;
    private int L;
    final EntityTickList M;
    public final PersistentEntitySectionManager<Entity> N;
    private final GameEventDispatcher O;
    public boolean e;
    private final SleepStatus P;
    private int Q;
    private final PortalTravelAgent R;
    private final TickListServer<Block> S;
    private final TickListServer<FluidType> T;
    private final PathTypeCache U;
    final Set<EntityInsentient> V;
    volatile boolean W;
    protected final PersistentRaid f;
    private final ObjectLinkedOpenHashSet<BlockActionData> X;
    private final List<BlockActionData> Y;
    private boolean Z;
    private final List<MobSpawner> aa;
    @Nullable
    private EnderDragonBattle ab;
    final Int2ObjectMap<EntityComplexPart> ac;
    private final StructureManager ad;
    private final StructureCheck ae;
    private final boolean af;
    private final RandomSequences ag;
    public final Convertable.ConversionSession convertable;
    public final UUID uuid;

    public Chunk getChunkIfLoaded(int x2, int z2) {
        return this.I.a(x2, z2, false);
    }

    @Override
    public ResourceKey<WorldDimension> getTypeKey() {
        return this.convertable.dimensionType;
    }

    public WorldServer(MinecraftServer minecraftserver, Executor executor, Convertable.ConversionSession convertable_conversionsession, WorldDataServer iworlddataserver, ResourceKey<net.minecraft.world.level.World> resourcekey, WorldDimension worlddimension, WorldLoadListener worldloadlistener, boolean flag, long i2, List<MobSpawner> list, boolean flag1, @Nullable RandomSequences randomsequences, World.Environment env, org.bukkit.generator.ChunkGenerator gen, BiomeProvider biomeProvider) {
        super(iworlddataserver, resourcekey, minecraftserver.bc(), worlddimension.a(), minecraftserver::aT, false, flag, i2, minecraftserver.bl(), gen, biomeProvider, env);
        this.pvpMode = minecraftserver.ad();
        this.convertable = convertable_conversionsession;
        this.uuid = WorldUUID.getUUID(convertable_conversionsession.c.f().toFile());
        this.H = Lists.newArrayList();
        this.M = new EntityTickList();
        this.S = new TickListServer(this::d, this.ah());
        this.T = new TickListServer(this::d, this.ah());
        this.U = new PathTypeCache();
        this.V = new ObjectOpenHashSet();
        this.X = new ObjectLinkedOpenHashSet();
        this.Y = new ArrayList<BlockActionData>(64);
        this.ac = new Int2ObjectOpenHashMap();
        this.af = flag1;
        this.J = minecraftserver;
        this.aa = list;
        this.K = iworlddataserver;
        ChunkGenerator chunkgenerator = worlddimension.b();
        this.K.setWorld(this);
        if (biomeProvider != null) {
            CustomWorldChunkManager worldChunkManager = new CustomWorldChunkManager((WorldInfo)this.getWorld(), biomeProvider, this.J.bc().d(Registries.aF));
            if (chunkgenerator instanceof ChunkGeneratorAbstract) {
                ChunkGeneratorAbstract cga = (ChunkGeneratorAbstract)chunkgenerator;
                chunkgenerator = new ChunkGeneratorAbstract((WorldChunkManager)worldChunkManager, cga.e);
            } else if (chunkgenerator instanceof ChunkProviderFlat) {
                ChunkProviderFlat cpf = (ChunkProviderFlat)chunkgenerator;
                chunkgenerator = new ChunkProviderFlat(cpf.h(), worldChunkManager);
            }
        }
        if (gen != null) {
            chunkgenerator = new CustomChunkGenerator(this, chunkgenerator, gen);
        }
        boolean flag2 = minecraftserver.aZ();
        DataFixer datafixer = minecraftserver.aD();
        EntityStorage entitypersistentstorage = new EntityStorage(new SimpleRegionStorage(new RegionStorageInfo(convertable_conversionsession.f(), resourcekey, "entities"), convertable_conversionsession.a(resourcekey).resolve("entities"), datafixer, flag2, DataFixTypes.s), this, minecraftserver);
        this.N = new PersistentEntitySectionManager<Entity>(Entity.class, new a(), entitypersistentstorage);
        StructureTemplateManager structuretemplatemanager = minecraftserver.ba();
        int j2 = this.spigotConfig.viewDistance;
        int k2 = this.spigotConfig.simulationDistance;
        PersistentEntitySectionManager<Entity> persistententitysectionmanager = this.N;
        Objects.requireNonNull(this.N);
        this.I = new ChunkProviderServer(this, convertable_conversionsession, datafixer, structuretemplatemanager, executor, chunkgenerator, j2, k2, flag2, worldloadlistener, persistententitysectionmanager::a, () -> minecraftserver.I().u());
        this.I.h().b();
        this.R = new PortalTravelAgent(this);
        this.U();
        this.X();
        this.C_().a(minecraftserver.ax());
        this.f = this.u().a(PersistentRaid.a(this), PersistentRaid.a(this.ae()));
        if (!minecraftserver.T()) {
            iworlddataserver.a(minecraftserver.u_());
        }
        long l2 = minecraftserver.bb().y().b();
        this.ae = new StructureCheck(this.I.m(), this.H_(), minecraftserver.ba(), resourcekey, chunkgenerator, this.I.i(), this, chunkgenerator.d(), l2, datafixer);
        this.ad = new StructureManager(this, this.K.y(), this.ae);
        this.ab = this.af() == net.minecraft.world.level.World.j && this.ae().a(BuiltinDimensionTypes.c) || env == World.Environment.THE_END ? new EnderDragonBattle(this, this.K.y().b(), this.K.C()) : null;
        this.P = new SleepStatus();
        this.O = new GameEventDispatcher(this);
        this.ag = Objects.requireNonNullElseGet(randomsequences, () -> this.u().a(RandomSequences.a(l2), "random_sequences"));
        this.getCraftServer().addWorld(this.getWorld());
    }

    @Deprecated
    @VisibleForTesting
    public void a(@Nullable EnderDragonBattle enderdragonbattle) {
        this.ab = enderdragonbattle;
    }

    public void a(int i2, int j2, boolean flag, boolean flag1) {
        this.K.a(i2);
        this.K.c(j2);
        this.K.b(j2);
        this.K.b(flag);
        this.K.a(flag1);
    }

    @Override
    public Holder<BiomeBase> a(int i2, int j2, int k2) {
        return this.l().g().d().getNoiseBiome(i2, j2, k2, this.l().i().b());
    }

    public StructureManager a() {
        return this.ad;
    }

    public void a(BooleanSupplier booleansupplier) {
        long j2;
        int i2;
        GameProfilerFiller gameprofilerfiller = this.ag();
        this.Z = true;
        TickRateManager tickratemanager = this.s();
        boolean flag = tickratemanager.i();
        if (flag) {
            gameprofilerfiller.a("world border");
            this.C_().s();
            gameprofilerfiller.b("weather");
            this.au();
        }
        if (this.P.a(i2 = this.ab().c(GameRules.P)) && this.P.a(i2, this.H)) {
            j2 = this.A.d() + 24000L;
            TimeSkipEvent event = new TimeSkipEvent((World)this.getWorld(), TimeSkipEvent.SkipReason.NIGHT_SKIP, j2 - j2 % 24000L - this.aa());
            if (this.ab().b(GameRules.l)) {
                this.getCraftServer().getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    this.b(this.aa() + event.getSkipAmount());
                }
            }
            if (!event.isCancelled()) {
                this.as();
            }
            if (this.ab().b(GameRules.v) && this.ad()) {
                this.g();
            }
        }
        this.U();
        if (flag) {
            this.b();
        }
        gameprofilerfiller.b("tickPending");
        this.timings.doTickPending.startTiming();
        if (!this.ai() && flag) {
            j2 = this.Z();
            gameprofilerfiller.a("blockTicks");
            this.S.a(j2, 65536, this::d);
            gameprofilerfiller.b("fluidTicks");
            this.T.a(j2, 65536, this::a);
            gameprofilerfiller.c();
        }
        this.timings.doTickPending.stopTiming();
        gameprofilerfiller.b("raid");
        if (flag) {
            this.f.a();
        }
        gameprofilerfiller.b("chunkSource");
        this.l().a(booleansupplier, true);
        gameprofilerfiller.b("blockEvents");
        if (flag) {
            this.timings.doSounds.startTiming();
            this.aw();
            this.timings.doSounds.stopTiming();
        }
        this.Z = false;
        gameprofilerfiller.c();
        boolean flag1 = true;
        if (flag1) {
            this.h();
        }
        if (flag1 || this.Q++ < 300) {
            gameprofilerfiller.a("entities");
            this.timings.tickEntities.startTiming();
            if (this.ab != null && flag) {
                gameprofilerfiller.a("dragonFight");
                this.ab.c();
                gameprofilerfiller.c();
            }
            ActivationRange.activateEntities(this);
            this.timings.entityTick.startTiming();
            this.M.a((Entity entity) -> {
                if (!entity.dJ() && !tickratemanager.a((Entity)entity)) {
                    gameprofilerfiller.a("checkDespawn");
                    entity.dA();
                    gameprofilerfiller.c();
                    if (this.I.a.j().c(entity.dq().a())) {
                        Entity entity1 = entity.dc();
                        if (entity1 != null) {
                            if (!entity1.dJ() && entity1.x((Entity)entity)) {
                                return;
                            }
                            entity.ad();
                        }
                        gameprofilerfiller.a("tick");
                        this.a(this::a, entity);
                        gameprofilerfiller.c();
                    }
                }
            });
            this.timings.entityTick.stopTiming();
            this.timings.tickEntities.stopTiming();
            gameprofilerfiller.c();
            this.T();
        }
        gameprofilerfiller.a("entityManagement");
        this.N.a();
        gameprofilerfiller.c();
    }

    @Override
    public boolean a(long i2) {
        return this.I.a.j().d(i2);
    }

    protected void b() {
        if (this.af) {
            long i2 = this.A.c() + 1L;
            this.K.a(i2);
            this.K.s().a(this.J, i2);
            if (this.A.o().b(GameRules.l)) {
                this.b(this.A.d() + 1L);
            }
        }
    }

    public void b(long i2) {
        this.K.b(i2);
    }

    public void a(boolean flag, boolean flag1) {
        for (MobSpawner mobspawner : this.aa) {
            mobspawner.a(this, flag, flag1);
        }
    }

    private boolean i(Entity entity) {
        return !this.J.ab() && (entity instanceof EntityAnimal || entity instanceof EntityWaterAnimal) ? true : !this.J.ac() && entity instanceof NPC;
    }

    private void as() {
        this.P.a();
        this.H.stream().filter(EntityLiving::fH).collect(Collectors.toList()).forEach(entityplayer -> entityplayer.a(false, false));
    }

    public void a(Chunk chunk, int i2) {
        BlockPosition blockposition;
        ChunkCoordIntPair chunkcoordintpair = chunk.f();
        boolean flag = this.ad();
        int j2 = chunkcoordintpair.d();
        int k2 = chunkcoordintpair.e();
        GameProfilerFiller gameprofilerfiller = this.ag();
        gameprofilerfiller.a("thunder");
        if (flag && this.ac() && this.spigotConfig.thunderChance > 0 && this.z.a(this.spigotConfig.thunderChance) == 0 && this.r(blockposition = this.b(this.a(j2, 0, k2, 15)))) {
            EntityLightning entitylightning;
            EntityHorseSkeleton entityhorseskeleton;
            boolean flag1;
            DifficultyDamageScaler difficultydamagescaler = this.d_(blockposition);
            boolean bl = flag1 = this.ab().b(GameRules.e) && this.z.j() < (double)difficultydamagescaler.b() * 0.01 && !this.a_(blockposition.e()).a(Blocks.ss);
            if (flag1 && (entityhorseskeleton = EntityTypes.aO.a(this)) != null) {
                entityhorseskeleton.x(true);
                entityhorseskeleton.c_(0);
                entityhorseskeleton.a_(blockposition.u(), blockposition.v(), blockposition.w());
                this.addFreshEntity(entityhorseskeleton, CreatureSpawnEvent.SpawnReason.LIGHTNING);
            }
            if ((entitylightning = EntityTypes.am.a(this)) != null) {
                entitylightning.f(Vec3D.c(blockposition));
                entitylightning.a(flag1);
                this.strikeLightning(entitylightning, LightningStrikeEvent.Cause.WEATHER);
            }
        }
        gameprofilerfiller.b("iceandsnow");
        for (int l2 = 0; l2 < i2; ++l2) {
            if (this.z.a(48) != 0) continue;
            this.a(this.a(j2, 0, k2, 15));
        }
        gameprofilerfiller.b("tickBlocks");
        if (i2 > 0) {
            ChunkSection[] achunksection = chunk.d();
            for (int i1 = 0; i1 < achunksection.length; ++i1) {
                ChunkSection chunksection = achunksection[i1];
                if (!chunksection.d()) continue;
                int j1 = chunk.g(i1);
                int k1 = SectionPosition.c(j1);
                for (int l1 = 0; l1 < i2; ++l1) {
                    Fluid fluid;
                    BlockPosition blockposition1 = this.a(j2, k1, k2, 15);
                    gameprofilerfiller.a("randomTick");
                    IBlockData iblockdata = chunksection.a(blockposition1.u() - j2, blockposition1.v() - k1, blockposition1.w() - k2);
                    if (iblockdata.v()) {
                        iblockdata.b(this, blockposition1, this.z);
                    }
                    if ((fluid = iblockdata.u()).f()) {
                        fluid.b(this, blockposition1, this.z);
                    }
                    gameprofilerfiller.c();
                }
            }
        }
        gameprofilerfiller.c();
    }

    @VisibleForTesting
    public void a(BlockPosition blockposition) {
        BlockPosition blockposition1 = this.a(HeightMap.Type.e, blockposition);
        BlockPosition blockposition2 = blockposition1.e();
        BiomeBase biomebase = this.t(blockposition1).a();
        if (biomebase.a(this, blockposition2)) {
            CraftEventFactory.handleBlockFormEvent((net.minecraft.world.level.World)this, blockposition2, Blocks.dO.o(), null);
        }
        if (this.ad()) {
            BiomeBase.Precipitation biomebase_precipitation;
            int i2 = this.ab().c(GameRules.T);
            if (i2 > 0 && biomebase.b(this, blockposition1)) {
                IBlockData iblockdata = this.a_(blockposition1);
                if (iblockdata.a(Blocks.dN)) {
                    int j2 = iblockdata.c(BlockSnow.c);
                    if (j2 < Math.min(i2, 8)) {
                        IBlockData iblockdata1 = (IBlockData)iblockdata.a(BlockSnow.c, j2 + 1);
                        Block.a(iblockdata, iblockdata1, this, blockposition1);
                        CraftEventFactory.handleBlockFormEvent((net.minecraft.world.level.World)this, blockposition1, iblockdata1, null);
                    }
                } else {
                    CraftEventFactory.handleBlockFormEvent((net.minecraft.world.level.World)this, blockposition1, Blocks.dN.o(), null);
                }
            }
            if ((biomebase_precipitation = biomebase.a(blockposition2)) != BiomeBase.Precipitation.a) {
                IBlockData iblockdata2 = this.a_(blockposition2);
                iblockdata2.b().a(iblockdata2, (net.minecraft.world.level.World)this, blockposition2, biomebase_precipitation);
            }
        }
    }

    private Optional<BlockPosition> E(BlockPosition blockposition) {
        Optional<BlockPosition> optional = this.y().e(holder -> holder.a(PoiTypes.t), blockposition1 -> blockposition1.v() == this.a(HeightMap.Type.b, blockposition1.u(), blockposition1.w()) - 1, blockposition, 128, VillagePlace.Occupancy.c);
        return optional.map(blockposition1 -> blockposition1.b(1));
    }

    protected BlockPosition b(BlockPosition blockposition) {
        BlockPosition blockposition1 = this.a(HeightMap.Type.e, blockposition);
        Optional<BlockPosition> optional = this.E(blockposition1);
        if (optional.isPresent()) {
            return optional.get();
        }
        AxisAlignedBB axisalignedbb = AxisAlignedBB.a(blockposition1, new BlockPosition(blockposition1.h(this.am()))).g(3.0);
        List<EntityLiving> list = this.a(EntityLiving.class, axisalignedbb, (? super T entityliving) -> entityliving != null && entityliving.bE() && this.h(entityliving.do()));
        if (!list.isEmpty()) {
            return list.get(this.z.a(list.size())).do();
        }
        if (blockposition1.v() == this.I_() - 1) {
            blockposition1 = blockposition1.b(2);
        }
        return blockposition1;
    }

    public boolean c() {
        return this.Z;
    }

    public boolean d() {
        return this.ab().c(GameRules.P) <= 100;
    }

    private void at() {
        if (this.d() && (!this.o().T() || this.o().r())) {
            int i2 = this.ab().c(GameRules.P);
            IChatMutableComponent ichatmutablecomponent = this.P.a(i2) ? IChatBaseComponent.c("sleep.skipping_night") : IChatBaseComponent.a("sleep.players_sleeping", this.P.b(), this.P.b(i2));
            for (EntityPlayer entityplayer : this.H) {
                entityplayer.a(ichatmutablecomponent, true);
            }
        }
    }

    public void e() {
        if (!this.H.isEmpty() && this.P.a(this.H)) {
            this.at();
        }
    }

    public ScoreboardServer f() {
        return this.J.aK();
    }

    private void au() {
        int idx;
        boolean flag = this.ad();
        if (this.D_().g()) {
            if (this.ab().b(GameRules.v)) {
                int i2 = this.K.f();
                int j2 = this.K.h();
                int k2 = this.K.j();
                boolean flag1 = this.A.g();
                boolean flag2 = this.A.i();
                if (i2 > 0) {
                    --i2;
                    j2 = flag1 ? 0 : 1;
                    k2 = flag2 ? 0 : 1;
                    flag1 = false;
                    flag2 = false;
                } else {
                    if (j2 > 0) {
                        if (--j2 == 0) {
                            flag1 = !flag1;
                        }
                    } else {
                        j2 = flag1 ? d.a(this.z) : D.a(this.z);
                    }
                    if (k2 > 0) {
                        if (--k2 == 0) {
                            flag2 = !flag2;
                        }
                    } else {
                        k2 = flag2 ? c.a(this.z) : b.a(this.z);
                    }
                }
                this.K.b(j2);
                this.K.c(k2);
                this.K.a(i2);
                this.K.a(flag1);
                this.K.b(flag2);
            }
            this.x = this.y;
            this.y = this.A.g() ? (this.y += 0.01f) : (this.y -= 0.01f);
            this.y = MathHelper.a(this.y, 0.0f, 1.0f);
            this.v = this.w;
            this.w = this.A.i() ? (this.w += 0.01f) : (this.w -= 0.01f);
            this.w = MathHelper.a(this.w, 0.0f, 1.0f);
        }
        for (idx = 0; idx < this.H.size(); ++idx) {
            if (this.H.get(idx).dO() != this) continue;
            this.H.get(idx).tickWeather();
        }
        if (flag != this.ad()) {
            for (idx = 0; idx < this.H.size(); ++idx) {
                if (this.H.get(idx).dO() != this) continue;
                this.H.get(idx).setPlayerWeather(!flag ? WeatherType.DOWNFALL : WeatherType.CLEAR, false);
            }
        }
        for (idx = 0; idx < this.H.size(); ++idx) {
            if (this.H.get(idx).dO() != this) continue;
            this.H.get(idx).updateWeather(this.v, this.w, this.x, this.y);
        }
    }

    @VisibleForTesting
    public void g() {
        this.K.b(false);
        if (!this.K.i()) {
            this.K.c(0);
        }
        this.K.a(false);
        if (!this.K.g()) {
            this.K.b(0);
        }
    }

    public void h() {
        this.Q = 0;
    }

    private void a(BlockPosition blockposition, FluidType fluidtype) {
        Fluid fluid = this.b_(blockposition);
        if (fluid.b(fluidtype)) {
            fluid.a(this, blockposition);
        }
    }

    private void d(BlockPosition blockposition, Block block) {
        IBlockData iblockdata = this.a_(blockposition);
        if (iblockdata.a(block)) {
            iblockdata.a(this, blockposition, this.z);
        }
    }

    public void a(Entity entity) {
        if (!ActivationRange.checkIfActive(entity)) {
            ++entity.ai;
            entity.inactiveTick();
            return;
        }
        entity.tickTimer.startTiming();
        entity.bv();
        GameProfilerFiller gameprofilerfiller = this.ag();
        ++entity.ai;
        this.ag().a(() -> BuiltInRegistries.f.b(entity.am()).toString());
        gameprofilerfiller.d("tickNonPassenger");
        entity.l();
        entity.postTick();
        this.ag().c();
        for (Entity entity1 : entity.cS()) {
            this.a(entity, entity1);
        }
        entity.tickTimer.stopTiming();
    }

    private void a(Entity entity, Entity entity1) {
        if (!entity1.dJ() && entity1.dc() == entity) {
            if (entity1 instanceof EntityHuman || this.M.c(entity1)) {
                entity1.bv();
                ++entity1.ai;
                GameProfilerFiller gameprofilerfiller = this.ag();
                gameprofilerfiller.a(() -> BuiltInRegistries.f.b(entity1.am()).toString());
                gameprofilerfiller.d("tickPassenger");
                entity1.u();
                entity1.postTick();
                gameprofilerfiller.c();
                for (Entity entity2 : entity1.cS()) {
                    this.a(entity1, entity2);
                }
            }
        } else {
            entity1.ad();
        }
    }

    @Override
    public boolean a(EntityHuman entityhuman, BlockPosition blockposition) {
        return !this.J.a(this, blockposition, entityhuman) && this.C_().a(blockposition);
    }

    public void a(@Nullable IProgressUpdate iprogressupdate, boolean flag, boolean flag1) {
        ChunkProviderServer chunkproviderserver = this.l();
        if (!flag1) {
            Bukkit.getPluginManager().callEvent((Event)new WorldSaveEvent((World)this.getWorld()));
            if (iprogressupdate != null) {
                iprogressupdate.a(IChatBaseComponent.c("menu.savingLevel"));
            }
            this.av();
            if (iprogressupdate != null) {
                iprogressupdate.c(IChatBaseComponent.c("menu.savingChunks"));
            }
            chunkproviderserver.a(flag);
            if (flag) {
                this.N.c();
            } else {
                this.N.b();
            }
        }
        WorldServer worldserver1 = this;
        this.K.a(worldserver1.C_().t());
        this.K.a(this.J.aN().a(this.H_()));
        this.convertable.a(this.J.bc(), this.K, this.J.ah().r());
    }

    private void av() {
        if (this.ab != null) {
            this.K.a(this.ab.b());
        }
        this.l().k().a();
    }

    public <T extends Entity> List<? extends T> a(EntityTypeTest<Entity, T> entitytypetest, Predicate<? super T> predicate) {
        ArrayList list = Lists.newArrayList();
        this.a(entitytypetest, predicate, list);
        return list;
    }

    public <T extends Entity> void a(EntityTypeTest<Entity, T> entitytypetest, Predicate<? super T> predicate, List<? super T> list) {
        this.a(entitytypetest, predicate, list, Integer.MAX_VALUE);
    }

    public <T extends Entity> void a(EntityTypeTest<Entity, T> entitytypetest, Predicate<? super T> predicate, List<? super T> list, int i2) {
        this.G().a(entitytypetest, (U entity) -> {
            if (predicate.test(entity)) {
                list.add((Object)entity);
                if (list.size() >= i2) {
                    return AbortableIterationConsumer.a.b;
                }
            }
            return AbortableIterationConsumer.a.a;
        });
    }

    public List<? extends EntityEnderDragon> i() {
        return this.a(EntityTypes.F, EntityLiving::bE);
    }

    public List<EntityPlayer> a(Predicate<? super EntityPlayer> predicate) {
        return this.a(predicate, Integer.MAX_VALUE);
    }

    public List<EntityPlayer> a(Predicate<? super EntityPlayer> predicate, int i2) {
        ArrayList list = Lists.newArrayList();
        for (EntityPlayer entityplayer : this.H) {
            if (!predicate.test(entityplayer)) continue;
            list.add(entityplayer);
            if (list.size() < i2) continue;
            return list;
        }
        return list;
    }

    @Nullable
    public EntityPlayer j() {
        List<EntityPlayer> list = this.a(EntityLiving::bE);
        return list.isEmpty() ? null : list.get(this.z.a(list.size()));
    }

    @Override
    public boolean b(Entity entity) {
        return this.addFreshEntity(entity, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    @Override
    public boolean addFreshEntity(Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        return this.addEntity(entity, reason);
    }

    public boolean c(Entity entity) {
        return this.addWithUUID(entity, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    public boolean addWithUUID(Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        return this.addEntity(entity, reason);
    }

    public void d(Entity entity) {
        this.addDuringTeleport(entity, null);
    }

    public void addDuringTeleport(Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entity;
            this.c(entityplayer);
        } else {
            this.addEntity(entity, reason);
        }
    }

    public void a(EntityPlayer entityplayer) {
        this.c(entityplayer);
    }

    public void b(EntityPlayer entityplayer) {
        this.c(entityplayer);
    }

    private void c(EntityPlayer entityplayer) {
        Entity entity = this.G().a(entityplayer.cz());
        if (entity != null) {
            E.warn("Force-added player with duplicate UUID {}", (Object)entityplayer.cz());
            entity.ak();
            this.a((EntityPlayer)entity, Entity.RemovalReason.b);
        }
        this.N.a(entityplayer);
    }

    private boolean addEntity(Entity entity, CreatureSpawnEvent.SpawnReason spawnReason) {
        AsyncCatcher.catchOp("entity add");
        if (entity.dJ()) {
            return false;
        }
        if (spawnReason != null && !CraftEventFactory.doEntityAddEventCalling(this, entity, spawnReason)) {
            return false;
        }
        return this.N.a(entity);
    }

    public boolean e(Entity entity) {
        return this.tryAddFreshEntityWithPassengers(entity, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    public boolean tryAddFreshEntityWithPassengers(Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        Stream<UUID> stream = entity.cU().map(Entity::cz);
        PersistentEntitySectionManager<Entity> persistententitysectionmanager = this.N;
        Objects.requireNonNull(this.N);
        if (stream.anyMatch(persistententitysectionmanager::a)) {
            return false;
        }
        this.addFreshEntityWithPassengers(entity, reason);
        return true;
    }

    public void a(Chunk chunk) {
        for (TileEntity tileentity : chunk.G().values()) {
            if (!(tileentity instanceof IInventory)) continue;
            for (HumanEntity h2 : Lists.newArrayList(((IInventory)((Object)tileentity)).getViewers())) {
                h2.closeInventory();
            }
        }
        chunk.I();
        chunk.b(this);
    }

    public void a(EntityPlayer entityplayer, Entity.RemovalReason entity_removalreason) {
        entityplayer.remove(entity_removalreason, null);
    }

    public boolean strikeLightning(Entity entitylightning) {
        return this.strikeLightning(entitylightning, LightningStrikeEvent.Cause.UNKNOWN);
    }

    public boolean strikeLightning(Entity entitylightning, LightningStrikeEvent.Cause cause) {
        LightningStrikeEvent lightning = CraftEventFactory.callLightningStrikeEvent((LightningStrike)entitylightning.getBukkitEntity(), cause);
        if (lightning.isCancelled()) {
            return false;
        }
        return this.b(entitylightning);
    }

    @Override
    public void a(int i2, BlockPosition blockposition, int j2) {
        Iterator<EntityPlayer> iterator = this.J.ah().t().iterator();
        EntityHuman entityhuman = null;
        Entity entity = this.a(i2);
        if (entity instanceof EntityHuman) {
            entityhuman = (EntityHuman)entity;
        }
        while (iterator.hasNext()) {
            EntityPlayer entityplayer = iterator.next();
            if (entityplayer == null || entityplayer.dO() != this || entityplayer.an() == i2) continue;
            double d0 = (double)blockposition.u() - entityplayer.dt();
            double d1 = (double)blockposition.v() - entityplayer.dv();
            double d2 = (double)blockposition.w() - entityplayer.dz();
            if (entityhuman != null && !entityplayer.getBukkitEntity().canSee(entityhuman.getBukkitEntity()) || !(d0 * d0 + d1 * d1 + d2 * d2 < 1024.0)) continue;
            entityplayer.c.b(new PacketPlayOutBlockBreakAnimation(i2, blockposition, j2));
        }
    }

    @Override
    public void a(@Nullable EntityHuman entityhuman, double d0, double d1, double d2, Holder<SoundEffect> holder, SoundCategory soundcategory, float f2, float f1, long i2) {
        this.J.ah().a(entityhuman, d0, d1, d2, holder.a().a(f2), this.af(), new PacketPlayOutNamedSoundEffect(holder, soundcategory, d0, d1, d2, f2, f1, i2));
    }

    @Override
    public void a(@Nullable EntityHuman entityhuman, Entity entity, Holder<SoundEffect> holder, SoundCategory soundcategory, float f2, float f1, long i2) {
        this.J.ah().a(entityhuman, entity.dt(), entity.dv(), entity.dz(), holder.a().a(f2), this.af(), new PacketPlayOutEntitySound(holder, soundcategory, entity, f2, f1, i2));
    }

    @Override
    public void b(int i2, BlockPosition blockposition, int j2) {
        if (this.ab().b(GameRules.W)) {
            this.J.ah().a(new PacketPlayOutWorldEvent(i2, blockposition, j2, true));
        } else {
            this.a((EntityHuman)null, i2, blockposition, j2);
        }
    }

    @Override
    public void a(@Nullable EntityHuman entityhuman, int i2, BlockPosition blockposition, int j2) {
        this.J.ah().a(entityhuman, blockposition.u(), blockposition.v(), blockposition.w(), 64.0, this.af(), new PacketPlayOutWorldEvent(i2, blockposition, j2, false));
    }

    public int k() {
        return this.D_().p();
    }

    @Override
    public void a(Holder<GameEvent> holder, Vec3D vec3d, GameEvent.a gameevent_a) {
        this.O.a(holder, vec3d, gameevent_a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void a(BlockPosition blockposition, IBlockData iblockdata, IBlockData iblockdata1, int i2) {
        if (this.W) {
            String s2 = "recursive call to sendBlockUpdated";
            SystemUtils.a("recursive call to sendBlockUpdated", (Throwable)new IllegalStateException("recursive call to sendBlockUpdated"));
        }
        this.l().a(blockposition);
        this.U.a(blockposition);
        VoxelShape voxelshape = iblockdata.k(this, blockposition);
        VoxelShape voxelshape1 = iblockdata1.k(this, blockposition);
        if (VoxelShapes.c(voxelshape, voxelshape1, OperatorBoolean.g)) {
            ObjectArrayList list = new ObjectArrayList();
            Iterator<EntityInsentient> iterator = this.V.iterator();
            while (iterator.hasNext()) {
                EntityInsentient entityinsentient;
                try {
                    entityinsentient = iterator.next();
                }
                catch (ConcurrentModificationException ex) {
                    this.a(blockposition, iblockdata, iblockdata1, i2);
                    return;
                }
                NavigationAbstract navigationabstract = entityinsentient.N();
                if (!navigationabstract.b(blockposition)) continue;
                list.add(navigationabstract);
            }
            try {
                this.W = true;
                for (NavigationAbstract navigationabstract1 : list) {
                    navigationabstract1.i();
                }
            }
            finally {
                this.W = false;
            }
        }
    }

    @Override
    public void a(BlockPosition blockposition, Block block) {
        this.s.a(blockposition, block, (EnumDirection)null);
    }

    @Override
    public void a(BlockPosition blockposition, Block block, EnumDirection enumdirection) {
        this.s.a(blockposition, block, enumdirection);
    }

    @Override
    public void a(BlockPosition blockposition, Block block, BlockPosition blockposition1) {
        this.s.a(blockposition, block, blockposition1);
    }

    @Override
    public void a(IBlockData iblockdata, BlockPosition blockposition, Block block, BlockPosition blockposition1, boolean flag) {
        this.s.a(iblockdata, blockposition, block, blockposition1, flag);
    }

    @Override
    public void a(Entity entity, byte b0) {
        this.l().a(entity, new PacketPlayOutEntityStatus(entity, b0));
    }

    @Override
    public void a(Entity entity, DamageSource damagesource) {
        this.l().a(entity, new ClientboundDamageEventPacket(entity, damagesource));
    }

    public ChunkProviderServer l() {
        return this.I;
    }

    @Override
    public Explosion a(@Nullable Entity entity, @Nullable DamageSource damagesource, @Nullable ExplosionDamageCalculator explosiondamagecalculator, double d0, double d1, double d2, float f2, boolean flag, World.a world_a, ParticleParam particleparam, ParticleParam particleparam1, Holder<SoundEffect> holder) {
        Explosion explosion = this.a(entity, damagesource, explosiondamagecalculator, d0, d1, d2, f2, flag, world_a, false, particleparam, particleparam1, holder);
        if (explosion.wasCanceled) {
            return explosion;
        }
        if (!explosion.d()) {
            explosion.h();
        }
        for (EntityPlayer entityplayer : this.H) {
            if (!(entityplayer.i(d0, d1, d2) < 4096.0)) continue;
            entityplayer.c.b(new PacketPlayOutExplosion(d0, d1, d2, f2, explosion.i(), explosion.e().get(entityplayer), explosion.j(), explosion.k(), explosion.l(), explosion.m()));
        }
        return explosion;
    }

    @Override
    public void a(BlockPosition blockposition, Block block, int i2, int j2) {
        this.X.add((Object)new BlockActionData(blockposition, block, i2, j2));
    }

    private void aw() {
        this.Y.clear();
        while (!this.X.isEmpty()) {
            BlockActionData blockactiondata = (BlockActionData)this.X.removeFirst();
            if (this.n(blockactiondata.a())) {
                if (!this.a(blockactiondata)) continue;
                this.J.ah().a(null, blockactiondata.a().u(), blockactiondata.a().v(), blockactiondata.a().w(), 64.0, this.af(), new PacketPlayOutBlockAction(blockactiondata.a(), blockactiondata.b(), blockactiondata.c(), blockactiondata.d()));
                continue;
            }
            this.Y.add(blockactiondata);
        }
        this.X.addAll(this.Y);
    }

    private boolean a(BlockActionData blockactiondata) {
        IBlockData iblockdata = this.a_(blockactiondata.a());
        return iblockdata.a(blockactiondata.b()) ? iblockdata.a((net.minecraft.world.level.World)this, blockactiondata.a(), blockactiondata.c(), blockactiondata.d()) : false;
    }

    public TickListServer<Block> m() {
        return this.S;
    }

    public TickListServer<FluidType> n() {
        return this.T;
    }

    @Override
    @Nonnull
    public MinecraftServer o() {
        return this.J;
    }

    public PortalTravelAgent p() {
        return this.R;
    }

    public StructureTemplateManager q() {
        return this.J.ba();
    }

    public <T extends ParticleParam> int a(T t0, double d0, double d1, double d2, int i2, double d3, double d4, double d5, double d6) {
        return this.sendParticles(null, t0, d0, d1, d2, i2, d3, d4, d5, d6, false);
    }

    public <T extends ParticleParam> int sendParticles(EntityPlayer sender, T t0, double d0, double d1, double d2, int i2, double d3, double d4, double d5, double d6, boolean force) {
        PacketPlayOutWorldParticles packetplayoutworldparticles = new PacketPlayOutWorldParticles(t0, force, d0, d1, d2, (float)d3, (float)d4, (float)d5, (float)d6, i2);
        int j2 = 0;
        for (int k2 = 0; k2 < this.H.size(); ++k2) {
            EntityPlayer entityplayer = this.H.get(k2);
            if (sender != null && !entityplayer.getBukkitEntity().canSee(sender.getBukkitEntity()) || !this.a(entityplayer, force, d0, d1, d2, packetplayoutworldparticles)) continue;
            ++j2;
        }
        return j2;
    }

    public <T extends ParticleParam> boolean a(EntityPlayer entityplayer, T t0, boolean flag, double d0, double d1, double d2, int i2, double d3, double d4, double d5, double d6) {
        PacketPlayOutWorldParticles packet = new PacketPlayOutWorldParticles(t0, flag, d0, d1, d2, (float)d3, (float)d4, (float)d5, (float)d6, i2);
        return this.a(entityplayer, flag, d0, d1, d2, packet);
    }

    private boolean a(EntityPlayer entityplayer, boolean flag, double d0, double d1, double d2, Packet<?> packet) {
        if (entityplayer.dO() != this) {
            return false;
        }
        BlockPosition blockposition = entityplayer.do();
        if (blockposition.a(new Vec3D(d0, d1, d2), flag ? 512.0 : 32.0)) {
            entityplayer.c.b(packet);
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public Entity a(int i2) {
        return this.G().a(i2);
    }

    @Deprecated
    @Nullable
    public Entity b(int i2) {
        Entity entity = this.G().a(i2);
        return entity != null ? entity : (Entity)this.ac.get(i2);
    }

    @Nullable
    public Entity a(UUID uuid) {
        return this.G().a(uuid);
    }

    @Nullable
    public BlockPosition a(TagKey<Structure> tagkey, BlockPosition blockposition, int i2, boolean flag) {
        if (!this.K.y().c()) {
            return null;
        }
        Optional<HolderSet.Named<Structure>> optional = this.H_().d(Registries.aR).b(tagkey);
        if (optional.isEmpty()) {
            return null;
        }
        Pair<BlockPosition, Holder<Structure>> pair = this.l().g().a(this, (HolderSet<Structure>)optional.get(), blockposition, i2, flag);
        return pair != null ? (BlockPosition)pair.getFirst() : null;
    }

    @Nullable
    public Pair<BlockPosition, Holder<BiomeBase>> a(Predicate<Holder<BiomeBase>> predicate, BlockPosition blockposition, int i2, int j2, int k2) {
        return this.l().g().d().a(blockposition, i2, j2, k2, predicate, this.l().i().b(), this);
    }

    @Override
    public CraftingManager r() {
        return this.J.aJ();
    }

    @Override
    public TickRateManager s() {
        return this.J.aQ();
    }

    @Override
    public boolean t() {
        return this.e;
    }

    public WorldPersistentData u() {
        return this.l().k();
    }

    @Override
    @Nullable
    public WorldMap a(MapId mapid) {
        WorldMap worldmap = this.o().I().u().b(WorldMap.a(), mapid.a());
        if (worldmap != null) {
            worldmap.id = mapid;
        }
        return worldmap;
    }

    @Override
    public void a(MapId mapid, WorldMap worldmap) {
        worldmap.id = mapid;
        MapInitializeEvent event = new MapInitializeEvent((MapView)worldmap.mapView);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        this.o().I().u().a(mapid.a(), worldmap);
    }

    @Override
    public MapId v() {
        return this.o().I().u().a(PersistentIdCounts.a(), "idcounts").b();
    }

    public void a(BlockPosition blockposition, float f2) {
        int i2;
        BlockPosition blockposition1 = this.A.a();
        float f1 = this.A.b();
        if (!blockposition1.equals(blockposition) || f1 != f2) {
            this.A.a(blockposition, f2);
            this.o().ah().a(new PacketPlayOutSpawnPosition(blockposition, f2));
        }
        if (this.L > 1) {
            this.l().b(TicketType.a, new ChunkCoordIntPair(blockposition1), this.L, Unit.a);
        }
        if ((i2 = this.ab().c(GameRules.Z) + 1) > 1) {
            this.l().a(TicketType.a, new ChunkCoordIntPair(blockposition), i2, Unit.a);
        }
        this.L = i2;
    }

    public LongSet w() {
        ForcedChunk forcedchunk = this.u().b(ForcedChunk.a(), "chunks");
        return forcedchunk != null ? LongSets.unmodifiable((LongSet)forcedchunk.b()) : LongSets.EMPTY_SET;
    }

    public boolean a(int i2, int j2, boolean flag) {
        boolean flag1;
        ForcedChunk forcedchunk = this.u().a(ForcedChunk.a(), "chunks");
        ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(i2, j2);
        long k2 = chunkcoordintpair.a();
        if (flag) {
            flag1 = forcedchunk.b().add(k2);
            if (flag1) {
                this.d(i2, j2);
            }
        } else {
            flag1 = forcedchunk.b().remove(k2);
        }
        forcedchunk.a(flag1);
        if (flag1) {
            this.l().a(chunkcoordintpair, flag);
        }
        return flag1;
    }

    public List<EntityPlayer> x() {
        return this.H;
    }

    @Override
    public void a(BlockPosition blockposition, IBlockData iblockdata, IBlockData iblockdata1) {
        Optional<Holder<VillagePlaceType>> optional1;
        Optional<Holder<VillagePlaceType>> optional = PoiTypes.a(iblockdata);
        if (!Objects.equals(optional, optional1 = PoiTypes.a(iblockdata1))) {
            BlockPosition blockposition1 = blockposition.j();
            optional.ifPresent(holder -> this.o().execute(() -> {
                this.y().a(blockposition1);
                PacketDebug.b(this, blockposition1);
            }));
            optional1.ifPresent(holder -> this.o().execute(() -> {
                this.y().a(blockposition1, (Holder<VillagePlaceType>)holder);
                PacketDebug.a(this, blockposition1);
            }));
        }
    }

    public VillagePlace y() {
        return this.l().l();
    }

    public boolean c(BlockPosition blockposition) {
        return this.a(blockposition, 1);
    }

    public boolean a(SectionPosition sectionposition) {
        return this.c(sectionposition.k());
    }

    public boolean a(BlockPosition blockposition, int i2) {
        return i2 > 6 ? false : this.b(SectionPosition.a(blockposition)) <= i2;
    }

    public int b(SectionPosition sectionposition) {
        return this.y().a(sectionposition);
    }

    public PersistentRaid z() {
        return this.f;
    }

    @Nullable
    public Raid d(BlockPosition blockposition) {
        return this.f.a(blockposition, 9216);
    }

    public boolean e(BlockPosition blockposition) {
        return this.d(blockposition) != null;
    }

    public void a(ReputationEvent reputationevent, Entity entity, ReputationHandler reputationhandler) {
        reputationhandler.a(reputationevent, entity);
    }

    public void a(Path path) throws IOException {
        PlayerChunkMap playerchunkmap = this.l().a;
        try (BufferedWriter bufferedwriter = Files.newBufferedWriter(path.resolve("stats.txt"), new OpenOption[0]);){
            bufferedwriter.write(String.format(Locale.ROOT, "spawning_chunks: %d\n", playerchunkmap.j().b()));
            SpawnerCreature.d spawnercreature_d = this.l().n();
            if (spawnercreature_d != null) {
                for (Object2IntMap.Entry entry : spawnercreature_d.b().object2IntEntrySet()) {
                    bufferedwriter.write(String.format(Locale.ROOT, "spawn_count.%s: %d\n", ((EnumCreatureType)entry.getKey()).a(), entry.getIntValue()));
                }
            }
            bufferedwriter.write(String.format(Locale.ROOT, "entities: %s\n", this.N.e()));
            bufferedwriter.write(String.format(Locale.ROOT, "block_entity_tickers: %d\n", this.r.size()));
            bufferedwriter.write(String.format(Locale.ROOT, "block_ticks: %d\n", this.m().a()));
            bufferedwriter.write(String.format(Locale.ROOT, "fluid_ticks: %d\n", this.n().a()));
            bufferedwriter.write("distance_manager: " + playerchunkmap.j().c() + "\n");
            bufferedwriter.write(String.format(Locale.ROOT, "pending_tasks: %d\n", this.l().f()));
        }
        CrashReport crashreport = new CrashReport("Level dump", new Exception("dummy"));
        this.a(crashreport);
        try (BufferedWriter bufferedwriter1 = Files.newBufferedWriter(path.resolve("example_crash.txt"), new OpenOption[0]);){
            bufferedwriter1.write(crashreport.a(ReportType.c));
        }
        Path path1 = path.resolve("chunks.csv");
        try (BufferedWriter bufferedwriter2 = Files.newBufferedWriter(path1, new OpenOption[0]);){
            playerchunkmap.a(bufferedwriter2);
        }
        Path path2 = path.resolve("entity_chunks.csv");
        try (BufferedWriter bufferedwriter3 = Files.newBufferedWriter(path2, new OpenOption[0]);){
            this.N.a(bufferedwriter3);
        }
        Path path3 = path.resolve("entities.csv");
        try (BufferedWriter bufferedwriter4 = Files.newBufferedWriter(path3, new OpenOption[0]);){
            WorldServer.a(bufferedwriter4, this.G().a());
        }
        Path path4 = path.resolve("block_entities.csv");
        try (BufferedWriter bufferedwriter5 = Files.newBufferedWriter(path4, new OpenOption[0]);){
            this.a(bufferedwriter5);
        }
    }

    private static void a(Writer writer, Iterable<Entity> iterable) throws IOException {
        CSVWriter csvwriter = CSVWriter.a().a("x").a("y").a("z").a("uuid").a("type").a("alive").a("display_name").a("custom_name").a(writer);
        for (Entity entity : iterable) {
            IChatBaseComponent ichatbasecomponent = entity.aj();
            IChatBaseComponent ichatbasecomponent1 = entity.S_();
            csvwriter.a(entity.dt(), entity.dv(), entity.dz(), entity.cz(), BuiltInRegistries.f.b(entity.am()), entity.bE(), ichatbasecomponent1.getString(), ichatbasecomponent != null ? ichatbasecomponent.getString() : null);
        }
    }

    private void a(Writer writer) throws IOException {
        CSVWriter csvwriter = CSVWriter.a().a("x").a("y").a("z").a("type").a(writer);
        for (TickingBlockEntity tickingblockentity : this.r) {
            BlockPosition blockposition = tickingblockentity.c();
            csvwriter.a(blockposition.u(), blockposition.v(), blockposition.w(), tickingblockentity.d());
        }
    }

    @VisibleForTesting
    public void a(StructureBoundingBox structureboundingbox) {
        this.X.removeIf(blockactiondata -> structureboundingbox.b(blockactiondata.a()));
    }

    @Override
    public void b(BlockPosition blockposition, Block block) {
        if (!this.ai()) {
            if (this.populating) {
                return;
            }
            this.a(blockposition, block);
        }
    }

    @Override
    public float a(EnumDirection enumdirection, boolean flag) {
        return 1.0f;
    }

    public Iterable<Entity> A() {
        return this.G().a();
    }

    public String toString() {
        return "ServerLevel[" + this.K.e() + "]";
    }

    public boolean B() {
        return this.K.z();
    }

    @Override
    public long C() {
        return this.K.y().b();
    }

    @Nullable
    public EnderDragonBattle D() {
        return this.ab;
    }

    @Override
    public WorldServer E() {
        return this;
    }

    @VisibleForTesting
    public String F() {
        return String.format(Locale.ROOT, "players: %s, entities: %s [%s], block_entities: %d [%s], block_ticks: %d, fluid_ticks: %d, chunk_source: %s", this.H.size(), this.N.e(), WorldServer.a(this.N.d().a(), (T entity) -> BuiltInRegistries.f.b(entity.am()).toString()), this.r.size(), WorldServer.a(this.r, TickingBlockEntity::d), this.m().a(), this.n().a(), this.I());
    }

    private static <T> String a(Iterable<T> iterable, Function<T, String> function) {
        try {
            Object2IntOpenHashMap object2intopenhashmap = new Object2IntOpenHashMap();
            for (T t0 : iterable) {
                String s2 = function.apply(t0);
                object2intopenhashmap.addTo((Object)s2, 1);
            }
            return object2intopenhashmap.object2IntEntrySet().stream().sorted(Comparator.comparing(Object2IntMap.Entry::getIntValue).reversed()).limit(5L).map(entry -> {
                String s1 = (String)entry.getKey();
                return s1 + ":" + entry.getIntValue();
            }).collect(Collectors.joining(","));
        }
        catch (Exception exception) {
            return "";
        }
    }

    @Override
    public LevelEntityGetter<Entity> G() {
        AsyncCatcher.catchOp("Chunk getEntities call");
        return this.N.d();
    }

    public void a(Stream<Entity> stream) {
        this.N.a(stream);
    }

    public void b(Stream<Entity> stream) {
        this.N.b(stream);
    }

    public void b(Chunk chunk) {
        chunk.c(this.A_().c());
    }

    public void a(IChunkAccess ichunkaccess) {
        this.J.execute(() -> this.ae.a(ichunkaccess.f(), ichunkaccess.g()));
    }

    public PathTypeCache H() {
        return this.U;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.N.close();
    }

    @Override
    public String I() {
        String s2 = this.I.e();
        return "Chunks[S] W: " + s2 + " E: " + this.N.e();
    }

    public boolean c(long i2) {
        return this.N.a(i2);
    }

    private boolean d(long i2) {
        return this.c(i2) && this.I.a(i2);
    }

    public boolean f(BlockPosition blockposition) {
        return this.N.a(blockposition) && this.I.a.j().c(ChunkCoordIntPair.a(blockposition));
    }

    public boolean g(BlockPosition blockposition) {
        return this.N.a(blockposition);
    }

    public boolean a(ChunkCoordIntPair chunkcoordintpair) {
        return this.N.a(chunkcoordintpair);
    }

    @Override
    public FeatureFlagSet J() {
        return this.J.bb().K();
    }

    @Override
    public PotionBrewer K() {
        return this.J.bp();
    }

    public RandomSource a(MinecraftKey minecraftkey) {
        return this.ag.a(minecraftkey);
    }

    public RandomSequences L() {
        return this.ag;
    }

    @Override
    public CrashReportSystemDetails a(CrashReport crashreport) {
        CrashReportSystemDetails crashreportsystemdetails = super.a(crashreport);
        crashreportsystemdetails.a("Loaded entity count", () -> String.valueOf(this.N.f()));
        return crashreportsystemdetails;
    }

    private final class a
    implements LevelCallback<Entity> {
        a() {
        }

        @Override
        public void a(Entity entity) {
        }

        @Override
        public void b(Entity entity) {
            WorldServer.this.f().a(entity);
        }

        @Override
        public void c(Entity entity) {
            WorldServer.this.M.a(entity);
        }

        @Override
        public void d(Entity entity) {
            WorldServer.this.M.b(entity);
        }

        @Override
        public void e(Entity entity) {
            AsyncCatcher.catchOp("entity register");
            WorldServer.this.l().b(entity);
            if (entity instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)entity;
                WorldServer.this.H.add(entityplayer);
                WorldServer.this.e();
            }
            if (entity instanceof EntityInsentient) {
                EntityInsentient entityinsentient = (EntityInsentient)entity;
                if (WorldServer.this.W) {
                    String s2 = "onTrackingStart called during navigation iteration";
                    SystemUtils.a("onTrackingStart called during navigation iteration", (Throwable)new IllegalStateException("onTrackingStart called during navigation iteration"));
                }
                WorldServer.this.V.add(entityinsentient);
            }
            if (entity instanceof EntityEnderDragon) {
                EntityEnderDragon entityenderdragon = (EntityEnderDragon)entity;
                for (EntityComplexPart entitycomplexpart : entityenderdragon.gg()) {
                    WorldServer.this.ac.put(entitycomplexpart.an(), (Object)entitycomplexpart);
                }
            }
            entity.a(DynamicGameEventListener::a);
            entity.inWorld = true;
            entity.valid = true;
        }

        @Override
        public void f(Entity entity) {
            AsyncCatcher.catchOp("entity unregister");
            if (entity instanceof EntityHuman) {
                Streams.stream(WorldServer.this.o().K()).map(WorldServer::u).forEach(worldData -> {
                    for (PersistentBase o2 : worldData.b.values()) {
                        if (!(o2 instanceof WorldMap)) continue;
                        WorldMap map = (WorldMap)o2;
                        map.p.remove((EntityHuman)entity);
                        Iterator<WorldMap.WorldMapHumanTracker> iter = map.o.iterator();
                        while (iter.hasNext()) {
                            if (iter.next().a != entity) continue;
                            iter.remove();
                        }
                    }
                });
            }
            if (entity.getBukkitEntity() instanceof InventoryHolder && (!(entity instanceof EntityPlayer) || entity.dK() != Entity.RemovalReason.a)) {
                for (HumanEntity h2 : Lists.newArrayList((Iterable)((InventoryHolder)entity.getBukkitEntity()).getInventory().getViewers())) {
                    h2.closeInventory();
                }
            }
            WorldServer.this.l().a(entity);
            if (entity instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)entity;
                WorldServer.this.H.remove(entityplayer);
                WorldServer.this.e();
            }
            if (entity instanceof EntityInsentient) {
                EntityInsentient entityinsentient = (EntityInsentient)entity;
                if (WorldServer.this.W) {
                    String s2 = "onTrackingStart called during navigation iteration";
                    SystemUtils.a("onTrackingStart called during navigation iteration", (Throwable)new IllegalStateException("onTrackingStart called during navigation iteration"));
                }
                WorldServer.this.V.remove(entityinsentient);
            }
            if (entity instanceof EntityEnderDragon) {
                EntityEnderDragon entityenderdragon = (EntityEnderDragon)entity;
                for (EntityComplexPart entitycomplexpart : entityenderdragon.gg()) {
                    WorldServer.this.ac.remove(entitycomplexpart.an());
                }
            }
            entity.a(DynamicGameEventListener::b);
            entity.valid = false;
            if (!(entity instanceof EntityPlayer)) {
                for (EntityPlayer player : WorldServer.this.H) {
                    player.getBukkitEntity().onEntityRemove(entity);
                }
            }
        }

        @Override
        public void g(Entity entity) {
            entity.a(DynamicGameEventListener::c);
        }
    }
}

