/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.google.common.collect.Lists;
import com.google.common.primitives.Floats;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.CommandSigningContext;
import net.minecraft.commands.arguments.ArgumentSignatures;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.DisconnectionDetails;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.TickablePacketListener;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.LastSeenMessages;
import net.minecraft.network.chat.LastSeenMessagesValidator;
import net.minecraft.network.chat.MessageSignature;
import net.minecraft.network.chat.MessageSignatureCache;
import net.minecraft.network.chat.OutgoingChatMessage;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.network.chat.RemoteChatSession;
import net.minecraft.network.chat.SignableCommand;
import net.minecraft.network.chat.SignedMessageBody;
import net.minecraft.network.chat.SignedMessageChain;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PlayerConnectionUtils;
import net.minecraft.network.protocol.common.ServerboundClientInformationPacket;
import net.minecraft.network.protocol.configuration.ConfigurationProtocols;
import net.minecraft.network.protocol.game.ClientboundBlockChangedAckPacket;
import net.minecraft.network.protocol.game.ClientboundDisguisedChatPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerChatPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundStartConfigurationPacket;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.network.protocol.game.PacketListenerPlayIn;
import net.minecraft.network.protocol.game.PacketPlayInAbilities;
import net.minecraft.network.protocol.game.PacketPlayInAdvancements;
import net.minecraft.network.protocol.game.PacketPlayInArmAnimation;
import net.minecraft.network.protocol.game.PacketPlayInAutoRecipe;
import net.minecraft.network.protocol.game.PacketPlayInBEdit;
import net.minecraft.network.protocol.game.PacketPlayInBeacon;
import net.minecraft.network.protocol.game.PacketPlayInBlockDig;
import net.minecraft.network.protocol.game.PacketPlayInBlockPlace;
import net.minecraft.network.protocol.game.PacketPlayInBoatMove;
import net.minecraft.network.protocol.game.PacketPlayInChat;
import net.minecraft.network.protocol.game.PacketPlayInClientCommand;
import net.minecraft.network.protocol.game.PacketPlayInCloseWindow;
import net.minecraft.network.protocol.game.PacketPlayInDifficultyChange;
import net.minecraft.network.protocol.game.PacketPlayInDifficultyLock;
import net.minecraft.network.protocol.game.PacketPlayInEnchantItem;
import net.minecraft.network.protocol.game.PacketPlayInEntityAction;
import net.minecraft.network.protocol.game.PacketPlayInEntityNBTQuery;
import net.minecraft.network.protocol.game.PacketPlayInFlying;
import net.minecraft.network.protocol.game.PacketPlayInHeldItemSlot;
import net.minecraft.network.protocol.game.PacketPlayInItemName;
import net.minecraft.network.protocol.game.PacketPlayInJigsawGenerate;
import net.minecraft.network.protocol.game.PacketPlayInPickItem;
import net.minecraft.network.protocol.game.PacketPlayInRecipeDisplayed;
import net.minecraft.network.protocol.game.PacketPlayInRecipeSettings;
import net.minecraft.network.protocol.game.PacketPlayInSetCommandBlock;
import net.minecraft.network.protocol.game.PacketPlayInSetCommandMinecart;
import net.minecraft.network.protocol.game.PacketPlayInSetCreativeSlot;
import net.minecraft.network.protocol.game.PacketPlayInSetJigsaw;
import net.minecraft.network.protocol.game.PacketPlayInSpectate;
import net.minecraft.network.protocol.game.PacketPlayInSteerVehicle;
import net.minecraft.network.protocol.game.PacketPlayInStruct;
import net.minecraft.network.protocol.game.PacketPlayInTabComplete;
import net.minecraft.network.protocol.game.PacketPlayInTeleportAccept;
import net.minecraft.network.protocol.game.PacketPlayInTileNBTQuery;
import net.minecraft.network.protocol.game.PacketPlayInTrSel;
import net.minecraft.network.protocol.game.PacketPlayInUpdateSign;
import net.minecraft.network.protocol.game.PacketPlayInUseEntity;
import net.minecraft.network.protocol.game.PacketPlayInUseItem;
import net.minecraft.network.protocol.game.PacketPlayInVehicleMove;
import net.minecraft.network.protocol.game.PacketPlayInWindowClick;
import net.minecraft.network.protocol.game.PacketPlayOutAttachEntity;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutHeldItemSlot;
import net.minecraft.network.protocol.game.PacketPlayOutNBTQuery;
import net.minecraft.network.protocol.game.PacketPlayOutPosition;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.network.protocol.game.PacketPlayOutTabComplete;
import net.minecraft.network.protocol.game.PacketPlayOutVehicleMove;
import net.minecraft.network.protocol.game.ServerboundChatAckPacket;
import net.minecraft.network.protocol.game.ServerboundChatCommandPacket;
import net.minecraft.network.protocol.game.ServerboundChatCommandSignedPacket;
import net.minecraft.network.protocol.game.ServerboundChatSessionUpdatePacket;
import net.minecraft.network.protocol.game.ServerboundChunkBatchReceivedPacket;
import net.minecraft.network.protocol.game.ServerboundConfigurationAcknowledgedPacket;
import net.minecraft.network.protocol.game.ServerboundContainerSlotStateChangedPacket;
import net.minecraft.network.protocol.game.ServerboundDebugSampleSubscriptionPacket;
import net.minecraft.network.protocol.ping.ClientboundPongResponsePacket;
import net.minecraft.network.protocol.ping.ServerboundPingRequestPacket;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.network.Filterable;
import net.minecraft.server.network.FilteredText;
import net.minecraft.server.network.ITextFilter;
import net.minecraft.server.network.PlayerChunkSender;
import net.minecraft.server.network.ServerCommonPacketListenerImpl;
import net.minecraft.server.network.ServerConfigurationPacketListenerImpl;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.stats.RecipeBookServer;
import net.minecraft.util.FutureChain;
import net.minecraft.util.MathHelper;
import net.minecraft.util.SignatureValidator;
import net.minecraft.util.UtilColor;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventory;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.IJumpable;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.EnumChatVisibility;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.entity.player.ProfilePublicKey;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerAnvil;
import net.minecraft.world.inventory.ContainerBeacon;
import net.minecraft.world.inventory.ContainerMerchant;
import net.minecraft.world.inventory.ContainerRecipeBook;
import net.minecraft.world.inventory.CrafterMenu;
import net.minecraft.world.inventory.InventoryClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemBucket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.WritableBookContent;
import net.minecraft.world.item.component.WrittenBookContent;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.CommandBlockListenerAbstract;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.block.BlockCommand;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.CrafterBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityCommand;
import net.minecraft.world.level.block.entity.TileEntityJigsaw;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.entity.TileEntityStructure;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandException;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_21_R1.SpigotTimings;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventoryView;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemType;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftNamespacedKey;
import org.bukkit.craftbukkit.v1_21_R1.util.LazyPlayerSet;
import org.bukkit.craftbukkit.v1_21_R1.util.Waitable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCreativeEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.inventory.SmithItemEvent;
import org.bukkit.event.inventory.TradeSelectEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerAnimationEvent;
import org.bukkit.event.player.PlayerAnimationType;
import org.bukkit.event.player.PlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerRecipeBookClickEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerToggleFlightEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.event.player.PlayerToggleSprintEvent;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.SmithingInventory;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class PlayerConnection
extends ServerCommonPacketListenerImpl
implements PacketListenerPlayIn,
ServerPlayerConnection,
TickablePacketListener {
    static final Logger h = LogUtils.getLogger();
    private static final int i = -1;
    private static final int j = 4096;
    private static final int k = 80;
    private static final IChatBaseComponent l = IChatBaseComponent.c("multiplayer.disconnect.chat_validation_failed");
    private static final IChatBaseComponent m = IChatBaseComponent.c("chat.disabled.invalid_command_signature").a(EnumChatFormat.m);
    private static final int n = 1000;
    public EntityPlayer f;
    public final PlayerChunkSender g;
    private int o;
    private int p = -1;
    private final AtomicInteger q = new AtomicInteger();
    private int r;
    private double s;
    private double t;
    private double u;
    private double v;
    private double w;
    private double x;
    @Nullable
    private net.minecraft.world.entity.Entity y;
    private double z;
    private double A;
    private double B;
    private double C;
    private double D;
    private double E;
    @Nullable
    private Vec3D F;
    private int G;
    private int H;
    private boolean I;
    private int J;
    private boolean K;
    private int L;
    private int M;
    private int N;
    @Nullable
    private RemoteChatSession O;
    private SignedMessageChain.b P;
    private final LastSeenMessagesValidator Q = new LastSeenMessagesValidator(20);
    private final MessageSignatureCache R = MessageSignatureCache.a();
    private final FutureChain S;
    private boolean T;
    private int lastTick = MinecraftServer.currentTick;
    private int allowedPlayerTicks = 1;
    private int lastDropTick = MinecraftServer.currentTick;
    private int lastBookTick = MinecraftServer.currentTick;
    private int dropCount = 0;
    private boolean hasMoved = false;
    private double lastPosX = Double.MAX_VALUE;
    private double lastPosY = Double.MAX_VALUE;
    private double lastPosZ = Double.MAX_VALUE;
    private float lastPitch = Float.MAX_VALUE;
    private float lastYaw = Float.MAX_VALUE;
    private boolean justTeleported = false;
    private int limitedPackets;
    private long lastLimitedPacket = -1L;

    public PlayerConnection(MinecraftServer minecraftserver, NetworkManager networkmanager, EntityPlayer entityplayer, CommonListenerCookie commonlistenercookie) {
        super(minecraftserver, networkmanager, commonlistenercookie, entityplayer);
        this.g = new PlayerChunkSender(networkmanager.e());
        this.f = entityplayer;
        entityplayer.c = this;
        entityplayer.Y().a();
        UUID uuid = entityplayer.cz();
        Objects.requireNonNull(minecraftserver);
        this.P = SignedMessageChain.b.unsigned(uuid, minecraftserver::aB);
        this.S = new FutureChain(minecraftserver.chatExecutor);
    }

    @Override
    public void d() {
        int spam;
        SpigotTimings.playerConnectionTimer.startTiming();
        if (this.p > -1) {
            this.b(new ClientboundBlockChangedAckPacket(this.p));
            this.p = -1;
        }
        this.l();
        this.f.L = this.f.dt();
        this.f.M = this.f.dv();
        this.f.N = this.f.dz();
        this.f.m();
        this.f.a(this.s, this.t, this.u, this.f.dE(), this.f.dG());
        ++this.o;
        this.N = this.M;
        if (this.I && !this.f.fH() && !this.f.bS() && !this.f.ex()) {
            if (++this.J > this.a(this.f)) {
                h.warn("{} was kicked for floating too long!", (Object)this.f.ah().getString());
                this.a(IChatBaseComponent.c("multiplayer.disconnect.flying"));
                return;
            }
        } else {
            this.I = false;
            this.J = 0;
        }
        this.y = this.f.cZ();
        if (this.y != this.f && this.y.cQ() == this.f) {
            this.z = this.y.dt();
            this.A = this.y.dv();
            this.B = this.y.dz();
            this.C = this.y.dt();
            this.D = this.y.dv();
            this.E = this.y.dz();
            if (this.K && this.y.cQ() == this.f) {
                if (++this.L > this.a(this.y)) {
                    h.warn("{} was kicked for floating a vehicle too long!", (Object)this.f.ah().getString());
                    this.a(IChatBaseComponent.c("multiplayer.disconnect.flying"));
                    return;
                }
            } else {
                this.K = false;
                this.L = 0;
            }
        } else {
            this.y = null;
            this.K = false;
            this.L = 0;
        }
        this.e();
        while ((spam = this.q.get()) > 0 && !this.q.compareAndSet(spam, spam - 1)) {
        }
        if (this.r > 0) {
            --this.r;
        }
        if (this.f.N() > 0L && this.d.aq() > 0 && SystemUtils.c() - this.f.N() > (long)this.d.aq() * 1000L * 60L) {
            this.f.H();
            this.a(IChatBaseComponent.c("multiplayer.disconnect.idling"));
        }
        SpigotTimings.playerConnectionTimer.stopTiming();
    }

    private int a(net.minecraft.world.entity.Entity entity) {
        double d0 = entity.ba();
        if (d0 < (double)1.0E-5f) {
            return Integer.MAX_VALUE;
        }
        double d1 = 0.08 / d0;
        return MathHelper.c(80.0 * Math.max(d1, 1.0));
    }

    public void l() {
        this.s = this.f.dt();
        this.t = this.f.dv();
        this.u = this.f.dz();
        this.v = this.f.dt();
        this.w = this.f.dv();
        this.x = this.f.dz();
    }

    @Override
    public boolean c() {
        return this.e.i() && !this.T;
    }

    @Override
    public boolean a(Packet<?> packet) {
        return super.a(packet) ? true : this.T && this.e.i() && packet instanceof ServerboundConfigurationAcknowledgedPacket;
    }

    @Override
    protected GameProfile i() {
        return this.f.fX();
    }

    private <T, R> CompletableFuture<R> a(T t0, BiFunction<ITextFilter, T, CompletableFuture<R>> bifunction) {
        return bifunction.apply(this.f.Y(), (ITextFilter)t0).thenApply(object -> {
            if (!this.c()) {
                h.debug("Ignoring packet due to disconnection");
                throw new CancellationException("disconnected");
            }
            return object;
        });
    }

    private CompletableFuture<FilteredText> a(String s2) {
        return this.a(s2, ITextFilter::a);
    }

    private CompletableFuture<List<FilteredText>> a(List<String> list) {
        return this.a(list, ITextFilter::a);
    }

    @Override
    public void a(PacketPlayInSteerVehicle packetplayinsteervehicle) {
        PlayerConnectionUtils.a(packetplayinsteervehicle, this, this.f.A());
        this.f.a(packetplayinsteervehicle.b(), packetplayinsteervehicle.e(), packetplayinsteervehicle.f(), packetplayinsteervehicle.g());
    }

    private static boolean b(double d0, double d1, double d2, float f2, float f1) {
        return Double.isNaN(d0) || Double.isNaN(d1) || Double.isNaN(d2) || !Floats.isFinite((float)f1) || !Floats.isFinite((float)f2);
    }

    private static double a(double d0) {
        return MathHelper.a(d0, -3.0E7, 3.0E7);
    }

    private static double b(double d0) {
        return MathHelper.a(d0, -2.0E7, 2.0E7);
    }

    @Override
    public void a(PacketPlayInVehicleMove packetplayinvehiclemove) {
        net.minecraft.world.entity.Entity entity;
        PlayerConnectionUtils.a(packetplayinvehiclemove, this, this.f.A());
        if (PlayerConnection.b(packetplayinvehiclemove.b(), packetplayinvehiclemove.e(), packetplayinvehiclemove.f(), packetplayinvehiclemove.g(), packetplayinvehiclemove.h())) {
            this.a(IChatBaseComponent.c("multiplayer.disconnect.invalid_vehicle_movement"));
        } else if (!this.p() && (entity = this.f.cZ()) != this.f && entity.cQ() == this.f && entity == this.y) {
            EntityLiving entityliving;
            WorldServer worldserver = this.f.A();
            double prevX = this.f.dt();
            double prevY = this.f.dv();
            double prevZ = this.f.dz();
            float prevYaw = this.f.dE();
            float prevPitch = this.f.dG();
            double d0 = entity.dt();
            double d1 = entity.dv();
            double d2 = entity.dz();
            double d3 = PlayerConnection.a(packetplayinvehiclemove.b());
            double d4 = PlayerConnection.b(packetplayinvehiclemove.e());
            double d5 = PlayerConnection.a(packetplayinvehiclemove.f());
            float f2 = MathHelper.g(packetplayinvehiclemove.g());
            float f1 = MathHelper.g(packetplayinvehiclemove.h());
            double d6 = d3 - this.z;
            double d7 = d4 - this.A;
            double d8 = d5 - this.B;
            double d9 = entity.dr().g();
            double d10 = d6 * d6 + d7 * d7 + d8 * d8;
            this.allowedPlayerTicks = (int)((long)this.allowedPlayerTicks + (System.currentTimeMillis() / 50L - (long)this.lastTick));
            this.allowedPlayerTicks = Math.max(this.allowedPlayerTicks, 1);
            this.lastTick = (int)(System.currentTimeMillis() / 50L);
            ++this.M;
            int i2 = this.M - this.N;
            if (i2 > Math.max(this.allowedPlayerTicks, 5)) {
                h.debug(this.f.cB() + " is sending move packets too frequently (" + i2 + " packets since last tick)");
                i2 = 1;
            }
            this.allowedPlayerTicks = d10 > 0.0 ? --this.allowedPlayerTicks : 20;
            double speed = this.f.fZ().b ? (double)(this.f.fZ().f * 20.0f) : (double)(this.f.fZ().g * 10.0f);
            speed *= 2.0;
            if (d10 - d9 > Math.max(100.0, Math.pow(SpigotConfig.movedTooQuicklyMultiplier * (double)i2 * speed, 2.0)) && !this.h()) {
                h.warn("{} (vehicle of {}) moved too quickly! {},{},{}", new Object[]{entity.ah().getString(), this.f.ah().getString(), d6, d7, d8});
                this.b(new PacketPlayOutVehicleMove(entity));
                return;
            }
            boolean flag = worldserver.a(entity, entity.cK().h(0.0625));
            d6 = d3 - this.C;
            d7 = d4 - this.D - 1.0E-6;
            d8 = d5 - this.E;
            boolean flag1 = entity.S;
            if (entity instanceof EntityLiving && (entityliving = (EntityLiving)entity).p_()) {
                entityliving.n();
            }
            entity.a(EnumMoveType.b, new Vec3D(d6, d7, d8));
            double d11 = d7;
            d6 = d3 - entity.dt();
            d7 = d4 - entity.dv();
            if (d7 > -0.5 || d7 < 0.5) {
                d7 = 0.0;
            }
            d8 = d5 - entity.dz();
            d10 = d6 * d6 + d7 * d7 + d8 * d8;
            boolean flag2 = false;
            if (d10 > SpigotConfig.movedWronglyThreshold) {
                flag2 = true;
                h.warn("{} (vehicle of {}) moved wrongly! {}", new Object[]{entity.ah().getString(), this.f.ah().getString(), Math.sqrt(d10)});
            }
            entity.a(d3, d4, d5, f2, f1);
            this.f.a(d3, d4, d5, this.f.dE(), this.f.dG());
            boolean flag3 = worldserver.a(entity, entity.cK().h(0.0625));
            if (flag && (flag2 || !flag3)) {
                entity.a(d0, d1, d2, f2, f1);
                this.f.a(d0, d1, d2, this.f.dE(), this.f.dG());
                this.b(new PacketPlayOutVehicleMove(entity));
                return;
            }
            CraftPlayer player = this.getCraftPlayer();
            if (!this.hasMoved) {
                this.lastPosX = prevX;
                this.lastPosY = prevY;
                this.lastPosZ = prevZ;
                this.lastYaw = prevYaw;
                this.lastPitch = prevPitch;
                this.hasMoved = true;
            }
            Location from = new Location(player.getWorld(), this.lastPosX, this.lastPosY, this.lastPosZ, this.lastYaw, this.lastPitch);
            Location to = player.getLocation().clone();
            to.setX(packetplayinvehiclemove.b());
            to.setY(packetplayinvehiclemove.e());
            to.setZ(packetplayinvehiclemove.f());
            to.setYaw(packetplayinvehiclemove.g());
            to.setPitch(packetplayinvehiclemove.h());
            double delta = Math.pow(this.lastPosX - to.getX(), 2.0) + Math.pow(this.lastPosY - to.getY(), 2.0) + Math.pow(this.lastPosZ - to.getZ(), 2.0);
            float deltaAngle = Math.abs(this.lastYaw - to.getYaw()) + Math.abs(this.lastPitch - to.getPitch());
            if ((delta > 0.00390625 || deltaAngle > 10.0f) && !this.f.fc()) {
                this.lastPosX = to.getX();
                this.lastPosY = to.getY();
                this.lastPosZ = to.getZ();
                this.lastYaw = to.getYaw();
                this.lastPitch = to.getPitch();
                Location oldTo = to.clone();
                PlayerMoveEvent event = new PlayerMoveEvent((Player)player, from, to);
                this.cserver.getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    this.teleport(from);
                    return;
                }
                if (!oldTo.equals((Object)event.getTo()) && !event.isCancelled()) {
                    this.f.getBukkitEntity().teleport(event.getTo(), PlayerTeleportEvent.TeleportCause.PLUGIN);
                    return;
                }
                if (!from.equals((Object)this.getCraftPlayer().getLocation()) && this.justTeleported) {
                    this.justTeleported = false;
                    return;
                }
            }
            this.f.A().l().a(this.f);
            Vec3D vec3d = new Vec3D(entity.dt() - d0, entity.dv() - d1, entity.dz() - d2);
            this.f.b(vec3d);
            this.f.b(vec3d.c, vec3d.d, vec3d.e);
            this.K = d11 >= -0.03125 && !flag1 && !this.d.ae() && !entity.aY() && this.b(entity);
            this.C = entity.dt();
            this.D = entity.dv();
            this.E = entity.dz();
        }
    }

    private boolean b(net.minecraft.world.entity.Entity entity) {
        return entity.dO().a(entity.cK().g(0.0625).b(0.0, -0.55, 0.0)).allMatch(BlockBase.BlockData::i);
    }

    @Override
    public void a(PacketPlayInTeleportAccept packetplayinteleportaccept) {
        PlayerConnectionUtils.a(packetplayinteleportaccept, this, this.f.A());
        if (packetplayinteleportaccept.b() == this.G) {
            if (this.F == null) {
                this.a(IChatBaseComponent.c("multiplayer.disconnect.invalid_player_movement"));
                return;
            }
            this.f.a(this.F.c, this.F.d, this.F.e, this.f.dE(), this.f.dG());
            this.v = this.F.c;
            this.w = this.F.d;
            this.x = this.F.e;
            if (this.f.P()) {
                this.f.Q();
            }
            this.F = null;
            this.f.A().l().a(this.f);
        }
    }

    @Override
    public void a(PacketPlayInRecipeDisplayed packetplayinrecipedisplayed) {
        PlayerConnectionUtils.a(packetplayinrecipedisplayed, this, this.f.A());
        Optional<RecipeHolder<?>> optional = this.d.aJ().a(packetplayinrecipedisplayed.b());
        RecipeBookServer recipebookserver = this.f.J();
        Objects.requireNonNull(recipebookserver);
        optional.ifPresent(recipebookserver::e);
    }

    @Override
    public void a(PacketPlayInRecipeSettings packetplayinrecipesettings) {
        PlayerConnectionUtils.a(packetplayinrecipesettings, this, this.f.A());
        CraftEventFactory.callRecipeBookSettingsEvent(this.f, packetplayinrecipesettings.b(), packetplayinrecipesettings.e(), packetplayinrecipesettings.f());
        this.f.J().a(packetplayinrecipesettings.b(), packetplayinrecipesettings.e(), packetplayinrecipesettings.f());
    }

    @Override
    public void a(PacketPlayInAdvancements packetplayinadvancements) {
        PlayerConnectionUtils.a(packetplayinadvancements, this, this.f.A());
        if (packetplayinadvancements.e() == PacketPlayInAdvancements.Status.a) {
            MinecraftKey minecraftkey = Objects.requireNonNull(packetplayinadvancements.f());
            AdvancementHolder advancementholder = this.d.aE().a(minecraftkey);
            if (advancementholder != null) {
                this.f.R().a(advancementholder);
            }
        }
    }

    @Override
    public void a(PacketPlayInTabComplete packetplayintabcomplete) {
        PlayerConnectionUtils.a(packetplayintabcomplete, this, this.f.A());
        if (this.q.addAndGet(1) > 500 && !this.d.ah().f(this.f.fX())) {
            this.a(IChatBaseComponent.c("disconnect.spam"));
            return;
        }
        StringReader stringreader = new StringReader(packetplayintabcomplete.e());
        if (stringreader.canRead() && stringreader.peek() == '/') {
            stringreader.skip();
        }
        ParseResults<CommandListenerWrapper> parseresults = this.d.aH().a().parse(stringreader, this.f.dg());
        this.d.aH().a().getCompletionSuggestions(parseresults).thenAccept(suggestions -> {
            if (suggestions.isEmpty()) {
                return;
            }
            Suggestions suggestions1 = suggestions.getList().size() <= 1000 ? suggestions : new Suggestions(suggestions.getRange(), suggestions.getList().subList(0, 1000));
            this.b(new PacketPlayOutTabComplete(packetplayintabcomplete.b(), suggestions1));
        });
    }

    @Override
    public void a(PacketPlayInSetCommandBlock packetplayinsetcommandblock) {
        PlayerConnectionUtils.a(packetplayinsetcommandblock, this, this.f.A());
        if (!this.d.q()) {
            this.f.a(IChatBaseComponent.c("advMode.notEnabled"));
        } else if (!this.f.gv()) {
            this.f.a(IChatBaseComponent.c("advMode.notAllowed"));
        } else {
            CommandBlockListenerAbstract commandblocklistenerabstract = null;
            TileEntityCommand tileentitycommand = null;
            BlockPosition blockposition = packetplayinsetcommandblock.b();
            TileEntity tileentity = this.f.dO().c_(blockposition);
            if (tileentity instanceof TileEntityCommand) {
                tileentitycommand = (TileEntityCommand)tileentity;
                commandblocklistenerabstract = tileentitycommand.b();
            }
            String s2 = packetplayinsetcommandblock.e();
            boolean flag = packetplayinsetcommandblock.f();
            if (commandblocklistenerabstract != null) {
                TileEntityCommand.Type tileentitycommand_type = tileentitycommand.l();
                IBlockData iblockdata = this.f.dO().a_(blockposition);
                EnumDirection enumdirection = iblockdata.c(BlockCommand.b);
                IBlockData iblockdata2 = switch (packetplayinsetcommandblock.i()) {
                    case TileEntityCommand.Type.a -> Blocks.kH.o();
                    case TileEntityCommand.Type.b -> Blocks.kG.o();
                    default -> Blocks.fN.o();
                };
                IBlockData iblockdata3 = (IBlockData)((IBlockData)iblockdata2.a(BlockCommand.b, enumdirection)).a(BlockCommand.c, packetplayinsetcommandblock.g());
                if (iblockdata3 != iblockdata) {
                    this.f.dO().a(blockposition, iblockdata3, 2);
                    tileentity.c(iblockdata3);
                    this.f.dO().m(blockposition).a(tileentity);
                }
                commandblocklistenerabstract.a(s2);
                commandblocklistenerabstract.a(flag);
                if (!flag) {
                    commandblocklistenerabstract.c(null);
                }
                tileentitycommand.b(packetplayinsetcommandblock.h());
                if (tileentitycommand_type != packetplayinsetcommandblock.i()) {
                    tileentitycommand.f();
                }
                commandblocklistenerabstract.f();
                if (!UtilColor.b(s2)) {
                    this.f.a(IChatBaseComponent.a("advMode.setCommand.success", new Object[]{s2}));
                }
            }
        }
    }

    @Override
    public void a(PacketPlayInSetCommandMinecart packetplayinsetcommandminecart) {
        PlayerConnectionUtils.a(packetplayinsetcommandminecart, this, this.f.A());
        if (!this.d.q()) {
            this.f.a(IChatBaseComponent.c("advMode.notEnabled"));
        } else if (!this.f.gv()) {
            this.f.a(IChatBaseComponent.c("advMode.notAllowed"));
        } else {
            CommandBlockListenerAbstract commandblocklistenerabstract = packetplayinsetcommandminecart.a(this.f.dO());
            if (commandblocklistenerabstract != null) {
                commandblocklistenerabstract.a(packetplayinsetcommandminecart.b());
                commandblocklistenerabstract.a(packetplayinsetcommandminecart.e());
                if (!packetplayinsetcommandminecart.e()) {
                    commandblocklistenerabstract.c(null);
                }
                commandblocklistenerabstract.f();
                this.f.a(IChatBaseComponent.a("advMode.setCommand.success", new Object[]{packetplayinsetcommandminecart.b()}));
            }
        }
    }

    @Override
    public void a(PacketPlayInPickItem packetplayinpickitem) {
        PlayerConnectionUtils.a(packetplayinpickitem, this, this.f.A());
        this.f.fY().c(packetplayinpickitem.b());
        this.f.c.b(new PacketPlayOutSetSlot(-2, 0, this.f.fY().k, this.f.fY().a(this.f.fY().k)));
        this.f.c.b(new PacketPlayOutSetSlot(-2, 0, packetplayinpickitem.b(), this.f.fY().a(packetplayinpickitem.b())));
        this.f.c.b(new PacketPlayOutHeldItemSlot(this.f.fY().k));
    }

    @Override
    public void a(PacketPlayInItemName packetplayinitemname) {
        PlayerConnectionUtils.a(packetplayinitemname, this, this.f.A());
        Container container = this.f.cd;
        if (container instanceof ContainerAnvil) {
            ContainerAnvil containeranvil = (ContainerAnvil)container;
            if (!containeranvil.b(this.f)) {
                h.debug("Player {} interacted with invalid menu {}", (Object)this.f, (Object)containeranvil);
                return;
            }
            containeranvil.a(packetplayinitemname.b());
        }
    }

    @Override
    public void a(PacketPlayInBeacon packetplayinbeacon) {
        PlayerConnectionUtils.a(packetplayinbeacon, this, this.f.A());
        Container container = this.f.cd;
        if (container instanceof ContainerBeacon) {
            ContainerBeacon containerbeacon = (ContainerBeacon)container;
            if (!this.f.cd.b(this.f)) {
                h.debug("Player {} interacted with invalid menu {}", (Object)this.f, (Object)this.f.cd);
                return;
            }
            containerbeacon.a(packetplayinbeacon.b(), packetplayinbeacon.e());
        }
    }

    @Override
    public void a(PacketPlayInStruct packetplayinstruct) {
        PlayerConnectionUtils.a(packetplayinstruct, this, this.f.A());
        if (this.f.gv()) {
            BlockPosition blockposition = packetplayinstruct.b();
            IBlockData iblockdata = this.f.dO().a_(blockposition);
            TileEntity tileentity = this.f.dO().c_(blockposition);
            if (tileentity instanceof TileEntityStructure) {
                TileEntityStructure tileentitystructure = (TileEntityStructure)tileentity;
                tileentitystructure.a(packetplayinstruct.f());
                tileentitystructure.a(packetplayinstruct.g());
                tileentitystructure.a(packetplayinstruct.h());
                tileentitystructure.a(packetplayinstruct.i());
                tileentitystructure.a(packetplayinstruct.j());
                tileentitystructure.a(packetplayinstruct.k());
                tileentitystructure.b(packetplayinstruct.l());
                tileentitystructure.a(packetplayinstruct.m());
                tileentitystructure.d(packetplayinstruct.n());
                tileentitystructure.e(packetplayinstruct.o());
                tileentitystructure.a(packetplayinstruct.p());
                tileentitystructure.a(packetplayinstruct.q());
                if (tileentitystructure.d()) {
                    String s2 = tileentitystructure.c();
                    if (packetplayinstruct.e() == TileEntityStructure.UpdateType.b) {
                        if (tileentitystructure.A()) {
                            this.f.a(IChatBaseComponent.a("structure_block.save_success", new Object[]{s2}), false);
                        } else {
                            this.f.a(IChatBaseComponent.a("structure_block.save_failure", new Object[]{s2}), false);
                        }
                    } else if (packetplayinstruct.e() == TileEntityStructure.UpdateType.c) {
                        if (!tileentitystructure.C()) {
                            this.f.a(IChatBaseComponent.a("structure_block.load_not_found", new Object[]{s2}), false);
                        } else if (tileentitystructure.a(this.f.A())) {
                            this.f.a(IChatBaseComponent.a("structure_block.load_success", new Object[]{s2}), false);
                        } else {
                            this.f.a(IChatBaseComponent.a("structure_block.load_prepare", new Object[]{s2}), false);
                        }
                    } else if (packetplayinstruct.e() == TileEntityStructure.UpdateType.d) {
                        if (tileentitystructure.z()) {
                            this.f.a(IChatBaseComponent.a("structure_block.size_success", new Object[]{s2}), false);
                        } else {
                            this.f.a(IChatBaseComponent.c("structure_block.size_failure"), false);
                        }
                    }
                } else {
                    this.f.a(IChatBaseComponent.a("structure_block.invalid_structure_name", new Object[]{packetplayinstruct.g()}), false);
                }
                tileentitystructure.e();
                this.f.dO().a(blockposition, iblockdata, iblockdata, 3);
            }
        }
    }

    @Override
    public void a(PacketPlayInSetJigsaw packetplayinsetjigsaw) {
        PlayerConnectionUtils.a(packetplayinsetjigsaw, this, this.f.A());
        if (this.f.gv()) {
            BlockPosition blockposition = packetplayinsetjigsaw.b();
            IBlockData iblockdata = this.f.dO().a_(blockposition);
            TileEntity tileentity = this.f.dO().c_(blockposition);
            if (tileentity instanceof TileEntityJigsaw) {
                TileEntityJigsaw tileentityjigsaw = (TileEntityJigsaw)tileentity;
                tileentityjigsaw.a(packetplayinsetjigsaw.e());
                tileentityjigsaw.b(packetplayinsetjigsaw.f());
                tileentityjigsaw.a(ResourceKey.a(Registries.aU, packetplayinsetjigsaw.g()));
                tileentityjigsaw.a(packetplayinsetjigsaw.h());
                tileentityjigsaw.a(packetplayinsetjigsaw.i());
                tileentityjigsaw.a(packetplayinsetjigsaw.k());
                tileentityjigsaw.b(packetplayinsetjigsaw.j());
                tileentityjigsaw.e();
                this.f.dO().a(blockposition, iblockdata, iblockdata, 3);
            }
        }
    }

    @Override
    public void a(PacketPlayInJigsawGenerate packetplayinjigsawgenerate) {
        PlayerConnectionUtils.a(packetplayinjigsawgenerate, this, this.f.A());
        if (this.f.gv()) {
            BlockPosition blockposition = packetplayinjigsawgenerate.b();
            TileEntity tileentity = this.f.dO().c_(blockposition);
            if (tileentity instanceof TileEntityJigsaw) {
                TileEntityJigsaw tileentityjigsaw = (TileEntityJigsaw)tileentity;
                tileentityjigsaw.a(this.f.A(), packetplayinjigsawgenerate.e(), packetplayinjigsawgenerate.f());
            }
        }
    }

    @Override
    public void a(PacketPlayInTrSel packetplayintrsel) {
        PlayerConnectionUtils.a(packetplayintrsel, this, this.f.A());
        int i2 = packetplayintrsel.b();
        Container container = this.f.cd;
        if (container instanceof ContainerMerchant) {
            ContainerMerchant containermerchant = (ContainerMerchant)container;
            TradeSelectEvent tradeSelectEvent = CraftEventFactory.callTradeSelectEvent(this.f, i2, containermerchant);
            if (tradeSelectEvent.isCancelled()) {
                this.f.getBukkitEntity().updateInventory();
                return;
            }
            if (!containermerchant.b(this.f)) {
                h.debug("Player {} interacted with invalid menu {}", (Object)this.f, (Object)containermerchant);
                return;
            }
            containermerchant.e(i2);
            containermerchant.h(i2);
        }
    }

    @Override
    public void a(PacketPlayInBEdit packetplayinbedit) {
        if (this.lastBookTick + 20 > MinecraftServer.currentTick) {
            this.a(IChatBaseComponent.b("Book edited too quickly!"));
            return;
        }
        this.lastBookTick = MinecraftServer.currentTick;
        int i2 = packetplayinbedit.b();
        if (PlayerInventory.d(i2) || i2 == 40) {
            ArrayList list = Lists.newArrayList();
            Optional<String> optional = packetplayinbedit.f();
            Objects.requireNonNull(list);
            optional.ifPresent(list::add);
            Stream stream = packetplayinbedit.e().stream().limit(100L);
            Objects.requireNonNull(list);
            stream.forEach(list::add);
            Consumer<List> consumer = optional.isPresent() ? list1 -> this.a((FilteredText)list1.get(0), list1.subList(1, list1.size()), i2) : list1 -> this.a((List<FilteredText>)list1, i2);
            this.a(list).thenAcceptAsync(consumer, (Executor)this.d);
        }
    }

    private void a(List<FilteredText> list, int i2) {
        ItemStack handItem = this.f.fY().a(i2);
        ItemStack itemstack = handItem.s();
        if (itemstack.a(Items.tZ)) {
            List<Filterable<String>> list1 = list.stream().map(this::a).toList();
            itemstack.b(DataComponents.I, new WritableBookContent(list1));
            CraftEventFactory.handleEditBookEvent(this.f, i2, handItem, itemstack);
        }
    }

    private void a(FilteredText filteredtext, List<FilteredText> list, int i2) {
        ItemStack itemstack = this.f.fY().a(i2);
        if (itemstack.a(Items.tZ)) {
            ItemStack itemstack1 = itemstack.a((IMaterial)Items.ua);
            itemstack1.c(DataComponents.I);
            List<Filterable<IChatBaseComponent>> list1 = list.stream().map(filteredtext1 -> this.a((FilteredText)filteredtext1).a(IChatBaseComponent::b)).toList();
            itemstack1.b(DataComponents.J, new WrittenBookContent(this.a(filteredtext), this.f.ah().getString(), 0, list1, true));
            CraftEventFactory.handleEditBookEvent(this.f, i2, itemstack, itemstack1);
            this.f.fY().a(i2, itemstack);
        }
    }

    private Filterable<String> a(FilteredText filteredtext) {
        return this.f.Z() ? Filterable.a(filteredtext.b()) : Filterable.a(filteredtext);
    }

    @Override
    public void a(PacketPlayInEntityNBTQuery packetplayinentitynbtquery) {
        net.minecraft.world.entity.Entity entity;
        PlayerConnectionUtils.a(packetplayinentitynbtquery, this, this.f.A());
        if (this.f.l(2) && (entity = this.f.dO().a(packetplayinentitynbtquery.e())) != null) {
            NBTTagCompound nbttagcompound = entity.f(new NBTTagCompound());
            this.f.c.b(new PacketPlayOutNBTQuery(packetplayinentitynbtquery.b(), nbttagcompound));
        }
    }

    @Override
    public void a(ServerboundContainerSlotStateChangedPacket serverboundcontainerslotstatechangedpacket) {
        CrafterMenu craftermenu;
        IInventory iinventory;
        Container container;
        PlayerConnectionUtils.a(serverboundcontainerslotstatechangedpacket, this, this.f.A());
        if (!this.f.R_() && serverboundcontainerslotstatechangedpacket.e() == this.f.cd.j && (container = this.f.cd) instanceof CrafterMenu && (iinventory = (craftermenu = (CrafterMenu)container).m()) instanceof CrafterBlockEntity) {
            CrafterBlockEntity crafterblockentity = (CrafterBlockEntity)iinventory;
            crafterblockentity.a(serverboundcontainerslotstatechangedpacket.b(), serverboundcontainerslotstatechangedpacket.f());
        }
    }

    @Override
    public void a(PacketPlayInTileNBTQuery packetplayintilenbtquery) {
        PlayerConnectionUtils.a(packetplayintilenbtquery, this, this.f.A());
        if (this.f.l(2)) {
            TileEntity tileentity = this.f.dO().c_(packetplayintilenbtquery.e());
            NBTTagCompound nbttagcompound = tileentity != null ? tileentity.d(this.f.dQ()) : null;
            this.f.c.b(new PacketPlayOutNBTQuery(packetplayintilenbtquery.b(), nbttagcompound));
        }
    }

    @Override
    public void a(PacketPlayInFlying packetplayinflying) {
        PlayerConnectionUtils.a(packetplayinflying, this, this.f.A());
        if (PlayerConnection.b(packetplayinflying.a(0.0), packetplayinflying.b(0.0), packetplayinflying.c(0.0), packetplayinflying.a(0.0f), packetplayinflying.b(0.0f))) {
            this.a(IChatBaseComponent.c("multiplayer.disconnect.invalid_player_movement"));
        } else {
            WorldServer worldserver = this.f.A();
            if (!this.f.h && !this.f.fc()) {
                if (this.o == 0) {
                    this.l();
                }
                if (!this.p()) {
                    double d0 = PlayerConnection.a(packetplayinflying.a(this.f.dt()));
                    double d1 = PlayerConnection.b(packetplayinflying.b(this.f.dv()));
                    double d2 = PlayerConnection.a(packetplayinflying.c(this.f.dz()));
                    float f2 = MathHelper.g(packetplayinflying.a(this.f.dE()));
                    float f1 = MathHelper.g(packetplayinflying.b(this.f.dG()));
                    if (this.f.bS()) {
                        this.f.a(this.f.dt(), this.f.dv(), this.f.dz(), f2, f1);
                        this.f.A().l().a(this.f);
                        this.allowedPlayerTicks = 20;
                    } else {
                        double prevX = this.f.dt();
                        double prevY = this.f.dv();
                        double prevZ = this.f.dz();
                        float prevYaw = this.f.dE();
                        float prevPitch = this.f.dG();
                        double d3 = this.f.dt();
                        double d4 = this.f.dv();
                        double d5 = this.f.dz();
                        double d6 = d0 - this.s;
                        double d7 = d1 - this.t;
                        double d8 = d2 - this.u;
                        double d9 = this.f.dr().g();
                        double d10 = d6 * d6 + d7 * d7 + d8 * d8;
                        if (this.f.fH()) {
                            if (d10 > 1.0) {
                                this.a(this.f.dt(), this.f.dv(), this.f.dz(), f2, f1);
                            }
                        } else {
                            boolean flag1;
                            boolean flag = this.f.fA();
                            if (worldserver.s().i()) {
                                ++this.M;
                                int i2 = this.M - this.N;
                                this.allowedPlayerTicks = (int)((long)this.allowedPlayerTicks + (System.currentTimeMillis() / 50L - (long)this.lastTick));
                                this.allowedPlayerTicks = Math.max(this.allowedPlayerTicks, 1);
                                this.lastTick = (int)(System.currentTimeMillis() / 50L);
                                if (i2 > Math.max(this.allowedPlayerTicks, 5)) {
                                    h.debug("{} is sending move packets too frequently ({} packets since last tick)", (Object)this.f.ah().getString(), (Object)i2);
                                    i2 = 1;
                                }
                                this.allowedPlayerTicks = packetplayinflying.h || d10 > 0.0 ? --this.allowedPlayerTicks : 20;
                                double speed = this.f.fZ().b ? (double)(this.f.fZ().f * 20.0f) : (double)(this.f.fZ().g * 10.0f);
                                if (!(this.f.P() || this.f.dO().ab().b(GameRules.t) && flag)) {
                                    float f22;
                                    float f3 = f22 = flag ? 300.0f : 100.0f;
                                    if (d10 - d9 > Math.max((double)f22, Math.pow(SpigotConfig.movedTooQuicklyMultiplier * (double)i2 * speed, 2.0)) && !this.h()) {
                                        h.warn("{} moved too quickly! {},{},{}", new Object[]{this.f.ah().getString(), d6, d7, d8});
                                        this.a(this.f.dt(), this.f.dv(), this.f.dz(), this.f.dE(), this.f.dG());
                                        return;
                                    }
                                }
                            }
                            AxisAlignedBB axisalignedbb = this.f.cK();
                            d6 = d0 - this.v;
                            d7 = d1 - this.w;
                            d8 = d2 - this.x;
                            boolean bl = flag1 = d7 > 0.0;
                            if (this.f.aF() && !packetplayinflying.b() && flag1) {
                                this.f.ff();
                            }
                            boolean flag2 = this.f.S;
                            this.f.a(EnumMoveType.b, new Vec3D(d6, d7, d8));
                            this.f.aG = packetplayinflying.b();
                            double d11 = d7;
                            d6 = d0 - this.f.dt();
                            d7 = d1 - this.f.dv();
                            if (d7 > -0.5 || d7 < 0.5) {
                                d7 = 0.0;
                            }
                            d8 = d2 - this.f.dz();
                            d10 = d6 * d6 + d7 * d7 + d8 * d8;
                            boolean flag3 = false;
                            if (!this.f.P() && d10 > SpigotConfig.movedWronglyThreshold && !this.f.fH() && !this.f.e.e() && this.f.e.b() != EnumGamemode.d) {
                                flag3 = true;
                                h.warn("{} moved wrongly!", (Object)this.f.ah().getString());
                            }
                            if (!this.f.ag && !this.f.fH() && (flag3 && worldserver.a((net.minecraft.world.entity.Entity)this.f, axisalignedbb) || this.a(worldserver, axisalignedbb, d0, d1, d2))) {
                                this.internalTeleport(d3, d4, d5, f2, f1, Collections.emptySet());
                                this.f.a(this.f.dt() - d3, this.f.dv() - d4, this.f.dz() - d5, packetplayinflying.b());
                            } else {
                                this.f.a(prevX, prevY, prevZ, prevYaw, prevPitch);
                                CraftPlayer player = this.getCraftPlayer();
                                if (!this.hasMoved) {
                                    this.lastPosX = prevX;
                                    this.lastPosY = prevY;
                                    this.lastPosZ = prevZ;
                                    this.lastYaw = prevYaw;
                                    this.lastPitch = prevPitch;
                                    this.hasMoved = true;
                                }
                                Location from = new Location(player.getWorld(), this.lastPosX, this.lastPosY, this.lastPosZ, this.lastYaw, this.lastPitch);
                                Location to = player.getLocation().clone();
                                if (packetplayinflying.g) {
                                    to.setX(packetplayinflying.a);
                                    to.setY(packetplayinflying.b);
                                    to.setZ(packetplayinflying.c);
                                }
                                if (packetplayinflying.h) {
                                    to.setYaw(packetplayinflying.d);
                                    to.setPitch(packetplayinflying.e);
                                }
                                double delta = Math.pow(this.lastPosX - to.getX(), 2.0) + Math.pow(this.lastPosY - to.getY(), 2.0) + Math.pow(this.lastPosZ - to.getZ(), 2.0);
                                float deltaAngle = Math.abs(this.lastYaw - to.getYaw()) + Math.abs(this.lastPitch - to.getPitch());
                                if ((delta > 0.00390625 || deltaAngle > 10.0f) && !this.f.fc()) {
                                    this.lastPosX = to.getX();
                                    this.lastPosY = to.getY();
                                    this.lastPosZ = to.getZ();
                                    this.lastYaw = to.getYaw();
                                    this.lastPitch = to.getPitch();
                                    Location oldTo = to.clone();
                                    PlayerMoveEvent event = new PlayerMoveEvent((Player)player, from, to);
                                    this.cserver.getPluginManager().callEvent((Event)event);
                                    if (event.isCancelled()) {
                                        this.teleport(from);
                                        return;
                                    }
                                    if (!oldTo.equals((Object)event.getTo()) && !event.isCancelled()) {
                                        this.f.getBukkitEntity().teleport(event.getTo(), PlayerTeleportEvent.TeleportCause.PLUGIN);
                                        return;
                                    }
                                    if (!from.equals((Object)this.getCraftPlayer().getLocation()) && this.justTeleported) {
                                        this.justTeleported = false;
                                        return;
                                    }
                                }
                                this.f.a(d0, d1, d2, f2, f1);
                                boolean flag4 = this.f.fn();
                                this.I = d11 >= -0.03125 && !flag2 && this.f.e.b() != EnumGamemode.d && !this.d.ae() && !this.f.fZ().c && !this.f.b(MobEffects.y) && !flag && !flag4 && this.b(this.f);
                                this.f.A().l().a(this.f);
                                Vec3D vec3d = new Vec3D(this.f.dt() - d3, this.f.dv() - d4, this.f.dz() - d5);
                                this.f.a(packetplayinflying.b(), vec3d);
                                this.f.a(this.f.dt() - d3, this.f.dv() - d4, this.f.dz() - d5, packetplayinflying.b());
                                this.f.b(vec3d);
                                if (flag1) {
                                    this.f.n();
                                }
                                if (packetplayinflying.b() || this.f.dX() || this.f.p_() || this.f.R_() || flag || flag4) {
                                    this.f.gB();
                                }
                                this.f.b(this.f.dt() - d3, this.f.dv() - d4, this.f.dz() - d5);
                                this.v = this.f.dt();
                                this.w = this.f.dv();
                                this.x = this.f.dz();
                            }
                        }
                    }
                }
            }
        }
    }

    private boolean p() {
        if (this.F != null) {
            if (this.o - this.H > 20) {
                this.H = this.o;
                this.a(this.F.c, this.F.d, this.F.e, this.f.dE(), this.f.dG());
            }
            this.allowedPlayerTicks = 20;
            return true;
        }
        this.H = this.o;
        return false;
    }

    private boolean a(IWorldReader iworldreader, AxisAlignedBB axisalignedbb, double d0, double d1, double d2) {
        VoxelShape voxelshape1;
        AxisAlignedBB axisalignedbb1 = this.f.cK().d(d0 - this.f.dt(), d1 - this.f.dv(), d2 - this.f.dz());
        Iterable<VoxelShape> iterable = iworldreader.d(this.f, axisalignedbb1.h(1.0E-5f));
        VoxelShape voxelshape = VoxelShapes.a(axisalignedbb.h(1.0E-5f));
        Iterator<VoxelShape> iterator = iterable.iterator();
        do {
            if (iterator.hasNext()) continue;
            return false;
        } while (VoxelShapes.c(voxelshape1 = iterator.next(), voxelshape, OperatorBoolean.i));
        return true;
    }

    public void a(double d0, double d1, double d2, float f2, float f1) {
        this.teleport(d0, d1, d2, f2, f1, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    public boolean teleport(double d0, double d1, double d2, float f2, float f1, PlayerTeleportEvent.TeleportCause cause) {
        return this.teleport(d0, d1, d2, f2, f1, Collections.emptySet(), cause);
    }

    public void a(double d0, double d1, double d2, float f2, float f1, Set<RelativeMovement> set) {
        this.teleport(d0, d1, d2, f2, f1, set, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    public boolean teleport(double d0, double d1, double d2, float f2, float f1, Set<RelativeMovement> set, PlayerTeleportEvent.TeleportCause cause) {
        CraftPlayer player = this.getCraftPlayer();
        Location from = player.getLocation();
        double x2 = d0;
        double y2 = d1;
        double z2 = d2;
        float yaw = f2;
        float pitch = f1;
        Location to = new Location(this.getCraftPlayer().getWorld(), x2, y2, z2, yaw, pitch);
        if (from.equals((Object)to)) {
            this.internalTeleport(d0, d1, d2, f2, f1, set);
            return true;
        }
        PlayerTeleportEvent event = new PlayerTeleportEvent((Player)player, from.clone(), to.clone(), cause);
        this.cserver.getPluginManager().callEvent((Event)event);
        if (event.isCancelled() || !to.equals((Object)event.getTo())) {
            set = Collections.emptySet();
            to = event.isCancelled() ? event.getFrom() : event.getTo();
            d0 = to.getX();
            d1 = to.getY();
            d2 = to.getZ();
            f2 = to.getYaw();
            f1 = to.getPitch();
        }
        this.internalTeleport(d0, d1, d2, f2, f1, set);
        return !event.isCancelled();
    }

    public void teleport(Location dest) {
        this.internalTeleport(dest.getX(), dest.getY(), dest.getZ(), dest.getYaw(), dest.getPitch(), Collections.emptySet());
    }

    private void internalTeleport(double d0, double d1, double d2, float f2, float f1, Set<RelativeMovement> set) {
        if (Float.isNaN(f2)) {
            f2 = 0.0f;
        }
        if (Float.isNaN(f1)) {
            f1 = 0.0f;
        }
        this.justTeleported = true;
        double d3 = set.contains((Object)RelativeMovement.a) ? this.f.dt() : 0.0;
        double d4 = set.contains((Object)RelativeMovement.b) ? this.f.dv() : 0.0;
        double d5 = set.contains((Object)RelativeMovement.c) ? this.f.dz() : 0.0;
        float f22 = set.contains((Object)RelativeMovement.d) ? this.f.dE() : 0.0f;
        float f3 = set.contains((Object)RelativeMovement.e) ? this.f.dG() : 0.0f;
        this.F = new Vec3D(d0, d1, d2);
        if (++this.G == Integer.MAX_VALUE) {
            this.G = 0;
        }
        this.lastPosX = this.F.c;
        this.lastPosY = this.F.d;
        this.lastPosZ = this.F.e;
        this.lastYaw = f2;
        this.lastPitch = f1;
        this.H = this.o;
        this.f.a(d0, d1, d2, f2, f1);
        this.f.c.b(new PacketPlayOutPosition(d0 - d3, d1 - d4, d2 - d5, f2 - f22, f1 - f3, set, this.G));
    }

    @Override
    public void a(PacketPlayInBlockDig packetplayinblockdig) {
        PlayerConnectionUtils.a(packetplayinblockdig, this, this.f.A());
        if (this.f.fc()) {
            return;
        }
        BlockPosition blockposition = packetplayinblockdig.b();
        this.f.H();
        PacketPlayInBlockDig.EnumPlayerDigType packetplayinblockdig_enumplayerdigtype = packetplayinblockdig.f();
        switch (packetplayinblockdig_enumplayerdigtype) {
            case g: {
                if (!this.f.R_()) {
                    ItemStack itemstack = this.f.b(EnumHand.b);
                    CraftItemStack mainHand = CraftItemStack.asCraftMirror(itemstack);
                    CraftItemStack offHand = CraftItemStack.asCraftMirror(this.f.b(EnumHand.a));
                    PlayerSwapHandItemsEvent swapItemsEvent = new PlayerSwapHandItemsEvent((Player)this.getCraftPlayer(), (org.bukkit.inventory.ItemStack)mainHand.clone(), (org.bukkit.inventory.ItemStack)offHand.clone());
                    this.cserver.getPluginManager().callEvent((Event)swapItemsEvent);
                    if (swapItemsEvent.isCancelled()) {
                        return;
                    }
                    if (swapItemsEvent.getOffHandItem().equals((Object)offHand)) {
                        this.f.a(EnumHand.b, this.f.b(EnumHand.a));
                    } else {
                        this.f.a(EnumHand.b, CraftItemStack.asNMSCopy(swapItemsEvent.getOffHandItem()));
                    }
                    if (swapItemsEvent.getMainHandItem().equals((Object)mainHand)) {
                        this.f.a(EnumHand.a, itemstack);
                    } else {
                        this.f.a(EnumHand.a, CraftItemStack.asNMSCopy(swapItemsEvent.getMainHandItem()));
                    }
                    this.f.fx();
                }
                return;
            }
            case e: {
                if (!this.f.R_()) {
                    if (this.lastDropTick != MinecraftServer.currentTick) {
                        this.dropCount = 0;
                        this.lastDropTick = MinecraftServer.currentTick;
                    } else {
                        ++this.dropCount;
                        if (this.dropCount >= 20) {
                            h.warn(this.f.cB() + " dropped their items too quickly!");
                            this.a(IChatBaseComponent.b("You dropped your items too quickly (Hacking?)"));
                            return;
                        }
                    }
                    this.f.a(false);
                }
                return;
            }
            case d: {
                if (!this.f.R_()) {
                    this.f.a(true);
                }
                return;
            }
            case f: {
                this.f.fw();
                return;
            }
            case a: 
            case b: 
            case c: {
                this.f.e.a(blockposition, packetplayinblockdig_enumplayerdigtype, packetplayinblockdig.e(), this.f.dO().am(), packetplayinblockdig.g());
                this.f.c.a(packetplayinblockdig.g());
                return;
            }
        }
        throw new IllegalArgumentException("Invalid player action");
    }

    private static boolean a(EntityPlayer entityplayer, ItemStack itemstack) {
        if (itemstack.e()) {
            return false;
        }
        Item item = itemstack.g();
        return (item instanceof ItemBlock || item instanceof ItemBucket) && !entityplayer.gt().a(item);
    }

    private boolean checkLimit(long timestamp) {
        if (this.lastLimitedPacket != -1L && timestamp - this.lastLimitedPacket < 30L && this.limitedPackets++ >= 4) {
            return false;
        }
        if (this.lastLimitedPacket == -1L || timestamp - this.lastLimitedPacket >= 30L) {
            this.lastLimitedPacket = timestamp;
            this.limitedPackets = 0;
            return true;
        }
        return true;
    }

    @Override
    public void a(PacketPlayInUseItem packetplayinuseitem) {
        PlayerConnectionUtils.a(packetplayinuseitem, this, this.f.A());
        if (this.f.fc()) {
            return;
        }
        if (!this.checkLimit(packetplayinuseitem.timestamp)) {
            return;
        }
        this.f.c.a(packetplayinuseitem.f());
        WorldServer worldserver = this.f.A();
        EnumHand enumhand = packetplayinuseitem.b();
        ItemStack itemstack = this.f.b(enumhand);
        if (itemstack.a(worldserver.J())) {
            MovingObjectPositionBlock movingobjectpositionblock = packetplayinuseitem.e();
            Vec3D vec3d = movingobjectpositionblock.e();
            BlockPosition blockposition = movingobjectpositionblock.a();
            if (this.f.a(blockposition, 1.0)) {
                Vec3D vec3d1 = vec3d.d(Vec3D.b(blockposition));
                double d0 = 1.0000001;
                if (Math.abs(vec3d1.a()) < 1.0000001 && Math.abs(vec3d1.b()) < 1.0000001 && Math.abs(vec3d1.c()) < 1.0000001) {
                    EnumDirection enumdirection = movingobjectpositionblock.b();
                    this.f.H();
                    int i2 = this.f.dO().am();
                    if (blockposition.v() < i2) {
                        if (this.F == null && worldserver.a((EntityHuman)this.f, blockposition)) {
                            this.f.fx();
                            EnumInteractionResult enuminteractionresult = this.f.e.a(this.f, worldserver, itemstack, enumhand, movingobjectpositionblock);
                            if (enuminteractionresult.a()) {
                                CriterionTriggers.P.a(this.f, movingobjectpositionblock.a(), itemstack.s());
                            }
                            if (enumdirection == EnumDirection.b && !enuminteractionresult.a() && blockposition.v() >= i2 - 1 && PlayerConnection.a(this.f, itemstack)) {
                                IChatMutableComponent ichatmutablecomponent = IChatBaseComponent.a("build.tooHigh", i2 - 1).a(EnumChatFormat.m);
                                this.f.b(ichatmutablecomponent, true);
                            } else if (enuminteractionresult.b()) {
                                this.f.a(enumhand, true);
                            }
                        }
                    } else {
                        IChatMutableComponent ichatmutablecomponent1 = IChatBaseComponent.a("build.tooHigh", i2 - 1).a(EnumChatFormat.m);
                        this.f.b(ichatmutablecomponent1, true);
                    }
                    this.f.c.b(new PacketPlayOutBlockChange(worldserver, blockposition));
                    this.f.c.b(new PacketPlayOutBlockChange(worldserver, blockposition.a(enumdirection)));
                } else {
                    h.warn("Rejecting UseItemOnPacket from {}: Location {} too far away from hit block {}.", new Object[]{this.f.fX().getName(), vec3d, blockposition});
                }
            }
        }
    }

    @Override
    public void a(PacketPlayInBlockPlace packetplayinblockplace) {
        PlayerConnectionUtils.a(packetplayinblockplace, this, this.f.A());
        if (this.f.fc()) {
            return;
        }
        if (!this.checkLimit(packetplayinblockplace.timestamp)) {
            return;
        }
        this.a(packetplayinblockplace.e());
        WorldServer worldserver = this.f.A();
        EnumHand enumhand = packetplayinblockplace.b();
        ItemStack itemstack = this.f.b(enumhand);
        this.f.H();
        if (!itemstack.e() && itemstack.a(worldserver.J())) {
            boolean cancelled;
            float f2 = MathHelper.g(packetplayinblockplace.f());
            float f1 = MathHelper.g(packetplayinblockplace.g());
            if (f1 != this.f.dG() || f2 != this.f.dE()) {
                this.f.b(f2, f1);
            }
            double d0 = this.f.dt();
            double d1 = this.f.dv() + (double)this.f.cL();
            double d2 = this.f.dz();
            Vec3D vec3d = new Vec3D(d0, d1, d2);
            float f3 = MathHelper.b(-f2 * ((float)Math.PI / 180) - (float)Math.PI);
            float f4 = MathHelper.a(-f2 * ((float)Math.PI / 180) - (float)Math.PI);
            float f5 = -MathHelper.b(-f1 * ((float)Math.PI / 180));
            float f6 = MathHelper.a(-f1 * ((float)Math.PI / 180));
            float f7 = f4 * f5;
            float f8 = f3 * f5;
            double d3 = this.f.gy();
            Vec3D vec3d1 = vec3d.b((double)f7 * d3, (double)f6 * d3, (double)f8 * d3);
            MovingObjectPositionBlock movingobjectposition = this.f.dO().a(new RayTrace(vec3d, vec3d1, RayTrace.BlockCollisionOption.b, RayTrace.FluidCollisionOption.a, this.f));
            if (movingobjectposition == null || ((MovingObjectPosition)movingobjectposition).c() != MovingObjectPosition.EnumMovingObjectType.b) {
                PlayerInteractEvent event = CraftEventFactory.callPlayerInteractEvent(this.f, Action.RIGHT_CLICK_AIR, itemstack, enumhand);
                cancelled = event.useItemInHand() == Event.Result.DENY;
            } else {
                PlayerInteractEvent event;
                MovingObjectPositionBlock movingobjectpositionblock = movingobjectposition;
                cancelled = this.f.e.firedInteract && this.f.e.interactPosition.equals(movingobjectpositionblock.a()) && this.f.e.interactHand == enumhand && ItemStack.c(this.f.e.interactItemStack, itemstack) ? this.f.e.interactResult : (event = CraftEventFactory.callPlayerInteractEvent(this.f, Action.RIGHT_CLICK_BLOCK, movingobjectpositionblock.a(), movingobjectpositionblock.b(), itemstack, true, enumhand, movingobjectpositionblock.e())).useItemInHand() == Event.Result.DENY;
                this.f.e.firedInteract = false;
            }
            if (cancelled) {
                this.f.getBukkitEntity().updateInventory();
                return;
            }
            itemstack = this.f.b(enumhand);
            if (itemstack.e()) {
                return;
            }
            EnumInteractionResult enuminteractionresult = this.f.e.a(this.f, worldserver, itemstack, enumhand);
            if (enuminteractionresult.b()) {
                this.f.a(enumhand, true);
            }
        }
    }

    @Override
    public void a(PacketPlayInSpectate packetplayinspectate) {
        PlayerConnectionUtils.a(packetplayinspectate, this, this.f.A());
        if (this.f.R_()) {
            for (WorldServer worldserver : this.d.K()) {
                net.minecraft.world.entity.Entity entity = packetplayinspectate.a(worldserver);
                if (entity == null) continue;
                this.f.teleportTo(worldserver, entity.dt(), entity.dv(), entity.dz(), entity.dE(), entity.dG(), PlayerTeleportEvent.TeleportCause.SPECTATE);
                return;
            }
        }
    }

    @Override
    public void a(PacketPlayInBoatMove packetplayinboatmove) {
        PlayerConnectionUtils.a(packetplayinboatmove, this, this.f.A());
        net.minecraft.world.entity.Entity entity = this.f.dd();
        if (entity instanceof EntityBoat) {
            EntityBoat entityboat = (EntityBoat)entity;
            entityboat.b(packetplayinboatmove.b(), packetplayinboatmove.e());
        }
    }

    @Override
    public void a(DisconnectionDetails disconnectiondetails) {
        if (this.processedDisconnect) {
            return;
        }
        this.processedDisconnect = true;
        h.info("{} lost connection: {}", (Object)this.f.ah().getString(), (Object)disconnectiondetails.a().getString());
        this.q();
        super.a(disconnectiondetails);
    }

    private void q() {
        this.S.close();
        this.f.v();
        String quitMessage = this.d.ah().remove(this.f);
        if (quitMessage != null && quitMessage.length() > 0) {
            this.d.ah().broadcastMessage(CraftChatMessage.fromString(quitMessage));
        }
        this.f.Y().b();
    }

    public void a(int i2) {
        if (i2 < 0) {
            throw new IllegalArgumentException("Expected packet sequence nr >= 0");
        }
        this.p = Math.max(i2, this.p);
    }

    @Override
    public void a(PacketPlayInHeldItemSlot packetplayinhelditemslot) {
        PlayerConnectionUtils.a(packetplayinhelditemslot, this, this.f.A());
        if (this.f.fc()) {
            return;
        }
        if (packetplayinhelditemslot.b() >= 0 && packetplayinhelditemslot.b() < PlayerInventory.g()) {
            PlayerItemHeldEvent event = new PlayerItemHeldEvent((Player)this.getCraftPlayer(), this.f.fY().k, packetplayinhelditemslot.b());
            this.cserver.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                this.b(new PacketPlayOutHeldItemSlot(this.f.fY().k));
                this.f.H();
                return;
            }
            if (this.f.fY().k != packetplayinhelditemslot.b() && this.f.fs() == EnumHand.a) {
                this.f.fx();
            }
            this.f.fY().k = packetplayinhelditemslot.b();
            this.f.H();
        } else {
            h.warn("{} tried to set an invalid carried item", (Object)this.f.ah().getString());
            this.a(IChatBaseComponent.b("Invalid hotbar selection (Hacking?)"));
        }
    }

    @Override
    public void a(PacketPlayInChat packetplayinchat) {
        if (this.d.ag()) {
            return;
        }
        Optional<LastSeenMessages> optional = this.a(packetplayinchat.h());
        if (!optional.isEmpty()) {
            this.tryHandleChat(packetplayinchat.b(), () -> {
                PlayerChatMessage playerchatmessage;
                try {
                    playerchatmessage = this.a(packetplayinchat, (LastSeenMessages)optional.get());
                }
                catch (SignedMessageChain.a signedmessagechain_a) {
                    this.a(signedmessagechain_a);
                    return;
                }
                CompletionStage completablefuture = this.a(playerchatmessage.c()).thenApplyAsync(Function.identity(), (Executor)this.d.chatExecutor);
                IChatBaseComponent ichatbasecomponent = this.d.bm().decorate(this.f, playerchatmessage.d());
                this.S.append(completablefuture, filteredtext -> {
                    PlayerChatMessage playerchatmessage1 = playerchatmessage.a(ichatbasecomponent).a(filteredtext.e());
                    this.b(playerchatmessage1);
                });
            }, false);
        }
    }

    @Override
    public void a(ServerboundChatCommandPacket serverboundchatcommandpacket) {
        this.tryHandleChat(serverboundchatcommandpacket.b(), () -> {
            if (this.f.w()) {
                return;
            }
            this.b(serverboundchatcommandpacket.b());
            this.detectRateSpam("/" + serverboundchatcommandpacket.b());
        }, true);
    }

    private void b(String s2) {
        String command = "/" + s2;
        h.info(this.f.cB() + " issued server command: " + command);
        PlayerCommandPreprocessEvent event = new PlayerCommandPreprocessEvent((Player)this.getCraftPlayer(), command, (Set)new LazyPlayerSet(this.d));
        this.cserver.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        s2 = event.getMessage().substring(1);
        ParseResults<CommandListenerWrapper> parseresults = this.c(s2);
        if (this.d.aB() && SignableCommand.a(parseresults)) {
            h.error("Received unsigned command packet from {}, but the command requires signable arguments: {}", (Object)this.f.fX().getName(), (Object)s2);
            this.f.a(m);
        } else {
            this.d.aH().a(parseresults, s2);
        }
    }

    @Override
    public void a(ServerboundChatCommandSignedPacket serverboundchatcommandsignedpacket) {
        Optional<LastSeenMessages> optional = this.a(serverboundchatcommandsignedpacket.h());
        if (!optional.isEmpty()) {
            this.tryHandleChat(serverboundchatcommandsignedpacket.b(), () -> {
                if (this.f.w()) {
                    return;
                }
                this.a(serverboundchatcommandsignedpacket, (LastSeenMessages)optional.get());
                this.detectRateSpam("/" + serverboundchatcommandsignedpacket.b());
            }, true);
        }
    }

    private void a(ServerboundChatCommandSignedPacket serverboundchatcommandsignedpacket, LastSeenMessages lastseenmessages) {
        Map<String, PlayerChatMessage> map;
        Object command = "/" + serverboundchatcommandsignedpacket.b();
        h.info(this.f.cB() + " issued server command: " + (String)command);
        PlayerCommandPreprocessEvent event = new PlayerCommandPreprocessEvent((Player)this.getCraftPlayer(), (String)command, (Set)new LazyPlayerSet(this.d));
        this.cserver.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        command = event.getMessage().substring(1);
        ParseResults<CommandListenerWrapper> parseresults = this.c((String)command);
        try {
            map = serverboundchatcommandsignedpacket.b().equals(command) ? this.a(serverboundchatcommandsignedpacket, SignableCommand.b(parseresults), lastseenmessages) : Collections.emptyMap();
        }
        catch (SignedMessageChain.a signedmessagechain_a) {
            this.a(signedmessagechain_a);
            return;
        }
        CommandSigningContext.a commandsigningcontext_a = new CommandSigningContext.a(map);
        parseresults = net.minecraft.commands.CommandDispatcher.a(parseresults, commandlistenerwrapper -> commandlistenerwrapper.a(commandsigningcontext_a, this.S));
        this.d.aH().a(parseresults, (String)command);
    }

    private void a(SignedMessageChain.a signedmessagechain_a) {
        h.warn("Failed to update secure chat state for {}: '{}'", (Object)this.f.fX().getName(), (Object)signedmessagechain_a.a().getString());
        this.f.a(signedmessagechain_a.a().f().a(EnumChatFormat.m));
    }

    private <S> Map<String, PlayerChatMessage> a(ServerboundChatCommandSignedPacket serverboundchatcommandsignedpacket, SignableCommand<S> signablecommand, LastSeenMessages lastseenmessages) throws SignedMessageChain.a {
        SignableCommand.a signablecommand_a1;
        List<ArgumentSignatures.a> list = serverboundchatcommandsignedpacket.g().a();
        List<SignableCommand.a<S>> list1 = signablecommand.a();
        if (list.isEmpty()) {
            return this.b(list1);
        }
        Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap();
        for (ArgumentSignatures.a argumentsignatures_a : list) {
            SignableCommand.a<S> signablecommand_a = signablecommand.a(argumentsignatures_a.a());
            if (signablecommand_a == null) {
                this.P.setChainBroken();
                throw PlayerConnection.a(serverboundchatcommandsignedpacket.b(), list, list1);
            }
            SignedMessageBody signedmessagebody = new SignedMessageBody(signablecommand_a.c(), serverboundchatcommandsignedpacket.e(), serverboundchatcommandsignedpacket.f(), lastseenmessages);
            map.put(signablecommand_a.a(), this.P.unpack(argumentsignatures_a.b(), signedmessagebody));
        }
        Iterator<Record> iterator = list1.iterator();
        do {
            if (iterator.hasNext()) continue;
            return map;
        } while (map.containsKey((signablecommand_a1 = (SignableCommand.a)iterator.next()).a()));
        throw PlayerConnection.a(serverboundchatcommandsignedpacket.b(), list, list1);
    }

    private <S> Map<String, PlayerChatMessage> b(List<SignableCommand.a<S>> list) throws SignedMessageChain.a {
        HashMap<String, PlayerChatMessage> map = new HashMap<String, PlayerChatMessage>();
        for (SignableCommand.a<S> signablecommand_a : list) {
            SignedMessageBody signedmessagebody = SignedMessageBody.a(signablecommand_a.c());
            map.put(signablecommand_a.a(), this.P.unpack(null, signedmessagebody));
        }
        return map;
    }

    private static <S> SignedMessageChain.a a(String s2, List<ArgumentSignatures.a> list, List<SignableCommand.a<S>> list1) {
        String s1 = list.stream().map(ArgumentSignatures.a::a).collect(Collectors.joining(", "));
        String s22 = list1.stream().map(SignableCommand.a::a).collect(Collectors.joining(", "));
        h.error("Signed command mismatch between server and client ('{}'): got [{}] from client, but expected [{}]", new Object[]{s2, s1, s22});
        return new SignedMessageChain.a(m);
    }

    private ParseResults<CommandListenerWrapper> c(String s2) {
        CommandDispatcher<CommandListenerWrapper> com_mojang_brigadier_commanddispatcher = this.d.aH().a();
        return com_mojang_brigadier_commanddispatcher.parse(s2, this.f.dg());
    }

    private void tryHandleChat(String s2, Runnable runnable, boolean sync) {
        if (PlayerConnection.d(s2)) {
            this.a(IChatBaseComponent.c("multiplayer.disconnect.illegal_characters"));
        } else if (this.f.dJ() || this.f.E() == EnumChatVisibility.c) {
            this.b(new ClientboundSystemChatPacket(IChatBaseComponent.c("chat.disabled.options").a(EnumChatFormat.m), false));
        } else {
            this.f.H();
            if (sync) {
                this.d.execute(runnable);
            } else {
                runnable.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<LastSeenMessages> a(LastSeenMessages.b lastseenmessages_b) {
        LastSeenMessagesValidator lastseenmessagesvalidator = this.Q;
        LastSeenMessagesValidator lastSeenMessagesValidator = this.Q;
        synchronized (lastSeenMessagesValidator) {
            Optional<LastSeenMessages> optional = this.Q.a(lastseenmessages_b);
            if (optional.isEmpty()) {
                h.warn("Failed to validate message acknowledgements from {}", (Object)this.f.ah().getString());
                this.a(l);
            }
            return optional;
        }
    }

    private static boolean d(String s2) {
        for (int i2 = 0; i2 < s2.length(); ++i2) {
            if (UtilColor.a(s2.charAt(i2))) continue;
            return true;
        }
        return false;
    }

    public void chat(String s2, final PlayerChatMessage original, boolean async) {
        if (s2.isEmpty() || this.f.E() == EnumChatVisibility.c) {
            return;
        }
        OutgoingChatMessage outgoing = OutgoingChatMessage.a(original);
        if (!async && s2.startsWith("/")) {
            this.handleCommand(s2);
        } else if (this.f.E() != EnumChatVisibility.b) {
            CraftPlayer player = this.getCraftPlayer();
            AsyncPlayerChatEvent event = new AsyncPlayerChatEvent(async, (Player)player, s2, (Set)new LazyPlayerSet(this.d));
            final String originalFormat = event.getFormat();
            final String originalMessage = event.getMessage();
            this.cserver.getPluginManager().callEvent((Event)event);
            if (PlayerChatEvent.getHandlerList().getRegisteredListeners().length != 0) {
                final PlayerChatEvent queueEvent = new PlayerChatEvent((Player)player, event.getMessage(), event.getFormat(), event.getRecipients());
                queueEvent.setCancelled(event.isCancelled());
                Waitable waitable = new Waitable(){

                    protected Object evaluate() {
                        Bukkit.getPluginManager().callEvent((Event)queueEvent);
                        if (queueEvent.isCancelled()) {
                            return null;
                        }
                        String message = String.format(queueEvent.getFormat(), queueEvent.getPlayer().getDisplayName(), queueEvent.getMessage());
                        if (((LazyPlayerSet)queueEvent.getRecipients()).isLazy()) {
                            if (!SpigotConfig.bungee && originalFormat.equals(queueEvent.getFormat()) && originalMessage.equals(queueEvent.getMessage()) && queueEvent.getPlayer().getName().equalsIgnoreCase(queueEvent.getPlayer().getDisplayName())) {
                                PlayerConnection.this.d.ah().a(original, PlayerConnection.this.f, ChatMessageType.a(ChatMessageType.e, PlayerConnection.this.f));
                                return null;
                            }
                            for (EntityPlayer recipient : PlayerConnection.this.d.ah().l) {
                                recipient.getBukkitEntity().sendMessage(PlayerConnection.this.f.cz(), message);
                            }
                        } else {
                            for (Player player : queueEvent.getRecipients()) {
                                player.sendMessage(PlayerConnection.this.f.cz(), message);
                            }
                        }
                        PlayerConnection.this.d.console.sendMessage(message);
                        return null;
                    }
                };
                if (async) {
                    this.d.processQueue.add(waitable);
                } else {
                    waitable.run();
                }
                try {
                    waitable.get();
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException e3) {
                    throw new RuntimeException("Exception processing chat event", e3.getCause());
                }
            } else {
                if (event.isCancelled()) {
                    return;
                }
                s2 = String.format(event.getFormat(), event.getPlayer().getDisplayName(), event.getMessage());
                if (((LazyPlayerSet)event.getRecipients()).isLazy()) {
                    if (!SpigotConfig.bungee && originalFormat.equals(event.getFormat()) && originalMessage.equals(event.getMessage()) && event.getPlayer().getName().equalsIgnoreCase(event.getPlayer().getDisplayName())) {
                        this.d.ah().a(original, this.f, ChatMessageType.a(ChatMessageType.e, this.f));
                        return;
                    }
                    for (EntityPlayer recipient : this.d.ah().l) {
                        recipient.getBukkitEntity().sendMessage(this.f.cz(), s2);
                    }
                } else {
                    for (Player recipient : event.getRecipients()) {
                        recipient.sendMessage(this.f.cz(), s2);
                    }
                }
                this.d.console.sendMessage(s2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCommand(String s2) {
        SpigotTimings.playerCommandTimer.startTiming();
        if (SpigotConfig.logCommands) {
            h.info(this.f.cB() + " issued server command: " + s2);
        }
        CraftPlayer player = this.getCraftPlayer();
        PlayerCommandPreprocessEvent event = new PlayerCommandPreprocessEvent((Player)player, s2, (Set)new LazyPlayerSet(this.d));
        this.cserver.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            SpigotTimings.playerCommandTimer.stopTiming();
            return;
        }
        try {
            if (this.cserver.dispatchCommand((CommandSender)event.getPlayer(), event.getMessage().substring(1))) {
                return;
            }
        }
        catch (CommandException ex) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "An internal error occurred while attempting to perform this command");
            java.util.logging.Logger.getLogger(PlayerConnection.class.getName()).log(Level.SEVERE, null, ex);
            return;
        }
        finally {
            SpigotTimings.playerCommandTimer.stopTiming();
        }
    }

    private PlayerChatMessage a(PacketPlayInChat packetplayinchat, LastSeenMessages lastseenmessages) throws SignedMessageChain.a {
        SignedMessageBody signedmessagebody = new SignedMessageBody(packetplayinchat.b(), packetplayinchat.e(), packetplayinchat.f(), lastseenmessages);
        return this.P.unpack(packetplayinchat.g(), signedmessagebody);
    }

    private void b(PlayerChatMessage playerchatmessage) {
        String s2 = playerchatmessage.c();
        if (s2.isEmpty()) {
            h.warn(this.f.cB() + " tried to send an empty message");
        } else if (this.getCraftPlayer().isConversing()) {
            final String conversationInput = s2;
            this.d.processQueue.add(new Runnable(){

                @Override
                public void run() {
                    PlayerConnection.this.getCraftPlayer().acceptConversationInput(conversationInput);
                }
            });
        } else if (this.f.E() == EnumChatVisibility.b) {
            this.b(new ClientboundSystemChatPacket(IChatBaseComponent.c("chat.cannotSend").a(EnumChatFormat.m), false));
        } else {
            this.chat(s2, playerchatmessage, true);
        }
        this.detectRateSpam(s2);
    }

    private void detectRateSpam(String s2) {
        boolean counted = true;
        for (String exclude : SpigotConfig.spamExclusions) {
            if (exclude == null || !s2.startsWith(exclude)) continue;
            counted = false;
            break;
        }
        if (this.q.addAndGet(20) > 200 && !this.d.ah().f(this.f.fX()) && !this.d.a(this.f.fX())) {
            this.a(IChatBaseComponent.c("disconnect.spam"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void a(ServerboundChatAckPacket serverboundchatackpacket) {
        LastSeenMessagesValidator lastseenmessagesvalidator = this.Q;
        LastSeenMessagesValidator lastSeenMessagesValidator = this.Q;
        synchronized (lastSeenMessagesValidator) {
            if (!this.Q.a(serverboundchatackpacket.b())) {
                h.warn("Failed to validate message acknowledgements from {}", (Object)this.f.ah().getString());
                this.a(l);
            }
        }
    }

    @Override
    public void a(PacketPlayInArmAnimation packetplayinarmanimation) {
        PlayerConnectionUtils.a(packetplayinarmanimation, this, this.f.A());
        if (this.f.fc()) {
            return;
        }
        this.f.H();
        float f1 = this.f.dG();
        float f2 = this.f.dE();
        double d0 = this.f.dt();
        double d1 = this.f.dv() + (double)this.f.cL();
        double d2 = this.f.dz();
        Location origin = new Location((World)this.f.dO().getWorld(), d0, d1, d2, f2, f1);
        double d3 = Math.max(this.f.gy(), this.f.gz());
        RayTraceResult result = this.f.dO().getWorld().rayTrace(origin, origin.getDirection(), d3, FluidCollisionMode.NEVER, false, 0.1, entity -> {
            net.minecraft.world.entity.Entity handle = ((CraftEntity)entity).getHandle();
            return entity != this.f.getBukkitEntity() && this.f.getBukkitEntity().canSee((Entity)entity) && !handle.R_() && handle.bA() && !handle.y(this.f);
        });
        if (result == null) {
            CraftEventFactory.callPlayerInteractEvent(this.f, Action.LEFT_CLICK_AIR, this.f.fY().f(), EnumHand.a);
        }
        PlayerAnimationEvent event = new PlayerAnimationEvent((Player)this.getCraftPlayer(), packetplayinarmanimation.b() == EnumHand.a ? PlayerAnimationType.ARM_SWING : PlayerAnimationType.OFF_ARM_SWING);
        this.cserver.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        this.f.a(packetplayinarmanimation.b());
    }

    @Override
    public void a(PacketPlayInEntityAction packetplayinentityaction) {
        PlayerConnectionUtils.a(packetplayinentityaction, this, this.f.A());
        if (this.f.dJ()) {
            return;
        }
        switch (packetplayinentityaction.e()) {
            case a: 
            case b: {
                PlayerToggleSneakEvent event = new PlayerToggleSneakEvent((Player)this.getCraftPlayer(), packetplayinentityaction.e() == PacketPlayInEntityAction.EnumPlayerAction.a);
                this.cserver.getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) break;
                return;
            }
            case d: 
            case e: {
                PlayerToggleSprintEvent e2 = new PlayerToggleSprintEvent((Player)this.getCraftPlayer(), packetplayinentityaction.e() == PacketPlayInEntityAction.EnumPlayerAction.d);
                this.cserver.getPluginManager().callEvent((Event)e2);
                if (!e2.isCancelled()) break;
                return;
            }
        }
        this.f.H();
        switch (packetplayinentityaction.e()) {
            case a: {
                this.f.g(true);
                break;
            }
            case b: {
                this.f.g(false);
                break;
            }
            case d: {
                this.f.h(true);
                break;
            }
            case e: {
                this.f.h(false);
                break;
            }
            case c: {
                if (!this.f.fH()) break;
                this.f.a(false, true);
                this.F = this.f.dm();
                break;
            }
            case f: {
                net.minecraft.world.entity.Entity entity = this.f.dd();
                if (!(entity instanceof IJumpable)) break;
                IJumpable ijumpable = (IJumpable)((Object)entity);
                int i2 = packetplayinentityaction.f();
                if (!ijumpable.a() || i2 <= 0) break;
                ijumpable.c(i2);
                break;
            }
            case g: {
                net.minecraft.world.entity.Entity entity = this.f.dd();
                if (!(entity instanceof IJumpable)) break;
                IJumpable ijumpable = (IJumpable)((Object)entity);
                ijumpable.b();
                break;
            }
            case h: {
                net.minecraft.world.entity.Entity entity = this.f.dc();
                if (!(entity instanceof HasCustomInventoryScreen)) break;
                HasCustomInventoryScreen hascustominventoryscreen = (HasCustomInventoryScreen)((Object)entity);
                hascustominventoryscreen.b(this.f);
                break;
            }
            case i: {
                if (this.f.gd()) break;
                this.f.gf();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid client command!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(PlayerChatMessage playerchatmessage) {
        MessageSignature messagesignature = playerchatmessage.l();
        if (messagesignature != null) {
            int i2;
            this.R.a(playerchatmessage.m(), playerchatmessage.l());
            LastSeenMessagesValidator lastseenmessagesvalidator = this.Q;
            LastSeenMessagesValidator lastSeenMessagesValidator = this.Q;
            synchronized (lastSeenMessagesValidator) {
                this.Q.a(messagesignature);
                i2 = this.Q.a();
            }
            if (i2 > 4096) {
                this.a(IChatBaseComponent.c("multiplayer.disconnect.too_many_pending_chats"));
            }
        }
    }

    public void a(PlayerChatMessage playerchatmessage, ChatMessageType.a chatmessagetype_a) {
        if (!this.getCraftPlayer().canSeePlayer(playerchatmessage.k().c())) {
            this.a(playerchatmessage.d(), chatmessagetype_a);
            return;
        }
        this.b(new ClientboundPlayerChatPacket(playerchatmessage.k().c(), playerchatmessage.k().b(), playerchatmessage.l(), playerchatmessage.m().a(this.R), playerchatmessage.n(), playerchatmessage.o(), chatmessagetype_a));
        this.a(playerchatmessage);
    }

    public void a(IChatBaseComponent ichatbasecomponent, ChatMessageType.a chatmessagetype_a) {
        this.b(new ClientboundDisguisedChatPacket(ichatbasecomponent, chatmessagetype_a));
    }

    public SocketAddress m() {
        return this.e.d();
    }

    public SocketAddress getRawAddress() {
        return this.e.n.remoteAddress();
    }

    public void n() {
        this.T = true;
        this.q();
        this.b(ClientboundStartConfigurationPacket.a);
        this.e.a(ConfigurationProtocols.d);
    }

    @Override
    public void a(ServerboundPingRequestPacket serverboundpingrequestpacket) {
        this.e.a(new ClientboundPongResponsePacket(serverboundpingrequestpacket.b()));
    }

    @Override
    public void a(PacketPlayInUseEntity packetplayinuseentity) {
        PlayerConnectionUtils.a(packetplayinuseentity, this, this.f.A());
        if (this.f.fc()) {
            return;
        }
        final WorldServer worldserver = this.f.A();
        final net.minecraft.world.entity.Entity entity = packetplayinuseentity.a(worldserver);
        if (entity == this.f && !this.f.R_()) {
            this.a(IChatBaseComponent.b("Cannot interact with self!"));
            return;
        }
        this.f.H();
        this.f.g(packetplayinuseentity.b());
        if (entity != null) {
            if (!worldserver.C_().a(entity.do())) {
                return;
            }
            AxisAlignedBB axisalignedbb = entity.cK();
            if (this.f.a(axisalignedbb, 1.0)) {
                packetplayinuseentity.a(new PacketPlayInUseEntity.c(){

                    private void performInteraction(EnumHand enumhand, a playerconnection_a, PlayerInteractEntityEvent event) {
                        ItemStack itemstack = PlayerConnection.this.f.b(enumhand);
                        if (itemstack.a(worldserver.J())) {
                            ItemStack itemstack1 = itemstack.s();
                            ItemStack itemInHand = PlayerConnection.this.f.b(enumhand);
                            boolean triggerLeashUpdate = itemInHand != null && itemInHand.g() == Items.uK && entity instanceof EntityInsentient;
                            Item origItem = PlayerConnection.this.f.fY().f() == null ? null : PlayerConnection.this.f.fY().f().g();
                            PlayerConnection.this.cserver.getPluginManager().callEvent((Event)event);
                            if (entity instanceof Bucketable && entity instanceof EntityLiving && origItem != null && origItem.r() == Items.qz && (event.isCancelled() || PlayerConnection.this.f.fY().f() == null || PlayerConnection.this.f.fY().f().g() != origItem)) {
                                entity.getBukkitEntity().update(PlayerConnection.this.f);
                                PlayerConnection.this.f.cd.b();
                            }
                            if (triggerLeashUpdate && (event.isCancelled() || PlayerConnection.this.f.fY().f() == null || PlayerConnection.this.f.fY().f().g() != origItem)) {
                                PlayerConnection.this.b(new PacketPlayOutAttachEntity(entity, ((EntityInsentient)entity).A()));
                            }
                            if (event.isCancelled() || PlayerConnection.this.f.fY().f() == null || PlayerConnection.this.f.fY().f().g() != origItem) {
                                entity.refreshEntityData(PlayerConnection.this.f);
                                if (entity instanceof Allay) {
                                    PlayerConnection.this.b(new PacketPlayOutEntityEquipment(entity.an(), Arrays.stream(EnumItemSlot.values()).map(slot -> Pair.of((Object)slot, (Object)((EntityLiving)entity).a((EnumItemSlot)slot).s())).collect(Collectors.toList())));
                                    PlayerConnection.this.f.cd.b();
                                }
                            }
                            if (event.isCancelled()) {
                                return;
                            }
                            EnumInteractionResult enuminteractionresult = playerconnection_a.run(PlayerConnection.this.f, entity, enumhand);
                            if (!itemInHand.e() && itemInHand.H() <= -1) {
                                PlayerConnection.this.f.cd.b();
                            }
                            if (enuminteractionresult.a()) {
                                CriterionTriggers.T.a(PlayerConnection.this.f, enuminteractionresult.c() ? itemstack1 : ItemStack.l, entity);
                                if (enuminteractionresult.b()) {
                                    PlayerConnection.this.f.a(enumhand, true);
                                }
                            }
                        }
                    }

                    @Override
                    public void a(EnumHand enumhand) {
                        this.performInteraction(enumhand, EntityHuman::a, new PlayerInteractEntityEvent((Player)PlayerConnection.this.getCraftPlayer(), (Entity)entity.getBukkitEntity(), enumhand == EnumHand.b ? EquipmentSlot.OFF_HAND : EquipmentSlot.HAND));
                    }

                    @Override
                    public void a(EnumHand enumhand, Vec3D vec3d) {
                        this.performInteraction(enumhand, (entityplayer, entity1, enumhand1) -> entity1.a(entityplayer, vec3d, enumhand1), (PlayerInteractEntityEvent)new PlayerInteractAtEntityEvent((Player)PlayerConnection.this.getCraftPlayer(), (Entity)entity.getBukkitEntity(), new Vector(vec3d.c, vec3d.d, vec3d.e), enumhand == EnumHand.b ? EquipmentSlot.OFF_HAND : EquipmentSlot.HAND));
                    }

                    @Override
                    public void a() {
                        EntityArrow entityarrow;
                        if (!(entity instanceof EntityItem || entity instanceof EntityExperienceOrb || entity == PlayerConnection.this.f && !PlayerConnection.this.f.R_() || entity instanceof EntityArrow && !(entityarrow = (EntityArrow)entity).cu())) {
                            ItemStack itemstack = PlayerConnection.this.f.b(EnumHand.a);
                            if (!itemstack.a(worldserver.J())) {
                                return;
                            }
                            PlayerConnection.this.f.e(entity);
                            if (!itemstack.e() && itemstack.H() <= -1) {
                                PlayerConnection.this.f.cd.b();
                            }
                            return;
                        }
                        PlayerConnection.this.a(IChatBaseComponent.c("multiplayer.disconnect.invalid_entity_attacked"));
                        h.warn("Player {} tried to attack an invalid entity", (Object)PlayerConnection.this.f.ah().getString());
                    }
                });
            }
        }
    }

    @Override
    public void a(PacketPlayInClientCommand packetplayinclientcommand) {
        PlayerConnectionUtils.a(packetplayinclientcommand, this, this.f.A());
        this.f.H();
        PacketPlayInClientCommand.EnumClientCommand packetplayinclientcommand_enumclientcommand = packetplayinclientcommand.b();
        switch (packetplayinclientcommand_enumclientcommand) {
            case a: {
                if (this.f.h) {
                    this.f.h = false;
                    this.f = this.d.ah().respawn(this.f, true, Entity.RemovalReason.e, PlayerRespawnEvent.RespawnReason.END_PORTAL);
                    CriterionTriggers.w.a(this.f, net.minecraft.world.level.World.j, net.minecraft.world.level.World.h);
                    break;
                }
                if (this.f.ew() > 0.0f) {
                    return;
                }
                this.f = this.d.ah().respawn(this.f, false, Entity.RemovalReason.a, PlayerRespawnEvent.RespawnReason.DEATH);
                if (!this.d.j()) break;
                this.f.a(EnumGamemode.d);
                this.f.dO().ab().a(GameRules.r).set(false, this.f.A());
                break;
            }
            case b: {
                this.f.I().a(this.f);
            }
        }
    }

    @Override
    public void a(PacketPlayInCloseWindow packetplayinclosewindow) {
        PlayerConnectionUtils.a(packetplayinclosewindow, this, this.f.A());
        if (this.f.fc()) {
            return;
        }
        CraftEventFactory.handleInventoryCloseEvent(this.f);
        this.f.t();
    }

    @Override
    public void a(PacketPlayInWindowClick packetplayinwindowclick) {
        PlayerConnectionUtils.a(packetplayinwindowclick, this, this.f.A());
        if (this.f.fc()) {
            return;
        }
        this.f.H();
        if (this.f.cd.j == packetplayinwindowclick.b() && this.f.cd.b(this.f)) {
            boolean cancelled = this.f.R_();
            if (!this.f.cd.b(this.f)) {
                h.debug("Player {} interacted with invalid menu {}", (Object)this.f, (Object)this.f.cd);
            } else {
                int i2 = packetplayinwindowclick.e();
                if (!this.f.cd.a(i2)) {
                    h.debug("Player {} clicked invalid slot index: {}, available slots: {}", new Object[]{this.f.ah(), i2, this.f.cd.i.size()});
                } else {
                    boolean flag = packetplayinwindowclick.j() != this.f.cd.j();
                    this.f.cd.h();
                    if (packetplayinwindowclick.e() < -1 && packetplayinwindowclick.e() != -999) {
                        return;
                    }
                    InventoryView inventory = this.f.cd.getBukkitView();
                    InventoryType.SlotType type = inventory.getSlotType(packetplayinwindowclick.e());
                    ClickType click = ClickType.UNKNOWN;
                    InventoryAction action = InventoryAction.UNKNOWN;
                    ItemStack itemstack = ItemStack.l;
                    switch (packetplayinwindowclick.i()) {
                        case a: {
                            if (packetplayinwindowclick.f() == 0) {
                                click = ClickType.LEFT;
                            } else if (packetplayinwindowclick.f() == 1) {
                                click = ClickType.RIGHT;
                            }
                            if (packetplayinwindowclick.f() != 0 && packetplayinwindowclick.f() != 1) break;
                            action = InventoryAction.NOTHING;
                            if (packetplayinwindowclick.e() == -999) {
                                if (this.f.cd.g().e()) break;
                                action = packetplayinwindowclick.f() == 0 ? InventoryAction.DROP_ALL_CURSOR : InventoryAction.DROP_ONE_CURSOR;
                                break;
                            }
                            if (packetplayinwindowclick.e() < 0) {
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            Slot slot = this.f.cd.b(packetplayinwindowclick.e());
                            if (slot == null) break;
                            ItemStack clickedItem = slot.g();
                            ItemStack cursor = this.f.cd.g();
                            if (clickedItem.e()) {
                                if (cursor.e()) break;
                                action = packetplayinwindowclick.f() == 0 ? InventoryAction.PLACE_ALL : InventoryAction.PLACE_ONE;
                                break;
                            }
                            if (!slot.a(this.f)) break;
                            if (cursor.e()) {
                                action = packetplayinwindowclick.f() == 0 ? InventoryAction.PICKUP_ALL : InventoryAction.PICKUP_HALF;
                                break;
                            }
                            if (slot.a(cursor)) {
                                if (ItemStack.c(clickedItem, cursor)) {
                                    int toPlace = packetplayinwindowclick.f() == 0 ? cursor.H() : 1;
                                    toPlace = Math.min(toPlace, clickedItem.j() - clickedItem.H());
                                    if ((toPlace = Math.min(toPlace, slot.c.al_() - clickedItem.H())) == 1) {
                                        action = InventoryAction.PLACE_ONE;
                                        break;
                                    }
                                    if (toPlace == cursor.H()) {
                                        action = InventoryAction.PLACE_ALL;
                                        break;
                                    }
                                    if (toPlace < 0) {
                                        action = toPlace != -1 ? InventoryAction.PICKUP_SOME : InventoryAction.PICKUP_ONE;
                                        break;
                                    }
                                    if (toPlace == 0) break;
                                    action = InventoryAction.PLACE_SOME;
                                    break;
                                }
                                if (cursor.H() > slot.a()) break;
                                action = InventoryAction.SWAP_WITH_CURSOR;
                                break;
                            }
                            if (!ItemStack.c(cursor, clickedItem) || clickedItem.H() < 0 || clickedItem.H() + cursor.H() > cursor.j()) break;
                            action = InventoryAction.PICKUP_ALL;
                            break;
                        }
                        case b: {
                            if (packetplayinwindowclick.f() == 0) {
                                click = ClickType.SHIFT_LEFT;
                            } else if (packetplayinwindowclick.f() == 1) {
                                click = ClickType.SHIFT_RIGHT;
                            }
                            if (packetplayinwindowclick.f() != 0 && packetplayinwindowclick.f() != 1) break;
                            if (packetplayinwindowclick.e() < 0) {
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            Slot slot = this.f.cd.b(packetplayinwindowclick.e());
                            if (slot != null && slot.a(this.f) && slot.h()) {
                                action = InventoryAction.MOVE_TO_OTHER_INVENTORY;
                                break;
                            }
                            action = InventoryAction.NOTHING;
                            break;
                        }
                        case c: {
                            if ((packetplayinwindowclick.f() < 0 || packetplayinwindowclick.f() >= 9) && packetplayinwindowclick.f() != 40) break;
                            click = packetplayinwindowclick.f() == 40 ? ClickType.SWAP_OFFHAND : ClickType.NUMBER_KEY;
                            Slot clickedSlot = this.f.cd.b(packetplayinwindowclick.e());
                            if (clickedSlot.a(this.f)) {
                                boolean canCleanSwap;
                                ItemStack hotbar = this.f.fY().a(packetplayinwindowclick.f());
                                boolean bl = canCleanSwap = hotbar.e() || clickedSlot.c == this.f.fY() && clickedSlot.a(hotbar);
                                if (clickedSlot.h()) {
                                    if (canCleanSwap) {
                                        action = InventoryAction.HOTBAR_SWAP;
                                        break;
                                    }
                                    action = InventoryAction.HOTBAR_MOVE_AND_READD;
                                    break;
                                }
                                if (!clickedSlot.h() && !hotbar.e() && clickedSlot.a(hotbar)) {
                                    action = InventoryAction.HOTBAR_SWAP;
                                    break;
                                }
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            action = InventoryAction.NOTHING;
                            break;
                        }
                        case d: {
                            Slot slot;
                            if (packetplayinwindowclick.f() == 2) {
                                click = ClickType.MIDDLE;
                                if (packetplayinwindowclick.e() < 0) {
                                    action = InventoryAction.NOTHING;
                                    break;
                                }
                                slot = this.f.cd.b(packetplayinwindowclick.e());
                                if (slot != null && slot.h() && this.f.fZ().d && this.f.cd.g().e()) {
                                    action = InventoryAction.CLONE_STACK;
                                    break;
                                }
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            click = ClickType.UNKNOWN;
                            action = InventoryAction.UNKNOWN;
                            break;
                        }
                        case e: {
                            Slot slot;
                            if (packetplayinwindowclick.e() >= 0) {
                                if (packetplayinwindowclick.f() == 0) {
                                    click = ClickType.DROP;
                                    slot = this.f.cd.b(packetplayinwindowclick.e());
                                    if (slot != null && slot.h() && slot.a(this.f) && !slot.g().e() && slot.g().g() != Item.a(Blocks.a)) {
                                        action = InventoryAction.DROP_ONE_SLOT;
                                        break;
                                    }
                                    action = InventoryAction.NOTHING;
                                    break;
                                }
                                if (packetplayinwindowclick.f() != 1) break;
                                click = ClickType.CONTROL_DROP;
                                slot = this.f.cd.b(packetplayinwindowclick.e());
                                if (slot != null && slot.h() && slot.a(this.f) && !slot.g().e() && slot.g().g() != Item.a(Blocks.a)) {
                                    action = InventoryAction.DROP_ALL_SLOT;
                                    break;
                                }
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            click = ClickType.LEFT;
                            if (packetplayinwindowclick.f() == 1) {
                                click = ClickType.RIGHT;
                            }
                            action = InventoryAction.NOTHING;
                            break;
                        }
                        case f: {
                            this.f.cd.a(packetplayinwindowclick.e(), packetplayinwindowclick.f(), packetplayinwindowclick.i(), this.f);
                            break;
                        }
                        case g: {
                            click = ClickType.DOUBLE_CLICK;
                            action = InventoryAction.NOTHING;
                            if (packetplayinwindowclick.e() < 0 || this.f.cd.g().e()) break;
                            ItemStack cursor = this.f.cd.g();
                            action = InventoryAction.NOTHING;
                            if (!inventory.getTopInventory().contains(CraftItemType.minecraftToBukkit(cursor.g())) && !inventory.getBottomInventory().contains(CraftItemType.minecraftToBukkit(cursor.g()))) break;
                            action = InventoryAction.COLLECT_TO_CURSOR;
                            break;
                        }
                    }
                    if (packetplayinwindowclick.i() != InventoryClickType.f) {
                        org.bukkit.inventory.ItemStack result;
                        Recipe recipe;
                        InventoryClickEvent event = click == ClickType.NUMBER_KEY ? new InventoryClickEvent(inventory, type, packetplayinwindowclick.e(), click, action, packetplayinwindowclick.f()) : new InventoryClickEvent(inventory, type, packetplayinwindowclick.e(), click, action);
                        Inventory top = inventory.getTopInventory();
                        if (packetplayinwindowclick.e() == 0 && top instanceof CraftingInventory && (recipe = ((CraftingInventory)top).getRecipe()) != null) {
                            event = click == ClickType.NUMBER_KEY ? new CraftItemEvent(recipe, inventory, type, packetplayinwindowclick.e(), click, action, packetplayinwindowclick.f()) : new CraftItemEvent(recipe, inventory, type, packetplayinwindowclick.e(), click, action);
                        }
                        if (packetplayinwindowclick.e() == 3 && top instanceof SmithingInventory && (result = ((SmithingInventory)top).getResult()) != null) {
                            event = click == ClickType.NUMBER_KEY ? new SmithItemEvent(inventory, type, packetplayinwindowclick.e(), click, action, packetplayinwindowclick.f()) : new SmithItemEvent(inventory, type, packetplayinwindowclick.e(), click, action);
                        }
                        event.setCancelled(cancelled);
                        Container oldContainer = this.f.cd;
                        this.cserver.getPluginManager().callEvent((Event)event);
                        if (this.f.cd != oldContainer) {
                            return;
                        }
                        block9 : switch (event.getResult()) {
                            case ALLOW: 
                            case DEFAULT: {
                                this.f.cd.a(i2, packetplayinwindowclick.f(), packetplayinwindowclick.i(), this.f);
                                break;
                            }
                            case DENY: {
                                switch (action) {
                                    case PICKUP_ALL: 
                                    case MOVE_TO_OTHER_INVENTORY: 
                                    case HOTBAR_MOVE_AND_READD: 
                                    case HOTBAR_SWAP: 
                                    case COLLECT_TO_CURSOR: 
                                    case UNKNOWN: {
                                        this.f.cd.b();
                                        break block9;
                                    }
                                    case PICKUP_SOME: 
                                    case PICKUP_HALF: 
                                    case PICKUP_ONE: 
                                    case PLACE_ALL: 
                                    case PLACE_SOME: 
                                    case PLACE_ONE: 
                                    case SWAP_WITH_CURSOR: {
                                        this.f.c.b(new PacketPlayOutSetSlot(-1, -1, this.f.cc.k(), this.f.cd.g()));
                                        this.f.c.b(new PacketPlayOutSetSlot(this.f.cd.j, this.f.cc.k(), packetplayinwindowclick.e(), this.f.cd.b(packetplayinwindowclick.e()).g()));
                                        break block9;
                                    }
                                    case DROP_ALL_SLOT: 
                                    case DROP_ONE_SLOT: {
                                        this.f.c.b(new PacketPlayOutSetSlot(this.f.cd.j, this.f.cc.k(), packetplayinwindowclick.e(), this.f.cd.b(packetplayinwindowclick.e()).g()));
                                        break block9;
                                    }
                                    case DROP_ALL_CURSOR: 
                                    case DROP_ONE_CURSOR: 
                                    case CLONE_STACK: {
                                        this.f.c.b(new PacketPlayOutSetSlot(-1, -1, this.f.cc.k(), this.f.cd.g()));
                                        break block9;
                                    }
                                }
                            }
                        }
                        if (event instanceof CraftItemEvent || event instanceof SmithItemEvent) {
                            this.f.cd.b();
                        }
                    }
                    for (Int2ObjectMap.Entry entry : Int2ObjectMaps.fastIterable(packetplayinwindowclick.h())) {
                        this.f.cd.b(entry.getIntKey(), (ItemStack)entry.getValue());
                    }
                    this.f.cd.a(packetplayinwindowclick.g());
                    this.f.cd.i();
                    if (flag) {
                        this.f.cd.e();
                    } else {
                        this.f.cd.d();
                    }
                }
            }
        }
    }

    @Override
    public void a(PacketPlayInAutoRecipe packetplayinautorecipe) {
        PlayerConnectionUtils.a(packetplayinautorecipe, this, this.f.A());
        this.f.H();
        if (!this.f.R_() && this.f.cd.j == packetplayinautorecipe.b() && this.f.cd instanceof ContainerRecipeBook) {
            if (!this.f.cd.b(this.f)) {
                h.debug("Player {} interacted with invalid menu {}", (Object)this.f, (Object)this.f.cd);
            } else {
                Recipe recipe = this.cserver.getRecipe(CraftNamespacedKey.fromMinecraft(packetplayinautorecipe.e()));
                if (recipe == null) {
                    return;
                }
                PlayerRecipeBookClickEvent event = CraftEventFactory.callRecipeBookClickEvent(this.f, recipe, packetplayinautorecipe.f());
                this.d.aJ().a(CraftNamespacedKey.toMinecraft(((Keyed)event.getRecipe()).getKey())).ifPresent(recipeholder -> ((ContainerRecipeBook)this.f.cd).a(event.isShiftClick(), (RecipeHolder<?>)recipeholder, this.f));
            }
        }
    }

    @Override
    public void a(PacketPlayInEnchantItem packetplayinenchantitem) {
        PlayerConnectionUtils.a(packetplayinenchantitem, this, this.f.A());
        if (this.f.fc()) {
            return;
        }
        this.f.H();
        if (this.f.cd.j == packetplayinenchantitem.b() && !this.f.R_()) {
            if (!this.f.cd.b(this.f)) {
                h.debug("Player {} interacted with invalid menu {}", (Object)this.f, (Object)this.f.cd);
            } else {
                boolean flag = this.f.cd.a((EntityHuman)this.f, packetplayinenchantitem.e());
                if (flag) {
                    this.f.cd.d();
                }
            }
        }
    }

    @Override
    public void a(PacketPlayInSetCreativeSlot packetplayinsetcreativeslot) {
        PlayerConnectionUtils.a(packetplayinsetcreativeslot, this, this.f.A());
        if (this.f.e.e()) {
            boolean flag2;
            boolean flag = packetplayinsetcreativeslot.b() < 0;
            ItemStack itemstack = packetplayinsetcreativeslot.e();
            if (!itemstack.a(this.f.dO().J())) {
                return;
            }
            CustomData customdata = itemstack.a(DataComponents.O, CustomData.a);
            if (customdata.a("x") && customdata.a("y") && customdata.a("z") && this.f.getBukkitEntity().hasPermission("minecraft.nbt.copy")) {
                TileEntity tileentity;
                BlockPosition blockposition = TileEntity.b(customdata.d());
                if (this.f.dO().p(blockposition) && (tileentity = this.f.dO().c_(blockposition)) != null) {
                    tileentity.a(itemstack, (HolderLookup.a)this.f.dO().H_());
                }
            }
            boolean flag1 = packetplayinsetcreativeslot.b() >= 1 && packetplayinsetcreativeslot.b() <= 45;
            boolean bl = flag2 = itemstack.e() || itemstack.H() <= itemstack.j();
            if (flag || flag1 && !ItemStack.a(this.f.cc.b(packetplayinsetcreativeslot.b()).g(), packetplayinsetcreativeslot.e())) {
                CraftInventoryView inventory = this.f.cc.getBukkitView();
                org.bukkit.inventory.ItemStack item = CraftItemStack.asBukkitCopy(packetplayinsetcreativeslot.e());
                InventoryType.SlotType type = InventoryType.SlotType.QUICKBAR;
                if (flag) {
                    type = InventoryType.SlotType.OUTSIDE;
                } else if (packetplayinsetcreativeslot.b() < 36) {
                    type = packetplayinsetcreativeslot.b() >= 5 && packetplayinsetcreativeslot.b() < 9 ? InventoryType.SlotType.ARMOR : InventoryType.SlotType.CONTAINER;
                }
                InventoryCreativeEvent event = new InventoryCreativeEvent((InventoryView)inventory, type, flag ? -999 : (int)packetplayinsetcreativeslot.b(), item);
                this.cserver.getPluginManager().callEvent((Event)event);
                itemstack = CraftItemStack.asNMSCopy(event.getCursor());
                switch (event.getResult()) {
                    case ALLOW: {
                        flag2 = true;
                        break;
                    }
                    case DEFAULT: {
                        break;
                    }
                    case DENY: {
                        if (packetplayinsetcreativeslot.b() >= 0) {
                            this.f.c.b(new PacketPlayOutSetSlot(this.f.cc.j, this.f.cc.k(), packetplayinsetcreativeslot.b(), this.f.cc.b(packetplayinsetcreativeslot.b()).g()));
                            this.f.c.b(new PacketPlayOutSetSlot(-1, this.f.cc.k(), -1, ItemStack.l));
                        }
                        return;
                    }
                }
            }
            if (flag1 && flag2) {
                this.f.cc.b(packetplayinsetcreativeslot.b()).e(itemstack);
                this.f.cc.d();
            } else if (flag && flag2 && this.r < 200) {
                this.r += 20;
                this.f.a(itemstack, true);
            }
        }
    }

    @Override
    public void a(PacketPlayInUpdateSign packetplayinupdatesign) {
        List<String> list = Stream.of(packetplayinupdatesign.f()).map(EnumChatFormat::a).collect(Collectors.toList());
        this.a(list).thenAcceptAsync(list1 -> this.a(packetplayinupdatesign, (List<FilteredText>)list1), (Executor)this.d);
    }

    private void a(PacketPlayInUpdateSign packetplayinupdatesign, List<FilteredText> list) {
        if (this.f.fc()) {
            return;
        }
        this.f.H();
        WorldServer worldserver = this.f.A();
        BlockPosition blockposition = packetplayinupdatesign.b();
        if (worldserver.B(blockposition)) {
            TileEntity tileentity = worldserver.c_(blockposition);
            if (!(tileentity instanceof TileEntitySign)) {
                return;
            }
            TileEntitySign tileentitysign = (TileEntitySign)tileentity;
            tileentitysign.a((EntityHuman)this.f, packetplayinupdatesign.e(), list);
        }
    }

    @Override
    public void a(PacketPlayInAbilities packetplayinabilities) {
        PlayerConnectionUtils.a(packetplayinabilities, this, this.f.A());
        if (this.f.fZ().c && this.f.fZ().b != packetplayinabilities.b()) {
            PlayerToggleFlightEvent event = new PlayerToggleFlightEvent((Player)this.f.getBukkitEntity(), packetplayinabilities.b());
            this.cserver.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                this.f.fZ().b = packetplayinabilities.b();
            } else {
                this.f.z();
            }
        }
    }

    @Override
    public void a(ServerboundClientInformationPacket serverboundclientinformationpacket) {
        PlayerConnectionUtils.a(serverboundclientinformationpacket, this, this.f.A());
        this.f.a(serverboundclientinformationpacket.b());
    }

    @Override
    public void a(PacketPlayInDifficultyChange packetplayindifficultychange) {
        PlayerConnectionUtils.a(packetplayindifficultychange, this, this.f.A());
        if (this.f.l(2) || this.h()) {
            this.d.a(packetplayindifficultychange.b(), false);
        }
    }

    @Override
    public void a(PacketPlayInDifficultyLock packetplayindifficultylock) {
        PlayerConnectionUtils.a(packetplayindifficultylock, this, this.f.A());
        if (this.f.l(2) || this.h()) {
            this.d.b(packetplayindifficultylock.b());
        }
    }

    @Override
    public void a(ServerboundChatSessionUpdatePacket serverboundchatsessionupdatepacket) {
        PlayerConnectionUtils.a(serverboundchatsessionupdatepacket, this, this.f.A());
        RemoteChatSession.a remotechatsession_a = serverboundchatsessionupdatepacket.b();
        ProfilePublicKey.a profilepublickey_a = this.O != null ? this.O.d().b() : null;
        ProfilePublicKey.a profilepublickey_a1 = remotechatsession_a.b();
        if (!Objects.equals(profilepublickey_a, profilepublickey_a1)) {
            if (profilepublickey_a != null && profilepublickey_a1.b().isBefore(profilepublickey_a.b())) {
                this.a(ProfilePublicKey.a);
            } else {
                try {
                    SignatureValidator signaturevalidator = this.d.as();
                    if (signaturevalidator == null) {
                        h.warn("Ignoring chat session from {} due to missing Services public key", (Object)this.f.fX().getName());
                        return;
                    }
                    this.a(remotechatsession_a.a(this.f.fX(), signaturevalidator));
                }
                catch (ProfilePublicKey.b profilepublickey_b) {
                    h.error("Failed to validate profile key: {}", (Object)profilepublickey_b.getMessage());
                    this.a(profilepublickey_b.a());
                }
            }
        }
    }

    @Override
    public void a(ServerboundConfigurationAcknowledgedPacket serverboundconfigurationacknowledgedpacket) {
        if (!this.T) {
            throw new IllegalStateException("Client acknowledged config, but none was requested");
        }
        this.e.a(ConfigurationProtocols.b, new ServerConfigurationPacketListenerImpl(this.d, this.e, this.a(this.f.C()), this.f));
    }

    @Override
    public void a(ServerboundChunkBatchReceivedPacket serverboundchunkbatchreceivedpacket) {
        PlayerConnectionUtils.a(serverboundchunkbatchreceivedpacket, this, this.f.A());
        this.g.a(serverboundchunkbatchreceivedpacket.b());
    }

    @Override
    public void a(ServerboundDebugSampleSubscriptionPacket serverbounddebugsamplesubscriptionpacket) {
        PlayerConnectionUtils.a(serverbounddebugsamplesubscriptionpacket, this, this.f.A());
        this.d.a(this.f, serverbounddebugsamplesubscriptionpacket.b());
    }

    private void a(RemoteChatSession remotechatsession) {
        this.O = remotechatsession;
        this.P = remotechatsession.a(this.f.cz());
        this.S.append(() -> {
            this.f.a(remotechatsession);
            this.d.ah().a(new ClientboundPlayerInfoUpdatePacket(EnumSet.of(ClientboundPlayerInfoUpdatePacket.a.b), List.of(this.f)));
        });
    }

    @Override
    public EntityPlayer o() {
        return this.f;
    }

    @FunctionalInterface
    private static interface a {
        public EnumInteractionResult run(EntityPlayer var1, net.minecraft.world.entity.Entity var2, EnumHand var3);
    }
}

