/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.metadata.ResourcePackMetaParser;
import net.minecraft.server.packs.resources.IoSupplier;

public class CompositePackResources
implements IResourcePack {
    private final IResourcePack c;
    private final List<IResourcePack> d;

    public CompositePackResources(IResourcePack var0, List<IResourcePack> var1) {
        this.c = var0;
        ArrayList<IResourcePack> var2 = new ArrayList<IResourcePack>(var1.size() + 1);
        var2.addAll(Lists.reverse(var1));
        var2.add(var0);
        this.d = List.copyOf(var2);
    }

    @Override
    @Nullable
    public IoSupplier<InputStream> a(String ... var0) {
        return this.c.a(var0);
    }

    @Override
    @Nullable
    public IoSupplier<InputStream> a(EnumResourcePackType var0, MinecraftKey var1) {
        for (IResourcePack var3 : this.d) {
            IoSupplier<InputStream> var4 = var3.a(var0, var1);
            if (var4 == null) continue;
            return var4;
        }
        return null;
    }

    @Override
    public void a(EnumResourcePackType var0, String var1, String var2, IResourcePack.a var3) {
        HashMap<MinecraftKey, IoSupplier<InputStream>> var4 = new HashMap<MinecraftKey, IoSupplier<InputStream>>();
        for (IResourcePack var6 : this.d) {
            var6.a(var0, var1, var2, var4::putIfAbsent);
        }
        var4.forEach(var3);
    }

    @Override
    public Set<String> a(EnumResourcePackType var0) {
        HashSet<String> var1 = new HashSet<String>();
        for (IResourcePack var3 : this.d) {
            var1.addAll(var3.a(var0));
        }
        return var1;
    }

    @Override
    @Nullable
    public <T> T a(ResourcePackMetaParser<T> var0) throws IOException {
        return this.c.a(var0);
    }

    @Override
    public PackLocationInfo a() {
        return this.c.a();
    }

    @Override
    public void close() {
        this.d.forEach(IResourcePack::close);
    }
}

