/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import jline.console.completer.Completer;
import net.minecraft.EnumChatFormat;
import net.minecraft.FileUtils;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.OutgoingChatMessage;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundUpdateTagsPacket;
import net.minecraft.network.protocol.game.ClientboundInitializeBorderPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderCenterPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderLerpSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDelayPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDistancePacket;
import net.minecraft.network.protocol.game.ClientboundSetSimulationDistancePacket;
import net.minecraft.network.protocol.game.GameProtocols;
import net.minecraft.network.protocol.game.PacketPlayOutAbilities;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutExperience;
import net.minecraft.network.protocol.game.PacketPlayOutGameStateChange;
import net.minecraft.network.protocol.game.PacketPlayOutHeldItemSlot;
import net.minecraft.network.protocol.game.PacketPlayOutLogin;
import net.minecraft.network.protocol.game.PacketPlayOutNamedSoundEffect;
import net.minecraft.network.protocol.game.PacketPlayOutRecipeUpdate;
import net.minecraft.network.protocol.game.PacketPlayOutRespawn;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardTeam;
import net.minecraft.network.protocol.game.PacketPlayOutServerDifficulty;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnPosition;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateTime;
import net.minecraft.network.protocol.game.PacketPlayOutViewDistance;
import net.minecraft.network.protocol.status.ServerPing;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.AdvancementDataPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.network.LoginListener;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.server.players.GameProfileBanEntry;
import net.minecraft.server.players.GameProfileBanList;
import net.minecraft.server.players.IpBanEntry;
import net.minecraft.server.players.IpBanList;
import net.minecraft.server.players.OpList;
import net.minecraft.server.players.OpListEntry;
import net.minecraft.server.players.UserCache;
import net.minecraft.server.players.WhiteList;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.ServerStatisticManager;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagNetworkSerialization;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.border.IWorldBorderListener;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.level.storage.SavedFile;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.level.storage.WorldNBTStorage;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.DisplaySlot;
import net.minecraft.world.scores.ScoreboardObjective;
import net.minecraft.world.scores.ScoreboardTeam;
import org.bukkit.Location;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R1.CraftServer;
import org.bukkit.craftbukkit.v1_21_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R1.command.ColouredConsoleSender;
import org.bukkit.craftbukkit.v1_21_R1.command.ConsoleCommandCompleter;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftLocation;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerSpawnChangeEvent;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;
import org.spigotmc.event.player.PlayerSpawnLocationEvent;

public abstract class PlayerList {
    public static final File a = new File("banned-players.json");
    public static final File b = new File("banned-ips.json");
    public static final File c = new File("ops.json");
    public static final File d = new File("whitelist.json");
    public static final IChatBaseComponent e = IChatBaseComponent.c("chat.filtered_full");
    public static final IChatBaseComponent f = IChatBaseComponent.c("multiplayer.disconnect.duplicate_login");
    private static final Logger h = LogUtils.getLogger();
    private static final int i = 600;
    private static final SimpleDateFormat j = new SimpleDateFormat("yyyy-MM-dd 'at' HH:mm:ss z");
    private final MinecraftServer k;
    public final List<EntityPlayer> l = new CopyOnWriteArrayList<EntityPlayer>();
    private final Map<UUID, EntityPlayer> m = Maps.newHashMap();
    private final GameProfileBanList n;
    private final IpBanList o;
    private final OpList p;
    private final WhiteList q;
    public final WorldNBTStorage t;
    private boolean u;
    private final LayeredRegistryAccess<RegistryLayer> v;
    public int g;
    private int w;
    private int x;
    private boolean y;
    private static final boolean z = false;
    private int A;
    private CraftServer cserver;
    private final Map<String, EntityPlayer> playersByName = new HashMap<String, EntityPlayer>();

    public PlayerList(MinecraftServer minecraftserver, LayeredRegistryAccess<RegistryLayer> layeredregistryaccess, WorldNBTStorage worldnbtstorage, int i2) {
        this.cserver = minecraftserver.server = new CraftServer((DedicatedServer)minecraftserver, this);
        minecraftserver.console = ColouredConsoleSender.getInstance();
        minecraftserver.reader.addCompleter((Completer)new ConsoleCommandCompleter(minecraftserver.server));
        this.n = new GameProfileBanList(a);
        this.o = new IpBanList(b);
        this.p = new OpList(c);
        this.q = new WhiteList(d);
        this.k = minecraftserver;
        this.v = layeredregistryaccess;
        this.g = i2;
        this.t = worldnbtstorage;
    }

    public void a(NetworkManager networkmanager, EntityPlayer entityplayer, CommonListenerCookie commonlistenercookie) {
        WorldServer worldserver1;
        ResourceKey<net.minecraft.world.level.World> resourcekey;
        WorldServer worldserver;
        NBTTagCompound nbttagcompound2;
        String s2;
        Optional<Object> optional;
        GameProfile gameprofile = entityplayer.fX();
        UserCache usercache = this.k.au();
        if (usercache != null) {
            optional = usercache.a(gameprofile.getId());
            s2 = optional.map(GameProfile::getName).orElse(gameprofile.getName());
            usercache.a(gameprofile);
        } else {
            s2 = gameprofile.getName();
        }
        optional = this.a(entityplayer);
        if (optional.isPresent() && (nbttagcompound2 = (NBTTagCompound)optional.get()).e("bukkit")) {
            NBTTagCompound bukkit = nbttagcompound2.p("bukkit");
            String string = s2 = bukkit.b("lastKnownName", 8) ? bukkit.l("lastKnownName") : s2;
        }
        if ((worldserver = this.k.a(resourcekey = optional.flatMap(nbttagcompound -> {
            DataResult<ResourceKey<net.minecraft.world.level.World>> dataresult = DimensionManager.a(new Dynamic((DynamicOps)DynamicOpsNBT.a, (Object)nbttagcompound.c("Dimension")));
            Logger logger = h;
            Objects.requireNonNull(logger);
            return dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0));
        }).orElse(entityplayer.A().af()))) == null) {
            h.warn("Unknown respawn dimension {}, defaulting to overworld", resourcekey);
            worldserver1 = this.k.I();
        } else {
            worldserver1 = worldserver;
        }
        entityplayer.a(worldserver1);
        String s1 = networkmanager.a(this.k.bn());
        CraftPlayer spawnPlayer = entityplayer.getBukkitEntity();
        PlayerSpawnLocationEvent ev = new PlayerSpawnLocationEvent((Player)spawnPlayer, spawnPlayer.getLocation());
        this.cserver.getPluginManager().callEvent((Event)ev);
        Location loc = ev.getSpawnLocation();
        worldserver1 = ((CraftWorld)loc.getWorld()).getHandle();
        entityplayer.spawnIn(worldserver1);
        entityplayer.e.a((WorldServer)entityplayer.dO());
        entityplayer.a(loc.getX(), loc.getY(), loc.getZ(), loc.getYaw(), loc.getPitch());
        WorldData worlddata = worldserver1.A_();
        entityplayer.c((NBTTagCompound)optional.orElse(null));
        PlayerConnection playerconnection = new PlayerConnection(this.k, networkmanager, entityplayer, commonlistenercookie);
        networkmanager.a(GameProtocols.a.a(RegistryFriendlyByteBuf.a(this.k.bc())), playerconnection);
        GameRules gamerules = worldserver1.ab();
        boolean flag = gamerules.b(GameRules.D);
        boolean flag1 = gamerules.b(GameRules.q);
        boolean flag2 = gamerules.b(GameRules.w);
        playerconnection.b(new PacketPlayOutLogin(entityplayer.an(), worlddata.l(), this.k.J(), this.n(), worldserver1.spigotConfig.viewDistance, worldserver1.spigotConfig.simulationDistance, flag1, !flag, flag2, entityplayer.b(worldserver1), this.k.aB()));
        entityplayer.getBukkitEntity().sendSupportedChannels();
        playerconnection.b(new PacketPlayOutServerDifficulty(worlddata.q(), worlddata.r()));
        playerconnection.b(new PacketPlayOutAbilities(entityplayer.fZ()));
        playerconnection.b(new PacketPlayOutHeldItemSlot(entityplayer.fY().k));
        playerconnection.b(new PacketPlayOutRecipeUpdate(this.k.aJ().b()));
        this.e(entityplayer);
        entityplayer.I().c();
        entityplayer.J().a(entityplayer);
        this.a(worldserver1.f(), entityplayer);
        this.k.aw();
        IChatMutableComponent ichatmutablecomponent = entityplayer.fX().getName().equalsIgnoreCase(s2) ? IChatBaseComponent.a("multiplayer.player.joined", entityplayer.S_()) : IChatBaseComponent.a("multiplayer.player.joined.renamed", entityplayer.S_(), s2);
        ichatmutablecomponent.a(EnumChatFormat.o);
        String joinMessage = CraftChatMessage.fromComponent(ichatmutablecomponent);
        playerconnection.a(entityplayer.dt(), entityplayer.dv(), entityplayer.dz(), entityplayer.dE(), entityplayer.dG());
        ServerPing serverping = this.k.av();
        if (serverping != null && !commonlistenercookie.d()) {
            entityplayer.a(serverping);
        }
        this.l.add(entityplayer);
        this.playersByName.put(entityplayer.cB().toLowerCase(Locale.ROOT), entityplayer);
        this.m.put(entityplayer.cz(), entityplayer);
        CraftPlayer bukkitPlayer = entityplayer.getBukkitEntity();
        entityplayer.cd.transferTo(entityplayer.cd, bukkitPlayer);
        PlayerJoinEvent playerJoinEvent = new PlayerJoinEvent((Player)bukkitPlayer, joinMessage);
        this.cserver.getPluginManager().callEvent((Event)playerJoinEvent);
        if (!entityplayer.c.c()) {
            return;
        }
        joinMessage = playerJoinEvent.getJoinMessage();
        if (joinMessage != null && joinMessage.length() > 0) {
            for (IChatBaseComponent line : CraftChatMessage.fromString(joinMessage)) {
                this.k.ah().a(line, false);
            }
        }
        ClientboundPlayerInfoUpdatePacket packet = ClientboundPlayerInfoUpdatePacket.a(List.of(entityplayer));
        for (int i2 = 0; i2 < this.l.size(); ++i2) {
            EntityPlayer entityplayer1 = this.l.get(i2);
            if (entityplayer1.getBukkitEntity().canSee(bukkitPlayer)) {
                entityplayer1.c.b(packet);
            }
            if (!bukkitPlayer.canSee(entityplayer1.getBukkitEntity())) continue;
            entityplayer.c.b(ClientboundPlayerInfoUpdatePacket.a(List.of(entityplayer1)));
        }
        entityplayer.sentListPacket = true;
        entityplayer.refreshEntityData(entityplayer);
        this.a(entityplayer, worldserver1);
        if (entityplayer.dO() == worldserver1 && !worldserver1.x().contains(entityplayer)) {
            worldserver1.a(entityplayer);
            this.k.aN().a(entityplayer);
        }
        worldserver1 = entityplayer.A();
        this.d(entityplayer);
        if (optional.isPresent() && ((NBTTagCompound)optional.get()).b("RootVehicle", 10)) {
            NBTTagCompound nbttagcompound3 = ((NBTTagCompound)optional.get()).p("RootVehicle");
            WorldServer finalWorldServer = worldserver1;
            Entity entity = EntityTypes.a(nbttagcompound3.p("Entity"), worldserver1, entity1 -> !finalWorldServer.c((Entity)entity1) ? null : entity1);
            if (entity != null) {
                UUID uuid = nbttagcompound3.b("Attach") ? nbttagcompound3.a("Attach") : null;
                if (entity.cz().equals(uuid)) {
                    entityplayer.a(entity, true);
                } else {
                    for (Entity entity12 : entity.cW()) {
                        if (!entity12.cz().equals(uuid)) continue;
                        entityplayer.a(entity12, true);
                        break;
                    }
                }
                if (!entityplayer.bS()) {
                    h.warn("Couldn't reattach entity to player");
                    entity.discard(null);
                    for (Entity entity12 : entity.cW()) {
                        entity12.discard(null);
                    }
                }
            }
        }
        entityplayer.h();
        h.info("{}[{}] logged in with entity id {} at ([{}]{}, {}, {})", new Object[]{entityplayer.ah().getString(), s1, entityplayer.an(), worldserver1.K.e(), entityplayer.dt(), entityplayer.dv(), entityplayer.dz()});
    }

    public void a(ScoreboardServer scoreboardserver, EntityPlayer entityplayer) {
        HashSet set = Sets.newHashSet();
        for (ScoreboardTeam scoreboardteam : scoreboardserver.g()) {
            entityplayer.c.b(PacketPlayOutScoreboardTeam.a(scoreboardteam, true));
        }
        for (DisplaySlot displayslot : DisplaySlot.values()) {
            ScoreboardObjective scoreboardobjective = scoreboardserver.a(displayslot);
            if (scoreboardobjective == null || set.contains(scoreboardobjective)) continue;
            List<Packet<?>> list = scoreboardserver.d(scoreboardobjective);
            for (Packet<?> packet : list) {
                entityplayer.c.b(packet);
            }
            set.add(scoreboardobjective);
        }
    }

    public void a(WorldServer worldserver) {
        if (this.t != null) {
            return;
        }
        worldserver.C_().a(new IWorldBorderListener(){

            @Override
            public void a(WorldBorder worldborder, double d0) {
                PlayerList.this.broadcastAll((Packet)new ClientboundSetBorderSizePacket(worldborder), worldborder.world);
            }

            @Override
            public void a(WorldBorder worldborder, double d0, double d1, long i2) {
                PlayerList.this.broadcastAll((Packet)new ClientboundSetBorderLerpSizePacket(worldborder), worldborder.world);
            }

            @Override
            public void a(WorldBorder worldborder, double d0, double d1) {
                PlayerList.this.broadcastAll((Packet)new ClientboundSetBorderCenterPacket(worldborder), worldborder.world);
            }

            @Override
            public void a(WorldBorder worldborder, int i2) {
                PlayerList.this.broadcastAll((Packet)new ClientboundSetBorderWarningDelayPacket(worldborder), worldborder.world);
            }

            @Override
            public void b(WorldBorder worldborder, int i2) {
                PlayerList.this.broadcastAll((Packet)new ClientboundSetBorderWarningDistancePacket(worldborder), worldborder.world);
            }

            @Override
            public void b(WorldBorder worldborder, double d0) {
            }

            @Override
            public void c(WorldBorder worldborder, double d0) {
            }
        });
    }

    public Optional<NBTTagCompound> a(EntityPlayer entityplayer) {
        Optional<NBTTagCompound> optional;
        NBTTagCompound nbttagcompound = this.k.bb().w();
        if (this.k.a(entityplayer.fX()) && nbttagcompound != null) {
            optional = Optional.of(nbttagcompound);
            entityplayer.g(nbttagcompound);
            h.debug("loading single player");
        } else {
            optional = this.t.b(entityplayer);
        }
        return optional;
    }

    protected void b(EntityPlayer entityplayer) {
        AdvancementDataPlayer advancementdataplayer;
        if (!entityplayer.getBukkitEntity().isPersistent()) {
            return;
        }
        this.t.a(entityplayer);
        ServerStatisticManager serverstatisticmanager = entityplayer.I();
        if (serverstatisticmanager != null) {
            serverstatisticmanager.a();
        }
        if ((advancementdataplayer = entityplayer.R()) != null) {
            advancementdataplayer.b();
        }
    }

    public String remove(EntityPlayer entityplayer) {
        Entity entity;
        WorldServer worldserver = entityplayer.A();
        entityplayer.a(StatisticList.j);
        if (entityplayer.cd != entityplayer.cc) {
            entityplayer.s();
        }
        PlayerQuitEvent playerQuitEvent = new PlayerQuitEvent((Player)entityplayer.getBukkitEntity(), (String)(entityplayer.kickLeaveMessage != null ? entityplayer.kickLeaveMessage : "\u00a7e" + entityplayer.cB() + " left the game"));
        this.cserver.getPluginManager().callEvent((Event)playerQuitEvent);
        entityplayer.getBukkitEntity().disconnect(playerQuitEvent.getQuitMessage());
        entityplayer.m();
        this.b(entityplayer);
        if (entityplayer.bS() && (entity = entityplayer.cZ()).cY()) {
            h.debug("Removing player mount");
            entityplayer.ad();
            entity.cV().forEach(entity1 -> entity1.setRemoved(Entity.RemovalReason.d, EntityRemoveEvent.Cause.PLAYER_QUIT));
        }
        entityplayer.ak();
        worldserver.a(entityplayer, Entity.RemovalReason.d);
        entityplayer.R().a();
        this.l.remove(entityplayer);
        this.playersByName.remove(entityplayer.cB().toLowerCase(Locale.ROOT));
        this.k.aN().b(entityplayer);
        UUID uuid = entityplayer.cz();
        EntityPlayer entityplayer1 = this.m.get(uuid);
        if (entityplayer1 == entityplayer) {
            this.m.remove(uuid);
        }
        ClientboundPlayerInfoRemovePacket packet = new ClientboundPlayerInfoRemovePacket(List.of(entityplayer.cz()));
        for (int i2 = 0; i2 < this.l.size(); ++i2) {
            EntityPlayer entityplayer2 = this.l.get(i2);
            if (entityplayer2.getBukkitEntity().canSee(entityplayer.getBukkitEntity())) {
                entityplayer2.c.b(packet);
                continue;
            }
            entityplayer2.getBukkitEntity().onEntityRemove(entityplayer);
        }
        this.cserver.getScoreboardManager().removePlayer(entityplayer.getBukkitEntity());
        return playerQuitEvent.getQuitMessage();
    }

    public EntityPlayer canPlayerLogin(LoginListener loginlistener, GameProfile gameprofile) {
        UUID uuid = gameprofile.getId();
        ArrayList list = Lists.newArrayList();
        for (int i2 = 0; i2 < this.l.size(); ++i2) {
            EntityPlayer entityplayer = this.l.get(i2);
            if (!entityplayer.cz().equals(uuid)) continue;
            list.add(entityplayer);
        }
        for (EntityPlayer entityplayer : list) {
            this.b(entityplayer);
            entityplayer.c.a(IChatBaseComponent.c("multiplayer.disconnect.duplicate_login"));
        }
        SocketAddress socketaddress = loginlistener.g.d();
        EntityPlayer entity = new EntityPlayer(this.k, this.k.a(net.minecraft.world.level.World.h), gameprofile, ClientInformation.a());
        entity.transferCookieConnection = loginlistener;
        CraftPlayer player = entity.getBukkitEntity();
        PlayerLoginEvent event = new PlayerLoginEvent((Player)player, loginlistener.g.hostname, ((InetSocketAddress)socketaddress).getAddress(), ((InetSocketAddress)loginlistener.g.n.remoteAddress()).getAddress());
        if (this.n.a(gameprofile)) {
            GameProfileBanEntry gameprofilebanentry = (GameProfileBanEntry)this.n.b(gameprofile);
            IChatMutableComponent ichatmutablecomponent = IChatBaseComponent.a("multiplayer.disconnect.banned.reason", new Object[]{gameprofilebanentry.d()});
            if (gameprofilebanentry.c() != null) {
                ichatmutablecomponent.b(IChatBaseComponent.a("multiplayer.disconnect.banned.expiration", new Object[]{j.format(gameprofilebanentry.c())}));
            }
            event.disallow(PlayerLoginEvent.Result.KICK_BANNED, CraftChatMessage.fromComponent(ichatmutablecomponent));
        } else if (!this.c(gameprofile)) {
            IChatMutableComponent ichatmutablecomponent = IChatBaseComponent.c("multiplayer.disconnect.not_whitelisted");
            event.disallow(PlayerLoginEvent.Result.KICK_WHITELIST, SpigotConfig.whitelistMessage);
        } else if (this.o.a(socketaddress)) {
            IpBanEntry ipbanentry = this.o.b(socketaddress);
            IChatMutableComponent ichatmutablecomponent = IChatBaseComponent.a("multiplayer.disconnect.banned_ip.reason", new Object[]{ipbanentry.d()});
            if (ipbanentry.c() != null) {
                ichatmutablecomponent.b(IChatBaseComponent.a("multiplayer.disconnect.banned_ip.expiration", new Object[]{j.format(ipbanentry.c())}));
            }
            event.disallow(PlayerLoginEvent.Result.KICK_BANNED, CraftChatMessage.fromComponent(ichatmutablecomponent));
        } else if (this.l.size() >= this.g && !this.d(gameprofile)) {
            event.disallow(PlayerLoginEvent.Result.KICK_FULL, SpigotConfig.serverFullMessage);
        }
        this.cserver.getPluginManager().callEvent((Event)event);
        if (event.getResult() != PlayerLoginEvent.Result.ALLOWED) {
            loginlistener.disconnect(event.getKickMessage());
            return null;
        }
        return entity;
    }

    public EntityPlayer getPlayerForLogin(GameProfile gameprofile, ClientInformation clientinformation, EntityPlayer player) {
        player.a(clientinformation);
        return player;
    }

    public boolean disconnectAllPlayersWithProfile(GameProfile gameprofile, EntityPlayer player) {
        return player == null;
    }

    public EntityPlayer respawn(EntityPlayer entityplayer, boolean flag, Entity.RemovalReason entity_removalreason, PlayerRespawnEvent.RespawnReason reason) {
        return this.respawn(entityplayer, flag, entity_removalreason, reason, null);
    }

    public EntityPlayer respawn(EntityPlayer entityplayer, boolean flag, Entity.RemovalReason entity_removalreason, PlayerRespawnEvent.RespawnReason reason, Location location) {
        Object blockposition;
        IBlockData iblockdata;
        DimensionTransition dimensiontransition;
        entityplayer.ad();
        this.l.remove(entityplayer);
        this.playersByName.remove(entityplayer.cB().toLowerCase(Locale.ROOT));
        entityplayer.A().a(entityplayer, entity_removalreason);
        EntityPlayer entityplayer1 = entityplayer;
        net.minecraft.world.level.World fromWorld = entityplayer.dO();
        entityplayer.h = false;
        entityplayer1.c = entityplayer.c;
        entityplayer1.a(entityplayer, flag);
        entityplayer1.e(entityplayer.an());
        entityplayer1.a(entityplayer.fq());
        for (String s2 : entityplayer.ao()) {
            entityplayer1.a(s2);
        }
        if (location == null) {
            dimensiontransition = entityplayer.findRespawnPositionAndUseSpawnBlock(flag, DimensionTransition.a, reason);
            if (!flag) {
                entityplayer.reset();
            }
        } else {
            dimensiontransition = new DimensionTransition(((CraftWorld)location.getWorld()).getHandle(), CraftLocation.toVec3D(location), Vec3D.b, location.getYaw(), location.getPitch(), DimensionTransition.a);
        }
        if (dimensiontransition == null) {
            return entityplayer;
        }
        WorldServer worldserver = dimensiontransition.a();
        entityplayer1.spawnIn(worldserver);
        entityplayer1.dL();
        entityplayer1.g(false);
        Vec3D vec3d = dimensiontransition.b();
        entityplayer1.forceSetPositionRotation(vec3d.c, vec3d.d, vec3d.e, dimensiontransition.d(), dimensiontransition.e());
        if (dimensiontransition.f()) {
            entityplayer1.c.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.b, 0.0f));
            entityplayer1.setRespawnPosition(null, null, 0.0f, false, false, PlayerSpawnChangeEvent.Cause.RESET);
        }
        boolean i2 = flag;
        WorldServer worldserver1 = entityplayer1.A();
        WorldData worlddata = worldserver1.A_();
        entityplayer1.c.b(new PacketPlayOutRespawn(entityplayer1.b(worldserver1), (byte)(i2 ? 1 : 0)));
        entityplayer1.c.b(new PacketPlayOutViewDistance(worldserver1.spigotConfig.viewDistance));
        entityplayer1.c.b(new ClientboundSetSimulationDistancePacket(worldserver1.spigotConfig.simulationDistance));
        entityplayer1.c.teleport(CraftLocation.toBukkit(entityplayer1.dm(), (World)worldserver1.getWorld(), entityplayer1.dE(), entityplayer1.dG()));
        entityplayer1.c.b(new PacketPlayOutSpawnPosition(worldserver.V(), worldserver.W()));
        entityplayer1.c.b(new PacketPlayOutServerDifficulty(worlddata.q(), worlddata.r()));
        entityplayer1.c.b(new PacketPlayOutExperience(entityplayer1.cs, entityplayer1.cr, entityplayer1.cq));
        this.d(entityplayer1);
        this.a(entityplayer1, worldserver);
        this.e(entityplayer1);
        if (!entityplayer.c.isDisconnected()) {
            worldserver.b(entityplayer1);
            this.l.add(entityplayer1);
            this.playersByName.put(entityplayer1.cB().toLowerCase(Locale.ROOT), entityplayer1);
            this.m.put(entityplayer1.cz(), entityplayer1);
        }
        entityplayer1.v(entityplayer1.ew());
        if (!flag && (iblockdata = worldserver.a_((BlockPosition)(blockposition = BlockPosition.a(dimensiontransition.b())))).a(Blocks.pl)) {
            entityplayer1.c.b(new PacketPlayOutNamedSoundEffect(SoundEffects.vy, SoundCategory.e, ((BaseBlockPosition)blockposition).u(), ((BaseBlockPosition)blockposition).v(), ((BaseBlockPosition)blockposition).w(), 1.0f, 1.0f, worldserver.E_().g()));
        }
        this.f(entityplayer);
        entityplayer.z();
        for (MobEffect mobEffect : entityplayer.et()) {
            entityplayer.c.b(new PacketPlayOutEntityEffect(entityplayer.an(), mobEffect, false));
        }
        entityplayer.c(worldserver);
        if (fromWorld != worldserver) {
            PlayerChangedWorldEvent event = new PlayerChangedWorldEvent((Player)entityplayer.getBukkitEntity(), (World)fromWorld.getWorld());
            this.k.server.getPluginManager().callEvent((Event)event);
        }
        if (entityplayer.c.isDisconnected()) {
            this.b(entityplayer);
        }
        return entityplayer1;
    }

    public void d(EntityPlayer entityplayer) {
        this.a((EntityLiving)entityplayer, entityplayer.c);
    }

    public void a(EntityLiving entityliving, PlayerConnection playerconnection) {
        for (MobEffect mobeffect : entityliving.et()) {
            playerconnection.b(new PacketPlayOutEntityEffect(entityliving.an(), mobeffect, false));
        }
    }

    public void e(EntityPlayer entityplayer) {
        GameProfile gameprofile = entityplayer.fX();
        int i2 = this.k.c(gameprofile);
        this.a(entityplayer, i2);
    }

    public void d() {
        if (++this.A > 600) {
            for (int i2 = 0; i2 < this.l.size(); ++i2) {
                final EntityPlayer target = this.l.get(i2);
                target.c.b(new ClientboundPlayerInfoUpdatePacket(EnumSet.of(ClientboundPlayerInfoUpdatePacket.a.e), this.l.stream().filter(new Predicate<EntityPlayer>(){

                    @Override
                    public boolean test(EntityPlayer input) {
                        return target.getBukkitEntity().canSee(input.getBukkitEntity());
                    }
                }).collect(Collectors.toList())));
            }
            this.A = 0;
        }
    }

    public void a(Packet<?> packet) {
        for (EntityPlayer entityplayer : this.l) {
            entityplayer.c.b(packet);
        }
    }

    public void broadcastAll(Packet packet, EntityHuman entityhuman) {
        for (int i2 = 0; i2 < this.l.size(); ++i2) {
            EntityPlayer entityplayer = this.l.get(i2);
            if (entityhuman != null && !entityplayer.getBukkitEntity().canSee(entityhuman.getBukkitEntity())) continue;
            this.l.get((int)i2).c.b(packet);
        }
    }

    public void broadcastAll(Packet packet, net.minecraft.world.level.World world) {
        for (int i2 = 0; i2 < world.x().size(); ++i2) {
            ((EntityPlayer)world.x().get((int)i2)).c.b(packet);
        }
    }

    public void a(Packet<?> packet, ResourceKey<net.minecraft.world.level.World> resourcekey) {
        for (EntityPlayer entityplayer : this.l) {
            if (entityplayer.dO().af() != resourcekey) continue;
            entityplayer.c.b(packet);
        }
    }

    public void a(EntityHuman entityhuman, IChatBaseComponent ichatbasecomponent) {
        ScoreboardTeam scoreboardteam = entityhuman.ck();
        if (scoreboardteam != null) {
            Collection<String> collection = scoreboardteam.g();
            for (String s2 : collection) {
                EntityPlayer entityplayer = this.a(s2);
                if (entityplayer == null || entityplayer == entityhuman) continue;
                entityplayer.a(ichatbasecomponent);
            }
        }
    }

    public void b(EntityHuman entityhuman, IChatBaseComponent ichatbasecomponent) {
        ScoreboardTeam scoreboardteam = entityhuman.ck();
        if (scoreboardteam == null) {
            this.a(ichatbasecomponent, false);
        } else {
            for (int i2 = 0; i2 < this.l.size(); ++i2) {
                EntityPlayer entityplayer = this.l.get(i2);
                if (entityplayer.ck() == scoreboardteam) continue;
                entityplayer.a(ichatbasecomponent);
            }
        }
    }

    public String[] e() {
        String[] astring = new String[this.l.size()];
        for (int i2 = 0; i2 < this.l.size(); ++i2) {
            astring[i2] = this.l.get(i2).fX().getName();
        }
        return astring;
    }

    public GameProfileBanList f() {
        return this.n;
    }

    public IpBanList g() {
        return this.o;
    }

    public void a(GameProfile gameprofile) {
        this.p.a(new OpListEntry(gameprofile, this.k.k(), this.p.a(gameprofile)));
        EntityPlayer entityplayer = this.a(gameprofile.getId());
        if (entityplayer != null) {
            this.e(entityplayer);
        }
    }

    public void b(GameProfile gameprofile) {
        this.p.c(gameprofile);
        EntityPlayer entityplayer = this.a(gameprofile.getId());
        if (entityplayer != null) {
            this.e(entityplayer);
        }
    }

    private void a(EntityPlayer entityplayer, int i2) {
        if (entityplayer.c != null) {
            byte b0 = i2 <= 0 ? (byte)24 : (i2 >= 4 ? (byte)28 : (byte)((byte)(24 + i2)));
            entityplayer.c.b(new PacketPlayOutEntityStatus(entityplayer, b0));
        }
        entityplayer.getBukkitEntity().recalculatePermissions();
        this.k.aH().a(entityplayer);
    }

    public boolean c(GameProfile gameprofile) {
        return !this.u || this.p.d(gameprofile) || this.q.d(gameprofile);
    }

    public boolean f(GameProfile gameprofile) {
        return this.p.d(gameprofile) || this.k.a(gameprofile) && this.k.bb().m() || this.y;
    }

    @Nullable
    public EntityPlayer a(String s2) {
        return this.playersByName.get(s2.toLowerCase(Locale.ROOT));
    }

    public void a(@Nullable EntityHuman entityhuman, double d0, double d1, double d2, double d3, ResourceKey<net.minecraft.world.level.World> resourcekey, Packet<?> packet) {
        for (int i2 = 0; i2 < this.l.size(); ++i2) {
            double d6;
            double d5;
            double d4;
            EntityPlayer entityplayer = this.l.get(i2);
            if (entityhuman != null && !entityplayer.getBukkitEntity().canSee(entityhuman.getBukkitEntity()) || entityplayer == entityhuman || entityplayer.dO().af() != resourcekey || !((d4 = d0 - entityplayer.dt()) * d4 + (d5 = d1 - entityplayer.dv()) * d5 + (d6 = d2 - entityplayer.dz()) * d6 < d3 * d3)) continue;
            entityplayer.c.b(packet);
        }
    }

    public void h() {
        for (int i2 = 0; i2 < this.l.size(); ++i2) {
            this.b(this.l.get(i2));
        }
    }

    public WhiteList i() {
        return this.q;
    }

    public String[] j() {
        return this.q.a();
    }

    public OpList k() {
        return this.p;
    }

    public String[] l() {
        return this.p.a();
    }

    public void a() {
    }

    public void a(EntityPlayer entityplayer, WorldServer worldserver) {
        WorldBorder worldborder = entityplayer.dO().C_();
        entityplayer.c.b(new ClientboundInitializeBorderPacket(worldborder));
        entityplayer.c.b(new PacketPlayOutUpdateTime(worldserver.Z(), worldserver.aa(), worldserver.ab().b(GameRules.l)));
        entityplayer.c.b(new PacketPlayOutSpawnPosition(worldserver.V(), worldserver.W()));
        if (worldserver.ad()) {
            entityplayer.setPlayerWeather(WeatherType.DOWNFALL, false);
            entityplayer.updateWeather(-worldserver.w, worldserver.w, -worldserver.y, worldserver.y);
        }
        entityplayer.c.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.o, 0.0f));
        this.k.aQ().a(entityplayer);
    }

    public void f(EntityPlayer entityplayer) {
        entityplayer.cc.b();
        entityplayer.getBukkitEntity().updateScaledHealth();
        entityplayer.refreshEntityData(entityplayer);
        entityplayer.c.b(new PacketPlayOutHeldItemSlot(entityplayer.fY().k));
        int i2 = entityplayer.dO().ab().b(GameRules.q) ? 22 : 23;
        entityplayer.c.b(new PacketPlayOutEntityStatus(entityplayer, (byte)i2));
        float immediateRespawn = entityplayer.dO().ab().b(GameRules.D) ? 1.0f : 0.0f;
        entityplayer.c.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.m, immediateRespawn));
    }

    public int m() {
        return this.l.size();
    }

    public int n() {
        return this.g;
    }

    public boolean o() {
        return this.u;
    }

    public void a(boolean flag) {
        this.u = flag;
    }

    public List<EntityPlayer> b(String s2) {
        ArrayList list = Lists.newArrayList();
        for (EntityPlayer entityplayer : this.l) {
            if (!entityplayer.B().equals(s2)) continue;
            list.add(entityplayer);
        }
        return list;
    }

    public int p() {
        return this.w;
    }

    public int q() {
        return this.x;
    }

    public MinecraftServer c() {
        return this.k;
    }

    @Nullable
    public NBTTagCompound r() {
        return null;
    }

    public void b(boolean flag) {
        this.y = flag;
    }

    public void s() {
        for (EntityPlayer player : this.l) {
            player.c.a(CraftChatMessage.fromStringOrEmpty(this.k.server.getShutdownMessage()));
        }
    }

    public void broadcastMessage(IChatBaseComponent[] iChatBaseComponents) {
        for (IChatBaseComponent component : iChatBaseComponents) {
            this.a(component, false);
        }
    }

    public void a(IChatBaseComponent ichatbasecomponent, boolean flag) {
        this.a(ichatbasecomponent, (EntityPlayer entityplayer) -> ichatbasecomponent, flag);
    }

    public void a(IChatBaseComponent ichatbasecomponent, Function<EntityPlayer, IChatBaseComponent> function, boolean flag) {
        this.k.a(ichatbasecomponent);
        for (EntityPlayer entityplayer : this.l) {
            IChatBaseComponent ichatbasecomponent1 = function.apply(entityplayer);
            if (ichatbasecomponent1 == null) continue;
            entityplayer.b(ichatbasecomponent1, flag);
        }
    }

    public void a(PlayerChatMessage playerchatmessage, CommandListenerWrapper commandlistenerwrapper, ChatMessageType.a chatmessagetype_a) {
        Objects.requireNonNull(commandlistenerwrapper);
        this.a(playerchatmessage, commandlistenerwrapper::a, commandlistenerwrapper.i(), chatmessagetype_a);
    }

    public void a(PlayerChatMessage playerchatmessage, EntityPlayer entityplayer, ChatMessageType.a chatmessagetype_a) {
        Objects.requireNonNull(entityplayer);
        this.a(playerchatmessage, entityplayer::c, entityplayer, chatmessagetype_a);
    }

    private void a(PlayerChatMessage playerchatmessage, Predicate<EntityPlayer> predicate, @Nullable EntityPlayer entityplayer, ChatMessageType.a chatmessagetype_a) {
        boolean flag = this.a(playerchatmessage);
        this.k.a(playerchatmessage.d(), chatmessagetype_a, flag ? null : "Not Secure");
        OutgoingChatMessage outgoingchatmessage = OutgoingChatMessage.a(playerchatmessage);
        boolean flag1 = false;
        for (EntityPlayer entityplayer1 : this.l) {
            boolean flag2 = predicate.test(entityplayer1);
            entityplayer1.a(outgoingchatmessage, flag2, chatmessagetype_a);
            flag1 |= flag2 && playerchatmessage.j();
        }
        if (flag1 && entityplayer != null) {
            entityplayer.a(e);
        }
    }

    private boolean a(PlayerChatMessage playerchatmessage) {
        return playerchatmessage.i() && !playerchatmessage.a(Instant.now());
    }

    public ServerStatisticManager getPlayerStats(EntityPlayer entityhuman) {
        ServerStatisticManager serverstatisticmanager = entityhuman.I();
        return serverstatisticmanager == null ? this.getPlayerStats(entityhuman.cz(), entityhuman.S_().getString()) : serverstatisticmanager;
    }

    public ServerStatisticManager getPlayerStats(UUID uuid, String displayName) {
        ServerStatisticManager serverstatisticmanager;
        EntityPlayer entityhuman = this.a(uuid);
        ServerStatisticManager serverStatisticManager = serverstatisticmanager = entityhuman == null ? null : entityhuman.I();
        if (serverstatisticmanager == null) {
            File file2;
            Path path;
            File file = this.k.a(SavedFile.b).toFile();
            File file1 = new File(file, String.valueOf(uuid) + ".json");
            if (!file1.exists() && FileUtils.a(path = (file2 = new File(file, displayName + ".json")).toPath()) && FileUtils.b(path) && path.startsWith(file.getPath()) && file2.isFile()) {
                file2.renameTo(file1);
            }
            serverstatisticmanager = new ServerStatisticManager(this.k, file1);
        }
        return serverstatisticmanager;
    }

    public AdvancementDataPlayer g(EntityPlayer entityplayer) {
        UUID uuid = entityplayer.cz();
        AdvancementDataPlayer advancementdataplayer = entityplayer.R();
        if (advancementdataplayer == null) {
            Path path = this.k.a(SavedFile.a).resolve(String.valueOf(uuid) + ".json");
            advancementdataplayer = new AdvancementDataPlayer(this.k.aD(), this, this.k.aE(), path, entityplayer);
        }
        advancementdataplayer.a(entityplayer);
        return advancementdataplayer;
    }

    public void a(int i2) {
        this.w = i2;
        this.a(new PacketPlayOutViewDistance(i2));
        for (WorldServer worldserver : this.k.K()) {
            if (worldserver == null) continue;
            worldserver.l().a(i2);
        }
    }

    public void b(int i2) {
        this.x = i2;
        this.a(new ClientboundSetSimulationDistancePacket(i2));
        for (WorldServer worldserver : this.k.K()) {
            if (worldserver == null) continue;
            worldserver.l().b(i2);
        }
    }

    public List<EntityPlayer> t() {
        return this.l;
    }

    @Nullable
    public EntityPlayer a(UUID uuid) {
        return this.m.get(uuid);
    }

    public boolean d(GameProfile gameprofile) {
        return false;
    }

    public void u() {
        for (EntityPlayer player : this.l) {
            player.R().a(this.k.aE());
            player.R().b(player);
        }
        this.a(new ClientboundUpdateTagsPacket(TagNetworkSerialization.a(this.v)));
        PacketPlayOutRecipeUpdate packetplayoutrecipeupdate = new PacketPlayOutRecipeUpdate(this.k.aJ().b());
        for (EntityPlayer entityplayer : this.l) {
            entityplayer.c.b(packetplayoutrecipeupdate);
            entityplayer.J().a(entityplayer);
        }
    }

    public boolean v() {
        return this.y;
    }
}

