/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.templates.List;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import java.util.List;
import java.util.stream.LongStream;
import net.minecraft.util.MathHelper;
import net.minecraft.util.datafix.fixes.DataConverterTypes;

public class DataConverterBitStorageAlign
extends DataFix {
    private static final int a = 6;
    private static final int b = 16;
    private static final int c = 16;
    private static final int d = 4096;
    private static final int e = 9;
    private static final int f = 256;

    public DataConverterBitStorageAlign(Schema var0) {
        super(var0, false);
    }

    protected TypeRewriteRule makeRule() {
        Type var0 = this.getInputSchema().getType(DataConverterTypes.c);
        Type var1 = var0.findFieldType("Level");
        OpticFinder var2 = DSL.fieldFinder((String)"Level", (Type)var1);
        OpticFinder var3 = var2.type().findField("Sections");
        Type var42 = ((List.ListType)var3.type()).getElement();
        OpticFinder var5 = DSL.typeFinder((Type)var42);
        Type var6 = DSL.named((String)DataConverterTypes.u.typeName(), (Type)DSL.remainderType());
        OpticFinder var7 = DSL.fieldFinder((String)"Palette", (Type)DSL.list((Type)var6));
        return this.fixTypeEverywhereTyped("BitStorageAlignFix", var0, this.getOutputSchema().getType(DataConverterTypes.c), var4 -> var4.updateTyped(var2, var3 -> this.a(DataConverterBitStorageAlign.a(var3, var5, var7, var3))));
    }

    private Typed<?> a(Typed<?> var02) {
        return var02.update(DSL.remainderFinder(), var0 -> var0.update("Heightmaps", var1 -> var1.updateMapValues(var12 -> var12.mapSecond(var1 -> DataConverterBitStorageAlign.a(var0, var1, 256, 9)))));
    }

    private static Typed<?> a(OpticFinder<?> var0, OpticFinder<?> var1, OpticFinder<List<Pair<String, Dynamic<?>>>> var22, Typed<?> var3) {
        return var3.updateTyped(var0, var2 -> var2.updateTyped(var1, var12 -> {
            Object var2 = var12.getOptional(var22).map(var0 -> Math.max(4, DataFixUtils.ceillog2((int)var0.size()))).orElse(0);
            if (var2 == 0 || MathHelper.d(var2)) {
                return var12;
            }
            return var12.update(DSL.remainderFinder(), var1 -> var1.update("BlockStates", var2 -> DataConverterBitStorageAlign.a(var1, var2, 4096, var2)));
        }));
    }

    private static Dynamic<?> a(Dynamic<?> var0, Dynamic<?> var1, int var2, int var3) {
        long[] var4 = var1.asLongStream().toArray();
        long[] var5 = DataConverterBitStorageAlign.a(var2, var3, var4);
        return var0.createLongList(LongStream.of(var5));
    }

    public static long[] a(int var0, int var1, long[] var2) {
        int var3 = var2.length;
        if (var3 == 0) {
            return var2;
        }
        long var4 = (1L << var1) - 1L;
        int var6 = 64 / var1;
        int var7 = (var0 + var6 - 1) / var6;
        long[] var8 = new long[var7];
        int var9 = 0;
        int var10 = 0;
        long var11 = 0L;
        int var13 = 0;
        long var14 = var2[0];
        long var16 = var3 > 1 ? var2[1] : 0L;
        for (int var18 = 0; var18 < var0; ++var18) {
            int var25;
            long var23;
            int var19 = var18 * var1;
            int var20 = var19 >> 6;
            int var21 = (var18 + 1) * var1 - 1 >> 6;
            int var22 = var19 ^ var20 << 6;
            if (var20 != var13) {
                var14 = var16;
                var16 = var20 + 1 < var3 ? var2[var20 + 1] : 0L;
                var13 = var20;
            }
            if (var20 == var21) {
                var23 = var14 >>> var22 & var4;
            } else {
                var25 = 64 - var22;
                var23 = (var14 >>> var22 | var16 << var25) & var4;
            }
            var25 = var10 + var1;
            if (var25 >= 64) {
                var8[var9++] = var11;
                var11 = var23;
                var10 = var1;
                continue;
            }
            var11 |= var23 << var10;
            var10 = var25;
        }
        if (var11 != 0L) {
            var8[var9] = var11;
        }
        return var8;
    }
}

