/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.schemas;

import com.google.common.collect.Maps;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.templates.Hook;
import com.mojang.datafixers.types.templates.TypeTemplate;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.util.datafix.schemas.DataConverterSchemaNamed;
import org.slf4j.Logger;

public class DataConverterSchemaV99
extends Schema {
    private static final Logger c = LogUtils.getLogger();
    static final Map<String, String> d = (Map)DataFixUtils.make((Object)Maps.newHashMap(), var0 -> {
        var0.put("minecraft:furnace", "Furnace");
        var0.put("minecraft:lit_furnace", "Furnace");
        var0.put("minecraft:chest", "Chest");
        var0.put("minecraft:trapped_chest", "Chest");
        var0.put("minecraft:ender_chest", "EnderChest");
        var0.put("minecraft:jukebox", "RecordPlayer");
        var0.put("minecraft:dispenser", "Trap");
        var0.put("minecraft:dropper", "Dropper");
        var0.put("minecraft:sign", "Sign");
        var0.put("minecraft:mob_spawner", "MobSpawner");
        var0.put("minecraft:noteblock", "Music");
        var0.put("minecraft:brewing_stand", "Cauldron");
        var0.put("minecraft:enhanting_table", "EnchantTable");
        var0.put("minecraft:command_block", "CommandBlock");
        var0.put("minecraft:beacon", "Beacon");
        var0.put("minecraft:skull", "Skull");
        var0.put("minecraft:daylight_detector", "DLDetector");
        var0.put("minecraft:hopper", "Hopper");
        var0.put("minecraft:banner", "Banner");
        var0.put("minecraft:flower_pot", "FlowerPot");
        var0.put("minecraft:repeating_command_block", "CommandBlock");
        var0.put("minecraft:chain_command_block", "CommandBlock");
        var0.put("minecraft:standing_sign", "Sign");
        var0.put("minecraft:wall_sign", "Sign");
        var0.put("minecraft:piston_head", "Piston");
        var0.put("minecraft:daylight_detector_inverted", "DLDetector");
        var0.put("minecraft:unpowered_comparator", "Comparator");
        var0.put("minecraft:powered_comparator", "Comparator");
        var0.put("minecraft:wall_banner", "Banner");
        var0.put("minecraft:standing_banner", "Banner");
        var0.put("minecraft:structure_block", "Structure");
        var0.put("minecraft:end_portal", "Airportal");
        var0.put("minecraft:end_gateway", "EndGateway");
        var0.put("minecraft:shield", "Banner");
    });
    public static final Map<String, String> a = Map.of("minecraft:armor_stand", "ArmorStand", "minecraft:painting", "Painting");
    protected static final Hook.HookFunction b = new Hook.HookFunction(){

        public <T> T apply(DynamicOps<T> var0, T var1) {
            return DataConverterSchemaV99.a(new Dynamic(var0, var1), d, a);
        }
    };

    public DataConverterSchemaV99(int var0, Schema var1) {
        super(var0, var1);
    }

    protected static TypeTemplate a(Schema var0) {
        return DSL.optionalFields((String)"Equipment", (TypeTemplate)DSL.list((TypeTemplate)DataConverterTypes.t.in(var0)));
    }

    protected static void a(Schema var0, Map<String, Supplier<TypeTemplate>> var1, String var2) {
        var0.register(var1, var2, () -> DataConverterSchemaV99.a(var0));
    }

    protected static void b(Schema var0, Map<String, Supplier<TypeTemplate>> var1, String var2) {
        var0.register(var1, var2, () -> DSL.optionalFields((String)"inTile", (TypeTemplate)DataConverterTypes.C.in(var0)));
    }

    protected static void c(Schema var0, Map<String, Supplier<TypeTemplate>> var1, String var2) {
        var0.register(var1, var2, () -> DSL.optionalFields((String)"DisplayTile", (TypeTemplate)DataConverterTypes.C.in(var0)));
    }

    protected static void d(Schema var0, Map<String, Supplier<TypeTemplate>> var1, String var2) {
        var0.register(var1, var2, () -> DSL.optionalFields((String)"Items", (TypeTemplate)DSL.list((TypeTemplate)DataConverterTypes.t.in(var0))));
    }

    public Map<String, Supplier<TypeTemplate>> registerEntities(Schema var0) {
        HashMap var12 = Maps.newHashMap();
        var0.register((Map)var12, "Item", var1 -> DSL.optionalFields((String)"Item", (TypeTemplate)DataConverterTypes.t.in(var0)));
        var0.registerSimple((Map)var12, "XPOrb");
        DataConverterSchemaV99.b(var0, (Map<String, Supplier<TypeTemplate>>)var12, "ThrownEgg");
        var0.registerSimple((Map)var12, "LeashKnot");
        var0.registerSimple((Map)var12, "Painting");
        var0.register((Map)var12, "Arrow", var1 -> DSL.optionalFields((String)"inTile", (TypeTemplate)DataConverterTypes.C.in(var0)));
        var0.register((Map)var12, "TippedArrow", var1 -> DSL.optionalFields((String)"inTile", (TypeTemplate)DataConverterTypes.C.in(var0)));
        var0.register((Map)var12, "SpectralArrow", var1 -> DSL.optionalFields((String)"inTile", (TypeTemplate)DataConverterTypes.C.in(var0)));
        DataConverterSchemaV99.b(var0, (Map<String, Supplier<TypeTemplate>>)var12, "Snowball");
        DataConverterSchemaV99.b(var0, (Map<String, Supplier<TypeTemplate>>)var12, "Fireball");
        DataConverterSchemaV99.b(var0, (Map<String, Supplier<TypeTemplate>>)var12, "SmallFireball");
        DataConverterSchemaV99.b(var0, (Map<String, Supplier<TypeTemplate>>)var12, "ThrownEnderpearl");
        var0.registerSimple((Map)var12, "EyeOfEnderSignal");
        var0.register((Map)var12, "ThrownPotion", var1 -> DSL.optionalFields((String)"inTile", (TypeTemplate)DataConverterTypes.C.in(var0), (String)"Potion", (TypeTemplate)DataConverterTypes.t.in(var0)));
        DataConverterSchemaV99.b(var0, (Map<String, Supplier<TypeTemplate>>)var12, "ThrownExpBottle");
        var0.register((Map)var12, "ItemFrame", var1 -> DSL.optionalFields((String)"Item", (TypeTemplate)DataConverterTypes.t.in(var0)));
        DataConverterSchemaV99.b(var0, (Map<String, Supplier<TypeTemplate>>)var12, "WitherSkull");
        var0.registerSimple((Map)var12, "PrimedTnt");
        var0.register((Map)var12, "FallingSand", var1 -> DSL.optionalFields((String)"Block", (TypeTemplate)DataConverterTypes.C.in(var0), (String)"TileEntityData", (TypeTemplate)DataConverterTypes.s.in(var0)));
        var0.register((Map)var12, "FireworksRocketEntity", var1 -> DSL.optionalFields((String)"FireworksItem", (TypeTemplate)DataConverterTypes.t.in(var0)));
        var0.registerSimple((Map)var12, "Boat");
        var0.register((Map)var12, "Minecart", () -> DSL.optionalFields((String)"DisplayTile", (TypeTemplate)DataConverterTypes.C.in(var0), (String)"Items", (TypeTemplate)DSL.list((TypeTemplate)DataConverterTypes.t.in(var0))));
        DataConverterSchemaV99.c(var0, var12, "MinecartRideable");
        var0.register((Map)var12, "MinecartChest", var1 -> DSL.optionalFields((String)"DisplayTile", (TypeTemplate)DataConverterTypes.C.in(var0), (String)"Items", (TypeTemplate)DSL.list((TypeTemplate)DataConverterTypes.t.in(var0))));
        DataConverterSchemaV99.c(var0, var12, "MinecartFurnace");
        DataConverterSchemaV99.c(var0, var12, "MinecartTNT");
        var0.register((Map)var12, "MinecartSpawner", () -> DSL.optionalFields((String)"DisplayTile", (TypeTemplate)DataConverterTypes.C.in(var0), (TypeTemplate)DataConverterTypes.F.in(var0)));
        var0.register((Map)var12, "MinecartHopper", var1 -> DSL.optionalFields((String)"DisplayTile", (TypeTemplate)DataConverterTypes.C.in(var0), (String)"Items", (TypeTemplate)DSL.list((TypeTemplate)DataConverterTypes.t.in(var0))));
        DataConverterSchemaV99.c(var0, var12, "MinecartCommandBlock");
        DataConverterSchemaV99.a(var0, (Map<String, Supplier<TypeTemplate>>)var12, "ArmorStand");
        DataConverterSchemaV99.a(var0, (Map<String, Supplier<TypeTemplate>>)var12, "Creeper");
        DataConverterSchemaV99.a(var0, (Map<String, Supplier<TypeTemplate>>)var12, "Skeleton");
        DataConverterSchemaV99.a(var0, (Map<String, Supplier<TypeTemplate>>)var12, "Spider");
        DataConverterSchemaV99.a(var0, (Map<String, Supplier<TypeTemplate>>)var12, "Giant");
        DataConverterSchemaV99.a(var0, (Map<String, Supplier<TypeTemplate>>)var12, "Zombie");
        DataConverterSchemaV99.a(var0, (Map<String, Supplier<TypeTemplate>>)var12, "Slime");
        DataConverterSchemaV99.a(var0, (Map<String, Supplier<TypeTemplate>>)var12, "Ghast");
        DataConverterSchemaV99.a(var0, (Map<String, Supplier<TypeTemplate>>)var12, "PigZombie");
        var0.register((Map)var12, "Enderman", var1 -> DSL.optionalFields((String)"carried", (TypeTemplate)DataConverterTypes.C.in(var0), (TypeTemplate)DataConverterSchemaV99.a(var0)));
        DataConverterSchemaV99.a(var0, (Map<String, Supplier<TypeTemplate>>)var12, "CaveSpider");
        DataConverterSchemaV99.a(var0, (Map<String, Supplier<TypeTemplate>>)var12, "Silverfish");
        DataConverterSchemaV99.a(var0, (Map<String, Supplier<TypeTemplate>>)var12, "Blaze");
        DataConverterSchemaV99.a(var0, (Map<String, Supplier<TypeTemplate>>)var12, "LavaSlime");
        DataConverterSchemaV99.a(var0, (Map<String, Supplier<TypeTemplate>>)var12, "EnderDragon");
        DataConverterSchemaV99.a(var0, (Map<String, Supplier<TypeTemplate>>)var12, "WitherBoss");
        DataConverterSchemaV99.a(var0, (Map<String, Supplier<TypeTemplate>>)var12, "Bat");
        DataConverterSchemaV99.a(var0, (Map<String, Supplier<TypeTemplate>>)var12, "Witch");
        DataConverterSchemaV99.a(var0, (Map<String, Supplier<TypeTemplate>>)var12, "Endermite");
        DataConverterSchemaV99.a(var0, (Map<String, Supplier<TypeTemplate>>)var12, "Guardian");
        DataConverterSchemaV99.a(var0, (Map<String, Supplier<TypeTemplate>>)var12, "Pig");
        DataConverterSchemaV99.a(var0, (Map<String, Supplier<TypeTemplate>>)var12, "Sheep");
        DataConverterSchemaV99.a(var0, (Map<String, Supplier<TypeTemplate>>)var12, "Cow");
        DataConverterSchemaV99.a(var0, (Map<String, Supplier<TypeTemplate>>)var12, "Chicken");
        DataConverterSchemaV99.a(var0, (Map<String, Supplier<TypeTemplate>>)var12, "Squid");
        DataConverterSchemaV99.a(var0, (Map<String, Supplier<TypeTemplate>>)var12, "Wolf");
        DataConverterSchemaV99.a(var0, (Map<String, Supplier<TypeTemplate>>)var12, "MushroomCow");
        DataConverterSchemaV99.a(var0, (Map<String, Supplier<TypeTemplate>>)var12, "SnowMan");
        DataConverterSchemaV99.a(var0, (Map<String, Supplier<TypeTemplate>>)var12, "Ozelot");
        DataConverterSchemaV99.a(var0, (Map<String, Supplier<TypeTemplate>>)var12, "VillagerGolem");
        var0.register((Map)var12, "EntityHorse", var1 -> DSL.optionalFields((String)"Items", (TypeTemplate)DSL.list((TypeTemplate)DataConverterTypes.t.in(var0)), (String)"ArmorItem", (TypeTemplate)DataConverterTypes.t.in(var0), (String)"SaddleItem", (TypeTemplate)DataConverterTypes.t.in(var0), (TypeTemplate)DataConverterSchemaV99.a(var0)));
        DataConverterSchemaV99.a(var0, (Map<String, Supplier<TypeTemplate>>)var12, "Rabbit");
        var0.register((Map)var12, "Villager", var1 -> DSL.optionalFields((String)"Inventory", (TypeTemplate)DSL.list((TypeTemplate)DataConverterTypes.t.in(var0)), (String)"Offers", (TypeTemplate)DSL.optionalFields((String)"Recipes", (TypeTemplate)DSL.list((TypeTemplate)DataConverterTypes.x.in(var0))), (TypeTemplate)DataConverterSchemaV99.a(var0)));
        var0.registerSimple((Map)var12, "EnderCrystal");
        var0.register((Map)var12, "AreaEffectCloud", var1 -> DSL.optionalFields((String)"Particle", (TypeTemplate)DataConverterTypes.y.in(var0)));
        var0.registerSimple((Map)var12, "ShulkerBullet");
        var0.registerSimple((Map)var12, "DragonFireball");
        DataConverterSchemaV99.a(var0, (Map<String, Supplier<TypeTemplate>>)var12, "Shulker");
        return var12;
    }

    public Map<String, Supplier<TypeTemplate>> registerBlockEntities(Schema var0) {
        HashMap var12 = Maps.newHashMap();
        DataConverterSchemaV99.d(var0, var12, "Furnace");
        DataConverterSchemaV99.d(var0, var12, "Chest");
        var0.registerSimple((Map)var12, "EnderChest");
        var0.register((Map)var12, "RecordPlayer", var1 -> DSL.optionalFields((String)"RecordItem", (TypeTemplate)DataConverterTypes.t.in(var0)));
        DataConverterSchemaV99.d(var0, var12, "Trap");
        DataConverterSchemaV99.d(var0, var12, "Dropper");
        var0.registerSimple((Map)var12, "Sign");
        var0.register((Map)var12, "MobSpawner", var1 -> DataConverterTypes.F.in(var0));
        var0.registerSimple((Map)var12, "Music");
        var0.registerSimple((Map)var12, "Piston");
        DataConverterSchemaV99.d(var0, var12, "Cauldron");
        var0.registerSimple((Map)var12, "EnchantTable");
        var0.registerSimple((Map)var12, "Airportal");
        var0.registerSimple((Map)var12, "Control");
        var0.registerSimple((Map)var12, "Beacon");
        var0.registerSimple((Map)var12, "Skull");
        var0.registerSimple((Map)var12, "DLDetector");
        DataConverterSchemaV99.d(var0, var12, "Hopper");
        var0.registerSimple((Map)var12, "Comparator");
        var0.register((Map)var12, "FlowerPot", var1 -> DSL.optionalFields((String)"Item", (TypeTemplate)DSL.or((TypeTemplate)DSL.constType((Type)DSL.intType()), (TypeTemplate)DataConverterTypes.D.in(var0))));
        var0.registerSimple((Map)var12, "Banner");
        var0.registerSimple((Map)var12, "Structure");
        var0.registerSimple((Map)var12, "EndGateway");
        return var12;
    }

    public void registerTypes(Schema var0, Map<String, Supplier<TypeTemplate>> var1, Map<String, Supplier<TypeTemplate>> var2) {
        var0.registerType(false, DataConverterTypes.a, DSL::remainder);
        var0.registerType(false, DataConverterTypes.b, () -> DSL.optionalFields((String)"Inventory", (TypeTemplate)DSL.list((TypeTemplate)DataConverterTypes.t.in(var0)), (String)"EnderItems", (TypeTemplate)DSL.list((TypeTemplate)DataConverterTypes.t.in(var0))));
        var0.registerType(false, DataConverterTypes.c, () -> DSL.fields((String)"Level", (TypeTemplate)DSL.optionalFields((String)"Entities", (TypeTemplate)DSL.list((TypeTemplate)DataConverterTypes.A.in(var0)), (String)"TileEntities", (TypeTemplate)DSL.list((TypeTemplate)DSL.or((TypeTemplate)DataConverterTypes.s.in(var0), (TypeTemplate)DSL.remainder())), (String)"TileTicks", (TypeTemplate)DSL.list((TypeTemplate)DSL.fields((String)"i", (TypeTemplate)DataConverterTypes.C.in(var0))))));
        var0.registerType(true, DataConverterTypes.s, () -> DSL.optionalFields((String)"components", (TypeTemplate)DataConverterTypes.w.in(var0), (TypeTemplate)DSL.taggedChoiceLazy((String)"id", (Type)DSL.string(), (Map)var2)));
        var0.registerType(true, DataConverterTypes.A, () -> DSL.optionalFields((String)"Riding", (TypeTemplate)DataConverterTypes.A.in(var0), (TypeTemplate)DataConverterTypes.B.in(var0)));
        var0.registerType(false, DataConverterTypes.z, () -> DSL.constType(DataConverterSchemaNamed.a()));
        var0.registerType(true, DataConverterTypes.B, () -> DSL.taggedChoiceLazy((String)"id", (Type)DSL.string(), (Map)var1));
        var0.registerType(true, DataConverterTypes.t, () -> DSL.hook((TypeTemplate)DSL.optionalFields((String)"id", (TypeTemplate)DSL.or((TypeTemplate)DSL.constType((Type)DSL.intType()), (TypeTemplate)DataConverterTypes.D.in(var0)), (String)"tag", (TypeTemplate)DSL.optionalFields((Pair[])new Pair[]{Pair.of((Object)"EntityTag", (Object)DataConverterTypes.A.in(var0)), Pair.of((Object)"BlockEntityTag", (Object)DataConverterTypes.s.in(var0)), Pair.of((Object)"CanDestroy", (Object)DSL.list((TypeTemplate)DataConverterTypes.C.in(var0))), Pair.of((Object)"CanPlaceOn", (Object)DSL.list((TypeTemplate)DataConverterTypes.C.in(var0))), Pair.of((Object)"Items", (Object)DSL.list((TypeTemplate)DataConverterTypes.t.in(var0))), Pair.of((Object)"ChargedProjectiles", (Object)DSL.list((TypeTemplate)DataConverterTypes.t.in(var0)))})), (Hook.HookFunction)b, (Hook.HookFunction)Hook.HookFunction.IDENTITY));
        var0.registerType(false, DataConverterTypes.e, DSL::remainder);
        var0.registerType(false, DataConverterTypes.C, () -> DSL.or((TypeTemplate)DSL.constType((Type)DSL.intType()), (TypeTemplate)DSL.constType(DataConverterSchemaNamed.a())));
        var0.registerType(false, DataConverterTypes.D, () -> DSL.constType(DataConverterSchemaNamed.a()));
        var0.registerType(false, DataConverterTypes.g, DSL::remainder);
        var0.registerType(false, DataConverterTypes.h, DSL::remainder);
        var0.registerType(false, DataConverterTypes.i, DSL::remainder);
        var0.registerType(false, DataConverterTypes.j, DSL::remainder);
        var0.registerType(false, DataConverterTypes.k, DSL::remainder);
        var0.registerType(false, DataConverterTypes.l, DSL::remainder);
        var0.registerType(false, DataConverterTypes.m, DSL::remainder);
        var0.registerType(false, DataConverterTypes.o, () -> DSL.optionalFields((String)"data", (TypeTemplate)DSL.optionalFields((String)"Objectives", (TypeTemplate)DSL.list((TypeTemplate)DataConverterTypes.H.in(var0)), (String)"Teams", (TypeTemplate)DSL.list((TypeTemplate)DataConverterTypes.I.in(var0)))));
        var0.registerType(false, DataConverterTypes.n, () -> DSL.optionalFields((String)"data", (TypeTemplate)DSL.optionalFields((String)"Features", (TypeTemplate)DSL.compoundList((TypeTemplate)DataConverterTypes.G.in(var0)))));
        var0.registerType(false, DataConverterTypes.G, DSL::remainder);
        var0.registerType(false, DataConverterTypes.H, DSL::remainder);
        var0.registerType(false, DataConverterTypes.I, DSL::remainder);
        var0.registerType(true, DataConverterTypes.F, DSL::remainder);
        var0.registerType(false, DataConverterTypes.q, DSL::remainder);
        var0.registerType(false, DataConverterTypes.M, DSL::remainder);
        var0.registerType(false, DataConverterTypes.r, () -> DSL.optionalFields((String)"Entities", (TypeTemplate)DSL.list((TypeTemplate)DataConverterTypes.A.in(var0))));
        var0.registerType(true, DataConverterTypes.w, DSL::remainder);
        var0.registerType(true, DataConverterTypes.x, () -> DSL.optionalFields((String)"buy", (TypeTemplate)DataConverterTypes.t.in(var0), (String)"buyB", (TypeTemplate)DataConverterTypes.t.in(var0), (String)"sell", (TypeTemplate)DataConverterTypes.t.in(var0)));
        var0.registerType(true, DataConverterTypes.y, () -> DSL.constType((Type)DSL.string()));
    }

    protected static <T> T a(Dynamic<T> var0, Map<String, String> var1, Map<String, String> var2) {
        return (T)var0.update("tag", var3 -> var3.update("BlockEntityTag", var2 -> {
            Object var3 = var0.get("id").asString().result().map(DataConverterSchemaNamed::a).orElse("minecraft:air");
            if (!"minecraft:air".equals(var3)) {
                String var4 = (String)var1.get(var3);
                if (var4 == null) {
                    c.warn("Unable to resolve BlockEntity for ItemStack: {}", var3);
                } else {
                    return var2.set("id", var0.createString(var4));
                }
            }
            return var2;
        }).update("EntityTag", var2 -> {
            if (var2.get("id").result().isPresent()) {
                return var2;
            }
            Object var3 = DataConverterSchemaNamed.a(var0.get("id").asString(""));
            String var4 = (String)var2.get(var3);
            if (var4 != null) {
                return var2.set("id", var0.createString(var4));
            }
            return var2;
        })).getValue();
    }
}

