/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import it.unimi.dsi.fastutil.doubles.DoubleListIterator;
import it.unimi.dsi.fastutil.floats.FloatArraySet;
import it.unimi.dsi.fastutil.floats.FloatArrays;
import it.unimi.dsi.fastutil.objects.Object2DoubleArrayMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICommandListener;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IPosition;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutAttachEntity;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.protocol.game.VecDeltaCodec;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.network.syncher.SyncedDataHolder;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsEntity;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.INamableTileEntity;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.PortalProcessor;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFenceGate;
import net.minecraft.world.level.block.BlockHoney;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.Portal;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.EntityInLevelCallback;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.portal.BlockPortalShape;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_21_R1.CraftServer;
import org.bukkit.craftbukkit.v1_21_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R1.SpigotTimings;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftPortalEvent;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftLocation;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Pose;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityAirChangeEvent;
import org.bukkit.event.entity.EntityCombustByBlockEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDismountEvent;
import org.bukkit.event.entity.EntityDropItemEvent;
import org.bukkit.event.entity.EntityMountEvent;
import org.bukkit.event.entity.EntityPortalEvent;
import org.bukkit.event.entity.EntityPoseChangeEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.entity.EntityUnleashEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.vehicle.VehicleBlockCollisionEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.plugin.PluginManager;
import org.bukkit.projectiles.ProjectileSource;
import org.slf4j.Logger;
import org.spigotmc.ActivationRange;
import org.spigotmc.CustomTimingsHandler;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class Entity
implements SyncedDataHolder,
INamableTileEntity,
EntityAccess,
ICommandListener,
ScoreHolder {
    private static final int CURRENT_LEVEL = 2;
    private CraftEntity bukkitEntity;
    private static final Logger b = LogUtils.getLogger();
    public static final String w = "id";
    public static final String x = "Passengers";
    private static final AtomicInteger c = new AtomicInteger();
    public static final int y = 0;
    public static final int z = 60;
    public static final int A = 300;
    public static final int B = 1024;
    public static final float C = 0.2f;
    public static final double D = 0.500001;
    public static final double E = 0.999999;
    public static final int F = 140;
    public static final int G = 40;
    public static final int H = 3;
    private static final AxisAlignedBB d = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private static final double e = 0.014;
    private static final double k = 0.007;
    private static final double l = 0.0023333333333333335;
    public static final String I = "UUID";
    private static double m = 1.0;
    private final EntityTypes<?> n;
    private int o;
    public boolean J;
    public ImmutableList<Entity> p;
    protected int K;
    @Nullable
    private Entity q;
    private net.minecraft.world.level.World r;
    public double L;
    public double M;
    public double N;
    private Vec3D s;
    private BlockPosition t;
    private ChunkCoordIntPair u;
    private Vec3D v;
    private float aD;
    private float aE;
    public float O;
    public float P;
    private AxisAlignedBB aF;
    public boolean aG;
    public boolean Q;
    public boolean R;
    public boolean S;
    public boolean T;
    public boolean U;
    protected Vec3D V;
    @Nullable
    private RemovalReason aH;
    public static final float W = 0.6f;
    public static final float X = 1.8f;
    public float Y;
    public float Z;
    public float aa;
    public float ab;
    public float ac;
    private float aI = 1.0f;
    public double ad;
    public double ae;
    public double af;
    public boolean ag;
    public final RandomSource ah;
    public int ai;
    private int aJ;
    public boolean aj;
    protected Object2DoubleMap<TagKey<FluidType>> ak;
    protected boolean al;
    private final Set<TagKey<FluidType>> aK;
    public int am;
    protected boolean an = true;
    protected final DataWatcher ao;
    protected static final DataWatcherObject<Byte> ap = DataWatcher.a(Entity.class, DataWatcherRegistry.a);
    protected static final int aq = 0;
    private static final int aL = 1;
    private static final int aM = 3;
    private static final int aN = 4;
    private static final int aO = 5;
    protected static final int ar = 6;
    protected static final int as = 7;
    private static final DataWatcherObject<Integer> aP = DataWatcher.a(Entity.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Optional<IChatBaseComponent>> aQ = DataWatcher.a(Entity.class, DataWatcherRegistry.g);
    private static final DataWatcherObject<Boolean> aR = DataWatcher.a(Entity.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> aS = DataWatcher.a(Entity.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> aT = DataWatcher.a(Entity.class, DataWatcherRegistry.k);
    protected static final DataWatcherObject<EntityPose> at = DataWatcher.a(Entity.class, DataWatcherRegistry.w);
    private static final DataWatcherObject<Integer> aU = DataWatcher.a(Entity.class, DataWatcherRegistry.b);
    private EntityInLevelCallback aV;
    private final VecDeltaCodec aW;
    public boolean au;
    public boolean av;
    @Nullable
    public PortalProcessor aw;
    public int aX;
    private boolean aY;
    protected UUID ax;
    protected String ay;
    private boolean aZ;
    private final Set<String> ba;
    private final double[] bb;
    private long bc;
    private EntitySize bd;
    private float be;
    public boolean az;
    public boolean aA;
    public boolean aB;
    public Optional<BlockPosition> aC;
    private boolean bf = false;
    private float bg;
    private int bh;
    public boolean bi;
    @Nullable
    private IBlockData bj = null;
    public boolean forceDrops;
    public boolean persist = true;
    public boolean visibleByDefault = true;
    public boolean valid;
    public boolean inWorld = false;
    public boolean generation;
    public int maxAirTicks = this.getDefaultMaxAirSupply();
    public ProjectileSource projectileSource;
    public boolean lastDamageCancelled;
    public boolean persistentInvisibility = false;
    public BlockPosition lastLavaContact;
    public boolean pluginRemoved = false;
    public CustomTimingsHandler tickTimer = SpigotTimings.getEntityTimings(this);
    public final ActivationRange.ActivationType activationType = ActivationRange.initializeEntityActivationType(this);
    public final boolean defaultActivationState;
    public long activatedTick = Integer.MIN_VALUE;

    static boolean isLevelAtLeast(NBTTagCompound tag, int level) {
        return tag.e("Bukkit.updateLevel") && tag.h("Bukkit.updateLevel") >= level;
    }

    public CraftEntity getBukkitEntity() {
        if (this.bukkitEntity == null) {
            this.bukkitEntity = CraftEntity.getEntity(this.r.getCraftServer(), this);
        }
        return this.bukkitEntity;
    }

    @Override
    public CommandSender getBukkitSender(CommandListenerWrapper wrapper) {
        return this.getBukkitEntity();
    }

    public int getDefaultMaxAirSupply() {
        return 300;
    }

    public void inactiveTick() {
    }

    public float getBukkitYaw() {
        return this.aD;
    }

    public boolean isChunkLoaded() {
        return this.r.b((int)Math.floor(this.dt()) >> 4, (int)Math.floor(this.dz()) >> 4);
    }

    public Entity(EntityTypes<?> entitytypes, net.minecraft.world.level.World world) {
        this.o = c.incrementAndGet();
        this.p = ImmutableList.of();
        this.v = Vec3D.b;
        this.aF = d;
        this.V = Vec3D.b;
        this.ah = RandomSource.a();
        this.aJ = -this.df();
        this.ak = new Object2DoubleArrayMap(2);
        this.aK = new HashSet<TagKey<FluidType>>();
        this.aV = EntityInLevelCallback.a;
        this.aW = new VecDeltaCodec();
        this.ax = MathHelper.a(this.ah);
        this.ay = this.ax.toString();
        this.ba = Sets.newHashSet();
        this.bb = new double[]{0.0, 0.0, 0.0};
        this.aC = Optional.empty();
        this.n = entitytypes;
        this.r = world;
        this.bd = entitytypes.n();
        this.s = Vec3D.b;
        this.t = BlockPosition.c;
        this.u = ChunkCoordIntPair.b;
        this.defaultActivationState = world != null ? ActivationRange.initializeEntityActivationState(this, world.spigotConfig) : false;
        DataWatcher.a datawatcher_a = new DataWatcher.a(this);
        datawatcher_a.a(ap, (byte)0);
        datawatcher_a.a(aP, this.cl());
        datawatcher_a.a(aR, false);
        datawatcher_a.a(aQ, Optional.empty());
        datawatcher_a.a(aS, false);
        datawatcher_a.a(aT, false);
        datawatcher_a.a(at, EntityPose.a);
        datawatcher_a.a(aU, 0);
        this.a(datawatcher_a);
        this.ao = datawatcher_a.a();
        this.a_(0.0, 0.0, 0.0);
        this.be = this.bd.c();
    }

    public boolean a(BlockPosition blockposition, IBlockData iblockdata) {
        VoxelShape voxelshape = iblockdata.b((IBlockAccess)this.dO(), blockposition, VoxelShapeCollision.a(this));
        VoxelShape voxelshape1 = voxelshape.a((double)blockposition.u(), (double)blockposition.v(), (double)blockposition.w());
        return VoxelShapes.c(voxelshape1, VoxelShapes.a(this.cK()), OperatorBoolean.i);
    }

    public int q_() {
        ScoreboardTeam scoreboardteam = this.ck();
        return scoreboardteam != null && scoreboardteam.n().f() != null ? scoreboardteam.n().f() : 0xFFFFFF;
    }

    public boolean R_() {
        return false;
    }

    public final void ak() {
        if (this.bT()) {
            this.bI();
        }
        if (this.bS()) {
            this.ad();
        }
    }

    public void f(double d0, double d1, double d2) {
        this.aW.e(new Vec3D(d0, d1, d2));
    }

    public VecDeltaCodec al() {
        return this.aW;
    }

    public EntityTypes<?> am() {
        return this.n;
    }

    @Override
    public int an() {
        return this.o;
    }

    public void e(int i2) {
        this.o = i2;
    }

    public Set<String> ao() {
        return this.ba;
    }

    public boolean a(String s2) {
        return this.ba.size() >= 1024 ? false : this.ba.add(s2);
    }

    public boolean b(String s2) {
        return this.ba.remove(s2);
    }

    public void ap() {
        this.remove(RemovalReason.a, EntityRemoveEvent.Cause.DEATH);
        this.a(GameEvent.p);
    }

    public final void aq() {
        this.discard(null);
    }

    public final void discard(EntityRemoveEvent.Cause cause) {
        this.remove(RemovalReason.b, cause);
    }

    protected abstract void a(DataWatcher.a var1);

    public DataWatcher ar() {
        return this.ao;
    }

    public void refreshEntityData(EntityPlayer to) {
        List<DataWatcher.c<?>> list = this.ar().c();
        if (list != null) {
            to.c.b(new PacketPlayOutEntityMetadata(this.an(), list));
        }
    }

    public boolean equals(Object object) {
        return object instanceof Entity ? ((Entity)object).o == this.o : false;
    }

    public int hashCode() {
        return this.o;
    }

    public void a(RemovalReason entity_removalreason) {
        this.setRemoved(entity_removalreason, null);
    }

    public void remove(RemovalReason entity_removalreason, EntityRemoveEvent.Cause cause) {
        this.setRemoved(entity_removalreason, cause);
    }

    public void as() {
    }

    public void b(EntityPose entitypose) {
        if (entitypose == this.at()) {
            return;
        }
        this.r.getCraftServer().getPluginManager().callEvent((Event)new EntityPoseChangeEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), Pose.values()[entitypose.ordinal()]));
        this.ao.a(at, entitypose);
    }

    public EntityPose at() {
        return this.ao.a(at);
    }

    public boolean c(EntityPose entitypose) {
        return this.at() == entitypose;
    }

    public boolean a(Entity entity, double d0) {
        return this.dm().a((IPosition)entity.dm(), d0);
    }

    public boolean a(Entity entity, double d0, double d1) {
        double d2 = entity.dt() - this.dt();
        double d3 = entity.dv() - this.dv();
        double d4 = entity.dz() - this.dz();
        return MathHelper.e(d2, d4) < MathHelper.k(d0) && MathHelper.k(d3) < MathHelper.k(d1);
    }

    protected void a(float f2, float f1) {
        if (Float.isNaN(f2)) {
            f2 = 0.0f;
        }
        if (f2 == Float.POSITIVE_INFINITY || f2 == Float.NEGATIVE_INFINITY) {
            if (this instanceof EntityPlayer) {
                this.r.getCraftServer().getLogger().warning(this.cB() + " was caught trying to crash the server with an invalid yaw");
                ((CraftPlayer)this.getBukkitEntity()).kickPlayer("Infinite yaw (Hacking?)");
            }
            f2 = 0.0f;
        }
        if (Float.isNaN(f1)) {
            f1 = 0.0f;
        }
        if (f1 == Float.POSITIVE_INFINITY || f1 == Float.NEGATIVE_INFINITY) {
            if (this instanceof EntityPlayer) {
                this.r.getCraftServer().getLogger().warning(this.cB() + " was caught trying to crash the server with an invalid pitch");
                ((CraftPlayer)this.getBukkitEntity()).kickPlayer("Infinite pitch (Hacking?)");
            }
            f1 = 0.0f;
        }
        this.t(f2 % 360.0f);
        this.u(f1 % 360.0f);
    }

    public final void c(Vec3D vec3d) {
        this.a_(vec3d.a(), vec3d.b(), vec3d.c());
    }

    public void a_(double d0, double d1, double d2) {
        this.o(d0, d1, d2);
        this.a(this.au());
    }

    protected AxisAlignedBB au() {
        return this.bd.a(this.s);
    }

    protected void av() {
        this.a_(this.s.c, this.s.d, this.s.e);
    }

    public void b(double d0, double d1) {
        float f2 = (float)d1 * 0.15f;
        float f1 = (float)d0 * 0.15f;
        this.u(this.dG() + f2);
        this.t(this.dE() + f1);
        this.u(MathHelper.a(this.dG(), -90.0f, 90.0f));
        this.P += f2;
        this.O += f1;
        this.P = MathHelper.a(this.P, -90.0f, 90.0f);
        if (this.q != null) {
            this.q.k(this);
        }
    }

    public void l() {
        this.aw();
    }

    public void postTick() {
        if (!(this instanceof EntityPlayer)) {
            this.bP();
        }
    }

    public void aw() {
        this.dO().ag().a("entityBaseTick");
        this.bj = null;
        if (this.bS() && this.dc().dJ()) {
            this.ad();
        }
        if (this.K > 0) {
            --this.K;
        }
        this.Y = this.Z;
        this.P = this.dG();
        this.O = this.dE();
        if (this instanceof EntityPlayer) {
            this.bP();
        }
        if (this.br()) {
            this.bs();
        }
        this.aA = this.az;
        this.az = false;
        this.bm();
        this.H();
        this.bl();
        if (this.dO().B) {
            this.aD();
        } else if (this.aJ > 0) {
            if (this.be()) {
                this.h(this.aJ - 4);
                if (this.aJ < 0) {
                    this.aD();
                }
            } else {
                if (this.aJ % 20 == 0 && !this.bt()) {
                    this.a(this.dP().d(), 1.0f);
                }
                this.h(this.aJ - 1);
            }
            if (this.cn() > 0) {
                this.k(0);
                this.dO().a((EntityHuman)null, 1009, this.t, 1);
            }
        }
        if (this.bt()) {
            this.aB();
            this.ac *= 0.5f;
        } else {
            this.lastLavaContact = null;
        }
        this.ax();
        if (!this.dO().B) {
            this.c(this.aJ > 0);
        }
        this.an = false;
        if (!this.dO().B && this instanceof Leashable) {
            Leashable.b_((Entity)((Object)((Leashable)((Object)this))));
        }
        this.dO().ag().c();
    }

    public void c(boolean flag) {
        this.b(0, flag || this.bi);
    }

    public void ax() {
        if (this.dv() < (double)(this.dO().I_() - 64)) {
            this.aE();
        }
    }

    public void ay() {
        this.aX = this.bQ();
    }

    public void f(int i2) {
        this.aX = i2;
    }

    public int az() {
        return this.aX;
    }

    public boolean aA() {
        return this.aX > 0;
    }

    protected void M() {
        if (this.aA()) {
            --this.aX;
        }
    }

    public void aB() {
        if (!this.be()) {
            if (this instanceof EntityLiving && this.aJ <= 0) {
                CraftBlock damager = this.lastLavaContact == null ? null : CraftBlock.at(this.r, this.lastLavaContact);
                CraftEntity damagee = this.getBukkitEntity();
                EntityCombustByBlockEvent combustEvent = new EntityCombustByBlockEvent((org.bukkit.block.Block)damager, (org.bukkit.entity.Entity)damagee, 15);
                this.r.getCraftServer().getPluginManager().callEvent((Event)combustEvent);
                if (!combustEvent.isCancelled()) {
                    this.igniteForSeconds(combustEvent.getDuration(), false);
                }
            } else {
                this.igniteForSeconds(15.0f, false);
            }
            if (this.a(this.dP().e().directBlock(this.r, this.lastLavaContact), 4.0f)) {
                this.a(SoundEffects.ka, 0.4f, 2.0f + this.ah.i() * 0.4f);
            }
        }
    }

    public final void d(float f2) {
        this.igniteForSeconds(f2, true);
    }

    public final void igniteForSeconds(float f2, boolean callEvent) {
        if (callEvent) {
            EntityCombustEvent event = new EntityCombustEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), f2);
            this.r.getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            f2 = event.getDuration();
        }
        this.g(MathHelper.d(f2 * 20.0f));
    }

    public void g(int i2) {
        if (this.aJ < i2) {
            this.h(i2);
        }
    }

    public void h(int i2) {
        this.aJ = i2;
    }

    public int aC() {
        return this.aJ;
    }

    public void aD() {
        this.h(0);
    }

    protected void aE() {
        this.discard(EntityRemoveEvent.Cause.OUT_OF_WORLD);
    }

    public boolean g(double d0, double d1, double d2) {
        return this.b(this.cK().d(d0, d1, d2));
    }

    private boolean b(AxisAlignedBB axisalignedbb) {
        return this.dO().a(this, axisalignedbb) && !this.dO().d(axisalignedbb);
    }

    public void d(boolean flag) {
        this.aG = flag;
        this.b(flag, (Vec3D)null);
    }

    public void a(boolean flag, Vec3D vec3d) {
        this.aG = flag;
        this.b(flag, vec3d);
    }

    public boolean d(BlockPosition blockposition) {
        return this.aC.isPresent() && this.aC.get().equals(blockposition);
    }

    protected void b(boolean flag, @Nullable Vec3D vec3d) {
        if (flag) {
            AxisAlignedBB axisalignedbb = this.cK();
            AxisAlignedBB axisalignedbb1 = new AxisAlignedBB(axisalignedbb.a, axisalignedbb.b - 1.0E-6, axisalignedbb.c, axisalignedbb.d, axisalignedbb.b, axisalignedbb.f);
            Optional<BlockPosition> optional = this.r.g(this, axisalignedbb1);
            if (!optional.isPresent() && !this.bf) {
                if (vec3d != null) {
                    AxisAlignedBB axisalignedbb2 = axisalignedbb1.d(-vec3d.c, 0.0, -vec3d.e);
                    optional = this.r.g(this, axisalignedbb2);
                    this.aC = optional;
                }
            } else {
                this.aC = optional;
            }
            this.bf = optional.isEmpty();
        } else {
            this.bf = false;
            if (this.aC.isPresent()) {
                this.aC = Optional.empty();
            }
        }
    }

    public boolean aF() {
        return this.aG;
    }

    public void a(EnumMoveType enummovetype, Vec3D vec3d) {
        SpigotTimings.entityMoveTimer.startTiming();
        if (this.ag) {
            this.a_(this.dt() + vec3d.c, this.dv() + vec3d.d, this.dz() + vec3d.e);
        } else {
            Vec3D vec3d1;
            double d0;
            this.aB = this.bR();
            if (enummovetype == EnumMoveType.c && (vec3d = this.e(vec3d)).equals(Vec3D.b)) {
                return;
            }
            this.dO().ag().a("move");
            if (this.V.g() > 1.0E-7) {
                vec3d = vec3d.h(this.V);
                this.V = Vec3D.b;
                this.i(Vec3D.b);
            }
            if ((d0 = (vec3d1 = this.a(vec3d = this.a(vec3d, enummovetype))).g()) > 1.0E-7) {
                MovingObjectPositionBlock movingobjectpositionblock;
                if (this.ac != 0.0f && d0 >= 1.0 && (movingobjectpositionblock = this.dO().a(new RayTrace(this.dm(), this.dm().e(vec3d1), RayTrace.BlockCollisionOption.d, RayTrace.FluidCollisionOption.d, this))).c() != MovingObjectPosition.EnumMovingObjectType.a) {
                    this.n();
                }
                this.a_(this.dt() + vec3d1.c, this.dv() + vec3d1.d, this.dz() + vec3d1.e);
            }
            this.dO().ag().c();
            this.dO().ag().a("rest");
            boolean flag = !MathHelper.b(vec3d.c, vec3d1.c);
            boolean flag1 = !MathHelper.b(vec3d.e, vec3d1.e);
            this.Q = flag || flag1;
            this.R = vec3d.d != vec3d1.d;
            this.S = this.R && vec3d.d < 0.0;
            this.T = this.Q ? this.d(vec3d1) : false;
            this.a(this.S, vec3d1);
            BlockPosition blockposition = this.aK();
            IBlockData iblockdata = this.dO().a_(blockposition);
            this.a(vec3d1.d, this.aF(), iblockdata, blockposition);
            if (this.dJ()) {
                this.dO().ag().c();
            } else {
                MovementEmission entity_movementemission;
                if (this.Q) {
                    Vec3D vec3d2 = this.dr();
                    this.n(flag ? 0.0 : vec3d2.c, vec3d2.d, flag1 ? 0.0 : vec3d2.e);
                }
                Block block = iblockdata.b();
                if (vec3d.d != vec3d1.d) {
                    block.a(this.dO(), this);
                }
                if (this.Q && this.getBukkitEntity() instanceof Vehicle) {
                    Vehicle vehicle = (Vehicle)this.getBukkitEntity();
                    org.bukkit.block.Block bl = this.r.getWorld().getBlockAt(MathHelper.a(this.dt()), MathHelper.a(this.dv()), MathHelper.a(this.dz()));
                    if (vec3d.c > vec3d1.c) {
                        bl = bl.getRelative(BlockFace.EAST);
                    } else if (vec3d.c < vec3d1.c) {
                        bl = bl.getRelative(BlockFace.WEST);
                    } else if (vec3d.e > vec3d1.e) {
                        bl = bl.getRelative(BlockFace.SOUTH);
                    } else if (vec3d.e < vec3d1.e) {
                        bl = bl.getRelative(BlockFace.NORTH);
                    }
                    if (!bl.getType().isAir()) {
                        VehicleBlockCollisionEvent event = new VehicleBlockCollisionEvent(vehicle, bl);
                        this.r.getCraftServer().getPluginManager().callEvent((Event)event);
                    }
                }
                if (this.aF()) {
                    block.a(this.dO(), blockposition, iblockdata, this);
                }
                if ((entity_movementemission = this.bc()).a() && !this.bS()) {
                    double d1 = vec3d1.c;
                    double d2 = vec3d1.d;
                    double d3 = vec3d1.e;
                    this.ab += (float)(vec3d1.f() * 0.6);
                    BlockPosition blockposition1 = this.aM();
                    IBlockData iblockdata1 = this.dO().a_(blockposition1);
                    boolean flag2 = this.c(iblockdata1);
                    if (!flag2) {
                        d2 = 0.0;
                    }
                    this.Z += (float)vec3d1.h() * 0.6f;
                    this.aa += (float)Math.sqrt(d1 * d1 + d2 * d2 + d3 * d3) * 0.6f;
                    if (this.aa > this.aI && !iblockdata1.i()) {
                        boolean flag3 = blockposition1.equals(blockposition);
                        boolean flag4 = this.a(blockposition, iblockdata, entity_movementemission.c(), flag3, vec3d);
                        if (!flag3) {
                            flag4 |= this.a(blockposition1, iblockdata1, false, entity_movementemission.b(), vec3d);
                        }
                        if (flag4) {
                            this.aI = this.aP();
                        } else if (this.bf()) {
                            this.aI = this.aP();
                            if (entity_movementemission.c()) {
                                this.aU();
                            }
                            if (entity_movementemission.b()) {
                                this.a(GameEvent.Q);
                            }
                        }
                    } else if (iblockdata1.i()) {
                        this.aJ();
                    }
                }
                this.aG();
                float f2 = this.aO();
                this.i(this.dr().d(f2, 1.0, f2));
                if (this.dO().c(this.cK().h(1.0E-6)).noneMatch(iblockdata2 -> iblockdata2.a(TagsBlock.aL) || iblockdata2.a(Blocks.H))) {
                    if (this.aJ <= 0) {
                        this.h(-this.df());
                    }
                    if (this.aB && (this.az || this.bh())) {
                        this.aH();
                    }
                }
                if (this.bR() && (this.az || this.bh())) {
                    this.h(-this.df());
                }
                this.dO().ag().c();
            }
        }
        SpigotTimings.entityMoveTimer.stopTiming();
    }

    private boolean c(IBlockData iblockdata) {
        return iblockdata.a(TagsBlock.aQ) || iblockdata.a(Blocks.qP);
    }

    private boolean a(BlockPosition blockposition, IBlockData iblockdata, boolean flag, boolean flag1, Vec3D vec3d) {
        if (iblockdata.i()) {
            return false;
        }
        boolean flag2 = this.c(iblockdata);
        if ((this.aF() || flag2 || this.cb() && vec3d.d == 0.0 || this.cj()) && !this.cd()) {
            if (flag) {
                this.c(blockposition, iblockdata);
            }
            if (flag1) {
                this.dO().a(GameEvent.P, this.dm(), GameEvent.a.a(this, iblockdata));
            }
            return true;
        }
        return false;
    }

    protected boolean d(Vec3D vec3d) {
        return false;
    }

    protected void aG() {
        try {
            this.aT();
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.a(throwable, "Checking entity block collision");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Entity being checked for collision");
            this.a(crashreportsystemdetails);
            throw new ReportedException(crashreport);
        }
    }

    protected void aH() {
        this.a(SoundEffects.kf, 0.7f, 1.6f + (this.ah.i() - this.ah.i()) * 0.4f);
    }

    public void aI() {
        if (!this.dO().B && this.aB) {
            this.aH();
        }
        this.aD();
    }

    protected void aJ() {
        if (this.aW()) {
            this.aV();
            if (this.bc().b()) {
                this.a(GameEvent.x);
            }
        }
    }

    @Deprecated
    public BlockPosition aK() {
        return this.e(0.2f);
    }

    public BlockPosition aL() {
        return this.e(0.500001f);
    }

    public BlockPosition aM() {
        return this.e(1.0E-5f);
    }

    protected BlockPosition e(float f2) {
        if (this.aC.isPresent()) {
            BlockPosition blockposition = this.aC.get();
            if (f2 <= 1.0E-5f) {
                return blockposition;
            }
            IBlockData iblockdata = this.dO().a_(blockposition);
            return ((double)f2 > 0.5 || !iblockdata.a(TagsBlock.T)) && !iblockdata.a(TagsBlock.M) && !(iblockdata.b() instanceof BlockFenceGate) ? blockposition.h(MathHelper.a(this.s.d - (double)f2)) : blockposition;
        }
        int i2 = MathHelper.a(this.s.c);
        int j2 = MathHelper.a(this.s.d - (double)f2);
        int k2 = MathHelper.a(this.s.e);
        return new BlockPosition(i2, j2, k2);
    }

    protected float aN() {
        float f2 = this.dO().a_(this.do()).b().k();
        float f1 = this.dO().a_(this.aL()).b().k();
        return (double)f2 == 1.0 ? f1 : f2;
    }

    protected float aO() {
        IBlockData iblockdata = this.dO().a_(this.do());
        float f2 = iblockdata.b().j();
        return !iblockdata.a(Blocks.G) && !iblockdata.a(Blocks.nd) ? ((double)f2 == 1.0 ? this.dO().a_(this.aL()).b().j() : f2) : f2;
    }

    protected Vec3D a(Vec3D vec3d, EnumMoveType enummovetype) {
        return vec3d;
    }

    protected Vec3D e(Vec3D vec3d) {
        if (vec3d.g() <= 1.0E-7) {
            return vec3d;
        }
        long i2 = this.dO().Z();
        if (i2 != this.bc) {
            Arrays.fill(this.bb, 0.0);
            this.bc = i2;
        }
        if (vec3d.c != 0.0) {
            double d0 = this.a(EnumDirection.EnumAxis.a, vec3d.c);
            return Math.abs(d0) <= (double)1.0E-5f ? Vec3D.b : new Vec3D(d0, 0.0, 0.0);
        }
        if (vec3d.d != 0.0) {
            double d0 = this.a(EnumDirection.EnumAxis.b, vec3d.d);
            return Math.abs(d0) <= (double)1.0E-5f ? Vec3D.b : new Vec3D(0.0, d0, 0.0);
        }
        if (vec3d.e != 0.0) {
            double d0 = this.a(EnumDirection.EnumAxis.c, vec3d.e);
            return Math.abs(d0) <= (double)1.0E-5f ? Vec3D.b : new Vec3D(0.0, 0.0, d0);
        }
        return Vec3D.b;
    }

    private double a(EnumDirection.EnumAxis enumdirection_enumaxis, double d0) {
        int i2 = enumdirection_enumaxis.ordinal();
        double d1 = MathHelper.a(d0 + this.bb[i2], -0.51, 0.51);
        d0 = d1 - this.bb[i2];
        this.bb[i2] = d1;
        return d0;
    }

    private Vec3D a(Vec3D vec3d) {
        boolean flag3;
        AxisAlignedBB axisalignedbb = this.cK();
        List<VoxelShape> list = this.dO().c(this, axisalignedbb.b(vec3d));
        Vec3D vec3d1 = vec3d.g() == 0.0 ? vec3d : Entity.a(this, vec3d, axisalignedbb, this.dO(), list);
        boolean flag = vec3d.c != vec3d1.c;
        boolean flag1 = vec3d.d != vec3d1.d;
        boolean flag2 = vec3d.e != vec3d1.e;
        boolean bl = flag3 = flag1 && vec3d.d < 0.0;
        if (this.dI() > 0.0f && (flag3 || this.aF()) && (flag || flag2)) {
            float[] afloat;
            AxisAlignedBB axisalignedbb1 = flag3 ? axisalignedbb.d(0.0, vec3d1.d, 0.0) : axisalignedbb;
            AxisAlignedBB axisalignedbb2 = axisalignedbb1.b(vec3d.c, this.dI(), vec3d.e);
            if (!flag3) {
                axisalignedbb2 = axisalignedbb2.b(0.0, -1.0E-5f, 0.0);
            }
            List<VoxelShape> list1 = Entity.a(this, this.r, list, axisalignedbb2);
            float f2 = (float)vec3d1.d;
            float[] afloat1 = afloat = Entity.a(axisalignedbb1, list1, this.dI(), f2);
            int i2 = afloat.length;
            for (int j2 = 0; j2 < i2; ++j2) {
                float f1 = afloat1[j2];
                Vec3D vec3d2 = Entity.a(new Vec3D(vec3d.c, f1, vec3d.e), axisalignedbb1, list1);
                if (!(vec3d2.i() > vec3d1.i())) continue;
                double d0 = axisalignedbb.b - axisalignedbb1.b;
                return vec3d2.b(0.0, -d0, 0.0);
            }
        }
        return vec3d1;
    }

    private static float[] a(AxisAlignedBB axisalignedbb, List<VoxelShape> list, float f2, float f1) {
        FloatArraySet floatarrayset = new FloatArraySet(4);
        block0: for (VoxelShape voxelshape : list) {
            DoubleList doublelist = voxelshape.a(EnumDirection.EnumAxis.b);
            DoubleListIterator doublelistiterator = doublelist.iterator();
            while (doublelistiterator.hasNext()) {
                double d0 = doublelistiterator.next();
                float f22 = (float)(d0 - axisalignedbb.b);
                if (!(f22 >= 0.0f) || f22 == f1) continue;
                if (f22 > f2) continue block0;
                floatarrayset.add(f22);
            }
        }
        float[] afloat = floatarrayset.toFloatArray();
        FloatArrays.unstableSort((float[])afloat);
        return afloat;
    }

    public static Vec3D a(@Nullable Entity entity, Vec3D vec3d, AxisAlignedBB axisalignedbb, net.minecraft.world.level.World world, List<VoxelShape> list) {
        List<VoxelShape> list1 = Entity.a(entity, world, list, axisalignedbb.b(vec3d));
        return Entity.a(vec3d, axisalignedbb, list1);
    }

    private static List<VoxelShape> a(@Nullable Entity entity, net.minecraft.world.level.World world, List<VoxelShape> list, AxisAlignedBB axisalignedbb) {
        boolean flag;
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)(list.size() + 1));
        if (!list.isEmpty()) {
            builder.addAll(list);
        }
        WorldBorder worldborder = world.C_();
        boolean bl = flag = entity != null && worldborder.a(entity, axisalignedbb);
        if (flag) {
            builder.add((Object)worldborder.c());
        }
        builder.addAll(world.e(entity, axisalignedbb));
        return builder.build();
    }

    private static Vec3D a(Vec3D vec3d, AxisAlignedBB axisalignedbb, List<VoxelShape> list) {
        boolean flag;
        if (list.isEmpty()) {
            return vec3d;
        }
        double d0 = vec3d.c;
        double d1 = vec3d.d;
        double d2 = vec3d.e;
        if (d1 != 0.0 && (d1 = VoxelShapes.a(EnumDirection.EnumAxis.b, axisalignedbb, list, d1)) != 0.0) {
            axisalignedbb = axisalignedbb.d(0.0, d1, 0.0);
        }
        boolean bl = flag = Math.abs(d0) < Math.abs(d2);
        if (flag && d2 != 0.0 && (d2 = VoxelShapes.a(EnumDirection.EnumAxis.c, axisalignedbb, list, d2)) != 0.0) {
            axisalignedbb = axisalignedbb.d(0.0, 0.0, d2);
        }
        if (d0 != 0.0) {
            d0 = VoxelShapes.a(EnumDirection.EnumAxis.a, axisalignedbb, list, d0);
            if (!flag && d0 != 0.0) {
                axisalignedbb = axisalignedbb.d(d0, 0.0, 0.0);
            }
        }
        if (!flag && d2 != 0.0) {
            d2 = VoxelShapes.a(EnumDirection.EnumAxis.c, axisalignedbb, list, d2);
        }
        return new Vec3D(d0, d1, d2);
    }

    protected float aP() {
        return (int)this.aa + 1;
    }

    protected SoundEffect aQ() {
        return SoundEffects.kj;
    }

    protected SoundEffect aR() {
        return SoundEffects.ki;
    }

    protected SoundEffect aS() {
        return SoundEffects.ki;
    }

    public SoundEffect getSwimSound0() {
        return this.aQ();
    }

    public SoundEffect getSwimSplashSound0() {
        return this.aR();
    }

    public SoundEffect getSwimHighSpeedSplashSound0() {
        return this.aS();
    }

    protected void aT() {
        AxisAlignedBB axisalignedbb = this.cK();
        BlockPosition blockposition = BlockPosition.a(axisalignedbb.a + 1.0E-7, axisalignedbb.b + 1.0E-7, axisalignedbb.c + 1.0E-7);
        BlockPosition blockposition1 = BlockPosition.a(axisalignedbb.d - 1.0E-7, axisalignedbb.e - 1.0E-7, axisalignedbb.f - 1.0E-7);
        if (this.dO().a(blockposition, blockposition1)) {
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
            for (int i2 = blockposition.u(); i2 <= blockposition1.u(); ++i2) {
                for (int j2 = blockposition.v(); j2 <= blockposition1.v(); ++j2) {
                    for (int k2 = blockposition.w(); k2 <= blockposition1.w(); ++k2) {
                        if (!this.bE()) {
                            return;
                        }
                        blockposition_mutableblockposition.d(i2, j2, k2);
                        IBlockData iblockdata = this.dO().a_(blockposition_mutableblockposition);
                        try {
                            iblockdata.a(this.dO(), (BlockPosition)blockposition_mutableblockposition, this);
                            this.a(iblockdata);
                            continue;
                        }
                        catch (Throwable throwable) {
                            CrashReport crashreport = CrashReport.a(throwable, "Colliding entity with block");
                            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Block being collided with");
                            CrashReportSystemDetails.a(crashreportsystemdetails, this.dO(), blockposition_mutableblockposition, iblockdata);
                            throw new ReportedException(crashreport);
                        }
                    }
                }
            }
        }
    }

    protected void a(IBlockData iblockdata) {
    }

    public BlockPosition a(WorldServer worldserver, BlockPosition blockposition) {
        BlockPosition blockposition1 = worldserver.V();
        Vec3D vec3d = blockposition1.b();
        int i2 = worldserver.m(blockposition1).a(HeightMap.Type.f, blockposition1.u(), blockposition1.w()) + 1;
        return BlockPosition.a(vec3d.c, (double)i2, vec3d.e);
    }

    public void a(Holder<GameEvent> holder, @Nullable Entity entity) {
        this.dO().a(entity, holder, this.s);
    }

    public void a(Holder<GameEvent> holder) {
        this.a(holder, this);
    }

    private void c(BlockPosition blockposition, IBlockData iblockdata) {
        this.b(blockposition, iblockdata);
        if (this.d(iblockdata)) {
            this.v();
        }
    }

    protected void aU() {
        Entity entity = Objects.requireNonNullElse(this.cQ(), this);
        float f2 = entity == this ? 0.35f : 0.4f;
        Vec3D vec3d = entity.dr();
        float f1 = Math.min(1.0f, (float)Math.sqrt(vec3d.c * vec3d.c * (double)0.2f + vec3d.d * vec3d.d + vec3d.e * vec3d.e * (double)0.2f) * f2);
        this.f(f1);
    }

    protected BlockPosition e(BlockPosition blockposition) {
        BlockPosition blockposition1 = blockposition.d();
        IBlockData iblockdata = this.dO().a_(blockposition1);
        return !iblockdata.a(TagsBlock.bo) && !iblockdata.a(TagsBlock.bp) ? blockposition : blockposition1;
    }

    protected void a(IBlockData iblockdata, IBlockData iblockdata1) {
        SoundEffectType soundeffecttype = iblockdata.w();
        this.a(soundeffecttype.d(), soundeffecttype.a() * 0.15f, soundeffecttype.b());
        this.b(iblockdata1);
    }

    protected void b(IBlockData iblockdata) {
        SoundEffectType soundeffecttype = iblockdata.w();
        this.a(soundeffecttype.d(), soundeffecttype.a() * 0.05f, soundeffecttype.b() * 0.8f);
    }

    protected void b(BlockPosition blockposition, IBlockData iblockdata) {
        SoundEffectType soundeffecttype = iblockdata.w();
        this.a(soundeffecttype.d(), soundeffecttype.a() * 0.15f, soundeffecttype.b());
    }

    private boolean d(IBlockData iblockdata) {
        return iblockdata.a(TagsBlock.bn) && this.ai >= this.bh + 20;
    }

    private void v() {
        this.bg *= (float)Math.pow(0.997, this.ai - this.bh);
        this.bg = Math.min(1.0f, this.bg + 0.07f);
        float f2 = 0.5f + this.bg * this.ah.i() * 1.2f;
        float f1 = 0.1f + this.bg * 1.2f;
        this.a(SoundEffects.E, f1, f2);
        this.bh = this.ai;
    }

    protected void f(float f2) {
        this.a(this.aQ(), f2, 1.0f + (this.ah.i() - this.ah.i()) * 0.4f);
    }

    protected void aV() {
    }

    protected boolean aW() {
        return false;
    }

    public void a(SoundEffect soundeffect, float f2, float f1) {
        if (!this.aX()) {
            this.dO().a((EntityHuman)null, this.dt(), this.dv(), this.dz(), soundeffect, this.de(), f2, f1);
        }
    }

    public void a(SoundEffect soundeffect) {
        if (!this.aX()) {
            this.a(soundeffect, 1.0f, 1.0f);
        }
    }

    public boolean aX() {
        return this.ao.a(aS);
    }

    public void e(boolean flag) {
        this.ao.a(aS, flag);
    }

    public boolean aY() {
        return this.ao.a(aT);
    }

    public void f(boolean flag) {
        this.ao.a(aT, flag);
    }

    protected double aZ() {
        return 0.0;
    }

    public final double ba() {
        return this.aY() ? 0.0 : this.aZ();
    }

    protected void bb() {
        double d0 = this.ba();
        if (d0 != 0.0) {
            this.i(this.dr().b(0.0, -d0, 0.0));
        }
    }

    protected MovementEmission bc() {
        return MovementEmission.d;
    }

    public boolean bd() {
        return false;
    }

    protected void a(double d0, boolean flag, IBlockData iblockdata, BlockPosition blockposition) {
        if (flag) {
            if (this.ac > 0.0f) {
                iblockdata.b().a(this.dO(), iblockdata, blockposition, this, this.ac);
                this.dO().a(GameEvent.A, this.s, GameEvent.a.a(this, this.aC.map(blockposition1 -> this.dO().a_((BlockPosition)blockposition1)).orElse(iblockdata)));
            }
            this.n();
        } else if (d0 < 0.0) {
            this.ac -= (float)d0;
        }
    }

    public boolean be() {
        return this.am().d();
    }

    public boolean a(float f2, float f1, DamageSource damagesource) {
        if (this.n.a(TagsEntity.o)) {
            return false;
        }
        if (this.bT()) {
            for (Entity entity : this.cS()) {
                entity.a(f2, f1, damagesource);
            }
        }
        return false;
    }

    public boolean bf() {
        return this.aj;
    }

    private boolean w() {
        BlockPosition blockposition = this.do();
        return this.dO().r(blockposition) || this.dO().r(BlockPosition.a((double)blockposition.u(), this.cK().e, (double)blockposition.w()));
    }

    private boolean F() {
        return this.dp().a(Blocks.nd);
    }

    public boolean bg() {
        return this.bf() || this.w();
    }

    public boolean bh() {
        return this.bf() || this.w() || this.F();
    }

    public boolean bi() {
        return this.bf() || this.F();
    }

    public boolean bj() {
        return this.bi() || this.bt();
    }

    public boolean bk() {
        return this.al && this.bf();
    }

    public void bl() {
        if (this.cd()) {
            this.i(this.cc() && this.bf() && !this.bS());
        } else {
            this.i(this.cc() && this.bk() && !this.bS() && this.dO().b_(this.t).a(TagsFluid.a));
        }
    }

    protected boolean bm() {
        this.ak.clear();
        this.bn();
        double d0 = this.dO().D_().i() ? 0.007 : 0.0023333333333333335;
        boolean flag = this.a(TagsFluid.b, d0);
        return this.bf() || flag;
    }

    void bn() {
        EntityBoat entityboat;
        Entity entity = this.dc();
        if (entity instanceof EntityBoat && !(entityboat = (EntityBoat)entity).bk()) {
            this.aj = false;
            return;
        }
        if (this.a(TagsFluid.a, 0.014)) {
            if (!this.aj && !this.an) {
                this.bo();
            }
            this.n();
            this.aj = true;
            this.aD();
        } else {
            this.aj = false;
        }
    }

    private void H() {
        EntityBoat entityboat;
        this.al = this.a(TagsFluid.a);
        this.aK.clear();
        double d0 = this.dx();
        Entity entity = this.dc();
        if (entity instanceof EntityBoat && !(entityboat = (EntityBoat)entity).bk() && entityboat.cK().e >= d0 && entityboat.cK().b <= d0) {
            return;
        }
        BlockPosition blockposition = BlockPosition.a(this.dt(), d0, this.dz());
        Fluid fluid = this.dO().b_(blockposition);
        double d1 = (float)blockposition.v() + fluid.a((IBlockAccess)this.dO(), blockposition);
        if (d1 > d0) {
            Stream<TagKey<FluidType>> stream = fluid.k();
            Set<TagKey<FluidType>> set = this.aK;
            Objects.requireNonNull(this.aK);
            stream.forEach(set::add);
        }
    }

    protected void bo() {
        double d1;
        double d0;
        Entity entity = Objects.requireNonNullElse(this.cQ(), this);
        float f2 = entity == this ? 0.2f : 0.9f;
        Vec3D vec3d = entity.dr();
        float f1 = Math.min(1.0f, (float)Math.sqrt(vec3d.c * vec3d.c * (double)0.2f + vec3d.d * vec3d.d + vec3d.e * vec3d.e * (double)0.2f) * f2);
        if (f1 < 0.25f) {
            this.a(this.aR(), f1, 1.0f + (this.ah.i() - this.ah.i()) * 0.4f);
        } else {
            this.a(this.aS(), f1, 1.0f + (this.ah.i() - this.ah.i()) * 0.4f);
        }
        float f22 = MathHelper.a(this.dv());
        int i2 = 0;
        while ((float)i2 < 1.0f + this.bd.a() * 20.0f) {
            d0 = (this.ah.j() * 2.0 - 1.0) * (double)this.bd.a();
            d1 = (this.ah.j() * 2.0 - 1.0) * (double)this.bd.a();
            this.dO().a(Particles.d, this.dt() + d0, (double)(f22 + 1.0f), this.dz() + d1, vec3d.c, vec3d.d - this.ah.j() * (double)0.2f, vec3d.e);
            ++i2;
        }
        i2 = 0;
        while ((float)i2 < 1.0f + this.bd.a() * 20.0f) {
            d0 = (this.ah.j() * 2.0 - 1.0) * (double)this.bd.a();
            d1 = (this.ah.j() * 2.0 - 1.0) * (double)this.bd.a();
            this.dO().a(Particles.am, this.dt() + d0, (double)(f22 + 1.0f), this.dz() + d1, vec3d.c, vec3d.d, vec3d.e);
            ++i2;
        }
        this.a(GameEvent.O);
    }

    @Deprecated
    protected IBlockData bp() {
        return this.dO().a_(this.aK());
    }

    public IBlockData bq() {
        return this.dO().a_(this.aM());
    }

    public boolean br() {
        return this.cc() && !this.bf() && !this.R_() && !this.cb() && !this.bt() && this.bE();
    }

    protected void bs() {
        BlockPosition blockposition = this.aK();
        IBlockData iblockdata = this.dO().a_(blockposition);
        if (iblockdata.l() != EnumRenderType.a) {
            Vec3D vec3d = this.dr();
            BlockPosition blockposition1 = this.do();
            double d0 = this.dt() + (this.ah.j() - 0.5) * (double)this.bd.a();
            double d1 = this.dz() + (this.ah.j() - 0.5) * (double)this.bd.a();
            if (blockposition1.u() != blockposition.u()) {
                d0 = MathHelper.a(d0, (double)blockposition.u(), (double)blockposition.u() + 1.0);
            }
            if (blockposition1.w() != blockposition.w()) {
                d1 = MathHelper.a(d1, (double)blockposition.w(), (double)blockposition.w() + 1.0);
            }
            this.dO().a(new ParticleParamBlock(Particles.b, iblockdata), d0, this.dv() + 0.1, d1, vec3d.c * -4.0, 1.5, vec3d.e * -4.0);
        }
    }

    public boolean a(TagKey<FluidType> tagkey) {
        return this.aK.contains(tagkey);
    }

    public boolean bt() {
        return !this.an && this.ak.getDouble(TagsFluid.b) > 0.0;
    }

    public void a(float f2, Vec3D vec3d) {
        Vec3D vec3d1 = Entity.b(vec3d, f2, this.dE());
        this.i(this.dr().e(vec3d1));
    }

    private static Vec3D b(Vec3D vec3d, float f2, float f1) {
        double d0 = vec3d.g();
        if (d0 < 1.0E-7) {
            return Vec3D.b;
        }
        Vec3D vec3d1 = (d0 > 1.0 ? vec3d.d() : vec3d).a((double)f2);
        float f22 = MathHelper.a(f1 * ((float)Math.PI / 180));
        float f3 = MathHelper.b(f1 * ((float)Math.PI / 180));
        return new Vec3D(vec3d1.c * (double)f3 - vec3d1.e * (double)f22, vec3d1.d, vec3d1.e * (double)f3 + vec3d1.c * (double)f22);
    }

    @Deprecated
    public float bu() {
        return this.dO().f(this.ds(), this.dy()) ? this.dO().x(BlockPosition.a(this.dt(), this.dx(), this.dz())) : 0.0f;
    }

    public void a(double d0, double d1, double d2, float f2, float f1) {
        this.h(d0, d1, d2);
        this.b(f2, f1);
    }

    public void b(float f2, float f1) {
        this.t(f2 % 360.0f);
        this.u(MathHelper.a(f1, -90.0f, 90.0f) % 360.0f);
        this.O = this.dE();
        this.P = this.dG();
    }

    public void h(double d0, double d1, double d2) {
        double d3 = MathHelper.a(d0, -3.0E7, 3.0E7);
        double d4 = MathHelper.a(d2, -3.0E7, 3.0E7);
        this.L = d3;
        this.M = d1;
        this.N = d4;
        this.a_(d3, d1, d4);
        if (this.valid) {
            this.r.d((int)Math.floor(this.dt()) >> 4, (int)Math.floor(this.dz()) >> 4);
        }
    }

    public void f(Vec3D vec3d) {
        this.e(vec3d.c, vec3d.d, vec3d.e);
    }

    public void e(double d0, double d1, double d2) {
        this.b(d0, d1, d2, this.dE(), this.dG());
    }

    public void a(BlockPosition blockposition, float f2, float f1) {
        this.a(blockposition.c(), f2, f1);
    }

    public void a(Vec3D vec3d, float f2, float f1) {
        this.b(vec3d.c, vec3d.d, vec3d.e, f2, f1);
    }

    public void b(double d0, double d1, double d2, float f2, float f1) {
        this.o(d0, d1, d2);
        this.t(f2);
        this.u(f1);
        this.bv();
        this.av();
    }

    public final void bv() {
        double d0 = this.dt();
        double d1 = this.dv();
        double d2 = this.dz();
        this.L = d0;
        this.M = d1;
        this.N = d2;
        this.ad = d0;
        this.ae = d1;
        this.af = d2;
        this.O = this.dE();
        this.P = this.dG();
    }

    public float f(Entity entity) {
        float f2 = (float)(this.dt() - entity.dt());
        float f1 = (float)(this.dv() - entity.dv());
        float f22 = (float)(this.dz() - entity.dz());
        return MathHelper.c(f2 * f2 + f1 * f1 + f22 * f22);
    }

    public double i(double d0, double d1, double d2) {
        double d3 = this.dt() - d0;
        double d4 = this.dv() - d1;
        double d5 = this.dz() - d2;
        return d3 * d3 + d4 * d4 + d5 * d5;
    }

    public double g(Entity entity) {
        return this.g(entity.dm());
    }

    public double g(Vec3D vec3d) {
        double d0 = this.dt() - vec3d.c;
        double d1 = this.dv() - vec3d.d;
        double d2 = this.dz() - vec3d.e;
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    public void b_(EntityHuman entityhuman) {
    }

    public void h(Entity entity) {
        double d1;
        double d0;
        double d2;
        if (!this.y(entity) && !entity.ag && !this.ag && (d2 = MathHelper.a(d0 = entity.dt() - this.dt(), d1 = entity.dz() - this.dz())) >= (double)0.01f) {
            d2 = Math.sqrt(d2);
            d0 /= d2;
            d1 /= d2;
            double d3 = 1.0 / d2;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d0 *= d3;
            d1 *= d3;
            d0 *= (double)0.05f;
            d1 *= (double)0.05f;
            if (!this.bT() && this.bB()) {
                this.j(-d0, 0.0, -d1);
            }
            if (!entity.bT() && entity.bB()) {
                entity.j(d0, 0.0, d1);
            }
        }
    }

    public void h(Vec3D vec3d) {
        this.j(vec3d.c, vec3d.d, vec3d.e);
    }

    public void j(double d0, double d1, double d2) {
        this.i(this.dr().b(d0, d1, d2));
        this.av = true;
    }

    protected void bw() {
        this.U = true;
    }

    public boolean a(DamageSource damagesource, float f2) {
        if (this.b(damagesource)) {
            return false;
        }
        this.bw();
        return false;
    }

    public final Vec3D g(float f2) {
        return this.c(this.h(f2), this.i(f2));
    }

    public EnumDirection bx() {
        return EnumDirection.a(this.g(1.0f));
    }

    public float h(float f2) {
        return f2 == 1.0f ? this.dG() : MathHelper.i(f2, this.P, this.dG());
    }

    public float i(float f2) {
        return f2 == 1.0f ? this.dE() : MathHelper.i(f2, this.O, this.dE());
    }

    public final Vec3D c(float f2, float f1) {
        float f22 = f2 * ((float)Math.PI / 180);
        float f3 = -f1 * ((float)Math.PI / 180);
        float f4 = MathHelper.b(f3);
        float f5 = MathHelper.a(f3);
        float f6 = MathHelper.b(f22);
        float f7 = MathHelper.a(f22);
        return new Vec3D(f5 * f6, -f7, f4 * f6);
    }

    public final Vec3D j(float f2) {
        return this.d(this.h(f2), this.i(f2));
    }

    protected final Vec3D d(float f2, float f1) {
        return this.c(f2 - 90.0f, f1);
    }

    public final Vec3D by() {
        return new Vec3D(this.dt(), this.dx(), this.dz());
    }

    public final Vec3D k(float f2) {
        double d0 = MathHelper.d((double)f2, this.L, this.dt());
        double d1 = MathHelper.d((double)f2, this.M, this.dv()) + (double)this.cL();
        double d2 = MathHelper.d((double)f2, this.N, this.dz());
        return new Vec3D(d0, d1, d2);
    }

    public Vec3D l(float f2) {
        return this.k(f2);
    }

    public final Vec3D m(float f2) {
        double d0 = MathHelper.d((double)f2, this.L, this.dt());
        double d1 = MathHelper.d((double)f2, this.M, this.dv());
        double d2 = MathHelper.d((double)f2, this.N, this.dz());
        return new Vec3D(d0, d1, d2);
    }

    public MovingObjectPosition a(double d0, float f2, boolean flag) {
        Vec3D vec3d = this.k(f2);
        Vec3D vec3d1 = this.g(f2);
        Vec3D vec3d2 = vec3d.b(vec3d1.c * d0, vec3d1.d * d0, vec3d1.e * d0);
        return this.dO().a(new RayTrace(vec3d, vec3d2, RayTrace.BlockCollisionOption.b, flag ? RayTrace.FluidCollisionOption.c : RayTrace.FluidCollisionOption.a, this));
    }

    public boolean bz() {
        return this.bE() && this.bA();
    }

    public boolean bA() {
        return false;
    }

    public boolean bB() {
        return false;
    }

    public boolean canCollideWithBukkit(Entity entity) {
        return this.bB();
    }

    public void a(Entity entity, int i2, DamageSource damagesource) {
        if (entity instanceof EntityPlayer) {
            CriterionTriggers.d.a((EntityPlayer)entity, this, damagesource);
        }
    }

    public boolean k(double d0, double d1, double d2) {
        double d3 = this.dt() - d0;
        double d4 = this.dv() - d1;
        double d5 = this.dz() - d2;
        double d6 = d3 * d3 + d4 * d4 + d5 * d5;
        return this.a(d6);
    }

    public boolean a(double d0) {
        double d1 = this.cK().a();
        if (Double.isNaN(d1)) {
            d1 = 1.0;
        }
        return d0 < (d1 *= 64.0 * m) * d1;
    }

    public boolean d(NBTTagCompound nbttagcompound) {
        return this.saveAsPassenger(nbttagcompound, true);
    }

    public boolean saveAsPassenger(NBTTagCompound nbttagcompound, boolean includeAll) {
        if (this.aH != null && !this.aH.b()) {
            return false;
        }
        String s2 = this.bD();
        if (!this.persist || s2 == null) {
            return false;
        }
        nbttagcompound.a(w, s2);
        this.saveWithoutId(nbttagcompound, includeAll);
        return true;
    }

    public boolean e(NBTTagCompound nbttagcompound) {
        return this.bS() ? false : this.d(nbttagcompound);
    }

    public NBTTagCompound f(NBTTagCompound nbttagcompound) {
        return this.saveWithoutId(nbttagcompound, true);
    }

    public NBTTagCompound saveWithoutId(NBTTagCompound nbttagcompound, boolean includeAll) {
        try {
            NBTTagList nbttaglist;
            int i2;
            if (includeAll) {
                if (this.q != null) {
                    nbttagcompound.a("Pos", this.a(new double[]{this.q.dt(), this.dv(), this.q.dz()}));
                } else {
                    nbttagcompound.a("Pos", this.a(new double[]{this.dt(), this.dv(), this.dz()}));
                }
            }
            Vec3D vec3d = this.dr();
            nbttagcompound.a("Motion", this.a(new double[]{vec3d.c, vec3d.d, vec3d.e}));
            if (Float.isNaN(this.aD)) {
                this.aD = 0.0f;
            }
            if (Float.isNaN(this.aE)) {
                this.aE = 0.0f;
            }
            nbttagcompound.a("Rotation", this.a(new float[]{this.dE(), this.dG()}));
            nbttagcompound.a("FallDistance", this.ac);
            nbttagcompound.a("Fire", (short)this.aJ);
            nbttagcompound.a("Air", (short)this.cm());
            nbttagcompound.a("OnGround", this.aF());
            nbttagcompound.a("Invulnerable", this.aY);
            nbttagcompound.a("PortalCooldown", this.aX);
            if (includeAll) {
                nbttagcompound.a(I, this.cz());
                nbttagcompound.a("WorldUUIDLeast", ((WorldServer)this.r).getWorld().getUID().getLeastSignificantBits());
                nbttagcompound.a("WorldUUIDMost", ((WorldServer)this.r).getWorld().getUID().getMostSignificantBits());
            }
            nbttagcompound.a("Bukkit.updateLevel", 2);
            if (!this.persist) {
                nbttagcompound.a("Bukkit.persist", this.persist);
            }
            if (!this.visibleByDefault) {
                nbttagcompound.a("Bukkit.visibleByDefault", this.visibleByDefault);
            }
            if (this.persistentInvisibility) {
                nbttagcompound.a("Bukkit.invisible", this.persistentInvisibility);
            }
            if (this.maxAirTicks != this.getDefaultMaxAirSupply()) {
                nbttagcompound.a("Bukkit.MaxAirSupply", this.cl());
            }
            nbttagcompound.a("Spigot.ticksLived", this.ai);
            IChatBaseComponent ichatbasecomponent = this.aj();
            if (ichatbasecomponent != null) {
                nbttagcompound.a("CustomName", IChatBaseComponent.ChatSerializer.a(ichatbasecomponent, (HolderLookup.a)this.dQ()));
            }
            if (this.cE()) {
                nbttagcompound.a("CustomNameVisible", this.cE());
            }
            if (this.aX()) {
                nbttagcompound.a("Silent", this.aX());
            }
            if (this.aY()) {
                nbttagcompound.a("NoGravity", this.aY());
            }
            if (this.aZ) {
                nbttagcompound.a("Glowing", true);
            }
            if ((i2 = this.cn()) > 0) {
                nbttagcompound.a("TicksFrozen", this.cn());
            }
            if (this.bi) {
                nbttagcompound.a("HasVisualFire", this.bi);
            }
            if (!this.ba.isEmpty()) {
                nbttaglist = new NBTTagList();
                for (String s2 : this.ba) {
                    nbttaglist.add(NBTTagString.a(s2));
                }
                nbttagcompound.a("Tags", nbttaglist);
            }
            this.addAdditionalSaveData(nbttagcompound, includeAll);
            if (this.bT()) {
                nbttaglist = new NBTTagList();
                for (Entity entity : this.cS()) {
                    NBTTagCompound nbttagcompound1;
                    if (!entity.saveAsPassenger(nbttagcompound1 = new NBTTagCompound(), includeAll)) continue;
                    nbttaglist.add(nbttagcompound1);
                }
                if (!nbttaglist.isEmpty()) {
                    nbttagcompound.a(x, nbttaglist);
                }
            }
            if (this.bukkitEntity != null) {
                this.bukkitEntity.storeBukkitValues(nbttagcompound);
            }
            return nbttagcompound;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.a(throwable, "Saving entity NBT");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Entity being saved");
            this.a(crashreportsystemdetails);
            throw new ReportedException(crashreport);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void g(NBTTagCompound nbttagcompound) {
        try {
            NBTTagList nbttaglist = nbttagcompound.c("Pos", 6);
            NBTTagList nbttaglist1 = nbttagcompound.c("Motion", 6);
            NBTTagList nbttaglist2 = nbttagcompound.c("Rotation", 5);
            double d0 = nbttaglist1.h(0);
            double d1 = nbttaglist1.h(1);
            double d2 = nbttaglist1.h(2);
            this.n(Math.abs(d0) > 10.0 ? 0.0 : d0, Math.abs(d1) > 10.0 ? 0.0 : d1, Math.abs(d2) > 10.0 ? 0.0 : d2);
            double d3 = 3.0000512E7;
            this.o(MathHelper.a(nbttaglist.h(0), -3.0000512E7, 3.0000512E7), MathHelper.a(nbttaglist.h(1), -2.0E7, 2.0E7), MathHelper.a(nbttaglist.h(2), -3.0000512E7, 3.0000512E7));
            this.t(nbttaglist2.i(0));
            this.u(nbttaglist2.i(1));
            this.bv();
            this.o(this.dE());
            this.p(this.dE());
            this.ac = nbttagcompound.j("FallDistance");
            this.aJ = nbttagcompound.g("Fire");
            if (nbttagcompound.e("Air")) {
                this.j(nbttagcompound.g("Air"));
            }
            this.aG = nbttagcompound.q("OnGround");
            this.aY = nbttagcompound.q("Invulnerable");
            this.aX = nbttagcompound.h("PortalCooldown");
            if (nbttagcompound.b(I)) {
                this.ax = nbttagcompound.a(I);
                this.ay = this.ax.toString();
            }
            if (!Double.isFinite(this.dt()) || !Double.isFinite(this.dv()) || !Double.isFinite(this.dz())) throw new IllegalStateException("Entity has invalid position");
            if (!Double.isFinite(this.dE()) || !Double.isFinite(this.dG())) throw new IllegalStateException("Entity has invalid rotation");
            this.av();
            this.a(this.dE(), this.dG());
            if (nbttagcompound.b("CustomName", 8)) {
                String s2 = nbttagcompound.l("CustomName");
                try {
                    this.b(IChatBaseComponent.ChatSerializer.a(s2, (HolderLookup.a)this.dQ()));
                }
                catch (Exception exception) {
                    b.warn("Failed to parse entity custom name {}", (Object)s2, (Object)exception);
                }
            }
            this.p(nbttagcompound.q("CustomNameVisible"));
            this.e(nbttagcompound.q("Silent"));
            this.f(nbttagcompound.q("NoGravity"));
            this.j(nbttagcompound.q("Glowing"));
            this.k(nbttagcompound.h("TicksFrozen"));
            this.bi = nbttagcompound.q("HasVisualFire");
            if (nbttagcompound.b("Tags", 9)) {
                this.ba.clear();
                NBTTagList nbttaglist3 = nbttagcompound.c("Tags", 8);
                int i2 = Math.min(nbttaglist3.size(), 1024);
                for (int j2 = 0; j2 < i2; ++j2) {
                    this.ba.add(nbttaglist3.j(j2));
                }
            }
            this.a(nbttagcompound);
            if (this.bC()) {
                this.av();
            }
            if (this instanceof EntityLiving) {
                this.ai = nbttagcompound.h("Spigot.ticksLived");
            }
            this.persist = !nbttagcompound.e("Bukkit.persist") || nbttagcompound.q("Bukkit.persist");
            boolean bl = this.visibleByDefault = !nbttagcompound.e("Bukkit.visibleByDefault") || nbttagcompound.q("Bukkit.visibleByDefault");
            if (nbttagcompound.e("Bukkit.MaxAirSupply")) {
                this.maxAirTicks = nbttagcompound.h("Bukkit.MaxAirSupply");
            }
            if (this instanceof EntityPlayer) {
                Server server = Bukkit.getServer();
                World bworld = null;
                String worldName = nbttagcompound.l("world");
                if (nbttagcompound.e("WorldUUIDMost") && nbttagcompound.e("WorldUUIDLeast")) {
                    UUID uid = new UUID(nbttagcompound.i("WorldUUIDMost"), nbttagcompound.i("WorldUUIDLeast"));
                    bworld = server.getWorld(uid);
                } else {
                    bworld = server.getWorld(worldName);
                }
                if (bworld == null) {
                    bworld = ((CraftServer)server).getServer().a(net.minecraft.world.level.World.h).getWorld();
                }
                ((EntityPlayer)this).a((net.minecraft.world.level.World)(bworld == null ? null : ((CraftWorld)bworld).getHandle()));
            }
            this.getBukkitEntity().readBukkitValues(nbttagcompound);
            if (!nbttagcompound.e("Bukkit.invisible")) return;
            boolean bukkitInvisible = nbttagcompound.q("Bukkit.invisible");
            this.k(bukkitInvisible);
            this.persistentInvisibility = bukkitInvisible;
            return;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.a(throwable, "Loading entity NBT");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Entity being loaded");
            this.a(crashreportsystemdetails);
            throw new ReportedException(crashreport);
        }
    }

    protected boolean bC() {
        return true;
    }

    @Nullable
    public final String bD() {
        EntityTypes<?> entitytypes = this.am();
        MinecraftKey minecraftkey = EntityTypes.a(entitytypes);
        return entitytypes.b() && minecraftkey != null ? minecraftkey.toString() : null;
    }

    protected void addAdditionalSaveData(NBTTagCompound nbttagcompound, boolean includeAll) {
        this.b(nbttagcompound);
    }

    protected abstract void a(NBTTagCompound var1);

    protected abstract void b(NBTTagCompound var1);

    protected NBTTagList a(double ... adouble) {
        NBTTagList nbttaglist = new NBTTagList();
        double[] adouble1 = adouble;
        int i2 = adouble.length;
        for (int j2 = 0; j2 < i2; ++j2) {
            double d0 = adouble1[j2];
            nbttaglist.add(NBTTagDouble.a(d0));
        }
        return nbttaglist;
    }

    protected NBTTagList a(float ... afloat) {
        NBTTagList nbttaglist = new NBTTagList();
        float[] afloat1 = afloat;
        int i2 = afloat.length;
        for (int j2 = 0; j2 < i2; ++j2) {
            float f2 = afloat1[j2];
            nbttaglist.add(NBTTagFloat.a(f2));
        }
        return nbttaglist;
    }

    @Nullable
    public EntityItem a(IMaterial imaterial) {
        return this.a(imaterial, 0);
    }

    @Nullable
    public EntityItem a(IMaterial imaterial, int i2) {
        return this.a(new ItemStack(imaterial), (float)i2);
    }

    @Nullable
    public EntityItem b(ItemStack itemstack) {
        return this.a(itemstack, 0.0f);
    }

    @Nullable
    public EntityItem a(ItemStack itemstack, float f2) {
        if (itemstack.e()) {
            return null;
        }
        if (this.dO().B) {
            return null;
        }
        if (this instanceof EntityLiving && !((EntityLiving)this).forceDrops) {
            ((EntityLiving)this).drops.add(CraftItemStack.asBukkitCopy(itemstack));
            return null;
        }
        EntityItem entityitem = new EntityItem(this.dO(), this.dt(), this.dv() + (double)f2, this.dz(), itemstack);
        entityitem.v();
        EntityDropItemEvent event = new EntityDropItemEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (Item)entityitem.getBukkitEntity());
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return null;
        }
        this.dO().b(entityitem);
        return entityitem;
    }

    public boolean bE() {
        return !this.dJ();
    }

    public boolean bF() {
        if (this.ag) {
            return false;
        }
        float f2 = this.bd.a() * 0.8f;
        AxisAlignedBB axisalignedbb = AxisAlignedBB.a(this.by(), f2, 1.0E-6, f2);
        return BlockPosition.a(axisalignedbb).anyMatch(blockposition -> {
            IBlockData iblockdata = this.dO().a_((BlockPosition)blockposition);
            return !iblockdata.i() && iblockdata.o(this.dO(), (BlockPosition)blockposition) && VoxelShapes.c(iblockdata.k(this.dO(), (BlockPosition)blockposition).a((double)blockposition.u(), (double)blockposition.v(), (double)blockposition.w()), VoxelShapes.a(axisalignedbb), OperatorBoolean.i);
        });
    }

    public EnumInteractionResult a(EntityHuman entityhuman, EnumHand enumhand) {
        Entity entity;
        if (this.bE() && (entity = this) instanceof Leashable) {
            Leashable leashable = (Leashable)((Object)entity);
            if (leashable.A() == entityhuman) {
                if (!this.dO().x_()) {
                    if (CraftEventFactory.callPlayerUnleashEntityEvent(this, entityhuman, enumhand).isCancelled()) {
                        ((EntityPlayer)entityhuman).c.b(new PacketPlayOutAttachEntity(this, leashable.A()));
                        return EnumInteractionResult.e;
                    }
                    leashable.a(true, !entityhuman.fL());
                    this.a(GameEvent.r, (Entity)entityhuman);
                }
                return EnumInteractionResult.a(this.dO().B);
            }
            ItemStack itemstack = entityhuman.b(enumhand);
            if (itemstack.a(Items.uK) && leashable.q()) {
                if (!this.dO().x_()) {
                    if (CraftEventFactory.callPlayerLeashEntityEvent(this, entityhuman, entityhuman, enumhand).isCancelled()) {
                        ((EntityPlayer)entityhuman).resendItemInHands();
                        ((EntityPlayer)entityhuman).c.b(new PacketPlayOutAttachEntity(this, leashable.A()));
                        return EnumInteractionResult.e;
                    }
                    leashable.b((Entity)entityhuman, true);
                }
                itemstack.h(1);
                return EnumInteractionResult.a(this.dO().B);
            }
        }
        return EnumInteractionResult.e;
    }

    public boolean i(Entity entity) {
        return entity.bG() && !this.y(entity);
    }

    public boolean bG() {
        return false;
    }

    public void u() {
        this.i(Vec3D.b);
        this.l();
        if (this.bS()) {
            this.dc().j(this);
        }
    }

    public final void j(Entity entity) {
        if (this.x(entity)) {
            this.a(entity, Entity::a_);
        }
    }

    protected void a(Entity entity, MoveFunction entity_movefunction) {
        Vec3D vec3d = this.m(entity);
        Vec3D vec3d1 = entity.l(this);
        entity_movefunction.accept(entity, vec3d.c - vec3d1.c, vec3d.d - vec3d1.d, vec3d.e - vec3d1.e);
    }

    public void k(Entity entity) {
    }

    public Vec3D l(Entity entity) {
        return this.dl().b(EntityAttachment.b, 0, this.aD);
    }

    public Vec3D m(Entity entity) {
        return this.dm().e(this.a(entity, this.bd, 1.0f));
    }

    protected Vec3D a(Entity entity, EntitySize entitysize, float f2) {
        return Entity.a(this, entity, entitysize.d());
    }

    protected static Vec3D a(Entity entity, Entity entity1, EntityAttachments entityattachments) {
        int i2 = entity.cS().indexOf(entity1);
        return entityattachments.c(EntityAttachment.a, i2, entity.aD);
    }

    public boolean n(Entity entity) {
        return this.a(entity, false);
    }

    public boolean bH() {
        return this instanceof EntityLiving;
    }

    public boolean a(Entity entity, boolean flag) {
        EntityMountEvent event;
        if (entity == this.q) {
            return false;
        }
        if (!entity.bK()) {
            return false;
        }
        Entity entity1 = entity;
        while (entity1.q != null) {
            if (entity1.q == this) {
                return false;
            }
            entity1 = entity1.q;
        }
        if (!(flag || this.o(entity) && entity.r(this))) {
            return false;
        }
        if (entity.getBukkitEntity() instanceof Vehicle && this.getBukkitEntity() instanceof LivingEntity) {
            event = new VehicleEnterEvent((Vehicle)entity.getBukkitEntity(), (org.bukkit.entity.Entity)this.getBukkitEntity());
            if (this.valid) {
                Bukkit.getPluginManager().callEvent((Event)event);
            }
            if (event.isCancelled()) {
                return false;
            }
        }
        event = new EntityMountEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity());
        if (this.valid) {
            Bukkit.getPluginManager().callEvent((Event)event);
        }
        if (event.isCancelled()) {
            return false;
        }
        if (this.bS()) {
            this.ad();
        }
        this.b(EntityPose.a);
        this.q = entity;
        this.q.p(this);
        entity.J().filter(entity2 -> entity2 instanceof EntityPlayer).forEach(entity2 -> CriterionTriggers.U.a((EntityPlayer)entity2));
        return true;
    }

    protected boolean o(Entity entity) {
        return !this.bW() && this.K <= 0;
    }

    public void bI() {
        for (int i2 = this.p.size() - 1; i2 >= 0; --i2) {
            ((Entity)this.p.get(i2)).ad();
        }
    }

    public void bJ() {
        if (this.q != null) {
            Entity entity = this.q;
            this.q = null;
            if (!entity.removePassenger(this)) {
                this.q = entity;
            }
        }
    }

    public void ad() {
        this.bJ();
    }

    protected void p(Entity entity) {
        if (entity.dc() != this) {
            throw new IllegalStateException("Use x.startRiding(y), not y.addPassenger(x)");
        }
        if (this.p.isEmpty()) {
            this.p = ImmutableList.of((Object)entity);
        } else {
            ArrayList list = Lists.newArrayList(this.p);
            if (!this.dO().B && entity instanceof EntityHuman && !(this.cT() instanceof EntityHuman)) {
                list.add(0, entity);
            } else {
                list.add(entity);
            }
            this.p = ImmutableList.copyOf((Collection)list);
        }
        this.a(GameEvent.s, entity);
    }

    protected boolean removePassenger(Entity entity) {
        EntityDismountEvent event;
        Entity orig;
        if (entity.dc() == this) {
            throw new IllegalStateException("Use x.stopRiding(y), not y.removePassenger(x)");
        }
        CraftEntity craft = (CraftEntity)entity.getBukkitEntity().getVehicle();
        Entity entity2 = orig = craft == null ? null : craft.getHandle();
        if (this.getBukkitEntity() instanceof Vehicle && entity.getBukkitEntity() instanceof LivingEntity) {
            CraftEntity craftn;
            Entity n2;
            event = new VehicleExitEvent((Vehicle)this.getBukkitEntity(), (LivingEntity)entity.getBukkitEntity());
            if (this.valid) {
                Bukkit.getPluginManager().callEvent((Event)event);
            }
            Entity entity3 = n2 = (craftn = (CraftEntity)entity.getBukkitEntity().getVehicle()) == null ? null : craftn.getHandle();
            if (event.isCancelled() || n2 != orig) {
                return false;
            }
        }
        event = new EntityDismountEvent((org.bukkit.entity.Entity)entity.getBukkitEntity(), (org.bukkit.entity.Entity)this.getBukkitEntity());
        if (this.valid) {
            Bukkit.getPluginManager().callEvent((Event)event);
        }
        if (event.isCancelled()) {
            return false;
        }
        this.p = this.p.size() == 1 && this.p.get(0) == entity ? ImmutableList.of() : (ImmutableList)this.p.stream().filter(entity1 -> entity1 != entity).collect(ImmutableList.toImmutableList());
        entity.K = 60;
        this.a(GameEvent.q, entity);
        return true;
    }

    protected boolean r(Entity entity) {
        return this.p.isEmpty();
    }

    protected boolean bK() {
        return true;
    }

    public void a(double d0, double d1, double d2, float f2, float f1, int i2) {
        this.a_(d0, d1, d2);
        this.a(f2, f1);
    }

    public double c_() {
        return this.dt();
    }

    public double d_() {
        return this.dv();
    }

    public double P_() {
        return this.dz();
    }

    public float Q_() {
        return this.dG();
    }

    public float e_() {
        return this.dE();
    }

    public void a(float f2, int i2) {
        this.o(f2);
    }

    public float bL() {
        return 0.0f;
    }

    public Vec3D bM() {
        return this.c(this.dG(), this.dE());
    }

    public Vec3D a(net.minecraft.world.item.Item item) {
        Entity entity = this;
        if (!(entity instanceof EntityHuman)) {
            return Vec3D.b;
        }
        EntityHuman entityhuman = (EntityHuman)entity;
        boolean flag = entityhuman.eU().a(item) && !entityhuman.eT().a(item);
        EnumMainHand enummainhand = flag ? entityhuman.fq().e() : entityhuman.fq();
        return this.c(0.0f, this.dE() + (float)(enummainhand == EnumMainHand.b ? 80 : -80)).a(0.5);
    }

    public Vec2F bN() {
        return new Vec2F(this.dG(), this.dE());
    }

    public Vec3D bO() {
        return Vec3D.a(this.bN());
    }

    public void a(Portal portal, BlockPosition blockposition) {
        if (this.aA()) {
            this.ay();
        } else if (this.aw != null && this.aw.a(portal)) {
            this.aw.a(blockposition.j());
            this.aw.a(true);
        } else {
            this.aw = new PortalProcessor(portal, blockposition.j());
        }
    }

    protected void bP() {
        net.minecraft.world.level.World world = this.dO();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            this.M();
            if (this.aw != null) {
                if (this.aw.a(worldserver, this, this.o(false))) {
                    worldserver.ag().a("portal");
                    this.ay();
                    DimensionTransition dimensiontransition = this.aw.a(worldserver, this);
                    if (dimensiontransition != null) {
                        WorldServer worldserver1 = dimensiontransition.a();
                        if (this instanceof EntityPlayer || worldserver1 != null && (worldserver1.af() == worldserver.af() || this.a((net.minecraft.world.level.World)worldserver, worldserver1))) {
                            this.a(dimensiontransition);
                        }
                    }
                    worldserver.ag().c();
                } else if (this.aw.b()) {
                    this.aw = null;
                }
            }
        }
    }

    public int bQ() {
        Entity entity = this.cT();
        return entity instanceof EntityPlayer ? entity.bQ() : 300;
    }

    public void l(double d0, double d1, double d2) {
        this.n(d0, d1, d2);
    }

    public void c(DamageSource damagesource) {
    }

    public void b(byte b0) {
        switch (b0) {
            case 53: {
                BlockHoney.a(this);
            }
        }
    }

    public void n(float f2) {
    }

    public boolean bR() {
        boolean flag = this.dO() != null && this.dO().B;
        return !this.be() && (this.aJ > 0 || flag && this.i(0));
    }

    public boolean bS() {
        return this.dc() != null;
    }

    public boolean bT() {
        return !this.p.isEmpty();
    }

    public boolean bU() {
        return this.am().a(TagsEntity.p);
    }

    public boolean bV() {
        return !this.am().a(TagsEntity.q);
    }

    public void g(boolean flag) {
        this.b(1, flag);
    }

    public boolean bW() {
        return this.i(1);
    }

    public boolean bX() {
        return this.bW();
    }

    public boolean bY() {
        return this.bW();
    }

    public boolean bZ() {
        return this.bW();
    }

    public boolean ca() {
        return this.bW();
    }

    public boolean cb() {
        return this.c(EntityPose.f);
    }

    public boolean cc() {
        return this.i(3);
    }

    public void h(boolean flag) {
        this.b(3, flag);
    }

    public boolean cd() {
        return this.i(4);
    }

    public boolean ce() {
        return this.c(EntityPose.d);
    }

    public boolean cf() {
        return this.ce() && !this.bf();
    }

    public void i(boolean flag) {
        if (this.valid && this.cd() != flag && this instanceof EntityLiving && CraftEventFactory.callToggleSwimEvent((EntityLiving)this, flag).isCancelled()) {
            return;
        }
        this.b(4, flag);
    }

    public final boolean cg() {
        return this.aZ;
    }

    public final void j(boolean flag) {
        this.aZ = flag;
        this.b(6, this.ch());
    }

    public boolean ch() {
        return this.dO().x_() ? this.i(6) : this.aZ;
    }

    public boolean ci() {
        return this.i(5);
    }

    public boolean d(EntityHuman entityhuman) {
        if (entityhuman.R_()) {
            return false;
        }
        ScoreboardTeam scoreboardteam = this.ck();
        return scoreboardteam != null && entityhuman != null && entityhuman.ck() == scoreboardteam && scoreboardteam.i() ? false : this.ci();
    }

    public boolean cj() {
        return false;
    }

    public void a(BiConsumer<DynamicGameEventListener<?>, WorldServer> biconsumer) {
    }

    @Nullable
    public ScoreboardTeam ck() {
        return this.dO().M().e(this.cB());
    }

    public boolean s(Entity entity) {
        return this.a(entity.ck());
    }

    public boolean a(ScoreboardTeamBase scoreboardteambase) {
        return this.ck() != null ? this.ck().a(scoreboardteambase) : false;
    }

    public void k(boolean flag) {
        if (!this.persistentInvisibility) {
            this.b(5, flag);
        }
    }

    public boolean i(int i2) {
        return (this.ao.a(ap) & 1 << i2) != 0;
    }

    public void b(int i2, boolean flag) {
        byte b0 = this.ao.a(ap);
        if (flag) {
            this.ao.a(ap, (byte)(b0 | 1 << i2));
        } else {
            this.ao.a(ap, (byte)(b0 & ~(1 << i2)));
        }
    }

    public int cl() {
        return this.maxAirTicks;
    }

    public int cm() {
        return this.ao.a(aP);
    }

    public void j(int i2) {
        EntityAirChangeEvent event = new EntityAirChangeEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), i2);
        if (this.valid) {
            event.getEntity().getServer().getPluginManager().callEvent((Event)event);
        }
        if (event.isCancelled() && this.cm() != i2) {
            this.ao.markDirty(aP);
            return;
        }
        this.ao.a(aP, event.getAmount());
    }

    public int cn() {
        return this.ao.a(aU);
    }

    public void k(int i2) {
        this.ao.a(aU, i2);
    }

    public float co() {
        int i2 = this.cq();
        return (float)Math.min(this.cn(), i2) / (float)i2;
    }

    public boolean cp() {
        return this.cn() >= this.cq();
    }

    public int cq() {
        return 140;
    }

    public void a(WorldServer worldserver, EntityLightning entitylightning) {
        this.h(this.aJ + 1);
        CraftEntity thisBukkitEntity = this.getBukkitEntity();
        CraftEntity stormBukkitEntity = entitylightning.getBukkitEntity();
        PluginManager pluginManager = Bukkit.getPluginManager();
        if (this.aJ == 0) {
            EntityCombustByEntityEvent entityCombustEvent = new EntityCombustByEntityEvent((org.bukkit.entity.Entity)stormBukkitEntity, (org.bukkit.entity.Entity)thisBukkitEntity, 8.0f);
            pluginManager.callEvent((Event)entityCombustEvent);
            if (!entityCombustEvent.isCancelled()) {
                this.igniteForSeconds(entityCombustEvent.getDuration(), false);
            }
        }
        if (thisBukkitEntity instanceof Hanging) {
            HangingBreakByEntityEvent hangingEvent = new HangingBreakByEntityEvent((Hanging)thisBukkitEntity, (org.bukkit.entity.Entity)stormBukkitEntity);
            pluginManager.callEvent((Event)hangingEvent);
            if (hangingEvent.isCancelled()) {
                return;
            }
        }
        if (this.be()) {
            return;
        }
        if (!this.a(this.dP().c().customEntityDamager(entitylightning), 5.0f)) {
            return;
        }
    }

    public void l(boolean flag) {
        Vec3D vec3d = this.dr();
        double d0 = flag ? Math.max(-0.9, vec3d.d - 0.03) : Math.min(1.8, vec3d.d + 0.1);
        this.n(vec3d.c, d0, vec3d.e);
    }

    public void m(boolean flag) {
        Vec3D vec3d = this.dr();
        double d0 = flag ? Math.max(-0.3, vec3d.d - 0.03) : Math.min(0.7, vec3d.d + 0.06);
        this.n(vec3d.c, d0, vec3d.e);
        this.n();
    }

    public boolean a(WorldServer worldserver, EntityLiving entityliving) {
        return true;
    }

    public void cr() {
        if (this.dr().b() > -0.5 && this.ac > 1.0f) {
            this.ac = 1.0f;
        }
    }

    public void n() {
        this.ac = 0.0f;
    }

    protected void m(double d0, double d1, double d2) {
        BlockPosition blockposition = BlockPosition.a(d0, d1, d2);
        Vec3D vec3d = new Vec3D(d0 - (double)blockposition.u(), d1 - (double)blockposition.v(), d2 - (double)blockposition.w());
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        EnumDirection enumdirection = EnumDirection.b;
        double d3 = Double.MAX_VALUE;
        for (EnumDirection enumdirection1 : new EnumDirection[]{EnumDirection.c, EnumDirection.d, EnumDirection.e, EnumDirection.f, EnumDirection.b}) {
            double d5;
            blockposition_mutableblockposition.a((BaseBlockPosition)blockposition, enumdirection1);
            if (this.dO().a_(blockposition_mutableblockposition).r(this.dO(), blockposition_mutableblockposition)) continue;
            double d4 = vec3d.a(enumdirection1.o());
            double d6 = d5 = enumdirection1.f() == EnumDirection.EnumAxisDirection.a ? 1.0 - d4 : d4;
            if (!(d5 < d3)) continue;
            d3 = d5;
            enumdirection = enumdirection1;
        }
        float f2 = this.ah.i() * 0.2f + 0.1f;
        float f1 = enumdirection.f().a();
        Vec3D vec3d1 = this.dr().a(0.75);
        if (enumdirection.o() == EnumDirection.EnumAxis.a) {
            this.n(f1 * f2, vec3d1.d, vec3d1.e);
        } else if (enumdirection.o() == EnumDirection.EnumAxis.b) {
            this.n(vec3d1.c, f1 * f2, vec3d1.e);
        } else if (enumdirection.o() == EnumDirection.EnumAxis.c) {
            this.n(vec3d1.c, vec3d1.d, f1 * f2);
        }
    }

    public void a(IBlockData iblockdata, Vec3D vec3d) {
        this.n();
        this.V = vec3d;
    }

    private static IChatBaseComponent c(IChatBaseComponent ichatbasecomponent) {
        IChatMutableComponent ichatmutablecomponent = ichatbasecomponent.e().b(ichatbasecomponent.a().a((ChatClickable)null));
        for (IChatBaseComponent ichatbasecomponent1 : ichatbasecomponent.c()) {
            ichatmutablecomponent.b(Entity.c(ichatbasecomponent1));
        }
        return ichatmutablecomponent;
    }

    @Override
    public IChatBaseComponent ah() {
        IChatBaseComponent ichatbasecomponent = this.aj();
        return ichatbasecomponent != null ? Entity.c(ichatbasecomponent) : this.cs();
    }

    protected IChatBaseComponent cs() {
        return this.n.h();
    }

    public boolean t(Entity entity) {
        return this == entity;
    }

    public float ct() {
        return 0.0f;
    }

    public void o(float f2) {
    }

    public void p(float f2) {
    }

    public boolean cu() {
        return true;
    }

    public boolean u(Entity entity) {
        return false;
    }

    public String toString() {
        String s2 = this.dO() == null ? "~NULL~" : this.dO().toString();
        return this.aH != null ? String.format(Locale.ROOT, "%s['%s'/%d, l='%s', x=%.2f, y=%.2f, z=%.2f, removed=%s]", new Object[]{this.getClass().getSimpleName(), this.ah().getString(), this.o, s2, this.dt(), this.dv(), this.dz(), this.aH}) : String.format(Locale.ROOT, "%s['%s'/%d, l='%s', x=%.2f, y=%.2f, z=%.2f]", this.getClass().getSimpleName(), this.ah().getString(), this.o, s2, this.dt(), this.dv(), this.dz());
    }

    public boolean b(DamageSource damagesource) {
        return this.dJ() || this.aY && !damagesource.a(DamageTypeTags.d) && !damagesource.h() || damagesource.a(DamageTypeTags.i) && this.be() || damagesource.a(DamageTypeTags.m) && this.am().a(TagsEntity.o);
    }

    public boolean cv() {
        return this.aY;
    }

    public void n(boolean flag) {
        this.aY = flag;
    }

    public void v(Entity entity) {
        this.b(entity.dt(), entity.dv(), entity.dz(), entity.dE(), entity.dG());
    }

    public void w(Entity entity) {
        NBTTagCompound nbttagcompound = entity.f(new NBTTagCompound());
        nbttagcompound.r("Dimension");
        this.g(nbttagcompound);
        this.aX = entity.aX;
        this.aw = entity.aw;
    }

    @Nullable
    public Entity a(DimensionTransition dimensiontransition) {
        net.minecraft.world.level.World world = this.dO();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (!this.dJ()) {
                Entity entity2;
                Location to = new Location((World)dimensiontransition.a().getWorld(), dimensiontransition.b().c, dimensiontransition.b().d, dimensiontransition.b().e, dimensiontransition.d(), dimensiontransition.e());
                EntityTeleportEvent teleEvent = CraftEventFactory.callEntityTeleportEvent(this, to);
                if (teleEvent.isCancelled()) {
                    return null;
                }
                to = teleEvent.getTo();
                dimensiontransition = new DimensionTransition(((CraftWorld)to.getWorld()).getHandle(), CraftLocation.toVec3D(to), dimensiontransition.c(), to.getYaw(), to.getPitch(), dimensiontransition.f(), dimensiontransition.g(), dimensiontransition.cause());
                WorldServer worldserver1 = dimensiontransition.a();
                List<Entity> list = this.cS();
                this.ak();
                ArrayList<Entity> list1 = new ArrayList<Entity>();
                for (Entity entity1 : list) {
                    Entity entity3 = entity1.a(dimensiontransition);
                    if (entity3 == null) continue;
                    list1.add(entity3);
                }
                worldserver.ag().a("changeDimension");
                Entity entity = entity2 = worldserver1.af() == worldserver.af() ? this : this.am().a(worldserver1);
                if (entity2 != null) {
                    if (this != entity2) {
                        entity2.w(this);
                        this.cw();
                        this.getBukkitEntity().setHandle(entity2);
                        entity2.bukkitEntity = this.getBukkitEntity();
                    }
                    entity2.b(dimensiontransition.b().c, dimensiontransition.b().d, dimensiontransition.b().e, dimensiontransition.d(), entity2.dG());
                    entity2.i(dimensiontransition.c());
                    if (this != entity2 && this.inWorld) {
                        worldserver1.d(entity2);
                    }
                    for (Entity entity3 : list1) {
                        entity3.a(entity2, true);
                    }
                    worldserver.h();
                    worldserver1.h();
                    dimensiontransition.g().onTransition(entity2);
                }
                worldserver.ag().c();
                return entity2;
            }
        }
        return null;
    }

    public void f(BlockPosition blockposition) {
        net.minecraft.world.level.World world = this.dO();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            worldserver.l().a(TicketType.e, new ChunkCoordIntPair(blockposition), 3, blockposition);
        }
    }

    protected void cw() {
        this.setRemoved(RemovalReason.e, null);
        Entity entity = this;
        if (entity instanceof Leashable) {
            Leashable leashable = (Leashable)((Object)entity);
            this.dO().getCraftServer().getPluginManager().callEvent((Event)new EntityUnleashEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), EntityUnleashEvent.UnleashReason.UNKNOWN));
            leashable.a(true, false);
        }
    }

    public Vec3D a(EnumDirection.EnumAxis enumdirection_enumaxis, BlockUtil.Rectangle blockutil_rectangle) {
        return BlockPortalShape.a(blockutil_rectangle, enumdirection_enumaxis, this.dm(), this.a(this.at()));
    }

    public CraftPortalEvent callPortalEvent(Entity entity, Location exit, PlayerTeleportEvent.TeleportCause cause, int searchRadius, int creationRadius) {
        CraftEntity bukkitEntity = entity.getBukkitEntity();
        Location enter = bukkitEntity.getLocation();
        EntityPortalEvent event = new EntityPortalEvent((org.bukkit.entity.Entity)bukkitEntity, enter, exit, searchRadius, true, creationRadius);
        event.getEntity().getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled() || event.getTo() == null || event.getTo().getWorld() == null || !entity.bE()) {
            return null;
        }
        return new CraftPortalEvent(event);
    }

    public boolean o(boolean flag) {
        return (flag || !this.bS()) && this.bE();
    }

    public boolean a(net.minecraft.world.level.World world, net.minecraft.world.level.World world1) {
        return true;
    }

    public float a(Explosion explosion, IBlockAccess iblockaccess, BlockPosition blockposition, IBlockData iblockdata, Fluid fluid, float f2) {
        return f2;
    }

    public boolean a(Explosion explosion, IBlockAccess iblockaccess, BlockPosition blockposition, IBlockData iblockdata, float f2) {
        return true;
    }

    public int cx() {
        return 3;
    }

    public boolean r_() {
        return false;
    }

    public void a(CrashReportSystemDetails crashreportsystemdetails) {
        crashreportsystemdetails.a("Entity Type", () -> {
            String s2 = String.valueOf(EntityTypes.a(this.am()));
            return s2 + " (" + this.getClass().getCanonicalName() + ")";
        });
        crashreportsystemdetails.a("Entity ID", this.o);
        crashreportsystemdetails.a("Entity Name", () -> this.ah().getString());
        crashreportsystemdetails.a("Entity's Exact location", String.format(Locale.ROOT, "%.2f, %.2f, %.2f", this.dt(), this.dv(), this.dz()));
        crashreportsystemdetails.a("Entity's Block location", CrashReportSystemDetails.a((LevelHeightAccessor)this.dO(), MathHelper.a(this.dt()), MathHelper.a(this.dv()), MathHelper.a(this.dz())));
        Vec3D vec3d = this.dr();
        crashreportsystemdetails.a("Entity's Momentum", String.format(Locale.ROOT, "%.2f, %.2f, %.2f", vec3d.c, vec3d.d, vec3d.e));
        crashreportsystemdetails.a("Entity's Passengers", () -> this.cS().toString());
        crashreportsystemdetails.a("Entity's Vehicle", () -> String.valueOf(this.dc()));
    }

    public boolean cy() {
        return this.bR() && !this.R_();
    }

    public void a_(UUID uuid) {
        this.ax = uuid;
        this.ay = this.ax.toString();
    }

    @Override
    public UUID cz() {
        return this.ax;
    }

    public String cA() {
        return this.ay;
    }

    @Override
    public String cB() {
        return this.ay;
    }

    public boolean cC() {
        return true;
    }

    public static double cD() {
        return m;
    }

    public static void b(double d0) {
        m = d0;
    }

    @Override
    public IChatBaseComponent S_() {
        return ScoreboardTeam.a(this.ck(), this.ah()).a(chatmodifier -> chatmodifier.a(this.cJ()).a(this.cA()));
    }

    public void b(@Nullable IChatBaseComponent ichatbasecomponent) {
        this.ao.a(aQ, Optional.ofNullable(ichatbasecomponent));
    }

    @Override
    @Nullable
    public IChatBaseComponent aj() {
        return this.ao.a(aQ).orElse(null);
    }

    @Override
    public boolean ai() {
        return this.ao.a(aQ).isPresent();
    }

    public void p(boolean flag) {
        this.ao.a(aR, flag);
    }

    public boolean cE() {
        return this.ao.a(aR);
    }

    public boolean teleportTo(WorldServer worldserver, double d0, double d1, double d2, Set<RelativeMovement> set, float f2, float f1, PlayerTeleportEvent.TeleportCause cause) {
        return this.a(worldserver, d0, d1, d2, set, f2, f1);
    }

    public boolean a(WorldServer worldserver, double d0, double d1, double d2, Set<RelativeMovement> set, float f2, float f1) {
        float f22 = MathHelper.a(f1, -90.0f, 90.0f);
        if (worldserver == this.dO()) {
            this.b(d0, d1, d2, f2, f22);
            this.I();
            this.o(f2);
        } else {
            this.ak();
            Object entity = this.am().a(worldserver);
            if (entity == null) {
                return false;
            }
            ((Entity)entity).w(this);
            ((Entity)entity).b(d0, d1, d2, f2, f22);
            ((Entity)entity).o(f2);
            this.setRemoved(RemovalReason.e, null);
            if (this.inWorld) {
                worldserver.d((Entity)entity);
            }
        }
        return true;
    }

    public void a(double d0, double d1, double d2) {
        this.c(d0, d1, d2);
    }

    public void c(double d0, double d1, double d2) {
        if (this.dO() instanceof WorldServer) {
            this.b(d0, d1, d2, this.dE(), this.dG());
            this.I();
        }
    }

    private void I() {
        this.cU().forEach(entity -> {
            for (Entity entity1 : entity.p) {
                entity.a(entity1, Entity::e);
            }
        });
    }

    public void d(double d0, double d1, double d2) {
        this.c(this.dt() + d0, this.dv() + d1, this.dz() + d2);
    }

    public boolean cF() {
        return this.cE();
    }

    @Override
    public void a(List<DataWatcher.c<?>> list) {
    }

    @Override
    public void a(DataWatcherObject<?> datawatcherobject) {
        if (at.equals(datawatcherobject)) {
            this.i_();
        }
    }

    @Deprecated
    protected void cG() {
        EntitySize entitysize;
        EntityPose entitypose = this.at();
        this.bd = entitysize = this.a(entitypose);
        this.be = entitysize.c();
    }

    public void i_() {
        boolean flag;
        EntitySize entitysize1;
        EntitySize entitysize = this.bd;
        EntityPose entitypose = this.at();
        this.bd = entitysize1 = this.a(entitypose);
        this.be = entitysize1.c();
        this.av();
        boolean bl = flag = (double)entitysize1.a() <= 4.0 && (double)entitysize1.b() <= 4.0;
        if (!(this.r.B || this.an || this.ag || !flag || !(entitysize1.a() > entitysize.a()) && !(entitysize1.b() > entitysize.b()) || this instanceof EntityHuman)) {
            this.a(entitysize);
        }
    }

    public boolean a(EntitySize entitysize) {
        VoxelShape voxelshape1;
        Optional<Vec3D> optional1;
        double d1;
        double d0;
        EntitySize entitysize1 = this.a(this.at());
        Vec3D vec3d = this.dm().b(0.0, (double)entitysize.b() / 2.0, 0.0);
        VoxelShape voxelshape = VoxelShapes.a(AxisAlignedBB.a(vec3d, d0 = (double)Math.max(0.0f, entitysize1.a() - entitysize.a()) + 1.0E-6, d1 = (double)Math.max(0.0f, entitysize1.b() - entitysize.b()) + 1.0E-6, d0));
        Optional<Vec3D> optional = this.r.a(this, voxelshape, vec3d, (double)entitysize1.a(), (double)entitysize1.b(), (double)entitysize1.a());
        if (optional.isPresent()) {
            this.c(optional.get().b(0.0, (double)(-entitysize1.b()) / 2.0, 0.0));
            return true;
        }
        if (entitysize1.a() > entitysize.a() && entitysize1.b() > entitysize.b() && (optional1 = this.r.a(this, voxelshape1 = VoxelShapes.a(AxisAlignedBB.a(vec3d, d0, 1.0E-6, d0)), vec3d, (double)entitysize1.a(), (double)entitysize.b(), (double)entitysize1.a())).isPresent()) {
            this.c(optional1.get().b(0.0, (double)(-entitysize.b()) / 2.0 + 1.0E-6, 0.0));
            return true;
        }
        return false;
    }

    public EnumDirection cH() {
        return EnumDirection.a(this.dE());
    }

    public EnumDirection cI() {
        return this.cH();
    }

    protected ChatHoverable cJ() {
        return new ChatHoverable(ChatHoverable.EnumHoverAction.c, new ChatHoverable.b(this.am(), this.cz(), this.ah()));
    }

    public boolean a(EntityPlayer entityplayer) {
        return true;
    }

    @Override
    public final AxisAlignedBB cK() {
        return this.aF;
    }

    public AxisAlignedBB h_() {
        return this.cK();
    }

    public final void a(AxisAlignedBB axisalignedbb) {
        double minX = axisalignedbb.a;
        double minY = axisalignedbb.b;
        double minZ = axisalignedbb.c;
        double maxX = axisalignedbb.d;
        double maxY = axisalignedbb.e;
        double maxZ = axisalignedbb.f;
        double len = axisalignedbb.d - axisalignedbb.a;
        if (len < 0.0) {
            maxX = minX;
        }
        if (len > 64.0) {
            maxX = minX + 64.0;
        }
        if ((len = axisalignedbb.e - axisalignedbb.b) < 0.0) {
            maxY = minY;
        }
        if (len > 64.0) {
            maxY = minY + 64.0;
        }
        if ((len = axisalignedbb.f - axisalignedbb.c) < 0.0) {
            maxZ = minZ;
        }
        if (len > 64.0) {
            maxZ = minZ + 64.0;
        }
        this.aF = new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public final float d(EntityPose entitypose) {
        return this.a(entitypose).c();
    }

    public final float cL() {
        return this.be;
    }

    public Vec3D q(float f2) {
        return this.cM();
    }

    protected Vec3D cM() {
        return new Vec3D(0.0, this.cL(), this.dj() * 0.4f);
    }

    public SlotAccess a_(int i2) {
        return SlotAccess.a;
    }

    @Override
    public void a(IChatBaseComponent ichatbasecomponent) {
    }

    public net.minecraft.world.level.World cN() {
        return this.dO();
    }

    @Nullable
    public MinecraftServer cO() {
        return this.dO().o();
    }

    public EnumInteractionResult a(EntityHuman entityhuman, Vec3D vec3d, EnumHand enumhand) {
        return EnumInteractionResult.e;
    }

    public boolean a(Explosion explosion) {
        return false;
    }

    public void d(EntityPlayer entityplayer) {
    }

    public void e(EntityPlayer entityplayer) {
    }

    public float a(EnumBlockRotation enumblockrotation) {
        float f2 = MathHelper.g(this.dE());
        switch (enumblockrotation) {
            case c: {
                return f2 + 180.0f;
            }
            case d: {
                return f2 + 270.0f;
            }
            case b: {
                return f2 + 90.0f;
            }
        }
        return f2;
    }

    public float a(EnumBlockMirror enumblockmirror) {
        float f2 = MathHelper.g(this.dE());
        switch (enumblockmirror) {
            case c: {
                return -f2;
            }
            case b: {
                return 180.0f - f2;
            }
        }
        return f2;
    }

    public boolean cP() {
        return false;
    }

    public ProjectileDeflection a(IProjectile iprojectile) {
        return this.am().a(TagsEntity.r) ? ProjectileDeflection.b : ProjectileDeflection.a;
    }

    @Nullable
    public EntityLiving cQ() {
        return null;
    }

    public final boolean cR() {
        return this.cQ() != null;
    }

    public final List<Entity> cS() {
        return this.p;
    }

    @Nullable
    public Entity cT() {
        return this.p.isEmpty() ? null : (Entity)this.p.get(0);
    }

    public boolean x(Entity entity) {
        return this.p.contains((Object)entity);
    }

    public boolean a(Predicate<Entity> predicate) {
        Entity entity;
        UnmodifiableIterator unmodifiableiterator = this.p.iterator();
        do {
            if (unmodifiableiterator.hasNext()) continue;
            return false;
        } while (!predicate.test(entity = (Entity)unmodifiableiterator.next()));
        return true;
    }

    private Stream<Entity> J() {
        return this.p.stream().flatMap(Entity::cU);
    }

    public Stream<Entity> cU() {
        return Stream.concat(Stream.of(this), this.J());
    }

    public Stream<Entity> cV() {
        return Stream.concat(this.p.stream().flatMap(Entity::cV), Stream.of(this));
    }

    public Iterable<Entity> cW() {
        return () -> this.J().iterator();
    }

    public int cX() {
        return (int)this.J().filter(entity -> entity instanceof EntityHuman).count();
    }

    public boolean cY() {
        return this.cX() == 1;
    }

    public Entity cZ() {
        Entity entity = this;
        while (entity.bS()) {
            entity = entity.dc();
        }
        return entity;
    }

    public boolean y(Entity entity) {
        return this.cZ() == entity.cZ();
    }

    public boolean z(Entity entity) {
        if (!entity.bS()) {
            return false;
        }
        Entity entity1 = entity.dc();
        return entity1 == this ? true : this.z(entity1);
    }

    public boolean da() {
        EntityLiving entityliving = this.cQ();
        if (entityliving instanceof EntityHuman) {
            EntityHuman entityhuman = (EntityHuman)entityliving;
            return entityhuman.g();
        }
        return this.db();
    }

    public boolean db() {
        return !this.dO().B;
    }

    protected static Vec3D a(double d0, double d1, float f2) {
        double d2 = (d0 + d1 + (double)1.0E-5f) / 2.0;
        float f1 = -MathHelper.a(f2 * ((float)Math.PI / 180));
        float f22 = MathHelper.b(f2 * ((float)Math.PI / 180));
        float f3 = Math.max(Math.abs(f1), Math.abs(f22));
        return new Vec3D((double)f1 * d2 / (double)f3, 0.0, (double)f22 * d2 / (double)f3);
    }

    public Vec3D b(EntityLiving entityliving) {
        return new Vec3D(this.dt(), this.cK().e, this.dz());
    }

    @Nullable
    public Entity dc() {
        return this.q;
    }

    @Nullable
    public Entity dd() {
        return this.q != null && this.q.cQ() == this ? this.q : null;
    }

    public EnumPistonReaction j_() {
        return EnumPistonReaction.a;
    }

    public SoundCategory de() {
        return SoundCategory.g;
    }

    public int df() {
        return 1;
    }

    public CommandListenerWrapper dg() {
        return new CommandListenerWrapper(this, this.dm(), this.bN(), this.dO() instanceof WorldServer ? (WorldServer)this.dO() : null, this.G(), this.ah().getString(), this.S_(), this.dO().o(), this);
    }

    protected int G() {
        return 0;
    }

    public boolean l(int i2) {
        return this.G() >= i2;
    }

    @Override
    public boolean k_() {
        return this.dO().ab().b(GameRules.p);
    }

    @Override
    public boolean w_() {
        return true;
    }

    @Override
    public boolean M_() {
        return true;
    }

    public void a(ArgumentAnchor.Anchor argumentanchor_anchor, Vec3D vec3d) {
        Vec3D vec3d1 = argumentanchor_anchor.a(this);
        double d0 = vec3d.c - vec3d1.c;
        double d1 = vec3d.d - vec3d1.d;
        double d2 = vec3d.e - vec3d1.e;
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        this.u(MathHelper.g((float)(-(MathHelper.d(d1, d3) * 57.2957763671875))));
        this.t(MathHelper.g((float)(MathHelper.d(d2, d0) * 57.2957763671875) - 90.0f));
        this.o(this.dE());
        this.P = this.dG();
        this.O = this.dE();
    }

    public float r(float f2) {
        return MathHelper.i(f2, this.O, this.aD);
    }

    public boolean a(TagKey<FluidType> tagkey, double d0) {
        if (this.dh()) {
            return false;
        }
        AxisAlignedBB axisalignedbb = this.cK().h(0.001);
        int i2 = MathHelper.a(axisalignedbb.a);
        int j2 = MathHelper.c(axisalignedbb.d);
        int k2 = MathHelper.a(axisalignedbb.b);
        int l2 = MathHelper.c(axisalignedbb.e);
        int i1 = MathHelper.a(axisalignedbb.c);
        int j1 = MathHelper.c(axisalignedbb.f);
        double d1 = 0.0;
        boolean flag = this.cC();
        boolean flag1 = false;
        Vec3D vec3d = Vec3D.b;
        int k1 = 0;
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        for (int l1 = i2; l1 < j2; ++l1) {
            for (int i22 = k2; i22 < l2; ++i22) {
                for (int j22 = i1; j22 < j1; ++j22) {
                    double d2;
                    blockposition_mutableblockposition.d(l1, i22, j22);
                    Fluid fluid = this.dO().b_(blockposition_mutableblockposition);
                    if (!fluid.a(tagkey) || !((d2 = (double)((float)i22 + fluid.a((IBlockAccess)this.dO(), (BlockPosition)blockposition_mutableblockposition))) >= axisalignedbb.b)) continue;
                    flag1 = true;
                    d1 = Math.max(d2 - axisalignedbb.b, d1);
                    if (flag) {
                        Vec3D vec3d1 = fluid.c(this.dO(), blockposition_mutableblockposition);
                        if (d1 < 0.4) {
                            vec3d1 = vec3d1.a(d1);
                        }
                        vec3d = vec3d.e(vec3d1);
                        ++k1;
                    }
                    if (tagkey != TagsFluid.b) continue;
                    this.lastLavaContact = blockposition_mutableblockposition.j();
                }
            }
        }
        if (vec3d.f() > 0.0) {
            if (k1 > 0) {
                vec3d = vec3d.a(1.0 / (double)k1);
            }
            if (!(this instanceof EntityHuman)) {
                vec3d = vec3d.d();
            }
            Vec3D vec3d2 = this.dr();
            vec3d = vec3d.a(d0);
            double d3 = 0.003;
            if (Math.abs(vec3d2.c) < 0.003 && Math.abs(vec3d2.e) < 0.003 && vec3d.f() < 0.0045000000000000005) {
                vec3d = vec3d.d().a(0.0045000000000000005);
            }
            this.i(this.dr().e(vec3d));
        }
        this.ak.put(tagkey, d1);
        return flag1;
    }

    public boolean dh() {
        AxisAlignedBB axisalignedbb = this.cK().g(1.0);
        int i2 = MathHelper.a(axisalignedbb.a);
        int j2 = MathHelper.c(axisalignedbb.d);
        int k2 = MathHelper.a(axisalignedbb.c);
        int l2 = MathHelper.c(axisalignedbb.f);
        return !this.dO().b(i2, k2, j2, l2);
    }

    public double b(TagKey<FluidType> tagkey) {
        return this.ak.getDouble(tagkey);
    }

    public double di() {
        return (double)this.cL() < 0.4 ? 0.0 : 0.4;
    }

    public final float dj() {
        return this.bd.a();
    }

    public final float dk() {
        return this.bd.b();
    }

    public Packet<PacketListenerPlayOut> a(EntityTrackerEntry entitytrackerentry) {
        return new PacketPlayOutSpawnEntity(this, entitytrackerentry);
    }

    public EntitySize a(EntityPose entitypose) {
        return this.n.n();
    }

    public final EntityAttachments dl() {
        return this.bd.d();
    }

    public Vec3D dm() {
        return this.s;
    }

    public Vec3D dn() {
        return this.dm();
    }

    @Override
    public BlockPosition do() {
        return this.t;
    }

    public IBlockData dp() {
        if (this.bj == null) {
            this.bj = this.dO().a_(this.do());
        }
        return this.bj;
    }

    public ChunkCoordIntPair dq() {
        return this.u;
    }

    public Vec3D dr() {
        return this.v;
    }

    public void i(Vec3D vec3d) {
        this.v = vec3d;
    }

    public void j(Vec3D vec3d) {
        this.i(this.dr().e(vec3d));
    }

    public void n(double d0, double d1, double d2) {
        this.i(new Vec3D(d0, d1, d2));
    }

    public final int ds() {
        return this.t.u();
    }

    public final double dt() {
        return this.s.c;
    }

    public double c(double d0) {
        return this.s.c + (double)this.dj() * d0;
    }

    public double d(double d0) {
        return this.c((2.0 * this.ah.j() - 1.0) * d0);
    }

    public final int du() {
        return this.t.v();
    }

    public final double dv() {
        return this.s.d;
    }

    public double e(double d0) {
        return this.s.d + (double)this.dk() * d0;
    }

    public double dw() {
        return this.e(this.ah.j());
    }

    public double dx() {
        return this.s.d + (double)this.be;
    }

    public final int dy() {
        return this.t.w();
    }

    public final double dz() {
        return this.s.e;
    }

    public double f(double d0) {
        return this.s.e + (double)this.dj() * d0;
    }

    public double g(double d0) {
        return this.f((2.0 * this.ah.j() - 1.0) * d0);
    }

    public final void o(double d0, double d1, double d2) {
        if (this.s.c != d0 || this.s.d != d1 || this.s.e != d2) {
            this.s = new Vec3D(d0, d1, d2);
            int i2 = MathHelper.a(d0);
            int j2 = MathHelper.a(d1);
            int k2 = MathHelper.a(d2);
            if (i2 != this.t.u() || j2 != this.t.v() || k2 != this.t.w()) {
                this.t = new BlockPosition(i2, j2, k2);
                this.bj = null;
                if (SectionPosition.a(i2) != this.u.e || SectionPosition.a(k2) != this.u.f) {
                    this.u = new ChunkCoordIntPair(this.t);
                }
            }
            this.aV.a();
        }
    }

    public void dA() {
    }

    public Vec3D s(float f2) {
        return this.m(f2).b(0.0, (double)this.be * 0.7, 0.0);
    }

    public void a(PacketPlayOutSpawnEntity packetplayoutspawnentity) {
        int i2 = packetplayoutspawnentity.b();
        double d0 = packetplayoutspawnentity.g();
        double d1 = packetplayoutspawnentity.h();
        double d2 = packetplayoutspawnentity.i();
        this.f(d0, d1, d2);
        this.e(d0, d1, d2);
        this.u(packetplayoutspawnentity.m());
        this.t(packetplayoutspawnentity.n());
        this.e(i2);
        this.a_(packetplayoutspawnentity.e());
    }

    @Nullable
    public ItemStack dB() {
        return null;
    }

    public void q(boolean flag) {
        this.az = flag;
    }

    public boolean dC() {
        return !this.am().a(TagsEntity.k);
    }

    public boolean dD() {
        return (this.az || this.aA) && this.dC();
    }

    public float dE() {
        return this.aD;
    }

    public float dF() {
        return this.dE();
    }

    public void t(float f2) {
        if (!Float.isFinite(f2)) {
            SystemUtils.b("Invalid entity rotation: " + f2 + ", discarding.");
        } else {
            this.aD = f2;
        }
    }

    public float dG() {
        return this.aE;
    }

    public void u(float f2) {
        if (!Float.isFinite(f2)) {
            SystemUtils.b("Invalid entity rotation: " + f2 + ", discarding.");
        } else {
            this.aE = f2;
        }
    }

    public boolean dH() {
        return false;
    }

    public float dI() {
        return 0.0f;
    }

    public void a(@Nullable Entity entity) {
    }

    public final boolean dJ() {
        return this.aH != null;
    }

    @Nullable
    public RemovalReason dK() {
        return this.aH;
    }

    @Override
    public final void b(RemovalReason entity_removalreason) {
        this.setRemoved(entity_removalreason, null);
    }

    @Override
    public final void setRemoved(RemovalReason entity_removalreason, EntityRemoveEvent.Cause cause) {
        CraftEventFactory.callEntityRemoveEvent(this, cause);
        if (this.aH == null) {
            this.aH = entity_removalreason;
        }
        if (this.aH.a()) {
            this.ad();
        }
        this.cS().forEach(Entity::ad);
        this.aV.a(entity_removalreason);
    }

    public void dL() {
        this.aH = null;
    }

    @Override
    public void a(EntityInLevelCallback entityinlevelcallback) {
        this.aV = entityinlevelcallback;
    }

    @Override
    public boolean dM() {
        return this.aH != null && !this.aH.b() ? false : (this.bS() ? false : !this.bT() || !this.cY());
    }

    @Override
    public boolean dN() {
        return false;
    }

    public boolean a(net.minecraft.world.level.World world, BlockPosition blockposition) {
        return true;
    }

    public net.minecraft.world.level.World dO() {
        return this.r;
    }

    protected void a(net.minecraft.world.level.World world) {
        this.r = world;
    }

    public DamageSources dP() {
        return this.dO().aj();
    }

    public IRegistryCustom dQ() {
        return this.dO().H_();
    }

    protected void a(int i2, double d0, double d1, double d2, double d3, double d4) {
        double d5 = 1.0 / (double)i2;
        double d6 = MathHelper.d(d5, this.dt(), d0);
        double d7 = MathHelper.d(d5, this.dv(), d1);
        double d8 = MathHelper.d(d5, this.dz(), d2);
        float f2 = (float)MathHelper.e(d5, (double)this.dE(), d3);
        float f1 = (float)MathHelper.d(d5, (double)this.dG(), d4);
        this.a_(d6, d7, d8);
        this.a(f2, f1);
    }

    public RandomSource dR() {
        return this.ah;
    }

    public Vec3D ag() {
        EntityLiving entityliving = this.cQ();
        if (entityliving instanceof EntityHuman) {
            EntityHuman entityhuman = (EntityHuman)entityliving;
            if (this.bE()) {
                return entityhuman.ag();
            }
        }
        return this.dr();
    }

    @Nullable
    public ItemStack dS() {
        return null;
    }

    public static enum RemovalReason {
        a(true, false),
        b(true, false),
        c(false, true),
        d(false, false),
        e(false, false);

        private final boolean f;
        private final boolean g;

        private RemovalReason(boolean flag, boolean flag1) {
            this.f = flag;
            this.g = flag1;
        }

        public boolean a() {
            return this.f;
        }

        public boolean b() {
            return this.g;
        }
    }

    public static enum MovementEmission {
        a(false, false),
        b(true, false),
        c(false, true),
        d(true, true);

        final boolean e;
        final boolean f;

        private MovementEmission(boolean flag, boolean flag1) {
            this.e = flag;
            this.f = flag1;
        }

        public boolean a() {
            return this.f || this.e;
        }

        public boolean b() {
            return this.f;
        }

        public boolean c() {
            return this.e;
        }
    }

    @FunctionalInterface
    public static interface MoveFunction {
        public void accept(Entity var1, double var2, double var4, double var6);
    }
}

