/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Level;
import javax.annotation.Nullable;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.tags.TagKey;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.EquipmentTable;
import net.minecraft.world.entity.EquipmentUser;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.Targeting;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerJump;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.control.EntityAIBodyControl;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSelector;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.sensing.EntitySenses;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemArmor;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemBow;
import net.minecraft.world.item.ItemCrossbow;
import net.minecraft.world.item.ItemMonsterEgg;
import net.minecraft.world.item.ItemProjectileWeapon;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemSword;
import net.minecraft.world.item.ItemTool;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.providers.VanillaEnchantmentProviders;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityKnockbackEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.entity.EntityUnleashEvent;

public abstract class EntityInsentient
extends EntityLiving
implements EquipmentUser,
Leashable,
Targeting {
    private static final DataWatcherObject<Byte> b = DataWatcher.a(EntityInsentient.class, DataWatcherRegistry.a);
    private static final int c = 1;
    private static final int d = 2;
    private static final int e = 4;
    protected static final int h = 1;
    private static final BaseBlockPosition cb = new BaseBlockPosition(1, 0, 1);
    public static final float bH = 0.15f;
    public static final float bI = 0.55f;
    public static final float bJ = 0.5f;
    public static final float bK = 0.25f;
    public static final float bL = 0.085f;
    public static final float bM = 1.0f;
    public static final int bN = 2;
    public static final int bO = 2;
    private static final double cc = Math.sqrt(2.04f) - (double)0.6f;
    protected static final MinecraftKey bP = MinecraftKey.b("random_spawn_bonus");
    public int bQ;
    protected int bR;
    protected ControllerLook bS;
    protected ControllerMove bT;
    protected ControllerJump bU;
    private final EntityAIBodyControl cd;
    protected NavigationAbstract bV;
    public PathfinderGoalSelector bW;
    public PathfinderGoalSelector bX;
    @Nullable
    private EntityLiving ce;
    private final EntitySenses cf;
    private final NonNullList<ItemStack> cg = NonNullList.a(2, ItemStack.l);
    public final float[] bY = new float[2];
    private final NonNullList<ItemStack> ch = NonNullList.a(4, ItemStack.l);
    public final float[] bZ = new float[4];
    private ItemStack ci = ItemStack.l;
    protected float ca;
    private boolean cj;
    private boolean ck;
    private final Map<PathType, Float> cl = Maps.newEnumMap(PathType.class);
    @Nullable
    public ResourceKey<LootTable> cm;
    public long cn;
    @Nullable
    private Leashable.a co;
    private BlockPosition cp = BlockPosition.c;
    private float cq = -1.0f;
    public boolean aware = true;

    protected EntityInsentient(EntityTypes<? extends EntityInsentient> entitytypes, World world) {
        super((EntityTypes<? extends EntityLiving>)entitytypes, world);
        this.bW = new PathfinderGoalSelector(world.ah());
        this.bX = new PathfinderGoalSelector(world.ah());
        this.bS = new ControllerLook(this);
        this.bT = new ControllerMove(this);
        this.bU = new ControllerJump(this);
        this.cd = this.H();
        this.bV = this.b(world);
        this.cf = new EntitySenses(this);
        Arrays.fill(this.bZ, 0.085f);
        Arrays.fill(this.bY, 0.085f);
        this.ca = 0.085f;
        if (world != null && !world.B) {
            this.B();
        }
    }

    public void setPersistenceRequired(boolean persistenceRequired) {
        this.ck = persistenceRequired;
    }

    protected void B() {
    }

    public static AttributeProvider.Builder C() {
        return EntityLiving.dV().a(GenericAttributes.m, 16.0);
    }

    protected NavigationAbstract b(World world) {
        return new Navigation(this, world);
    }

    protected boolean D() {
        return false;
    }

    public float a(PathType pathtype) {
        EntityInsentient entityinsentient1;
        Entity entity = this.dd();
        EntityInsentient entityinsentient = entity instanceof EntityInsentient && (entityinsentient1 = (EntityInsentient)entity).D() ? entityinsentient1 : this;
        Float ofloat = entityinsentient.cl.get((Object)pathtype);
        return ofloat == null ? pathtype.a() : ofloat.floatValue();
    }

    public void a(PathType pathtype, float f2) {
        this.cl.put(pathtype, Float.valueOf(f2));
    }

    public void E() {
    }

    public void F() {
    }

    protected EntityAIBodyControl H() {
        return new EntityAIBodyControl(this);
    }

    public ControllerLook I() {
        return this.bS;
    }

    public ControllerMove J() {
        Entity entity = this.dd();
        if (entity instanceof EntityInsentient) {
            EntityInsentient entityinsentient = (EntityInsentient)entity;
            return entityinsentient.J();
        }
        return this.bT;
    }

    public ControllerJump L() {
        return this.bU;
    }

    public NavigationAbstract N() {
        Entity entity = this.dd();
        if (entity instanceof EntityInsentient) {
            EntityInsentient entityinsentient = (EntityInsentient)entity;
            return entityinsentient.N();
        }
        return this.bV;
    }

    @Override
    @Nullable
    public EntityLiving cQ() {
        Entity entity = this.cT();
        if (!this.fZ() && entity instanceof EntityInsentient) {
            EntityInsentient entityinsentient1 = (EntityInsentient)entity;
            if (entity.bV()) {
                EntityInsentient entityinsentient = entityinsentient1;
                return entityinsentient;
            }
        }
        EntityLiving entityinsentient = null;
        return entityinsentient;
    }

    public EntitySenses O() {
        return this.cf;
    }

    @Override
    @Nullable
    public EntityLiving p() {
        return this.ce;
    }

    @Nullable
    protected final EntityLiving P() {
        return this.dT().c(MemoryModuleType.o).orElse(null);
    }

    public void h(@Nullable EntityLiving entityliving) {
        this.setTarget(entityliving, EntityTargetEvent.TargetReason.UNKNOWN, true);
    }

    public boolean setTarget(EntityLiving entityliving, EntityTargetEvent.TargetReason reason, boolean fireEvent) {
        if (this.p() == entityliving) {
            return false;
        }
        if (fireEvent) {
            if (reason == EntityTargetEvent.TargetReason.UNKNOWN && this.p() != null && entityliving == null) {
                EntityTargetEvent.TargetReason targetReason = reason = this.p().bE() ? EntityTargetEvent.TargetReason.FORGOT_TARGET : EntityTargetEvent.TargetReason.TARGET_DIED;
            }
            if (reason == EntityTargetEvent.TargetReason.UNKNOWN) {
                this.dO().getCraftServer().getLogger().log(Level.WARNING, "Unknown target reason, please report on the issue tracker", new Exception());
            }
            CraftLivingEntity ctarget = null;
            if (entityliving != null) {
                ctarget = (CraftLivingEntity)entityliving.getBukkitEntity();
            }
            EntityTargetLivingEntityEvent event = new EntityTargetLivingEntityEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (LivingEntity)ctarget, reason);
            this.dO().getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return false;
            }
            entityliving = event.getTarget() != null ? ((CraftLivingEntity)event.getTarget()).getHandle() : null;
        }
        this.ce = entityliving;
        return true;
    }

    @Override
    public boolean a(EntityTypes<?> entitytypes) {
        return entitytypes != EntityTypes.T;
    }

    public boolean a(ItemProjectileWeapon itemprojectileweapon) {
        return false;
    }

    public void Q() {
        ((Entity)this).a(GameEvent.m);
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(b, (byte)0);
    }

    public int R() {
        return 80;
    }

    public void S() {
        this.b(this.v());
    }

    @Override
    public void aw() {
        super.aw();
        this.dO().ag().a("mobBaseTick");
        if (this.bE() && this.ah.a(1000) < this.bQ++) {
            this.s();
            this.S();
        }
        this.dO().ag().c();
    }

    @Override
    protected void e(DamageSource damagesource) {
        this.s();
        super.e(damagesource);
    }

    private void s() {
        this.bQ = -this.R();
    }

    @Override
    protected int eg() {
        if (this.bR > 0) {
            int j2;
            int i2 = this.bR;
            for (j2 = 0; j2 < this.ch.size(); ++j2) {
                if (this.ch.get(j2).e() || !(this.bZ[j2] <= 1.0f)) continue;
                i2 += 1 + this.ah.a(3);
            }
            for (j2 = 0; j2 < this.cg.size(); ++j2) {
                if (this.cg.get(j2).e() || !(this.bY[j2] <= 1.0f)) continue;
                i2 += 1 + this.ah.a(3);
            }
            if (!this.ci.e() && this.ca <= 1.0f) {
                i2 += 1 + this.ah.a(3);
            }
            return i2;
        }
        return this.bR;
    }

    public void T() {
        if (this.dO().B) {
            for (int i2 = 0; i2 < 20; ++i2) {
                double d0 = this.ah.k() * 0.02;
                double d1 = this.ah.k() * 0.02;
                double d2 = this.ah.k() * 0.02;
                double d3 = 10.0;
                this.dO().a(Particles.ab, this.c(1.0) - d0 * 10.0, this.dw() - d1 * 10.0, this.g(1.0) - d2 * 10.0, d0, d1, d2);
            }
        } else {
            this.dO().a((Entity)this, (byte)20);
        }
    }

    @Override
    public void b(byte b0) {
        if (b0 == 20) {
            this.T();
        } else {
            super.b(b0);
        }
    }

    @Override
    public void l() {
        super.l();
        if (!this.dO().B && this.ai % 5 == 0) {
            this.U();
        }
    }

    protected void U() {
        boolean flag = !(this.cQ() instanceof EntityInsentient);
        boolean flag1 = !(this.dc() instanceof EntityBoat);
        this.bW.a(PathfinderGoal.Type.a, flag);
        this.bW.a(PathfinderGoal.Type.c, flag && flag1);
        this.bW.a(PathfinderGoal.Type.b, flag);
    }

    @Override
    protected float f(float f2, float f1) {
        this.cd.a();
        return f1;
    }

    @Nullable
    protected SoundEffect v() {
        return null;
    }

    public SoundEffect getAmbientSound0() {
        return this.v();
    }

    @Override
    public void b(NBTTagCompound nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("CanPickUpLoot", this.fS());
        nbttagcompound.a("PersistenceRequired", this.ck);
        NBTTagList nbttaglist = new NBTTagList();
        for (ItemStack itemstack : this.ch) {
            if (!itemstack.e()) {
                nbttaglist.add(itemstack.a(this.dQ()));
                continue;
            }
            nbttaglist.add(new NBTTagCompound());
        }
        nbttagcompound.a("ArmorItems", nbttaglist);
        NBTTagList nbttaglist1 = new NBTTagList();
        for (float f2 : this.bZ) {
            nbttaglist1.add(NBTTagFloat.a(f2));
        }
        nbttagcompound.a("ArmorDropChances", nbttaglist1);
        NBTTagList nbttaglist2 = new NBTTagList();
        for (ItemStack itemstack1 : this.cg) {
            if (!itemstack1.e()) {
                nbttaglist2.add(itemstack1.a(this.dQ()));
                continue;
            }
            nbttaglist2.add(new NBTTagCompound());
        }
        nbttagcompound.a("HandItems", nbttaglist2);
        NBTTagList nbttaglist3 = new NBTTagList();
        for (float f1 : this.bY) {
            nbttaglist3.add(NBTTagFloat.a(f1));
        }
        nbttagcompound.a("HandDropChances", nbttaglist3);
        if (!this.ci.e()) {
            nbttagcompound.a("body_armor_item", this.ci.a(this.dQ()));
            nbttagcompound.a("body_armor_drop_chance", this.ca);
        }
        this.a(nbttagcompound, this.co);
        nbttagcompound.a("LeftHanded", this.ga());
        if (this.cm != null) {
            nbttagcompound.a("DeathLootTable", this.cm.a().toString());
            if (this.cn != 0L) {
                nbttagcompound.a("DeathLootTableSeed", this.cn);
            }
        }
        if (this.fZ()) {
            nbttagcompound.a("NoAI", this.fZ());
        }
        nbttagcompound.a("Bukkit.Aware", this.aware);
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        NBTTagCompound nbttagcompound1;
        int i2;
        NBTTagList nbttaglist;
        boolean data;
        super.a(nbttagcompound);
        if (nbttagcompound.b("CanPickUpLoot", 1)) {
            data = nbttagcompound.q("CanPickUpLoot");
            if (EntityInsentient.isLevelAtLeast(nbttagcompound, 1) || data) {
                this.a_(data);
            }
        }
        data = nbttagcompound.q("PersistenceRequired");
        if (EntityInsentient.isLevelAtLeast(nbttagcompound, 1) || data) {
            this.ck = data;
        }
        if (nbttagcompound.b("ArmorItems", 9)) {
            nbttaglist = nbttagcompound.c("ArmorItems", 10);
            for (i2 = 0; i2 < this.ch.size(); ++i2) {
                nbttagcompound1 = nbttaglist.a(i2);
                this.ch.set(i2, ItemStack.a((HolderLookup.a)this.dQ(), nbttagcompound1));
            }
        }
        if (nbttagcompound.b("ArmorDropChances", 9)) {
            nbttaglist = nbttagcompound.c("ArmorDropChances", 5);
            for (i2 = 0; i2 < nbttaglist.size(); ++i2) {
                this.bZ[i2] = nbttaglist.i(i2);
            }
        }
        if (nbttagcompound.b("HandItems", 9)) {
            nbttaglist = nbttagcompound.c("HandItems", 10);
            for (i2 = 0; i2 < this.cg.size(); ++i2) {
                nbttagcompound1 = nbttaglist.a(i2);
                this.cg.set(i2, ItemStack.a((HolderLookup.a)this.dQ(), nbttagcompound1));
            }
        }
        if (nbttagcompound.b("HandDropChances", 9)) {
            nbttaglist = nbttagcompound.c("HandDropChances", 5);
            for (i2 = 0; i2 < nbttaglist.size(); ++i2) {
                this.bY[i2] = nbttaglist.i(i2);
            }
        }
        if (nbttagcompound.b("body_armor_item", 10)) {
            this.ci = ItemStack.a((HolderLookup.a)this.dQ(), (NBTBase)nbttagcompound.p("body_armor_item")).orElse(ItemStack.l);
            this.ca = nbttagcompound.j("body_armor_drop_chance");
        } else {
            this.ci = ItemStack.l;
        }
        this.co = this.c(nbttagcompound);
        this.v(nbttagcompound.q("LeftHanded"));
        if (nbttagcompound.b("DeathLootTable", 8)) {
            this.cm = ResourceKey.a(Registries.bc, MinecraftKey.a(nbttagcompound.l("DeathLootTable")));
            this.cn = nbttagcompound.i("DeathLootTableSeed");
        }
        this.u(nbttagcompound.q("NoAI"));
        if (nbttagcompound.e("Bukkit.Aware")) {
            this.aware = nbttagcompound.q("Bukkit.Aware");
        }
    }

    @Override
    protected void a(DamageSource damagesource, boolean flag) {
        super.a(damagesource, flag);
        this.cm = null;
    }

    @Override
    public final ResourceKey<LootTable> eA() {
        return this.cm == null ? this.V() : this.cm;
    }

    protected ResourceKey<LootTable> V() {
        return super.eA();
    }

    @Override
    public long eB() {
        return this.cn;
    }

    public void E(float f2) {
        this.bq = f2;
    }

    public void F(float f2) {
        this.bp = f2;
    }

    public void G(float f2) {
        this.bo = f2;
    }

    @Override
    public void A(float f2) {
        super.A(f2);
        this.E(f2);
    }

    public void W() {
        this.N().n();
        this.G(0.0f);
        this.F(0.0f);
        this.A(0.0f);
    }

    @Override
    public void m_() {
        super.m_();
        this.dO().ag().a("looting");
        if (!this.dO().B && this.fS() && this.bE() && !this.be && this.dO().ab().b(GameRules.c)) {
            BaseBlockPosition baseblockposition = this.X();
            List<EntityItem> list = this.dO().a(EntityItem.class, this.cK().c(baseblockposition.u(), baseblockposition.v(), baseblockposition.w()));
            for (EntityItem entityitem : list) {
                if (entityitem.dJ() || entityitem.p().e() || entityitem.y() || !this.k(entityitem.p())) continue;
                this.b(entityitem);
            }
        }
        this.dO().ag().c();
    }

    protected BaseBlockPosition X() {
        return cb;
    }

    protected void b(EntityItem entityitem) {
        ItemStack itemstack = entityitem.p();
        ItemStack itemstack1 = this.equipItemIfPossible(itemstack.s(), entityitem);
        if (!itemstack1.e()) {
            this.a(entityitem);
            this.a((Entity)entityitem, itemstack1.H());
            itemstack.h(itemstack1.H());
            if (itemstack.e()) {
                entityitem.discard(EntityRemoveEvent.Cause.PICKUP);
            }
        }
    }

    public ItemStack i(ItemStack itemstack) {
        return this.equipItemIfPossible(itemstack, null);
    }

    public ItemStack equipItemIfPossible(ItemStack itemstack, EntityItem entityitem) {
        boolean canPickup;
        EnumItemSlot enumitemslot = this.h(itemstack);
        ItemStack itemstack1 = this.a(enumitemslot);
        boolean flag = this.b(itemstack, itemstack1);
        if (enumitemslot.f() && !flag) {
            enumitemslot = EnumItemSlot.a;
            itemstack1 = this.a(enumitemslot);
            flag = itemstack1.e();
        }
        boolean bl = canPickup = flag && this.j(itemstack);
        if (entityitem != null) {
            boolean bl2 = canPickup = !CraftEventFactory.callEntityPickupItemEvent(this, entityitem, 0, !canPickup).isCancelled();
        }
        if (canPickup) {
            double d0 = this.f(enumitemslot);
            if (!itemstack1.e() && (double)Math.max(this.ah.i() - 0.1f, 0.0f) < d0) {
                this.forceDrops = true;
                this.b(itemstack1);
                this.forceDrops = false;
            }
            ItemStack itemstack2 = enumitemslot.a(itemstack);
            this.b(enumitemslot, itemstack2);
            return itemstack2;
        }
        return ItemStack.l;
    }

    protected void b(EnumItemSlot enumitemslot, ItemStack itemstack) {
        this.a(enumitemslot, itemstack);
        this.e(enumitemslot);
        this.ck = true;
    }

    public void e(EnumItemSlot enumitemslot) {
        switch (enumitemslot.a()) {
            case a: {
                this.bY[enumitemslot.b()] = 2.0f;
                break;
            }
            case b: {
                this.bZ[enumitemslot.b()] = 2.0f;
                break;
            }
            case c: {
                this.ca = 2.0f;
            }
        }
    }

    protected boolean b(ItemStack itemstack, ItemStack itemstack1) {
        if (itemstack1.e()) {
            return true;
        }
        if (itemstack.g() instanceof ItemSword) {
            double d1;
            if (!(itemstack1.g() instanceof ItemSword)) {
                return true;
            }
            double d0 = this.o(itemstack);
            return d0 != (d1 = this.o(itemstack1)) ? d0 > d1 : this.c(itemstack, itemstack1);
        }
        if (itemstack.g() instanceof ItemBow && itemstack1.g() instanceof ItemBow) {
            return this.c(itemstack, itemstack1);
        }
        if (itemstack.g() instanceof ItemCrossbow && itemstack1.g() instanceof ItemCrossbow) {
            return this.c(itemstack, itemstack1);
        }
        Item item = itemstack.g();
        if (item instanceof ItemArmor) {
            ItemArmor itemarmor = (ItemArmor)item;
            if (EnchantmentManager.a(itemstack1, EnchantmentEffectComponents.E)) {
                return false;
            }
            if (!(itemstack1.g() instanceof ItemArmor)) {
                return true;
            }
            ItemArmor itemarmor1 = (ItemArmor)itemstack1.g();
            return itemarmor.k() != itemarmor1.k() ? itemarmor.k() > itemarmor1.k() : (itemarmor.l() != itemarmor1.l() ? itemarmor.l() > itemarmor1.l() : this.c(itemstack, itemstack1));
        }
        if (itemstack.g() instanceof ItemTool) {
            if (itemstack1.g() instanceof ItemBlock) {
                return true;
            }
            if (itemstack1.g() instanceof ItemTool) {
                double d1;
                double d0 = this.o(itemstack);
                if (d0 != (d1 = this.o(itemstack1))) {
                    return d0 > d1;
                }
                return this.c(itemstack, itemstack1);
            }
        }
        return false;
    }

    private double o(ItemStack itemstack) {
        ItemAttributeModifiers itemattributemodifiers = itemstack.a(DataComponents.n, ItemAttributeModifiers.a);
        return itemattributemodifiers.a(this.h(GenericAttributes.c), EnumItemSlot.a);
    }

    public boolean c(ItemStack itemstack, ItemStack itemstack1) {
        return itemstack.n() < itemstack1.n() ? true : EntityInsentient.p(itemstack) && !EntityInsentient.p(itemstack1);
    }

    private static boolean p(ItemStack itemstack) {
        DataComponentMap datacomponentmap = itemstack.a();
        int i2 = datacomponentmap.d();
        return i2 > 1 || i2 == 1 && !datacomponentmap.b(DataComponents.e);
    }

    public boolean j(ItemStack itemstack) {
        return true;
    }

    public boolean k(ItemStack itemstack) {
        return this.j(itemstack);
    }

    public boolean h(double d0) {
        return true;
    }

    public boolean Y() {
        return this.bS();
    }

    protected boolean Z() {
        return false;
    }

    @Override
    public void dA() {
        if (this.dO().al() == EnumDifficulty.a && this.Z()) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else if (!this.fT() && !this.Y()) {
            EntityHuman entityhuman = this.dO().a((Entity)this, -1.0);
            if (entityhuman != null) {
                int i2;
                int j2;
                double d0 = entityhuman.g((Entity)this);
                if (d0 > (double)(j2 = (i2 = this.am().f().f()) * i2) && this.h(d0)) {
                    this.discard(EntityRemoveEvent.Cause.DESPAWN);
                }
                int k2 = this.am().f().g();
                int l2 = k2 * k2;
                if (this.bf > 600 && this.ah.a(800) == 0 && d0 > (double)l2 && this.h(d0)) {
                    this.discard(EntityRemoveEvent.Cause.DESPAWN);
                } else if (d0 < (double)l2) {
                    this.bf = 0;
                }
            }
        } else {
            this.bf = 0;
        }
    }

    @Override
    protected final void fm() {
        ++this.bf;
        if (!this.aware) {
            return;
        }
        GameProfilerFiller gameprofilerfiller = this.dO().ag();
        gameprofilerfiller.a("sensing");
        this.cf.a();
        gameprofilerfiller.c();
        int i2 = this.ai + this.an();
        if (i2 % 2 != 0 && this.ai > 1) {
            gameprofilerfiller.a("targetSelector");
            this.bX.a(false);
            gameprofilerfiller.c();
            gameprofilerfiller.a("goalSelector");
            this.bW.a(false);
            gameprofilerfiller.c();
        } else {
            gameprofilerfiller.a("targetSelector");
            this.bX.a();
            gameprofilerfiller.c();
            gameprofilerfiller.a("goalSelector");
            this.bW.a();
            gameprofilerfiller.c();
        }
        gameprofilerfiller.a("navigation");
        this.bV.c();
        gameprofilerfiller.c();
        gameprofilerfiller.a("mob tick");
        this.ab();
        gameprofilerfiller.c();
        gameprofilerfiller.a("controls");
        gameprofilerfiller.a("move");
        this.bT.a();
        gameprofilerfiller.b("look");
        this.bS.a();
        gameprofilerfiller.b("jump");
        this.bU.b();
        gameprofilerfiller.c();
        gameprofilerfiller.c();
        this.aa();
    }

    protected void aa() {
        PacketDebug.a(this.dO(), this, this.bW);
    }

    protected void ab() {
    }

    public int ac() {
        return 40;
    }

    public int ae() {
        return 75;
    }

    protected void af() {
        float f2 = this.ae();
        float f1 = this.ct();
        float f22 = MathHelper.g(this.aY - f1);
        float f3 = MathHelper.a(MathHelper.g(this.aY - f1), -f2, f2);
        float f4 = f1 + f22 - f3;
        this.o(f4);
    }

    public int fM() {
        return 10;
    }

    public void a(Entity entity, float f2, float f1) {
        double d2;
        double d0 = entity.dt() - this.dt();
        double d1 = entity.dz() - this.dz();
        if (entity instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)entity;
            d2 = entityliving.dx() - this.dx();
        } else {
            d2 = (entity.cK().b + entity.cK().e) / 2.0 - this.dx();
        }
        double d3 = Math.sqrt(d0 * d0 + d1 * d1);
        float f22 = (float)(MathHelper.d(d1, d0) * 57.2957763671875) - 90.0f;
        float f3 = (float)(-(MathHelper.d(d2, d3) * 57.2957763671875));
        this.u(this.a(this.dG(), f3, f1));
        this.t(this.a(this.dE(), f22, f2));
    }

    private float a(float f2, float f1, float f22) {
        float f3 = MathHelper.g(f1 - f2);
        if (f3 > f22) {
            f3 = f22;
        }
        if (f3 < -f22) {
            f3 = -f22;
        }
        return f2 + f3;
    }

    public static boolean a(EntityTypes<? extends EntityInsentient> entitytypes, GeneratorAccess generatoraccess, EnumMobSpawn enummobspawn, BlockPosition blockposition, RandomSource randomsource) {
        BlockPosition blockposition1 = blockposition.e();
        return enummobspawn == EnumMobSpawn.c || generatoraccess.a_(blockposition1).a((IBlockAccess)generatoraccess, blockposition1, entitytypes);
    }

    public boolean a(GeneratorAccess generatoraccess, EnumMobSpawn enummobspawn) {
        return true;
    }

    public boolean a(IWorldReader iworldreader) {
        return !iworldreader.d(this.cK()) && iworldreader.f(this);
    }

    public int fN() {
        return 4;
    }

    public boolean r(int i2) {
        return false;
    }

    @Override
    public int cx() {
        if (this.p() == null) {
            return this.w(0.0f);
        }
        int i2 = (int)(this.ew() - this.eN() * 0.33f);
        if ((i2 -= (3 - this.dO().al().a()) * 4) < 0) {
            i2 = 0;
        }
        return this.w(i2);
    }

    @Override
    public Iterable<ItemStack> eW() {
        return this.cg;
    }

    @Override
    public Iterable<ItemStack> eV() {
        return this.ch;
    }

    public ItemStack fO() {
        return this.ci;
    }

    @Override
    public boolean d(EnumItemSlot enumitemslot) {
        return enumitemslot != EnumItemSlot.g;
    }

    public boolean fP() {
        return !this.a(EnumItemSlot.g).e();
    }

    public boolean l(ItemStack itemstack) {
        return false;
    }

    public void m(ItemStack itemstack) {
        this.b(EnumItemSlot.g, itemstack);
    }

    @Override
    public Iterable<ItemStack> eX() {
        return this.ci.e() ? this.ch : Iterables.concat(this.ch, List.of(this.ci));
    }

    @Override
    public ItemStack a(EnumItemSlot enumitemslot) {
        return switch (enumitemslot.a()) {
            case EnumItemSlot.Function.a -> this.cg.get(enumitemslot.b());
            case EnumItemSlot.Function.b -> this.ch.get(enumitemslot.b());
            case EnumItemSlot.Function.c -> this.ci;
            default -> throw new MatchException(null, null);
        };
    }

    @Override
    public void a(EnumItemSlot enumitemslot, ItemStack itemstack) {
        this.e(itemstack);
        switch (enumitemslot.a()) {
            case a: {
                this.a(enumitemslot, this.cg.set(enumitemslot.b(), itemstack), itemstack);
                break;
            }
            case b: {
                this.a(enumitemslot, this.ch.set(enumitemslot.b(), itemstack), itemstack);
                break;
            }
            case c: {
                ItemStack itemstack1 = this.ci;
                this.ci = itemstack;
                this.a(enumitemslot, itemstack1, itemstack);
            }
        }
    }

    @Override
    protected void a(WorldServer worldserver, DamageSource damagesource, boolean flag) {
        super.a(worldserver, damagesource, flag);
        for (EnumItemSlot enumitemslot : EnumItemSlot.values()) {
            ItemStack itemstack = this.a(enumitemslot);
            float f2 = this.f(enumitemslot);
            if (f2 == 0.0f) continue;
            boolean flag1 = f2 > 1.0f;
            Entity entity = damagesource.d();
            if (entity instanceof EntityLiving) {
                EntityLiving entityliving = (EntityLiving)entity;
                World world = this.dO();
                if (world instanceof WorldServer) {
                    WorldServer worldserver1 = (WorldServer)world;
                    f2 = EnchantmentManager.a(worldserver1, entityliving, damagesource, f2);
                }
            }
            if (itemstack.e() || EnchantmentManager.a(itemstack, EnchantmentEffectComponents.D) || !flag && !flag1 || !(this.ah.i() < f2)) continue;
            if (!flag1 && itemstack.l()) {
                itemstack.b(itemstack.o() - this.ah.a(1 + this.ah.a(Math.max(itemstack.o() - 3, 1))));
            }
            this.b(itemstack);
            this.a(enumitemslot, ItemStack.l);
        }
    }

    protected float f(EnumItemSlot enumitemslot) {
        return switch (enumitemslot.a()) {
            case EnumItemSlot.Function.a -> this.bY[enumitemslot.b()];
            case EnumItemSlot.Function.b -> this.bZ[enumitemslot.b()];
            case EnumItemSlot.Function.c -> this.ca;
            default -> throw new MatchException(null, null);
        };
    }

    public void fQ() {
        this.c((ItemStack itemstack) -> true);
    }

    public Set<EnumItemSlot> c(Predicate<ItemStack> predicate) {
        HashSet<EnumItemSlot> set = new HashSet<EnumItemSlot>();
        for (EnumItemSlot enumitemslot : EnumItemSlot.values()) {
            ItemStack itemstack = this.a(enumitemslot);
            if (itemstack.e()) continue;
            if (!predicate.test(itemstack)) {
                set.add(enumitemslot);
                continue;
            }
            double d0 = this.f(enumitemslot);
            if (!(d0 > 1.0)) continue;
            this.a(enumitemslot, ItemStack.l);
            this.b(itemstack);
        }
        return set;
    }

    private LootParams a(WorldServer worldserver) {
        return new LootParams.a(worldserver).a(LootContextParameters.f, this.dm()).a(LootContextParameters.a, this).a(LootContextParameterSets.h);
    }

    public void a(EquipmentTable equipmenttable) {
        this.a(equipmenttable.a(), equipmenttable.b());
    }

    public void a(ResourceKey<LootTable> resourcekey, Map<EnumItemSlot, Float> map) {
        World world = this.dO();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            this.a(resourcekey, this.a(worldserver), map);
        }
    }

    protected void a(RandomSource randomsource, DifficultyDamageScaler difficultydamagescaler) {
        if (randomsource.i() < 0.15f * difficultydamagescaler.d()) {
            float f2;
            int i2 = randomsource.a(2);
            float f3 = f2 = this.dO().al() == EnumDifficulty.d ? 0.1f : 0.25f;
            if (randomsource.i() < 0.095f) {
                ++i2;
            }
            if (randomsource.i() < 0.095f) {
                ++i2;
            }
            if (randomsource.i() < 0.095f) {
                ++i2;
            }
            boolean flag = true;
            for (EnumItemSlot enumitemslot : EnumItemSlot.values()) {
                Item item;
                if (enumitemslot.a() != EnumItemSlot.Function.b) continue;
                ItemStack itemstack = this.a(enumitemslot);
                if (!flag && randomsource.i() < f2) break;
                flag = false;
                if (!itemstack.e() || (item = EntityInsentient.a(enumitemslot, i2)) == null) continue;
                this.a(enumitemslot, new ItemStack(item));
            }
        }
    }

    @Nullable
    public static Item a(EnumItemSlot enumitemslot, int i2) {
        switch (enumitemslot) {
            case f: {
                if (i2 == 0) {
                    return Items.py;
                }
                if (i2 == 1) {
                    return Items.pO;
                }
                if (i2 == 2) {
                    return Items.pC;
                }
                if (i2 == 3) {
                    return Items.pG;
                }
                if (i2 == 4) {
                    return Items.pK;
                }
            }
            case e: {
                if (i2 == 0) {
                    return Items.pz;
                }
                if (i2 == 1) {
                    return Items.pP;
                }
                if (i2 == 2) {
                    return Items.pD;
                }
                if (i2 == 3) {
                    return Items.pH;
                }
                if (i2 == 4) {
                    return Items.pL;
                }
            }
            case d: {
                if (i2 == 0) {
                    return Items.pA;
                }
                if (i2 == 1) {
                    return Items.pQ;
                }
                if (i2 == 2) {
                    return Items.pE;
                }
                if (i2 == 3) {
                    return Items.pI;
                }
                if (i2 == 4) {
                    return Items.pM;
                }
            }
            case c: {
                if (i2 == 0) {
                    return Items.pB;
                }
                if (i2 == 1) {
                    return Items.pR;
                }
                if (i2 == 2) {
                    return Items.pF;
                }
                if (i2 == 3) {
                    return Items.pJ;
                }
                if (i2 != 4) break;
                return Items.pN;
            }
        }
        return null;
    }

    protected void a(WorldAccess worldaccess, RandomSource randomsource, DifficultyDamageScaler difficultydamagescaler) {
        this.b(worldaccess, randomsource, difficultydamagescaler);
        for (EnumItemSlot enumitemslot : EnumItemSlot.values()) {
            if (enumitemslot.a() != EnumItemSlot.Function.b) continue;
            this.a(worldaccess, randomsource, enumitemslot, difficultydamagescaler);
        }
    }

    protected void b(WorldAccess worldaccess, RandomSource randomsource, DifficultyDamageScaler difficultydamagescaler) {
        this.a(worldaccess, EnumItemSlot.a, randomsource, 0.25f, difficultydamagescaler);
    }

    protected void a(WorldAccess worldaccess, RandomSource randomsource, EnumItemSlot enumitemslot, DifficultyDamageScaler difficultydamagescaler) {
        this.a(worldaccess, enumitemslot, randomsource, 0.5f, difficultydamagescaler);
    }

    private void a(WorldAccess worldaccess, EnumItemSlot enumitemslot, RandomSource randomsource, float f2, DifficultyDamageScaler difficultydamagescaler) {
        ItemStack itemstack = this.a(enumitemslot);
        if (!itemstack.e() && randomsource.i() < f2 * difficultydamagescaler.d()) {
            EnchantmentManager.a(itemstack, worldaccess.H_(), VanillaEnchantmentProviders.a, difficultydamagescaler, randomsource);
            this.a(enumitemslot, itemstack);
        }
    }

    @Nullable
    public GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EnumMobSpawn enummobspawn, @Nullable GroupDataEntity groupdataentity) {
        RandomSource randomsource = worldaccess.E_();
        AttributeModifiable attributemodifiable = Objects.requireNonNull(this.f(GenericAttributes.m));
        if (!attributemodifiable.b(bP)) {
            attributemodifiable.d(new AttributeModifier(bP, randomsource.a(0.0, 0.11485000000000001), AttributeModifier.Operation.b));
        }
        this.v(randomsource.i() < 0.05f);
        return groupdataentity;
    }

    public void fR() {
        this.ck = true;
    }

    @Override
    public void a(EnumItemSlot enumitemslot, float f2) {
        switch (enumitemslot.a()) {
            case a: {
                this.bY[enumitemslot.b()] = f2;
                break;
            }
            case b: {
                this.bZ[enumitemslot.b()] = f2;
                break;
            }
            case c: {
                this.ca = f2;
            }
        }
    }

    public boolean fS() {
        return this.cj;
    }

    public void a_(boolean flag) {
        this.cj = flag;
    }

    @Override
    public boolean f(ItemStack itemstack) {
        EnumItemSlot enumitemslot = this.h(itemstack);
        return this.a(enumitemslot).e() && this.fS();
    }

    public boolean fT() {
        return this.ck;
    }

    @Override
    public final EnumInteractionResult a(EntityHuman entityhuman, EnumHand enumhand) {
        if (!this.bE()) {
            return EnumInteractionResult.e;
        }
        EnumInteractionResult enuminteractionresult = this.c(entityhuman, enumhand);
        if (enuminteractionresult.a()) {
            this.a(GameEvent.r, (Entity)entityhuman);
            return enuminteractionresult;
        }
        EnumInteractionResult enuminteractionresult1 = super.a(entityhuman, enumhand);
        if (enuminteractionresult1 != EnumInteractionResult.e) {
            return enuminteractionresult1;
        }
        enuminteractionresult = this.b(entityhuman, enumhand);
        if (enuminteractionresult.a()) {
            this.a(GameEvent.r, (Entity)entityhuman);
            return enuminteractionresult;
        }
        return EnumInteractionResult.e;
    }

    private EnumInteractionResult c(EntityHuman entityhuman, EnumHand enumhand) {
        EnumInteractionResult enuminteractionresult;
        ItemStack itemstack = entityhuman.b(enumhand);
        if (itemstack.a(Items.uL) && (enuminteractionresult = itemstack.a(entityhuman, (EntityLiving)this, enumhand)).a()) {
            return enuminteractionresult;
        }
        if (itemstack.g() instanceof ItemMonsterEgg) {
            if (this.dO() instanceof WorldServer) {
                ItemMonsterEgg itemmonsteregg = (ItemMonsterEgg)itemstack.g();
                Optional<EntityInsentient> optional = itemmonsteregg.a(entityhuman, this, this.am(), (WorldServer)this.dO(), this.dm(), itemstack);
                optional.ifPresent(entityinsentient -> this.a(entityhuman, (EntityInsentient)entityinsentient));
                return optional.isPresent() ? EnumInteractionResult.a : EnumInteractionResult.e;
            }
            return EnumInteractionResult.c;
        }
        return EnumInteractionResult.e;
    }

    protected void a(EntityHuman entityhuman, EntityInsentient entityinsentient) {
    }

    protected EnumInteractionResult b(EntityHuman entityhuman, EnumHand enumhand) {
        return EnumInteractionResult.e;
    }

    public boolean fU() {
        return this.a(this.do());
    }

    public boolean a(BlockPosition blockposition) {
        return this.cq == -1.0f ? true : this.cp.j(blockposition) < (double)(this.cq * this.cq);
    }

    public void a(BlockPosition blockposition, int i2) {
        this.cp = blockposition;
        this.cq = i2;
    }

    public BlockPosition fV() {
        return this.cp;
    }

    public float fW() {
        return this.cq;
    }

    public void fX() {
        this.cq = -1.0f;
    }

    public boolean fY() {
        return this.cq != -1.0f;
    }

    @Nullable
    public <T extends EntityInsentient> T a(EntityTypes<T> entitytypes, boolean flag) {
        return this.convertTo(entitytypes, flag, EntityTransformEvent.TransformReason.UNKNOWN, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    @Nullable
    public <T extends EntityInsentient> T convertTo(EntityTypes<T> entitytypes, boolean flag, EntityTransformEvent.TransformReason transformReason, CreatureSpawnEvent.SpawnReason spawnReason) {
        if (this.dJ()) {
            return null;
        }
        EntityInsentient t0 = (EntityInsentient)entitytypes.a(this.dO());
        if (t0 == null) {
            return null;
        }
        t0.v(this);
        t0.a(this.o_());
        t0.u(this.fZ());
        if (this.ai()) {
            t0.b(this.aj());
            t0.p(this.cE());
        }
        if (this.fT()) {
            t0.fR();
        }
        t0.n(this.cv());
        if (flag) {
            t0.a_(this.fS());
            for (EnumItemSlot enumitemslot : EnumItemSlot.values()) {
                ItemStack itemstack = this.a(enumitemslot);
                if (itemstack.e()) continue;
                t0.a(enumitemslot, itemstack.f());
                t0.a(enumitemslot, this.f(enumitemslot));
            }
        }
        if (CraftEventFactory.callEntityTransformEvent((EntityLiving)this, t0, transformReason).isCancelled()) {
            return null;
        }
        this.dO().addFreshEntity(t0, spawnReason);
        if (this.bS()) {
            Entity entity = this.dc();
            this.ad();
            t0.a(entity, true);
        }
        this.discard(EntityRemoveEvent.Cause.TRANSFORMATION);
        return (T)t0;
    }

    @Override
    @Nullable
    public Leashable.a X_() {
        return this.co;
    }

    @Override
    public void a(@Nullable Leashable.a leashable_a) {
        this.co = leashable_a;
    }

    @Override
    public void a(boolean flag, boolean flag1) {
        Leashable.super.a(flag, flag1);
        if (this.X_() == null) {
            this.fX();
        }
    }

    @Override
    public void z() {
        Leashable.super.z();
        this.bW.a(PathfinderGoal.Type.a);
    }

    @Override
    public boolean y() {
        return !(this instanceof IMonster);
    }

    @Override
    public boolean a(Entity entity, boolean flag) {
        boolean flag1 = super.a(entity, flag);
        if (flag1 && this.N_()) {
            this.dO().getCraftServer().getPluginManager().callEvent((Event)new EntityUnleashEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), EntityUnleashEvent.UnleashReason.UNKNOWN));
            this.a(true, true);
        }
        return flag1;
    }

    @Override
    public boolean db() {
        return super.db() && !this.fZ();
    }

    public void u(boolean flag) {
        byte b0 = this.ao.a(b);
        this.ao.a(b, flag ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE));
    }

    public void v(boolean flag) {
        byte b0 = this.ao.a(b);
        this.ao.a(b, flag ? (byte)(b0 | 2) : (byte)(b0 & 0xFFFFFFFD));
    }

    public void w(boolean flag) {
        byte b0 = this.ao.a(b);
        this.ao.a(b, flag ? (byte)(b0 | 4) : (byte)(b0 & 0xFFFFFFFB));
    }

    public boolean fZ() {
        return (this.ao.a(b) & 1) != 0;
    }

    public boolean ga() {
        return (this.ao.a(b) & 2) != 0;
    }

    public boolean gb() {
        return (this.ao.a(b) & 4) != 0;
    }

    public void a(boolean flag) {
    }

    @Override
    public EnumMainHand fq() {
        return this.ga() ? EnumMainHand.a : EnumMainHand.b;
    }

    public boolean i(EntityLiving entityliving) {
        return this.gc().c(entityliving.eF());
    }

    protected AxisAlignedBB gc() {
        AxisAlignedBB axisalignedbb;
        Entity entity = this.dc();
        if (entity != null) {
            AxisAlignedBB axisalignedbb1 = entity.cK();
            AxisAlignedBB axisalignedbb2 = this.cK();
            axisalignedbb = new AxisAlignedBB(Math.min(axisalignedbb2.a, axisalignedbb1.a), axisalignedbb2.b, Math.min(axisalignedbb2.c, axisalignedbb1.c), Math.max(axisalignedbb2.d, axisalignedbb1.d), axisalignedbb2.e, Math.max(axisalignedbb2.f, axisalignedbb1.f));
        } else {
            axisalignedbb = this.cK();
        }
        return axisalignedbb.c(cc, 0.0, cc);
    }

    @Override
    public boolean D(Entity entity) {
        boolean flag;
        float f2 = (float)this.g(GenericAttributes.c);
        DamageSource damagesource = this.dP().b(this);
        World world = this.dO();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            f2 = EnchantmentManager.a(worldserver, this.dS(), entity, damagesource, f2);
        }
        if (flag = entity.a(damagesource, f2)) {
            World world1;
            float f1 = this.a(entity, damagesource);
            if (f1 > 0.0f && entity instanceof EntityLiving) {
                EntityLiving entityliving = (EntityLiving)entity;
                entityliving.knockback(f1 * 0.5f, MathHelper.a(this.dE() * ((float)Math.PI / 180)), -MathHelper.b(this.dE() * ((float)Math.PI / 180)), this, EntityKnockbackEvent.KnockbackCause.ENTITY_ATTACK);
                this.i(this.dr().d(0.6, 1.0, 0.6));
            }
            if ((world1 = this.dO()) instanceof WorldServer) {
                WorldServer worldserver1 = (WorldServer)world1;
                EnchantmentManager.a(worldserver1, entity, damagesource);
            }
            this.A(entity);
            this.gd();
        }
        return flag;
    }

    protected void gd() {
    }

    protected boolean ge() {
        if (this.dO().R() && !this.dO().B) {
            boolean flag;
            float f2 = this.bu();
            BlockPosition blockposition = BlockPosition.a(this.dt(), this.dx(), this.dz());
            boolean bl = flag = this.bh() || this.az || this.aA;
            if (f2 > 0.5f && this.ah.i() * 30.0f < (f2 - 0.4f) * 2.0f && !flag && this.dO().h(blockposition)) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void c(TagKey<FluidType> tagkey) {
        if (this.N().p()) {
            super.c(tagkey);
        } else {
            this.i(this.dr().b(0.0, 0.3, 0.0));
        }
    }

    @VisibleForTesting
    public void gf() {
        this.d((PathfinderGoal pathfindergoal) -> true);
        this.dT().h();
    }

    public void d(Predicate<PathfinderGoal> predicate) {
        this.bW.a(predicate);
    }

    @Override
    protected void cw() {
        super.cw();
        this.eY().forEach(itemstack -> {
            if (!itemstack.e()) {
                itemstack.e(0);
            }
        });
    }

    @Override
    @Nullable
    public ItemStack dB() {
        ItemMonsterEgg itemmonsteregg = ItemMonsterEgg.a(this.am());
        return itemmonsteregg == null ? null : new ItemStack(itemmonsteregg);
    }
}

