/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockLightAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.PathType;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityBreedEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityEnterLoveModeEvent;

public abstract class EntityAnimal
extends EntityAgeable {
    protected static final int cf = 6000;
    public int cc;
    @Nullable
    public UUID cd;
    public ItemStack breedItem;

    protected EntityAnimal(EntityTypes<? extends EntityAnimal> entitytypes, World world) {
        super((EntityTypes<? extends EntityAgeable>)entitytypes, world);
        this.a(PathType.n, 16.0f);
        this.a(PathType.o, -1.0f);
    }

    @Override
    protected void ab() {
        if (this.g() != 0) {
            this.cc = 0;
        }
        super.ab();
    }

    @Override
    public void m_() {
        super.m_();
        if (this.g() != 0) {
            this.cc = 0;
        }
        if (this.cc > 0) {
            --this.cc;
            if (this.cc % 10 == 0) {
                double d0 = this.ah.k() * 0.02;
                double d1 = this.ah.k() * 0.02;
                double d2 = this.ah.k() * 0.02;
                this.dO().a(Particles.Q, this.d(1.0), this.dw() + 0.5, this.g(1.0), d0, d1, d2);
            }
        }
    }

    @Override
    public boolean actuallyHurt(DamageSource damagesource, float f2, EntityDamageEvent event) {
        boolean damageResult = super.actuallyHurt(damagesource, f2, event);
        if (!damageResult) {
            return false;
        }
        this.gt();
        return true;
    }

    @Override
    public float a(BlockPosition blockposition, IWorldReader iworldreader) {
        return iworldreader.a_(blockposition.e()).a(Blocks.i) ? 10.0f : iworldreader.w(blockposition);
    }

    @Override
    public void b(NBTTagCompound nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("InLove", this.cc);
        if (this.cd != null) {
            nbttagcompound.a("LoveCause", this.cd);
        }
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        super.a(nbttagcompound);
        this.cc = nbttagcompound.h("InLove");
        this.cd = nbttagcompound.b("LoveCause") ? nbttagcompound.a("LoveCause") : null;
    }

    public static boolean b(EntityTypes<? extends EntityAnimal> entitytypes, GeneratorAccess generatoraccess, EnumMobSpawn enummobspawn, BlockPosition blockposition, RandomSource randomsource) {
        boolean flag = EnumMobSpawn.b(enummobspawn) || EntityAnimal.a(generatoraccess, blockposition);
        return generatoraccess.a_(blockposition.e()).a(TagsBlock.bX) && flag;
    }

    protected static boolean a(IBlockLightAccess iblocklightaccess, BlockPosition blockposition) {
        return iblocklightaccess.b(blockposition, 0) > 8;
    }

    @Override
    public int R() {
        return 120;
    }

    @Override
    public boolean h(double d0) {
        return false;
    }

    @Override
    protected int eg() {
        return 1 + this.dO().z.a(3);
    }

    public abstract boolean o(ItemStack var1);

    @Override
    public EnumInteractionResult b(EntityHuman entityhuman, EnumHand enumhand) {
        ItemStack itemstack = entityhuman.b(enumhand);
        if (this.o(itemstack)) {
            int i2 = this.g();
            if (!this.dO().B && i2 == 0 && this.gp()) {
                this.a(entityhuman, enumhand, itemstack);
                this.f(entityhuman);
                return EnumInteractionResult.a;
            }
            if (this.o_()) {
                this.a(entityhuman, enumhand, itemstack);
                this.a(EntityAnimal.d_(-i2), true);
                return EnumInteractionResult.a(this.dO().B);
            }
            if (this.dO().B) {
                return EnumInteractionResult.c;
            }
        }
        return super.b(entityhuman, enumhand);
    }

    protected void a(EntityHuman entityhuman, EnumHand enumhand, ItemStack itemstack) {
        itemstack.a(1, (EntityLiving)entityhuman);
    }

    public boolean gp() {
        return this.cc <= 0;
    }

    public void f(@Nullable EntityHuman entityhuman) {
        EntityEnterLoveModeEvent entityEnterLoveModeEvent = CraftEventFactory.callEntityEnterLoveModeEvent(entityhuman, this, 600);
        if (entityEnterLoveModeEvent.isCancelled()) {
            return;
        }
        this.cc = entityEnterLoveModeEvent.getTicksInLove();
        if (entityhuman != null) {
            this.cd = entityhuman.cz();
        }
        this.breedItem = entityhuman.fY().f();
        this.dO().a((Entity)this, (byte)18);
    }

    public void s(int i2) {
        this.cc = i2;
    }

    public int gq() {
        return this.cc;
    }

    @Nullable
    public EntityPlayer gr() {
        if (this.cd == null) {
            return null;
        }
        EntityHuman entityhuman = this.dO().b(this.cd);
        return entityhuman instanceof EntityPlayer ? (EntityPlayer)entityhuman : null;
    }

    public boolean gs() {
        return this.cc > 0;
    }

    public void gt() {
        this.cc = 0;
    }

    public boolean a(EntityAnimal entityanimal) {
        return entityanimal == this ? false : (entityanimal.getClass() != this.getClass() ? false : this.gs() && entityanimal.gs());
    }

    public void a(WorldServer worldserver, EntityAnimal entityanimal) {
        EntityAgeable entityageable = this.a(worldserver, (EntityAgeable)entityanimal);
        if (entityageable != null) {
            entityageable.a(true);
            entityageable.b(this.dt(), this.dv(), this.dz(), 0.0f, 0.0f);
            EntityPlayer breeder = Optional.ofNullable(this.gr()).or(() -> Optional.ofNullable(entityanimal.gr())).orElse(null);
            int experience = this.dR().a(7) + 1;
            EntityBreedEvent entityBreedEvent = CraftEventFactory.callEntityBreedEvent(entityageable, this, entityanimal, breeder, this.breedItem, experience);
            if (entityBreedEvent.isCancelled()) {
                return;
            }
            experience = entityBreedEvent.getExperience();
            this.finalizeSpawnChildFromBreeding(worldserver, entityanimal, entityageable, experience);
            worldserver.addFreshEntityWithPassengers(entityageable, CreatureSpawnEvent.SpawnReason.BREEDING);
        }
    }

    public void a(WorldServer worldserver, EntityAnimal entityanimal, @Nullable EntityAgeable entityageable) {
        this.finalizeSpawnChildFromBreeding(worldserver, entityanimal, entityageable, this.dR().a(7) + 1);
    }

    public void finalizeSpawnChildFromBreeding(WorldServer worldserver, EntityAnimal entityanimal, @Nullable EntityAgeable entityageable, int experience) {
        Optional.ofNullable(this.gr()).or(() -> Optional.ofNullable(entityanimal.gr())).ifPresent(entityplayer -> {
            entityplayer.a(StatisticList.P);
            CriterionTriggers.p.a((EntityPlayer)entityplayer, this, entityanimal, entityageable);
        });
        this.c_(6000);
        entityanimal.c_(6000);
        this.gt();
        entityanimal.gt();
        worldserver.a((Entity)this, (byte)18);
        if (worldserver.ab().b(GameRules.f) && experience > 0) {
            worldserver.b(new EntityExperienceOrb(worldserver, this.dt(), this.dv(), this.dz(), experience));
        }
    }

    @Override
    public void b(byte b0) {
        if (b0 == 18) {
            for (int i2 = 0; i2 < 7; ++i2) {
                double d0 = this.ah.k() * 0.02;
                double d1 = this.ah.k() * 0.02;
                double d2 = this.ah.k() * 0.02;
                this.dO().a(Particles.Q, this.d(1.0), this.dw() + 0.5, this.g(1.0), d0, d1, d2);
            }
        } else {
            super.b(b0);
        }
    }
}

