/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.google.common.collect.Lists;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.PoiTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.TimeRange;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.ControllerMoveFlying;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSelector;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalUniversalAngerReset;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.navigation.NavigationFlying;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.entity.ai.util.AirRandomPos;
import net.minecraft.world.entity.ai.util.HoverRandomPos;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceRecord;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityBird;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockCrops;
import net.minecraft.world.level.block.BlockStem;
import net.minecraft.world.level.block.BlockSweetBerryBush;
import net.minecraft.world.level.block.BlockTallPlant;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityBeehive;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyDoubleBlockHalf;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityTargetEvent;

public class EntityBee
extends EntityAnimal
implements IEntityAngerable,
EntityBird {
    public static final float cc = 120.32113f;
    public static final int cd = MathHelper.f(1.4959966f);
    private static final DataWatcherObject<Byte> cm = DataWatcher.a(EntityBee.class, DataWatcherRegistry.a);
    private static final DataWatcherObject<Integer> cn = DataWatcher.a(EntityBee.class, DataWatcherRegistry.b);
    private static final int co = 2;
    private static final int cp = 4;
    private static final int cq = 8;
    private static final int cr = 1200;
    private static final int cs = 2400;
    private static final int ct = 3600;
    private static final int cu = 4;
    private static final int cv = 10;
    private static final int cw = 10;
    private static final int cx = 18;
    private static final int cy = 32;
    private static final int cz = 2;
    private static final int cA = 16;
    private static final int cB = 20;
    public static final String ce = "CropsGrownSincePollination";
    public static final String cg = "CannotEnterHiveTicks";
    public static final String ch = "TicksSincePollination";
    public static final String ci = "HasStung";
    public static final String cj = "HasNectar";
    public static final String ck = "flower_pos";
    public static final String cl = "hive_pos";
    private static final UniformInt cD = TimeRange.a(20, 39);
    @Nullable
    private UUID cE;
    private float cF;
    private float cG;
    private int cH;
    int cI;
    public int cJ;
    private int cK;
    private static final int cL = 200;
    int cM;
    private static final int cN = 200;
    int cO;
    @Nullable
    BlockPosition cP;
    @Nullable
    public BlockPosition cQ;
    k cR;
    e cS;
    private f cT;
    private int cU;

    public EntityBee(EntityTypes<? extends EntityBee> entitytypes, World world) {
        super((EntityTypes<? extends EntityAnimal>)entitytypes, world);
        this.cO = MathHelper.a(this.ah, 20, 60);
        this.bT = new ControllerMoveFlying(this, 20, true);
        this.bS = new j(this);
        this.a(PathType.n, -1.0f);
        this.a(PathType.j, -1.0f);
        this.a(PathType.k, 16.0f);
        this.a(PathType.x, -1.0f);
        this.a(PathType.h, -1.0f);
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(cm, (byte)0);
        datawatcher_a.a(cn, 0);
    }

    @Override
    public float a(BlockPosition blockposition, IWorldReader iworldreader) {
        return iworldreader.a_(blockposition).i() ? 10.0f : 0.0f;
    }

    @Override
    protected void B() {
        this.bW.a(0, new b(this, 1.4f, true));
        this.bW.a(1, new d());
        this.bW.a(2, new PathfinderGoalBreed(this, 1.0));
        this.bW.a(3, new PathfinderGoalTempt(this, 1.25, itemstack -> itemstack.a(TagsItem.aj), false));
        this.cR = new k();
        this.bW.a(4, this.cR);
        this.bW.a(5, new PathfinderGoalFollowParent(this, 1.25));
        this.bW.a(5, new i());
        this.cS = new e();
        this.bW.a(5, this.cS);
        this.cT = new f();
        this.bW.a(6, this.cT);
        this.bW.a(7, new g());
        this.bW.a(8, new l());
        this.bW.a(9, new PathfinderGoalFloat(this));
        this.bX.a(1, new h(this).a(new Class[0]));
        this.bX.a(2, new c(this));
        this.bX.a(3, new PathfinderGoalUniversalAngerReset<EntityBee>(this, true));
    }

    @Override
    public void b(NBTTagCompound nbttagcompound) {
        this.addAdditionalSaveData(nbttagcompound, true);
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound nbttagcompound, boolean includeAll) {
        super.b(nbttagcompound);
        if (includeAll && this.gm()) {
            nbttagcompound.a(cl, GameProfileSerializer.a(this.gn()));
        }
        if (includeAll && this.t()) {
            nbttagcompound.a(ck, GameProfileSerializer.a(this.s()));
        }
        nbttagcompound.a(cj, this.gu());
        nbttagcompound.a(ci, this.gv());
        nbttagcompound.a(ch, this.cI);
        nbttagcompound.a(cg, this.cJ);
        nbttagcompound.a(ce, this.cK);
        this.a_(nbttagcompound);
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        this.cQ = GameProfileSerializer.a(nbttagcompound, cl).orElse(null);
        this.cP = GameProfileSerializer.a(nbttagcompound, ck).orElse(null);
        super.a(nbttagcompound);
        this.x(nbttagcompound.q(cj));
        this.y(nbttagcompound.q(ci));
        this.cI = nbttagcompound.h(ch);
        this.cJ = nbttagcompound.h(cg);
        this.cK = nbttagcompound.h(ce);
        this.a(this.dO(), nbttagcompound);
    }

    @Override
    public boolean D(Entity entity) {
        DamageSource damagesource = this.dP().a(this);
        boolean flag = entity.a(damagesource, (float)((int)this.g(GenericAttributes.c)));
        if (flag) {
            World world = this.dO();
            if (world instanceof WorldServer) {
                WorldServer worldserver = (WorldServer)world;
                EnchantmentManager.a(worldserver, entity, damagesource);
            }
            if (entity instanceof EntityLiving) {
                EntityLiving entityliving = (EntityLiving)entity;
                entityliving.q(entityliving.eQ() + 1);
                int b0 = 0;
                if (this.dO().al() == EnumDifficulty.c) {
                    b0 = 10;
                } else if (this.dO().al() == EnumDifficulty.d) {
                    b0 = 18;
                }
                if (b0 > 0) {
                    entityliving.addEffect(new MobEffect(MobEffects.s, b0 * 20, 0), this, EntityPotionEffectEvent.Cause.ATTACK);
                }
            }
            this.y(true);
            this.Z_();
            this.a(SoundEffects.bS, 1.0f, 1.0f);
        }
        return flag;
    }

    @Override
    public void l() {
        super.l();
        if (this.gu() && this.gD() < 10 && this.ah.i() < 0.05f) {
            for (int i2 = 0; i2 < this.ah.a(2) + 1; ++i2) {
                this.a(this.dO(), this.dt() - (double)0.3f, this.dt() + (double)0.3f, this.dz() - (double)0.3f, this.dz() + (double)0.3f, this.e(0.5), Particles.ay);
            }
        }
        this.gB();
    }

    private void a(World world, double d0, double d1, double d2, double d3, double d4, ParticleParam particleparam) {
        world.a(particleparam, MathHelper.d(world.z.j(), d0, d1), d4, MathHelper.d(world.z.j(), d2, d3), 0.0, 0.0, 0.0);
    }

    void j(BlockPosition blockposition) {
        Vec3D vec3d1;
        Vec3D vec3d = Vec3D.c(blockposition);
        int b0 = 0;
        BlockPosition blockposition1 = this.do();
        int i2 = (int)vec3d.d - blockposition1.v();
        if (i2 > 2) {
            b0 = 4;
        } else if (i2 < -2) {
            b0 = -4;
        }
        int j2 = 6;
        int k2 = 8;
        int l2 = blockposition1.k(blockposition);
        if (l2 < 15) {
            j2 = l2 / 2;
            k2 = l2 / 2;
        }
        if ((vec3d1 = AirRandomPos.a(this, j2, k2, b0, vec3d, 0.3141592741012573)) != null) {
            this.bV.a(0.5f);
            this.bV.a(vec3d1.c, vec3d1.d, vec3d1.e, 1.0);
        }
    }

    @Nullable
    public BlockPosition s() {
        return this.cP;
    }

    public boolean t() {
        return this.cP != null;
    }

    public void h(BlockPosition blockposition) {
        this.cP = blockposition;
    }

    @VisibleForDebug
    public int x() {
        return Math.max(this.cS.d, this.cT.d);
    }

    @VisibleForDebug
    public List<BlockPosition> gk() {
        return this.cS.f;
    }

    private boolean gz() {
        return this.cI > 3600;
    }

    boolean gA() {
        if (this.cJ <= 0 && !this.cR.l() && !this.gv() && this.p() == null) {
            boolean flag = this.gz() || this.dO().ad() || this.dO().S() || this.gu();
            return flag && !this.gC();
        }
        return false;
    }

    public void t(int i2) {
        this.cJ = i2;
    }

    public float H(float f2) {
        return MathHelper.i(f2, this.cG, this.cF);
    }

    private void gB() {
        this.cG = this.cF;
        this.cF = this.gH() ? Math.min(1.0f, this.cF + 0.2f) : Math.max(0.0f, this.cF - 0.24f);
    }

    @Override
    protected void ab() {
        boolean flag = this.gv();
        this.cU = this.bi() ? ++this.cU : 0;
        if (this.cU > 20) {
            this.a(this.dP().i(), 1.0f);
        }
        if (flag) {
            ++this.cH;
            if (this.cH % 5 == 0 && this.ah.a(MathHelper.a(1200 - this.cH, 1, 1200)) == 0) {
                this.a(this.dP().o(), this.ew());
            }
        }
        if (!this.gu()) {
            ++this.cI;
        }
        if (!this.dO().B) {
            this.a((WorldServer)this.dO(), false);
        }
    }

    public void gl() {
        this.cI = 0;
    }

    private boolean gC() {
        if (this.cQ == null) {
            return false;
        }
        TileEntity tileentity = this.dO().c_(this.cQ);
        return tileentity instanceof TileEntityBeehive && ((TileEntityBeehive)tileentity).b();
    }

    @Override
    public int a() {
        return this.ao.a(cn);
    }

    @Override
    public void a(int i2) {
        this.ao.a(cn, i2);
    }

    @Override
    @Nullable
    public UUID b() {
        return this.cE;
    }

    @Override
    public void a(@Nullable UUID uuid) {
        this.cE = uuid;
    }

    @Override
    public void c() {
        this.a(cD.a(this.ah));
    }

    private boolean k(BlockPosition blockposition) {
        TileEntity tileentity = this.dO().c_(blockposition);
        return tileentity instanceof TileEntityBeehive ? !((TileEntityBeehive)tileentity).d() : false;
    }

    @VisibleForDebug
    public boolean gm() {
        return this.cQ != null;
    }

    @Nullable
    @VisibleForDebug
    public BlockPosition gn() {
        return this.cQ;
    }

    @VisibleForDebug
    public PathfinderGoalSelector go() {
        return this.bW;
    }

    @Override
    protected void aa() {
        super.aa();
        PacketDebug.a(this);
    }

    int gD() {
        return this.cK;
    }

    private void gE() {
        this.cK = 0;
    }

    void gF() {
        ++this.cK;
    }

    @Override
    public void m_() {
        super.m_();
        if (!this.dO().B) {
            if (this.cJ > 0) {
                --this.cJ;
            }
            if (this.cM > 0) {
                --this.cM;
            }
            if (this.cO > 0) {
                --this.cO;
            }
            boolean flag = this.ad_() && !this.gv() && this.p() != null && this.p().g((Entity)this) < 4.0;
            this.z(flag);
            if (this.ai % 20 == 0 && !this.gG()) {
                this.cQ = null;
            }
        }
    }

    boolean gG() {
        if (!this.gm()) {
            return false;
        }
        if (this.l(this.cQ)) {
            return false;
        }
        TileEntity tileentity = this.dO().c_(this.cQ);
        return tileentity != null && tileentity.r() == TileEntityTypes.H;
    }

    public boolean gu() {
        return this.u(8);
    }

    public void x(boolean flag) {
        if (flag) {
            this.gl();
        }
        this.d(8, flag);
    }

    public boolean gv() {
        return this.u(4);
    }

    public void y(boolean flag) {
        this.d(4, flag);
    }

    private boolean gH() {
        return this.u(2);
    }

    private void z(boolean flag) {
        this.d(2, flag);
    }

    boolean l(BlockPosition blockposition) {
        return !this.b(blockposition, 32);
    }

    private void d(int i2, boolean flag) {
        if (flag) {
            this.ao.a(cm, (byte)(this.ao.a(cm) | i2));
        } else {
            this.ao.a(cm, (byte)(this.ao.a(cm) & ~i2));
        }
    }

    private boolean u(int i2) {
        return (this.ao.a(cm) & i2) != 0;
    }

    public static AttributeProvider.Builder gw() {
        return EntityInsentient.C().a(GenericAttributes.s, 10.0).a(GenericAttributes.l, 0.6f).a(GenericAttributes.v, 0.3f).a(GenericAttributes.c, 2.0).a(GenericAttributes.m, 48.0);
    }

    @Override
    protected NavigationAbstract b(World world) {
        NavigationFlying navigationflying = new NavigationFlying(this, world){

            @Override
            public boolean a(BlockPosition blockposition) {
                return !this.b.a_(blockposition.e()).i();
            }

            @Override
            public void c() {
                if (!EntityBee.this.cR.l()) {
                    super.c();
                }
            }
        };
        navigationflying.b(false);
        navigationflying.a(false);
        navigationflying.c(true);
        return navigationflying;
    }

    @Override
    public boolean o(ItemStack itemstack) {
        return itemstack.a(TagsItem.aj);
    }

    boolean m(BlockPosition blockposition) {
        return this.dO().p(blockposition) && this.dO().a_(blockposition).a(TagsBlock.V);
    }

    @Override
    protected void b(BlockPosition blockposition, IBlockData iblockdata) {
    }

    @Override
    protected SoundEffect v() {
        return null;
    }

    @Override
    protected SoundEffect d(DamageSource damagesource) {
        return SoundEffects.bP;
    }

    @Override
    protected SoundEffect n_() {
        return SoundEffects.bO;
    }

    @Override
    protected float fa() {
        return 0.4f;
    }

    @Nullable
    public EntityBee b(WorldServer worldserver, EntityAgeable entityageable) {
        return EntityTypes.h.a(worldserver);
    }

    @Override
    protected void a(double d0, boolean flag, IBlockData iblockdata, BlockPosition blockposition) {
    }

    @Override
    public boolean aW() {
        return this.gx() && this.ai % cd == 0;
    }

    @Override
    public boolean gx() {
        return !this.aF();
    }

    public void gy() {
        this.x(false);
        this.gE();
    }

    @Override
    public boolean a(DamageSource damagesource, float f2) {
        if (this.b(damagesource)) {
            return false;
        }
        boolean result = super.a(damagesource, f2);
        if (result && !this.dO().B) {
            this.cR.m();
        }
        return result;
    }

    @Override
    protected void c(TagKey<FluidType> tagkey) {
        this.i(this.dr().b(0.0, 0.01, 0.0));
    }

    @Override
    public Vec3D cM() {
        return new Vec3D(0.0, 0.5f * this.cL(), this.dj() * 0.2f);
    }

    boolean b(BlockPosition blockposition, int i2) {
        return blockposition.a(this.do(), (double)i2);
    }

    public void i(BlockPosition blockposition) {
        this.cQ = blockposition;
    }

    private class j
    extends ControllerLook {
        j(EntityInsentient entityinsentient) {
            super(entityinsentient);
        }

        @Override
        public void a() {
            if (!EntityBee.this.ad_()) {
                super.a();
            }
        }

        @Override
        protected boolean c() {
            return !EntityBee.this.cR.l();
        }
    }

    private class b
    extends PathfinderGoalMeleeAttack {
        b(EntityCreature entitycreature, double d0, boolean flag) {
            super(entitycreature, d0, flag);
        }

        @Override
        public boolean b() {
            return super.b() && EntityBee.this.ad_() && !EntityBee.this.gv();
        }

        @Override
        public boolean c() {
            return super.c() && EntityBee.this.ad_() && !EntityBee.this.gv();
        }
    }

    private class d
    extends a {
        d() {
        }

        @Override
        public boolean h() {
            TileEntity tileentity;
            if (EntityBee.this.gm() && EntityBee.this.gA() && EntityBee.this.cQ.a(EntityBee.this.dm(), 2.0) && (tileentity = EntityBee.this.dO().c_(EntityBee.this.cQ)) instanceof TileEntityBeehive) {
                TileEntityBeehive tileentitybeehive = (TileEntityBeehive)tileentity;
                if (!tileentitybeehive.d()) {
                    return true;
                }
                EntityBee.this.cQ = null;
            }
            return false;
        }

        @Override
        public boolean i() {
            return false;
        }

        @Override
        public void d() {
            TileEntity tileentity = EntityBee.this.dO().c_(EntityBee.this.cQ);
            if (tileentity instanceof TileEntityBeehive) {
                TileEntityBeehive tileentitybeehive = (TileEntityBeehive)tileentity;
                tileentitybeehive.a(EntityBee.this);
            }
        }
    }

    private class k
    extends a {
        private static final int c = 400;
        private static final int d = 20;
        private static final int e = 60;
        private final Predicate<IBlockData> f;
        private static final double g = 0.1;
        private static final int h = 25;
        private static final float i = 0.35f;
        private static final float j = 0.6f;
        private static final float k = 0.33333334f;
        private int l;
        private int m;
        private boolean n;
        @Nullable
        private Vec3D o;
        private int p;
        private static final int q = 600;

        k() {
            this.f = iblockdata -> iblockdata.b(BlockProperties.C) && iblockdata.c(BlockProperties.C).booleanValue() ? false : (iblockdata.a(TagsBlock.V) ? (iblockdata.a(Blocks.iD) ? iblockdata.c(BlockTallPlant.b) == BlockPropertyDoubleBlockHalf.a : true) : false);
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean h() {
            if (EntityBee.this.cO > 0) {
                return false;
            }
            if (EntityBee.this.gu()) {
                return false;
            }
            if (EntityBee.this.dO().ad()) {
                return false;
            }
            Optional<BlockPosition> optional = this.p();
            if (optional.isPresent()) {
                EntityBee.this.cP = optional.get();
                EntityBee.this.bV.a((double)EntityBee.this.cP.u() + 0.5, (double)EntityBee.this.cP.v() + 0.5, (double)EntityBee.this.cP.w() + 0.5, 1.2f);
                return true;
            }
            EntityBee.this.cO = MathHelper.a(EntityBee.this.ah, 20, 60);
            return false;
        }

        @Override
        public boolean i() {
            if (!this.n) {
                return false;
            }
            if (!EntityBee.this.t()) {
                return false;
            }
            if (EntityBee.this.dO().ad()) {
                return false;
            }
            if (this.k()) {
                return EntityBee.this.ah.i() < 0.2f;
            }
            if (EntityBee.this.ai % 20 == 0 && !EntityBee.this.m(EntityBee.this.cP)) {
                EntityBee.this.cP = null;
                return false;
            }
            return true;
        }

        private boolean k() {
            return this.l > 400;
        }

        boolean l() {
            return this.n;
        }

        void m() {
            this.n = false;
        }

        @Override
        public void d() {
            this.l = 0;
            this.p = 0;
            this.m = 0;
            this.n = true;
            EntityBee.this.gl();
        }

        @Override
        public void e() {
            if (this.k()) {
                EntityBee.this.x(true);
            }
            this.n = false;
            EntityBee.this.bV.n();
            EntityBee.this.cO = 200;
        }

        @Override
        public boolean V_() {
            return true;
        }

        @Override
        public void a() {
            ++this.p;
            if (this.p > 600) {
                EntityBee.this.cP = null;
            } else {
                Vec3D vec3d = Vec3D.c(EntityBee.this.cP).b(0.0, 0.6f, 0.0);
                if (vec3d.f(EntityBee.this.dm()) > 1.0) {
                    this.o = vec3d;
                    this.n();
                } else {
                    if (this.o == null) {
                        this.o = vec3d;
                    }
                    boolean flag = EntityBee.this.dm().f(this.o) <= 0.1;
                    boolean flag1 = true;
                    if (!flag && this.p > 600) {
                        EntityBee.this.cP = null;
                    } else {
                        if (flag) {
                            boolean flag2;
                            boolean bl = flag2 = EntityBee.this.ah.a(25) == 0;
                            if (flag2) {
                                this.o = new Vec3D(vec3d.a() + (double)this.o(), vec3d.b(), vec3d.c() + (double)this.o());
                                EntityBee.this.bV.n();
                            } else {
                                flag1 = false;
                            }
                            EntityBee.this.I().a(vec3d.a(), vec3d.b(), vec3d.c());
                        }
                        if (flag1) {
                            this.n();
                        }
                        ++this.l;
                        if (EntityBee.this.ah.i() < 0.05f && this.l > this.m + 60) {
                            this.m = this.l;
                            EntityBee.this.a(SoundEffects.bT, 1.0f, 1.0f);
                        }
                    }
                }
            }
        }

        private void n() {
            EntityBee.this.J().a(this.o.a(), this.o.b(), this.o.c(), 0.35f);
        }

        private float o() {
            return (EntityBee.this.ah.i() * 2.0f - 1.0f) * 0.33333334f;
        }

        private Optional<BlockPosition> p() {
            return this.a(this.f, 5.0);
        }

        private Optional<BlockPosition> a(Predicate<IBlockData> predicate, double d0) {
            BlockPosition blockposition = EntityBee.this.do();
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
            int i2 = 0;
            while ((double)i2 <= d0) {
                int j2 = 0;
                while ((double)j2 < d0) {
                    int k2 = 0;
                    while (k2 <= j2) {
                        int l2;
                        int n2 = l2 = k2 < j2 && k2 > -j2 ? j2 : 0;
                        while (l2 <= j2) {
                            blockposition_mutableblockposition.a(blockposition, k2, i2 - 1, l2);
                            if (blockposition.a(blockposition_mutableblockposition, d0) && predicate.test(EntityBee.this.dO().a_(blockposition_mutableblockposition))) {
                                return Optional.of(blockposition_mutableblockposition);
                            }
                            l2 = l2 > 0 ? -l2 : 1 - l2;
                        }
                        k2 = k2 > 0 ? -k2 : 1 - k2;
                    }
                    ++j2;
                }
                i2 = i2 > 0 ? -i2 : 1 - i2;
            }
            return Optional.empty();
        }
    }

    private class i
    extends a {
        i() {
        }

        @Override
        public boolean h() {
            return EntityBee.this.cM == 0 && !EntityBee.this.gm() && EntityBee.this.gA();
        }

        @Override
        public boolean i() {
            return false;
        }

        @Override
        public void d() {
            EntityBee.this.cM = 200;
            List<BlockPosition> list = this.k();
            if (!list.isEmpty()) {
                BlockPosition blockposition;
                Iterator<BlockPosition> iterator = list.iterator();
                do {
                    if (iterator.hasNext()) continue;
                    EntityBee.this.cS.k();
                    EntityBee.this.cQ = list.get(0);
                    return;
                } while (EntityBee.this.cS.b(blockposition = iterator.next()));
                EntityBee.this.cQ = blockposition;
            }
        }

        private List<BlockPosition> k() {
            BlockPosition blockposition = EntityBee.this.do();
            VillagePlace villageplace = ((WorldServer)EntityBee.this.dO()).y();
            Stream<VillagePlaceRecord> stream = villageplace.c(holder -> holder.a(PoiTypeTags.c), blockposition, 20, VillagePlace.Occupancy.c);
            return stream.map(VillagePlaceRecord::f).filter(EntityBee.this::k).sorted(Comparator.comparingDouble(blockposition1 -> blockposition1.j(blockposition))).collect(Collectors.toList());
        }
    }

    @VisibleForDebug
    public class e
    extends a {
        public static final int b = 600;
        int d;
        private static final int e = 3;
        final List<BlockPosition> f;
        @Nullable
        private PathEntity g;
        private static final int h = 60;
        private int i;

        e() {
            this.d = EntityBee.this.ah.a(10);
            this.f = Lists.newArrayList();
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean h() {
            return EntityBee.this.cQ != null && !EntityBee.this.fY() && EntityBee.this.gA() && !this.d(EntityBee.this.cQ) && EntityBee.this.dO().a_(EntityBee.this.cQ).a(TagsBlock.aH);
        }

        @Override
        public boolean i() {
            return this.h();
        }

        @Override
        public void d() {
            this.d = 0;
            this.i = 0;
            super.d();
        }

        @Override
        public void e() {
            this.d = 0;
            this.i = 0;
            EntityBee.this.bV.n();
            EntityBee.this.bV.g();
        }

        @Override
        public void a() {
            if (EntityBee.this.cQ != null) {
                ++this.d;
                if (this.d > this.a(600)) {
                    this.l();
                } else if (!EntityBee.this.bV.m()) {
                    if (!EntityBee.this.b(EntityBee.this.cQ, 16)) {
                        if (EntityBee.this.l(EntityBee.this.cQ)) {
                            this.m();
                        } else {
                            EntityBee.this.j(EntityBee.this.cQ);
                        }
                    } else {
                        boolean flag = this.a(EntityBee.this.cQ);
                        if (!flag) {
                            this.l();
                        } else if (this.g != null && EntityBee.this.bV.j().a(this.g)) {
                            ++this.i;
                            if (this.i > 60) {
                                this.m();
                                this.i = 0;
                            }
                        } else {
                            this.g = EntityBee.this.bV.j();
                        }
                    }
                }
            }
        }

        private boolean a(BlockPosition blockposition) {
            EntityBee.this.bV.a(10.0f);
            EntityBee.this.bV.a(blockposition.u(), (double)blockposition.v(), blockposition.w(), 2, 1.0);
            return EntityBee.this.bV.j() != null && EntityBee.this.bV.j().j();
        }

        boolean b(BlockPosition blockposition) {
            return this.f.contains(blockposition);
        }

        private void c(BlockPosition blockposition) {
            this.f.add(blockposition);
            while (this.f.size() > 3) {
                this.f.remove(0);
            }
        }

        void k() {
            this.f.clear();
        }

        private void l() {
            if (EntityBee.this.cQ != null) {
                this.c(EntityBee.this.cQ);
            }
            this.m();
        }

        private void m() {
            EntityBee.this.cQ = null;
            EntityBee.this.cM = 200;
        }

        private boolean d(BlockPosition blockposition) {
            if (EntityBee.this.b(blockposition, 2)) {
                return true;
            }
            PathEntity pathentity = EntityBee.this.bV.j();
            return pathentity != null && pathentity.l().equals(blockposition) && pathentity.j() && pathentity.c();
        }
    }

    public class f
    extends a {
        private static final int c = 600;
        int d;

        f() {
            this.d = EntityBee.this.ah.a(10);
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean h() {
            return EntityBee.this.cP != null && !EntityBee.this.fY() && this.k() && EntityBee.this.m(EntityBee.this.cP) && !EntityBee.this.b(EntityBee.this.cP, 2);
        }

        @Override
        public boolean i() {
            return this.h();
        }

        @Override
        public void d() {
            this.d = 0;
            super.d();
        }

        @Override
        public void e() {
            this.d = 0;
            EntityBee.this.bV.n();
            EntityBee.this.bV.g();
        }

        @Override
        public void a() {
            if (EntityBee.this.cP != null) {
                ++this.d;
                if (this.d > this.a(600)) {
                    EntityBee.this.cP = null;
                } else if (!EntityBee.this.bV.m()) {
                    if (EntityBee.this.l(EntityBee.this.cP)) {
                        EntityBee.this.cP = null;
                    } else {
                        EntityBee.this.j(EntityBee.this.cP);
                    }
                }
            }
        }

        private boolean k() {
            return EntityBee.this.cI > 2400;
        }
    }

    private class g
    extends a {
        static final int b = 30;

        g() {
        }

        @Override
        public boolean h() {
            return EntityBee.this.gD() >= 10 ? false : (EntityBee.this.ah.i() < 0.3f ? false : EntityBee.this.gu() && EntityBee.this.gG());
        }

        @Override
        public boolean i() {
            return this.h();
        }

        @Override
        public void a() {
            if (EntityBee.this.ah.a(this.a(30)) == 0) {
                for (int i2 = 1; i2 <= 2; ++i2) {
                    BlockPosition blockposition = EntityBee.this.do().c(i2);
                    IBlockData iblockdata = EntityBee.this.dO().a_(blockposition);
                    Block block = iblockdata.b();
                    IBlockData iblockdata1 = null;
                    if (!iblockdata.a(TagsBlock.aJ)) continue;
                    if (block instanceof BlockCrops) {
                        BlockCrops blockcrops = (BlockCrops)block;
                        if (!blockcrops.h(iblockdata)) {
                            iblockdata1 = blockcrops.b(blockcrops.g(iblockdata) + 1);
                        }
                    } else if (block instanceof BlockStem) {
                        int j2 = iblockdata.c(BlockStem.c);
                        if (j2 < 7) {
                            iblockdata1 = (IBlockData)iblockdata.a(BlockStem.c, j2 + 1);
                        }
                    } else if (iblockdata.a(Blocks.oi)) {
                        int j3 = iblockdata.c(BlockSweetBerryBush.c);
                        if (j3 < 3) {
                            iblockdata1 = (IBlockData)iblockdata.a(BlockSweetBerryBush.c, j3 + 1);
                        }
                    } else if (iblockdata.a(Blocks.sv) || iblockdata.a(Blocks.sw)) {
                        ((IBlockFragilePlantElement)((Object)iblockdata.b())).a((WorldServer)EntityBee.this.dO(), EntityBee.this.ah, blockposition, iblockdata);
                    }
                    if (iblockdata1 == null || !CraftEventFactory.callEntityChangeBlockEvent(EntityBee.this, blockposition, iblockdata1)) continue;
                    EntityBee.this.dO().c(2011, blockposition, 15);
                    EntityBee.this.dO().b(blockposition, iblockdata1);
                    EntityBee.this.gF();
                }
            }
        }
    }

    private class l
    extends PathfinderGoal {
        private static final int b = 22;

        l() {
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean b() {
            return EntityBee.this.bV.l() && EntityBee.this.ah.a(10) == 0;
        }

        @Override
        public boolean c() {
            return EntityBee.this.bV.m();
        }

        @Override
        public void d() {
            Vec3D vec3d = this.h();
            if (vec3d != null) {
                EntityBee.this.bV.a(EntityBee.this.bV.a(BlockPosition.a(vec3d), 1), 1.0);
            }
        }

        @Nullable
        private Vec3D h() {
            Vec3D vec3d;
            if (EntityBee.this.gG() && !EntityBee.this.b(EntityBee.this.cQ, 22)) {
                Vec3D vec3d1 = Vec3D.b(EntityBee.this.cQ);
                vec3d = vec3d1.d(EntityBee.this.dm()).d();
            } else {
                vec3d = EntityBee.this.g(0.0f);
            }
            boolean flag = true;
            Vec3D vec3d2 = HoverRandomPos.a(EntityBee.this, 8, 7, vec3d.c, vec3d.e, 1.5707964f, 3, 1);
            return vec3d2 != null ? vec3d2 : AirAndWaterRandomPos.a(EntityBee.this, 8, 4, -2, vec3d.c, vec3d.e, 1.5707963705062866);
        }
    }

    private class h
    extends PathfinderGoalHurtByTarget {
        h(EntityBee entitybee) {
            super(entitybee, new Class[0]);
        }

        @Override
        public boolean c() {
            return EntityBee.this.ad_() && super.c();
        }

        @Override
        protected void a(EntityInsentient entityinsentient, EntityLiving entityliving) {
            if (entityinsentient instanceof EntityBee && this.e.F(entityliving)) {
                entityinsentient.setTarget(entityliving, EntityTargetEvent.TargetReason.TARGET_ATTACKED_ENTITY, true);
            }
        }
    }

    private static class c
    extends PathfinderGoalNearestAttackableTarget<EntityHuman> {
        c(EntityBee entitybee) {
            super(entitybee, EntityHuman.class, 10, true, false, entitybee::a_);
        }

        @Override
        public boolean b() {
            return this.i() && super.b();
        }

        @Override
        public boolean c() {
            boolean flag = this.i();
            if (flag && this.e.p() != null) {
                return super.c();
            }
            this.g = null;
            return false;
        }

        private boolean i() {
            EntityBee entitybee = (EntityBee)this.e;
            return entitybee.ad_() && !entitybee.gv();
        }
    }

    private abstract class a
    extends PathfinderGoal {
        a() {
        }

        public abstract boolean h();

        public abstract boolean i();

        @Override
        public boolean b() {
            return this.h() && !EntityBee.this.ad_();
        }

        @Override
        public boolean c() {
            return this.i() && !EntityBee.this.ad_();
        }
    }
}

