/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemLiquidUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.event.player.PlayerBucketFillEvent;

public class EntityCow
extends EntityAnimal {
    private static final EntitySize cc = EntityTypes.w.n().a(0.5f).b(0.665f);

    public EntityCow(EntityTypes<? extends EntityCow> entitytypes, World world) {
        super((EntityTypes<? extends EntityAnimal>)entitytypes, world);
    }

    @Override
    protected void B() {
        this.bW.a(0, new PathfinderGoalFloat(this));
        this.bW.a(1, new PathfinderGoalPanic(this, 2.0));
        this.bW.a(2, new PathfinderGoalBreed(this, 1.0));
        this.bW.a(3, new PathfinderGoalTempt(this, 1.25, itemstack -> itemstack.a(TagsItem.aa), false));
        this.bW.a(4, new PathfinderGoalFollowParent(this, 1.25));
        this.bW.a(5, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.bW.a(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.bW.a(7, new PathfinderGoalRandomLookaround(this));
    }

    @Override
    public boolean o(ItemStack itemstack) {
        return itemstack.a(TagsItem.aa);
    }

    public static AttributeProvider.Builder s() {
        return EntityInsentient.C().a(GenericAttributes.s, 10.0).a(GenericAttributes.v, 0.2f);
    }

    @Override
    protected SoundEffect v() {
        return SoundEffects.gb;
    }

    @Override
    protected SoundEffect d(DamageSource damagesource) {
        return SoundEffects.gd;
    }

    @Override
    protected SoundEffect n_() {
        return SoundEffects.gc;
    }

    @Override
    protected void b(BlockPosition blockposition, IBlockData iblockdata) {
        this.a(SoundEffects.gf, 0.15f, 1.0f);
    }

    @Override
    protected float fa() {
        return 0.4f;
    }

    @Override
    public EnumInteractionResult b(EntityHuman entityhuman, EnumHand enumhand) {
        ItemStack itemstack = entityhuman.b(enumhand);
        if (itemstack.a(Items.qy) && !this.o_()) {
            PlayerBucketFillEvent event = CraftEventFactory.callPlayerBucketFillEvent((WorldServer)entityhuman.dO(), entityhuman, this.do(), this.do(), null, itemstack, Items.qE, enumhand);
            if (event.isCancelled()) {
                return EnumInteractionResult.e;
            }
            entityhuman.a(SoundEffects.ge, 1.0f, 1.0f);
            ItemStack itemstack1 = ItemLiquidUtil.a(itemstack, entityhuman, CraftItemStack.asNMSCopy(event.getItemStack()));
            entityhuman.a(enumhand, itemstack1);
            return EnumInteractionResult.a(this.dO().B);
        }
        return super.b(entityhuman, enumhand);
    }

    @Nullable
    public EntityCow b(WorldServer worldserver, EntityAgeable entityageable) {
        return EntityTypes.w.a(worldserver);
    }

    @Override
    public EntitySize e(EntityPose entitypose) {
        return this.o_() ? cc : super.e(entitypose);
    }
}

